/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.mm.basedata.BOMSearchFacadeFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMCollection;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMFactory;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMInfo;
import com.kingdee.eas.ncm.std.cal.STDCostCalcParam;
import java.util.Iterator;

public class BOMDataCache {
    private Context ctx;
    private STDCostCalcParam calcParam;

    public BOMDataCache(Context ctx, STDCostCalcParam calcParam) {
        this.ctx = ctx;
        this.calcParam = calcParam;
    }

    public String getBomDataTable() throws BOSException {
        String bomtable = this.getBomDataTbl();
        String companyID = this.calcParam.getCompanyId();
        String schemeID = this.calcParam.getEstimateSchemeId();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EStimateScheme.id", (Object)schemeID, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bom.id"));
        view.setSelector(selector);
        view.setFilter(filter);
        STDCostMaterialBOMCollection coll = STDCostMaterialBOMFactory.getLocalInstance(this.ctx).getSTDCostMaterialBOMCollection(view);
        if (coll != null && coll.size() > 0) {
            String bomtempTbl;
            Iterator itr = coll.iterator();
            String[] bomIDs = new String[300];
            int i = 1;
            while (itr.hasNext()) {
                BomInfo bomInfo;
                if (i % 300 > 0 && (bomInfo = ((STDCostMaterialBOMInfo)itr.next()).getBOM()) != null) {
                    bomIDs[i - 1] = bomInfo.getId().toString();
                }
                if (i % 300 == 0) {
                    bomtempTbl = BOMSearchFacadeFactory.getLocalInstance((Context)this.ctx).getSearchBOM(companyID, bomIDs);
                    this.insertTempData(bomtable, bomtempTbl);
                    bomIDs = new String[300];
                    i = 1;
                    continue;
                }
                ++i;
            }
            bomtempTbl = BOMSearchFacadeFactory.getLocalInstance((Context)this.ctx).getSearchBOM(companyID, bomIDs);
            this.insertTempData(bomtable, bomtempTbl);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("Insert Into ").append(bomtable).append(" (\n");
        insertSql.append("FLevel,FTraceID,FSTORAGEORGUNITID,FBOMID,FBomType, \n");
        insertSql.append("FParentMaterialID,FParentUnitID,FMaterialID,FUnitID,FCHILDSTORAGEORGUNITID, \n");
        insertSql.append("FConsumeFixQty,FEffectiveDate,FDisableDate,FBOMChildID,FConsumeType,\n");
        insertSql.append("FMaterialAttr,FBaseStatus,FIsTempData)\n");
        insertSql.append("Select 0,FTraceID,FSTORAGEORGUNITID,FBOMID,FBomType,\n");
        insertSql.append("FParentMaterialID,FParentUnitID,FMaterialID,FUnitID,FCHILDSTORAGEORGUNITID, \n");
        insertSql.append("sum(FConsumeFixQty),min(FEffectiveDate),max(FDisableDate),min(FBOMChildID),FConsumeType,\n");
        insertSql.append("FMaterialAttr,FBaseStatus,0 \n");
        insertSql.append("From ").append(bomtable).append(" \n");
        insertSql.append("where FIsTempData = 1 \n");
        insertSql.append("group by FTraceID,FSTORAGEORGUNITID,FBOMID,FBomType,\n");
        insertSql.append("FParentMaterialID,FParentUnitID,FMaterialID,FUnitID,FCHILDSTORAGEORGUNITID, \n");
        insertSql.append("FConsumeType,FMaterialAttr,FBaseStatus \n");
        NCMDbUtil.execute((Context)this.ctx, (String)insertSql.toString());
        insertSql.setLength(0);
        insertSql.append("delete From ").append(bomtable).append(" where FIsTempData = 1;\n");
        NCMDbUtil.execute((Context)this.ctx, (String)insertSql.toString());
        insertSql.setLength(0);
        return bomtable;
    }

    private void insertTempData(String bomDataTbl, String bomDataSrcTbl) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("Insert Into ").append(bomDataTbl).append(" (\n");
        insertSql.append("FLevel,FTraceID,FSTORAGEORGUNITID,FBOMID,FBomType, \n");
        insertSql.append("FParentMaterialID,FParentUnitID,FMaterialID,FUnitID,FCHILDSTORAGEORGUNITID, \n");
        insertSql.append("FConsumeFixQty,FEffectiveDate,FDisableDate,FBOMChildID,FConsumeType,\n");
        insertSql.append("FMaterialAttr,FBaseStatus,FIsTempData)\n");
        insertSql.append("Select FLevel,FTraceID,FSTORAGEORGUNITID,FBOMID,FBomType,\n");
        insertSql.append("FParentMaterialID,FParentUnitID,FMaterialID,FUnitID,FCHILDSTORAGEORGUNITID, \n");
        insertSql.append("FConsumeFixQty,FEffectiveDate,FDisableDate,FBOMChildID,FConsumeType,\n");
        insertSql.append("FMaterialAttr,FBaseStatus,1 \n");
        insertSql.append("From ").append(bomDataSrcTbl);
        NCMDbUtil.execute((Context)this.ctx, (String)insertSql.toString());
        insertSql.setLength(0);
    }

    private String getBomDataTbl() throws BOSException {
        String createTableSQL = " CREATE TABLE t1 ( FLevel int , FTraceID varchar(44), FSTORAGEORGUNITID varchar(44),  FBOMID varchar(44), FBomType int, FParentMaterialID varchar(44), FParentUnitID varchar(44),  FMaterialID varchar(44), FUnitID varchar(44), FCHILDSTORAGEORGUNITID varchar(44),  FConsumeFixQty NUMERIC(21,8),  FEffectiveDate DATETIME, FDisableDate DATETIME, FBOMChildID varchar(44), FConsumeType int, FMaterialAttr int,  FIsTempData int,  FBaseStatus varchar(44) )";
        String tableName = NCMDbUtil.createTempTable((Context)this.ctx, (String)createTableSQL);
        return tableName;
    }
}

