/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.std.cal.STDCostCalcParam;
import com.kingdee.eas.ncm.std.cal.STDCostCalcResult;
import com.kingdee.eas.ncm.std.cal.task.app.MatBOMRollUpCalculator;
import com.kingdee.eas.ncm.std.cal.task.app.ServerCalcTask;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MatBOMRollUpCalcTask
extends ServerCalcTask {
    private static Logger logger = Logger.getLogger((String)MatBOMRollUpCalcTask.class.getName());
    String T_NCM_STDCostBomPath = null;
    private String T_NCM_STDCostDataMatDetail = null;
    private String T_NCM_STDCostDataResDetail = null;
    private String T_NCM_STDCostRollUpMat = null;
    private String T_NCM_STDCostRollUpRes = null;
    String T_TMP_Material = null;

    public MatBOMRollUpCalcTask(Context ctx) {
        super(ctx);
    }

    @Override
    public STDCostCalcResult execute(STDCostCalcParam calcParam, STDCostCalcResult calcResult) throws BOSException, EASBizException {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCompanyId() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getEstimateSchemeId() != null ? 1 : 0) != 0);
        Assert.that((calcResult != null ? 1 : 0) != 0);
        Assert.that((this.getContext() != null ? 1 : 0) != 0);
        try {
            this.initRollupTask(calcParam);
            this.buildRollupRange(calcParam);
            this.initRollupMat(calcParam);
            this.initRollupRes(calcParam);
            this.rollup(calcParam, calcResult);
            this.updateRollupResult(calcParam);
            this.saveRollupResult(calcParam);
            this.writeBackPrice(calcParam);
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            try {
                if (this.T_TMP_Material != null) {
                    TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.T_TMP_Material);
                }
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
            }
        }
        return calcResult;
    }

    private void initRollupTask(STDCostCalcParam calcParam) throws EASBizException, BOSException, SQLException {
        Context ctx = this.getContext();
        String companyId = calcParam.getCompanyId();
        this.T_NCM_STDCostBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostBomPath");
        this.T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostDataMatDetail");
        this.T_NCM_STDCostRollUpMat = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostRollUpMat");
        this.T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostDataResDetail");
        this.T_NCM_STDCostRollUpRes = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostRollUpRes");
        StringBuffer ksql = new StringBuffer();
        String dbTypeName = (String)ctx.get((Object)"dbType");
        int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
        if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
            ksql.setLength(0);
            ksql.append("/*dialect*/").append(" \n");
            ksql.append("alter session enable parallel dml \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("/*dialect*/").append(" \n");
            ksql.append("alter table " + this.T_NCM_STDCostDataMatDetail + " nologging \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("/*dialect*/").append(" \n");
            ksql.append("alter table " + this.T_NCM_STDCostDataResDetail + " nologging \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("/*dialect*/").append(" \n");
            ksql.append("alter table " + this.T_NCM_STDCostRollUpRes + " nologging \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRollupRange(STDCostCalcParam calcParam) throws Exception {
        String[] materialIds = calcParam.getMaterialIds();
        if (materialIds == null || materialIds.length == 0) {
            return;
        }
        Context ctx = this.getContext();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("create table T ( \n");
            sql.append("\t  FMaterialID varchar(44) \n");
            sql.append(") \n");
            this.T_TMP_Material = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + this.T_TMP_Material + " ( \n");
            sql.append("    FMaterialID \n");
            sql.append(") \n");
            sql.append("select distinct \n");
            sql.append("    FParentMaterialID \n");
            sql.append("from " + this.T_NCM_STDCostBomPath + " \n");
            sql.append("union \n");
            sql.append("select distinct \n");
            sql.append("    FMaterialID \n");
            sql.append("from " + this.T_NCM_STDCostBomPath + " \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            conn = EJBFactory.getConnection((Context)ctx);
            sql.setLength(0);
            sql.append("insert into " + this.T_TMP_Material + " ( \n");
            sql.append("    FMaterialID \n");
            sql.append(") \n");
            sql.append("select ? \n");
            sql.append("     \n");
            sql.append("where not exists ( \n");
            sql.append("    select 1 from " + this.T_TMP_Material + " t where t.FMaterialID = ? \n");
            sql.append(") \n");
            ps = conn.prepareStatement(sql.toString());
            for (int i = 0; i < materialIds.length; ++i) {
                ps.setString(1, materialIds[i]);
                ps.setString(2, materialIds[i]);
                ps.addBatch();
            }
            ps.executeBatch();
            TempTablePool.getInstance((Context)this.getContext()).createIndex(this.T_TMP_Material, "FMaterialID", false, false);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, ps, conn);
            throw throwable;
        }
        SQLUtils.cleanup(rst, (Statement)ps, (Connection)conn);
    }

    private void initRollupMat(STDCostCalcParam calcParam) throws BOSException {
        Context ctx = this.getContext();
        StringBuffer kSql = new StringBuffer();
        boolean isOnlyForOnStdCost = calcParam.isOnlyForOnStdCost();
        kSql.setLength(0);
        kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
        kSql.append(" SET    FChildStdPrice = (SELECT ISNULL(manualMat.FSTDPrice,0) \n");
        kSql.append("                            FROM " + this.T_NCM_STDCostRollUpMat + " manualMat \n");
        kSql.append("                           WHERE manualMat.FEstimateType = 1 \n");
        kSql.append("                                 AND manualMat.FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID) \n");
        kSql.append(" WHERE  EXISTS (SELECT 1 \n");
        kSql.append("                  FROM " + this.T_NCM_STDCostRollUpMat + " manualMat\n");
        kSql.append("                 WHERE manualMat.FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID \n");
        kSql.append("                       AND manualMat.FEstimateType = 1) \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        if (isOnlyForOnStdCost) {
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append(" SET    FChildStdPrice = (SELECT costData.FStdAmount \n");
            kSql.append("                            FROM T_NCM_StdCostData costData \n");
            kSql.append("                           WHERE costData.FEstimateSchemeID = " + this.T_NCM_STDCostRollUpMat + ".FEstimateSchemeID \n");
            kSql.append("                                 AND costData.FMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID \n");
            kSql.append("                                 AND costData.FDataType = 2 \n");
            kSql.append("                                 AND costData.FStdAmount IS NOT NULL ) \n");
            kSql.append(" WHERE  EXISTS (SELECT 1 \n");
            kSql.append("                  FROM T_NCM_StdCostData costData\n");
            kSql.append("                 WHERE costData.FEstimateSchemeID = " + this.T_NCM_STDCostRollUpMat + ".FEstimateSchemeID \n");
            kSql.append("                   AND costData.FMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID \n");
            kSql.append("                   AND costData.FDataType = 2 \n");
            kSql.append("                   AND costData.FStdAmount IS NOT NULL ) \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRollupRes(STDCostCalcParam calcParam) throws Exception {
        StringBuffer kSql = new StringBuffer();
        Context ctx = this.getContext();
        String T_TMP_ResStdPrice = null;
        try {
            NCMDbUtil.execute((Context)ctx, (String)(" truncate table " + this.T_NCM_STDCostRollUpRes));
            NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostRollUpRes");
            String dbTypeName = (String)ctx.get((Object)"dbType");
            int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
            if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
                this.initRollupResOnOracle(calcParam);
            } else {
                this.initRollupResOnKSQL(calcParam);
            }
            kSql.setLength(0);
            kSql.append("UPDATE " + this.T_NCM_STDCostRollUpRes + " \n");
            kSql.append("set (FStdPrice, FResAmount) = ( \n");
            kSql.append("    select  \n");
            kSql.append("         ROUND( \n");
            kSql.append("             FStdPrice, isnull(ci.FPricePrecision, 2) \n");
            kSql.append("         ), \n");
            kSql.append("         ROUND( \n");
            kSql.append("             FResAmount, isnull(ci.FPricePrecision, 2) \n");
            kSql.append("         ) \n");
            kSql.append("    from T_NCM_CostItem ci \n");
            kSql.append("    where ci.FID = " + this.T_NCM_STDCostRollUpRes + ".FResCostItemID \n");
            kSql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append("create table T ( \n");
            kSql.append("\t  FParentMaterialID varchar(44), \n");
            kSql.append("\t  FStdPrice \t\tdecimal(24,12) \n");
            kSql.append(") \n");
            T_TMP_ResStdPrice = TempTablePool.getInstance((Context)ctx).createTempTable(kSql.toString());
            kSql.setLength(0);
            kSql.append("insert into " + T_TMP_ResStdPrice + " ( \n");
            kSql.append("    FParentMaterialID, FStdPrice \n");
            kSql.append(") \n");
            kSql.append("SELECT  FParentMaterialID, \n");
            kSql.append("    SUM(ISNULL(FResAmount,0)) AS FStdPrice \n");
            kSql.append("FROM " + this.T_NCM_STDCostRollUpRes + " \n");
            kSql.append("GROUP BY FParentMaterialID \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_ResStdPrice, "FParentMaterialID", false, false);
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpRes + " \n");
            kSql.append(" SET    FStdPrice = (SELECT TO_DECIMAL(FStdPrice,24,12) \n");
            kSql.append("                               FROM     " + T_TMP_ResStdPrice + " rp \n");
            kSql.append(" WHERE  rp.FParentMaterialID = " + this.T_NCM_STDCostRollUpRes + ".FParentMaterialID) \n");
            if (this.T_TMP_Material != null) {
                kSql.append(" WHERE exists ( \n");
                kSql.append("     select 1 from " + this.T_TMP_Material + " m \n");
                kSql.append("     where m.FMaterialID = " + this.T_NCM_STDCostRollUpRes + ".FParentMaterialID \n");
                kSql.append(" ) \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        }
        catch (Throwable throwable) {
            NCMDynamicTableManager.buildIndexsOfBusiTbl((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostRollUpRes");
            try {
                if (T_TMP_ResStdPrice != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_ResStdPrice);
                }
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
            }
            throw throwable;
        }
        NCMDynamicTableManager.buildIndexsOfBusiTbl((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostRollUpRes");
        try {
            if (T_TMP_ResStdPrice != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_ResStdPrice);
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
    }

    private void initRollupResOnOracle(STDCostCalcParam calcParam) throws BOSException {
        Context ctx = this.getContext();
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append("/*dialect*/").append(" \n");
        kSql.append("declare \n");
        kSql.append("    cursor cur is \n");
        kSql.append("    \n");
        kSql.append(" SELECT /*+ no_merge(S) use_hash(S) */ NEWBOSID('3718804A') AS FID, \n");
        kSql.append("        resQty.FMaterialID AS FParentMaterialID, \n");
        kSql.append("        NVL(resQty.FSTDQty,0)* \n");
        kSql.append("        (CASE \n");
        kSql.append("            WHEN NVL(matPrice.FSTDPrice, 0) > 0 THEN NVL(matPrice.FSTDPrice, 0)  \n");
        kSql.append("            ELSE NVL(resPrice.FSTDPrice,0) \n");
        kSql.append("        END) \n");
        kSql.append("        AS FStdPrice, \n");
        kSql.append("        resQty.FResourceTypeID AS FResourceTypeID, \n");
        kSql.append("        res.FMeasureUnitID AS FResMeasureUnitID, \n");
        kSql.append("        res.FCostItemID AS FResCostItemID, \n");
        kSql.append("        NVL(resQty.FSTDQty,0) AS FResQty, \n");
        kSql.append("        (CASE \n");
        kSql.append("            WHEN NVL(matPrice.FSTDPrice, 0) > 0 THEN NVL(matPrice.FSTDPrice, 0)  \n");
        kSql.append("            ELSE NVL(resPrice.FSTDPrice,0) \n");
        kSql.append("        END) \n");
        kSql.append("        AS FResStdPrice, \n");
        kSql.append("        NVL(resQty.FSTDQty,0)* \n");
        kSql.append("        (CASE \n");
        kSql.append("            WHEN NVL(matPrice.FSTDPrice, 0) > 0 THEN NVL(matPrice.FSTDPrice, 0)  \n");
        kSql.append("            ELSE NVL(resPrice.FSTDPrice,0) \n");
        kSql.append("        END) \n");
        kSql.append("        AS FResAmount \n");
        kSql.append(" FROM   T_NCM_STDCostResTypeQty resQty \n");
        if (this.T_TMP_Material != null) {
            kSql.append(" join   " + this.T_TMP_Material + " tm on tm.FMaterialID = resQty.FMaterialID \n");
        }
        kSql.append("        INNER JOIN T_NCM_SCResourceType res \n");
        kSql.append("          ON resQty.FResourceTypeID = res.FID \n");
        kSql.append("        LEFT OUTER JOIN T_NCM_STDCostResTypePrice resPrice \n");
        kSql.append("          ON resPrice.FResourceTypeID = resQty.FResourceTypeID \n");
        kSql.append("            AND resPrice.FEstimateSchemeID = '" + calcParam.getResStdPriceSchemeID() + "' \n");
        kSql.append("        LEFT OUTER JOIN T_NCM_STDCostResTypeMatPrice matPrice \n");
        kSql.append("          ON matPrice.FResourceTypeID = resQty.FResourceTypeID \n");
        kSql.append("            AND matPrice.FMaterialID = resQty.FMaterialID \n");
        kSql.append("            AND matPrice.FEstimateSchemeID = '" + calcParam.getResStdPriceSchemeID() + "' \n");
        kSql.append(" WHERE  resQty.FEstimateSchemeID = '" + calcParam.getResStdQtySchemeID() + "' \n");
        kSql.append("    ; \n");
        kSql.append("    \n");
        kSql.append("    type t_FID IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FID%TYPE; \n");
        kSql.append("    type t_FParentMaterialID IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FParentMaterialID%TYPE; \n");
        kSql.append("    type t_FStdPrice IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FStdPrice%TYPE; \n");
        kSql.append("    type t_FResourceTypeID IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FResourceTypeID%TYPE; \n");
        kSql.append("    type t_FResMeasureUnitID IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FResMeasureUnitID%TYPE; \n");
        kSql.append("    type t_FResCostItemID IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FResCostItemID%TYPE; \n");
        kSql.append("    type t_FResQty IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FResQty%TYPE; \n");
        kSql.append("    type t_FResStdPrice IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FResStdPrice%TYPE; \n");
        kSql.append("    type t_FResAmount IS TABLE OF " + this.T_NCM_STDCostRollUpRes + ".FResAmount%TYPE; \n");
        kSql.append("    \n");
        kSql.append("    v_FID t_FID; \n");
        kSql.append("    v_FParentMaterialID t_FParentMaterialID; \n");
        kSql.append("    v_FStdPrice t_FStdPrice; \n");
        kSql.append("    v_FResourceTypeID t_FResourceTypeID; \n");
        kSql.append("    v_FResMeasureUnitID t_FResMeasureUnitID; \n");
        kSql.append("    v_FResCostItemID t_FResCostItemID; \n");
        kSql.append("    v_FResQty t_FResQty; \n");
        kSql.append("    v_FResStdPrice t_FResStdPrice; \n");
        kSql.append("    v_FResAmount t_FResAmount; \n");
        kSql.append("    \n");
        kSql.append("begin \n");
        kSql.append("    \n");
        kSql.append("    open cur; \n");
        kSql.append("    loop \n");
        kSql.append("        FETCH cur BULK COLLECT INTO \n");
        kSql.append("            v_FID, \n");
        kSql.append("            v_FParentMaterialID, \n");
        kSql.append("            v_FStdPrice, \n");
        kSql.append("            v_FResourceTypeID, \n");
        kSql.append("            v_FResMeasureUnitID, \n");
        kSql.append("            v_FResCostItemID, \n");
        kSql.append("            v_FResQty, \n");
        kSql.append("            v_FResStdPrice, \n");
        kSql.append("            v_FResAmount \n");
        kSql.append("        LIMIT 1000; \n");
        kSql.append("        FORALL i IN 1 .. v_FID.COUNT \n");
        kSql.append("        INSERT /*+ append parallel(" + this.T_NCM_STDCostRollUpRes + ") */ INTO " + this.T_NCM_STDCostRollUpRes + " ( \n");
        kSql.append("             FID, \n");
        kSql.append("             FCompanyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FStorageOrgUnitID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FParentMaterialID, \n");
        kSql.append("             FParentCostObjectID, \n");
        kSql.append("             FStdPrice, \n");
        kSql.append("             FResourceTypeID, \n");
        kSql.append("             FResMeasureUnitID, \n");
        kSql.append("             FResCostItemID, \n");
        kSql.append("             FResQty, \n");
        kSql.append("             FResStdPrice, \n");
        kSql.append("             FResAmount \n");
        kSql.append("        ) \n");
        kSql.append("        values ( \n");
        kSql.append("            v_FID(i), \n");
        kSql.append("            '" + calcParam.getCompanyId() + "', \n");
        kSql.append("            null, \n");
        kSql.append("            '" + calcParam.getStorageOrgUnitID() + "', \n");
        kSql.append("            '" + calcParam.getEstimateSchemeId() + "', \n");
        kSql.append("            v_FParentMaterialID(i), \n");
        kSql.append("            null, \n");
        kSql.append("            v_FStdPrice(i), \n");
        kSql.append("            v_FResourceTypeID(i), \n");
        kSql.append("            v_FResMeasureUnitID(i), \n");
        kSql.append("            v_FResCostItemID(i), \n");
        kSql.append("            v_FResQty(i), \n");
        kSql.append("            v_FResStdPrice(i), \n");
        kSql.append("            v_FResAmount(i) \n");
        kSql.append("        ); \n");
        kSql.append("        \n");
        kSql.append("        commit; \n");
        kSql.append("        EXIT WHEN cur%NOTFOUND; \n");
        kSql.append("        \n");
        kSql.append("    end loop; \n");
        kSql.append("    close cur; \n");
        kSql.append("    commit; \n");
        kSql.append("    \n");
        kSql.append("end; \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    private void initRollupResOnKSQL(STDCostCalcParam calcParam) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        Context ctx = this.getContext();
        kSql.setLength(0);
        kSql.append(" INSERT INTO " + this.T_NCM_STDCostRollUpRes + " \n");
        kSql.append("            (FID, \n");
        kSql.append("             FCompanyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FStorageOrgUnitID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FParentMaterialID, \n");
        kSql.append("             FParentCostObjectID, \n");
        kSql.append("             FStdPrice, \n");
        kSql.append("             FResourceTypeID, \n");
        kSql.append("             FResMeasureUnitID, \n");
        kSql.append("             FResCostItemID, \n");
        kSql.append("             FResQty, \n");
        kSql.append("             FResStdPrice, \n");
        kSql.append("             FResAmount) \n");
        kSql.append(" SELECT NEWBOSID('3718804A') AS FID, \n");
        kSql.append("        '" + calcParam.getCompanyId() + "' AS FCompanyOrg, \n");
        kSql.append("        NULL AS FCalculatePeriod, \n");
        kSql.append("        '" + calcParam.getStorageOrgUnitID() + "' AS FStorageOrgUnitID, \n");
        kSql.append("        '" + calcParam.getEstimateSchemeId() + "' AS FEstimateSchemeID, \n");
        kSql.append("        resQty.FMaterialID AS FParentMaterialID, \n");
        kSql.append("        NULL AS FParentCostObjectID, \n");
        kSql.append("        ISNULL(resQty.FSTDQty,0)* \n");
        kSql.append("        (CASE \n");
        kSql.append("            WHEN ISNULL(matPrice.FSTDPrice, 0) > 0 THEN ISNULL(matPrice.FSTDPrice, 0)  \n");
        kSql.append("            ELSE ISNULL(resPrice.FSTDPrice,0) \n");
        kSql.append("        END) \n");
        kSql.append("        AS FStdPrice, \n");
        kSql.append("        resQty.FResourceTypeID AS FResourceTypeID, \n");
        kSql.append("        res.FMeasureUnitID AS FResMeasureUnitID, \n");
        kSql.append("        res.FCostItemID AS FResCostItemID, \n");
        kSql.append("        ISNULL(resQty.FSTDQty,0) AS FResQty, \n");
        kSql.append("        (CASE \n");
        kSql.append("            WHEN ISNULL(matPrice.FSTDPrice, 0) > 0 THEN ISNULL(matPrice.FSTDPrice, 0)  \n");
        kSql.append("            ELSE ISNULL(resPrice.FSTDPrice,0) \n");
        kSql.append("        END) \n");
        kSql.append("        AS FResStdPrice, \n");
        kSql.append("        ISNULL(resQty.FSTDQty,0)* \n");
        kSql.append("        (CASE \n");
        kSql.append("            WHEN ISNULL(matPrice.FSTDPrice, 0) > 0 THEN ISNULL(matPrice.FSTDPrice, 0)  \n");
        kSql.append("            ELSE ISNULL(resPrice.FSTDPrice,0) \n");
        kSql.append("        END) \n");
        kSql.append("        AS FResAmount \n");
        kSql.append(" FROM   T_NCM_STDCostResTypeQty resQty \n");
        if (this.T_TMP_Material != null) {
            kSql.append(" join   " + this.T_TMP_Material + " tm on tm.FMaterialID = resQty.FMaterialID \n");
        }
        kSql.append("        INNER JOIN T_NCM_SCResourceType res \n");
        kSql.append("          ON resQty.FResourceTypeID = res.FID \n");
        kSql.append("        LEFT OUTER JOIN T_NCM_STDCostResTypePrice resPrice \n");
        kSql.append("          ON resPrice.FResourceTypeID = resQty.FResourceTypeID \n");
        kSql.append("            AND resPrice.FEstimateSchemeID = '" + calcParam.getResStdPriceSchemeID() + "' \n");
        kSql.append("        LEFT OUTER JOIN T_NCM_STDCostResTypeMatPrice matPrice \n");
        kSql.append("          ON matPrice.FResourceTypeID = resQty.FResourceTypeID \n");
        kSql.append("            AND matPrice.FMaterialID = resQty.FMaterialID \n");
        kSql.append("            AND matPrice.FEstimateSchemeID = '" + calcParam.getResStdPriceSchemeID() + "' \n");
        kSql.append(" WHERE  resQty.FEstimateSchemeID = '" + calcParam.getResStdQtySchemeID() + "' \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollup(STDCostCalcParam calcParam, STDCostCalcResult calcResult) throws Exception {
        StringBuffer kSql = new StringBuffer();
        Context ctx = this.getContext();
        kSql.setLength(0);
        kSql.append(" SELECT   DISTINCT FLowLevelCode \n");
        kSql.append(" FROM     " + this.T_NCM_STDCostRollUpMat + " \n");
        kSql.append(" ORDER BY FLowLevelCode DESC \n");
        IRowSet rst = null;
        try {
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            MatBOMRollUpCalculator rollUpCalculator = new MatBOMRollUpCalculator(ctx, calcParam, calcResult, this.T_TMP_Material);
            int rank = -1;
            while (rst.next()) {
                rank = rst.getInt("FLowLevelCode");
                if (rank == 999) continue;
                rollUpCalculator.rollUp(rank);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    private void updateRollupResult(STDCostCalcParam calcParam) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        Context ctx = this.getContext();
        String companyId = calcParam.getCompanyId();
        kSql.setLength(0);
        kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
        kSql.append(" SET    FMeasureUnitID = (SELECT FBaseUnit \n");
        kSql.append("                          FROM   T_BD_Material \n");
        kSql.append("                          WHERE  FID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID) \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
        kSql.append(" SET    FChildCostItemID = (SELECT FDefaultCostItemID \n");
        kSql.append("                            FROM   T_BD_Material mat \n");
        kSql.append("                                   INNER JOIN T_BD_MaterialCost mc \n");
        kSql.append("                                     ON mat.FID = mc.FMaterialID \n");
        kSql.append("                            WHERE  mc.FOrgUnit = ? \n");
        kSql.append("                              AND  mc.FStatus = 1 \n");
        kSql.append("                                   AND mat.FID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID) \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId});
        kSql.setLength(0);
        kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
        kSql.append(" SET    FChildCostItemID = (SELECT FCostItemID \n");
        kSql.append("                            FROM   T_NCM_ExpenseCompanyInfo ec \n");
        kSql.append("                            WHERE  ec.FExpenseID = ? \n");
        kSql.append("                                   AND ec.FCompanyOrgUnitID = ? ) \n");
        kSql.append(" WHERE  FChildCostItemID IS NULL \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{"ml7t5QEaEADgAAwawKgRe0olWCc=", companyId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRollupResult(STDCostCalcParam calcParam) throws BOSException, EASBizException, SQLException {
        Context ctx = this.getContext();
        String estimateSchemeId = calcParam.getEstimateSchemeId();
        StringBuffer kSql = new StringBuffer();
        try {
            if (this.T_TMP_Material == null) {
                NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostDataMatDetail");
                NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostDataResDetail");
            }
            kSql.setLength(0);
            kSql.append("DELETE FROM " + this.T_NCM_STDCostDataMatDetail + " \n");
            kSql.append("where FEstimateSchemeID = '" + estimateSchemeId + "' \n");
            if (this.T_TMP_Material != null) {
                kSql.append("and EXISTS ( \n");
                kSql.append("    SELECT 1  FROM " + this.T_TMP_Material + " m \n");
                kSql.append("    WHERE m.FMaterialID = " + this.T_NCM_STDCostDataMatDetail + ".FParentMaterialID \n");
                kSql.append(") \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
            String dbTypeName = (String)ctx.get((Object)"dbType");
            int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
            if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
                this.saveRollupMatResultOnOracle();
            } else {
                this.saveRollupMatResultOnKSQL();
            }
            kSql.setLength(0);
            kSql.append(" DELETE FROM " + this.T_NCM_STDCostDataResDetail + " \n");
            kSql.append(" where FEstimateSchemeID = '" + estimateSchemeId + "' \n");
            if (this.T_TMP_Material != null) {
                kSql.append("and EXISTS ( \n");
                kSql.append("    SELECT 1  FROM " + this.T_TMP_Material + " m \n");
                kSql.append("    WHERE m.FMaterialID = " + this.T_NCM_STDCostDataResDetail + ".FParentMaterialID \n");
                kSql.append(") \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
            if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
                this.saveRollupResResultOnOracle();
            } else {
                this.saveRollupResResultOnKSQL();
            }
        }
        finally {
            if (this.T_TMP_Material == null) {
                NCMDynamicTableManager.buildIndexsOfBusiTbl((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostDataMatDetail");
                NCMDynamicTableManager.buildIndexsOfBusiTbl((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostDataResDetail");
            }
        }
    }

    private void saveRollupMatResultOnOracle() throws BOSException {
        Context ctx = this.getContext();
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append("/*dialect*/").append(" \n");
        kSql.append("declare \n");
        kSql.append("    cursor cur is \n");
        kSql.append("    \n");
        kSql.append(" SELECT NEWBOSID('E723DD0A') AS FID, \n");
        kSql.append("        FComapnyOrg, \n");
        kSql.append("        FCalculatePeriod, \n");
        kSql.append("        FStorageOrgUnitID, \n");
        kSql.append("        FEstimateSchemeID, \n");
        kSql.append("        FParentMaterialID, \n");
        kSql.append("        FParentCostObjectID, \n");
        kSql.append("        FEstimateType, \n");
        kSql.append("        FStdPrice, \n");
        kSql.append("        FMaterialID, \n");
        kSql.append("        FMeasureUnitID, \n");
        kSql.append("        FCostObjectID, \n");
        kSql.append("        FChildCostItemID, \n");
        kSql.append("        FChildQty, \n");
        kSql.append("        FChildStdPrice, \n");
        kSql.append("        FChildAmount, \n");
        kSql.append("        FLowLevelCode, \n");
        kSql.append("        FSpreadPath \n");
        kSql.append(" FROM   " + this.T_NCM_STDCostRollUpMat + " \n");
        kSql.append("    ; \n");
        kSql.append("    \n");
        kSql.append("    type t_FID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FID%TYPE; \n");
        kSql.append("    type t_FComapnyOrg IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FComapnyOrg%TYPE; \n");
        kSql.append("    type t_FCalculatePeriod IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FCalculatePeriod%TYPE; \n");
        kSql.append("    type t_FStorageOrgUnitID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FStorageOrgUnitID%TYPE; \n");
        kSql.append("    type t_FEstimateSchemeID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FEstimateSchemeID%TYPE; \n");
        kSql.append("    type t_FParentMaterialID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FParentMaterialID%TYPE; \n");
        kSql.append("    type t_FParentCostObjectID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FParentCostObjectID%TYPE; \n");
        kSql.append("    type t_FEstimateType IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FEstimateType%TYPE; \n");
        kSql.append("    type t_FStdPrice IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FStdPrice%TYPE; \n");
        kSql.append("    type t_FMaterialID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FMaterialID%TYPE; \n");
        kSql.append("    type t_FMeasureUnitID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FMeasureUnitID%TYPE; \n");
        kSql.append("    type t_FCostObjectID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FCostObjectID%TYPE; \n");
        kSql.append("    type t_FChildCostItemID IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FChildCostItemID%TYPE; \n");
        kSql.append("    type t_FChildQty IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FChildQty%TYPE; \n");
        kSql.append("    type t_FChildStdPrice IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FChildStdPrice%TYPE; \n");
        kSql.append("    type t_FChildAmount IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FChildAmount%TYPE; \n");
        kSql.append("    type t_FLowLevelCode IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FLowLevelCode%TYPE; \n");
        kSql.append("    type t_FSpreadPath IS TABLE OF " + this.T_NCM_STDCostDataMatDetail + ".FSpreadPath%TYPE; \n");
        kSql.append("    \n");
        kSql.append("    v_FID t_FID; \n");
        kSql.append("    v_FComapnyOrg t_FComapnyOrg; \n");
        kSql.append("    v_FCalculatePeriod t_FCalculatePeriod; \n");
        kSql.append("    v_FStorageOrgUnitID t_FStorageOrgUnitID; \n");
        kSql.append("    v_FEstimateSchemeID t_FEstimateSchemeID; \n");
        kSql.append("    v_FParentMaterialID t_FParentMaterialID; \n");
        kSql.append("    v_FParentCostObjectID t_FParentCostObjectID; \n");
        kSql.append("    v_FEstimateType t_FEstimateType; \n");
        kSql.append("    v_FStdPrice t_FStdPrice; \n");
        kSql.append("    v_FMaterialID t_FMaterialID; \n");
        kSql.append("    v_FMeasureUnitID t_FMeasureUnitID; \n");
        kSql.append("    v_FCostObjectID t_FCostObjectID; \n");
        kSql.append("    v_FChildCostItemID t_FChildCostItemID; \n");
        kSql.append("    v_FChildQty t_FChildQty; \n");
        kSql.append("    v_FChildStdPrice t_FChildStdPrice; \n");
        kSql.append("    v_FChildAmount t_FChildAmount; \n");
        kSql.append("    v_FLowLevelCode t_FLowLevelCode; \n");
        kSql.append("    v_FSpreadPath t_FSpreadPath; \n");
        kSql.append("    \n");
        kSql.append("begin \n");
        kSql.append("    \n");
        kSql.append("    open cur; \n");
        kSql.append("    loop \n");
        kSql.append("        FETCH cur BULK COLLECT INTO \n");
        kSql.append("            v_FID, \n");
        kSql.append("            v_FComapnyOrg, \n");
        kSql.append("            v_FCalculatePeriod, \n");
        kSql.append("            v_FStorageOrgUnitID, \n");
        kSql.append("            v_FEstimateSchemeID, \n");
        kSql.append("            v_FParentMaterialID, \n");
        kSql.append("            v_FParentCostObjectID, \n");
        kSql.append("            v_FEstimateType, \n");
        kSql.append("            v_FStdPrice, \n");
        kSql.append("            v_FMaterialID, \n");
        kSql.append("            v_FMeasureUnitID, \n");
        kSql.append("            v_FCostObjectID, \n");
        kSql.append("            v_FChildCostItemID, \n");
        kSql.append("            v_FChildQty, \n");
        kSql.append("            v_FChildStdPrice, \n");
        kSql.append("            v_FChildAmount, \n");
        kSql.append("            v_FLowLevelCode, \n");
        kSql.append("            v_FSpreadPath \n");
        kSql.append("        LIMIT 1000; \n");
        kSql.append("        FORALL i IN 1 .. v_FID.COUNT \n");
        kSql.append("        INSERT /*+ append parallel(" + this.T_NCM_STDCostDataMatDetail + ") */ INTO " + this.T_NCM_STDCostDataMatDetail + " ( \n");
        kSql.append("             FID, \n");
        kSql.append("             FComapnyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FStorageOrgUnitID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FParentMaterialID, \n");
        kSql.append("             FParentCostObjectID, \n");
        kSql.append("             FEstimateType, \n");
        kSql.append("             FStdPrice, \n");
        kSql.append("             FMaterialID, \n");
        kSql.append("             FMeasureUnitID, \n");
        kSql.append("             FCostObjectID, \n");
        kSql.append("             FChildCostItemID, \n");
        kSql.append("             FChildQty, \n");
        kSql.append("             FChildStdPrice, \n");
        kSql.append("             FChildAmount, \n");
        kSql.append("             FLowLevelCode, \n");
        kSql.append("             FSpreadPath \n");
        kSql.append("        ) \n");
        kSql.append("        values ( \n");
        kSql.append("            v_FID(i), \n");
        kSql.append("            v_FComapnyOrg(i), \n");
        kSql.append("            v_FCalculatePeriod(i), \n");
        kSql.append("            v_FStorageOrgUnitID(i), \n");
        kSql.append("            v_FEstimateSchemeID(i), \n");
        kSql.append("            v_FParentMaterialID(i), \n");
        kSql.append("            v_FParentCostObjectID(i), \n");
        kSql.append("            v_FEstimateType(i), \n");
        kSql.append("            v_FStdPrice(i), \n");
        kSql.append("            v_FMaterialID(i), \n");
        kSql.append("            v_FMeasureUnitID(i), \n");
        kSql.append("            v_FCostObjectID(i), \n");
        kSql.append("            v_FChildCostItemID(i), \n");
        kSql.append("            v_FChildQty(i), \n");
        kSql.append("            v_FChildStdPrice(i), \n");
        kSql.append("            v_FChildAmount(i), \n");
        kSql.append("            v_FLowLevelCode(i), \n");
        kSql.append("            v_FSpreadPath(i) \n");
        kSql.append("        ); \n");
        kSql.append("        \n");
        kSql.append("        commit; \n");
        kSql.append("        EXIT WHEN cur%NOTFOUND; \n");
        kSql.append("        \n");
        kSql.append("    end loop; \n");
        kSql.append("    close cur; \n");
        kSql.append("    commit; \n");
        kSql.append("    \n");
        kSql.append("end; \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    private void saveRollupMatResultOnKSQL() throws BOSException {
        Context ctx = this.getContext();
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" INSERT INTO " + this.T_NCM_STDCostDataMatDetail + " \n");
        kSql.append("            (FID, \n");
        kSql.append("             FComapnyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FStorageOrgUnitID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FParentMaterialID, \n");
        kSql.append("             FParentCostObjectID, \n");
        kSql.append("             FEstimateType, \n");
        kSql.append("             FStdPrice, \n");
        kSql.append("             FMaterialID, \n");
        kSql.append("             FMeasureUnitID, \n");
        kSql.append("             FCostObjectID, \n");
        kSql.append("             FChildCostItemID, \n");
        kSql.append("             FChildQty, \n");
        kSql.append("             FChildStdPrice, \n");
        kSql.append("             FChildAmount, \n");
        kSql.append("             FLowLevelCode, \n");
        kSql.append("             FSpreadPath) \n");
        kSql.append(" SELECT NEWBOSID('E723DD0A') AS FID, \n");
        kSql.append("        FComapnyOrg, \n");
        kSql.append("        FCalculatePeriod, \n");
        kSql.append("        FStorageOrgUnitID, \n");
        kSql.append("        FEstimateSchemeID, \n");
        kSql.append("        FParentMaterialID, \n");
        kSql.append("        FParentCostObjectID, \n");
        kSql.append("        FEstimateType, \n");
        kSql.append("        FStdPrice, \n");
        kSql.append("        FMaterialID, \n");
        kSql.append("        FMeasureUnitID, \n");
        kSql.append("        FCostObjectID, \n");
        kSql.append("        FChildCostItemID, \n");
        kSql.append("        FChildQty, \n");
        kSql.append("        FChildStdPrice, \n");
        kSql.append("        FChildAmount, \n");
        kSql.append("        FLowLevelCode, \n");
        kSql.append("        FSpreadPath \n");
        kSql.append(" FROM   " + this.T_NCM_STDCostRollUpMat + " \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    private void saveRollupResResultOnOracle() throws BOSException {
        Context ctx = this.getContext();
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append("/*dialect*/").append(" \n");
        kSql.append("declare \n");
        kSql.append("    cursor cur is \n");
        kSql.append("    \n");
        kSql.append(" SELECT NEWBOSID('3718804A') AS FID, \n");
        kSql.append("        FCompanyOrg, \n");
        kSql.append("        FCalculatePeriod, \n");
        kSql.append("        FStorageOrgUnitID, \n");
        kSql.append("        FEstimateSchemeID, \n");
        kSql.append("        FParentMaterialID, \n");
        kSql.append("        FParentCostObjectID, \n");
        kSql.append("        FStdPrice, \n");
        kSql.append("        FResourceTypeID, \n");
        kSql.append("        FResMeasureUnitID, \n");
        kSql.append("        FResCostItemID, \n");
        kSql.append("        FResQty, \n");
        kSql.append("        FResStdPrice, \n");
        kSql.append("        FResAmount \n");
        kSql.append(" FROM   " + this.T_NCM_STDCostRollUpRes + " \n");
        kSql.append("    ; \n");
        kSql.append("    \n");
        kSql.append("    type t_FID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FID%TYPE; \n");
        kSql.append("    type t_FCompanyOrg IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FCompanyOrg%TYPE; \n");
        kSql.append("    type t_FCalculatePeriod IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FCalculatePeriod%TYPE; \n");
        kSql.append("    type t_FStorageOrgUnitID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FStorageOrgUnitID%TYPE; \n");
        kSql.append("    type t_FEstimateSchemeID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FEstimateSchemeID%TYPE; \n");
        kSql.append("    type t_FParentMaterialID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FParentMaterialID%TYPE; \n");
        kSql.append("    type t_FParentCostObjectID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FParentCostObjectID%TYPE; \n");
        kSql.append("    type t_FStdPrice IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FStdPrice%TYPE; \n");
        kSql.append("    type t_FResourceTypeID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FResourceTypeID%TYPE; \n");
        kSql.append("    type t_FResMeasureUnitID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FResMeasureUnitID%TYPE; \n");
        kSql.append("    type t_FResCostItemID IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FResCostItemID%TYPE; \n");
        kSql.append("    type t_FResQty IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FResQty%TYPE; \n");
        kSql.append("    type t_FResStdPrice IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FResStdPrice%TYPE; \n");
        kSql.append("    type t_FResAmount IS TABLE OF " + this.T_NCM_STDCostDataResDetail + ".FResAmount%TYPE; \n");
        kSql.append("    \n");
        kSql.append("    v_FID t_FID; \n");
        kSql.append("    v_FCompanyOrg t_FCompanyOrg; \n");
        kSql.append("    v_FCalculatePeriod t_FCalculatePeriod; \n");
        kSql.append("    v_FStorageOrgUnitID t_FStorageOrgUnitID; \n");
        kSql.append("    v_FEstimateSchemeID t_FEstimateSchemeID; \n");
        kSql.append("    v_FParentMaterialID t_FParentMaterialID; \n");
        kSql.append("    v_FParentCostObjectID t_FParentCostObjectID; \n");
        kSql.append("    v_FStdPrice t_FStdPrice; \n");
        kSql.append("    v_FResourceTypeID t_FResourceTypeID; \n");
        kSql.append("    v_FResMeasureUnitID t_FResMeasureUnitID; \n");
        kSql.append("    v_FResCostItemID t_FResCostItemID; \n");
        kSql.append("    v_FResQty t_FResQty; \n");
        kSql.append("    v_FResStdPrice t_FResStdPrice; \n");
        kSql.append("    v_FResAmount t_FResAmount; \n");
        kSql.append("    \n");
        kSql.append("begin \n");
        kSql.append("    \n");
        kSql.append("    open cur; \n");
        kSql.append("    loop \n");
        kSql.append("        FETCH cur BULK COLLECT INTO \n");
        kSql.append("            v_FID, \n");
        kSql.append("            v_FCompanyOrg, \n");
        kSql.append("            v_FCalculatePeriod, \n");
        kSql.append("            v_FStorageOrgUnitID, \n");
        kSql.append("            v_FEstimateSchemeID, \n");
        kSql.append("            v_FParentMaterialID, \n");
        kSql.append("            v_FParentCostObjectID, \n");
        kSql.append("            v_FStdPrice, \n");
        kSql.append("            v_FResourceTypeID, \n");
        kSql.append("            v_FResMeasureUnitID, \n");
        kSql.append("            v_FResCostItemID, \n");
        kSql.append("            v_FResQty, \n");
        kSql.append("            v_FResStdPrice, \n");
        kSql.append("            v_FResAmount \n");
        kSql.append("        LIMIT 1000; \n");
        kSql.append("        FORALL i IN 1 .. v_FID.COUNT \n");
        kSql.append("        INSERT /*+ append parallel(" + this.T_NCM_STDCostDataResDetail + ") */ INTO " + this.T_NCM_STDCostDataResDetail + " ( \n");
        kSql.append("             FID, \n");
        kSql.append("             FCompanyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FStorageOrgUnitID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FParentMaterialID, \n");
        kSql.append("             FParentCostObjectID, \n");
        kSql.append("             FStdPrice, \n");
        kSql.append("             FResourceTypeID, \n");
        kSql.append("             FResMeasureUnitID, \n");
        kSql.append("             FResCostItemID, \n");
        kSql.append("             FResQty, \n");
        kSql.append("             FResStdPrice, \n");
        kSql.append("             FResAmount \n");
        kSql.append("        ) \n");
        kSql.append("        values ( \n");
        kSql.append("            v_FID(i), \n");
        kSql.append("            v_FCompanyOrg(i), \n");
        kSql.append("            v_FCalculatePeriod(i), \n");
        kSql.append("            v_FStorageOrgUnitID(i), \n");
        kSql.append("            v_FEstimateSchemeID(i), \n");
        kSql.append("            v_FParentMaterialID(i), \n");
        kSql.append("            v_FParentCostObjectID(i), \n");
        kSql.append("            v_FStdPrice(i), \n");
        kSql.append("            v_FResourceTypeID(i), \n");
        kSql.append("            v_FResMeasureUnitID(i), \n");
        kSql.append("            v_FResCostItemID(i), \n");
        kSql.append("            v_FResQty(i), \n");
        kSql.append("            v_FResStdPrice(i), \n");
        kSql.append("            v_FResAmount(i) \n");
        kSql.append("        ); \n");
        kSql.append("        \n");
        kSql.append("        commit; \n");
        kSql.append("        EXIT WHEN cur%NOTFOUND; \n");
        kSql.append("        \n");
        kSql.append("    end loop; \n");
        kSql.append("    close cur; \n");
        kSql.append("    commit; \n");
        kSql.append("    \n");
        kSql.append("end; \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    private void saveRollupResResultOnKSQL() throws BOSException {
        Context ctx = this.getContext();
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" INSERT INTO " + this.T_NCM_STDCostDataResDetail + " \n");
        kSql.append("            (FID, \n");
        kSql.append("             FCompanyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FStorageOrgUnitID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FParentMaterialID, \n");
        kSql.append("             FParentCostObjectID, \n");
        kSql.append("             FStdPrice, \n");
        kSql.append("             FResourceTypeID, \n");
        kSql.append("             FResMeasureUnitID, \n");
        kSql.append("             FResCostItemID, \n");
        kSql.append("             FResQty, \n");
        kSql.append("             FResStdPrice, \n");
        kSql.append("             FResAmount) \n");
        kSql.append(" SELECT NEWBOSID('3718804A') AS FID, \n");
        kSql.append("        FCompanyOrg, \n");
        kSql.append("        FCalculatePeriod, \n");
        kSql.append("        FStorageOrgUnitID, \n");
        kSql.append("        FEstimateSchemeID, \n");
        kSql.append("        FParentMaterialID, \n");
        kSql.append("        FParentCostObjectID, \n");
        kSql.append("        FStdPrice, \n");
        kSql.append("        FResourceTypeID, \n");
        kSql.append("        FResMeasureUnitID, \n");
        kSql.append("        FResCostItemID, \n");
        kSql.append("        FResQty, \n");
        kSql.append("        FResStdPrice, \n");
        kSql.append("        FResAmount \n");
        kSql.append(" FROM   " + this.T_NCM_STDCostRollUpRes + " \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackPrice(STDCostCalcParam calcParam) throws Exception {
        if (calcParam.isCombScheme()) {
            return;
        }
        Context ctx = this.getContext();
        String estimateSchemeId = calcParam.getEstimateSchemeId();
        boolean isOnlyForOnStdCost = calcParam.isOnlyForOnStdCost();
        StringBuffer kSql = new StringBuffer();
        String T_TMP_RollUpPrice = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("create table T ( \n");
            sql.append("\t  FMaterialID varchar(44), \n");
            sql.append("\t  FStdPrice decimal(24,12) \n");
            sql.append(") \n");
            T_TMP_RollUpPrice = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + T_TMP_RollUpPrice + " ( \n");
            sql.append("    FMaterialID,  \n");
            sql.append("    FStdPrice  \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    FParentMaterialID FMaterialID, \n");
            sql.append("    ISNULL(FSTDPrice,0) FSTDPrice \n");
            sql.append("from " + this.T_NCM_STDCostRollUpMat + " \n");
            sql.append("GROUP BY FParentMaterialID, FSTDPrice \n");
            sql.append("union \n");
            sql.append("select \n");
            sql.append("    FParentMaterialID FParentMaterialID, \n");
            sql.append("    ISNULL(FSTDPrice,0) FSTDPrice \n");
            sql.append("from " + this.T_NCM_STDCostRollUpRes + " \n");
            sql.append("GROUP BY FParentMaterialID,FSTDPrice \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(T_TMP_RollUpPrice, "FMaterialID", false, false);
            kSql.setLength(0);
            kSql.append("UPDATE T_NCM_STDCostData \n");
            kSql.append("set (FSTDAmount) = ( \n");
            kSql.append("    select FSTDPrice \n");
            kSql.append("    from " + T_TMP_RollUpPrice + " p \n");
            kSql.append("    where p.FMaterialID = T_NCM_STDCostData.FMaterialID \n");
            kSql.append(") \n");
            kSql.append("where FEstimateSchemeID = '" + estimateSchemeId + "' \n");
            kSql.append("and FDataType = 2 \n");
            if (isOnlyForOnStdCost) {
                kSql.append("and FStdAmount IS NULL \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        }
        catch (Throwable throwable) {
            try {
                if (T_TMP_RollUpPrice != null) {
                    TempTablePool.getInstance((Context)this.getContext()).releaseTable(T_TMP_RollUpPrice);
                }
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
            }
            throw throwable;
        }
        try {
            if (T_TMP_RollUpPrice != null) {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(T_TMP_RollUpPrice);
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
    }
}

