/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class STDCostDiffReport
extends ReportServerBase {
    protected static final Logger logger = Logger.getLogger((String)STDCostDiffReport.class.getName());
    private int currencyPrecision = -1;
    private static Map groups = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = null;
        try {
            IRowSet rs;
            tempTable = this.buildData(reportID, filter);
            String ksql = this.buildSelectSql(filter, tempTable);
            IRowSet iRowSet = rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
            return iRowSet;
        }
        finally {
            if (tempTable != null) {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
            }
        }
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = null;
        try {
            tableName = this.buildData(reportID, filter);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        String ksql = this.buildSelectSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql, (int)start, (int)rows);
        return rs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String buildData(String reportID, RptParams filter) throws Exception {
        Connection conn;
        String T_TMP_CostObject;
        String TMP_NCM_STDCostDiffRpt;
        block48: {
            Assert.that((!StringUtils.isEmpty((String)reportID) ? 1 : 0) != 0);
            Assert.that((filter != null ? 1 : 0) != 0);
            String companyId = ((CompanyOrgUnitInfo)filter.getObject("companyOrg")).getId().toString();
            STDCostEstimateSchemeInfo estimateScheme = (STDCostEstimateSchemeInfo)filter.getObject("scheme");
            String estimateSchemeId = estimateScheme.getId().toString();
            String year = filter.getString("year");
            String month = filter.getString("month");
            this.currencyPrecision = NCMUtils.getCurrencyPrecision((Context)this.getContext(), (String)companyId);
            boolean divMatBatch = this.isDivMatBatch(filter);
            Locale locale = this.getContext().getLocale();
            TMP_NCM_STDCostDiffRpt = null;
            T_TMP_CostObject = null;
            String T_NCM_STDCostDataMatDetail = null;
            String T_NCM_STDCostDataResDetail = null;
            String T_NCM_CostCalMatDetailResult = null;
            String T_NCM_DataByCostObj = null;
            String T_NCM_CostCalResult = null;
            conn = null;
            Object rst = null;
            try {
                int i;
                conn = EJBFactory.getConnection((Context)this.getContext());
                String periodId = this.getPeriodId(year, month, companyId);
                if (StringUtils.isEmpty((String)periodId)) {
                    String string = null;
                    return string;
                }
                int period = this.getPeriodNumber(companyId, year, month);
                T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_STDCostDataMatDetail");
                T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_STDCostDataResDetail");
                T_NCM_CostCalMatDetailResult = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_CostCalMatDetailResult", (int)period, (int)period);
                T_NCM_DataByCostObj = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_DataByCostObj", (int)period, (int)period);
                T_NCM_CostCalResult = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_CostCalResult", (int)period, (int)period);
                StringBuffer kSql = new StringBuffer();
                kSql.setLength(0);
                kSql.append("create table TMP_NCM_STDCostDiffRpt(");
                kSql.append(" \tFPeriodID \t\t      varchar(44),");
                kSql.append(" \tFPeriodNumber         varchar(80),");
                kSql.append(" \tFPeriodName \t      varchar(100),");
                kSql.append(" \tFCostCenterID \t\t  varchar(44),");
                kSql.append(" \tFCostCenterNumber \t  varchar(80),");
                kSql.append(" \tFCostCenterName \t  varchar(255), ");
                kSql.append(" \tFSchemeID\t\t      varchar(44),");
                kSql.append(" \tFSchemeNumber \t      varchar(80),");
                kSql.append(" \tFSchemeName  \t      varchar(255),");
                kSql.append(" \tFCostObjectID\t\t  nvarchar(44),");
                kSql.append(" \tFCostObjectNumber \t  varchar(80),");
                kSql.append(" \tFCostObjectName \t  varchar(255),");
                kSql.append("   FBatchNo              nvarchar(255),");
                kSql.append(" \tFParentMaterialID \t  varchar(44),");
                kSql.append(" \tFParentMaterialNumber varchar(80),");
                kSql.append(" \tFParentMaterialName   varchar(255),");
                kSql.append("   FModel                nvarchar(255),");
                kSql.append("   FCostObjectQty        decimal(21,8),");
                kSql.append(" \tFCostItemID \t\t  varchar(44),");
                kSql.append(" \tFCostItemNumber \t  varchar(80),");
                kSql.append(" \tFCostItemName \t\t  varchar(255),");
                kSql.append(" \tFItemType \t\t      int default(2),");
                kSql.append(" \tFMaterialID \t\t  varchar(44),");
                kSql.append(" \tFMaterialNumber \t  varchar(80),");
                kSql.append(" \tFMaterialName \t\t  varchar(255),");
                kSql.append(" \tFMaterialModel \t\t  nvarchar(255),");
                kSql.append("   FMeasureUnitName      nvarchar(255),");
                kSql.append("   FLot       \t\t\t  nvarchar(80),");
                kSql.append(" \tFTotalRow \t\t      decimal(21,8) not null default(0),");
                kSql.append(" \tFTotalRow2 \t\t      decimal(21,8) not null default(0),");
                kSql.append("   FIsTotalRow int not null default(1), ");
                kSql.append("   FTotalPeriodRow int not null default(0), ");
                kSql.append("   FTotalCostCenterRow int not null default(0), ");
                kSql.append("   FTotalSchemeRow int not null default(0), ");
                kSql.append("   FTotalCostObjectRow int not null default(0), ");
                kSql.append("   FTotalParentMaterialRow int not null default(0), ");
                kSql.append("   FTotalCostItemRow int not null default(0), ");
                kSql.append("   FTotalMaterialRow int not null default(0), ");
                kSql.append("\tFQtyDecimal \t      int default(6),");
                kSql.append("\tFPriceDecimal \t      int default(6),");
                kSql.append("\tFAmountDecimal \t      int default(6),");
                kSql.append("\tFRateDecimal \t      int default(2),");
                kSql.append("\tFSpecFlag \t          int default(0),");
                kSql.append(" \tFActTotalAmount \t  decimal(21,8),");
                kSql.append(" \tFStdTotalAmount \t  decimal(21,8),");
                kSql.append(" \tFTotalDiff \t\t      decimal(21,8),");
                kSql.append(" \tFTotalDiffRate\t      decimal(21,8),");
                kSql.append(" \tFActTotalQty \t      decimal(21,8),");
                kSql.append(" \tFStdTotalQty \t      decimal(21,8),");
                kSql.append(" \tFActUnitQty     \t  decimal(21,8),");
                kSql.append(" \tFStdUnitQty     \t  decimal(21,8),");
                kSql.append(" \tFUnitQtyDiff     \t  decimal(21,8),");
                kSql.append(" \tFQtyDiff     \t      decimal(21,8),");
                kSql.append(" \tFQtyDiffRate     \t  decimal(21,8),");
                kSql.append(" \tFActUnitPrice     \t  decimal(21,8),");
                kSql.append(" \tFStdUnitPrice     \t  decimal(21,8),");
                kSql.append(" \tFUnitPriceDiff     \t  decimal(21,8),");
                kSql.append(" \tFPriceDiff     \t      decimal(21,8),");
                kSql.append(" \tFPriceDiffRate        decimal(21,8),");
                kSql.append("\tFDataFlag \t          int default(0)");
                kSql.append(" ) ");
                TMP_NCM_STDCostDiffRpt = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
                kSql.setLength(0);
                kSql.append("create table T_TMP_CostObject ( \n");
                kSql.append("    FCostCenterID \t\t      varchar(44), \n");
                kSql.append("    FCostObjectID \t\t      varchar(44), \n");
                kSql.append("    FMaterialID \t\t      varchar(44) \n");
                kSql.append(") \n");
                T_TMP_CostObject = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
                kSql.setLength(0);
                kSql.append("insert into " + T_TMP_CostObject + " ( \n");
                kSql.append("    FCostCenterID, \n");
                kSql.append("    FCostObjectID, \n");
                kSql.append("    FMaterialID \n");
                kSql.append(") \n");
                kSql.append("select distinct \n");
                kSql.append("    r.FCostCenterID FCostCenterID, \n");
                kSql.append("    co.FID FCostObjectID, \n");
                kSql.append("    co.FRelatedID FMaterialID \n");
                kSql.append("from " + T_NCM_CostCalResult + " r \n");
                kSql.append("join T_ORG_CostCenter cc \n");
                kSql.append("    on cc.FID = r.FCostCenterID \n");
                kSql.append("join T_BD_CostObject co \n");
                kSql.append("    on co.FID = r.FCostObjectID \n");
                kSql.append("where r.FCompanyID = '" + companyId + "' \n");
                kSql.append("and r.FCalculatePeriodID = '" + periodId + "' \n");
                if (this.isFilterCostCenter(filter)) {
                    kSql.append("and cc.FNumber in (" + this.filterCostCenter(filter) + ") \n");
                }
                if (this.isFilterCostObject(filter)) {
                    kSql.append("and co.FNumber in (" + this.filterCostObject(filter) + ") \n");
                }
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                TempTablePool.getInstance((Context)this.getContext()).createIndex(T_TMP_CostObject, "FCostObjectID", false, false);
                TempTablePool.getInstance((Context)this.getContext()).createIndex(T_TMP_CostObject, "FMaterialID", false, false);
                if (divMatBatch) {
                    this.insertActMatDetail(TMP_NCM_STDCostDiffRpt, T_NCM_CostCalMatDetailResult, companyId, periodId, estimateSchemeId, true, filter, 2);
                    this.insertActMatDetail(TMP_NCM_STDCostDiffRpt, T_NCM_CostCalMatDetailResult, companyId, periodId, estimateSchemeId, false, filter, 3);
                } else {
                    this.insertActMatDetail(TMP_NCM_STDCostDiffRpt, T_NCM_CostCalMatDetailResult, companyId, periodId, estimateSchemeId, false, filter, 0);
                }
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostDiffRpt, "FCostCenterID", false, false);
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostDiffRpt, "FSchemeID", false, false);
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostDiffRpt, "FCostObjectID", false, false);
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostDiffRpt, "FParentMaterialID", false, false);
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostDiffRpt, "FCostItemID", false, false);
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostDiffRpt, "FMaterialID", false, false);
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FParentMaterialID = (SELECT co.FRelatedID \n");
                kSql.append("                                     FROM   T_BD_CostObject co \n");
                kSql.append("                                     WHERE  " + TMP_NCM_STDCostDiffRpt + ".FCostObjectID = co.FID \n");
                kSql.append("                                            AND co.FRelatedType IN (0)) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" INSERT INTO " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" \t   (FPeriodID, \n");
                kSql.append("  \t\tFPeriodNumber, \n");
                kSql.append("  \t\tFPeriodName, \n");
                kSql.append("  \t\tFCostCenterID, \n");
                kSql.append("  \t\tFCostCenterNumber, \n");
                kSql.append("  \t\tFCostCenterName, \n");
                kSql.append("  \t\tFSchemeID, \n");
                kSql.append("  \t\tFSchemeNumber, \n");
                kSql.append("  \t\tFSchemeName, \n");
                kSql.append("  \t\tFCostObjectID, \n");
                kSql.append("  \t\tFCostObjectNumber, \n");
                kSql.append("  \t\tFCostObjectName, \n");
                kSql.append("  \t\tFBatchNo, \n");
                kSql.append("  \t\tFParentMaterialID, \n");
                kSql.append("  \t\tFParentMaterialNumber, \n");
                kSql.append("  \t\tFParentMaterialName, \n");
                kSql.append("  \t\tFModel, \n");
                kSql.append("  \t\tFCostObjectQty, \n");
                kSql.append("  \t\tFCostItemID, \n");
                kSql.append("  \t\tFCostItemNumber, \n");
                kSql.append("  \t\tFCostItemName, \n");
                kSql.append("  \t\tFMaterialID, \n");
                kSql.append("  \t\tFMaterialNumber, \n");
                kSql.append("  \t\tFMaterialName, \n");
                kSql.append("  \t\tFMeasureUnitName, \n");
                kSql.append("  \t\tFLot, \n");
                kSql.append("  \t\tFTotalRow, \n");
                kSql.append("  \t\tFTotalRow2, \n");
                kSql.append("  \t\tFQtyDecimal, \n");
                kSql.append("  \t\tFPriceDecimal, \n");
                kSql.append("  \t\tFAmountDecimal, \n");
                kSql.append("  \t\tFRateDecimal, \n");
                kSql.append("  \t\tFSpecFlag, \n");
                kSql.append("  \t\tFActTotalAmount, \n");
                kSql.append("  \t\tFActTotalQty, \n");
                kSql.append("  \t\tFIsTotalRow, \n");
                kSql.append("  \t\tFDataFlag \n");
                kSql.append("  \t\t) \n");
                kSql.append("SELECT distinct '" + periodId + "', \n");
                kSql.append(" \t    NULL AS FPeriodNumber, \n");
                kSql.append("\t\tNULL AS FPeriodName, \n");
                kSql.append(" \t\tco.FCostCenterID, \n");
                kSql.append(" \t\tNULL AS FCostCenterNumber, \n");
                kSql.append(" \t\tNULL AS FCostCenterName, \n");
                kSql.append(" \t\t'" + estimateSchemeId + "' AS FSchemeID, \n");
                kSql.append(" \t\tNULL AS FSchemeNumber, \n");
                kSql.append(" \t\tNULL AS FSchemeName, \n");
                kSql.append(" \t\tco.FCostObjectID AS FCostObjectID, \n");
                kSql.append(" \t\tNULL AS FCostObjectNumber, \n");
                kSql.append(" \t\tNULL AS FCostObjectName, \n");
                kSql.append(" \t\tnull AS FBatchNo, \n");
                kSql.append(" \t\tr.FParentMaterialID AS FParentMaterialID, \n");
                kSql.append(" \t\tNULL AS FParentMaterialNumber, \n");
                kSql.append(" \t\tNULL AS FParentMaterialName, \n");
                kSql.append(" \t\tnull AS FModel, \n");
                kSql.append("  \t\t0 FCostObjectQty, \n");
                kSql.append(" \t\tr.FChildCostItemID AS FCostItemID, \n");
                kSql.append(" \t\tNULL AS FCostItemNumber, \n");
                kSql.append(" \t\tNULL AS FCostItemName, \n");
                kSql.append(" \t\tr.FMaterialID AS FMaterialID, \n");
                kSql.append(" \t\tNULL AS FMaterialNumber, \n");
                kSql.append(" \t\tNULL AS FMaterialName, \n");
                kSql.append(" \t\tNULL AS FMeasureUnitName, \n");
                kSql.append(" \t\tnull AS FLot, \n");
                kSql.append(" \t\t0 AS FTotalRow, \n");
                kSql.append(" \t\t0 AS FTotalRow2, \n");
                kSql.append(" \t\t6 AS FQtyDecimal, \n");
                kSql.append(" \t\t6 AS FPriceDecimal, \n");
                kSql.append(" \t\t" + this.currencyPrecision + " AS FAmountDecimal, \n");
                kSql.append(" \t\t2 AS FRateDecimal, \n");
                kSql.append(" \t\t0, \n");
                kSql.append(" \t\t0 AS FActTotalAmount, \n");
                kSql.append(" \t\t0 AS FActTotalQty, \n");
                kSql.append("       0 AS FIsTotalRow ,\n");
                kSql.append("       0 AS FDataFlag \n");
                kSql.append(" FROM  " + T_NCM_STDCostDataMatDetail + " r \n");
                kSql.append(" join  " + T_TMP_CostObject + " co \n");
                kSql.append("     on co.FMaterialID = FParentMaterialID \n");
                kSql.append(" where r.FEstimateSchemeID = '" + estimateSchemeId + "' \n");
                kSql.append(" and not exists ( \n");
                kSql.append("     select 1 from " + TMP_NCM_STDCostDiffRpt + " d \n");
                kSql.append("     where d.FParentMaterialID = r.FParentMaterialID \n");
                kSql.append("     and d.FCostItemID = r.FChildCostItemID \n");
                kSql.append("     and d.FMaterialID = r.FMaterialID \n");
                kSql.append(" ) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" INSERT INTO " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" \t   (FPeriodID, \n");
                kSql.append("  \t\tFPeriodNumber, \n");
                kSql.append("  \t\tFPeriodName, \n");
                kSql.append("  \t\tFCostCenterID, \n");
                kSql.append("  \t\tFCostCenterNumber, \n");
                kSql.append("  \t\tFCostCenterName, \n");
                kSql.append("  \t\tFSchemeID, \n");
                kSql.append("  \t\tFSchemeNumber, \n");
                kSql.append("  \t\tFSchemeName, \n");
                kSql.append("  \t\tFCostObjectID, \n");
                kSql.append("  \t\tFCostObjectNumber, \n");
                kSql.append("  \t\tFCostObjectName, \n");
                kSql.append("  \t\tFBatchNo, \n");
                kSql.append("  \t\tFParentMaterialID, \n");
                kSql.append("  \t\tFParentMaterialNumber, \n");
                kSql.append("  \t\tFParentMaterialName, \n");
                kSql.append("  \t\tFModel, \n");
                kSql.append("  \t\tFCostObjectQty, \n");
                kSql.append("  \t\tFCostItemID, \n");
                kSql.append("  \t\tFCostItemNumber, \n");
                kSql.append("  \t\tFCostItemName, \n");
                kSql.append("  \t\tFMaterialID, \n");
                kSql.append("  \t\tFMaterialNumber, \n");
                kSql.append("  \t\tFMaterialName, \n");
                kSql.append("  \t\tFMeasureUnitName, \n");
                kSql.append("  \t\tFTotalRow, \n");
                kSql.append("  \t\tFTotalRow2, \n");
                kSql.append("  \t\tFQtyDecimal, \n");
                kSql.append("  \t\tFPriceDecimal, \n");
                kSql.append("  \t\tFAmountDecimal, \n");
                kSql.append("  \t\tFRateDecimal, \n");
                kSql.append("  \t\tFActTotalAmount, \n");
                kSql.append("  \t\tFActTotalQty, \n");
                kSql.append("  \t\tFIsTotalRow \n");
                kSql.append("  \t\t) \n");
                kSql.append("SELECT costCalResult.FCalculatePeriodID AS FPeriodID, \n");
                kSql.append(" \t    NULL AS FPeriodNumber, \n");
                kSql.append("\t\tNULL AS FPeriodName, \n");
                kSql.append(" \t\tcostCalResult.FCostCenterID AS FCostCenterID, \n");
                kSql.append(" \t\tNULL AS FCostCenterNumber, \n");
                kSql.append(" \t\tNULL AS FCostCenterName, \n");
                kSql.append(" \t\t'" + estimateSchemeId + "' AS FSchemeID, \n");
                kSql.append(" \t\tNULL AS FSchemeNumber, \n");
                kSql.append(" \t\tNULL AS FSchemeName, \n");
                kSql.append(" \t\tcostCalResult.FCostObjectID AS FCostObjectID, \n");
                kSql.append(" \t\tNULL AS FCostObjectNumber, \n");
                kSql.append(" \t\tNULL AS FCostObjectName, \n");
                kSql.append(" \t\tISNULL(co.FBatchNumber,' ') AS FBatchNo, \n");
                kSql.append(" \t\tNULL AS FParentMaterialID, \n");
                kSql.append(" \t\tNULL AS FParentMaterialNumber, \n");
                kSql.append(" \t\tNULL AS FParentMaterialName, \n");
                kSql.append(" \t\tNULL AS FModel, \n");
                kSql.append("  \t\t0 AS FCostObjectQty, \n");
                kSql.append(" \t\tcostCalResult.FCostItemID AS FCostItemID, \n");
                kSql.append(" \t\tNULL AS FCostItemNumber, \n");
                kSql.append(" \t\tNULL AS FCostItemName, \n");
                kSql.append(" \t\tNULL AS FMaterialID, \n");
                kSql.append(" \t\tNULL AS FMaterialNumber, \n");
                kSql.append(" \t\tNULL AS FMaterialName, \n");
                kSql.append(" \t\tNULL AS FMeasureUnitName, \n");
                kSql.append(" \t\t0 AS FTotalRow, \n");
                kSql.append(" \t\t0 AS FTotalRow2, \n");
                kSql.append(" \t\t6 AS FQtyDecimal, \n");
                kSql.append(" \t\t6 AS FPriceDecimal, \n");
                kSql.append(" \t\t" + this.currencyPrecision + " AS FAmountDecimal, \n");
                kSql.append(" \t\t2 AS FRateDecimal, \n");
                kSql.append(" \t\tcostCalResult.FFinishedAmount AS FActTotalAmount, \n");
                kSql.append(" \t\tcostCalResult.FFinishedQty AS FActTotalQty, \n");
                kSql.append(" \t\t0 AS FIsTotalRow \n");
                kSql.append(" FROM   " + T_NCM_CostCalResult + " costCalResult \n");
                if (this.isFilterCostCenter(filter)) {
                    kSql.append("  \tLEFT OUTER JOIN  T_ORG_CostCenter cc on  costCalResult.FCostCenterID = cc.FID \n");
                }
                kSql.append("  \tLEFT OUTER JOIN  T_BD_CostObject co on  costCalResult.FCostObjectID = co.FID \n");
                if (this.isFilterCostItem(filter)) {
                    kSql.append("  \tLEFT OUTER JOIN  T_NCM_CostItem ci on  costCalResult.FCostItemID = ci.FID \n");
                }
                kSql.append("WHERE  costCalResult.FCalculatePeriodID = '" + periodId + "' \n");
                kSql.append("  AND  costCalResult.FCompanyID = '" + companyId + "' \n");
                if (this.isFilterCostCenter(filter)) {
                    kSql.append("  AND cc.FNumber in (" + this.filterCostCenter(filter) + ") \n");
                }
                if (this.isFilterCostObject(filter)) {
                    kSql.append("  AND co.FNumber in (" + this.filterCostObject(filter) + ") \n");
                }
                if (this.isFilterCostItem(filter)) {
                    kSql.append("  AND ci.FNumber in (" + this.filterCostItem(filter) + ") \n");
                }
                kSql.append("  AND  NOT EXISTS (SELECT 1 \n");
                kSql.append("                     FROM\u3000" + TMP_NCM_STDCostDiffRpt + " diffRpt \n");
                kSql.append("                    WHERE diffRpt.FPeriodID = costCalResult.FCalculatePeriodID \n");
                kSql.append("                      AND diffRpt.FCostCenterID = costCalResult.FCostCenterID \n");
                kSql.append("                      AND diffRpt.FCostObjectID = costCalResult.FCostObjectID \n");
                kSql.append("                      AND diffRpt.FCostItemID = costCalResult.FCostItemID \n");
                kSql.append("                   ) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" INSERT INTO " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" \t   (FPeriodID, \n");
                kSql.append("  \t\tFPeriodNumber, \n");
                kSql.append("  \t\tFPeriodName, \n");
                kSql.append("  \t\tFCostCenterID, \n");
                kSql.append("  \t\tFCostCenterNumber, \n");
                kSql.append("  \t\tFCostCenterName, \n");
                kSql.append("  \t\tFSchemeID, \n");
                kSql.append("  \t\tFSchemeNumber, \n");
                kSql.append("  \t\tFSchemeName, \n");
                kSql.append("  \t\tFCostObjectID, \n");
                kSql.append("  \t\tFCostObjectNumber, \n");
                kSql.append("  \t\tFCostObjectName, \n");
                kSql.append("  \t\tFBatchNo, \n");
                kSql.append("  \t\tFParentMaterialID, \n");
                kSql.append("  \t\tFParentMaterialNumber, \n");
                kSql.append("  \t\tFParentMaterialName, \n");
                kSql.append("  \t\tFModel, \n");
                kSql.append("  \t\tFCostObjectQty, \n");
                kSql.append("  \t\tFCostItemID, \n");
                kSql.append("  \t\tFCostItemNumber, \n");
                kSql.append("  \t\tFCostItemName, \n");
                kSql.append("  \t\tFMaterialID, \n");
                kSql.append("  \t\tFMaterialNumber, \n");
                kSql.append("  \t\tFMaterialName, \n");
                kSql.append("  \t\tFMeasureUnitName, \n");
                kSql.append("  \t\tFTotalRow, \n");
                kSql.append("  \t\tFTotalRow2, \n");
                kSql.append("  \t\tFQtyDecimal, \n");
                kSql.append("  \t\tFPriceDecimal, \n");
                kSql.append("  \t\tFAmountDecimal, \n");
                kSql.append("  \t\tFRateDecimal, \n");
                kSql.append("  \t\tFActTotalAmount, \n");
                kSql.append("  \t\tFIsTotalRow \n");
                kSql.append("  \t\t) \n");
                kSql.append("SELECT costCalResult.FCalculatePeriodID AS FPeriodID, \n");
                kSql.append(" \t    NULL AS FPeriodNumber, \n");
                kSql.append("\t\tNULL AS FPeriodName, \n");
                kSql.append(" \t\tcostCalResult.FCostCenterID AS FCostCenterID, \n");
                kSql.append(" \t\tNULL AS FCostCenterNumber, \n");
                kSql.append(" \t\tNULL AS FCostCenterName, \n");
                kSql.append(" \t\t'" + estimateSchemeId + "' AS FSchemeID, \n");
                kSql.append(" \t\tNULL AS FSchemeNumber, \n");
                kSql.append(" \t\tNULL AS FSchemeName, \n");
                kSql.append(" \t\tcostCalResult.FCostObjectID AS FCostObjectID, \n");
                kSql.append(" \t\tNULL AS FCostObjectNumber, \n");
                kSql.append(" \t\tNULL AS FCostObjectName, \n");
                kSql.append(" \t\tISNULL(co.FBatchNumber,' ') AS FBatchNo, \n");
                kSql.append(" \t\tNULL AS FParentMaterialID, \n");
                kSql.append(" \t\tNULL AS FParentMaterialNumber, \n");
                kSql.append(" \t\tNULL AS FParentMaterialName, \n");
                kSql.append(" \t\tNULL AS FModel, \n");
                kSql.append("  \t\t0 AS FCostObjectQty, \n");
                kSql.append(" \t\tcostCalResult.FCostItemID AS FCostItemID, \n");
                kSql.append(" \t\tNULL AS FCostItemNumber, \n");
                kSql.append(" \t\tNULL AS FCostItemName, \n");
                kSql.append(" \t\tNULL AS FMaterialID, \n");
                kSql.append(" \t\tNULL AS FMaterialNumber, \n");
                kSql.append(" \t\tNULL AS FMaterialName, \n");
                kSql.append(" \t\tNULL AS FMeasureUnitName, \n");
                kSql.append(" \t\t0 AS FTotalRow, \n");
                kSql.append(" \t\t0 AS FTotalRow2, \n");
                kSql.append(" \t\t6 AS FQtyDecimal, \n");
                kSql.append(" \t\t6 AS FPriceDecimal, \n");
                kSql.append(" \t\t" + this.currencyPrecision + " AS FAmountDecimal, \n");
                kSql.append(" \t\t2 AS FRateDecimal, \n");
                kSql.append(" \t\t(ISNULL(costCalResult.FFinishedAmount,0) - ISNULL(sumData.FFinishedAmount,0)) AS FActTotalAmount, \n");
                kSql.append("       0 AS FIsTotalRow");
                kSql.append(" FROM   " + T_NCM_CostCalResult + " costCalResult \n");
                kSql.append("  INNER JOIN\u3000(SELECT FPeriodID, \n");
                kSql.append("                             FCostCenterID, \n");
                kSql.append("                             FCostObjectID, \n");
                kSql.append("                             FCostItemID, \n");
                kSql.append("                             ISNULL(SUM(FActTotalAmount),0) AS FFinishedAmount \n");
                kSql.append("                        FROM " + TMP_NCM_STDCostDiffRpt + "\n");
                if (this.isDivMatBatch(filter)) {
                    kSql.append("                    where FSpecFlag = 2 \n");
                }
                kSql.append("                        GROUP BY FPeriodID, \n");
                kSql.append("                             FCostCenterID, \n");
                kSql.append("                             FCostObjectID, \n");
                kSql.append("                             FCostItemID) sumData \n");
                kSql.append("      ON sumData.FPeriodID = costCalResult.FCalculatePeriodID \n");
                kSql.append("        AND sumData.FCostCenterID = costCalResult.FCostCenterID \n");
                kSql.append("        AND sumData.FCostObjectID = costCalResult.FCostObjectID \n");
                kSql.append("        AND sumData.FCostItemID = costCalResult.FCostItemID \n");
                if (this.isFilterCostCenter(filter)) {
                    kSql.append("  \tLEFT OUTER JOIN  T_ORG_CostCenter cc on  costCalResult.FCostCenterID = cc.FID \n");
                }
                kSql.append("  \tLEFT OUTER JOIN  T_BD_CostObject co on  costCalResult.FCostObjectID = co.FID \n");
                if (this.isFilterCostItem(filter)) {
                    kSql.append("  \tLEFT OUTER JOIN  T_NCM_CostItem ci on  costCalResult.FCostItemID = ci.FID \n");
                }
                kSql.append("WHERE  costCalResult.FCalculatePeriodID = '" + periodId + "' \n");
                kSql.append("  AND  costCalResult.FCompanyID = '" + companyId + "' \n");
                kSql.append("  AND  (ISNULL(costCalResult.FFinishedAmount,0) - ISNULL(sumData.FFinishedAmount,0))>0.000001 \n");
                if (this.isFilterCostCenter(filter)) {
                    kSql.append("  AND cc.FNumber in (" + this.filterCostCenter(filter) + ") \n");
                }
                if (this.isFilterCostObject(filter)) {
                    kSql.append("  AND co.FNumber in (" + this.filterCostObject(filter) + ") \n");
                }
                if (this.isFilterCostItem(filter)) {
                    kSql.append("  AND ci.FNumber in (" + this.filterCostItem(filter) + ") \n");
                }
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TMP_NCM_STDCostDiffRpt);
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FCostObjectQty = (SELECT ISNULL(dbco.FFinishedQty,0) \n");
                kSql.append("                            FROM " + T_NCM_DataByCostObj + " dbco \n");
                kSql.append("                           WHERE  dbco.FCompanyID = '" + companyId + "' \n");
                kSql.append("                             AND " + TMP_NCM_STDCostDiffRpt + ".FPeriodID = dbco.FCalculatePeriodID \n");
                kSql.append("                             AND " + TMP_NCM_STDCostDiffRpt + ".FCostObjectID = dbco.FCostObjectID \n");
                kSql.append("                             AND " + TMP_NCM_STDCostDiffRpt + ".FCostCenterID = dbco.FCostCenterID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FParentMaterialID = (SELECT co.FRelatedID \n");
                kSql.append("                                     FROM   T_BD_CostObject co \n");
                kSql.append("                                     WHERE  " + TMP_NCM_STDCostDiffRpt + ".FCostObjectID = co.FID \n");
                kSql.append("                                            AND co.FRelatedType IN (0)) \n");
                kSql.append(" where  FParentMaterialID is null \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FStdTotalAmount,FStdTotalQty) =  \n");
                kSql.append(" \t\t\t\t(SELECT DISTINCT \n");
                kSql.append("         \t\t\t\tround(stdMatDetail.FChildAmount * " + TMP_NCM_STDCostDiffRpt + ".FCostObjectQty," + this.currencyPrecision + "), \n");
                kSql.append(" \t\t\t\t        (CASE WHEN stdMatDetail.FChildAmount IS NULL OR stdMatDetail.FChildAmount = 0 THEN NULL \n");
                kSql.append(" \t\t\t\t             ELSE stdMatDetail.FChildQty \n");
                kSql.append(" \t\t\t\t        END) * " + TMP_NCM_STDCostDiffRpt + ".FCostObjectQty AS FStdTotalQty \n");
                kSql.append("  \t\t\t\tFROM   " + T_NCM_STDCostDataMatDetail + " stdMatDetail \n");
                kSql.append("         \t\t\t\tINNER JOIN T_BD_MeasureUnit mu \n");
                kSql.append("           \t\t\t\tON stdMatDetail.FMeasureUnitID = mu.FID \n");
                kSql.append("  \t\t\t\tWHERE  stdMatDetail.FEstimateSchemeID = " + TMP_NCM_STDCostDiffRpt + ".FSchemeID \n");
                kSql.append("         \t\t\t\tAND stdMatDetail.FParentMaterialID = " + TMP_NCM_STDCostDiffRpt + ".FParentMaterialID \n");
                kSql.append("         \t\t\t\tAND stdMatDetail.FMaterialID = " + TMP_NCM_STDCostDiffRpt + ".FMaterialID \n");
                kSql.append("         \t\t\t\tAND stdMatDetail.FChildCostItemID = " + TMP_NCM_STDCostDiffRpt + ".FCostItemID) \n");
                kSql.append(" WHERE  EXISTS (SELECT fid \n");
                kSql.append("                FROM   " + T_NCM_STDCostDataMatDetail + " stdMatDetail \n");
                kSql.append("                WHERE  stdMatDetail.FEstimateSchemeID = " + TMP_NCM_STDCostDiffRpt + ".FSchemeID \n");
                kSql.append("                       AND stdMatDetail.FParentMaterialID = " + TMP_NCM_STDCostDiffRpt + ".FParentMaterialID \n");
                kSql.append("                       AND stdMatDetail.FMaterialID = " + TMP_NCM_STDCostDiffRpt + ".FMaterialID \n");
                kSql.append("                       AND stdMatDetail.FChildCostItemID = " + TMP_NCM_STDCostDiffRpt + ".FCostItemID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FMeasureUnitName) =  \n");
                kSql.append(" \t\t\t\t(SELECT DISTINCT \n");
                kSql.append("         \t\t\t\tunit.FName_l2 \n");
                kSql.append("  \t\t\t\tFROM  T_BD_MeasureUnit unit \n");
                kSql.append("  \t\t\t\tinner join T_Bd_Material mat on mat.FBaseUnit =  unit.Fid  \n");
                kSql.append("         \t\tWhere " + TMP_NCM_STDCostDiffRpt + ".FMaterialID = mat.FID)");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FMeasureUnitName) =  \n");
                kSql.append(" \t\t\t\t(SELECT DISTINCT \n");
                kSql.append("         \t\t\t\tunit.FName_l2 \n");
                kSql.append("  \t\t\t\tFROM  T_BD_MeasureUnit unit \n");
                kSql.append("  \t\t\t\tinner join T_NCM_CostItem ci on ci.FUnitID =  unit.Fid  \n");
                kSql.append("         \t\tWhere " + TMP_NCM_STDCostDiffRpt + ".FCostItemID = ci.FID)");
                kSql.append("         \t\tWhere FMeasureUnitName is null or FMeasureUnitName = ''");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET     \n");
                kSql.append(" (FStdTotalAmount,FStdTotalQty) =  \n");
                kSql.append(" ( \n");
                kSql.append(" \t   SELECT \n");
                kSql.append(" \t   round(" + TMP_NCM_STDCostDiffRpt + ".FCostObjectQty * t.FStdTotalAmount," + this.currencyPrecision + "), \n");
                kSql.append(" \t   " + TMP_NCM_STDCostDiffRpt + ".FCostObjectQty * t.FStdTotalQty \n");
                kSql.append(" \t   from ( \n");
                kSql.append(" \t       SELECT \n");
                kSql.append(" \t       resDetail.FEstimateSchemeID, resDetail.FParentMaterialID, resDetail.FResCostItemID, \n");
                kSql.append(" \t       sum(resDetail.FResAmount) as FStdTotalAmount, sum(resDetail.FResQty) as FStdTotalQty \n");
                kSql.append(" \t       from " + T_NCM_STDCostDataResDetail + " resDetail \n");
                kSql.append(" \t       group by resDetail.FEstimateSchemeID, resDetail.FParentMaterialID, resDetail.FResCostItemID \n");
                kSql.append(" \t   ) t \n");
                kSql.append(" \t   where \n");
                kSql.append(" \t   t.FEstimateSchemeID = " + TMP_NCM_STDCostDiffRpt + ".FSchemeID \n");
                kSql.append(" \t   and \n");
                kSql.append(" \t   t.FParentMaterialID = " + TMP_NCM_STDCostDiffRpt + ".FParentMaterialID \n");
                kSql.append(" \t   and \n");
                kSql.append(" \t   t.FResCostItemID = " + TMP_NCM_STDCostDiffRpt + ".FCostItemID \n");
                kSql.append(" ) \n");
                kSql.append(" where FMaterialID IS NULL \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FQtyDecimal,FPriceDecimal) = (SELECT isnull(mu.FQtyPrecision, 2), \n");
                kSql.append("                                              cm.FPricePrecision \n");
                kSql.append("                                       FROM   T_BD_Material cm \n");
                kSql.append("                                              LEFT OUTER JOIN T_BD_MultiMeasureUnit mu \n");
                kSql.append("                                                ON mu.FMaterialID = cm.FID and mu.FMeasureUnitID = cm.FBaseUnit \n");
                kSql.append("                                       WHERE  cm.FID = " + TMP_NCM_STDCostDiffRpt + ".FMaterialID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FTotalDiff = ISNULL(FActTotalAmount, 0) - ISNULL(FStdTotalAmount, 0) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FTotalDiffRate = 100*(ISNULL(FActTotalAmount, 0) - FStdTotalAmount) / FStdTotalAmount \n");
                kSql.append(" WHERE  FStdTotalAmount IS NOT NULL \n");
                kSql.append("        AND FStdTotalAmount <> 0 \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append("     FActUnitQty = FActTotalQty / FCostObjectQty \n");
                kSql.append("\n");
                kSql.append("WHERE\n");
                kSql.append("\tFActTotalQty IS NOT NULL \n");
                kSql.append("\tAND FCostObjectQty IS NOT NULL \n");
                kSql.append("\tAND FCostObjectQty <> 0 \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append("     FActUnitPrice = FActTotalAmount / FActTotalQty \n");
                kSql.append("\n");
                kSql.append("WHERE\n");
                kSql.append("\tFActTotalAmount IS NOT NULL \n");
                kSql.append("\tAND FActTotalQty IS NOT NULL \n");
                kSql.append("\tAND FActTotalQty <> 0\n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append("     FStdUnitQty = FStdTotalQty / FCostObjectQty \n");
                kSql.append("\n");
                kSql.append("WHERE\n");
                kSql.append("\tFStdTotalQty IS NOT NULL \n");
                kSql.append("\tAND FCostObjectQty IS NOT NULL \n");
                kSql.append("\tAND FCostObjectQty <> 0 \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append("     FStdUnitPrice = FStdTotalAmount / FStdTotalQty \n");
                kSql.append("\n");
                kSql.append("WHERE\n");
                kSql.append("\tFStdTotalAmount IS NOT NULL \n");
                kSql.append("\tAND FStdTotalQty IS NOT NULL \n");
                kSql.append("\tAND FStdTotalQty <> 0\n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append(" FUnitQtyDiff = ROUND(TO_DECIMAL(ISNULL(FActUnitQty, 0) - ISNULL(FStdUnitQty, 0), 21, 12),FQtyDecimal) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append(" FQtyDiff = FStdUnitPrice * FUnitQtyDiff * FCostObjectQty \n");
                kSql.append("WHERE\n");
                kSql.append("\tFStdUnitPrice IS NOT NULL \n");
                kSql.append("\tAND FUnitQtyDiff IS NOT NULL \n");
                kSql.append("\tAND FCostObjectQty IS NOT NULL \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append(" FQtyDiffRate = 100 * (ISNULL(FQtyDiff, 0) / FStdTotalAmount) \n");
                kSql.append("WHERE\n");
                kSql.append("\tFStdTotalAmount IS NOT NULL \n");
                kSql.append("\tAND FStdTotalAmount <> 0 \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append(" FUnitPriceDiff = ISNULL(FActUnitPrice, 0) - ISNULL(FStdUnitPrice, 0) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append(" FPriceDiff = ISNULL(FTotalDiff, 0) -  ISNULL(FQtyDiff, 0) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET \n");
                kSql.append(" FPriceDiffRate = 100 * (FPriceDiff / FStdTotalAmount) \n");
                kSql.append("WHERE\n");
                kSql.append("\tFPriceDiff IS NOT NULL \n");
                kSql.append("\tAND FStdTotalAmount IS NOT NULL \n");
                kSql.append("\tAND FStdTotalAmount <> 0 \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                if (divMatBatch) {
                    kSql.setLength(0);
                    String[] fields = new String[]{"FTotalDiff", "FTotalDiffRate", "FActUnitQty", "FStdUnitQty", "FUnitQtyDiff", "FQtyDiff", "FQtyDiffRate", "FActUnitPrice", "FStdUnitPrice", "FUnitPriceDiff", "FPriceDiff", "FPriceDiffRate"};
                    for (i = 0; i < fields.length; ++i) {
                        kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                        kSql.append(" SET \n");
                        kSql.append(" " + fields[i] + " =  \n");
                        kSql.append(" (select diffRpt." + fields[i] + " from " + TMP_NCM_STDCostDiffRpt + " diffRpt \n");
                        kSql.append("WHERE\n");
                        kSql.append("\tdiffRpt.FPeriodID = " + TMP_NCM_STDCostDiffRpt + ".FPeriodID \n");
                        kSql.append("\tAND \n");
                        kSql.append("\tdiffRpt.FCostCenterID = " + TMP_NCM_STDCostDiffRpt + ".FCostCenterID \n");
                        kSql.append("\tAND \n");
                        kSql.append("\tdiffRpt.FCostObjectID = " + TMP_NCM_STDCostDiffRpt + ".FCostObjectID \n");
                        kSql.append("\tAND \n");
                        kSql.append("\tdiffRpt.FCostItemID = " + TMP_NCM_STDCostDiffRpt + ".FCostItemID \n");
                        kSql.append("\tAND \n");
                        kSql.append("\tdiffRpt.FMaterialID = " + TMP_NCM_STDCostDiffRpt + ".FMaterialID \n");
                        kSql.append("\tAND \n");
                        kSql.append("\tdiffRpt.FSpecFlag = 3 \n");
                        kSql.append("\t) \n");
                        kSql.append("\tWHERE FSpecFlag = 2; \n");
                    }
                    NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
                }
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET FQtyDecimal = 2, FPriceDecimal = 2, FAmountDecimal = " + this.currencyPrecision + " \n");
                kSql.append(" WHERE  FActTotalAmount IS NULL AND FStdTotalAmount IS NULL \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET FQtyDecimal = 2, FPriceDecimal = 2, FAmountDecimal = " + this.currencyPrecision + " \n");
                kSql.append(" WHERE (FActTotalQty IS NULL OR FActTotalQty = 0) AND (FStdTotalQty IS NULL OR FStdTotalQty = 0) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET FItemType = (SELECT to_decimal(FItemType) FROM T_NCM_CostItem WHERE FID = " + TMP_NCM_STDCostDiffRpt + ".FCostItemID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
                for (i = 0; i < list.size(); ++i) {
                    HashMap map = (HashMap)list.get(list.size() - i - 1);
                    String fields = (String)map.get("groupby");
                    boolean sumUnitQty = false;
                    if (fields.endsWith("FCostItemID") || fields.endsWith("FMaterialID")) {
                        sumUnitQty = true;
                    }
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + TMP_NCM_STDCostDiffRpt + " \n");
                    kSql.append("   (FTotalRow, \n");
                    kSql.append("    FTotalRow2, \n");
                    kSql.append("    " + fields + ",");
                    kSql.append("    FQtyDecimal, \n");
                    kSql.append("    FPriceDecimal, \n");
                    kSql.append("    FAmountDecimal, \n");
                    kSql.append("    FRateDecimal, \n");
                    kSql.append("    FActTotalAmount, \n");
                    kSql.append("    FStdTotalAmount, \n");
                    kSql.append("    FTotalDiff, \n");
                    kSql.append("    FTotalDiffRate, \n");
                    if (sumUnitQty) {
                        kSql.append("    FActUnitQty, \n");
                        kSql.append("    FStdUnitQty, \n");
                        kSql.append("    FUnitQtyDiff, \n");
                    }
                    kSql.append("    FQtyDiff, \n");
                    kSql.append("    FQtyDiffRate, \n");
                    kSql.append("    FPriceDiff, \n");
                    kSql.append("    FPriceDiffRate \n");
                    kSql.append("    ) \n");
                    kSql.append("   SELECT 0,\n");
                    kSql.append("          " + map.get("totalrow").toString() + ", \n");
                    kSql.append("          " + fields + ",");
                    kSql.append("          ISNULL(MAX(FQtyDecimal), 2),\n");
                    kSql.append("          ISNULL(MAX(FPriceDecimal), 2), \n");
                    kSql.append("          ISNULL(MAX(FAmountDecimal), " + this.currencyPrecision + "), \n");
                    kSql.append("          ISNULL(MAX(FRateDecimal), 2), \n");
                    kSql.append("          ROUND(SUM(FActTotalAmount),6), \n");
                    kSql.append("          ROUND(SUM(FStdTotalAmount),6), \n");
                    kSql.append("          ROUND(SUM(ISNULL(FActTotalAmount, 0)) - SUM(ISNULL(FStdTotalAmount, 0)), 6), \n");
                    kSql.append("          CASE WHEN SUM(ISNULL(FStdTotalAmount, 0)) = 0 THEN NULL \n");
                    kSql.append("               ELSE TO_DECIMAL(100*((SUM(ISNULL(FActTotalAmount, 0)) - SUM(ISNULL(FStdTotalAmount, 0)))/ SUM(ISNULL(FStdTotalAmount, 0))),21,8) \n");
                    kSql.append("          END, \n");
                    if (sumUnitQty) {
                        kSql.append("          ROUND(SUM(FActUnitQty),6), \n");
                        kSql.append("          ROUND(SUM(FStdUnitQty),6), \n");
                        kSql.append("          ROUND(SUM(FUnitQtyDiff),6), \n");
                    }
                    kSql.append("          ROUND(SUM(FQtyDiff),6), \n");
                    kSql.append("          CASE WHEN SUM(ISNULL(FStdTotalAmount, 0)) = 0 THEN NULL \n");
                    kSql.append("               ELSE TO_DECIMAL(100*(SUM(ISNULL(FQtyDiff, 0)) / SUM(ISNULL(FStdTotalAmount, 0))),21,8) \n");
                    kSql.append("          END, \n");
                    kSql.append("          ROUND(SUM(FPriceDiff),6), \n");
                    kSql.append("          CASE WHEN SUM(ISNULL(FStdTotalAmount, 0)) = 0 THEN NULL \n");
                    kSql.append("               ELSE 100 * (SUM(ISNULL(FPriceDiff, 0)) / SUM(ISNULL(FStdTotalAmount, 0))) \n");
                    kSql.append("          END \n");
                    kSql.append("     FROM " + TMP_NCM_STDCostDiffRpt + " \n");
                    kSql.append("    WHERE FTotalRow2 = 0 AND FSpecFlag <> 2\n");
                    if (fields.endsWith("FMaterialID")) {
                        kSql.append("    AND FItemType = 1 \n");
                    }
                    kSql.append("     GROUP BY " + fields + "\n");
                    DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                }
                kSql.setLength(0);
                kSql.append(" INSERT INTO " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append("   (FTotalRow, \n");
                kSql.append("    FTotalRow2, \n");
                kSql.append("    FQtyDecimal, \n");
                kSql.append("    FPriceDecimal, \n");
                kSql.append("    FAmountDecimal, \n");
                kSql.append("    FRateDecimal, \n");
                kSql.append("    FActTotalAmount, \n");
                kSql.append("    FStdTotalAmount, \n");
                kSql.append("    FTotalDiff, \n");
                kSql.append("    FTotalDiffRate, \n");
                kSql.append("    FQtyDiff, \n");
                kSql.append("    FQtyDiffRate, \n");
                kSql.append("    FPriceDiff, \n");
                kSql.append("    FPriceDiffRate \n");
                kSql.append("    ) \n");
                kSql.append("   SELECT 1,\n");
                kSql.append("          200, \n");
                kSql.append("          ISNULL(MAX(FQtyDecimal), 2),\n");
                kSql.append("          ISNULL(MAX(FPriceDecimal), 2), \n");
                kSql.append("          ISNULL(MAX(FAmountDecimal), " + this.currencyPrecision + "), \n");
                kSql.append("          ISNULL(MAX(FRateDecimal), 2), \n");
                kSql.append("          ROUND(SUM(FActTotalAmount),6), \n");
                kSql.append("          ROUND(SUM(FStdTotalAmount),6), \n");
                kSql.append("          ROUND(SUM(ISNULL(FActTotalAmount, 0)) - SUM(ISNULL(FStdTotalAmount, 0)), 6), \n");
                kSql.append("          CASE WHEN SUM(ISNULL(FStdTotalAmount, 0)) = 0 THEN NULL \n");
                kSql.append("               ELSE TO_DECIMAL(100*((SUM(ISNULL(FActTotalAmount, 0)) - SUM(ISNULL(FStdTotalAmount, 0)))/ SUM(ISNULL(FStdTotalAmount, 0))),21,8) \n");
                kSql.append("          END, \n");
                kSql.append("          ROUND(SUM(FQtyDiff),6), \n");
                kSql.append("          CASE WHEN SUM(ISNULL(FStdTotalAmount, 0)) = 0 THEN NULL \n");
                kSql.append("               ELSE TO_DECIMAL(100*(SUM(ISNULL(FQtyDiff, 0)) / SUM(ISNULL(FStdTotalAmount, 0))),21,8) \n");
                kSql.append("          END, \n");
                kSql.append("          ROUND(SUM(FPriceDiff),6), \n");
                kSql.append("          CASE WHEN SUM(ISNULL(FStdTotalAmount, 0)) = 0 THEN NULL \n");
                kSql.append("               ELSE 100 * (SUM(ISNULL(FPriceDiff, 0)) / SUM(ISNULL(FStdTotalAmount, 0))) \n");
                kSql.append("          END \n");
                kSql.append("     FROM " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append("    WHERE FTotalRow2 = 0  AND FSpecFlag <> 2\n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                if (divMatBatch) {
                    kSql.setLength(0);
                    kSql.append(" delete from " + TMP_NCM_STDCostDiffRpt + " where FSpecFlag = 3 \n");
                    DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                }
                Context ctx = this.getContext();
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FPeriodNumber,FPeriodName) = \n");
                kSql.append(" \t\t\t  (SELECT (TO_CHAR(prd.FPeriodYear) || '.' || TO_CHAR(prd.FPeriodNumber)),\n");
                kSql.append("              \t\t  (TO_CHAR(prd.FPeriodYear) || '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"0_STDCostDiffReport", (Locale)ctx.getLocale()) + "' || TO_CHAR(prd.FPeriodNumber)) || '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"1_STDCostDiffReport", (Locale)ctx.getLocale()) + "' \n");
                kSql.append("         \t\t FROM T_BD_Period prd\n");
                kSql.append("         \t\tWHERE prd.FID = " + TMP_NCM_STDCostDiffRpt + ".FPeriodID \n");
                kSql.append("        \t\t) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FCostCenterNumber,FCostCenterName)\n");
                kSql.append(" \t\t\t\t= (SELECT cc.FNumber,cc.FName_" + locale.getLanguage() + " \n");
                kSql.append("                    FROM T_ORG_CostCenter cc \n");
                kSql.append("                   WHERE cc.FID = " + TMP_NCM_STDCostDiffRpt + ".FCostCenterID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FCostObjectQty = (SELECT maxData.matQty \n");
                kSql.append("                          FROM   ((SELECT   MAX(ISNULL(FCostObjectQty,0)) matQty, \n");
                kSql.append("                                            FCostObjectID, \n");
                kSql.append("                                            FCostCenterID \n");
                kSql.append("                                   FROM     " + TMP_NCM_STDCostDiffRpt + " diffRpt \n");
                kSql.append("                                   GROUP BY FCostObjectID,FCostCenterID)) maxData \n");
                kSql.append("                          WHERE  maxData.FCostObjectID = " + TMP_NCM_STDCostDiffRpt + ".FCostObjectID \n");
                kSql.append("                            AND  maxData.FCostCenterID = " + TMP_NCM_STDCostDiffRpt + ".FCostCenterID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FSchemeNumber,FSchemeName)\n");
                kSql.append(" \t\t\t\t= (SELECT scheme.FNumber,scheme.FName_" + locale.getLanguage() + " \n");
                kSql.append("                    FROM T_NCM_SCEstimateScheme scheme\n");
                kSql.append("                   WHERE scheme.FID = " + TMP_NCM_STDCostDiffRpt + ".FSchemeID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FCostObjectNumber,FCostObjectName,FBatchNo)\n");
                kSql.append(" \t\t\t\t= (SELECT co.FNumber,co.FName_" + locale.getLanguage() + ",co.FBatchNumber \n");
                kSql.append("                    FROM T_BD_CostObject co \n");
                kSql.append("                   WHERE co.FID = " + TMP_NCM_STDCostDiffRpt + ".FCostObjectID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FParentMaterialNumber,FParentMaterialName,FModel)\n");
                kSql.append(" \t\t\t\t= (SELECT mat.FNumber,mat.FName_" + locale.getLanguage() + ",mat.FModel \n");
                kSql.append("                    FROM T_BD_Material mat \n");
                kSql.append("                   WHERE mat.FID = " + TMP_NCM_STDCostDiffRpt + ".FParentMaterialID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FCostItemNumber,FCostItemName)\n");
                kSql.append(" \t\t\t\t= (SELECT ci.FNumber,ci.FName_" + locale.getLanguage() + " \n");
                kSql.append("                    FROM T_NCM_CostItem ci \n");
                kSql.append("                   WHERE ci.FID = " + TMP_NCM_STDCostDiffRpt + ".FCostItemID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FMaterialNumber,FMaterialName, FMaterialModel) \n");
                kSql.append(" \t\t= (SELECT mat.FNumber,mat.FName_" + locale.getLanguage() + ", mat.FModel \n");
                kSql.append("            FROM  T_BD_Material mat\n");
                kSql.append("           WHERE  mat.FID = " + TMP_NCM_STDCostDiffRpt + ".FMaterialID \n");
                kSql.append("          ) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FMaterialNumber,FMaterialName) \n");
                kSql.append(" \t\t= (SELECT resType.FNumber,resType.FName_" + locale.getLanguage() + " \n");
                kSql.append("            FROM  T_NCM_SCResourceType resType\n");
                kSql.append("           WHERE  resType.FID = " + TMP_NCM_STDCostDiffRpt + ".FMaterialID \n");
                kSql.append("          ) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FQtyDecimal,FPriceDecimal) = (SELECT isnull(mu.FQtyPrecision, 2), \n");
                kSql.append("                                              cm.FPricePrecision \n");
                kSql.append("                                       FROM   T_BD_Material cm \n");
                kSql.append("                                              LEFT OUTER JOIN T_BD_MultiMeasureUnit mu \n");
                kSql.append("                                                ON mu.FMaterialID = cm.FID and mu.FMeasureUnitID = cm.FBaseUnit \n");
                kSql.append("                                       WHERE  cm.FID = " + TMP_NCM_STDCostDiffRpt + ".FMaterialID) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FQtyDecimal,FPriceDecimal) = (SELECT isnull(mu.FQtyPrecision, 2), \n");
                kSql.append("                                              ci.FPricePrecision \n");
                kSql.append("                                       FROM   T_NCM_CostItem ci \n");
                kSql.append("                                              LEFT OUTER JOIN T_BD_MeasureUnit mu \n");
                kSql.append("                                                ON mu.FID = ci.FUnitID \n");
                kSql.append("                                       WHERE  ci.FID = " + TMP_NCM_STDCostDiffRpt + ".FCostItemID and ci.FItemType <> '1' ) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    (FAmountDecimal) = (SELECT ISNULL(pm.FPricePrecision,6) \n");
                kSql.append("                          FROM   T_BD_Material pm \n");
                kSql.append("                          WHERE  pm.FID = " + TMP_NCM_STDCostDiffRpt + ".FParentMaterialID) \n");
                kSql.setLength(0);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    HashMap map = (HashMap)list.get(i2);
                    String field = (String)map.get("id");
                    String fieldName = field.substring(0, field.length() - 2) + "Name";
                    String fieldNumber = field.substring(0, field.length() - 2) + "Number";
                    String whichTotal = "";
                    if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                        whichTotal = ", FTotalPeriodRow = 1 ";
                    }
                    if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                        whichTotal = ", FTotalCostCenterRow = 1 ";
                    }
                    if (fieldNumber.equalsIgnoreCase("FCostObjectNumber")) {
                        whichTotal = ", FTotalCostObjectRow = 1 ";
                    }
                    if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                        whichTotal = ", FTotalCostItemRow = 1 ";
                    }
                    if (fieldNumber.equalsIgnoreCase("FSchemeNumber")) {
                        whichTotal = ", FTotalSchemeRow = 1 ";
                    }
                    if (fieldNumber.equalsIgnoreCase("FParentMaterialNumber")) {
                        whichTotal = ", FTotalParentMaterialRow = 1 ";
                    }
                    if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                        whichTotal = ", FTotalMaterialRow = 1 ";
                    }
                    kSql.append(" update " + TMP_NCM_STDCostDiffRpt + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"2_STDCostDiffReport", (Locale)ctx.getLocale()) + "'," + fieldNumber + " = " + fieldNumber);
                    kSql.append(whichTotal);
                    kSql.append(" where FTotalRow2 = ").append(map.get("totalrow")).append("\n");
                    kSql.append(";");
                }
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FModel = ''\n");
                kSql.append(" where FTotalParentMaterialRow <> 0 \n;");
                NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
                String[] sumFields = this.getSumFields(filter);
                if (sumFields != null) {
                    kSql.setLength(0);
                    kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + "\n");
                    String totalfield = sumFields[0];
                    if ("FPeriodNumber".equalsIgnoreCase(totalfield)) {
                        totalfield = "FPeriodName";
                    }
                    kSql.append("    SET " + totalfield + " = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"3_STDCostDiffReport", (Locale)ctx.getLocale()) + "', \n");
                    kSql.append("        FTotalRow2 = 200 \n");
                    kSql.append("  WHERE FTotalRow = 1 \n");
                    DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                }
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_NCM_STDCostDiffRpt + " \n");
                kSql.append(" SET    FAmountDecimal = 6 \n");
                kSql.append(" WHERE\u3000FAmountDecimal IS NULL \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                DbUtil.execute((Context)this.getContext(), (String)(" delete from " + TMP_NCM_STDCostDiffRpt + " where (FActTotalAmount IS NULL OR FActTotalAmount = 0 ) AND (FStdTotalAmount IS NULL OR FStdTotalAmount = 0 )"));
                if (T_TMP_CostObject == null) break block48;
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            try {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(T_TMP_CostObject);
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
            }
        }
        if (conn == null) return TMP_NCM_STDCostDiffRpt;
        SQLUtils.cleanup((Connection)conn);
        return TMP_NCM_STDCostDiffRpt;
        finally {
            if (T_TMP_CostObject != null) {
                try {
                    TempTablePool.getInstance((Context)this.getContext()).releaseTable(T_TMP_CostObject);
                }
                catch (Exception exc) {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                }
            }
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private String buildSelectSql(RptParams filter, String tablename) {
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            orderBy.append(fieldNumber);
            orderBy.append(",");
        }
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        orderBy = this.getOrderByFields((ArrayList)filter.getObject("table"), orderByMode);
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" SELECT * \n");
        kSql.append("   FROM " + tablename + " \n");
        kSql.append(where);
        kSql.append("  ORDER BY \n");
        kSql.append("\t\tFTotalRow ");
        kSql.append(orderByMode + ",");
        kSql.append("  \t\t" + orderBy + " \n");
        kSql.append("  \t\tFTotalRow2 \n");
        return kSql.toString();
    }

    private void insertActMatDetail(String TMP_NCM_STDCostDiffRpt, String T_NCM_CostCalMatDetailResult, String companyId, String periodId, String estimateSchemeId, boolean divMatBatch, RptParams filter, int FSpecFlag) throws Exception {
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" INSERT INTO " + TMP_NCM_STDCostDiffRpt + " \n");
        kSql.append(" \t   (FPeriodID, \n");
        kSql.append("  \t\tFPeriodNumber, \n");
        kSql.append("  \t\tFPeriodName, \n");
        kSql.append("  \t\tFCostCenterID, \n");
        kSql.append("  \t\tFCostCenterNumber, \n");
        kSql.append("  \t\tFCostCenterName, \n");
        kSql.append("  \t\tFSchemeID, \n");
        kSql.append("  \t\tFSchemeNumber, \n");
        kSql.append("  \t\tFSchemeName, \n");
        kSql.append("  \t\tFCostObjectID, \n");
        kSql.append("  \t\tFCostObjectNumber, \n");
        kSql.append("  \t\tFCostObjectName, \n");
        kSql.append("  \t\tFBatchNo, \n");
        kSql.append("  \t\tFParentMaterialID, \n");
        kSql.append("  \t\tFParentMaterialNumber, \n");
        kSql.append("  \t\tFParentMaterialName, \n");
        kSql.append("  \t\tFModel, \n");
        kSql.append("  \t\tFCostObjectQty, \n");
        kSql.append("  \t\tFCostItemID, \n");
        kSql.append("  \t\tFCostItemNumber, \n");
        kSql.append("  \t\tFCostItemName, \n");
        kSql.append("  \t\tFMaterialID, \n");
        kSql.append("  \t\tFMaterialNumber, \n");
        kSql.append("  \t\tFMaterialName, \n");
        kSql.append("  \t\tFMeasureUnitName, \n");
        if (divMatBatch) {
            kSql.append("  \t\tFLot, \n");
        }
        kSql.append("  \t\tFTotalRow, \n");
        kSql.append("  \t\tFTotalRow2, \n");
        kSql.append("  \t\tFQtyDecimal, \n");
        kSql.append("  \t\tFPriceDecimal, \n");
        kSql.append("  \t\tFAmountDecimal, \n");
        kSql.append("  \t\tFRateDecimal, \n");
        kSql.append("  \t\tFSpecFlag, \n");
        kSql.append("  \t\tFActTotalAmount, \n");
        kSql.append("  \t\tFActTotalQty, \n");
        kSql.append("  \t\tFIsTotalRow, \n");
        kSql.append("  \t\tFDataFlag\n");
        kSql.append("  \t\t) \n");
        kSql.append("SELECT actMatDetail.FCalculatePeriodID AS FPeriodID, \n");
        kSql.append(" \t    NULL AS FPeriodNumber, \n");
        kSql.append("\t\tNULL AS FPeriodName, \n");
        kSql.append(" \t\tactMatDetail.FCostCenterID AS FCostCenterID, \n");
        kSql.append(" \t\tNULL AS FCostCenterNumber, \n");
        kSql.append(" \t\tNULL AS FCostCenterName, \n");
        kSql.append(" \t\t'" + estimateSchemeId + "' AS FSchemeID, \n");
        kSql.append(" \t\tNULL AS FSchemeNumber, \n");
        kSql.append(" \t\tNULL AS FSchemeName, \n");
        kSql.append(" \t\tactMatDetail.FCostObjectID AS FCostObjectID, \n");
        kSql.append(" \t\tNULL AS FCostObjectNumber, \n");
        kSql.append(" \t\tNULL AS FCostObjectName, \n");
        kSql.append(" \t\tISNULL(co.FBatchNumber,' ') AS FBatchNo, \n");
        kSql.append(" \t\tNULL AS FParentMaterialID, \n");
        kSql.append(" \t\tNULL AS FParentMaterialNumber, \n");
        kSql.append(" \t\tNULL AS FParentMaterialName, \n");
        kSql.append(" \t\tNULL AS FModel, \n");
        kSql.append("  \t\t0 AS FCostObjectQty, \n");
        kSql.append(" \t\tactMatDetail.FCostItemID AS FCostItemID, \n");
        kSql.append(" \t\tNULL AS FCostItemNumber, \n");
        kSql.append(" \t\tNULL AS FCostItemName, \n");
        kSql.append(" \t\tactMatDetail.FMaterialID AS FMaterialID, \n");
        kSql.append(" \t\tNULL AS FMaterialNumber, \n");
        kSql.append(" \t\tNULL AS FMaterialName, \n");
        kSql.append(" \t\tNULL AS FMeasureUnitName, \n");
        if (divMatBatch) {
            kSql.append(" \t\tactMatDetail.FLot AS FLot, \n");
        }
        kSql.append(" \t\t0 AS FTotalRow, \n");
        kSql.append(" \t\t0 AS FTotalRow2, \n");
        kSql.append(" \t\t6 AS FQtyDecimal, \n");
        kSql.append(" \t\t6 AS FPriceDecimal, \n");
        kSql.append(" \t\t" + this.currencyPrecision + " AS FAmountDecimal, \n");
        kSql.append(" \t\t2 AS FRateDecimal, \n");
        kSql.append(" \t\t" + FSpecFlag + " AS FSpecFlag, \n");
        if (divMatBatch) {
            kSql.append(" \t\tactMatDetail.FFinishedAmount AS FActTotalAmount, \n");
            kSql.append(" \t\tactMatDetail.FFinishedQty AS FActTotalQty, \n");
        } else {
            kSql.append(" \t\tsum(actMatDetail.FFinishedAmount) AS FActTotalAmount, \n");
            kSql.append(" \t\tsum(actMatDetail.FFinishedQty) AS FActTotalQty, \n");
        }
        kSql.append("      0 AS FIsTotalRow, \n");
        kSql.append("      1 AS FDataFlag \n");
        kSql.append(" FROM   " + T_NCM_CostCalMatDetailResult + " actMatDetail \n");
        if (this.isFilterCostCenter(filter)) {
            kSql.append("  \tLEFT OUTER JOIN  T_ORG_CostCenter cc on  actMatDetail.FCostCenterID = cc.FID \n");
        }
        kSql.append("  \tLEFT OUTER JOIN  T_BD_CostObject co on  actMatDetail.FCostObjectID = co.FID \n");
        if (this.isFilterCostItem(filter)) {
            kSql.append("  \tLEFT OUTER JOIN  T_NCM_CostItem ci on  actMatDetail.FCostItemID = ci.FID \n");
        }
        kSql.append("WHERE  actMatDetail.FCalculatePeriodID = '" + periodId + "' \n");
        kSql.append("  AND  actMatDetail.FCompanyID = '" + companyId + "' \n");
        kSql.append("  AND  (actMatDetail.FFinishedAmount <> 0 OR actMatDetail.FFinishedQty <> 0) \n");
        if (this.isFilterCostCenter(filter)) {
            kSql.append("  AND cc.FNumber in (" + this.filterCostCenter(filter) + ") \n");
        }
        if (this.isFilterCostObject(filter)) {
            kSql.append("  AND co.FNumber in (" + this.filterCostObject(filter) + ") \n");
        }
        if (this.isFilterCostItem(filter)) {
            kSql.append("  AND ci.FNumber in (" + this.filterCostItem(filter) + ") \n");
        }
        if (!divMatBatch) {
            kSql.append("\tgroup by \n");
            kSql.append("   \tactMatDetail.FCalculatePeriodID, \n");
            kSql.append("    \tactMatDetail.FCostCenterID, \n");
            kSql.append("    \tactMatDetail.FCostObjectID, \n");
            kSql.append("    \tco.FBatchNumber, \n");
            kSql.append("    \tactMatDetail.FCostItemID, \n");
            kSql.append("    \tactMatDetail.FMaterialID \n");
        }
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
    }

    protected boolean isFilterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenters");
        List list = this.split(costCenterNumbers);
        return list.size() > 0;
    }

    protected StringBuffer filterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenters");
        return BDCMUtils.splitPK((Collection)this.split(costCenterNumbers));
    }

    protected boolean isFilterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjects");
        List list = this.split(costObjectNumbers);
        return list.size() > 0;
    }

    protected StringBuffer filterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjects");
        return BDCMUtils.splitPK((Collection)this.split(costObjectNumbers));
    }

    protected boolean isFilterCostItem(RptParams filter) throws Exception {
        String costItemNumbers = filter.getString("costItems");
        List list = this.split(costItemNumbers);
        return list.size() > 0;
    }

    protected boolean isDivMatBatch(RptParams filter) throws Exception {
        return filter.getBoolean("divMatBatch");
    }

    protected StringBuffer filterCostItem(RptParams filter) throws Exception {
        String costItemNumbers = filter.getString("costItems");
        return BDCMUtils.splitPK((Collection)this.split(costItemNumbers));
    }

    private List split(String target) {
        ArrayList<String> list = new ArrayList<String>();
        if (target != null && target.length() > 0) {
            String[] strs = target.split(";");
            for (int i = 0; i < strs.length; ++i) {
                String temp = strs[i].trim();
                if (temp.length() <= 0) continue;
                list.add(temp);
            }
        }
        return list;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyOrg");
        String companyName = "";
        companyName = companyInfo == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : companyInfo.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"5_STDCostDiffReport", (Locale)ctx.getLocale()) + companyName);
        String year = filter.getString("year");
        String month = filter.getString("month");
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"6_STDCostDiffReport", (Locale)ctx.getLocale()) + year + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"0_STDCostDiffReport", (Locale)ctx.getLocale()) + month + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"1_STDCostDiffReport", (Locale)ctx.getLocale()));
        String costCenters = filter.getString("costCenters");
        String costCenterNumbers = "";
        costCenterNumbers = StringUtils.isEmpty((String)costCenters) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : costCenters.replaceAll(";", ",");
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"7_STDCostDiffReport", (Locale)ctx.getLocale()) + costCenterNumbers);
        STDCostEstimateSchemeInfo scheme = (STDCostEstimateSchemeInfo)filter.getObject("scheme");
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"8_STDCostDiffReport", (Locale)ctx.getLocale()) + scheme.getName());
        String costObjects = filter.getString("costObjects");
        String costObjectNumbers = "";
        costObjectNumbers = StringUtils.isEmpty((String)costObjects) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : costObjects.replaceAll(";", ",");
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"9_STDCostDiffReport", (Locale)ctx.getLocale()) + costObjectNumbers);
        String costItems = filter.getString("costItems");
        String costItemNumbers = "";
        costItemNumbers = StringUtils.isEmpty((String)costItems) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : costItems.replaceAll(";", ",");
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"10_STDCostDiffReport", (Locale)ctx.getLocale()) + costItemNumbers);
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        int i2;
        ReportHeader header = super.getReportHeader(reportID, filter);
        ArrayList childList = header.getChilds();
        ArrayList childChildList = null;
        Context ctx = this.getContext();
        ReportHeader childHeader = null;
        ReportHeader childChildHeader = null;
        String fieldNameTemp = null;
        String childFieldName = null;
        for (i2 = 0; i2 < childList.size(); ++i2) {
            childHeader = (ReportHeader)childList.get(i2);
            fieldNameTemp = childHeader.getFieldName();
            if (!fieldNameTemp.equals("FPeriodNumber")) continue;
            childList.remove(childHeader);
            break;
        }
        for (i2 = 0; i2 < childList.size(); ++i2) {
            int j;
            childHeader = (ReportHeader)childList.get(i2);
            fieldNameTemp = childHeader.getFieldName();
            if (fieldNameTemp.equals("FPeriodName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"14_STDCostDiffReportFilter2UI", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FSchemeNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"25_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FSchemeName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"26_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"40_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"41_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"29_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"30_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"31_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"42_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"43_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMeasureUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"34_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FBatchNo")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"44_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostObjectQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"45_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FParentMaterialNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"46_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FParentMaterialName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"47_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMaterialNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"27_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMaterialName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"28_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMeasureUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"34_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FLot")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"48_STDCostDiffReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FTotalDiffP")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"49_STDCostDiffReport", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FActTotalAmount")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"50_STDCostDiffReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FStdTotalAmount")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"51_STDCostDiffReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FTotalDiff")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"52_STDCostDiffReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FTotalDiffRate")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"53_STDCostDiffReport", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldNameTemp.equals("FQtyDiffP")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"54_STDCostDiffReport", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FActUnitQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"55_STDCostDiffReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FStdUnitQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"56_STDCostDiffReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitQtyDiff")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"57_STDCostDiffReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FQtyDiff")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"58_STDCostDiffReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FQtyDiffRate")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"59_STDCostDiffReport", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (!fieldNameTemp.equals("FPriceDiffP")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"60_STDCostDiffReport", (Locale)ctx.getLocale()));
            childChildList = childHeader.getChilds();
            for (j = 0; j < childChildList.size(); ++j) {
                childChildHeader = (ReportHeader)childChildList.get(j);
                childFieldName = childChildHeader.getFieldName();
                if (childFieldName.equals("FActUnitPrice")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"61_STDCostDiffReport", (Locale)ctx.getLocale()));
                    continue;
                }
                if (childFieldName.equals("FStdUnitPrice")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"62_STDCostDiffReport", (Locale)ctx.getLocale()));
                    continue;
                }
                if (childFieldName.equals("FUnitPriceDiff")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"63_STDCostDiffReport", (Locale)ctx.getLocale()));
                    continue;
                }
                if (childFieldName.equals("FPriceDiff")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"64_STDCostDiffReport", (Locale)ctx.getLocale()));
                    continue;
                }
                if (!childFieldName.equals("FPriceDiffRate")) continue;
                childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"65_STDCostDiffReport", (Locale)ctx.getLocale()));
            }
        }
        if (!this.isDivMatBatch(filter)) {
            ArrayList childs = header.getChilds();
            for (i = 0; i < childs.size(); ++i) {
                if (!"FLot".equalsIgnoreCase(((ReportHeader)childs.get(i)).getFieldName())) continue;
                childs.remove(i);
                break;
            }
        }
        ArrayList childs = header.getChilds();
        for (i = 0; i < childs.size(); ++i) {
            if (!"FMaterialName".equalsIgnoreCase(((ReportHeader)childs.get(i)).getFieldName())) continue;
            childHeader = new ReportHeader();
            childHeader.setFieldName("FMaterialModel");
            childHeader.setLevel(1);
            childHeader.setMergeable(true);
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"29_STDCostSumReport", (Locale)ctx.getLocale()));
            childs.add(i + 1, childHeader);
            break;
        }
        HashSet<String> orderFields = new HashSet<String>();
        Iterator it = groups.keySet().iterator();
        while (it.hasNext()) {
            String[] group = (String[])groups.get(it.next());
            orderFields.addAll(Arrays.asList(group));
        }
        ArrayList<String> orders = new ArrayList<String>();
        ArrayList table = (ArrayList)filter.getObject("table");
        for (int i3 = 0; i3 < table.size(); ++i3) {
            HashMap map = (HashMap)table.get(i3);
            String fieldID = (String)map.get("id");
            orders.add(fieldID);
        }
        if (orders.size() == 0) {
            return header;
        }
        HashMap<String, ReportHeader> orderFieldHeaders = new HashMap<String, ReportHeader>();
        childs = header.getChilds();
        for (int i4 = childs.size() - 1; i4 >= 0; --i4) {
            ReportHeader child = (ReportHeader)childs.get(i4);
            String fieldName = child.getFieldName();
            if (!orderFields.contains(fieldName)) continue;
            childs.remove(i4);
            orderFieldHeaders.put(fieldName, child);
        }
        ArrayList temp = new ArrayList();
        for (int i5 = 0; i5 < orders.size(); ++i5) {
            String[] group = (String[])groups.get(orders.get(i5));
            for (int k = 0; k < group.length; ++k) {
                if (orderFieldHeaders.get(group[k]) == null) continue;
                temp.add(orderFieldHeaders.get(group[k]));
            }
        }
        childs.addAll(0, temp);
        return header;
    }

    private String[] getSumFields(RptParams filter) {
        HashMap map;
        String fieldID;
        String[] group;
        ArrayList table = (ArrayList)filter.getObject("table");
        if (table.size() > 0 && (group = (String[])groups.get(fieldID = (String)(map = (HashMap)table.get(0)).get("id"))) != null && group.length >= 2) {
            return group;
        }
        return null;
    }

    protected ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }

    private StringBuffer getOrderByFields(ArrayList list, String sortModel) {
        StringBuffer checkedFields = new StringBuffer();
        StringBuffer uncheckedFields = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String fieldID = (String)map.get("id");
            String fieldNumber = fieldID.substring(0, fieldID.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                orderByWhichTotal = ",FTotalPeriodRow " + sortModel;
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ",FTotalCostCenterRow " + sortModel;
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectNumber")) {
                orderByWhichTotal = ",FTotalCostObjectRow " + sortModel;
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ",FTotalCostItemRow " + sortModel;
            }
            if (fieldNumber.equalsIgnoreCase("FSchemeNumber")) {
                orderByWhichTotal = ",FTotalSchemeRow " + sortModel;
            }
            if (fieldNumber.equalsIgnoreCase("FParentMaterialNumber")) {
                orderByWhichTotal = ",FTotalParentMaterialRow " + sortModel;
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                orderByWhichTotal = ",FTotalMaterialRow " + sortModel;
            }
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (checkedFields.length() > 0) {
                    checkedFields.append(",");
                }
                checkedFields.append(fieldNumber);
                checkedFields.append(orderByWhichTotal);
                continue;
            }
            if (uncheckedFields.length() > 0) {
                uncheckedFields.append(",");
            }
            uncheckedFields.append(fieldNumber);
            uncheckedFields.append(orderByWhichTotal);
        }
        if (checkedFields.length() > 0) {
            checkedFields.append(",");
        }
        if (uncheckedFields.length() > 0) {
            uncheckedFields.append(",");
        }
        checkedFields.append(uncheckedFields);
        return checkedFields;
    }

    private String getPeriodId(String year, String month, String companyId) throws BOSException {
        IRowSet rst = null;
        try {
            StringBuffer kSql = new StringBuffer();
            kSql.append(" select p.fid  \n");
            kSql.append("   from T_BD_Period p \n");
            kSql.append("        inner join t_bd_periodtype pt  \n");
            kSql.append("           on p.FTypeID = pt.FID \n");
            kSql.append("        inner join t_org_company fi  \n");
            kSql.append("           on fi.FAccountPeriodID = pt.FID  \n");
            kSql.append("  where p.FPeriodYear = ?  \n");
            kSql.append("    and p.FPeriodNumber = ? \n");
            kSql.append("    and fi.fid = ? \n");
            rst = DbUtil.executeQuery((Context)this.getContext(), (String)kSql.toString(), (Object[])new Object[]{Integer.valueOf(year), Integer.valueOf(month), companyId});
            if (rst.next()) {
                return rst.getString("FID");
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return null;
    }

    private int getPeriodNumber(String companyId, String periodYear, String periodNumber) throws EASBizException, BOSException {
        int number = 0;
        if (periodYear == null || periodNumber == null || periodYear.length() != 4 || periodNumber.length() != 1 && periodNumber.length() != 2) {
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
            number = currPeriod.getNumber();
            return number;
        }
        if (periodNumber.length() == 1) {
            periodNumber = "0" + periodNumber;
        }
        String temp = periodYear + periodNumber;
        number = new Integer(temp);
        return number;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow2", (Object)new BigDecimal(1), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow2", 1, (Object)new BigDecimal(200), a);
        return conditions;
    }

    static {
        groups.put("FPeriodID", new String[]{"FPeriodNumber", "FPeriodName"});
        groups.put("FCostCenterID", new String[]{"FCostCenterNumber", "FCostCenterName"});
        groups.put("FSchemeID", new String[]{"FSchemeNumber", "FSchemeName"});
        groups.put("FCostObjectID", new String[]{"FCostObjectNumber", "FCostObjectName", "FBatchNo", "FCostObjectQty"});
        groups.put("FParentMaterialID", new String[]{"FParentMaterialNumber", "FParentMaterialName", "FModel"});
        groups.put("FCostItemID", new String[]{"FCostItemNumber", "FCostItemName"});
        groups.put("FMaterialID", new String[]{"FMaterialNumber", "FMaterialName", "FMaterialModel", "FMeasureUnitName", "FLot"});
    }
}

