/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostSumReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)STDCostSumReport.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = null;
        try {
            IRowSet rs;
            tempTable = this.buildReportDataTempTable(filter);
            String ksql = this.buildSelectSql(filter, tempTable);
            IRowSet iRowSet = rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
            return iRowSet;
        }
        finally {
            if (tempTable != null) {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
            }
        }
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTempTable(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        String ksql = this.buildSelectSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql, (int)start, (int)rows);
        return rs;
    }

    protected String buildReportDataTempTable(RptParams filter) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = null;
        currCompany = filter.getObject("companyOrg") instanceof CompanyOrgUnitInfo ? (CompanyOrgUnitInfo)filter.getObject("companyOrg") : ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = currCompany.getId().toString();
        Locale locale = this.getContext().getLocale();
        String currCurrencyId = currCompany.getBaseCurrency().getId().toString();
        int amountPrecision = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currCurrencyId)).getPrecision();
        String TMP_NCM_STDCostData = null;
        String T_NCM_STDCostDataMatDetail = null;
        String T_NCM_STDCostDataResDetail = null;
        Connection conn = null;
        Object rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            StringBuffer kSql = new StringBuffer();
            kSql.append("create table TMP_NCM_STDCostData(");
            kSql.append(" \tFStorageOrgUnitID \t\tvarchar(44),");
            kSql.append(" \tFStorageOrgUnitNumber   varchar(80),");
            kSql.append(" \tFStorageOrgUnitName \tvarchar(255),");
            kSql.append(" \tFEstimateSchemeID \t\tvarchar(44),");
            kSql.append(" \tFEstimateSchemeNumber \tvarchar(80),");
            kSql.append(" \tFEstimateSchemeName \tvarchar(255), ");
            kSql.append(" \tFParentMaterialID\t\tvarchar(44),");
            kSql.append(" \tFParentMaterialNumber \tvarchar(80),");
            kSql.append(" \tFParentMaterialName  \tvarchar(255),");
            kSql.append(" \tFModel\t\t\t  \t\tnvarchar(255),");
            kSql.append(" \tFCostItemID \t\t\tvarchar(44),");
            kSql.append(" \tFCostItemNumber \t\tvarchar(80),");
            kSql.append(" \tFCostItemName \t\t\tvarchar(255),");
            kSql.append(" \tFResTypeID \t\t\t\tvarchar(44),");
            kSql.append(" \tFResTypeNumber \t\t\tvarchar(80),");
            kSql.append(" \tFResTypeName \t\t\tvarchar(255),");
            kSql.append(" \tFMeasureUnitID \t\t\tvarchar(44),");
            kSql.append(" \tFMeasureUnitName \t\tvarchar(255),");
            kSql.append(" \tFQty \t\t\t\t\tdecimal(21,8),");
            kSql.append(" \tFStdPrice \t\t\t\tdecimal(21,8),");
            kSql.append(" \tFStdAmount \t\t\t\tdecimal(21,8),");
            kSql.append(" \tFTotalRow \t\t\t\tdecimal(21,8) not null default(0),");
            kSql.append(" \tFTotalRow2 \t\t\t\tdecimal(21,8) not null default(0),");
            kSql.append("   FIsTotalRow int not null default(1), ");
            kSql.append("   FTotalStorageOrgUnitRow int not null default(0), ");
            kSql.append("   FTotalSchemeRow int not null default(0), ");
            kSql.append("   FTotalParentMaterialRow int not null default(0), ");
            kSql.append("   FTotalCostItemRow int not null default(0), ");
            kSql.append("   FTotalMaterialRow int not null default(0), ");
            kSql.append("\tFQtyDecimal \t\t\tint default(6),");
            kSql.append("\tFPriceDecimal \t\t\tint default(6),");
            kSql.append("\tFAmountDecimal \t\t\tint default(6)");
            kSql.append(" ) ");
            TMP_NCM_STDCostData = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostData, "FStorageOrgUnitID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostData, "FEstimateSchemeID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostData, "FParentMaterialID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostData, "FCostItemID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_STDCostData, "FResTypeID", false, false);
            T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_STDCostDataMatDetail");
            T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_STDCostDataResDetail");
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + TMP_NCM_STDCostData + " \n");
            kSql.append("            (FStorageOrgUnitID, \n");
            kSql.append("             FStorageOrgUnitNumber, \n");
            kSql.append("             FStorageOrgUnitName, \n");
            kSql.append("             FEstimateSchemeID, \n");
            kSql.append("             FEstimateSchemeNumber, \n");
            kSql.append("             FEstimateSchemeName, \n");
            kSql.append("             FParentMaterialID, \n");
            kSql.append("             FParentMaterialNumber, \n");
            kSql.append("             FParentMaterialName, \n");
            kSql.append("             FModel, \n");
            kSql.append("             FCostItemID,\n");
            kSql.append("             FCostItemNumber,\n");
            kSql.append("             FCostItemName,\n");
            kSql.append("             FResTypeID,\n");
            kSql.append("             FResTypeNumber,\n");
            kSql.append("             FResTypeName,\n");
            kSql.append("             FMeasureUnitID,\n");
            kSql.append("             FMeasureUnitName,\n");
            kSql.append("             FQty,\n");
            kSql.append("             FStdPrice,\n");
            kSql.append("             FStdAmount,\n");
            kSql.append("             FTotalRow,\n");
            kSql.append("             FTotalRow2,\n");
            kSql.append("             FQtyDecimal,\n");
            kSql.append("             FPriceDecimal,\n");
            kSql.append("             FAmountDecimal,\n");
            kSql.append("             FIsTotalRow) \n");
            kSql.append(" SELECT detail.FStorageOrgUnitID AS FStorageOrgUnitID,\n");
            kSql.append("        detail.FStorageOrgUnitNumber AS FStorageOrgUnitNumber, \n");
            kSql.append("        detail.FStorageOrgUnitName AS FStorageOrgUnitName,\n");
            kSql.append("        detail.FEstimateSchemeID AS FEstimateSchemeID,\n");
            kSql.append("        detail.FEstimateSchemeNumber AS FEstimateSchemeNumber,\n");
            kSql.append("        detail.FEstimateSchemeName AS FEstimateSchemeName,\n");
            kSql.append("        detail.FParentMaterialID AS FParentMaterialID,\n");
            kSql.append("        detail.FParentMaterialNumber AS FParentMaterialNumber,\n");
            kSql.append("        detail.FParentMaterialName AS FParentMaterialName,\n");
            kSql.append("        detail.FModel AS FModel,\n");
            kSql.append("        detail.FCostItemID AS FCostItemID,\n");
            kSql.append("        costItem.FNumber AS FCostItemNumber,\n");
            kSql.append("        costItem.FName_" + locale.getLanguage() + " AS FCostItemName,\n");
            kSql.append("        detail.FResTypeID AS FResTypeID,\n");
            kSql.append("        detail.FResTypeNumber AS FResTypeNumber,\n");
            kSql.append("        detail.FResTypeName AS FResTypeName,\n");
            kSql.append("        detail.FMeasureUnitID AS FMeasureUnitID,\n");
            kSql.append("        detail.FMeasureUnitName AS FMeasureUnitName,\n");
            kSql.append("        detail.FQty AS FQty,\n");
            kSql.append("        detail.FStdPrice AS FStdPrice,\n");
            kSql.append("        detail.FStdAmount AS FStdAmount,\n");
            kSql.append("        0 AS FTotalRow,\n");
            kSql.append("        0 AS FTotalRow2,\n");
            kSql.append("        detail.FQtyPrecision AS FQtyDecimal,\n");
            kSql.append("        detail.FPriceDecimal AS fFPriceDecimal,\n");
            kSql.append("        FAmountDecimal AS FAmountDecimal, \n");
            kSql.append("        0 AS FIsTotalRow \n");
            kSql.append(" FROM   (\n");
            kSql.append("         (SELECT matDetail.FStorageOrgUnitID AS FStorageOrgUnitID,\n");
            kSql.append("                 storageOrg.FNumber AS\u3000FStorageOrgUnitNumber, \n");
            kSql.append("                 storageOrg.FName_" + locale.getLanguage() + " AS FStorageOrgUnitName,\n");
            kSql.append("                 matDetail.FEstimateSchemeID AS FEstimateSchemeID,\n");
            kSql.append("                 scheme.FNumber AS FEstimateSchemeNumber,\n");
            kSql.append("                 scheme.FName_" + locale.getLanguage() + " AS FEstimateSchemeName,\n");
            kSql.append("                 matDetail.FParentMaterialID AS FParentMaterialID,\n");
            kSql.append("                 parentMatrial.FNumber AS FParentMaterialNumber,\n");
            kSql.append("                 parentMatrial.FName_" + locale.getLanguage() + " AS FParentMaterialName,\n");
            kSql.append("                 parentMatrial.FModel AS FModel,\n");
            kSql.append("                 matDetail.FChildCostItemID AS FCostItemID,\n");
            kSql.append("                 NULL AS FCostItemNumber,\n");
            kSql.append("                 NULL AS FCostItemName,\n");
            kSql.append("                 CASE WHEN matDetail.FMaterialID IS NOT NULL THEN  matDetail.FMaterialID\n");
            kSql.append("                      ELSE matDetail.FParentMaterialID\n");
            kSql.append("                 END AS FResTypeID,\n");
            kSql.append("                 material.FNumber AS FResTypeNumber,\n");
            kSql.append("                 material.FName_" + locale.getLanguage() + " AS FResTypeName,\n");
            kSql.append("                 matDetail.FMeasureUnitID AS FMeasureUnitID,\n");
            kSql.append("                 mu.FName_" + locale.getLanguage() + " AS FMeasureUnitName,\n");
            kSql.append("                 matDetail.FChildQty AS FQty,\n");
            kSql.append("                 matDetail.FChildStdPrice AS FStdPrice,\n");
            kSql.append("                 Round(matDetail.FChildAmount, material.FPricePrecision) AS FStdAmount,\n");
            kSql.append("                 0 AS FTotalRow,\n");
            kSql.append("                 0 AS FTotalRow2,\n");
            kSql.append("                 mmu.FQtyPrecision AS FQtyPrecision,\n");
            kSql.append("                 material.FPricePrecision AS FPriceDecimal,\n");
            kSql.append("                 material.FPricePrecision AS FAmountDecimal\n");
            kSql.append("          FROM   " + T_NCM_STDCostDataMatDetail + " matDetail\n");
            kSql.append("                 LEFT OUTER JOIN T_BD_Material material \n");
            kSql.append("                   ON matDetail.FMaterialID = material.FID\n");
            kSql.append("                 INNER JOIN T_BD_MeasureUnit mu \n");
            kSql.append("                     ON mu.FID = matDetail.FMeasureUnitID \n");
            kSql.append("                 LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu \n");
            kSql.append("                   ON mmu.FMaterialID = material.FID and mmu.FMeasureUnitID = mu.FID \n");
            kSql.append("                 INNER JOIN T_ORG_Storage storageOrg \n");
            kSql.append("                 \tON matDetail.FStorageOrgUnitID = storageOrg.FID \n");
            if (this.isFilterStorage(filter)) {
                kSql.append("                 \t\tAND storageOrg.FNumber IN(" + this.filterStorage(filter) + ")\n");
            }
            kSql.append("                 INNER JOIN T_NCM_SCEstimateScheme scheme \n");
            kSql.append("                 \tON matDetail.FEstimateSchemeID = scheme.FID \n");
            if (this.isFilterScheme(filter)) {
                kSql.append("                 \t\tAND scheme.FNumber IN(" + this.filterScheme(filter) + ")\n");
            }
            kSql.append("                 INNER JOIN T_BD_Material parentMatrial \n");
            kSql.append("                 \tON matDetail.FParentMaterialID = parentMatrial.FID \n");
            if (this.isFilterMaterial(filter)) {
                kSql.append("                 \t\tAND parentMatrial.FNumber IN(" + this.filterMaterial(filter) + ")\n");
            }
            if (this.isFilterCalcType(filter)) {
                kSql.append("                 INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
                kSql.append("                 \t\tON parentMatrial.FID = matCompany.FMaterialID \n");
                kSql.append("                 \t\t  AND matCompany.FCalculateType = " + this.filterCalcType(filter) + " \n");
                kSql.append("                 \t\t  AND matCompany.FCompanyID = '" + companyId + "' \n");
            }
            kSql.append("         ) \n");
            kSql.append("         UNION \n");
            kSql.append("         (SELECT resDetail.FStorageOrgUnitID AS FStorageOrgUnitID,\n");
            kSql.append("                 storageOrg.FNumber AS FStorageOrgUnitNumber, \n");
            kSql.append("                 storageOrg.FName_" + locale.getLanguage() + " AS FStorageOrgUnitName,\n");
            kSql.append("                 resDetail.FEstimateSchemeID AS FEstimateSchemeID,\n");
            kSql.append("                 scheme.FNumber AS FEstimateSchemeNumber,\n");
            kSql.append("                 scheme.FName_" + locale.getLanguage() + " AS FEstimateSchemeName,\n");
            kSql.append("                 resDetail.FParentMaterialID AS FParentMaterialID,\n");
            kSql.append("                 parentMatrial.FNumber AS FParentMaterialNumber,\n");
            kSql.append("                 parentMatrial.FName_" + locale.getLanguage() + " AS FParentMaterialName,\n");
            kSql.append("                 parentMatrial.FModel AS FModel,\n");
            kSql.append("                 resDetail.FResCostItemID AS FCostItemID,\n");
            kSql.append("                 NULL AS FCostItemNumber,\n");
            kSql.append("                 NULL AS FCostItemName,\n");
            kSql.append("                 resDetail.FResourceTypeID AS FResTypeID,\n");
            kSql.append("                 resType.FNumber AS FResTypeNumber,\n");
            kSql.append("                 resType.FName_" + locale.getLanguage() + " AS FResTypeName,\n");
            kSql.append("                 resDetail.FResMeasureUnitID AS FMeasureUnitID,\n");
            kSql.append("                 mu.FName_" + locale.getLanguage() + " AS FMeasureUnitName,\n");
            kSql.append("                 resDetail.FResQty AS FQty,\n");
            kSql.append("                 resDetail.FResStdPrice AS FStdPrice,\n");
            kSql.append("                 resDetail.FResAmount AS FStdAmount,\n");
            kSql.append("                 0 AS FTotalRow,\n");
            kSql.append("                 0 AS FTotalRow2,\n");
            kSql.append("                 mu.FQtyPrecision AS FQtyPrecision,\n");
            kSql.append("                 6 AS FPriceDecimal,\n");
            kSql.append("                 ci.FPricePrecision AS FAmountDecimal\n");
            kSql.append("          FROM   " + T_NCM_STDCostDataResDetail + " resDetail\n");
            kSql.append("                 INNER JOIN T_BD_MeasureUnit mu \n");
            kSql.append("                     ON mu.FID = resDetail.FResMeasureUnitID \n");
            kSql.append("                 INNER JOIN T_NCM_CostItem ci on ci.FID = resDetail.FResCostItemID \n");
            kSql.append("                 LEFT OUTER JOIN T_NCM_SCResourceType resType\n");
            kSql.append("                   ON resDetail.FResourceTypeID = resType.FID \n");
            kSql.append("                 INNER JOIN T_ORG_Storage storageOrg \n");
            kSql.append("                 \tON resDetail.FStorageOrgUnitID = storageOrg.FID \n");
            if (this.isFilterStorage(filter)) {
                kSql.append("                 \t\tAND storageOrg.FNumber IN(" + this.filterStorage(filter) + ")\n");
            }
            kSql.append("                 INNER JOIN T_NCM_SCEstimateScheme scheme \n");
            kSql.append("                 \tON resDetail.FEstimateSchemeID = scheme.FID \n");
            if (this.isFilterScheme(filter)) {
                kSql.append("                 \t\tAND scheme.FNumber IN(" + this.filterScheme(filter) + ")\n");
            }
            kSql.append("                 INNER JOIN T_BD_Material parentMatrial \n");
            kSql.append("                 \tON resDetail.FParentMaterialID = parentMatrial.FID \n");
            if (this.isFilterMaterial(filter)) {
                kSql.append("                 \t\tAND parentMatrial.FNumber IN(" + this.filterMaterial(filter) + ")\n");
            }
            if (this.isFilterCalcType(filter)) {
                kSql.append("                 INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
                kSql.append("                 \t\tON parentMatrial.FID = matCompany.FMaterialID \n");
                kSql.append("                 \t\t   AND matCompany.FCalculateType = " + this.filterCalcType(filter) + " \n");
                kSql.append("                 \t\t   AND matCompany.FCompanyID = '" + companyId + "' \n");
            }
            kSql.append("         ) \n");
            kSql.append("        ) detail\n");
            kSql.append("        LEFT OUTER JOIN T_NCM_CostItem costItem\n");
            kSql.append("          ON detail.FCostItemID = costItem.FID\n");
            kSql.append("  WHERE detail.FStdAmount IS NOT NULL AND detail.FStdAmount <> 0 \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + TMP_NCM_STDCostData + " \n");
            kSql.append("            (FStorageOrgUnitID, \n");
            kSql.append("             FStorageOrgUnitNumber, \n");
            kSql.append("             FStorageOrgUnitName, \n");
            kSql.append("             FEstimateSchemeID, \n");
            kSql.append("             FEstimateSchemeNumber, \n");
            kSql.append("             FEstimateSchemeName, \n");
            kSql.append("             FParentMaterialID, \n");
            kSql.append("             FParentMaterialNumber, \n");
            kSql.append("             FParentMaterialName, \n");
            kSql.append("             FModel, \n");
            kSql.append("             FCostItemID, \n");
            kSql.append("             FCostItemNumber, \n");
            kSql.append("             FCostItemName, \n");
            kSql.append("             FResTypeID, \n");
            kSql.append("             FResTypeNumber, \n");
            kSql.append("             FResTypeName, \n");
            kSql.append("             FMeasureUnitID, \n");
            kSql.append("             FMeasureUnitName, \n");
            kSql.append("             FQty, \n");
            kSql.append("             FStdPrice, \n");
            kSql.append("             FStdAmount, \n");
            kSql.append("             FTotalRow, \n");
            kSql.append("             FTotalRow2, \n");
            kSql.append("             FQtyDecimal, \n");
            kSql.append("             FPriceDecimal, \n");
            kSql.append("             FAmountDecimal, \n");
            kSql.append("             FIsTotalRow) \n");
            kSql.append(" SELECT storageOrg.FID AS FStorageOrgUnitID, \n");
            kSql.append("        storageOrg.FNumber AS FStorageOrgUnitNumber, \n");
            kSql.append("        storageOrg.FName_" + locale.getLanguage() + " AS FStorageOrgUnitName, \n");
            kSql.append("        scheme.FID AS FEstimateSchemeID, \n");
            kSql.append("        scheme.FNumber AS FEstimateSchemeNumber, \n");
            kSql.append("        scheme.FName_" + locale.getLanguage() + " AS FEstimateSchemeName, \n");
            kSql.append("        mat.FID AS FParentMaterialID, \n");
            kSql.append("        mat.FNumber AS FParentMaterialNumber, \n");
            kSql.append("        mat.FName_" + locale.getLanguage() + " AS FParentMaterialName, \n");
            kSql.append("        FModel, \n");
            kSql.append("        NULL AS FCostItemID, \n");
            kSql.append("        NULL AS FCostItemNumber, \n");
            kSql.append("        NULL AS FCostItemName, \n");
            kSql.append("        NULL AS FResTypeID, \n");
            kSql.append("        NULL AS FResTypeNumber, \n");
            kSql.append("        NULL AS FResTypeName, \n");
            kSql.append("        NULL AS FMeasureUnitID, \n");
            kSql.append("        NULL AS FMeasureUnitName, \n");
            kSql.append("        0 AS FQty, \n");
            kSql.append("        0 AS FStdPrice, \n");
            kSql.append("        FStdAmount AS FStdAmount, \n");
            kSql.append("        0 AS FTotalRow, \n");
            kSql.append("        0 AS FTotalRow2, \n");
            kSql.append("        6 AS FQtyDecimal, \n");
            kSql.append("        6 AS FPriceDecimal, \n");
            kSql.append("        mat.FPricePrecision AS FAmountDecimal, \n");
            kSql.append("        0 AS FIsTotalRow \n");
            kSql.append(" FROM   T_NCM_STDCostData costData \n");
            kSql.append("        INNER JOIN T_NCM_SCEstimateScheme scheme \n");
            kSql.append("          ON costData.FEstimateSchemeID = scheme.FID \n");
            if (this.isFilterScheme(filter)) {
                kSql.append("             AND scheme.FNumber IN(" + this.filterScheme(filter) + ")\n");
            }
            kSql.append("        INNER JOIN T_ORG_Storage storageOrg \n");
            kSql.append("          ON scheme.FStorageOrgUnitID = storageOrg.FID \n");
            if (this.isFilterStorage(filter)) {
                kSql.append("             AND storageOrg.FNumber IN(" + this.filterStorage(filter) + ")\n");
            }
            kSql.append("        INNER JOIN T_BD_Material mat \n");
            kSql.append("          ON costData.FMaterialID = mat.FID \n");
            kSql.append("        INNER JOIN T_BD_MaterialInventory matInv \n");
            kSql.append("          ON matInv.FMaterialID = mat.FID and matInv.FOrgUnit = storageOrg.FID \n");
            kSql.append("          and matInv.FStatus = 1 \n");
            if (this.isFilterMaterial(filter)) {
                kSql.append("             AND mat.FNumber IN(" + this.filterMaterial(filter) + ")\n");
            }
            if (this.isFilterCalcType(filter)) {
                kSql.append("        INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
                kSql.append("       ON mat.FID = matCompany.FMaterialID \n");
                kSql.append("          AND matCompany.FCalculateType = " + this.filterCalcType(filter) + " \n");
                kSql.append("          AND matCompany.FCompanyID = '" + companyId + "' \n");
            }
            kSql.append(" WHERE  costData.FStdAmount IS NOT NULL AND costData.FStdAmount <> 0 \n");
            kSql.append("        AND NOT EXISTS (SELECT 1 \n");
            kSql.append("                        FROM   " + TMP_NCM_STDCostData + " \n");
            kSql.append("                        WHERE  FEstimateSchemeID = costData.FEstimateSchemeID \n");
            kSql.append("                          AND costData.FMaterialID = FParentMaterialID) \n");
            kSql.append("        AND costData.FCompanyOrg = '" + companyId + "' \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TMP_NCM_STDCostData);
            String[] fields = this.getGroupByFields((ArrayList)filter.getObject("table"));
            if (fields != null && fields.length > 0 && !StringUtils.isEmpty((String)fields[0])) {
                kSql.setLength(0);
                kSql.append(" INSERT INTO " + TMP_NCM_STDCostData + " \n");
                kSql.append("   (FTotalRow, \n");
                kSql.append("    FTotalRow2, \n");
                kSql.append("    " + fields[0] + ",");
                kSql.append("    FQtyDecimal, \n");
                kSql.append("    FPriceDecimal, \n");
                kSql.append("    FAmountDecimal, \n");
                kSql.append("    FStdAmount) \n");
                kSql.append("   SELECT " + fields[1] + ",\n");
                kSql.append("          CASE WHEN GROUPING(" + fields[2] + ") = 1 THEN 1 ELSE 0 END,\n");
                kSql.append("          " + fields[0] + ",");
                kSql.append("          ISNULL(MAX(FQtyDecimal), 0),\n");
                kSql.append("          ISNULL(MAX(FPriceDecimal), 0), \n");
                kSql.append("          ISNULL(MAX(FAmountDecimal), 0), \n");
                kSql.append("          SUM(FStdAmount) \n");
                kSql.append("     FROM " + TMP_NCM_STDCostData + " \n");
                kSql.append("    WHERE FTotalRow = 0 \n");
                kSql.append("     GROUP BY " + fields[0] + "\n");
                kSql.append("        WITH ROLLUP \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            }
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_STDCostData + " \n");
            kSql.append(" SET    (FStorageOrgUnitNumber,FStorageOrgUnitName)\n");
            kSql.append(" \t\t\t\t= (SELECT FNumber,FName_" + locale.getLanguage() + " \n");
            kSql.append("                    FROM T_ORG_Storage \n");
            kSql.append("                   WHERE FID = " + TMP_NCM_STDCostData + ".FStorageOrgUnitID) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_STDCostData + " \n");
            kSql.append(" SET    (FEstimateSchemeNumber,FEstimateSchemeName)\n");
            kSql.append(" \t\t\t\t= (SELECT FNumber,FName_" + locale.getLanguage() + " \n");
            kSql.append("                    FROM T_NCM_SCEstimateScheme \n");
            kSql.append("                   WHERE FID = " + TMP_NCM_STDCostData + ".FEstimateSchemeID) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_STDCostData + " \n");
            kSql.append(" SET    (FParentMaterialNumber,FParentMaterialName,FModel)\n");
            kSql.append(" \t\t\t\t= (SELECT mat.FNumber,mat.FName_" + locale.getLanguage() + ",mat.FModel \n");
            kSql.append("                    FROM T_BD_Material mat \n");
            kSql.append("                   WHERE mat.FID = " + TMP_NCM_STDCostData + ".FParentMaterialID) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_STDCostData + " \n");
            kSql.append(" SET    (FCostItemNumber,FCostItemName)\n");
            kSql.append(" \t\t\t\t= (SELECT FNumber,FName_" + locale.getLanguage() + " \n");
            kSql.append("                    FROM T_NCM_CostItem \n");
            kSql.append("                   WHERE FID = " + TMP_NCM_STDCostData + ".FCostItemID) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_STDCostData + " \n");
            kSql.append(" SET    (FResTypeNumber,FResTypeName) \n");
            kSql.append(" \t\t= (SELECT FNumber,FName_" + locale.getLanguage() + " \n");
            kSql.append("            FROM T_BD_Material mat \n");
            kSql.append("           WHERE FResTypeID = mat.FID \n");
            kSql.append("           ) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_STDCostData + " \n");
            kSql.append(" SET    (FResTypeNumber,FResTypeName) \n");
            kSql.append(" \t\t= (SELECT FNumber,FName_" + locale.getLanguage() + " \n");
            kSql.append("            FROM  T_NCM_SCResourceType res \n");
            kSql.append("           WHERE  FResTypeID = res.FID \n");
            kSql.append("          ) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
            Context ctx = this.getContext();
            kSql.setLength(0);
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                String field = (String)map.get("id");
                String fieldName = field.substring(0, field.length() - 2) + "Name";
                String fieldNumber = field.substring(0, field.length() - 2) + "Number";
                String whichTotal = "";
                if (fieldNumber.equalsIgnoreCase("FStorageOrgUnitNumber")) {
                    whichTotal = ", FTotalStorageOrgUnitRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                    whichTotal = ", FTotalCostItemRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FEstimateSchemeNumber")) {
                    whichTotal = ", FTotalSchemeRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FParentMaterialNumber")) {
                    whichTotal = ", FTotalParentMaterialRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                    whichTotal = ", FTotalMaterialRow = 1 ";
                }
                kSql.append(" update " + TMP_NCM_STDCostData + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"2_STDCostDiffReport", (Locale)ctx.getLocale()) + "'," + fieldNumber + " = " + fieldNumber);
                kSql.append(whichTotal);
                kSql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                kSql.append(";");
            }
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            String orderBySort = this.getShowString((ArrayList)filter.getObject("table")).toString();
            String[] orderStrings = orderBySort.split(",");
            String totalFieldNumber = orderStrings[0];
            kSql.append(" UPDATE " + TMP_NCM_STDCostData + "\n");
            kSql.append("    SET " + totalFieldNumber + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"3_STDCostDiffReport", (Locale)ctx.getLocale()) + "', \n");
            kSql.append("        FTotalRow = 200 \n");
            kSql.append("  WHERE FTotalRow2 = 1 \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return TMP_NCM_STDCostData;
    }

    private String buildSelectSql(RptParams filter, String tablename) {
        StringBuffer ksql = new StringBuffer();
        String[] fields = this.getGroupByFields((ArrayList)filter.getObject("table"));
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FStorageOrgUnitNumber")) {
                orderByWhichTotal = ",FTotalStorageOrgUnitRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ",FTotalCostItemRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FEstimateSchemeNumber")) {
                orderByWhichTotal = ",FTotalSchemeRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FParentMaterialNumber")) {
                orderByWhichTotal = ",FTotalParentMaterialRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                orderByWhichTotal = ",FTotalMaterialRow " + orderByMode;
            }
            orderBy.append(fieldNumber);
            orderBy.append(orderByWhichTotal);
            orderBy.append(",");
        }
        if (fields == null || fields.length == 0 || StringUtils.isEmpty((String)fields[0])) {
            orderBy.setLength(0);
            orderBy.append(" FEstimateSchemeNumber,FParentMaterialNumber,FCostItemNumber,FResTypeNumber,");
        }
        if (orderBy.indexOf("FCostItemNumber") < 0) {
            orderBy.append("FCostItemNumber,");
        }
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        ksql.append(" SELECT * \n");
        ksql.append("   FROM " + tablename + " \n");
        ksql.append(where);
        ksql.append("  ORDER BY \n");
        ksql.append("\t\tFTotalRow2 ");
        ksql.append(orderByMode + ",");
        ksql.append("  \t\t" + orderBy + " \n");
        ksql.append("  \t\tFTotalRow \n");
        return ksql.toString();
    }

    private boolean isFilterStorage(RptParams filter) throws Exception {
        String storageOrgNumbers = filter.getString("storageOrgUnits");
        List list = this.split(storageOrgNumbers);
        return list.size() > 0;
    }

    private StringBuffer filterStorage(RptParams filter) throws Exception {
        String storageOrgNumbers = filter.getString("storageOrgUnits");
        return BDCMUtils.splitPK((Collection)this.split(storageOrgNumbers));
    }

    private boolean isFilterScheme(RptParams filter) throws Exception {
        String estimateSchemes = filter.getString("estimateSchemes");
        List list = this.split(estimateSchemes);
        return list.size() > 0;
    }

    private StringBuffer filterScheme(RptParams filter) throws Exception {
        String estimateSchemes = filter.getString("estimateSchemes");
        return BDCMUtils.splitPK((Collection)this.split(estimateSchemes));
    }

    private boolean isFilterMaterial(RptParams filter) throws Exception {
        String materials = filter.getString("materials");
        List list = this.split(materials);
        return list.size() > 0;
    }

    private StringBuffer filterMaterial(RptParams filter) throws Exception {
        String materials = filter.getString("materials");
        return BDCMUtils.splitPK((Collection)this.split(materials));
    }

    private boolean isFilterCalcType(RptParams filter) throws Exception {
        String calcuType = filter.getString("calcuType");
        return !StringUtils.isEmpty((String)calcuType) && !calcuType.equals(String.valueOf(-1));
    }

    private StringBuffer filterCalcType(RptParams filter) throws Exception {
        String calcuType = filter.getString("calcuType");
        return new StringBuffer(calcuType);
    }

    private List split(String target) {
        ArrayList<String> list = new ArrayList<String>();
        if (target != null && target.length() > 0) {
            String[] strs = target.split(";");
            for (int i = 0; i < strs.length; ++i) {
                String temp = strs[i].trim();
                if (temp.length() <= 0) continue;
                list.add(temp);
            }
        }
        return list;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyOrg");
        String companyName = "";
        companyName = companyInfo == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : companyInfo.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"5_STDCostDiffReport", (Locale)ctx.getLocale()) + companyName);
        String storages = filter.getString("storageOrgUnits");
        String storageNumbers = "";
        storageNumbers = StringUtils.isEmpty((String)storages) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : storages.replaceAll(";", ",");
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"11_STDCostSumReport", (Locale)ctx.getLocale()) + storageNumbers);
        String estimateSchemes = filter.getString("estimateSchemes");
        String estimateSchemeNumbers = "";
        estimateSchemeNumbers = StringUtils.isEmpty((String)estimateSchemes) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : estimateSchemes.replaceAll(";", ",");
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"8_STDCostDiffReport", (Locale)ctx.getLocale()) + estimateSchemeNumbers);
        String materials = filter.getString("materials");
        String materialNumbers = "";
        materialNumbers = StringUtils.isEmpty((String)materials) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"4_STDCostDiffReport", (Locale)ctx.getLocale()) : materials.replaceAll(";", ",");
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"12_STDCostSumReport", (Locale)ctx.getLocale()) + materialNumbers);
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader header = super.getReportHeader(reportID, filter);
        ArrayList tblData = (ArrayList)filter.getObject("table");
        ArrayList childs = header.getChilds();
        ReportHeader childHeader = null;
        String fieldNameTemp = null;
        Context ctx = this.getContext();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            childHeader = (ReportHeader)childs.get(i2);
            fieldNameTemp = childHeader.getFieldName();
            if (fieldNameTemp.equals("FStorageOrgUnitNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"24_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FStorageOrgUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"22_STDCostSumReportFilter2UI", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FEstimateSchemeNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"25_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FEstimateSchemeName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"26_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FParentMaterialNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"27_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FParentMaterialName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"28_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"29_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"30_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"31_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FResTypeNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"32_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FResTypeName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"33_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMeasureUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"34_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"35_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FStdPrice")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"36_STDCostSumReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldNameTemp.equals("FStdAmount")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"37_STDCostSumReport", (Locale)ctx.getLocale()));
        }
        HashMap<String, ReportHeader> headerMap = new HashMap<String, ReportHeader>();
        for (int i3 = 0; i3 < childs.size(); ++i3) {
            ReportHeader child = (ReportHeader)childs.get(i3);
            String fieldName = child.getFieldName().toLowerCase();
            headerMap.put(fieldName.toLowerCase(), child);
        }
        ArrayList temp = new ArrayList(childs.size());
        temp.addAll(childs);
        childs.clear();
        ArrayList<String> sortedCols = new ArrayList<String>();
        sortedCols.add("FCompanyOrg");
        int qtyCounter = 0;
        for (i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FStorageOrgUnitID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FStorageOrgUnitNumber");
                sortedCols.add("FStorageOrgUnitName");
                ++qtyCounter;
            }
            if ("FEstimateSchemeID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FEstimateSchemeNumber");
                sortedCols.add("FEstimateSchemeName");
                ++qtyCounter;
            }
            if ("FParentMaterialID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FParentMaterialNumber");
                sortedCols.add("FParentMaterialName");
                sortedCols.add("FModel");
                ++qtyCounter;
            }
            if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostItemNumber");
                sortedCols.add("FCostItemName");
                ++qtyCounter;
            }
            if (!"FResTypeID".equalsIgnoreCase(fieldID)) continue;
            sortedCols.add("FResTypeNumber");
            sortedCols.add("FResTypeName");
            sortedCols.add("FMeasureUnitName");
            ++qtyCounter;
        }
        sortedCols.add("FQty");
        sortedCols.add("FStdPrice");
        sortedCols.add("FStdAmount");
        for (i = 0; i < sortedCols.size(); ++i) {
            String field = (String)sortedCols.get(i);
            ReportHeader child = (ReportHeader)headerMap.get(field.toLowerCase());
            if (child == null) continue;
            childs.add(child);
            temp.remove(child);
        }
        childs.addAll(temp);
        return header;
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                String fieldID = (String)map.get("id");
                sb.append(fieldID);
                map.put("groupby", sb.toString());
                map.put("totalrow", 104 - i + n);
                newList.add(map);
                continue;
            }
            ++n;
        }
        return newList;
    }

    private String[] getGroupByFields(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sqlCase = new StringBuffer();
        String firstFields = null;
        sqlCase.append(" case ");
        int n = 105;
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            sqlCase.append(" when grouping(" + fieldID + ") = 1 then " + n + " \n");
            if (firstFields == null) {
                firstFields = fieldID;
            }
            --n;
        }
        sqlCase.append(" else " + n + " end ");
        return new String[]{sb.toString(), sqlCase.toString(), firstFields};
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }
}

