/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCItemFactory;
import com.kingdee.eas.qm.basedata.QCItemGroupFactory;
import com.kingdee.eas.qm.basedata.QCItemGroupInfo;
import com.kingdee.eas.qm.basedata.app.AbstractQCItemGroupControllerBean;
import com.kingdee.eas.qm.common.QMVerifyException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class QCItemGroupControllerBean
extends AbstractQCItemGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.basedata.app.QCItemGroupControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkTreeData(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkTreeData(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkTreeData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        QCItemGroupInfo info = (QCItemGroupInfo)model;
        int level = 0;
        if (info.getParent() != null) {
            String parentID = info.getParent().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("group.id", (Object)parentID);
            if (QCItemFactory.getLocalInstance(ctx).exists(filter)) {
                throw new QMVerifyException(QMVerifyException.DBCANNOT_ADD_GROUP, (Object[])new String[]{info.getParent().getName()});
            }
            QCItemGroupInfo parentInfo = QCItemGroupFactory.getLocalInstance(ctx).getQCItemGroupInfo((IObjectPK)new ObjectStringPK(parentID));
            level = parentInfo.getLevel();
            if (level > 4) {
                throw new QMVerifyException(QMVerifyException.DBMORE_GROUP_LEVEL);
            }
        }
        if (level < 5) {
            String sql = "select max(flevel) as maxlevel from t_qm_qcitemgroup where flongnumber like '" + info.getLongNumber() + "%'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                int maxLevel;
                int tempLevel;
                if (rs.next() && (tempLevel = (maxLevel = rs.getInt("maxlevel")) - info.getLevel() + 1) + level > 5) {
                    throw new QMVerifyException(QMVerifyException.DBMORE_GROUP_LEVEL);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
    }
}

