/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.IQCStandardExtendAttr;
import com.kingdee.eas.qm.basedata.IQCStandardItemEntry;
import com.kingdee.eas.qm.basedata.IQCStandardItemExtendAttr;
import com.kingdee.eas.qm.basedata.QCStandardBizObjectEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardBizObjectEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardBizObjectEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardCollection;
import com.kingdee.eas.qm.basedata.QCStandardException;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardMaterialEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardMaterialEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardMaterialEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardProductLineEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardProductLineEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardProductLineEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardTechnicsEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardTechnicsEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardTechnicsEntryInfo;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.SampleHierarchyEnum;
import com.kingdee.eas.qm.basedata.app.AbstractQCStandardControllerBean;
import com.kingdee.eas.qm.basedata.app.QCStandardNewImpl;
import com.kingdee.eas.qm.basedata.app.action.QCStandardServerBatchAuditAction;
import com.kingdee.eas.qm.basedata.app.action.QCStandardServerBatchDeleteAction;
import com.kingdee.eas.qm.basedata.app.action.QCStandardServerBatchUnAuditAction;
import com.kingdee.eas.qm.basedata.app.verify.QCStandardCancelVerifyItem;
import com.kingdee.eas.qm.basedata.app.verify.QCStandardDeleteVerifyItem;
import com.kingdee.eas.qm.basedata.app.verify.QCStandardNormalAuditVerifyItem;
import com.kingdee.eas.qm.basedata.app.verify.QCStandardOrgAuditVerifyItem;
import com.kingdee.eas.qm.basedata.app.verify.QCStandardOrgUnAuditVerifyItem;
import com.kingdee.eas.qm.basedata.app.verify.QCStandardSubmitVerifyItem;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.QMCoreDataBaseInfo;
import com.kingdee.eas.qm.common.QMDataBaseDInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.QMVerifyException;
import com.kingdee.eas.qm.common.app.QMDataBaseDNewImpl;
import com.kingdee.eas.qm.common.app.action.IServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QCStandardControllerBean
extends AbstractQCStandardControllerBean {
    private static final long serialVersionUID = 6691786152968869848L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.basedata.app.QCStandardControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.getSubmitVerifyManager(ctx, (QCStandardInfo)model).verify();
        IObjectPK pk = super._submit(ctx, model);
        QCStandardInfo info = (QCStandardInfo)model;
        this.saveRelation(ctx, info);
        if (this.isCreateQualityOrg(ctx, info) && this._isStandardAssign(ctx, pk)) {
            this.makeExtInfoWithAssignInfo(ctx, pk);
        }
        if (SampleHierarchyEnum.step == info.getSampleHierarchy()) {
            this.checkDelegOrgUnitByStep(ctx, pk);
        }
        return pk;
    }

    protected void checkDelegOrgUnitByStep(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select tt.info AS INFO,count(tt.orgid)");
        checkSql.append("from ");
        checkSql.append("(");
        checkSql.append("select distinct aa.fcheckstep as info ,bb.fdelegorgunitid as orgid  ");
        checkSql.append("from t_qm_qcstandarditementries aa ");
        checkSql.append("left join t_qm_qcstandarditemextendattr bb ");
        checkSql.append("on aa.fid = bb.fqcstandardentryid ");
        checkSql.append("where aa.fparentid ='" + pk.toString() + "' ");
        checkSql.append("and bb.fqualityorgunitid = '" + this.getCurrentQualityOrgUnit(ctx).getId().toString() + "' ");
        checkSql.append(")tt ");
        checkSql.append("group by tt.info ");
        checkSql.append("having count(tt.orgid)  >1 ");
        logger.debug((Object)checkSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (rs.next()) {
                String stepInfo = rs.getString("INFO");
                throw new QCStandardException(QCStandardException.CHECKSTEP_DISORG, new String[]{stepInfo});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void makeExtInfoWithAssignInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select sss.fassignorgunitid as ORGID ");
        sql.append("from t_qm_databasedassign sss ");
        sql.append("where sss.fbosobjecttype='C8666A62' ");
        sql.append("and sss.fdatabasedid = '" + pk.toString() + "' ");
        logger.debug((Object)sql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            QCStandardNewImpl qsImp = (QCStandardNewImpl)this.getQMDataBaseDNewImpl();
            while (rs.next()) {
                String orgID = rs.getString("ORGID");
                qsImp.checkBeforeQCItemCanAssign(ctx, orgID, "('" + pk.toString() + "')", false);
                StringBuffer inSql = new StringBuffer();
                inSql.append("INSERT INTO T_QM_QCSTANDARDITEMEXTENDATTR  ");
                inSql.append("(FID,FPARENTID,FQCSTANDARDENTRYID, ");
                inSql.append("FQUALITYORGUNITID,FSEQ) ");
                inSql.append("select newbosid('520A2EA0'),eee.fparentid, ");
                inSql.append("eee.fid as ENTRYID ,'" + orgID + "',1 ");
                inSql.append("from t_qm_qcstandarditementries eee ");
                inSql.append("left join t_qm_qcstandarditemextendattr ttt ");
                inSql.append("on eee.fid = ttt.fqcstandardentryid ");
                inSql.append("and ttt.fqualityorgunitid = '" + orgID + "' ");
                inSql.append("where  eee.fparentid = '" + pk.toString() + "' ");
                inSql.append("and ttt.fid is null");
                logger.debug((Object)inSql.toString());
                st.addBatch(inSql.toString());
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    protected void makeMaterialInfoWithAssignInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select sss.fassignorgunitid as ORGID ");
        sql.append("from t_qm_databasedassign sss ");
        sql.append("where sss.fbosobjecttype='C8666A62' ");
        sql.append("and sss.fdatabasedid = '" + pk.toString() + "' ");
        logger.debug((Object)sql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            QCStandardNewImpl qsImp = (QCStandardNewImpl)this.getQMDataBaseDNewImpl();
            while (rs.next()) {
                String orgID = rs.getString("ORGID");
                qsImp.checkBeforeMaterialAssign(ctx, "('" + pk.toString() + "')", false, orgID);
                StringBuffer inSql = new StringBuffer();
                inSql.append("insert into t_qm_qcstandardmaterialentries  ");
                inSql.append("(fid,fseq,fmaterialgroupid,fmaterialid,fsourceallotid, ");
                inSql.append("fparentid,fisfreeze,fisallot,fqualityorgunitid) ");
                inSql.append("select newbosid('C36D0849'),abc.fseq, ");
                inSql.append("abc.fmaterialgroupid,abc.fmaterialid,abc.fid, ");
                inSql.append("abc.fparentid,abc.fisfreeze,1,'" + orgID + "' ");
                inSql.append(" from t_qm_qcstandardmaterialentries abc ");
                inSql.append("where abc.fparentid = '" + pk.toString() + "' ");
                inSql.append("and abc.fid not in( ");
                inSql.append("select aaa.fsourceallotid from t_qm_qcstandardmaterialentries aaa ");
                inSql.append("where aaa.fqualityorgunitid = '" + orgID + "') ");
                inSql.append("and abc.fqualityorgunitid = '" + this.getCurrentQualityOrgUnit(ctx).getId().toString() + "' ");
                logger.debug((Object)inSql.toString());
                st.addBatch(inSql.toString());
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    protected void saveRelation(Context ctx, QCStandardInfo info) throws BOSException, EASBizException {
        int i;
        Object ibiz = QCStandardExtendAttrFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)this.getCurrentQualityOrgUnit(ctx).getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        QCStandardExtendAttrCollection colls = QCStandardExtendAttrFactory.getLocalInstance(ctx).getQCStandardExtendAttrCollection(ev);
        if (colls.size() == 0) {
            String insertSql = this.buildExtSql(ctx, info);
            DbUtil.execute((Context)ctx, (String)insertSql);
        } else if (colls.size() == 1) {
            QCStandardExtendAttrInfo extendAttrInfo = info.getExtendAttr().get(0);
            QCStrategyEnum strategyEnum = info.getExtendAttr().get(0).getQCStrategy();
            QCStandardExtendAttrInfo innerExtInfo = colls.get(0);
            innerExtInfo.setEachSampleQty(extendAttrInfo.getEachSampleQty());
            innerExtInfo.setEachSampleUnit(extendAttrInfo.getEachSampleUnit());
            innerExtInfo.setQCStrategy(strategyEnum);
            ibiz.update((IObjectPK)new ObjectUuidPK(innerExtInfo.getId()), innerExtInfo);
        }
        AbstractObjectCollection cols = info.getItemEntries();
        IQCStandardItemEntry ibiz2 = QCStandardItemEntryFactory.getLocalInstance(ctx);
        StringBuffer ids = new StringBuffer();
        ids.append("('X'");
        for (int i2 = 0; cols != null && i2 < cols.size(); ++i2) {
            QCStandardItemEntryInfo entryInfo = cols.get(i2);
            entryInfo.setSeq(i2 + 1);
            entryInfo.setParent(info);
            IObjectPK entryPk = ibiz2.submit(entryInfo);
            ids.append(",'" + entryPk + "'");
        }
        ids.append(")");
        try {
            String checkSql = "SELECT FID FROM t_qm_qcstandarditementries TT WHERE TT.FID NOT IN " + ids.toString() + " AND TT.FPARENTID='" + info.getId().toString() + "' ";
            logger.debug((Object)checkSql);
            boolean hasDelEntry = false;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (rs.next()) {
                hasDelEntry = true;
            }
            if (hasDelEntry) {
                checkSql = "select fid from t_qm_databasedassign tt where tt.fdatabasedid = '" + info.getId().toString() + "' and tt.fbosobjecttype='C8666A62'    and tt.fassignorgunitid!='" + this.getCurrentQualityOrgUnit(ctx).getId().toString() + "' ";
                logger.debug((Object)checkSql);
                rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                if (rs.next()) {
                    throw new QCStandardException(QCStandardException.AUDIT_ENTRYDEL);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String delSql = "DELETE FROM  t_qm_qcstandarditemextendattr WHERE FQCSTANDARDENTRYID NOT IN " + ids.toString() + " AND FPARENTID='" + info.getId().toString() + "' ";
        logger.debug((Object)delSql);
        DbUtil.execute((Context)ctx, (String)delSql);
        delSql = "DELETE FROM t_qm_qcstandarditementries WHERE FID NOT IN " + ids.toString() + " AND FPARENTID='" + info.getId().toString() + "' ";
        DbUtil.execute((Context)ctx, (String)delSql);
        logger.debug((Object)delSql);
        ibiz = QCStandardItemExtendAttrFactory.getLocalInstance(ctx);
        for (int j = 0; j < info.getItemEntries().size(); ++j) {
            QCStandardItemEntryInfo entryInfo = info.getItemEntries().get(j);
            for (int i3 = 0; entryInfo.getItemExtendAttr() != null && i3 < entryInfo.getItemExtendAttr().size(); ++i3) {
                QCStandardItemExtendAttrInfo eextInfo = entryInfo.getItemExtendAttr().get(i3);
                entryInfo.setSeq(i3 + 1);
                eextInfo.setParent(info);
                eextInfo.setQCStandardEntry(entryInfo);
                ibiz.submit(eextInfo);
            }
        }
        cols = info.getMaterialEntries();
        Object ibiz22 = QCStandardMaterialEntryFactory.getLocalInstance(ctx);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)this.getCurrentQualityOrgUnit(ctx).getId().toString(), CompareType.EQUALS));
        ibiz22.delete(filter);
        for (i = 0; cols != null && i < cols.size(); ++i) {
            QCStandardMaterialEntryInfo entryInfo = cols.get(i);
            entryInfo.setSeq(i + 1);
            entryInfo.setParent(info);
            ibiz22.submit(entryInfo);
        }
        cols = info.getTechnicsEntries();
        ibiz22 = QCStandardTechnicsEntryFactory.getLocalInstance(ctx);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)this.getCurrentQualityOrgUnit(ctx).getId().toString(), CompareType.EQUALS));
        ibiz22.delete(filter);
        for (i = 0; cols != null && i < cols.size(); ++i) {
            QCStandardTechnicsEntryInfo entryInfo = cols.get(i);
            entryInfo.setSeq(i + 1);
            entryInfo.setParent(info);
            ibiz22.submit(entryInfo);
        }
        cols = info.getProductLineEntries();
        ibiz22 = QCStandardProductLineEntryFactory.getLocalInstance(ctx);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)this.getCurrentQualityOrgUnit(ctx).getId().toString(), CompareType.EQUALS));
        ibiz22.delete(filter);
        for (i = 0; cols != null && i < cols.size(); ++i) {
            QCStandardProductLineEntryInfo entryInfo = cols.get(i);
            entryInfo.setSeq(i + 1);
            entryInfo.setParent(info);
            ibiz22.submit(entryInfo);
        }
        cols = info.getBizObjectEntries();
        ibiz22 = QCStandardBizObjectEntryFactory.getLocalInstance(ctx);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)this.getCurrentQualityOrgUnit(ctx).getId().toString(), CompareType.EQUALS));
        ibiz22.delete(filter);
        for (i = 0; cols != null && i < cols.size(); ++i) {
            QCStandardBizObjectEntryInfo entryInfo = cols.get(i);
            entryInfo.setSeq(i + 1);
            entryInfo.setParent(info);
            ibiz22.submit(entryInfo);
        }
    }

    protected String buildExtSql(Context ctx, QCStandardInfo info) throws EASBizException {
        if (null == info.getExtendAttr().get(0).getQCStrategy()) {
            throw new QCStandardException(QCStandardException.QCSTRATAGE_CANNOTNULL);
        }
        QCStandardExtendAttrInfo extendAttrInfo = info.getExtendAttr().get(0);
        int esQty = extendAttrInfo.getEachSampleQty() == null ? 0 : extendAttrInfo.getEachSampleQty().intValue();
        String esUnitID = extendAttrInfo.getEachSampleUnit() == null ? "" : extendAttrInfo.getEachSampleUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append("T_QM_QCSTANDARDEXTENDATTR ");
        sql.append("(FID,FPARENTID,FSEQ,FCHECKEDSTATUS,FQUALITYORGUNITID,FQCSTRATEGY,FEachSampleQty,FEachSampleUnitID) ");
        sql.append("VALUES ( ");
        sql.append("NEWBOSID('BC89242D'),'" + info.getId().toString() + "',1,1,'" + info.getQualityOrgUnit().getId().toString() + "'," + info.getExtendAttr().get(0).getQCStrategy().getValue() + ", " + esQty + ",'" + esUnitID + "'" + "");
        sql.append(") ");
        return sql.toString();
    }

    protected void makeExtValueForGetValue(Context ctx, QCStandardInfo headInfo) throws BOSException, EASBizException {
        QualityOrgUnitInfo qyOrg = this.getCurrentQualityOrgUnit(ctx);
        if (headInfo == null || headInfo.getId() == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qyOrg.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("eachSampleUnit.id"));
        sic.add(new SelectorItemInfo("eachSampleUnit.number"));
        sic.add(new SelectorItemInfo("eachSampleUnit.name"));
        ev.setSelector(sic);
        QCStandardExtendAttrCollection colls = QCStandardExtendAttrFactory.getLocalInstance(ctx).getQCStandardExtendAttrCollection(ev);
        headInfo.getExtendAttr().addCollection(colls);
        if (colls != null && colls.size() > 0) {
            QCStandardExtendAttrInfo extInfo = colls.get(0);
            headInfo.setCheckedStatus(extInfo.getCheckedStatus());
        }
        IQCStandardItemExtendAttr ieextbiz = QCStandardItemExtendAttrFactory.getLocalInstance(ctx);
        for (int i = 0; i < headInfo.getItemEntries().size(); ++i) {
            QCStandardItemEntryInfo entryInfo = headInfo.getItemEntries().get(i);
            EntityViewInfo innerEV = new EntityViewInfo();
            FilterInfo innerFilter = new FilterInfo();
            innerFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headInfo.getId().toString(), CompareType.EQUALS));
            innerFilter.getFilterItems().add(new FilterItemInfo("qCStandardEntry.id", (Object)entryInfo.getId().toString(), CompareType.EQUALS));
            innerFilter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qyOrg.getId().toString(), CompareType.EQUALS));
            innerEV.setFilter(innerFilter);
            QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)innerEV.getSelector(), (String)"qcGroup", (String[])new String[]{"*"});
            QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)innerEV.getSelector(), (String)"qcInstrumentGroup", (String[])new String[]{"*"});
            QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)innerEV.getSelector(), (String)"qcInstrument", (String[])new String[]{"*"});
            QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)innerEV.getSelector(), (String)"delegOrgUnit", (String[])new String[]{"*"});
            QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)innerEV.getSelector(), (String)"sampleProgram", (String[])new String[]{"id", "name", "number"});
            QCStandardItemExtendAttrCollection eextcols = ieextbiz.getQCStandardItemExtendAttrCollection(innerEV);
            entryInfo.getItemExtendAttr().addCollection(eextcols);
        }
        headInfo.getMaterialEntries().clear();
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qyOrg.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headInfo.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)ev.getSelector(), (String[])new String[]{"material", "materialGroup"});
        AbstractObjectCollection cols = QCStandardMaterialEntryFactory.getLocalInstance(ctx).getQCStandardMaterialEntryCollection(ev);
        headInfo.getMaterialEntries().addCollection((QCStandardMaterialEntryCollection)cols);
        headInfo.getTechnicsEntries().clear();
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qyOrg.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headInfo.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)ev.getSelector(), (String[])new String[]{"WorkingProcedureGroup", "material", "technicsRoute", "WorkingProcedure"});
        cols = QCStandardTechnicsEntryFactory.getLocalInstance(ctx).getQCStandardTechnicsEntryCollection(ev);
        headInfo.getTechnicsEntries().addCollection((QCStandardTechnicsEntryCollection)cols);
        headInfo.getProductLineEntries().clear();
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qyOrg.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headInfo.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)ev.getSelector(), (String[])new String[]{"productLine", "material", "ProductLineWP"});
        cols = QCStandardProductLineEntryFactory.getLocalInstance(ctx).getQCStandardProductLineEntryCollection(ev);
        headInfo.getProductLineEntries().addCollection((QCStandardProductLineEntryCollection)cols);
        headInfo.getBizObjectEntries().clear();
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qyOrg.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headInfo.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)ev.getSelector(), (String[])new String[]{"qCBizObjectGroup", "qCBizObject"});
        cols = QCStandardBizObjectEntryFactory.getLocalInstance(ctx).getQCStandardBizObjectEntryCollection(ev);
        headInfo.getBizObjectEntries().addCollection((QCStandardBizObjectEntryCollection)cols);
    }

    protected IVerifyManager getSubmitVerifyManager(Context ctx, QCStandardInfo info) {
        VerifyManager manager = new VerifyManager();
        QCStandardSubmitVerifyItem verifyItem = new QCStandardSubmitVerifyItem(ctx, info);
        manager.addVerifyItem((IVerifyItem)verifyItem);
        return manager;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QCStandardInfo info = (QCStandardInfo)this._getValue(ctx, pk);
        this.getDeleteVerifyManager(ctx, (QMCoreDataBaseInfo)info).verify();
        this.deleteRelation(ctx, (IObjectPK[])new ObjectStringPK[]{new ObjectStringPK(pk.toString())});
        super._delete(ctx, pk);
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        QCStandardCollection colls = this.getQCStandardCollection(ctx, ev);
        ObjectUuidPK[] pks = new ObjectUuidPK[colls.size()];
        for (int i = 0; i < colls.size(); ++i) {
            pks[i] = new ObjectUuidPK(colls.get(i).getId());
        }
        this.deleteRelation(ctx, (IObjectPK[])pks);
        return super._delete(ctx, filter);
    }

    protected void _delete(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.deleteRelation(ctx, pks);
        super._delete(ctx, pks);
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        QCStandardCollection colls = this.getQCStandardCollection(ctx, oql);
        ObjectUuidPK[] pks = new ObjectUuidPK[colls.size()];
        for (int i = 0; i < colls.size(); ++i) {
            pks[i] = new ObjectUuidPK(colls.get(i).getId());
        }
        this.deleteRelation(ctx, (IObjectPK[])pks);
        return super._delete(ctx, oql);
    }

    protected void deleteRelation(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"error delete!"});
        }
        StringBuffer whereSql = new StringBuffer();
        whereSql.append("''");
        for (int i = 0; i < pks.length; ++i) {
            whereSql.append(",'" + pks[i].toString() + "'");
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardextendattr WHERE fparentid in (" + whereSql.toString() + ")");
            logger.debug((Object)("delete sql is :" + deleteSql.toString()));
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandarditementries WHERE fparentid in(" + whereSql.toString() + ")");
            logger.debug((Object)("delete sql is :" + deleteSql.toString()));
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandarditemextendattr WHERE fparentid in(" + whereSql.toString() + ")");
            logger.debug((Object)("delete sql is :" + deleteSql.toString()));
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardmaterialentries WHERE fparentid in(" + whereSql.toString() + ")");
            logger.debug((Object)("delete sql is :" + deleteSql.toString()));
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardplineentry WHERE fparentid in(" + whereSql.toString() + ")");
            logger.debug((Object)("delete sql is :" + deleteSql.toString()));
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardtechnicsentries WHERE fparentid in(" + whereSql.toString() + ")");
            logger.debug((Object)("delete sql is :" + deleteSql.toString()));
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardboentry WHERE fparentid in (" + whereSql.toString() + ")");
            logger.debug((Object)("delete sql is :" + deleteSql.toString()));
            st.addBatch(deleteSql.toString());
            logger.info((Object)"delete entrys relations begin !!!");
            st.executeBatch();
            logger.info((Object)">>>>>>>>> delete entrys relations end!!!");
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("itemEntries.*");
        sic.add("itemEntries.qCItem.number");
        sic.add("itemEntries.qCItem.name");
        sic.add("itemEntries.qCItem.qCValueType");
        sic.add("itemEntries.qCItem.QCIdentity");
        QCStandardInfo info = (QCStandardInfo)this._getExtValue(ctx, pk, sic);
        this.getAuditVerifyManager(ctx, info).verify();
        this.getOrgAuditVerifyManager(ctx, info).verify();
        this.extOrgAudit(ctx, info, true);
        if (this.isCreateQualityOrg(ctx, info)) {
            this.allAudit(ctx, pk);
            String updateSql = "update t_qm_qcstandard  set fcheckedstatus =2 where fid = '" + pk.toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QCStandardInfo info = (QCStandardInfo)this._getExtValue(ctx, pk);
        this.getOrgUnAuditVerifyManager(ctx, info).verify();
        this.extOrgAudit(ctx, info, false);
        if (this.isCreateQualityOrg(ctx, info)) {
            this.allUnAudit(ctx, pk);
            String updateSql = "update t_qm_qcstandard  set fcheckedstatus =1 where fid = '" + pk.toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    protected void allAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QualityOrgUnitInfo orgInfo = this.getCurrentQualityOrgUnit(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("update t_qm_qcstandardextendattr ");
        sql.append("set fcheckedstatus = 2  ");
        sql.append("where fqualityorgunitid not in( ");
        sql.append("select t.fqualityorgunitid  ");
        sql.append("from t_qm_qcstandarditemextendattr t ");
        sql.append("where (t.fqcgroupid is null ");
        sql.append("or t.fdelegorgunitid is null) ");
        sql.append("and t.fparentid = '" + pk.toString() + "') ");
        sql.append("and fqualityorgunitid!='" + orgInfo.getId().toString() + "' ");
        sql.append("and fparentid = '" + pk.toString() + "' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void allUnAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QualityOrgUnitInfo orgInfo = this.getCurrentQualityOrgUnit(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("update t_qm_qcstandardextendattr ");
        sql.append("set fcheckedstatus = 1 ");
        sql.append("where fqualityorgunitid!='" + orgInfo.getId().toString() + "' ");
        sql.append("and fparentid = '" + pk.toString() + "' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void extOrgAudit(Context ctx, QCStandardInfo info, boolean isaudit) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        this.lockData(ctx, pk.toString());
        IQCStandardExtendAttr ibiz = QCStandardExtendAttrFactory.getLocalInstance(ctx);
        if (info.getExtendAttr() != null && info.getExtendAttr().size() > 0) {
            QCStandardExtendAttrInfo extInfo;
            if ((isaudit ? 2 : 1) == (extInfo = info.getExtendAttr().get(0)).getCheckedStatus().getValue()) {
                throw new QMVerifyException(isaudit ? QMVerifyException.DBAUDIT_HASAUDIT : QMVerifyException.DBUNAUDIT_NOAUDIT);
            }
            extInfo.setCheckedStatus(isaudit ? DBCheckedStatusEnum.AUDITED : DBCheckedStatusEnum.UNAUDITED);
            ibiz.submit(extInfo);
        } else {
            QCStandardExtendAttrInfo extInfo = new QCStandardExtendAttrInfo();
            extInfo.setParent(info);
            extInfo.setQualityOrgUnit(this.getCurrentQualityOrgUnit(ctx));
            extInfo.setCheckedStatus(isaudit ? DBCheckedStatusEnum.AUDITED : DBCheckedStatusEnum.UNAUDITED);
            ibiz.submit(extInfo);
        }
    }

    public IVerifyManager getDeleteVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager imanager = new VerifyManager();
        QCStandardDeleteVerifyItem item = new QCStandardDeleteVerifyItem((QCStandardInfo)info, ctx);
        imanager.addVerifyItem((IVerifyItem)item);
        imanager.addChildrenManager(super.getDeleteVerifyManager(ctx, info));
        return imanager;
    }

    protected IVerifyManager getOrgAuditVerifyManager(Context ctx, QCStandardInfo info) throws EASBizException, BOSException {
        VerifyManager imanager = new VerifyManager();
        QCStandardOrgAuditVerifyItem item = new QCStandardOrgAuditVerifyItem(info, ctx, this.getCurrentQualityOrgUnit(ctx).getId().toString());
        imanager.addVerifyItem((IVerifyItem)item);
        return imanager;
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, QMDataBaseDInfo info) {
        IVerifyManager imanager = super.getAuditVerifyManager(ctx, info);
        imanager.addVerifyItem((IVerifyItem)new QCStandardNormalAuditVerifyItem(ctx, (QCStandardInfo)info));
        return imanager;
    }

    protected IVerifyManager getOrgUnAuditVerifyManager(Context ctx, QCStandardInfo info) throws EASBizException, BOSException {
        VerifyManager imanager = new VerifyManager();
        QCStandardOrgUnAuditVerifyItem item = new QCStandardOrgUnAuditVerifyItem(info, ctx);
        imanager.addVerifyItem((IVerifyItem)item);
        return imanager;
    }

    protected IVerifyManager getCancelCancelVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager imanager = new VerifyManager();
        QCStandardCancelVerifyItem item = new QCStandardCancelVerifyItem((QCStandardInfo)info, ctx, false);
        imanager.addVerifyItem((IVerifyItem)item);
        imanager.addChildrenManager(super.getCancelCancelVerifyManager(ctx, info));
        return imanager;
    }

    protected IVerifyManager getCancelVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager imanager = new VerifyManager();
        QCStandardCancelVerifyItem item = new QCStandardCancelVerifyItem((QCStandardInfo)info, ctx, true);
        imanager.addVerifyItem((IVerifyItem)item);
        imanager.addChildrenManager(super.getCancelVerifyManager(ctx, info));
        return imanager;
    }

    @Override
    protected IObjectValue _getExtValue(Context ctx, IObjectPK pk, SelectorItemCollection sic) throws BOSException, EASBizException {
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("itemEntries.seq"));
        QCStandardInfo info = (QCStandardInfo)this._getValue(ctx, pk, sic, sort);
        this.makeExtValueForGetValue(ctx, info);
        return info;
    }

    @Override
    protected IObjectValue _getExtValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QCStandardInfo info = (QCStandardInfo)this._getValue(ctx, pk);
        this.makeExtValueForGetValue(ctx, info);
        return info;
    }

    protected QMDataBaseDNewImpl getQMDataBaseDNewImpl() {
        return new QCStandardNewImpl();
    }

    @Override
    protected boolean _isStandardAssign(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select fid from t_qm_databasedassign t ");
        checkSql.append("where t.fbosobjecttype = 'C8666A62' ");
        checkSql.append("and t.fdatabasedid = '" + pk.toString() + "' ");
        checkSql.append("and t.fassignorgunitid!='" + this.getCurrentQualityOrgUnit(ctx).getId().toString() + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected MaterialGroupInfo _getMaterialQMGroup(Context ctx, String materialID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fmaterialgroupid as GROUPID  ");
        sql.append("from T_BD_MaterialGroupDetial t ");
        sql.append("where t.fmaterialid = '" + materialID + "' ");
        sql.append("and t.fmaterialgroupstandardid = 'aVgJygEgEADgAABEfwAAAZeb4R8=' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String groupID = "";
        try {
            if (rs.next()) {
                groupID = rs.getString("GROUPID");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (!StringUtil.isEmptyString((String)groupID)) {
            return MaterialGroupFactory.getLocalInstance((Context)ctx).getMaterialGroupInfo((IObjectPK)new ObjectStringPK(groupID));
        }
        return null;
    }

    protected Set _getMaterialeFilterByProductLine(Context ctx, String productLineID) throws BOSException, EASBizException {
        return this.buildMaterialAndProductLineFilter(ctx, productLineID, false);
    }

    @Override
    protected Set _getProductLineFilterByMaterial(Context ctx, String materialID) throws BOSException, EASBizException {
        return this.buildMaterialAndProductLineFilter(ctx, materialID, true);
    }

    protected Set buildMaterialAndProductLineFilter(Context ctx, String id, boolean isMaterial) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t2.fmaterialid AS MATERIALID, ");
        sql.append("T3.FPRODUCTLINEID AS PRODUCTLINEID  ");
        sql.append("from T_MM_ProductLinePAllotDef T1 ");
        sql.append("INNER JOIN T_MM_ProductLPADE T2 ");
        sql.append("ON T1.FID = T2.FPARENTID ");
        sql.append("INNER JOIN T_MM_ProductLPADRE T3 ");
        sql.append("ON T2.FID = T3.FPARENTID ");
        sql.append("WHERE T1.FSTATUS = 20 ");
        if (isMaterial) {
            sql.append("AND T2.FMATERIALID ='" + id + "'  ");
        } else {
            sql.append("AND T3.FPRODUCTLINEID = '" + id + "' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            while (rs.next()) {
                String filterid = rs.getString(isMaterial ? "PRODUCTLINEID" : "MATERIALID");
                set.add(filterid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (set.size() == 0) {
            set.add("");
        }
        return set;
    }

    @Override
    protected Map _getProductLineFilterByMaterial(Context ctx, List materialIDs) throws BOSException, EASBizException {
        HashMap<String, FilterItemInfo> cacheMap = new HashMap<String, FilterItemInfo>();
        for (String key : materialIDs) {
            Set tempSet = this._getProductLineFilterByMaterial(ctx, key);
            FilterItemInfo itemInfo = new FilterItemInfo("id", (Object)tempSet, CompareType.INCLUDE);
            cacheMap.put(key, itemInfo);
        }
        return cacheMap;
    }

    public BatchExecuteResult batchAudit(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        return super.batchAudit(ctx, paramEntries);
    }

    public IServerBatchAction getBatchAuditAction(Context ctx) {
        QCStandardServerBatchAuditAction auditAction = new QCStandardServerBatchAuditAction((ISuportServerBatchAction)this, "BEFORE_AUDIT", "AFTER_AUDIT");
        return auditAction;
    }

    public BatchExecuteResult batchUnAudit(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        return super.batchUnAudit(ctx, paramEntries);
    }

    public IServerBatchAction getBatchUnAuditAction(Context ctx) {
        QCStandardServerBatchUnAuditAction unauditAction = new QCStandardServerBatchUnAuditAction((ISuportServerBatchAction)this, "BEFORE_UNAUDIT", "AFTER_UNAUDIT");
        return unauditAction;
    }

    public IServerBatchAction getBatchDeleteAction() {
        QCStandardServerBatchDeleteAction action = new QCStandardServerBatchDeleteAction((ISuportServerBatchAction)this, "BEFORE_DELETE", "AFTER_DELETE");
        return action;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("itemEntries.seq"));
        return super._getValue(ctx, pk, selector, sort);
    }
}

