/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.qm.basedata.QCStandardException;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.QMVerifyException;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ServerBatchAction;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class QCStandardServerBatchBaseAction
extends ServerBatchAction {
    public QCStandardServerBatchBaseAction(ISuportServerBatchAction bean, String beforeEventName, String afterEventName) {
        super(bean, beforeEventName, afterEventName);
    }

    protected void batchCheckBySql(Context ctx, String checkSql, String pkFiledName, Throwable ex, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            while (rs.next()) {
                String standardID = rs.getString(pkFiledName);
                BOSUuid sduuid = BOSUuid.read((String)standardID);
                int index = successedColl.indexOf((Object)sduuid);
                if (index < 0) continue;
                successedColl.removeObject(index);
                this.putException(result, standardID, ex);
            }
        }
        catch (SQLException sqlex) {
            throw new SQLDataException(sqlex);
        }
    }

    protected void batchCheckMulQCItem(Context ctx, String checkSql, BatchExecuteResult result, String pkFieldName, String itemNumberFieldName, CoreBaseCollection successedColl) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        HashMap<String, StringBuffer> mulMap = new HashMap<String, StringBuffer>();
        try {
            while (rs.next()) {
                StringBuffer qcItemNums;
                String standardID = rs.getString(pkFieldName);
                String itemNumber = rs.getString(itemNumberFieldName);
                if (mulMap.get(standardID) == null) {
                    qcItemNums = new StringBuffer();
                    qcItemNums.append(itemNumber);
                    mulMap.put(standardID, qcItemNums);
                    continue;
                }
                qcItemNums = (StringBuffer)mulMap.get(standardID);
                qcItemNums.append(", " + itemNumber);
            }
            if (mulMap == null || mulMap.size() == 0) {
                return;
            }
            for (String stdId : mulMap.keySet()) {
                String itemNums = ((StringBuffer)mulMap.get(stdId)).toString();
                QCStandardException ex = new QCStandardException(QCStandardException.HASREPEATEDQCITEM, new Object[]{itemNums});
                BOSUuid sduuid = BOSUuid.read((String)stdId);
                int index = successedColl.indexOf((Object)sduuid);
                if (index < 0) continue;
                successedColl.removeObject(index);
                this.putException(result, stdId, (Throwable)((Object)ex));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void batchCheckEntryBySql(Context ctx, String checkSql, NumericExceptionSubItem exItem, BatchExecuteResult result, String pkFieldName, String seqFieldName, CoreBaseCollection successedColl) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        HashMap<String, StringBuffer> seqMap = new HashMap<String, StringBuffer>();
        try {
            CharSequence itemSeqs;
            while (rs.next()) {
                String standardID = rs.getString(pkFieldName);
                String seq = rs.getString(seqFieldName);
                if (seqMap.get(standardID) == null) {
                    itemSeqs = new StringBuffer();
                    itemSeqs.append(seq);
                    seqMap.put(standardID, (StringBuffer)itemSeqs);
                    continue;
                }
                itemSeqs = (StringBuffer)seqMap.get(standardID);
                itemSeqs.append(", " + seq);
            }
            if (seqMap == null || seqMap.size() == 0) {
                return;
            }
            for (String stdId : seqMap.keySet()) {
                itemSeqs = ((StringBuffer)seqMap.get(stdId)).toString();
                QCStandardException ex = new QCStandardException(exItem, new Object[]{itemSeqs});
                BOSUuid sduuid = BOSUuid.read((String)stdId);
                int index = successedColl.indexOf((Object)sduuid);
                if (index < 0) continue;
                successedColl.removeObject(index);
                this.putException(result, stdId, (Throwable)((Object)ex));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected String getSuccessedIDS(Context ctx, CoreBaseCollection successedColl) {
        StringBuffer ids = new StringBuffer();
        ids.append("''");
        for (Object obj : successedColl) {
            IObjectValue objValue;
            String tempID;
            if (!(obj instanceof IObjectValue) || (tempID = (objValue = (IObjectValue)obj).getString(objValue.getPKField())) == null) continue;
            ids.append(",'" + tempID + "'");
        }
        return ids.toString();
    }

    protected void checkHeadExtDataRight(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl, String ids, String currentQMOrgID) throws BOSException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select t1.fid as fid1,t2.fid as fid2 from t_qm_qcstandard t1 \n");
        checkSql.append("left join t_qm_qcstandardextendattr t2 \n");
        checkSql.append("on (t1.fid = t2.fparentid \n");
        checkSql.append("and t2.fqualityorgunitid = '" + currentQMOrgID + "' \n");
        checkSql.append(") \n");
        checkSql.append("where t1.fid in (" + ids + ") \n");
        checkSql.append("and t2.fid is null \n");
        checkSql.append(" \n");
        this.batchCheckBySql(ctx, checkSql.toString(), "fid1", (Throwable)new QMException(QMException.BLANK, (Object[])new String[]{"error qcstandard object!"}), result, successedColl);
    }

    protected void checkAuditStatusSql(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl, String currentQMOrgID, String ids, boolean isaudit) throws BOSException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select t1.fid as fid1, \n");
        checkSql.append("t2.fid as fid2,t2.fcheckedstatus \n");
        checkSql.append("from t_qm_qcstandard t1 \n");
        checkSql.append("left join t_qm_qcstandardextendattr t2 \n");
        checkSql.append("on (t1.fid = t2.fparentid \n");
        checkSql.append("and t2.fqualityorgunitid = '" + currentQMOrgID + "' \n");
        checkSql.append(") \n");
        checkSql.append("where t1.fid in (" + ids + ") \n");
        if (isaudit) {
            checkSql.append("and t2.fcheckedstatus = 2 \n");
        } else {
            checkSql.append("and t2.fcheckedstatus != 2 \n");
        }
        checkSql.append(" \n");
        this.batchCheckBySql(ctx, checkSql.toString(), "fid1", (Throwable)new QMVerifyException(isaudit ? QMVerifyException.DBAUDIT_HASAUDIT : QMVerifyException.DBUNAUDIT_NOAUDIT), result, successedColl);
    }

    protected StringBuffer doAduit3(String currentQMOrgID, String ids, boolean isAudit) {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_qm_qcstandardextendattr ");
        sql.append("set fcheckedstatus = " + (isAudit ? 2 : 1) + "  ");
        sql.append("where fqualityorgunitid not in( ");
        sql.append("select t.fqualityorgunitid  ");
        sql.append("from t_qm_qcstandarditemextendattr t ");
        sql.append("where t.fdelegorgunitid is null ");
        sql.append("and t.fparentid in(" + ids + ") ) ");
        sql.append("and fqualityorgunitid!='" + currentQMOrgID + "' ");
        sql.append("and fparentid in ( \n ");
        sql.append(" SELECT FID FROM T_QM_QCSTANDARD TS \n");
        sql.append(" WHERE TS.FID IN (" + ids + ") \n");
        sql.append("AND TS.FQUALITYORGUNITID = '" + currentQMOrgID + "' \n");
        sql.append(") \n");
        sql.append(" \n");
        return sql;
    }

    protected StringBuffer doAudit2(String currentQMOrgID, String ids, boolean isAudit) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_QM_QCSTANDARD  \n");
        sql.append(" SET FCHECKEDSTATUS =" + (isAudit ? 2 : 1) + " \n");
        sql.append(" WHERE FID IN (" + ids + ") \n");
        sql.append(" AND FQUALITYORGUNITID = '" + currentQMOrgID + "' \n");
        sql.append(" \n");
        return sql;
    }

    protected StringBuffer doAudit1(String currentQMOrgID, String ids, boolean isAudit) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_QM_QCSTANDARDEXTENDATTR  \n");
        sql.append("SET FCHECKEDSTATUS = " + (isAudit ? 2 : 1) + " \n");
        sql.append("WHERE FPARENTID IN(" + ids + ") \n");
        sql.append("AND FQUALITYORGUNITID = '" + currentQMOrgID + "' \n");
        sql.append(" \n");
        return sql;
    }
}

