/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.qm.basedata.QCSamplingProgramException;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.QMVerifyException;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.util.app.ContextUtil;

public class QCDataBaseSamplingProgramAuditVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private QCSamplingProgramInfo info;
    private Context ctx;

    public QCDataBaseSamplingProgramAuditVerifyItem(QCSamplingProgramInfo info, Context ctx) {
        this.info = info;
        this.ctx = ctx;
    }

    public boolean verify() throws EASBizException, BOSException {
        if (this.info.getEffectedStatus() != EffectedStatusEnum.EFFECTED) {
            throw new QMVerifyException(QMVerifyException.DBAUDIT_ISSAVE);
        }
        if (this.info.getCheckedStatus() == DBCheckedStatusEnum.AUDITED) {
            throw new QMVerifyException(QMVerifyException.DBAUDIT_HASAUDIT);
        }
        if (this.info.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            throw new QMVerifyException(QMVerifyException.DBAUDIT_ISCANCEL);
        }
        QualityOrgUnitInfo orgInfo = ContextUtil.getCurrentQualityUnit((Context)this.ctx);
        if (!orgInfo.getId().toString().equals(this.info.getQualityOrgUnit().getId().toString())) {
            throw new QCSamplingProgramException(QCSamplingProgramException.ASSIGNEDCANNOTAUDIT);
        }
        return true;
    }
}

