/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.EvaluateModeEnum;
import com.kingdee.eas.qm.basedata.MergeModeEnum;
import com.kingdee.eas.qm.basedata.QCIdentityEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCStandardException;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class QCStandardNormalAuditVerifyItem
extends AbstractVerifyItem {
    private Context ctx;
    private QCStandardInfo info;

    public QCStandardNormalAuditVerifyItem(Context ctx, QCStandardInfo info) {
        this.ctx = ctx;
        this.info = info;
    }

    public boolean verify() throws EASBizException, BOSException {
        this.verifyHead();
        this.verifyItemEntry();
        return true;
    }

    protected void verifyHead() throws EASBizException, BOSException {
        if (this.info.getQcStandardType() == null) {
            throw new QCStandardException(QCStandardException.QCSTANDARDTYPECANNOTNULL);
        }
        QualityOrgUnitInfo currOrg = this.getCurrentQualityOrg();
        StringBuffer oql = new StringBuffer();
        oql.append("select eachSampleUnit.id,eachSampleQty");
        oql.append(" where parent.id='" + this.info.getId().toString() + "'");
        oql.append(" and qualityOrgUnit.id='" + currOrg.getId().toString() + "'");
        QCStandardExtendAttrInfo extInfo = QCStandardExtendAttrFactory.getLocalInstance(this.ctx).getQCStandardExtendAttrInfo(oql.toString());
        BigDecimal eachSampleQty = extInfo.getEachSampleQty();
        MeasureUnitInfo eachSampleUnit = extInfo.getEachSampleUnit();
        SampleSolutionEnum qcType = this.info.getSampleSolution();
        if (SampleSolutionEnum.allCheck.equals((Object)qcType) && !QMEqualsUtils.equals((Object)new BigDecimal("1"), (Object)eachSampleQty)) {
            throw new QCStandardException(QCStandardException.EACHSAMQTYMUSTONEBYALLCHECK);
        }
        if (!NumericUtils.equalsZero((BigDecimal)eachSampleQty) && eachSampleUnit == null) {
            throw new QCStandardException(QCStandardException.EACHSAMPLEUNITCANNOTNULL);
        }
    }

    protected void verifyItemEntry() throws EASBizException, BOSException {
        Object[] params;
        QCStandardItemEntryCollection itemEntrys = this.info.getItemEntries();
        if (itemEntrys == null || itemEntrys.size() == 0) {
            return;
        }
        Iterator iter = itemEntrys.iterator();
        ArrayList<BOSUuid> itemIds = new ArrayList<BOSUuid>();
        ArrayList<QCItemInfo> multiItems = new ArrayList<QCItemInfo>();
        StringBuffer spItemIndexs = new StringBuffer();
        StringBuffer mergeModeNullIndexs = new StringBuffer();
        StringBuffer mergeModeNotNullIndexs = new StringBuffer();
        StringBuffer acqModeNullIndexs = new StringBuffer();
        StringBuffer acqModeErrIndexs = new StringBuffer();
        StringBuffer pointSmpGrgmIndexs = new StringBuffer();
        StringBuffer tallySmpGrgmIndexs = new StringBuffer();
        StringBuffer measureSmpGrgmIndexs = new StringBuffer();
        StringBuffer unAssignedSmpGrgmIndexs = new StringBuffer();
        SampleSolutionEnum qcType = this.info.getSampleSolution();
        int index = 0;
        while (iter.hasNext()) {
            QCStandardItemEntryInfo entry = (QCStandardItemEntryInfo)iter.next();
            ++index;
            QCItemInfo qcItem = entry.getQCItem();
            QCValueTypeEnum valueType = qcItem.getQCValueType();
            QCIdentityEnum identity = qcItem.getQCIdentity();
            MergeModeEnum mergeMode = entry.getMergeMode();
            QCValueAcquisitionModeEnum acqMode = entry.getQCValueAcquisitionMode();
            if (qcItem != null && qcItem.getId() != null) {
                if (itemIds.indexOf(qcItem.getId()) >= 0) {
                    multiItems.add(qcItem);
                } else {
                    itemIds.add(qcItem.getId());
                }
            }
            QCStandardItemExtendAttrInfo itemExt = this.getCurrentItemExtInfo(entry);
            QCSamplingProgramInfo sampleProgram = itemExt.getSampleProgram();
            if (SampleSolutionEnum.allCheck.equals((Object)qcType) && sampleProgram != null) {
                if (spItemIndexs.length() > 0) {
                    spItemIndexs.append("\uff0c");
                }
                spItemIndexs.append(String.valueOf(index));
            }
            if (sampleProgram != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("select count(1) as cont \n");
                sql.append("from T_QM_DatabasedAssign bb \n");
                sql.append("where bb.fassignorgunitid = '" + this.getCurrentQualityOrg().getId().toString() + "' \n");
                sql.append("and bb.fbosobjecttype ='147DC558' \n");
                sql.append("and bb.fdatabasedid = '" + sampleProgram.getId().toString() + "'");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                try {
                    if (rs.next() && rs.getInt("cont") == 0) {
                        if (unAssignedSmpGrgmIndexs.length() > 0) {
                            unAssignedSmpGrgmIndexs.append("\uff0c");
                        }
                        unAssignedSmpGrgmIndexs.append(String.valueOf(index));
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            if (SampleSolutionEnum.takeOutCheck.equals((Object)qcType) && sampleProgram != null) {
                EvaluateModeEnum evalMode = sampleProgram.getEvaluationMode();
                if (QCIdentityEnum.point.equals((Object)identity) && EvaluateModeEnum.pointdeterminebymanual != evalMode && EvaluateModeEnum.pointdeterminebysys != evalMode) {
                    if (pointSmpGrgmIndexs.length() > 0) {
                        pointSmpGrgmIndexs.append("\uff0c");
                    }
                    pointSmpGrgmIndexs.append(String.valueOf(index));
                }
                if (QCIdentityEnum.tally.equals((Object)identity) && EvaluateModeEnum.countdeterminebymanual != evalMode && EvaluateModeEnum.countdeterminebysys != evalMode) {
                    if (tallySmpGrgmIndexs.length() > 0) {
                        tallySmpGrgmIndexs.append("\uff0c");
                    }
                    tallySmpGrgmIndexs.append(String.valueOf(index));
                }
                if (QCIdentityEnum.measure.equals((Object)identity)) {
                    if (measureSmpGrgmIndexs.length() > 0) {
                        measureSmpGrgmIndexs.append("\uff0c");
                    }
                    measureSmpGrgmIndexs.append(String.valueOf(index));
                }
            }
            if ((QCValueTypeEnum.number.equals((Object)valueType) || QCValueTypeEnum.formula.equals((Object)valueType)) && (mergeMode == null || MergeModeEnum.NULL.equals((Object)mergeMode))) {
                if (mergeModeNullIndexs.length() > 0) {
                    mergeModeNullIndexs.append("\uff0c");
                }
                mergeModeNullIndexs.append(String.valueOf(index));
            }
            if ((QCValueTypeEnum.text.equals((Object)valueType) || QCValueTypeEnum.enumvalue.equals((Object)valueType)) && mergeMode != null && !MergeModeEnum.NULL.equals((Object)mergeMode)) {
                if (mergeModeNotNullIndexs.length() > 0) {
                    mergeModeNotNullIndexs.append("\uff0c");
                }
                mergeModeNotNullIndexs.append(String.valueOf(index));
            }
            if (acqMode == null) {
                if (acqModeNullIndexs.length() > 0) {
                    acqModeNullIndexs.append("\uff0c");
                }
                acqModeNullIndexs.append(String.valueOf(index));
                continue;
            }
            if (!QCValueTypeEnum.formula.equals((Object)valueType) || QCValueAcquisitionModeEnum.BYQCITEM.equals((Object)acqMode)) continue;
            if (acqModeErrIndexs.length() > 0) {
                acqModeErrIndexs.append("\uff0c");
            }
            acqModeErrIndexs.append(String.valueOf(index));
        }
        if (multiItems != null && multiItems.size() > 0) {
            StringBuffer multItemNums = new StringBuffer();
            for (int i = 0; i < multiItems.size(); ++i) {
                QCItemInfo qcItem = (QCItemInfo)multiItems.get(i);
                if (i > 0) {
                    multItemNums.append(", ");
                }
                multItemNums.append(qcItem.getNumber());
            }
            Object[] params2 = new Object[]{multItemNums};
            throw new QCStandardException(QCStandardException.HASREPEATEDQCITEM, params2);
        }
        if (spItemIndexs != null && spItemIndexs.length() > 0) {
            params = new Object[]{spItemIndexs};
            throw new QCStandardException(QCStandardException.SAMPLEPRGMMUSTNULLBYALLCHECK, params);
        }
        if (unAssignedSmpGrgmIndexs != null && unAssignedSmpGrgmIndexs.length() > 0) {
            params = new Object[]{unAssignedSmpGrgmIndexs};
            throw new QCStandardException(QCStandardException.QCSAMPRGMHASNOTASSIGNED, params);
        }
        if (pointSmpGrgmIndexs != null && pointSmpGrgmIndexs.length() > 0) {
            params = new Object[]{pointSmpGrgmIndexs};
            throw new QCStandardException(QCStandardException.POINTQCIDENTITYMUSTPOINTSMPPRGM, params);
        }
        if (tallySmpGrgmIndexs != null && tallySmpGrgmIndexs.length() > 0) {
            params = new Object[]{tallySmpGrgmIndexs};
            throw new QCStandardException(QCStandardException.TALLYQCIDENTITYMUSTTALLYSMPPRGM, params);
        }
        if (measureSmpGrgmIndexs != null && measureSmpGrgmIndexs.length() > 0) {
            params = new Object[]{measureSmpGrgmIndexs};
            throw new QCStandardException(QCStandardException.MEASUREQCIDENTITYSMPPRGMMUSTNULL, params);
        }
        if (mergeModeNotNullIndexs != null && mergeModeNotNullIndexs.length() > 0) {
            params = new Object[]{mergeModeNotNullIndexs};
            throw new QCStandardException(QCStandardException.MERGEMODEMUSTNULLBYTXTORENUM, params);
        }
        if (mergeModeNullIndexs != null && mergeModeNullIndexs.length() > 0) {
            params = new Object[]{mergeModeNullIndexs};
            throw new QCStandardException(QCStandardException.MERGEMODECANNOTNULLBYNUMORFORMULA, params);
        }
        if (acqModeNullIndexs != null && acqModeNullIndexs.length() > 0) {
            params = new Object[]{acqModeNullIndexs};
            throw new QCStandardException(QCStandardException.QCVALUEACQMODECANNOTNULL, params);
        }
        if (acqModeErrIndexs != null && acqModeErrIndexs.length() > 0) {
            params = new Object[]{acqModeErrIndexs};
            throw new QCStandardException(QCStandardException.QCVALUEACQMODEMUSTBEQCITEM, params);
        }
    }

    protected QCStandardItemExtendAttrInfo getCurrentItemExtInfo(QCStandardItemEntryInfo entry) throws EASBizException, BOSException {
        QualityOrgUnitInfo org = this.getCurrentQualityOrg();
        StringBuffer oql = new StringBuffer();
        oql.append("select sampleProgram.id,sampleProgram.evaluationMode");
        oql.append(" where parent='" + this.info.getId().toString() + "'");
        oql.append(" and qCStandardEntry.id='" + entry.getId().toString() + "'");
        oql.append(" and qualityOrgUnit.id='" + org.getId().toString() + "'");
        return QCStandardItemExtendAttrFactory.getLocalInstance(this.ctx).getQCStandardItemExtendAttrInfo(oql.toString());
    }

    private QualityOrgUnitInfo getCurrentQualityOrg() throws QMException {
        QualityOrgUnitInfo currOrg = ContextUtil.getCurrentQualityUnit((Context)this.ctx);
        if (currOrg == null) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"Error QualityOrgUnit!!!"});
        }
        return currOrg;
    }
}

