/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCStandardBizObjectEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardException;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardMaterialEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardProductLineEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardTechnicsEntryInfo;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.QMVerifyException;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;

public class QCStandardOrgAuditVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private Context ctx;
    private QCStandardInfo info;
    private String orgID;

    public QCStandardOrgAuditVerifyItem(QCStandardInfo info, Context ctx, String orgID) {
        this.ctx = ctx;
        this.info = info;
        this.orgID = orgID;
    }

    public boolean verify() throws EASBizException, BOSException {
        this.headAndItemEntryVerify();
        this.materialEntryVerify();
        this.productLineEntriesVerify();
        this.technicsEntriesVerify();
        this.bizObjectEntriesVerify();
        return true;
    }

    protected void headAndItemEntryVerify() throws EASBizException, BOSException {
        if (this.info.getExtendAttr() == null || this.info.getExtendAttr().size() == 0) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"error qcstandard object!"});
        }
        QCStandardExtendAttrInfo extInfo = this.info.getExtendAttr().get(0);
        try {
            StringBuffer checkSql = null;
            IRowSet rs = null;
            checkSql = new StringBuffer();
            checkSql.append("select t1.fid \n");
            checkSql.append(" from t_qm_qcstandarditementries t1 \n");
            checkSql.append(" left join t_qm_qcstandarditemextendattr t2 \n");
            checkSql.append("on t1.fid =t2.fqcstandardentryid \n");
            checkSql.append("where t1.fparentid = '" + this.info.getId() + "' \n");
            checkSql.append("and isnull(t2.fqualityorgunitid, '" + this.orgID + "') = '" + this.orgID + "' \n");
            checkSql.append("and (t2.fdelegorgunitid is null) \n");
            checkSql.append(" \n");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)checkSql.toString());
            if (rs.next()) {
                throw new QCStandardException(QCStandardException.ITEMENTRY_INFO_NULL);
            }
            boolean isCreator = this.orgID.equals(this.info.getQualityOrgUnit().getId().toString());
            if (!isCreator) {
                int auditValue;
                checkSql = new StringBuffer();
                checkSql.append("select t1.fcheckedstatus  from t_qm_qcstandard t ");
                checkSql.append("inner join t_qm_qcstandardextendattr t1 ");
                checkSql.append("on t.fid = t1.fparentid and t.fqualityorgunitid = t1.fqualityorgunitid ");
                checkSql.append("where t.fid = '" + this.info.getId().toString() + "' ");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)checkSql.toString());
                if (rs.next() && 2 != (auditValue = rs.getInt("fcheckedstatus"))) {
                    throw new QCStandardException(QCStandardException.CREATOR_UNAUDIT);
                }
            }
            if (DBCheckedStatusEnum.AUDITED == extInfo.getCheckedStatus()) {
                throw new QMVerifyException(QMVerifyException.DBAUDIT_HASAUDIT);
            }
            if (this.info.getSampleSolution() == SampleSolutionEnum.takeOutCheck && extInfo.getQCStrategy() == QCStrategyEnum.twoStepCheck) {
                throw new QCStandardException(QCStandardException.BIZVERIFY2);
            }
            if (this.info.getBillType() == null) {
                throw new QCStandardException(QCStandardException.BIZVERIFY1);
            }
            if (this.info.getBillType().getQCBizType() == QCBizTypeEnum.otherCheck && extInfo.getQCStrategy() != QCStrategyEnum.oneStepCheck) {
                throw new QCStandardException(QCStandardException.BIZVERIFY3);
            }
            if (extInfo.getQCStrategy() == QCStrategyEnum.oneStepCheck) {
                HashSet<String> orgIDSet = new HashSet<String>();
                Iterator it = this.info.getItemEntries().iterator();
                while (it.hasNext()) {
                    QCStandardItemExtendAttrInfo innerEntryInfo;
                    QCStandardItemEntryInfo entryInfo = (QCStandardItemEntryInfo)it.next();
                    if (entryInfo == null || entryInfo.getItemExtendAttr().size() <= 0 || (innerEntryInfo = entryInfo.getItemExtendAttr().get(0)) == null || innerEntryInfo.getDelegOrgUnit() == null) continue;
                    String innerOrgID = innerEntryInfo.getDelegOrgUnit().getId().toString();
                    orgIDSet.add(innerOrgID);
                }
                QualityOrgUnitInfo qyOrg = ContextUtil.getCurrentQualityUnit((Context)this.ctx);
                if (qyOrg == null) {
                    throw new QMException(QMException.BLANK, (Object[])new String[]{"Error QualityOrgUnit!!!"});
                }
                if (orgIDSet.size() > 1 || qyOrg.isIsBizUnit() && !orgIDSet.contains(qyOrg.getId().toString())) {
                    throw new QCStandardException(QCStandardException.BIZVERIFY4);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void materialEntryVerify() throws EASBizException, BOSException {
        Iterator it = this.info.getMaterialEntries().iterator();
        while (it.hasNext()) {
            QCStandardMaterialEntryInfo entryInfo = (QCStandardMaterialEntryInfo)it.next();
            if (entryInfo.getMaterialGroup() != null || entryInfo.getMaterial() != null) continue;
            throw new QCStandardException(QCStandardException.BIZVERIFY5);
        }
    }

    protected void productLineEntriesVerify() throws EASBizException, BOSException {
        Iterator it = this.info.getProductLineEntries().iterator();
        while (it.hasNext()) {
            QCStandardProductLineEntryInfo entryInfo = (QCStandardProductLineEntryInfo)it.next();
            if (entryInfo.getMaterial() != null) continue;
            throw new QCStandardException(QCStandardException.BIZVERIFY6);
        }
    }

    protected void technicsEntriesVerify() throws EASBizException, BOSException {
        Iterator it = this.info.getTechnicsEntries().iterator();
        while (it.hasNext()) {
            QCStandardTechnicsEntryInfo qCStandardTechnicsEntryInfo = (QCStandardTechnicsEntryInfo)it.next();
        }
    }

    protected void bizObjectEntriesVerify() throws EASBizException, BOSException {
        Iterator it = this.info.getBizObjectEntries().iterator();
        while (it.hasNext()) {
            QCStandardBizObjectEntryInfo entryInfo = (QCStandardBizObjectEntryInfo)it.next();
            if (entryInfo.getQCBizObjectGroup() != null) continue;
            throw new QCStandardException(QCStandardException.BIZVERIFY8);
        }
    }
}

