/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.qm.basedata.pur.app.AbstractApprovedSupplierFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ApprovedSupplierFacadeControllerBean
extends AbstractApprovedSupplierFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.basedata.pur.app.ApprovedSupplierFacadeControllerBean");

    @Override
    protected void _batchSubmit(Context ctx, List approvedSupplierList) throws BOSException, EASBizException {
        if (approvedSupplierList == null) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        int size = approvedSupplierList.size();
        try {
            if (size > 0) {
                con = this.getConnection(ctx);
                String strSql = new String("update T_SM_ApprovedSupplier set FIsCheck=?, FCheckStandard=? where FId= ? ");
                ps = con.prepareStatement(strSql);
                for (int i = 0; i < size; ++i) {
                    ApprovedSupplierInfo appSupplierInfo = (ApprovedSupplierInfo)approvedSupplierList.get(i);
                    int index = 1;
                    ps.setBoolean(index++, appSupplierInfo.isIsCheck());
                    String strStdId = null;
                    if (appSupplierInfo.getCheckStandard() != null) {
                        strStdId = appSupplierInfo.getCheckStandard().getId().toString();
                    }
                    ps.setString(index++, strStdId);
                    ps.setString(index++, appSupplierInfo.getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        finally {
            SQLUtils.cleanup(ps, con);
        }
    }

    @Override
    protected List _getApprovedSuppColl(Context ctx, String strIDS) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        ArrayList<ApprovedSupplierInfo> list = new ArrayList<ApprovedSupplierInfo>();
        if (strIDS != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIDS, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(this.getSelectors());
            IApprovedSupplier iappSupplier = ApprovedSupplierFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection approvedSupColl = iappSupplier.getCollection(viewInfo);
            Iterator it = approvedSupColl.iterator();
            IMaterialPurchasing imPurchasing = MaterialPurchasingFactory.getLocalInstance((Context)ctx);
            OrgUnitInfo purOrgInfo = (OrgUnitInfo)ctx.get((Object)OrgType.Purchase);
            if (purOrgInfo != null) {
                String strPurOrg = purOrgInfo.getId().toString();
                while (it.hasNext()) {
                    ApprovedSupplierInfo appInfo = (ApprovedSupplierInfo)it.next();
                    String strMatId = appInfo.getMaterialItem().getId().toString();
                    String strSql = " where material='" + strMatId + "' and orgUnit='" + strPurOrg + "'";
                    MaterialPurchasingInfo matPurInfo = (MaterialPurchasingInfo)imPurchasing.getValue(strSql);
                    if (matPurInfo == null || matPurInfo.getQualityOrg() == null) continue;
                    appInfo.put(strMatId, (Object)matPurInfo);
                    list.add(appInfo);
                }
            }
        }
        return list;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("materialItem.name"));
        sic.add(new SelectorItemInfo("materialItem.model"));
        sic.add(new SelectorItemInfo("materialItem.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("purchaseOrg.number"));
        sic.add(new SelectorItemInfo("purchaseOrg.name"));
        sic.add(new SelectorItemInfo("isCheck"));
        sic.add(new SelectorItemInfo("checkStandard.id"));
        sic.add(new SelectorItemInfo("checkStandard.name"));
        sic.add(new SelectorItemInfo("checkStandard.name"));
        return sic;
    }
}

