/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.qm.common.QMCoreDataBaseInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.AbstractQMCoreDataBaseControllerBean;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.app.action.IServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ServerActionManager;
import com.kingdee.eas.qm.common.app.action.ServerBatchAuditAction;
import com.kingdee.eas.qm.common.app.action.ServerBatchDeleteAction;
import com.kingdee.eas.qm.common.app.action.ServerBatchUnAuditAction;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.util.QMServerUtils;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseAddnewCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseAuditCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseBlockedCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseCancelCancelCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseCancelCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseDeleteCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseUnAuditCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseUnBlockedCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseUpdateCommonVerifyItem;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class QMCoreDataBaseControllerBean
extends AbstractQMCoreDataBaseControllerBean
implements ISuportCodingRule,
ISuportServerBatchAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.common.app.QMCoreDataBaseControllerBean");

    protected void regesterServerAction(Context ctx, QMCoreDataBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)model;
        String tableName = this.getTableName(ctx);
        QMServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)model;
        String tableName = this.getTableName(ctx);
        QMServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        return super._submit(ctx, model);
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseUpdateCommonVerifyItem verifyItem = new QMDataBaseUpdateCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseAddnewCommonVerifyItem verifyItem = new QMDataBaseAddnewCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)model;
        this.getCodingRuleStrategy().initEditNumber(this, ctx, info);
        this._checkNumberBlank(ctx, info);
        this._checkNameBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        IVerifyManager verifymanager = this.getUpdateVerifyManager(ctx, info);
        verifymanager.verify();
        super._update(ctx, pk, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._cancelCancel(ctx, pk, model);
    }

    public ServerCodingRuleStrategy getCodingRuleStrategy() {
        return new ServerCodingRuleStrategy();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getDeleteVerifyManager(ctx, info);
        verifymanager.verify();
        super._delete(ctx, pk);
        String orgID = "";
        orgID = info.getMainOrgUnit() != null ? info.getMainOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        this.getCodingRuleStrategy().recycleNumber(ctx, (CoreBaseInfo)info, orgID);
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseDeleteCommonVerifyItem verifyItem = new QMDataBaseDeleteCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public IServerBatchAction getBatchDeleteAction() {
        DataBatchDeleteAction action = new DataBatchDeleteAction(this);
        return action;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)model;
        this.getCodingRuleStrategy().initNumber(this, ctx, info);
        LogControllManager.getInstance().enableLog();
        this._checkNumberBlank(ctx, info);
        this._checkNameBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        IVerifyManager verifymanager = this.getAddnewVerifyManager(ctx, info);
        verifymanager.verify();
        IObjectPK pk = super._addnew(ctx, model);
        this.logAddnew(ctx, info);
        return pk;
    }

    @Override
    public boolean isNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        QMCoreDataBaseInfo coreBillBaseInfo = (QMCoreDataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterForDefaultCU(ctx, coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForDefaultCU(ctx, coreBillBaseInfo), "AND");
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Class[] parameTypes = new Class[]{IObjectPK.class};
        BatchExecuteParamsEntry p = new BatchExecuteParamsEntry(parameTypes);
        p.add((Object)pk);
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[]{p};
        BatchExecuteResult result = this.batchAudit(ctx, paramEntries);
        this.throwException(result);
    }

    public BatchExecuteResult batchAudit(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        IServerBatchAction action = this.getBatchAuditAction(ctx);
        return this.doBatchExcuter(ctx, action, "batchAudit", paramEntries);
    }

    public IServerBatchAction getBatchAuditAction(Context ctx) {
        DataBatchAuditAction action = new DataBatchAuditAction(this, this.getTableName(ctx));
        return action;
    }

    @Override
    public void mutexRequest(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean b = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(pk.toString());
        if (!b) {
            throw new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
        }
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseAuditCommonVerifyItem verifyItem = new QMDataBaseAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected void lockData(Context ctx, String pk) throws BOSException, EASBizException {
        String tbl = this.getTableName(ctx);
        String dateStr = DateTimeUtils.format((Date)new Date());
        String sql = "update " + tbl + " set FLastUpdateTime= to_date('" + dateStr + "') where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
    }

    @Override
    public void lockData(Context ctx, Set ids) throws BOSException {
        String tbl = this.getTableName(ctx);
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        String dateStr = DateTimeUtils.format((Date)new Date());
        sql.appendSql("update " + tbl + " set FLastUpdateTime= to_date('" + dateStr + "') ");
        sql.appendSql("where fid in (");
        sql.appendParam(ids.toArray());
        sql.appendSql(")");
        sql.execute(ctx);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Class[] parameTypes = new Class[]{IObjectPK.class};
        BatchExecuteParamsEntry p = new BatchExecuteParamsEntry(parameTypes);
        p.add((Object)pk);
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[]{p};
        BatchExecuteResult result = this.batchUnAudit(ctx, paramEntries);
        this.throwException(result);
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseUnAuditCommonVerifyItem verifyItem = new QMDataBaseUnAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public BatchExecuteResult batchUnAudit(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        IServerBatchAction action = this.getBatchUnAuditAction(ctx);
        return this.doBatchExcuter(ctx, action, "batchUnAudit", paramEntries);
    }

    public IServerBatchAction getBatchUnAuditAction(Context ctx) {
        DataBatchUnAuditAction action = new DataBatchUnAuditAction(this, this.getTableName(ctx));
        return action;
    }

    protected IVerifyManager getUnBlockedVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseUnBlockedCommonVerifyItem verifyItem = new QMDataBaseUnBlockedCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getBlockedVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseBlockedCommonVerifyItem verifyItem = new QMDataBaseBlockedCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public String getTableName(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        return entity.getTable().getName();
    }

    @Override
    protected void _blocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMCoreDataBaseInfo info = null;
        try {
            info = (QMCoreDataBaseInfo)this.getValue(ctx, pk);
        }
        catch (Exception e) {
            throw new QMException(QMException.RECORDNOTEXIST);
        }
        IVerifyManager verifymanager = this.getBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    @Override
    protected void _unBlocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMCoreDataBaseInfo info = null;
        try {
            info = (QMCoreDataBaseInfo)this.getValue(ctx, pk);
        }
        catch (Exception e) {
            throw new QMException(QMException.RECORDNOTEXIST);
        }
        IVerifyManager verifymanager = this.getUnBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMCoreDataBaseInfo info = null;
        try {
            info = (QMCoreDataBaseInfo)this.getValue(ctx, pk);
        }
        catch (Exception e) {
            throw new QMException(QMException.RECORDNOTEXIST);
        }
        IVerifyManager verifymanager = this.getCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMCoreDataBaseInfo info = null;
        try {
            info = (QMCoreDataBaseInfo)this.getValue(ctx, pk);
        }
        catch (Exception e) {
            throw new QMException(QMException.RECORDNOTEXIST);
        }
        IVerifyManager verifymanager = this.getCancelCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    protected IVerifyManager getCancelCancelVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseCancelCancelCommonVerifyItem verifyItem = new QMDataBaseCancelCancelCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getCancelVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseCancelCommonVerifyItem verifyItem = new QMDataBaseCancelCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    @Override
    public FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return super.getFilterForDefaultCU(ctx, model);
    }

    @Override
    public void audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.audit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    public void unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.unAudit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    public void cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.cancel(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    public void cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.cancelCancel(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    public void blocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.blocked(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    public void unBlocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.unBlocked(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.delete(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    protected void _logAddnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public void fireServerAction(Context ctx, IObjectValue model, String eventName) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        this.getServerActionManager(ctx, (QMCoreDataBaseInfo)model, eventName).fireServerAction(ctx, event);
    }

    protected void fireServerAction(Context ctx, IObjectValue model, String eventName, Object[] args) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        event.setParams(args);
        this.getServerActionManager(ctx, (QMCoreDataBaseInfo)model, eventName).fireServerAction(ctx, event);
    }

    public IServerActionManager getServerActionManager(Context ctx, QMCoreDataBaseInfo model, String name) throws BOSException {
        ServerActionManager serverActionManager = new ServerActionManager(name);
        this.regesterServerAction(ctx, model, serverActionManager);
        return serverActionManager;
    }

    public BatchExecuteResult doBatchExcuter(Context ctx, IServerBatchAction action, String name, BatchExecuteParamsEntry[] paramEntries) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(name);
        event.setSrcObject(null);
        event.setParams(paramEntries);
        ServerActionManager serverActionManager = new ServerActionManager(name);
        serverActionManager.addServerAction(action);
        serverActionManager.fireServerAction(ctx, event);
        return (BatchExecuteResult)event.getResult();
    }

    public BatchExecuteResult batchingExecute(Context ctx, MetaDataPK methodPK, Method batchMethod, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        ServiceStateManager.getInstance().setServiceState(this.getServiceState());
        try {
            int i;
            BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
            ServiceContext[] arrSvcCtx = new ServiceContext[result.size()];
            for (int i2 = 0; i2 < arrSvcCtx.length; ++i2) {
                ServiceContext svcCtx = this.createServiceContext(methodPK, this.getParamValueArray(ctx, paramEntries[i2]));
                svcCtx.setExecutionMode(0);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i2] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            ArrayList<BatchExecuteParamsEntry> successedEntries = new ArrayList<BatchExecuteParamsEntry>();
            ArrayList<Integer> successedEntryIndex = new ArrayList<Integer>();
            for (int i3 = 0; i3 < arrSvcCtx.length; ++i3) {
                Throwable th = arrSvcCtx[i3].getServiceException();
                if (th == null) {
                    successedEntries.add(paramEntries[i3]);
                    successedEntryIndex.add(new Integer(i3));
                    continue;
                }
                result.setException(i3, th);
            }
            Object batchRtv = this.invoke(this, batchMethod, new Object[]{ctx, successedEntries.toArray(new BatchExecuteParamsEntry[0])});
            result.setBatchResult(batchRtv);
            if (batchRtv instanceof BatchExecuteResult) {
                for (int i4 = 0; i4 < successedEntryIndex.size(); ++i4) {
                    BatchExecuteResult batchRtv2 = (BatchExecuteResult)batchRtv;
                    int entryIndex = (Integer)successedEntryIndex.get(i4);
                    if (batchRtv2.exceptionOccured(i4)) {
                        arrSvcCtx[entryIndex] = null;
                    }
                    result.setException(entryIndex, batchRtv2.getException(i4));
                    result.setReturnValue(entryIndex, batchRtv2.getReturnValue(i4));
                }
            }
            for (i = 0; i < arrSvcCtx.length; ++i) {
                if (arrSvcCtx[i] == null) continue;
                if (arrSvcCtx[i].getServiceException() != null) {
                    arrSvcCtx[i] = null;
                    continue;
                }
                ServiceContext svcCtx = this.createServiceContext(methodPK, this.getParamValueArray(ctx, paramEntries[i]));
                svcCtx.setExecutionMode(1);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            for (i = 0; i < arrSvcCtx.length; ++i) {
                Throwable th;
                if (arrSvcCtx[i] == null || (th = arrSvcCtx[i].getServiceException()) == null) continue;
                result.setException(i, th);
            }
            BatchExecuteResult batchExecuteResult = result;
            return batchExecuteResult;
        }
        catch (Throwable th) {
            this.setRollbackOnly();
            if (th instanceof BaseException) {
                throw (BaseException)th;
            }
            throw new BOSException(th);
        }
        finally {
            this.cleanUpServiceState();
        }
    }

    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public Object[] getParamValueArray(Context ctx, BatchExecuteParamsEntry entry) {
        Object[] params = new Object[entry.getParamTypes().length + 1];
        params[0] = ctx;
        Object[] entryItems = entry.toArray();
        System.arraycopy(entryItems, 0, params, 1, entryItems.length);
        return params;
    }

    protected void throwException(BatchExecuteResult result) throws BOSException, EASBizException {
        Throwable[] exceptions = result.getExceptions();
        if (null != exceptions && exceptions.length > 0) {
            Throwable th = exceptions[0];
            try {
                throw th;
            }
            catch (BOSException bosExp) {
                throw bosExp;
            }
            catch (EASBizException bizExp) {
                throw bizExp;
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    public class DataBatchAuditAction
    extends ServerBatchAuditAction {
        public DataBatchAuditAction(ISuportServerBatchAction bean, String tableName) {
            super(bean, tableName);
        }

        @Override
        protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
            QMCoreDataBaseInfo dbInfo = (QMCoreDataBaseInfo)info;
            IVerifyManager verifymanager = super.getVerifyManager(ctx, info);
            IVerifyManager manager = QMCoreDataBaseControllerBean.this.getAuditVerifyManager(ctx, dbInfo);
            verifymanager.addChildrenManager(manager);
            return verifymanager;
        }
    }

    public class DataBatchUnAuditAction
    extends ServerBatchUnAuditAction {
        public DataBatchUnAuditAction(ISuportServerBatchAction bean, String tableName) {
            super(bean, tableName);
        }

        @Override
        protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
            IVerifyManager verifymanager = super.getVerifyManager(ctx, info);
            QMCoreDataBaseInfo dbInfo = (QMCoreDataBaseInfo)info;
            IVerifyManager manager = QMCoreDataBaseControllerBean.this.getUnAuditVerifyManager(ctx, dbInfo);
            verifymanager.addChildrenManager(manager);
            return verifymanager;
        }
    }

    public class DataBatchDeleteAction
    extends ServerBatchDeleteAction {
        public DataBatchDeleteAction(ISuportServerBatchAction bean) {
            super(bean);
        }

        @Override
        protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
            IVerifyManager verifymanager = super.getVerifyManager(ctx, info);
            QMCoreDataBaseInfo dbInfo = (QMCoreDataBaseInfo)info;
            IVerifyManager manager = QMCoreDataBaseControllerBean.this.getDeleteVerifyManager(ctx, dbInfo);
            verifymanager.addChildrenManager(manager);
            return verifymanager;
        }
    }
}

