/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.DataBaseDAssignInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.IDataBaseDAssign;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CUBDDispatchPattern;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.qm.common.QMCoreDataBaseInfo;
import com.kingdee.eas.qm.common.QMDataBaseDInfo;
import com.kingdee.eas.qm.common.QMDatabaseCanInfo;
import com.kingdee.eas.qm.common.QMDatabaseDException;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.AbstractQMDataBaseDControllerBean;
import com.kingdee.eas.qm.common.app.QMDataBaseDNewImpl;
import com.kingdee.eas.qm.common.app.verify.QMAssignDeleteVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseAuditCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseBlockedCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseDeleteCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseUnAuditCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMDataBaseUnBlockedCommonVerifyItem;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class QMDataBaseDControllerBean
extends AbstractQMDataBaseDControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.common.app.QMDataBaseDControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getDeleteVerifyManager(ctx, info);
        verifymanager.verify();
        this._unBatchAssign(ctx, null, true, null, new String[]{pk.toString()}, new String[]{info.getMainOrgUnit().getId().toString()});
        super._delete(ctx, pk);
    }

    @Override
    protected IVerifyManager getDeleteVerifyManager(Context ctx, QMCoreDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        AbstractVerifyItem verifyItem = new QMDataBaseDeleteCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        verifyItem = new QMAssignDeleteVerifyItem(ctx, info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)model;
        IObjectPK pk = super._addnew(ctx, model);
        this._batchAssign(ctx, null, false, null, new String[]{pk.toString()}, new String[]{info.getMainOrgUnit().getId().toString()});
        return pk;
    }

    @Override
    public boolean isNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return super.isNumberDup(ctx, pk, model);
    }

    @Override
    public FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMDataBaseDInfo info = (QMDataBaseDInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getAuditVerifyManager(ctx, info);
        verifymanager.verify();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        String sql = "update " + this.getTableName(ctx) + " set FCheckedStatus=" + 2 + " ,FAuditorId=? , fauditTime=getDate() where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{userId, pk.toString()});
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, QMDataBaseDInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem(new QMDataBaseAuditCommonVerifyItem(info));
        return verifymanager;
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMDataBaseDInfo info = (QMDataBaseDInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getUnAuditVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FCheckedStatus=" + 1 + " ,FAuditorId=null , fauditTime=null where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMDataBaseDInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem(new QMDataBaseUnAuditCommonVerifyItem(info));
        return verifymanager;
    }

    @Override
    protected void _block(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMDataBaseDInfo info = (QMDataBaseDInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    protected IVerifyManager getBlockedVerifyManager(Context ctx, QMDataBaseDInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem(new QMDataBaseBlockedCommonVerifyItem(info));
        return verifymanager;
    }

    @Override
    protected void _unBlock(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMDataBaseDInfo info = (QMDataBaseDInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getUnBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    protected IVerifyManager getUnBlockedVerifyManager(Context ctx, QMDataBaseDInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMDataBaseUnBlockedCommonVerifyItem verifyItem = new QMDataBaseUnBlockedCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    @Override
    protected void lockData(Context ctx, String pk) throws BOSException {
        String tbl = this.getTableName(ctx);
        String dateStr = DateTimeUtils.format((Date)new Date());
        String sql = "update " + tbl + " set FLastUpdateTime= to_date('" + dateStr + "') where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
    }

    @Override
    protected void _batchAssign(Context ctx, String srcOrgUnit, boolean all, String sql, String[] dataMap, String[] assignedOrgUnits) throws BOSException, EASBizException {
        this.getQMDataBaseDNewImpl().batchAssign(ctx, srcOrgUnit, all, sql, dataMap, assignedOrgUnits, this.getBOSType(), true);
    }

    protected QMDataBaseDNewImpl getQMDataBaseDNewImpl() {
        QMDataBaseDNewImpl dbImpl = new QMDataBaseDNewImpl();
        return dbImpl;
    }

    @Override
    protected void _unBatchAssign(Context ctx, String srcOrgUnit, boolean all, String sql, String[] dataMap, String[] assignedOrgUnits) throws BOSException, EASBizException {
        this.getQMDataBaseDNewImpl().unBatchAssign(ctx, srcOrgUnit, all, sql, dataMap, assignedOrgUnits, this.getBOSType(), true);
    }

    @Override
    protected void _batchRefer(Context ctx, String srcOrgUnit, String referOrgUnit, boolean all, String sql, String[] selDbids) throws BOSException, EASBizException {
        this.getQMDataBaseDNewImpl().batchAssign(ctx, srcOrgUnit, all, sql, selDbids, new String[]{referOrgUnit}, this.getBOSType(), false);
    }

    @Override
    protected void _unBatchRefer(Context ctx, String srcOrgUnit, String referOrgUnit, boolean all, String sql, String[] selDbids) throws BOSException, EASBizException {
        this.getQMDataBaseDNewImpl().unBatchAssign(ctx, srcOrgUnit, all, sql, selDbids, new String[]{referOrgUnit}, this.getBOSType(), false);
    }

    @Override
    protected void _upgrade(Context ctx, IObjectPK dataPK, IObjectPK subordinateCUPK, IObjectPK superiorCUPK) throws BOSException, EASBizException {
        BOSUuid dataID = BOSUuid.read((String)dataPK.toString());
        CtrlUnitInfo assignCU = new CtrlUnitInfo();
        assignCU.setId(BOSUuid.read((String)subordinateCUPK.toString()));
        String bosType = dataID.getType().toString();
        IDataBaseDAssign idbda = DataBaseDAssignFactory.getLocalInstance((Context)ctx);
        DataBaseDAssignInfo dbdai = new DataBaseDAssignInfo();
        dbdai.setDataBaseDID(dataID);
        dbdai.setAssignCU(assignCU);
        dbdai.setBosObjectType(bosType);
        idbda.addnew((CoreBaseInfo)dbdai);
        DataBaseDInfo dataInfo = (DataBaseDInfo)this._getValue(ctx, dataPK);
        CtrlUnitInfo CU = dataInfo.getCU();
        CtrlUnitInfo CUCopy = (CtrlUnitInfo)CU.clone();
        CUCopy.setId(BOSUuid.read((String)superiorCUPK.toString()));
        dataInfo.setAdminCU(CUCopy);
        dataInfo.setCU(CUCopy);
        super._update(ctx, dataPK, (IObjectValue)dataInfo);
    }

    @Override
    protected boolean _canBeAssigned(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        try {
            String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
            String longNumber = this.getCULongNumber(ctx, ctrlUnitPK);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            String ctrlUnitID = iFullOrgUnit.getFullOrgUnitInfo(ctrlUnitPK).getCU().getId().toString();
            StringBuffer sql = new StringBuffer(500);
            sql.append(" SELECT Structure.FUnitId FROM T_ORG_Structure Structure ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = Structure.FUnitId ").append(" WHERE Structure.FTreeId = ? ").append(" AND CHARINDEX( N'").append(longNumber).append("!' , Structure.FLongNumber || N'!' ) > 0 ").append(" AND BaseUnit.FControlUnitID = ? ").append(" ORDER BY Structure.FLongNumber ASC ");
            Object[] params = new Object[]{treeID, ctrlUnitID};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                if (!this.canBeAssigned(ctx, bosObjectType, ctrlUnitID)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_INFO_FAIL, (Throwable)e);
        }
        return false;
    }

    private String getCULongNumber(Context ctx, IObjectPK orgPK) throws BOSException, SQLException {
        String longNumber = null;
        String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
        String orgID = orgPK.toString();
        Object[] params = new Object[]{treeID, orgID};
        StringBuffer sql = new StringBuffer(500);
        sql.append(" SELECT FLongNumber FROM T_ORG_Structure ").append(" WHERE\tFTreeId = ? ").append(" AND FUnitId = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        if (rowSet.next()) {
            longNumber = rowSet.getString("FLongNumber");
        }
        return longNumber;
    }

    private boolean canBeAssigned(Context ctx, BOSObjectType objectType, String ctrlUnitID) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitID);
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH);
    }

    @Override
    protected boolean _canBeUpgraded(Context ctx, BOSObjectType bosType, IObjectPK ctrUnitPK) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosType.toString(), ctrUnitPK.toString());
        return controlInfo == null ? false : controlInfo.isIsSubordinateUpgradable();
    }

    @Override
    protected boolean _canRefer(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosObjectType.toString(), ctrlUnitPK.toString());
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.REFERENCE);
    }

    @Override
    protected QMDatabaseCanInfo _allCan(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        QMDatabaseCanInfo info = new QMDatabaseCanInfo();
        CtrlUnitInfo curCtrl = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK);
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosObjectType.toString(), ctrlUnitPK.toString());
        info.setCanAssign(this._canBeAssigned(ctx, bosObjectType, ctrlUnitPK));
        info.setCanRefer(controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.REFERENCE));
        info.setCanUpgrade(controlInfo == null ? false : controlInfo.isIsSubordinateUpgradable());
        info.setCurCtrlUnit((OrgUnitInfo)curCtrl);
        return info;
    }

    @Override
    public FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    protected boolean isCreateQualityOrg(Context ctx, QMDataBaseDInfo info) throws BOSException, EASBizException {
        if (info.getQualityOrgUnit() == null) {
            throw new QMException(QMException.BLANK, new String[]{"error info object!"});
        }
        return this.getCurrentQualityOrgUnit(ctx).getId().toString().equals(info.getQualityOrgUnit().getId().toString());
    }

    protected QualityOrgUnitInfo getCurrentQualityOrgUnit(Context ctx) throws BOSException, EASBizException {
        QualityOrgUnitInfo qyOrg = ContextUtil.getCurrentQualityUnit((Context)ctx);
        if (qyOrg == null) {
            throw new QMException(QMException.BLANK, new String[]{"Error QualityOrgUnit!!!"});
        }
        return qyOrg;
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.id"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.name"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.number"));
        QMDataBaseDInfo info = null;
        try {
            info = (QMDataBaseDInfo)this.getValue(ctx, pk, sic);
        }
        catch (Exception e) {
            throw new QMException(QMException.RECORDNOTEXIST);
        }
        if (!this.isCreateQualityOrg(ctx, info)) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_CANCEL);
        }
        IVerifyManager verifymanager = this.getCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.id"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.name"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.number"));
        QMDataBaseDInfo info = null;
        try {
            info = (QMDataBaseDInfo)this.getValue(ctx, pk, sic);
        }
        catch (Exception e) {
            throw new QMException(QMException.RECORDNOTEXIST);
        }
        if (!this.isCreateQualityOrg(ctx, info)) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_CANCLECANCLE);
        }
        IVerifyManager verifymanager = this.getCancelCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }
}

