/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ServerActionManager
implements IServerActionManager {
    public List serverActions = new ArrayList();
    private String name;
    private static final Logger logger = Logger.getLogger(ServerActionManager.class);

    public ServerActionManager(String name) {
        this.name = name;
    }

    @Override
    public void fireServerAction(Context ctx, ServerEvent event) throws EASBizException, BOSException {
        for (IServerAction serverAction : this.serverActions) {
            serverAction.handler(ctx, event);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void addServerAction(IServerAction serverAction) {
        this.serverActions.add(serverAction);
    }

    @Override
    public void addServerAction(String serverAction) {
        IServerAction c = null;
        try {
            c = (IServerAction)Class.forName(serverAction).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.serverActions.add(c);
    }

    @Override
    public List getServerActions() {
        return this.serverActions;
    }

    @Override
    public void removeServerAction(IServerAction serverAction) {
        this.serverActions.remove(serverAction);
    }
}

