/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.QMCoreDataBaseInfo;
import com.kingdee.eas.qm.common.QMTreeBaseInfo;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ServerBatchAction;
import com.kingdee.eas.qm.common.util.backup.QMCommonUtils;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ServerBatchDeleteAction
extends ServerBatchAction {
    private static final String BOTP_BIZ_REFERENCE = "com.kingdee.bos.metadata.bot.BOTPReference";

    public ServerBatchDeleteAction(ISuportServerBatchAction bean) {
        super(bean, "BEFORE_DELETE", "AFTER_DELETE");
    }

    @Override
    public CoreBaseCollection doIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException, EASBizException {
        CoreBaseCollection tempCol = new CoreBaseCollection();
        for (int i = 0; i < successedColl.size(); ++i) {
            CoreBaseInfo info;
            block3: {
                info = successedColl.get(i);
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                try {
                    this.isReferenced(ctx, (IObjectPK)pk);
                    if (!(info instanceof QMCoreDataBaseInfo)) break block3;
                    this.isDataReferenced(ctx, (IObjectPK)pk);
                }
                catch (ObjectReferedException e) {
                    this.putException(result, info, (Exception)((Object)e));
                    continue;
                }
            }
            tempCol.add(info);
        }
        ArrayList sucIds = ServerBatchDeleteAction.getIds(tempCol);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(sucIds), CompareType.INCLUDE));
        this.getBiz().delete(ctx, filter);
        return tempCol;
    }

    @Override
    protected CoreBaseCollection batchVerify(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        return super.batchVerify(ctx, result, successedColl);
    }

    @Override
    protected CoreBaseCollection afterDoIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        CoreBaseCollection tmpCol = new CoreBaseCollection();
        for (int i = 0; i < successedColl.size(); ++i) {
            IBTPManager iBTPManager;
            CoreBaseInfo info = successedColl.get(i);
            String orgID = this.getMainOrgID(ctx, info);
            QMCommonUtils.recycleNumber(ctx, info, orgID);
            if (info instanceof CoreBillBaseInfo && !(iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx)).ifHaveDestBills(info.getId().toString())) {
                try {
                    iBTPManager.removeAllSRCRelation((CoreBillBaseInfo)info);
                }
                catch (BTPException e) {
                    throw new BOSException(e.getCause());
                }
            }
            try {
                this.getBiz().fireServerAction(ctx, (IObjectValue)info, this.afterEventName);
            }
            catch (Exception ex) {
                this.putException(result, info, ex);
                continue;
            }
            tmpCol.add(info);
        }
        return tmpCol;
    }

    protected void afterDoIt(Context ctx, BatchExecuteResult result, List successedIndex, CoreBaseCollection successedColl, BatchExecuteResult successedresult) throws EASBizException, BOSException {
        for (int i = 0; i < successedColl.size(); ++i) {
            IBTPManager iBTPManager;
            CoreBaseInfo info = successedColl.get(i);
            this.getBiz().fireServerAction(ctx, (IObjectValue)info, this.afterEventName);
            int index = (Integer)successedIndex.get(i);
            result.setException(index, successedresult.getException(i));
            result.setReturnValue(index, successedresult.getReturnValue(i));
            String orgID = this.getMainOrgID(ctx, info);
            QMCommonUtils.recycleNumber(ctx, info, orgID);
            if (!(info instanceof CoreBillBaseInfo) || (iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx)).ifHaveDestBills(info.getId().toString())) continue;
            iBTPManager.removeAllSRCRelation((CoreBillBaseInfo)info);
        }
    }

    public String getMainOrgID(Context ctx, CoreBaseInfo info) {
        String orgID = "";
        if (info instanceof QMCoreDataBaseInfo) {
            QMCoreDataBaseInfo dbInfo = (QMCoreDataBaseInfo)info;
            orgID = null != dbInfo.getMainOrgUnit() ? dbInfo.getMainOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        } else if (info instanceof QMTreeBaseInfo) {
            QMTreeBaseInfo treeInfo = (QMTreeBaseInfo)info;
            orgID = null != treeInfo.getMainOrgUnit() ? treeInfo.getMainOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        } else if (info instanceof QMCoreBillBaseInfo) {
            QMCoreBillBaseInfo billInfo = (QMCoreBillBaseInfo)info;
            orgID = billInfo.getMainOrgUnit().getId().toString();
        }
        return orgID;
    }

    public void isReferenced(Context ctx, IObjectPK pk) throws ObjectReferedException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        if (ref != null) {
            throw new ObjectReferedException((Object)ref);
        }
    }

    public void isDataReferenced(Context ctx, IObjectPK pk) throws ObjectReferedException {
        if (pk instanceof ObjectUuidPK) {
            try {
                IBizReference botpReference = this.getBOTPBizReference();
                if (botpReference != null && botpReference.checkReferenced(ctx, ((ObjectUuidPK)pk).getKeyValue()).isFound()) {
                    BizReference bizReference = new BizReference();
                    bizReference.setRefEntityAlias_L1("BOTP Rule");
                    bizReference.setRefEntityAlias_L2("BOTP Rule");
                    bizReference.setRefEntityAlias_L3("BOTP Rule");
                    throw new ObjectReferedException((Object)bizReference);
                }
            }
            catch (BizReferenceException bizReferenceException) {
                // empty catch block
            }
        }
    }

    protected IBizReference getBOTPBizReference() {
        IBizReference result = null;
        try {
            result = (IBizReference)Class.forName(BOTP_BIZ_REFERENCE).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

