/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.IQualityOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitCollection;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.service.IPermissionService;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public final class QMServerUtils {
    private static Logger logger = Logger.getLogger(QMServerUtils.class);

    public static void createBotpRelation(Context ctx, String srcObjectId, String destObjectId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)srcObjectId) || StringUtils.isEmpty((String)destObjectId)) {
            return;
        }
        StringBuffer sqlString = new StringBuffer();
        sqlString = sqlString.append("SELECT COUNT(1) FROM T_BOT_Relation ").append("WHERE FSRCOBJECTID ='").append(srcObjectId).append("' ").append("AND FDESTOBJECTID ='").append(destObjectId).append("' ");
        IRowSet relationCount = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString());
        try {
            if (relationCount.next() && relationCount.getInt(1) == 0) {
                IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                BOTRelationInfo info = new BOTRelationInfo();
                String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
                String destBosType = BOSUuid.read((String)destObjectId).getType().toString();
                info.setSrcEntityID(srcBosType);
                info.setDestEntityID(destBosType);
                info.setSrcObjectID(srcObjectId);
                info.setDestObjectID(destObjectId);
                info.setDate(new Date());
                info.setOperatorID("system");
                info.setIsEffected(true);
                info.setType(0);
                iBOTRelation.addnew(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static OrgUnitCollection getOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: {
                return iDestOrg == 1 ? iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg) : iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 3) {
                    return QMServerUtils.getSalePurchaseRelation(ctx, srcOrgType, destOrgType, orgPK);
                }
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 2) {
                    return QMServerUtils.getSalePurchaseRelation(ctx, srcOrgType, destOrgType, orgPK);
                }
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 4: {
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 24: {
                if (iDestOrg != 4) break;
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static OrgUnitInfo getDefaultOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        OrgUnitInfo defaultOrg = null;
        if (srcOrgType.equals((Object)OrgType.Storage) && (destOrgType.equals((Object)OrgType.Purchase) || destOrgType.equals((Object)OrgType.Sale)) || srcOrgType.equals((Object)OrgType.Admin) && destOrgType.equals((Object)OrgType.Storage)) {
            IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            defaultOrg = iOrgRelation.getDefaultToUnit(orgPK, srcOrgType.getValue(), destOrgType.getValue());
        }
        return defaultOrg;
    }

    private static OrgUnitCollection getSalePurchaseRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        OrgUnitCollection resultOrgs = new OrgUnitCollection();
        OrgUnitCollection companyOrgs = QMServerUtils.getOrgsByRelation(ctx, srcOrgType, OrgType.Company, orgPK);
        if (companyOrgs != null && companyOrgs.size() > 0) {
            return QMServerUtils.getOrgsByRelation(ctx, OrgType.Company, destOrgType, companyOrgs.get(0).getId().toString());
        }
        return resultOrgs;
    }

    public static String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static void validateMaterialInfo(Context ctx, OrgType orgType, String orgId, String[] materialIds) throws Exception {
        IRowSet resultSet;
        block25: {
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            resultSet = null;
            StringBuffer sqlParams = new StringBuffer();
            int c = materialIds.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(materialIds[i]);
                sqlParams.append("'");
            }
            try {
                String materialName;
                IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK pk = new ObjectUuidPK(fullOrgUnitInfo.getCU().getId().toString());
                FilterInfo filterInfo = iMaterial.getDatabaseDFilter((IObjectPK)pk, "FID", "FAdminCUID");
                StringBuffer materialBuffer = new StringBuffer();
                materialBuffer.append(" select fid,fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material ").append(" where fid in(").append(sqlParams.toString()).append(")").append(" and ").append(filterInfo.toString());
                resultSet = DbUtil.executeQuery((Context)ctx, (String)materialBuffer.toString());
                StringBuffer noFitMaterialNameBuffer = new StringBuffer();
                while (resultSet.next()) {
                    String materialName2 = resultSet.getString(2);
                    String id = resultSet.getString(1);
                    if (sqlParams.indexOf(id) >= 0) continue;
                    if (noFitMaterialNameBuffer.length() > 0) {
                        noFitMaterialNameBuffer.append(",");
                    }
                    noFitMaterialNameBuffer.append(materialName2);
                }
                if (noFitMaterialNameBuffer.length() > 0) {
                    throw new MaterialBaseException(MaterialBaseException.ORGVIEWMATERIALFORBIDEN, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                }
                if (orgType.equals((Object)OrgType.Company)) {
                    StringBuffer companyBuffer = new StringBuffer();
                    companyBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialCompanyInfo companyInfo on material.FID = companyInfo.FMaterial").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and companyInfo.FCompanyID in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)companyBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALCOMPANY, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Purchase)) {
                    StringBuffer purchaseBuffer = new StringBuffer();
                    purchaseBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialPurchasing purchaseInfo on material.FID = purchaseInfo.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and purchaseInfo.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)purchaseBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALPURCHASE, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Sale)) {
                    StringBuffer saleBuffer = new StringBuffer();
                    saleBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialSales saleInfo on material.FID = saleInfo.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and saleInfo.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)saleBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALSALE, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Storage)) {
                    StringBuffer inventoryBuffer = new StringBuffer();
                    inventoryBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialInventory inventory on material.FID = inventory.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and inventory.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)inventoryBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALINVENTARY, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                throw new SCMBillException(SCMBillException.ORGTYPEERROE);
            }
            catch (SQLException e) {
                try {
                    throw new Exception(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet);
    }

    public static void validateSupplierInfo(Context ctx, OrgType orgType, String orgId, String supplierId) throws Exception {
        SupplierCollection supplierCollection;
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        EntityViewInfo view = new EntityViewInfo();
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(fullOrgUnitInfo.getCU().getId().toString());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)supplierId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("adminCU", (Object)pk.toString(), CompareType.EQUALS));
        FilterInfo filterInfo = iSupplier.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            view.getFilter().mergeFilter(filterInfo, "and");
        }
        if ((supplierCollection = iSupplier.getSupplierCollection(view)) == null || supplierCollection.size() <= 0) {
            throw new CustomerSupplierException(CustomerSupplierException.ORGVIEWSUPPLIERFORBIDDEN);
        }
        if (orgType.equals((Object)OrgType.Company)) {
            ISupplierCompanyInfo iSupplierCompany = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("supplier", (Object)supplierId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            SupplierCompanyInfoCollection companyCollection = iSupplierCompany.getSupplierCompanyInfoCollection(view);
            if (companyCollection == null || companyCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINSUPPLIERCOMPANY);
            }
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            ISupplierPurchaseInfo iSupplierPurchase = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("supplier", (Object)supplierId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            SupplierPurchaseInfoCollection purchaseCollection = iSupplierPurchase.getSupplierPurchaseInfoCollection(view);
            if (purchaseCollection == null || purchaseCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINSUPPLIERPURCHASE);
            }
        } else {
            throw new SCMBillException(SCMBillException.ORGTYPEERROE);
        }
    }

    public static void validateCustomerInfo(Context ctx, OrgType orgType, String orgId, String customerId) throws Exception {
        CustomerCollection customerCollection;
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        EntityViewInfo view = new EntityViewInfo();
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(fullOrgUnitInfo.getCU().getId().toString());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)customerId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("adminCU", (Object)pk.toString(), CompareType.EQUALS));
        FilterInfo filterInfo = iCustomer.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            view.getFilter().mergeFilter(filterInfo, "and");
        }
        if ((customerCollection = iCustomer.getCustomerCollection(view)) == null || customerCollection.size() <= 0) {
            throw new CustomerSupplierException(CustomerSupplierException.ORGVIEWCUSTOMERFORBIDDEN);
        }
        if (orgType.equals((Object)OrgType.Company)) {
            ICustomerCompanyInfo iCustomerCompany = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("customer", (Object)customerId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            CustomerCompanyInfoCollection companyCollection = iCustomerCompany.getCustomerCompanyInfoCollection(view);
            if (companyCollection == null || companyCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINCUSTOMERCOMPANY);
            }
        } else if (orgType.equals((Object)OrgType.Sale)) {
            ICustomerSaleInfo iCustomerSale = CustomerSaleInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("customer", (Object)customerId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("saleOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("saleOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            CustomerSaleInfoCollection saleCollection = iCustomerSale.getCustomerSaleInfoCollection(view);
            if (saleCollection == null || saleCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINCUSTOMERSALE);
            }
        } else {
            throw new SCMBillException(SCMBillException.ORGTYPEERROE);
        }
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, boolean isBizUnit) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs != null && orgs.size() == 0) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (orgs != null) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < orgs.size(); ++i) {
                keys.add(orgs.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        }
        if (orgType == null) {
            return null;
        }
        if (!orgType.equals((Object)OrgType.Admin) && isBizUnit) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 32: {
                    IQualityOrgUnit iTransport = QualityOrgUnitFactory.getLocalInstance((Context)ctx);
                    QualityOrgUnitCollection collection = iTransport.getQualityOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static OrgUnitInfo getDefaultMainBizOrg(RequestContext request, ResponseContext response, Context context) throws EASBizException, BOSException {
        String loginOrgId;
        OrgUnitInfo mainOrg = (OrgUnitInfo)request.get("_SCMMAINORG");
        if (mainOrg != null) {
            return mainOrg;
        }
        OrgUnitInfo[] mainOrgs = SCMServiceFactory.getLocalInstance((Context)context).getAuthorizedBizOrgUnits(request.getUserPK(), (OrgType)request.get("_SCMMAINORGTYPE"), (String)request.get("_SCMPERMISSIONITEM"));
        Class[] typeClass = new Class[]{IObjectPK.class, OrgType.class, String.class};
        Object[] paramsValue = new Object[]{request.getUserPK(), (OrgType)request.get("_SCMMAINORGTYPE"), (String)request.get("_SCMPERMISSIONITEM")};
        try {
            BaseFrameService.getMultiKey((ResponseContext)response, IPermissionService.class, (String)"getAuthorizedBizOrgUnits", (Class[])typeClass, (Object[])paramsValue, (Object)mainOrgs);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (mainOrgs == null || mainOrgs.length == 0) {
            return null;
        }
        String string = loginOrgId = request.getOrg() != null ? request.getOrg().toString() : null;
        if (loginOrgId != null) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!loginOrgId.equals(mainOrgs[i].getId().toString())) continue;
                return mainOrgs[i];
            }
        }
        mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
        return mainOrgs[0];
    }

    public static OrgUnitInfo[] getOrgUnitInfos(Context context, String ids) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)context);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtil.getKeyIdList((String)ids), CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.get(i);
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static void checkLastUpTime(Context ctx, ObjectBaseInfo info, String tableName) throws BOSException, EASBizException {
        block5: {
            Timestamp time = info.getLastUpdateTime();
            BOSUuid id = info.getId();
            if (time != null && id != null) {
                String sql = "select fid ,flastupdatetime from " + tableName + " where fid =?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id.toString()});
                try {
                    if (rs.next()) {
                        Timestamp lst = rs.getTimestamp(2);
                        if (lst.after(time)) {
                            throw new QMException(QMException.SUBMIT_MODIFY);
                        }
                        break block5;
                    }
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public static CoreBaseCollection sortCollection(CoreBaseCollection collection, Object[] idxArray) {
        if (null == collection || null == idxArray || collection.size() <= 0 || idxArray.length <= 0) {
            return null;
        }
        CoreBaseCollection rtnCol = new CoreBaseCollection();
        for (int i = 0; i < idxArray.length; ++i) {
            BOSUuid key = BOSUuid.read((String)((String)idxArray[i]));
            CoreBaseInfo info = (CoreBaseInfo)collection.getObject((Object)key);
            if (null == info) continue;
            rtnCol.add(info);
        }
        return rtnCol;
    }
}

