/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.botp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.botp.AbstractQMFuncInfo;
import com.kingdee.eas.qm.common.util.QMUtils;
import com.kingdee.eas.qm.common.util.backup.QMHelper;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;

public final class QMBOTPGetPeriodDay
extends AbstractQMFuncInfo {
    public QMBOTPGetPeriodDay() {
        super(CATEGORY_MATH, "__BOTPGetPeriodDay", EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"1_QMBOTPGetPeriodDay"));
    }

    @Override
    public Object evalFunction(List args) throws KScriptException {
        Context ctx = this.getContext(args);
        String materialId = args.get(1).toString();
        if (QMHelper.isEmpty(materialId)) {
            throw QMBOTPGetPeriodDay.throwError(EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"2_QMBOTPGetPeriodDay"));
        }
        String orgUnitId = args.get(2).toString();
        if (QMHelper.isEmpty(orgUnitId)) {
            throw QMBOTPGetPeriodDay.throwError(EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"3_QMBOTPGetPeriodDay"));
        }
        try {
            return QMBOTPGetPeriodDay.getPeriodDay(ctx, materialId, orgUnitId);
        }
        catch (EASBizException e) {
            throw QMBOTPGetPeriodDay.throwError((Exception)((Object)e));
        }
        catch (BOSException e) {
            throw QMBOTPGetPeriodDay.throwError((Exception)((Object)e));
        }
    }

    public static Integer getPeriodDay(Context ctx, String materialId, String orgUnitId) throws EASBizException, BOSException {
        MaterialInventoryInfo materialPlanInfo;
        EntityViewInfo ev = QMBOTPGetPeriodDay.getEV(materialId, orgUnitId);
        MaterialInventoryCollection coll = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(ev);
        if (coll.size() == 1 && (materialPlanInfo = coll.get(0)).isIsPeriodValid()) {
            int p = materialPlanInfo.getPeriodValid();
            TimeUnitEnum unit = materialPlanInfo.getPeriodValidUnit();
            return QMUtils.getDayNumber(unit, p);
        }
        return new Integer(0);
    }

    public static EntityViewInfo getEV(String materialId, String orgUnitId) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
        ev.setFilter(filter);
        ev.getSelector().add("*");
        ev.getSelector().add("qualityOrg.*");
        return ev;
    }
}

