/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionUsageEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeEnum;
import com.kingdee.eas.basedata.assistant.StartStandardEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.DemandMergeRulerEnum;
import com.kingdee.eas.basedata.master.material.IAsstAttrType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseDispersionEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialOffsetEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchaseGroup;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QMDataImportTools {
    private static Logger logger = Logger.getLogger((String)QMDataImportTools.class.getName());
    public static final String resClassName = "com.kingdee.eas.basedata.master.material.MaterialResource";
    public static final String resAddClassName = "com.kingdee.eas.basedata.master.material.MaterialAddResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";

    public static void putValue(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public static String getMlData(Hashtable hsData, String fieldName) {
        String result = null;
        String value = (String)((DataToken)hsData.get((Object)new StringBuilder().append((String)fieldName).append((String)"_L1").toString())).data;
        if (value != null && value.trim().length() != 0) {
            result = value;
        }
        if ((value = (String)((DataToken)hsData.get((Object)new StringBuilder().append((String)fieldName).append((String)"_L2").toString())).data) != null && value.trim().length() != 0) {
            result = value;
        }
        if ((value = (String)((DataToken)hsData.get((Object)new StringBuilder().append((String)fieldName).append((String)"_L3").toString())).data) != null && value.trim().length() != 0) {
            result = value;
        }
        return result;
    }

    public static EntityViewInfo getNumberEntityView(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static String getLoc(Context ctx) {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
    }

    public static String getResString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    public static void putToHashtable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public static String getDataString(Hashtable hsData, String fieldName) {
        return (String)((DataToken)hsData.get((Object)fieldName)).data;
    }

    public static BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return new BigDecimal(str);
    }

    public static boolean getDataboolean(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return false;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return false;
        }
        return str.equals("Y") || str.equals("1");
    }

    public static String boolToString(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    public static int getDataint(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return 0;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return 0;
        }
        return new Integer(str);
    }

    public static Date getDataDate(Hashtable hsData, String fieldName) throws Exception {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return TypeConversionUtils.objToDate((Object)str);
    }

    public static void AddFilterItemInfo(FilterInfo filter, String fieldName, Object value) {
        filter.getFilterItems().add(new FilterItemInfo(fieldName, value));
    }

    public static EntityViewInfo getViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static MeasureUnitInfo getMeasureUnitInfo(Context ctx, String number) throws TaskExternalException {
        MeasureUnitCollection unitCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IMeasureUnit iUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            unitCollection = iUnit.getMeasureUnitCollection("where number = '" + number + "'");
            if (unitCollection == null || unitCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_MeasureUnit_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return unitCollection.get(0);
    }

    public static MeasureUnitInfo getMultiMeasureUnitInfo(Context ctx, String number, String materialId) throws TaskExternalException {
        MultiMeasureUnitCollection unitCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        QMDataImportTools.AddFilterItemInfo(filter, "measureUnit.number", number);
        QMDataImportTools.AddFilterItemInfo(filter, "material.id", materialId);
        filter.setMaskString("#0 and #1");
        try {
            IMultiMeasureUnit iUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = QMDataImportTools.getViewInfo(filter);
            unitCollection = iUnit.getMultiMeasureUnitCollection(ev);
            if (unitCollection == null || unitCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_MeasureUnit_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return unitCollection.get(0).getMeasureUnit();
    }

    public static MaterialInfo getMaterialInfo(Context ctx, String number) throws TaskExternalException {
        MaterialCollection matCollection;
        FilterInfo filter = new FilterInfo();
        QMDataImportTools.AddFilterItemInfo(filter, "number", number);
        filter.setMaskString("#0");
        try {
            IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
            matCollection = iMat.getMaterialCollection(QMDataImportTools.getViewInfo(filter));
            if (matCollection == null || matCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_MaterialNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return matCollection.get(0);
    }

    public static MaterialInfo getMaterialInfo(Context ctx, CtrlUnitInfo ctrlUnit, String number) throws BOSException, EASBizException, TaskExternalException {
        MaterialCollection matCollection;
        try {
            IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
            if (ctrlUnit == null) {
                ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            FilterInfo filter = iMat.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ctrlUnit.getId()), "id", "adminCU.id");
            FilterInfo filterNumber = new FilterInfo();
            filterNumber.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filter.mergeFilter(filterNumber, "and");
            matCollection = iMat.getMaterialCollection(QMDataImportTools.getViewInfo(filter));
            if (matCollection == null || matCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_MaterialNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return matCollection.get(0);
    }

    public static MaterialGroupStandardInfo getMaterialGroupStandard(Context ctx, String number) throws TaskExternalException {
        MaterialGroupStandardCollection standardCollection;
        FilterInfo filter = new FilterInfo();
        QMDataImportTools.AddFilterItemInfo(filter, "number", number);
        filter.setMaskString("#0");
        try {
            IMaterialGroupStandard iMatGrouStandard = MaterialGroupStandardFactory.getLocalInstance((Context)ctx);
            standardCollection = iMatGrouStandard.getMaterialGroupStandardCollection(QMDataImportTools.getViewInfo(filter));
            if (standardCollection == null || standardCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_GroupStandardNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return standardCollection.get(0);
    }

    public static MaterialInfo getMaterialInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
        return iMat.getMaterialInfo((IObjectPK)new ObjectUuidPK(id));
    }

    public static String getMaterialName(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        MaterialInfo info = QMDataImportTools.getMaterialInfo(ctx, id);
        return info.getName();
    }

    public static MaterialGroupInfo getMaterialGroupInfo(Context ctx, String number) throws TaskExternalException {
        MaterialGroupCollection groupCollection;
        FilterInfo filter = new FilterInfo();
        QMDataImportTools.AddFilterItemInfo(filter, "number", number);
        filter.setMaskString("#0");
        try {
            IMaterialGroup iGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
            groupCollection = iGroup.getMaterialGroupCollection(QMDataImportTools.getViewInfo(filter));
            if (groupCollection == null || groupCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_BaseGroup_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return groupCollection.get(0);
    }

    public static OrgUnitInfo getOrgUnitInfo(Context ctx, String number) throws TaskExternalException {
        FullOrgUnitCollection orgCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IFullOrgUnit iOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            orgCollection = iOrg.getFullOrgUnitCollection("where number = '" + number + "'");
            if (orgCollection == null || orgCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_OUNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return orgCollection.get(0);
    }

    public static PersonInfo getPersonInfo(Context ctx, String number) throws TaskExternalException {
        PersonCollection perCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            perCollection = iPerson.getPersonCollection("where number = '" + number + "'");
            if (perCollection == null || perCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_InvPlannerNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return perCollection.get(0);
    }

    public static AsstAttrTypeInfo getAsstAttrTypeInfo(Context ctx, String number) throws TaskExternalException {
        AsstAttrTypeCollection asstCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IAsstAttrType iAsst = AsstAttrTypeFactory.getLocalInstance((Context)ctx);
            asstCollection = iAsst.getAsstAttrTypeCollection("where number = '" + number + "'");
            if (asstCollection == null || asstCollection.size() <= 0) {
                throw new TaskExternalException(QMDataImportTools.getResString(resClassName, "DataImport_AsstNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return asstCollection.get(0);
    }

    public static UsedStatusEnum getStatusEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(QMDataImportTools.getResString("DataImport_UsedStatus_Error", ctx));
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)UsedStatusEnum.UNAPPROVE)) {
            return UsedStatusEnum.UNAPPROVE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)UsedStatusEnum.APPROVED)) {
            return UsedStatusEnum.APPROVED;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)UsedStatusEnum.FREEZED)) {
            return UsedStatusEnum.FREEZED;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_UsedStatus_Error", ctx));
    }

    public static PlanningModeEnum getPlanModeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return PlanningModeEnum.NOPLANNING;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)PlanningModeEnum.NOPLANNING)) {
            return PlanningModeEnum.NOPLANNING;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)PlanningModeEnum.REBOOKPOINT)) {
            return PlanningModeEnum.REBOOKPOINT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)PlanningModeEnum.MPS)) {
            return PlanningModeEnum.MPS;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)PlanningModeEnum.MRP)) {
            return PlanningModeEnum.MRP;
        }
        return PlanningModeEnum.NOPLANNING;
    }

    public static BatchPolicyEnum getBatchPolicyEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return BatchPolicyEnum.FIXATIONBATCH;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)BatchPolicyEnum.FIXATIONBATCH)) {
            return BatchPolicyEnum.FIXATIONBATCH;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)BatchPolicyEnum.STRAIGHTBATCH)) {
            return BatchPolicyEnum.STRAIGHTBATCH;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)BatchPolicyEnum.QTYMAXINVENTORY)) {
            return BatchPolicyEnum.QTYMAXINVENTORY;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_UsedStatus_Error", ctx));
    }

    public static AccountType getAccountTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(QMDataImportTools.getResString("DataImport_AccountType_Error", ctx));
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)AccountType.STANDARDCOST)) {
            return AccountType.STANDARDCOST;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)AccountType.MOVE_ADD_AVERAGE)) {
            return AccountType.MOVE_ADD_AVERAGE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)AccountType.ADD_AVERAGE)) {
            return AccountType.ADD_AVERAGE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)AccountType.SPECIAL_ACCT)) {
            return AccountType.SPECIAL_ACCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)AccountType.FIN_FOUT)) {
            return AccountType.FIN_FOUT;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_AccountType_Error", ctx));
    }

    public static MaterialGroupStandardTypeEnum getMaterialGroupStandardEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(QMDataImportTools.getResString("DataImport_GroupStandard_Error", ctx));
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialGroupStandardTypeEnum.BasicStandard)) {
            return MaterialGroupStandardTypeEnum.BasicStandard;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialGroupStandardTypeEnum.DefaultStandard)) {
            return MaterialGroupStandardTypeEnum.DefaultStandard;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_GroupStandard_Error", ctx));
    }

    public static CalculateTypeEnum getCalculateTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(QMDataImportTools.getResString("DataImport_CalType_Error", ctx));
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)CalculateTypeEnum.PURCHASE)) {
            return CalculateTypeEnum.PURCHASE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)CalculateTypeEnum.CONSIGN)) {
            return CalculateTypeEnum.CONSIGN;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)CalculateTypeEnum.SELFMANUFACTURE)) {
            return CalculateTypeEnum.SELFMANUFACTURE;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_CalType_Error", ctx));
    }

    public static StoreType getStoreTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(QMDataImportTools.getResString("DataImport_StoreType_Error", ctx));
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StoreType.SOURCE_MATERIAL)) {
            return StoreType.SOURCE_MATERIAL;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StoreType.FINISHED_PRODUCT)) {
            return StoreType.FINISHED_PRODUCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StoreType.HALF_PRODUCT)) {
            return StoreType.HALF_PRODUCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StoreType.PACK_PRODUCT)) {
            return StoreType.PACK_PRODUCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StoreType.CONSUME_PRODUCT)) {
            return StoreType.CONSUME_PRODUCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StoreType.OTHER)) {
            return StoreType.OTHER;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_StoreType_Error", ctx));
    }

    public static ABCEnum getABCEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return ABCEnum.NOTSELECT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)ABCEnum.A)) {
            return ABCEnum.A;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)ABCEnum.B)) {
            return ABCEnum.B;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)ABCEnum.C)) {
            return ABCEnum.C;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_ABC_Error", ctx));
    }

    public static IssuePriorityEnum getIssuePriorityEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return IssuePriorityEnum.NOTSELECT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)IssuePriorityEnum.BYBATCHNO)) {
            return IssuePriorityEnum.BYBATCHNO;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)IssuePriorityEnum.BYLOTNUMBERQUEUE)) {
            return IssuePriorityEnum.BYLOTNUMBERQUEUE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)IssuePriorityEnum.BYLOTNUMBERSTACK)) {
            return IssuePriorityEnum.BYLOTNUMBERSTACK;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)IssuePriorityEnum.NEARVALIDPERIOD)) {
            return IssuePriorityEnum.NEARVALIDPERIOD;
        }
        throw new TaskExternalException(QMDataImportTools.getResString("DataImport_IssuePriority_Error", ctx));
    }

    public static TimeUnitEnum getTimeUnitEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return TimeUnitEnum.DAY;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)TimeUnitEnum.DAY)) {
            return TimeUnitEnum.DAY;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)TimeUnitEnum.MONTH)) {
            return TimeUnitEnum.MONTH;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)TimeUnitEnum.YEAR)) {
            return TimeUnitEnum.YEAR;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static PayConditionUsageEnum getPayConditionUsageEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)PayConditionUsageEnum.PAYMENT)) {
            return PayConditionUsageEnum.PAYMENT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)PayConditionUsageEnum.RECEIVE)) {
            return PayConditionUsageEnum.RECEIVE;
        }
        return null;
    }

    public static DeletedStatusEnum getDeletedStatusEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)DeletedStatusEnum.NORMAL)) {
            return DeletedStatusEnum.NORMAL;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)DeletedStatusEnum.DELETED)) {
            return DeletedStatusEnum.DELETED;
        }
        return null;
    }

    public static SettlementTypeEnum getSettlementTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)SettlementTypeEnum.CREDIT)) {
            return SettlementTypeEnum.CREDIT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)SettlementTypeEnum.DATE)) {
            return SettlementTypeEnum.DATE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)SettlementTypeEnum.MONTH)) {
            return SettlementTypeEnum.MONTH;
        }
        return null;
    }

    public static StartStandardEnum getStartStandardEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StartStandardEnum.BILL_DATE)) {
            return StartStandardEnum.BILL_DATE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StartStandardEnum.BILL_MONTHEND_DATE)) {
            return StartStandardEnum.BILL_MONTHEND_DATE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StartStandardEnum.BIZ_DATE)) {
            return StartStandardEnum.BIZ_DATE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)StartStandardEnum.BIZ_MONTHEND_DATE)) {
            return StartStandardEnum.BIZ_MONTHEND_DATE;
        }
        return null;
    }

    public static boolean EnumEqualByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw)));
    }

    public static String getResString(String resName, Context ctx) {
        return QMDataImportTools.getResString(resClassName, resName, ctx.getLocale());
    }

    public static String getAddResString(String resName, Context ctx) {
        return QMDataImportTools.getResString(resAddClassName, resName, ctx.getLocale());
    }

    public static MaterialGroupStandardInfo getGroupStandardInfoByNumber(Context ctx, String number) throws BOSException {
        MaterialGroupStandardInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            IMaterialGroupStandard iStandard = MaterialGroupStandardFactory.getLocalInstance((Context)ctx);
            MaterialGroupStandardCollection collection = iStandard.getMaterialGroupStandardCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    public static MaterialGroupInfo getGroupInfoByNumber(Context ctx, String number, String standardNum) throws BOSException {
        MaterialGroupInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.number", (Object)standardNum, CompareType.EQUALS));
            viewInfo.getFilter().mergeFilter(filterInfo, "and");
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("groupStandard.*"));
            IMaterialGroup iMaterialGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
            MaterialGroupCollection collection = iMaterialGroup.getMaterialGroupCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        ICompanyOrgUnit iCompanyOrgUnit;
        CompanyOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        CompanyOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static StorageOrgUnitInfo getStorageOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        IStorageOrgUnit iStorageOrgUnit;
        StorageOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx)).getStorageOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static PurchaseGroupInfo getPurGroupInfoFromNumber(Context ctx, String number) throws BOSException {
        IPurchaseGroup iPurGroup;
        PurchaseGroupCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("purOrg.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        PurchaseGroupInfo purGroupInfo = null;
        if (number != null && number.trim().length() > 0 && (collection = (iPurGroup = PurchaseGroupFactory.getLocalInstance((Context)ctx)).getPurchaseGroupCollection(viewInfo)) != null && collection.size() > 0) {
            purGroupInfo = collection.get(0);
        }
        return purGroupInfo;
    }

    public static PurchaseOrgUnitInfo getPurchaseOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        IPurchaseOrgUnit iPurOrgUnit;
        PurchaseOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        PurchaseOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iPurOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx)).getPurchaseOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static SaleOrgUnitInfo getSaleOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        ISaleOrgUnit iSaleOrgUnit;
        SaleOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SaleOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iSaleOrgUnit = SaleOrgUnitFactory.getLocalInstance((Context)ctx)).getSaleOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static boolean isMaterialAssignForOrg(Context ctx, String materialID, CtrlUnitInfo ctrlUnitInfo) throws BOSException {
        if (ctrlUnitInfo == null) {
            return false;
        }
        return QMDataImportTools.isMaterialAssignForOrg(ctx, materialID, ctrlUnitInfo.getId().toString());
    }

    public static boolean isMaterialAssignForOrg(Context ctx, String materialID, String cuId) throws BOSException {
        FilterInfo filterAssign = new FilterInfo();
        try {
            filterAssign = MaterialFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuId)), "id", "adminCU.id");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        FilterInfo filterMaterialID = new FilterInfo();
        filterMaterialID.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK(BOSUuid.read((String)materialID)), CompareType.EQUALS));
        filterAssign.mergeFilter(filterMaterialID, "and");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterAssign);
        IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCollection materialColl = imaterial.getMaterialCollection(viewInfo);
        return materialColl != null && materialColl.size() != 0;
    }

    public static MaterialProvideTypeEnum getMaterialProvideTypeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialProvideTypeEnum.NONE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
            return MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialProvideTypeEnum.CURRENTORGPROVIDE)) {
            return MaterialProvideTypeEnum.CURRENTORGPROVIDE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialProvideTypeEnum.NONE)) {
            return MaterialProvideTypeEnum.NONE;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static MaterialAttributeEnum getMaterialAttributeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialAttributeEnum.FABRICATEDPART;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialAttributeEnum.PHANTOMPART)) {
            return MaterialAttributeEnum.PHANTOMPART;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialAttributeEnum.FABRICATEDPART)) {
            return MaterialAttributeEnum.FABRICATEDPART;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialAttributeEnum.PURCHASEDPART)) {
            return MaterialAttributeEnum.PURCHASEDPART;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialAttributeEnum.EXTERNALPROCESSINPART)) {
            return MaterialAttributeEnum.EXTERNALPROCESSINPART;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialAttributeEnum.OTHER)) {
            return MaterialAttributeEnum.OTHER;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static MaterialCharEnum getMaterialCharEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialCharEnum.NONE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialCharEnum.NONE)) {
            return MaterialCharEnum.NONE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialCharEnum.MASTERPROP)) {
            return MaterialCharEnum.MASTERPROP;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialCharEnum.AUXILIARYPROP)) {
            return MaterialCharEnum.AUXILIARYPROP;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialCharEnum.REFERRENCEPROP)) {
            return MaterialCharEnum.REFERRENCEPROP;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static MaterialOffsetEnum getMaterialOffsetEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialOffsetEnum.NONE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialOffsetEnum.NONE)) {
            return MaterialOffsetEnum.NONE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialOffsetEnum.OFFSETFORWARD)) {
            return MaterialOffsetEnum.OFFSETFORWARD;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialOffsetEnum.OFFSETBACK)) {
            return MaterialOffsetEnum.OFFSETBACK;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialOffsetEnum.OFFSETFORWARDTOBACK)) {
            return MaterialOffsetEnum.OFFSETFORWARDTOBACK;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialOffsetEnum.OFFSETBACKTOFORWARD)) {
            return MaterialOffsetEnum.OFFSETBACKTOFORWARD;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static DemandMergeRulerEnum getDemandMergeRulerEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return DemandMergeRulerEnum.None;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)DemandMergeRulerEnum.None)) {
            return DemandMergeRulerEnum.None;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)DemandMergeRulerEnum.MERGEBYDAY)) {
            return DemandMergeRulerEnum.MERGEBYDAY;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static MaterialLeadTimeTypeEnum getMaterialLeadTimeTypeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialLeadTimeTypeEnum.FIXBATCHTYPE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialLeadTimeTypeEnum.FIXBATCHTYPE)) {
            return MaterialLeadTimeTypeEnum.FIXBATCHTYPE;
        }
        return MaterialLeadTimeTypeEnum.FIXBATCHTYPE;
    }

    public static MaterialScrapRateExpressionEnum getMaterialScrapRateExpressionEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialScrapRateExpressionEnum.BYDIVIDE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
            return MaterialScrapRateExpressionEnum.BYDIVIDE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialScrapRateExpressionEnum.MUTIPLE)) {
            return MaterialScrapRateExpressionEnum.MUTIPLE;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static MaterialProductEnum getMaterialProductEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        MaterialProductEnum defaultValue = MaterialProductEnum.OTHER;
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialProductEnum.MASTERPRODUCT)) {
            return MaterialProductEnum.MASTERPRODUCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialProductEnum.RELATEDPRODUCT)) {
            return MaterialProductEnum.RELATEDPRODUCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialProductEnum.BYPRODUCT)) {
            return MaterialProductEnum.BYPRODUCT;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialProductEnum.OTHER)) {
            return MaterialProductEnum.OTHER;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static MaterialIssueModeEnum getMaterialIssueModeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        MaterialIssueModeEnum defaultValue = MaterialIssueModeEnum.PRODUCEISSMODE;
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialIssueModeEnum.PRODUCEISSMODE)) {
            return MaterialIssueModeEnum.PRODUCEISSMODE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialIssueModeEnum.KANBANISSMODE)) {
            return MaterialIssueModeEnum.KANBANISSMODE;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialIssueModeEnum.NOTISSMODE)) {
            return MaterialIssueModeEnum.NOTISSMODE;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }

    public static MaterialBaseDispersionEnum getMaterialBaseDispersionEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialBaseDispersionEnum.PRODUCTIONPLANQTY;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialBaseDispersionEnum.PRODUCTIONPLANQTY)) {
            return MaterialBaseDispersionEnum.PRODUCTIONPLANQTY;
        }
        if (QMDataImportTools.EnumEqualByAlias(value, (Enum)MaterialBaseDispersionEnum.FINISHEDREPORTQTY)) {
            return MaterialBaseDispersionEnum.FINISHEDREPORTQTY;
        }
        throw new TaskExternalException(QMDataImportTools.getResString(errResName, ctx));
    }
}

