/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.qm.common.filter.FilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import java.awt.Component;
import org.apache.log4j.Logger;

public class RangeFilterElement
extends FilterElement {
    private static Logger logger = Logger.getLogger((String)RangeFilterElement.class.getName());
    SingleFilterElement from;
    SingleFilterElement to;

    public RangeFilterElement(String compareExp, Component fromComp, Component toComp) {
        super(compareExp);
        this.from = new SingleFilterElement(compareExp, fromComp);
        this.to = new SingleFilterElement(compareExp, toComp);
        this.to.putUserInfo("type", "end");
        this.from.setId(compareExp + "from");
        this.to.setId(compareExp + "to");
        this.from.setCompareType(CompareType.GREATER_EQUALS);
        this.to.setCompareType(CompareType.LESS_EQUALS);
    }

    public SingleFilterElement getFrom() {
        return this.from;
    }

    public void setFrom(SingleFilterElement from) {
        this.from = from;
    }

    public SingleFilterElement getTo() {
        return this.to;
    }

    public void setTo(SingleFilterElement to) {
        this.to = to;
    }

    public RangeFilterElement(String compareExp, Component fromComp, Component toComp, Object[] blankValue) {
        super(compareExp, blankValue);
        Object blankValuefrom = null;
        Object blankValueto = null;
        if (blankValue != null && blankValue.length == 2) {
            blankValuefrom = blankValue[0];
            blankValueto = blankValue[0];
        }
        this.from = new SingleFilterElement(compareExp, fromComp, blankValuefrom);
        this.to = new SingleFilterElement(compareExp, toComp, blankValueto);
        this.to.putUserInfo("type", "end");
        this.from.setId(compareExp + "from");
        this.to.setId(compareExp + "id");
        this.from.setCompareType(CompareType.GREATER_EQUALS);
        this.to.setCompareType(CompareType.LESS_EQUALS);
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo item1 = null;
        FilterInfo item2 = null;
        item1 = this.from.getFilterInfo();
        item2 = this.to.getFilterInfo();
        try {
            if (item1 != null) {
                filterInfo.mergeFilter(item1, "and");
            }
            if (item2 != null) {
                filterInfo.mergeFilter(item2, "and");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filterInfo.getFilterItems().size() > 0 ? filterInfo : null;
    }

    @Override
    public void clear() {
        this.from.clear();
        this.to.clear();
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CustomerParams me = cp.getMe(this.from.getId());
        this.from.setElementValue(me);
        CustomerParams me2 = cp.getMe(this.to.getId());
        this.to.setElementValue(me2);
    }

    public void setDefaultValue(Object value) {
        if (value instanceof String[]) {
            String[] values = (String[])value;
            if (values.length > 0) {
                this.from.setDefaultValue(values[0]);
            }
            if (values.length > 1) {
                this.to.setDefaultValue(values[1]);
            }
        }
    }

    @Override
    public CustomerParams getElementValue() {
        CustomerParams cst = new CustomerParams();
        CustomerParams elementValue = this.from.getElementValue();
        CustomerParams elementValue2 = this.to.getElementValue();
        if (elementValue == null && elementValue2 == null) {
            return null;
        }
        if (elementValue != null) {
            cst.putMe(this.from.getId(), elementValue);
        }
        if (elementValue2 != null) {
            cst.putMe(this.to.getId(), elementValue2);
        }
        return cst;
    }

    @Override
    public String getValue() {
        return this.from.getValue() + " to " + this.from.getValue();
    }
}

