/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.print;

import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.qm.common.print.QMPrintDataProvider;
import com.kingdee.eas.qm.common.print.QMPrintIntegrationCustomFilterMaker;
import com.kingdee.eas.qm.common.print.QMPrintIntegrationHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class QMPrintIntegrationDataProvider
extends QMPrintDataProvider {
    private static final Logger logger = Logger.getLogger(QMPrintIntegrationDataProvider.class);
    private IMetaDataPK queryPk = null;
    private BOSObjectType bosType = null;

    public QMPrintIntegrationDataProvider(BOSObjectType bosType, IMetaDataPK queryPk) {
        this.bosType = bosType;
        this.queryPk = queryPk;
        this.setDefaultMetaDataPK(queryPk);
        QMPrintIntegrationCustomFilterMaker customFilterMaker = new QMPrintIntegrationCustomFilterMaker(this.bosType);
        this.setCustomFilterMaker(customFilterMaker);
    }

    public QMPrintIntegrationDataProvider(BOSObjectType bosType) {
        this(bosType, QMPrintIntegrationHelper.getPrintIntegrationQueryPK());
    }

    @Override
    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        return super.getData(dataSource);
    }

    @Override
    public IRowSet afterExecuteQuery(IRowSet rowSet) throws Exception {
        IRowSet rs = super.afterExecuteQuery(rowSet);
        String username = SysContext.getSysContext().getCurrentUserInfo().getName();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        if (rs.size() <= 0) {
            rs = this.createTempRowSet(0, username, time);
        } else {
            while (rs.next()) {
                int pnum = rs.getInt("printedNumber");
                rs.updateInt(4, pnum + 1);
                rs.updateString("lastPrintUser.name", username);
                rs.updateTimestamp("lastPrintTime", time);
            }
            rs.beforeFirst();
        }
        return rs;
    }

    private IRowSet createTempRowSet(int pnum, String username, Timestamp time) throws Exception {
        logger.info((Object)"Create a temp rowset!");
        DynamicRowSet drs = null;
        drs = new DynamicRowSet(3);
        drs.setColInfo(1, "printedNumber", "printedNumber", 4, null);
        drs.setColInfo(2, "lastPrintUser.name", "lastPrintTime", 12, null);
        drs.setColInfo(3, "lastPrintTime", "lastPrintTime", 93, null);
        drs.moveToInsertRow();
        drs.updateInt("printedNumber", pnum);
        drs.updateString("lastPrintUser.name", username);
        drs.updateTimestamp("lastPrintTime", time);
        drs.insertRow();
        drs.beforeFirst();
        return drs;
    }

    public IMetaDataPK getQueryPk() {
        return this.queryPk;
    }

    public void setQqueryPk(IMetaDataPK queryPk) {
        this.queryPk = queryPk;
    }

    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public void setBosType(BOSObjectType bosType) {
        this.bosType = bosType;
    }
}

