/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util;

import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.common.util.QMConstant;
import java.math.BigDecimal;

public abstract class NumericUtils {
    public static int effectualPrecision(int scale) {
        return scale >= 0 ? scale : 2;
    }

    public static int effectualPrecision(int scale, int defaultScale) {
        int d = 4;
        if (defaultScale >= 0) {
            d = defaultScale;
        }
        return scale >= 0 ? scale : d;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static BigDecimal toBigDecimal(Object o) {
        BigDecimal result = NumericUtils.effectualNumeric(null);
        if (o != null) {
            String vString;
            if (o instanceof BigDecimal) {
                result = (BigDecimal)o;
            } else if ((o instanceof String || o instanceof StringBuffer) && (vString = o.toString().trim()).matches("(-|\\+)?\\d+\\.?\\d*")) {
                result = new BigDecimal(vString);
            }
        }
        return result;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return NumericUtils.isDistrustExchangeRate(exchangeRate) ? exchangeRate : QMConstant.EXCHANGERATE_DEFAULT;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return NumericUtils.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean isBigDecimal(String str) {
        boolean result = false;
        if (str != null && str.matches("(-|\\+)?\\d+\\.?\\d*")) {
            result = true;
        }
        return result;
    }
}

