/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.JTextField;

public class QMPrecisionUtil {
    public static final int DEFAULT_PRICISION = 4;
    public static final int DEFAULT_AMOUT_PRICISION = 2;
    public static final int DEFAULT_QTY_PRICISION = 8;
    public static final BigDecimal BigDecimal_MaxValue = new BigDecimal("9999999999999.99999999");
    public static final BigDecimal BigDecimal_MinValue = new BigDecimal("-9999999999999.99999999");
    private static HashMap multiMeasureUnitMap = new HashMap();
    private static HashMap precisionMap = new HashMap();

    public static String getFormatString(int precision) {
        return PrecisionUtil.getFormatString((int)precision);
    }

    public static String getNumberFtmStr(int precision) {
        StringBuffer formatBuffer = new StringBuffer("##,###,###,###,###,##0");
        if (precision > 0) {
            formatBuffer.append(".");
        }
        for (int i = 0; i < precision; ++i) {
            formatBuffer.append("0");
        }
        return formatBuffer.toString();
    }

    public static KDFormattedTextField getNumberEditor(int precision, BigDecimal maxValue, BigDecimal minValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        QMPrecisionUtil.setNumberEditorFmt(precision, maxValue, minValue, colTxtField);
        return colTxtField;
    }

    public static void setNumberEditorFmt(int precision, BigDecimal maxValue, BigDecimal minValue, KDFormattedTextField colTxtField) {
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setRemoveingZeroInEdit(false);
        if (minValue != null) {
            colTxtField.setMinimumValue((Comparable)minValue);
        }
        if (minValue == null || colTxtField.getMinimumValue() == null || colTxtField.getMinimumValue().compareTo(BigDecimal_MinValue) == -1) {
            colTxtField.setMinimumValue((Comparable)BigDecimal_MinValue);
        }
        if (maxValue != null) {
            colTxtField.setMaximumValue((Comparable)maxValue);
        }
        if (maxValue == null || colTxtField.getMaximumValue() == null || colTxtField.getMaximumValue().compareTo(BigDecimal_MaxValue) == 1) {
            colTxtField.setMaximumValue((Comparable)BigDecimal_MaxValue);
        }
    }

    public static void setNumberEditorFmt(int precision, BigDecimal maxValue, BigDecimal minValue, KDFormattedTextField[] colTxtFields) {
        for (int i = 0; i < colTxtFields.length; ++i) {
            QMPrecisionUtil.setNumberEditorFmt(precision, maxValue, minValue, colTxtFields[i]);
        }
    }

    public static void setColNumberEditor(int precision, KDTable table, String[] cols, BigDecimal maxValue, BigDecimal minValue) {
        for (int i = 0; i < cols.length; ++i) {
            KDFormattedTextField txtNum = QMPrecisionUtil.getNumberEditor(precision, maxValue, minValue);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtNum);
            table.getColumn(cols[i]).setEditor((ICellEditor)editor);
            table.getColumn(cols[i]).getStyleAttributes().setNumberFormat(QMPrecisionUtil.getFormatString(precision));
        }
    }

    public static void setRowNumberEditor(int precision, KDTable table, int rowIndex, String[] cols, BigDecimal maxValue, BigDecimal minValue) {
        QMPrecisionUtil.setRowNumberEditor(precision, table, rowIndex, cols, maxValue, minValue, true);
    }

    public static void setRowNumberEditor(int precision, KDTable table, int rowIndex, String[] cols, BigDecimal maxValue, BigDecimal minValue, boolean canUsed) {
        IRow row = table.getRow(rowIndex);
        QMPrecisionUtil.setRowNumberEditor(precision, row, cols, maxValue, minValue, canUsed);
    }

    public static void setRowNumberEditor(int precision, IRow row, String[] cols, BigDecimal maxValue, BigDecimal minValue, boolean canUsed) {
        for (int i = 0; i < cols.length; ++i) {
            KDFormattedTextField txtNum = QMPrecisionUtil.getNumberEditor(precision, maxValue, minValue);
            txtNum.setEditable(canUsed);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtNum);
            row.getCell(cols[i]).setEditor((ICellEditor)editor);
            row.getCell(cols[i]).getStyleAttributes().setNumberFormat(QMPrecisionUtil.getFormatString(precision));
            row.getCell(cols[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static int qtyPrecision(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QMPrecisionUtil.multiUnitQTYPrecision(QMPrecisionUtil.multiMeasureUnit(null, material, unit));
    }

    public static int qtyPrecision(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QMPrecisionUtil.multiUnitQTYPrecision(QMPrecisionUtil.multiMeasureUnit(ctx, material, unit));
    }

    public static int multiUnitQTYPrecision(MultiMeasureUnitInfo multiUnit) {
        int scale = 4;
        if (null != multiUnit) {
            scale = QMPrecisionUtil.effectualQtyPrecision(multiUnit.getQtyPrecision());
        }
        return scale;
    }

    public static int effectualQtyPrecision(int scale) {
        return scale >= 0 ? scale : 4;
    }

    public static MultiMeasureUnitInfo multiMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        String key;
        MultiMeasureUnitInfo multiUnit = null;
        if (null != material && null != material.getId() && null != unit && null != unit.getId() && (multiUnit = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(key = material.getId().toString() + "AND" + unit.getId().toString())) == null) {
            multiUnit = QMPrecisionUtil.getMultiUnitBizInterface(ctx).getMultiUnit(material.getId().toString(), unit.getId().toString());
            multiMeasureUnitMap.put(key, multiUnit);
        }
        return multiUnit;
    }

    private static IMultiMeasureUnit getMultiUnitBizInterface(Context ctx) throws BOSException {
        IMultiMeasureUnit ie = null;
        ie = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        return ie;
    }
}

