/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.qm.common.QMVerifyException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.log4j.Logger;

public final class QMVerifyHelper {
    private static Logger logger = Logger.getLogger((String)QMVerifyHelper.class.getName());

    public static void checkNumberEmpty(DataBaseInfo info) throws EASBizException {
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK, new Object[0]);
        }
    }

    public static void checkNumberEmpty(BillBaseInfo info) throws EASBizException {
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK, new Object[0]);
        }
    }

    public static void checkBlank(Object o1, Object[] args) throws EASBizException {
        if (o1 == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
        if (o1 instanceof String && o1.toString().trim().length() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkBlank(Context ctx, IObjectValue vo, String name) throws EASBizException {
        Object val = vo.get(name);
        if (val == null) {
            QMVerifyHelper.checkMsg(ctx, vo, name, val);
        } else if (val instanceof String && val.toString().trim().length() == 0) {
            QMVerifyHelper.checkMsg(ctx, vo, name, (String)val);
        }
    }

    public static void checkMustMoreThanZero(Context ctx, IObjectValue vo, String name) throws EASBizException {
        QMVerifyHelper.checkBlank(ctx, vo, name);
        Object value = vo.get(name);
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.signum() <= 0) {
                String alias = QMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
                throw new QMVerifyException(QMVerifyException.MUSTMORETHANZERO, new Object[]{alias});
            }
        } else {
            String alias = QMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
            throw new QMVerifyException(QMVerifyException.FIELDNOTBIGDECIMAL, new Object[]{alias});
        }
    }

    public static void checkNotLessThanZero(Context ctx, IObjectValue vo, String name) throws EASBizException {
        QMVerifyHelper.checkBlank(ctx, vo, name);
        Object value = vo.get(name);
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.signum() < 0) {
                String alias = QMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
                throw new QMVerifyException(QMVerifyException.MUSTNOTLESSTHANZERO, new Object[]{alias});
            }
        } else {
            String alias = QMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
            throw new QMVerifyException(QMVerifyException.FIELDNOTBIGDECIMAL, new Object[]{alias});
        }
    }

    public static void checkDateFromBeforeDateTo(Context ctx, IObjectValue vo, String dateFrom, String dateTo) throws EASBizException {
        Date fromDate = vo.getDate(dateFrom);
        Date toDate = vo.getDate(dateTo);
        String aliasFrom = QMVerifyHelper.getEntityFieldAlias(ctx, vo, dateFrom);
        String aliasTo = QMVerifyHelper.getEntityFieldAlias(ctx, vo, dateTo);
        if (!fromDate.before(toDate)) {
            throw new QMVerifyException(QMVerifyException.DATEFROMMUSTBEFORETO, new Object[]{aliasFrom, aliasTo});
        }
    }

    public static void throwNotSame(Context ctx, IObjectValue val, String name) throws EASBizException {
        String alias = QMVerifyHelper.getEntityFieldAlias(ctx, val, name);
        QMVerifyHelper.checkBlank(val, (Object[])new String[]{alias});
        throw new QMVerifyException(QMVerifyException.ATTRINOTSAME, new String[]{alias});
    }

    private static void checkMsg(Context ctx, IObjectValue vo, String name, Object val) throws EASBizException {
        String alias = QMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
        QMVerifyHelper.checkBlank(val, (Object[])new String[]{alias});
    }

    private static String getEntityFieldAlias(Context ctx, IObjectValue vo, String name) {
        IMetaDataLoader loader = null;
        loader = ctx != null ? MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx) : MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(vo.getBOSType());
        PropertyInfo property = entity.getPropertyByName(name);
        String alias = null;
        if (property != null) {
            alias = property.getAlias();
        }
        return alias;
    }

    public static void checkBlank(int o1, Object[] args) throws EASBizException {
        if (o1 == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkBlank(String o1, Object[] args) throws EASBizException {
        if (o1 == null || o1.trim().length() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkBlank(Object[] o1, Object[] args) throws EASBizException {
        if (o1 == null || o1.length == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkTreeNodeData(KDTreeNode treeNode, ICoreBase iCoreBase, Component comp) {
        try {
            if (treeNode.getUserObject() instanceof TreeBaseInfo) {
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("group.id", (Object)((TreeBaseInfo)treeNode.getUserObject()).getId().toString());
                if (iCoreBase.exists(filter)) {
                    MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"cannotAddGroup"));
                    SysUtil.abort();
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            SysUtil.abort();
        }
    }

    public static void checkIsLeaf(KDTreeNode treeNode, Component comp) {
        if (treeNode != null && !treeNode.isLeaf() && !treeNode.isRoot()) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"cannotAddData"));
            SysUtil.abort();
        }
    }
}

