/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util.backup;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.util.VOComparetor;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.CurrencyExchangeRateUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QMCommonUtils {
    private static Logger logger = Logger.getLogger((String)QMCommonUtils.class.getName());
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    public static final BigDecimal BIGDECIMAL_ONE;
    public static final BigDecimal EXCHANGERATE_DEFAULT;
    public static final int PRECISION_DEFAUL = 2;
    public static final int PRECISION_DEFAUL_DB = 10;

    public static IObjectPK[] convertStringToObjectPK(String[] pkStrs) {
        if (pkStrs == null || pkStrs.length == 0) {
            return null;
        }
        int num = pkStrs.length;
        ObjectUuidPK[] objectPk = new ObjectUuidPK[num];
        for (int i = 0; i < num; ++i) {
            objectPk[i] = new ObjectUuidPK(pkStrs[i]);
        }
        return objectPk;
    }

    public static String getBillTypeNOFormBillTypeID(BillTypeInfo billType) {
        if (billType == null || billType.getId() == null) {
            return null;
        }
        return QMCommonUtils.getBillTypeNOFormBillTypeID(billType.getId());
    }

    public static String getBillTypeNOFormBillTypeID(BOSUuid id) {
        if (id == null) {
            return null;
        }
        return QMCommonUtils.getBillTypeNOFormBillTypeID(id.toString());
    }

    public static String getBillTypeNOFormBillTypeID(String billTypeID) {
        if ("50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
            return "110";
        }
        if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            return "101";
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
            return "102";
        }
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
            return "103";
        }
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
            return "104";
        }
        if ("XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeID)) {
            return "160";
        }
        if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
            return "105";
        }
        if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) {
            return "106";
        }
        if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
            return "107";
        }
        if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            return "108";
        }
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            return "109";
        }
        if ("528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            return "100";
        }
        if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billTypeID)) {
            return "410";
        }
        if ("3a3b5446-0106-1000-e000-01c3c0a812e6463ED552".equals(billTypeID)) {
            return "420";
        }
        if ("510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(billTypeID)) {
            return "230";
        }
        if ("510b6503-0105-1000-e000-0117c0a812fd463ED552".equals(billTypeID)) {
            return "330";
        }
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(billTypeID)) {
            return "210";
        }
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billTypeID)) {
            return "220";
        }
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(billTypeID)) {
            return "310";
        }
        if ("510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(billTypeID)) {
            return "320";
        }
        if ("50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billTypeID)) {
            return "120";
        }
        if ("50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billTypeID)) {
            return "130";
        }
        if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID)) {
            return "140";
        }
        if ("50957179-0105-1000-e004-4152c0a812fd463ED552".equals(billTypeID)) {
            return "150";
        }
        if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(billTypeID)) {
            return "250";
        }
        if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(billTypeID)) {
            return "350";
        }
        return null;
    }

    public static MultiMeasureUnitInfo getSaleMultiUnit(String meterialID, String saleOrgID) {
        MultiMeasureUnitInfo measureUnitInfo = null;
        try {
            IMaterial material = MaterialFactory.getRemoteInstance();
            MaterialSalesInfo materialSaleOrgInfo = MaterialSalesFactory.getRemoteInstance().getSalesInfo(meterialID, saleOrgID);
            MeasureUnitInfo saleUnitInfo = materialSaleOrgInfo.getUnit();
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            measureUnitInfo = multiUnit.getMultiUnit(meterialID, saleUnitInfo.getId().toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return measureUnitInfo;
    }

    public static MultiMeasureUnitInfo getPurMultiUnit(String meterialID, String purOrgID) {
        MultiMeasureUnitInfo measureUnitInfo = null;
        try {
            IMaterial material = MaterialFactory.getRemoteInstance();
            MaterialPurchasingInfo materialPurInfo = MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(meterialID, purOrgID);
            MeasureUnitInfo saleUnitInfo = materialPurInfo.getUnit();
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            measureUnitInfo = multiUnit.getMultiUnit(meterialID, saleUnitInfo.getId().toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return measureUnitInfo;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, baseQty.scale() + qty.scale(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangePrecisionQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = QMCommonUtils.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = QMCommonUtils.effectualNumeric(baseQty).divide(QMCommonUtils.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangePriceForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal price) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetPrice = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = QMCommonUtils.effectualExchangeRate(multiUnifInfo.getBaseConvsRate());
            BigDecimal baseExchangeRate2 = QMCommonUtils.effectualExchangeRate(othermultiUnifInfo.getBaseConvsRate());
            int scale = 28;
            BigDecimal basePrice = QMCommonUtils.effectualNumeric(price).divide(baseExchangeRate1, scale, 4);
            if (basePrice != null && price != null) {
                scale = basePrice.scale() + price.scale();
            }
            targetPrice = QMCommonUtils.effectualNumeric(basePrice).multiply(QMCommonUtils.effectualExchangeRate(baseExchangeRate2)).setScale(scale, 4);
        }
        return targetPrice;
    }

    public static BigDecimal getExchangePricesionQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal baseQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        if (multiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            baseQty = qty.multiply(baseExchangeRate1);
        }
        return baseQty;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, String materialID, String unitInfoID, BigDecimal qty, String otherUnitInfoID) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfoID.toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfoID.toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1).setScale(16, 4);
            int scale = QMCommonUtils.effectualPrecision(othermultiUnifInfo.getQtyPrecision());
            targetQty = baseQty.divide(baseExchangeRate2, scale, 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(MultiMeasureUnitInfo multiUnifInfo, MultiMeasureUnitInfo othermultiUnifInfo, BigDecimal qty) {
        BigDecimal targetQty = null;
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1).setScale(16, 4);
            int scale = QMCommonUtils.effectualPrecision(othermultiUnifInfo.getQtyPrecision());
            targetQty = baseQty.divide(baseExchangeRate2, baseQty.scale() + qty.scale(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeRateQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo mulUnit;
        BigDecimal baseExchangeRate = new BigDecimal("1.00");
        IMultiMeasureUnit immu = null;
        immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (material != null && unit != null && (mulUnit = immu.getMultiUnit(material.getId().toString(), unit.getId().toString())) != null && ((baseExchangeRate = mulUnit.getBaseConvsRate()) == null || new BigDecimal("0").compareTo(baseExchangeRate) == 0)) {
            baseExchangeRate = new BigDecimal("1.00");
        }
        return baseExchangeRate;
    }

    public static void refreshEnumList(KDComboBox list, Iterator itor) {
        list.removeAllItems();
        if (itor != null) {
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public static Timestamp getSCMQueryTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(QMClientUtils.getServerDate2());
        }
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static Timestamp getDayEndTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayStartTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        if (scmBillBaseInfo == null) {
            return false;
        }
        BillTypeInfo billType = scmBillBaseInfo.getSourceBillType();
        return billType != null;
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String billTypeID) {
        if (QMCommonUtils.isBotpBill(scmBillBaseInfo)) {
            return scmBillBaseInfo.getSourceBillType().getId().toString().equalsIgnoreCase(billTypeID);
        }
        return false;
    }

    public static BigDecimal calculateLocalAmount(BigDecimal amount, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal localAmount = new BigDecimal("0.00");
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                localAmount = amount.multiply(exchangeRateinfo.getConvertRate());
            } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                int scale = amount.scale() + exchangeRateinfo.getConvertRate().scale();
                localAmount = amount.divide(exchangeRateinfo.getConvertRate(), scale, 4);
            }
        } else {
            localAmount = amount;
        }
        return localAmount;
    }

    public static BigDecimal calculateOriginAmount(BigDecimal baseamount, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal amount = new BigDecimal("0.00");
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                int scale = baseamount.scale() + exchangeRateinfo.getConvertRate().scale();
                amount = baseamount.divide(exchangeRateinfo.getConvertRate(), scale, 4);
            } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                amount = baseamount.multiply(exchangeRateinfo.getConvertRate());
            }
        } else {
            amount = baseamount;
        }
        return amount;
    }

    public static BigDecimal getExchangeRateAmount(Context ctx, CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        BigDecimal exchangeRate = new BigDecimal("1.00");
        if (currencyInfo != null) {
            ObjectUuidPK sourceCurrPK = new ObjectUuidPK(QMCommonUtils.getCompanyBaseCurrency(ctx, ficompanyOrgInfo).getId().toString());
            ObjectUuidPK destCurrPK = new ObjectUuidPK(currencyInfo.getId());
            ObjectUuidPK excTablepk = null;
            ExchangeTableInfo exchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (exchangeTableInfo != null) {
                excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
                IExchangeRate iexchangRate = null;
                iexchangRate = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
                ExchangeRateInfo exchangeRateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
                if (exchangeRateinfo != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("exchangeAux.*"));
                    exchangeRateinfo = iexchangRate.getExchangeRateInfo((IObjectPK)new ObjectUuidPK(exchangeRateinfo.getId()), sic);
                }
                if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
                    if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                        exchangeRate = exchangeRate.divide(exchangeRateinfo.getConvertRate(), 4);
                    } else if (exchangeRateinfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        exchangeRate = exchangeRateinfo.getConvertRate();
                    }
                } else {
                    exchangeRate = new BigDecimal("1.00");
                }
            }
        }
        return exchangeRate;
    }

    public static CurrencyInfo getCompanyBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        if (company.getBaseCurrency() != null) {
            currency = company.getBaseCurrency();
            return currency;
        }
        ICompanyOrgUnit corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    public static void releaseMutex(Uuid id) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseMutex(id);
    }

    public static boolean requestMutex(MutexParameter param) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        return mutexService.requestMutex(param);
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String mutextName, MutexLockType lockType) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(mutextName);
        param.setMutexLockType(lockType);
        return param;
    }

    public static String getResource(String resClassName, String key, Context ctx) {
        return QMCommonUtils.getString(resClassName, key, ctx.getLocale());
    }

    public static String getString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    public static String toParamString(Iterator itor, List params) {
        int count = 0;
        Object o = null;
        if (params == null) {
            params = new ArrayList<String>();
        }
        StringBuffer paramString = new StringBuffer("(");
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null) continue;
            if (count > 0) {
                paramString.append(",");
            }
            paramString.append(" ? ");
            params.add(o.toString());
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        } else {
            paramString.append(")");
        }
        return paramString.toString();
    }

    public static BigDecimal calculateNumericForMulExchangeRate(BigDecimal numeric, ExchangeRateInfo rate, ExchangeRateInfo oldRate, int scale) {
        BigDecimal localNumeric = QMCommonUtils.convertAmountByExchangeRate(numeric, oldRate, 10);
        BigDecimal result = QMCommonUtils.effectualNumeric(numeric);
        if (rate != null) {
            ConvertModeEnum mode = rate.getConvertMode();
            if (mode != null) {
                if (mode.getValue() == 0) {
                    result = QMCommonUtils.effectualNumeric(localNumeric).divide(QMCommonUtils.effectualExchangeRate(rate.getConvertRate()), QMCommonUtils.effectualPrecision(scale), 4);
                } else if (mode.getValue() == 1) {
                    result = QMCommonUtils.effectualNumeric(localNumeric).multiply(QMCommonUtils.effectualExchangeRate(rate.getConvertRate())).setScale(QMCommonUtils.effectualPrecision(scale), 4);
                }
            } else {
                result = QMCommonUtils.effectualNumeric(localNumeric).divide(QMCommonUtils.effectualExchangeRate(rate.getConvertRate()), QMCommonUtils.effectualPrecision(scale), 4);
            }
        }
        return result;
    }

    public static BigDecimal convertAmountByCompany(Context ctx, BigDecimal amount, CompanyOrgUnitInfo company, CurrencyInfo currency, BigDecimal exchangeRate) throws BOSException, EASBizException {
        if (QMCommonUtils.equalsZero(amount) || currency == null || currency.getId() == null || company == null || company.getBaseCurrency() == null || company.getBaseCurrency().getId() == null || currency.getId().toString().equals(company.getBaseCurrency().getId().toString())) {
            return amount;
        }
        ExchangeRateInfo rateInfo = CurrencyExchangeRateUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, null);
        if (rateInfo == null) {
            throw new SCMBillException(SCMBillException.NULL_EXCHANGERATE);
        }
        if (!QMCommonUtils.equalsZero(exchangeRate)) {
            rateInfo.setConvertRate(QMCommonUtils.effectualExchangeRate(exchangeRate));
        }
        BigDecimal result = amount;
        result = QMCommonUtils.convertAmountByExchangeRate(result, rateInfo, PrecisionUtil.getCurrencyPrecisionByCompany((CompanyOrgUnitInfo)company));
        return result;
    }

    public static BigDecimal convertAmountByCompany(Context ctx, BigDecimal amount, CompanyOrgUnitInfo company, CurrencyInfo currency) throws BOSException, EASBizException {
        return QMCommonUtils.convertAmountByCompany(ctx, amount, company, currency, null);
    }

    public static BigDecimal convertAmountByExchangeRate(BigDecimal amount, ExchangeRateInfo exchangeRate, int scale) {
        BigDecimal result = QMCommonUtils.effectualNumeric(amount);
        if (exchangeRate != null) {
            ConvertModeEnum mode = exchangeRate.getConvertMode();
            if (mode != null) {
                if (mode.getValue() == 0) {
                    result = QMCommonUtils.effectualNumeric(amount).multiply(QMCommonUtils.effectualExchangeRate(exchangeRate.getConvertRate())).setScale(QMCommonUtils.effectualPrecision(scale), 4);
                } else if (mode.getValue() == 1) {
                    result = QMCommonUtils.effectualNumeric(amount).divide(QMCommonUtils.effectualExchangeRate(exchangeRate.getConvertRate()), QMCommonUtils.effectualPrecision(scale), 4);
                }
            } else {
                result = QMCommonUtils.effectualNumeric(amount).multiply(QMCommonUtils.effectualExchangeRate(exchangeRate.getConvertRate())).setScale(QMCommonUtils.effectualPrecision(scale), 4);
            }
        }
        return result;
    }

    public static int effectualPrecision(int scale) {
        return scale >= 0 ? scale : 2;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return QMCommonUtils.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return QMCommonUtils.isDistrustExchangeRate(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static boolean equalsID(ObjectBaseInfo val1, ObjectBaseInfo val2) {
        return val1 == null ? val2 == null : (val2 == null ? false : val1.getId().equals((Object)val2.getId()));
    }

    public static String getSqlFromHashSet(Set set) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (set != null && set.size() > 0) {
            String[] keys = set.toArray(new String[set.size()]);
            for (int i = 0; i < keys.length; ++i) {
                sqlBuffer.append("'" + keys[i] + "'");
                if (i >= keys.length - 1) continue;
                sqlBuffer.append(",");
            }
        }
        return sqlBuffer.toString();
    }

    public static boolean containsAllIsNull(Object[] objs) {
        if (objs == null) {
            return true;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            return false;
        }
        return true;
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return;
        }
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public static IRowSet transJdbcRowSet(IRowSet jdbcRowSet) throws EASBizException, BOSException {
        DynamicRowSet drs = null;
        try {
            int i;
            ResultSetMetaData rsmd = jdbcRowSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            drs = new DynamicRowSet(colCount);
            String[] columnNameArray = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                int columnClz = rsmd.getColumnType(i + 1);
                String columnlbl = rsmd.getColumnLabel(i + 1);
                columnNameArray[i] = columnName;
                ColInfo ciId = new ColInfo(columnName, columnlbl, columnClz, null);
                drs.setColInfo(i + 1, ciId);
            }
            while (jdbcRowSet.next()) {
                drs.moveToInsertRow();
                for (i = 0; i < colCount; ++i) {
                    drs.updateObject(columnNameArray[i], jdbcRowSet.getObject(columnNameArray[i]));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    public static void dropTable(Context ctx, String table) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)table)) {
            return;
        }
        ITableManagerFacade tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        tbl.releaseTableName(table);
    }

    public static String gc() {
        Runtime runtime = Runtime.getRuntime();
        double d = (double)runtime.totalMemory() / 1048576.0;
        double d1 = (double)runtime.maxMemory() / 1048576.0;
        double d2 = (double)runtime.freeMemory() / 1048576.0;
        double d3 = d - d2;
        System.gc();
        System.gc();
        System.gc();
        Thread.yield();
        double d4 = (double)runtime.totalMemory() / 1048576.0;
        double d5 = (double)runtime.maxMemory() / 1048576.0;
        double d6 = (double)runtime.freeMemory() / 1048576.0;
        double d7 = d4 - d6;
        NumberFormat numberformat = NumberFormat.getNumberInstance();
        numberformat.setMaximumFractionDigits(3);
        StringBuffer sb = new StringBuffer(100);
        sb.append("Memory Usage in MegaBytes");
        sb.append("Before Garbage Collection:\n\tMaximum Allowable Memory Size:\t\t");
        sb.append(numberformat.format(d1));
        sb.append("\n");
        sb.append("\tMemory Allocated:\t\t\t");
        sb.append(numberformat.format(d));
        sb.append("\n");
        sb.append("\tMemory Used:\t\t\t\t");
        sb.append(numberformat.format(d3));
        sb.append("\n");
        sb.append("\tMemory Available:\t\t\t");
        sb.append(numberformat.format(d2));
        sb.append("\n");
        sb.append("\n");
        sb.append("After Garbage Collection:\n");
        sb.append("\tMaximum Allowable Memory Size:\t\t");
        sb.append(numberformat.format(d5));
        sb.append("\n");
        sb.append("\tMemory Allocated:\t\t\t");
        sb.append(numberformat.format(d4));
        sb.append("\n");
        sb.append("\tMemory Used:\t\t\t\t");
        sb.append(numberformat.format(d7));
        sb.append("\n");
        sb.append("\tMemory Available:\t\t\t");
        sb.append(numberformat.format(d6));
        return sb.toString();
    }

    public static void sortCollection(AbstractObjectCollection coll, String[] strArray, boolean asc) {
        VOComparetor comp = new VOComparetor(strArray, asc);
        Object[] infoArray = coll.toArray();
        Arrays.sort(infoArray, comp);
        coll.clear();
        for (int i = 0; i < infoArray.length; ++i) {
            coll.addObject((IObjectValue)infoArray[i]);
        }
    }

    public static void buildVO(IObjectValue info, String infoField, ResultSet rs, String dbField, Class linkClass, Map cache) throws SQLException {
        String id = rs.getString(dbField);
        IObjectValue linkObject = (IObjectValue)cache.get(id);
        if (linkObject == null) {
            try {
                linkObject = (IObjectValue)linkClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
            linkObject.setBOSUuid("id", BOSUuid.read((String)id));
            cache.put(id, linkObject);
        }
        info.put(infoField, (Object)linkObject);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
            BigDecimal new_o1 = (BigDecimal)o1;
            BigDecimal new_o2 = (BigDecimal)o2;
            if (new_o1.scale() < new_o2.scale()) {
                new_o1 = new_o1.setScale(new_o2.scale(), 4);
            } else if (new_o2.scale() < new_o1.scale()) {
                new_o2 = new_o2.setScale(new_o1.scale(), 4);
            }
            return new_o1.equals(new_o2);
        }
        if (IObjectValue.class.isInstance(o1) && IObjectValue.class.isInstance(o2)) {
            IObjectValue newo1 = (IObjectValue)o1;
            IObjectValue newo2 = (IObjectValue)o2;
            String pkfield = newo1.getPKField();
            return QMCommonUtils.equals(newo1.getBOSUuid(pkfield), newo2.getBOSUuid(pkfield));
        }
        if (o1.hashCode() != o2.hashCode()) {
            return false;
        }
        return o1.equals(o2);
    }

    public static Date getDate(String date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        try {
            return formatter.parse(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isEmpty(Object[] param) {
        return param == null || param.length == 0 || param[0] == null || param[0].toString().trim().length() == 0;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return o == null || o.toString().trim().length() == 0;
        }
        return o == null;
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(AbstractObjectCollection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(Constants.ZERO) == 0;
    }

    public static boolean isEmpty(CoreBaseInfo info) {
        return info == null || QMCommonUtils.isEmpty(info.getId());
    }

    public static Locale[] getAllLocale(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo solution = loader.getSolution();
        LanguageCollection lc = solution.getLanguages();
        Locale[] locales = new Locale[lc.size()];
        int n = lc.size();
        for (int i = 0; i < n; ++i) {
            locales[i] = lc.get(i).getLocale();
        }
        return locales;
    }

    static {
        EXCHANGERATE_DEFAULT = BIGDECIMAL_ONE = new BigDecimal("1.0");
    }
}

