/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util.backup;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.calc.express.IllegalParameterException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.qm.common.util.backup.FMClientHelper;
import com.kingdee.eas.qm.common.util.backup.FMConstants;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public final class QMHelper {
    private static final String STRING_ZERO = "0";
    private static final String STRING_ONE = "1";
    private static final String DATE_POSFIX = "}";
    private static final String DATE_PREFIX = "{";
    private static final String EMPTY_STRING = "";
    private static Logger logger = Logger.getLogger(QMHelper.class);
    public static final HashMap mapPrecOfCurrency = new HashMap(32);
    private static StringBuffer sb;
    public static char[] hex;
    private static UserInfo adminUser;

    public static void dropTable(Context ctx, String table) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)table)) {
            return;
        }
        ITableManagerFacade tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        tbl.releaseTableName(table);
    }

    public static boolean hasNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals(EMPTY_STRING)) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isEmpty(Object[] param) {
        return param == null || param.length == 0 || QMHelper.isEmpty(param[0]);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return o == null || o.toString().trim().length() == 0;
        }
        return o == null;
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(AbstractObjectCollection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(FMConstants.ZERO) == 0;
    }

    public static boolean isEmpty(CoreBaseInfo info) {
        return info == null || QMHelper.isEmpty(info.getId());
    }

    public static BOSUuid[] getIds(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        BOSUuid[] ids = new BOSUuid[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (BOSUuid)list.get(i);
        }
        return ids;
    }

    public static void buildVO(IObjectValue info, String infoField, ResultSet rs, String dbField, Class linkClass, Map cache) throws SQLException {
        String id = rs.getString(dbField);
        IObjectValue linkObject = (IObjectValue)cache.get(id);
        if (linkObject == null) {
            try {
                linkObject = (IObjectValue)linkClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
            linkObject.setBOSUuid("id", BOSUuid.read((String)id));
            cache.put(id, linkObject);
        }
        info.put(infoField, (Object)linkObject);
    }

    public static CompanyOrgUnitInfo getCompanyOrgByOrgUnit(OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        if (orgUnitInfo == null) {
            return null;
        }
        IOrgUnitCommon iOrgCommon = OrgUnitCommonFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = iOrgCommon.getCompany(orgUnitInfo.getId());
        return companyInfo;
    }

    public static boolean isGroupModel() throws EASBizException, BOSException {
        boolean result = false;
        HashMap<String, Object> hmApp = new HashMap<String, Object>();
        hmApp.put("G000", null);
        IParamControl pc = ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmApp);
        int is_Group_Right = 0;
        if (hmAllParam.get("G000") != null) {
            is_Group_Right = Integer.parseInt(hmAllParam.get("G000").toString());
        }
        if (is_Group_Right == 0) {
            result = true;
        } else if (is_Group_Right == 1) {
            result = false;
        }
        return result;
    }

    public static Object cloneInstance(Object coll) {
        try {
            return coll.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void initNumber(Context ctx, BillBaseInfo info, AbstractCoreBaseControllerBean controller) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!QMHelper.isEmpty(info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent;
            if (QMHelper.isEmpty(numberSilent = QMHelper.getNumberSilent(ctx, (CoreBaseInfo)info, info.getCompany().getId().toString()))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (controller.exists(ctx, filter = QMHelper.getCheckNumberDupFilter((IObjectValue)info, true)) && ++i < 10);
    }

    public static void initNumber(Context ctx, DataBaseInfo info, String companyId, AbstractCoreBaseControllerBean controller) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!QMHelper.isEmpty(info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent;
            if (QMHelper.isEmpty(numberSilent = QMHelper.getNumberSilent(ctx, (CoreBaseInfo)info, companyId))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (controller.exists(ctx, filter = QMHelper.getCheckNumberDupFilter((IObjectValue)info, true)) && ++i < 10);
    }

    public static FilterInfo getCheckNumberDupFilter(IObjectValue model, boolean isNeedComp) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)model.getString("number")));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }

    public static FilterInfo getCheckSeqDupFilter(IObjectValue model, boolean isNeedComp, String seqName) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo(seqName, (Object)model.getString(seqName)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }

    public static String getNumberSilent(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || companyId == null || companyId.equals(EMPTY_STRING)) {
            return null;
        }
        String result = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        result = codingRuleManager.getNumber((IObjectValue)info, companyId);
        return result;
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals(EMPTY_STRING)) {
            return;
        }
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public static Map populateMap(ResultSet rs, String[] valueskey, String[] keys) throws SQLException {
        HashMap<String, Object[]> cache = new HashMap<String, Object[]>();
        rs.beforeFirst();
        while (rs.next()) {
            StringBuffer key = new StringBuffer();
            for (int j = 0; j < keys.length; ++j) {
                key.append(rs.getString(keys[j]));
            }
            Object[] values = new Object[valueskey.length];
            for (int j = 0; j < valueskey.length; ++j) {
                values[j] = rs.getObject(valueskey[j]);
            }
            cache.put(key.toString(), values);
        }
        return cache;
    }

    public static int dateCompare(Date theDate, Date anotherDate) {
        DateFormat df = FMConstants.getFormatDay();
        try {
            theDate = df.parse(df.format(theDate));
            anotherDate = df.parse(df.format(anotherDate));
            long thisTime = theDate.getTime();
            long anotherTime = anotherDate.getTime();
            return thisTime < anotherTime ? -1 : (thisTime == anotherTime ? 0 : 1);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            return 0;
        }
    }

    public static int[] splitString(String line, String seperator) {
        String trim;
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new int[0];
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            trim = line.substring(i, j).trim();
            if (QMHelper.isInt(trim)) {
                v.addElement(trim);
            }
            i = j + seperator.length();
        }
        trim = line.substring(i).trim();
        if (QMHelper.isInt(trim)) {
            v.addElement(trim);
        }
        int[] ps = QMHelper.copyAry(v);
        return ps;
    }

    private static boolean isInt(String trim) {
        boolean isOK = true;
        try {
            Integer.parseInt(trim);
        }
        catch (Exception e) {
            isOK = false;
        }
        return isOK;
    }

    private static int[] copyAry(Vector v) {
        int size = v.size();
        int[] ps = new int[size];
        if (size > 0) {
            for (int idx = 0; idx < size; ++idx) {
                ps[idx] = Integer.parseInt((String)v.get(idx));
            }
        }
        return ps;
    }

    public static Date getLastEndDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - 1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static OrgUnitInfo getGroupOrg(Context ctx) {
        OrgUnitInfo groupOrg = null;
        try {
            groupOrg = NewOrgUnitHelper.getRootCU((Context)ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return groupOrg;
    }

    public static String formateDate(Date date) {
        String format = FMConstants.getFormatDay().format(date);
        return DATE_PREFIX + format + DATE_POSFIX;
    }

    public static BigDecimal checkBigDecimal(BigDecimal big) {
        return big == null ? FMConstants.ZERO : big;
    }

    public static BigDecimal checkBigDecimal(BigDecimal big, int scale) {
        if (big == null) {
            return FMConstants.ZERO;
        }
        return big.setScale(scale, 4);
    }

    public static BigDecimal checkAbsBigDecimal(BigDecimal big, int scale) {
        return big == null ? FMConstants.ZERO : QMHelper.checkBigDecimal(big.abs(), scale);
    }

    public static IObjectValue seekObjectInfo(IObjectCollection iObjCol, IObjectValue info, String[] keys) {
        IObjectValue iObjVal = null;
        Object objVal = null;
        Object objHash = null;
        for (int i = 0; i < iObjCol.size(); ++i) {
            iObjVal = iObjCol.getObject(i);
            boolean isFound = true;
            for (int j = 0; j < keys.length; ++j) {
                String strKey = keys[j];
                objVal = iObjVal.get(strKey);
                if (EqualsUtil.equals((Object)objVal, (Object)(objHash = info.get(strKey)))) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            return iObjVal;
        }
        return null;
    }

    public static boolean isEmptyScript(String script) {
        return script == null || script.trim().length() == 0 || script.charAt(0) == '=' || script.equals("null");
    }

    public static Set asSet(String[] ids) {
        if (QMHelper.isEmpty(ids)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        return set;
    }

    public static Set asSet(String id) {
        if (QMHelper.isEmpty(id)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(1);
        set.add(id);
        return set;
    }

    public static String[] mergeArray(String[] array1, String[] array2) {
        String[] newArray = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static void sumAttribute(IObjectValue sumInfo, IObjectValue info, String[] sumAttrs) {
        for (int i = 0; i < sumAttrs.length; ++i) {
            String attr = sumAttrs[i];
            BigDecimal sumValue = sumInfo.getBigDecimal(attr) == null ? FMConstants.ZERO : sumInfo.getBigDecimal(attr);
            BigDecimal value = info.getBigDecimal(attr) == null ? FMConstants.ZERO : info.getBigDecimal(attr);
            sumInfo.setBigDecimal(attr, sumValue.add(value));
        }
    }

    public static void transferAttribute(IObjectValue sumInfo, IObjectValue info, String[] dims) {
        for (int i = 0; i < dims.length; ++i) {
            sumInfo.put(dims[i], info.get(dims[i]));
        }
    }

    public static boolean equalAttribute(IObjectValue info1, IObjectValue info2, String[][] compareAttrs) {
        for (int i = 0; i < compareAttrs.length; ++i) {
            if (EqualsUtil.equals((Object)info1.get(compareAttrs[i][0]), (Object)info2.get(compareAttrs[i][1]))) continue;
            return false;
        }
        return true;
    }

    public static IMetaDataPK getActionPK(ItemAction action) {
        if (action == null) {
            return null;
        }
        String actoinName = action.getClass().getName();
        if (actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        return new MetaDataPK(actoinName);
    }

    public static String getCUId(Context ctx, String strCompanyId) throws BOSException, EASBizException {
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strCompanyId));
        String strCUId = comInfo.getCU().getId().toString();
        return strCUId;
    }

    public static String getAccountTabled(Context ctx, String strCompanyId) throws BOSException, EASBizException {
        if (QMHelper.isEmpty(strCompanyId)) {
            return null;
        }
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strCompanyId));
        String strAccountTableId = comInfo.getAccountTable().getId().toString();
        return strAccountTableId;
    }

    public static void setAccountViewF7(KDBizPromptBox prmtAccoutView, Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        EntityViewInfo info = QMHelper.getAccountViewEvi(companyId, currencyId, viewInfo);
        prmtAccoutView.setEntityViewInfo(info);
    }

    public static EntityViewInfo getAccountViewEvi(String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        Set set = QMHelper.getAcctViewIdSet(companyId, currencyId, viewInfo);
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (set == null || set.size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        }
        info.setFilter(filter);
        return info;
    }

    public static Set getAcctViewIdSet(String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        AccountViewCollection acctViewColl = QMHelper.getAccountViewCollection(null, companyId, currencyId, viewInfo);
        if (acctViewColl == null) {
            return null;
        }
        int size = acctViewColl.size();
        AccountViewInfo acctViewInfo = null;
        for (int i = 0; i < size; ++i) {
            acctViewInfo = acctViewColl.get(i);
            set.add(acctViewInfo.getId().toString());
        }
        return set;
    }

    public static Set getAcctViewIdSet(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        AccountViewCollection acctViewColl = QMHelper.getAccountViewCollection(ctx, companyId, currencyId, viewInfo);
        if (acctViewColl == null) {
            return null;
        }
        int size = acctViewColl.size();
        AccountViewInfo acctViewInfo = null;
        for (int i = 0; i < size; ++i) {
            acctViewInfo = acctViewColl.get(i);
            set.add(acctViewInfo.getId().toString());
        }
        return set;
    }

    public static AccountViewCollection getAccountViewCollection(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        if (QMHelper.isEmpty(companyId)) {
            throw new BOSException((Throwable)new IllegalParameterException("company is null"));
        }
        EntityViewInfo view = viewInfo;
        if (viewInfo == null) {
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("isLeaf", (Object)FMConstants.TRUE));
            items.add(new FilterItemInfo("isGFreeze", (Object)FMConstants.FALSE));
            items.add(new FilterItemInfo("isCFreeze", (Object)FMConstants.FALSE));
        }
        return QMHelper.getAccountViewCollectionWithDataPermission(ctx, companyId, currencyId, view);
    }

    public static AccountViewCollection getAccountViewCollectionWithDataPermission(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo comInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String strCUId = comInfo.getId().toString();
        String acctTableId = null;
        if (comInfo.getAccountTable() != null) {
            acctTableId = comInfo.getAccountTable().getId().toString();
        }
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance((Context)ctx) : AccountViewFactory.getRemoteInstance();
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)strCUId));
        if (acctTableId != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTableId));
        }
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        AccountViewCollection acctViewCol = iAccountView.getAccountViewCollection(viewInfo);
        if (acctViewCol == null || acctViewCol.size() == 0) {
            return null;
        }
        if (currencyId == null) {
            return acctViewCol;
        }
        IContextHelper iContextHelper = null;
        iContextHelper = ctx != null ? ContextHelperFactory.getLocalInstance((Context)ctx) : ContextHelperFactory.getRemoteInstance();
        CurrencyInfo baseCy = iContextHelper.getCompanyBaseCurrency(comInfo);
        String localCurrencyId = EMPTY_STRING;
        if (baseCy != null) {
            localCurrencyId = baseCy.getId().toString();
        }
        if (localCurrencyId.length() == 0) {
            return acctViewCol;
        }
        AccountViewCollection retColl = new AccountViewCollection();
        AccountCurrencyCollection acctCurColl = null;
        int size = acctViewCol.size();
        block5: for (int i = 0; i < size; ++i) {
            AccountViewInfo acctInfo = acctViewCol.get(i);
            switch (acctInfo.getAccountingcurrency().getValue()) {
                case 2: {
                    retColl.add(acctInfo);
                }
                case 0: {
                    if (localCurrencyId.equals(currencyId)) {
                        retColl.add(acctInfo);
                    }
                }
                case 1: {
                    acctCurColl = acctInfo.getAccountCurrency();
                    for (int j = 0; j < acctCurColl.size(); ++j) {
                        if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                        retColl.add(acctInfo);
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        return retColl;
    }

    public static String getKeyString(IObjectValue iter, String[] keys) {
        StringBuffer sb = new StringBuffer(keys.length * 10);
        for (int i = 0; i < keys.length; ++i) {
            Object val = iter.get(keys[i]);
            sb.append("_");
            if (val == null) {
                sb.append("null");
                continue;
            }
            if (val instanceof IObjectValue) {
                IObjectValue new_val = (IObjectValue)val;
                Object pk = new_val.get("id");
                if (pk == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(pk);
                continue;
            }
            if (val instanceof BigDecimal) {
                NumberFormat fmt = BOSLocaleUtil.getDecimalFormat();
                sb.append(fmt.format(val));
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public static String gc() {
        Runtime runtime = Runtime.getRuntime();
        double d = (double)runtime.totalMemory() / 1048576.0;
        double d1 = (double)runtime.maxMemory() / 1048576.0;
        double d2 = (double)runtime.freeMemory() / 1048576.0;
        double d3 = d - d2;
        System.gc();
        System.gc();
        System.gc();
        Thread.yield();
        double d4 = (double)runtime.totalMemory() / 1048576.0;
        double d5 = (double)runtime.maxMemory() / 1048576.0;
        double d6 = (double)runtime.freeMemory() / 1048576.0;
        double d7 = d4 - d6;
        NumberFormat numberformat = NumberFormat.getNumberInstance();
        numberformat.setMaximumFractionDigits(3);
        StringBuffer sb = new StringBuffer(100);
        sb.append("Memory Usage in MegaBytes");
        sb.append("Before Garbage Collection:\n\tMaximum Allowable Memory Size:\t\t");
        sb.append(numberformat.format(d1));
        sb.append("\n");
        sb.append("\tMemory Allocated:\t\t\t");
        sb.append(numberformat.format(d));
        sb.append("\n");
        sb.append("\tMemory Used:\t\t\t\t");
        sb.append(numberformat.format(d3));
        sb.append("\n");
        sb.append("\tMemory Available:\t\t\t");
        sb.append(numberformat.format(d2));
        sb.append("\n");
        sb.append("\n");
        sb.append("After Garbage Collection:\n");
        sb.append("\tMaximum Allowable Memory Size:\t\t");
        sb.append(numberformat.format(d5));
        sb.append("\n");
        sb.append("\tMemory Allocated:\t\t\t");
        sb.append(numberformat.format(d4));
        sb.append("\n");
        sb.append("\tMemory Used:\t\t\t\t");
        sb.append(numberformat.format(d7));
        sb.append("\n");
        sb.append("\tMemory Available:\t\t\t");
        sb.append(numberformat.format(d6));
        return sb.toString();
    }

    public static String formatMessage(Context ctx, String resPath, String resName, Object[] args) {
        if (resPath == null || resName == null) {
            throw new IllegalArgumentException("resPath or resName is nul!");
        }
        String str = null;
        str = ctx != null ? ResourceBase.getString((String)resPath, (String)resName, (Locale)ctx.getLocale()) : EASResource.getString((String)resPath, (String)resName);
        if (args == null || args.length == 0) {
            return str;
        }
        return MessageFormat.format(str, args);
    }

    public static PreparedStatement createState(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement state = conn.prepareStatement(sql);
        if (params == null) {
            return state;
        }
        for (int i = 0; i < params.length; ++i) {
            Object object = params[i];
            state.setObject(i + 1, object);
        }
        return state;
    }

    public static BigDecimal max(BigDecimal a, BigDecimal b) {
        if (a.compareTo(b) >= 0) {
            return a;
        }
        return b;
    }

    public static BigDecimal min(BigDecimal a, BigDecimal b) {
        if (a.compareTo(b) >= 0) {
            return b;
        }
        return a;
    }

    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        if (a == null) {
            a = FMConstants.ZERO;
        }
        if (b == null) {
            b = FMConstants.ZERO;
        }
        return a.add(b);
    }

    public static BigDecimal subtract(BigDecimal a, BigDecimal b) {
        if (a == null) {
            a = FMConstants.ZERO;
        }
        if (b == null) {
            b = FMConstants.ZERO;
        }
        return a.subtract(b);
    }

    public static boolean isExistMultiBankAcct(Context ctx, String companyId, String accountId) throws BOSException {
        if (ctx == null) {
            return QMHelper.isExistMultiBankAcct(companyId, accountId);
        }
        String strSql = "select count(FID) as counts from T_BD_AccountBanks where FCompanyID=? AND FAccountID =?";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int counts = 0;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.prepareStatement(strSql.toString());
            stmt.setString(1, companyId);
            stmt.setString(2, accountId);
            rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                counts = rs.getInt("counts");
            }
        }
        catch (SQLException sql) {
            try {
                throw new BOSException((Throwable)sql);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return counts > 1;
    }

    public static boolean isExistMultiBankAcct(String companyId, String accountId) throws BOSException {
        StringBuffer strBuffer = new StringBuffer("select count(FID) as counts from T_BD_AccountBanks where FCompanyID='");
        strBuffer.append(companyId);
        strBuffer.append("' AND FAccountID ='");
        strBuffer.append(accountId);
        strBuffer.append("'");
        IRowSet rs = null;
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)strBuffer.toString());
        int counts = 0;
        try {
            rs = sqlExe.executeSQL();
            if (rs != null && rs.next()) {
                counts = rs.getInt("counts");
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return counts > 1;
    }

    public static Set asSet(int[] args) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (args == null || args.length == 0) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            set.add(new Integer(args[i]));
        }
        return set;
    }

    public static BigDecimal getBigDecimal(Object obj) {
        BigDecimal value = null;
        if (obj == null) {
            return SysConstant.BIGZERO;
        }
        String s = obj.toString();
        if (s == null || s.trim().length() == 0) {
            value = SysConstant.BIGZERO;
            return value;
        }
        if (obj instanceof BigDecimal) {
            value = (BigDecimal)obj;
        } else if (FMClientHelper.verifyIsNumber(s)) {
            value = new BigDecimal(s);
        } else {
            throw new IllegalArgumentException("object is not BigDecimal type!");
        }
        return value;
    }

    public static BigDecimal getBigDecimalNULL(BigDecimal value) {
        if (value == null || value.signum() == 0) {
            return null;
        }
        return value;
    }

    public static String getNextNumber(String number) {
        int i;
        if (QMHelper.isEmpty(number)) {
            return null;
        }
        for (i = number.length() - 1; i >= 0 && number.charAt(i) <= '9' && number.charAt(i) >= '0'; --i) {
        }
        String substring = number.substring(i + 1);
        if (QMHelper.isEmpty(substring)) {
            return null;
        }
        try {
            BigDecimal j = new BigDecimal(substring).add(FMConstants.ONE);
            return number.substring(0, i + 1) + QMHelper.fixNumber(j, number.length() - i - 1);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getNextNumber(String number, char sp) {
        int i;
        if (QMHelper.isEmpty(number)) {
            return null;
        }
        for (i = number.length() - 1; i >= 0 && number.charAt(i) <= '9' && number.charAt(i) >= '0'; --i) {
        }
        char prefix = number.charAt(i);
        if (prefix != sp) {
            return number + sp + 1;
        }
        String substring = number.substring(i + 1);
        if (QMHelper.isEmpty(substring)) {
            return null;
        }
        try {
            BigDecimal j = new BigDecimal(substring).add(FMConstants.ONE);
            return number.substring(0, i + 1) + QMHelper.fixNumber(j, number.length() - i - 1);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fixNumber(BigDecimal n, int len) {
        int i;
        char[] b = new char[len];
        String toString = n.toString();
        int k = len - toString.length();
        for (i = 0; i < k; ++i) {
            b[i] = 48;
        }
        while (i < len) {
            b[i] = toString.charAt(i - k);
            ++i;
        }
        return new String(b);
    }

    public static String quotedString(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] testValue = new String[]{"9999999999999999999999.9999", "9,999,999,999,999,999,999,999.9999", "999999999,9999,99999,99,99.9999", "99,9999,99999,99,99.9999", null, EMPTY_STRING};
        for (int j = 0; j < testValue.length; ++j) {
            BigDecimal number = QMHelper.parseBigDecimal(testValue[j]);
            logger.debug((Object)((Object)number).toString());
        }
    }

    public static String buildIn(String name, Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        int size = set.length;
        int num = size / 800;
        int j = 0;
        sb.append("(");
        for (int i = 0; i < num; ++i) {
            sb.append(" ");
            sb.append(name);
            sb.append(" ");
            sb.append(" in (");
            QMHelper.appendStrValue(sb, set[j]);
            ++j;
            while (j < (i + 1) * 800) {
                sb.append(",");
                QMHelper.appendStrValue(sb, set[j]);
                ++j;
            }
            sb.append(")\n ");
            sb.append(" or ");
        }
        if (j == size) {
            sb.append("1=1");
            sb.append(" )");
            return sb.toString();
        }
        sb.append(" " + name + " ");
        sb.append(" in (");
        QMHelper.appendStrValue(sb, set[j]);
        ++j;
        while (j < size) {
            sb.append(",");
            QMHelper.appendStrValue(sb, set[j]);
            ++j;
        }
        sb.append(")");
        sb.append(")");
        return sb.toString();
    }

    private static void appendStrValue(StringBuffer sb, Object object) {
        if (object instanceof Integer) {
            sb.append(object);
        } else {
            sb.append("'");
            sb.append(object);
            sb.append("'");
        }
    }

    public static void copyModelOfKDTable(KDTable srcTable, KDTable destTable) {
        int rowCount = srcTable.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            destTable.addRow(i, srcTable.getRow(i));
        }
    }

    public static void copyModelWithUserObjOfKDTable(KDTable srcTable, KDTable destTable) {
        int rowCount = srcTable.getRowCount3();
        int colCount = srcTable.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                ICell destCell = destTable.getCell(i, j);
                ICell srcCell = srcTable.getCell(i, j);
                destCell.setValue(srcCell.getValue());
                if (srcCell.getUserObject() == null) continue;
                destCell.setUserObject(srcCell.getUserObject());
            }
        }
    }

    public static void copyTable(KDTable srcTable, KDTable destTable, boolean includeUserObject) {
        if (srcTable == null || destTable == null) {
            return;
        }
        FMClientHelper.clearTable(destTable);
        int colCount = srcTable.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            destTable.addColumn(i, srcTable.getColumn(i));
        }
        int headRowCount = srcTable.getHeadRowCount();
        for (int i = 0; i < headRowCount; ++i) {
            destTable.addHeadRow(i, srcTable.getHeadRow(i));
        }
        if (includeUserObject) {
            QMHelper.copyModelWithUserObjOfKDTable(srcTable, destTable);
        } else {
            QMHelper.copyModelOfKDTable(srcTable, destTable);
        }
    }

    public static String getConnectionInfo(Connection conn) throws BOSException {
        StringBuffer sb = new StringBuffer();
        try {
            Field[] filds = conn.getClass().getDeclaredFields();
            HashSet<Object> objectSet = new HashSet<Object>();
            for (int i = 0; i < filds.length; ++i) {
                Field f1 = filds[i];
                Object o1 = QMHelper.getSafeValue(conn, f1);
                if (o1 == null) continue;
                if (o1 instanceof String) {
                    sb.append(f1.getName() + ":" + o1);
                    sb.append("\n");
                    continue;
                }
                Field[] f1s = o1.getClass().getDeclaredFields();
                for (int j = 0; j < f1s.length; ++j) {
                    Field f2 = f1s[j];
                    Object o2 = QMHelper.getSafeValue(o1, f2);
                    if (o2 == null || objectSet.contains(o2)) continue;
                    objectSet.add(o2);
                    if (o2 instanceof String) {
                        sb.append(f2.getName() + ":" + o2);
                        sb.append("\n");
                        continue;
                    }
                    Field[] f2s = o2.getClass().getDeclaredFields();
                    for (int k = 0; k < f2s.length; ++k) {
                        Field f3 = f2s[k];
                        Object o3 = QMHelper.getSafeValue(o2, f3);
                        if (o3 == null || objectSet.contains(o3)) continue;
                        objectSet.add(o3);
                        if (o3 instanceof String) {
                            sb.append(f2.getName() + ":" + o2);
                            sb.append("\n");
                            continue;
                        }
                        Field[] f3s = o3.getClass().getDeclaredFields();
                        for (int l = 0; l < f3s.length; ++l) {
                            Field f4 = f3s[l];
                            Object o4 = QMHelper.getSafeValue(o3, f4);
                            if (o4 == null || objectSet.contains(o4)) continue;
                            objectSet.add(o4);
                            if (o4 instanceof String) {
                                sb.append(f3.getName() + ":" + o3);
                                sb.append("\n");
                                continue;
                            }
                            sb.append(f3.getName() + ":" + o3);
                            sb.append("\n");
                        }
                    }
                }
                sb.append("\n");
            }
            sb.append("\nURL: " + conn.getMetaData().getURL());
            sb.append("\nUSER: " + conn.getMetaData().getUserName());
            sb.append("\nUSER: " + ((Object)objectSet).toString());
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sb.toString();
    }

    private static Object getSafeValue(Object o2, Field f3) {
        f3.setAccessible(true);
        Object o3 = null;
        try {
            o3 = f3.get(o2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o3;
    }

    public static String getAdjustMsg(String msg) {
        if (msg != null && msg.length() > 2000) {
            msg = msg.substring(0, 2000) + "...";
        }
        return msg;
    }

    public static String gen_Menuitem(Context ctx, String s) throws BOSException {
        ResultSet rs;
        FMQuerySqlBuilder sb;
        if (QMHelper.isEmpty(s)) {
            return null;
        }
        Object[] ar = s.split(",");
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = ar[i].trim().replaceAll("\"", EMPTY_STRING);
            ar[i] = ar[i].trim().replaceAll("'", EMPTY_STRING);
        }
        StringBuffer rsValue = new StringBuffer();
        try {
            sb = new FMQuerySqlBuilder();
            sb.appendSql("select * from  t_bas_sysmenuitem where fnumber in (");
            sb.appendParam(ar);
            sb.appendSql(")");
            rs = sb.exeQuery(ctx);
            while (rs.next()) {
                rsValue.append("delete from t_bas_sysmenuitem where fid='" + rs.getString("fid") + "';\n");
            }
            rs.beforeFirst();
            rsValue.append(QMHelper.genInsertSql("t_bas_sysmenuitem", rs));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            sb = new FMQuerySqlBuilder();
            sb.appendSql("select * from  t_pm_mainmenuitem where fnumber in (");
            sb.appendParam(ar);
            sb.appendSql(")");
            rs = sb.exeQuery(ctx);
            while (rs.next()) {
                rsValue.append("delete from t_pm_mainmenuitem where fid='" + rs.getString("fid") + "';\n");
            }
            rs.beforeFirst();
            rsValue.append(QMHelper.genInsertSql("t_pm_mainmenuitem", rs));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rsValue.toString();
    }

    public static String gen_InsertScript(Context ctx, String string) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String rstValue = null;
        ResultSet rs = null;
        try {
            int e;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(string);
            rs = stmt.executeQuery();
            String from = "from";
            String lc = string.toLowerCase();
            int s = lc.indexOf(from);
            String tableName = null;
            if (s > 0 && (e = lc.indexOf(" ", s = from.length() + s + 1)) > 0) {
                tableName = lc.substring(s, e).trim();
            }
            rstValue = QMHelper.genInsertSql(tableName, rs);
        }
        catch (SQLException exp) {
            try {
                throw new BOSException((Throwable)exp);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return rstValue;
    }

    private static List getPid(Context ctx, String menuName) throws BOSException {
        ArrayList menus = new ArrayList();
        HashMap<String, String> hm = null;
        String sql = " select df.fname_l1,df.fname_l2,df.fuiclassname,df.FdisplayName_l2,length(df.FdisplayName_l2) seq  from T_PM_MainMenuItem df where fname_l2 like '%" + menuName + "%' order by seq";
        ResultSet rs = null;
        Connection con = null;
        Statement createStatement = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            createStatement = con.createStatement();
            rs = createStatement.executeQuery(sql);
            while (rs.next()) {
                hm = new HashMap<String, String>();
                hm.put("name", rs.getString(2));
                hm.put("ui", rs.getString(3));
                hm.put("path", rs.getString(4));
                menus.add(hm);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)createStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)createStatement, (Connection)con);
        return menus;
    }

    public static Object findMenuPath(Context ctx, String menu) throws BOSException {
        String path = EMPTY_STRING;
        sb = new StringBuffer();
        List menus = QMHelper.getPid(ctx, menu);
        Map hm = null;
        String node = EMPTY_STRING;
        String pathSingle = EMPTY_STRING;
        String menuName = EMPTY_STRING;
        String menuUI = EMPTY_STRING;
        for (int i = 0; i < menus.size(); ++i) {
            hm = (Map)menus.get(i);
            pathSingle = (String)hm.get("path");
            menuName = (String)hm.get("name");
            menuUI = (String)hm.get("ui");
            String[] nodes = pathSingle.split("_");
            for (int j = 0; j < nodes.length; ++j) {
                node = nodes[j];
                path = !menuName.equals(node) ? path + node : (menuUI != null ? path + node + "(" + menuUI + ")" : path + node);
                if (j == nodes.length - 1) continue;
                path = path + "--->>";
            }
            path = path + "\r\n";
        }
        return path;
    }

    private static String genInsertSql(String tableName, ResultSet rs) throws SQLException {
        int i;
        if (rs == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer headSb = new StringBuffer();
        ResultSetMetaData mddata = rs.getMetaData();
        if (QMHelper.isEmpty(tableName)) {
            tableName = "T_Temp_Table";
        }
        headSb.append("insert into ");
        headSb.append(tableName);
        headSb.append("(");
        for (i = 1; i <= mddata.getColumnCount(); ++i) {
            if (i > 1) {
                headSb.append(", ");
            }
            headSb.append(mddata.getColumnName(i));
        }
        headSb.append(")");
        headSb.append("\n");
        headSb.append(" values \n");
        headSb.append("(");
        while (rs.next()) {
            sb.append("\n");
            sb.append(headSb.toString());
            for (i = 1; i <= mddata.getColumnCount(); ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(QMHelper.getRowValue(rs, i, mddata.getColumnType(i), mddata.getColumnTypeName(i)));
            }
            sb.append(")");
            sb.append(";\n");
        }
        return sb.toString();
    }

    private static Object getRowValue(ResultSet rs, int i, int type, String dispTypeName) throws SQLException {
        Object o = rs.getObject(i);
        if (o == null) {
            return "null";
        }
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return o.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                if (o.toString().trim().length() == 44 || o.toString().trim().length() == 28) {
                    return "'" + rs.getString(i) + "'";
                }
                return "N'" + rs.getString(i) + "'";
            }
            case 16: {
                return o.toString();
            }
            case 91: {
                return "{d'" + FMConstants.getFormatDay().format(o) + "'}";
            }
            case 92: 
            case 93: {
                return "{ts'" + FMConstants.getFormatTime().format(o) + "'}";
            }
            case 0: {
                return null;
            }
            case 1111: {
                return "'" + rs.getString(i) + "'";
            }
        }
        return "'" + rs.getString(i) + "'";
    }

    public static int getPrecOfCurrency(Context ctx, String currencyId) {
        if (mapPrecOfCurrency.size() == 0) {
            QMHelper.setPrecOfCurrenty(ctx, mapPrecOfCurrency);
        }
        if (!mapPrecOfCurrency.containsKey(currencyId)) {
            return 10;
        }
        return (Integer)mapPrecOfCurrency.get(currencyId);
    }

    private static void setPrecOfCurrenty(Context ctx, Map map) {
        String sql = "select fid,fprecision from t_bd_currency";
        ISQLExecutor sqlExe = null;
        sqlExe = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        try {
            IRowSet rs = sqlExe.executeSQL();
            while (rs.next()) {
                map.put(rs.getString(1), new Integer(rs.getInt(2)));
            }
        }
        catch (BOSException bose) {
            logger.error((Object)bose);
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
        }
    }

    public static CurrencyInfo getBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
        return currency;
    }

    public static BOSException toBOSException(Throwable e) {
        BOSException be = new BOSException(e);
        be.setStackTrace(e.getStackTrace());
        return be;
    }

    public static Set getSrcBillIdCollBySrcId(Context ctx, String srcBillId) throws BTPException, BOSException {
        Set destBillIdSet = QMHelper.getDestBillIdSet(ctx, srcBillId);
        return QMHelper.getSrcBillIdSet(ctx, destBillIdSet);
    }

    public static Map getDestBillIDSet(Context ctx, Set srcBillIDSet) throws BTPException, BOSException {
        IBOTRelation iBTPRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("relationEntries.*"));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcBillIDSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        BOTRelationCollection botRc = iBTPRelation.getCollection(viewInfo);
        int size = botRc.size();
        BOTRelationInfo botR = null;
        HashMap hm = new HashMap();
        for (int i = 0; i < size; ++i) {
            botR = botRc.get(i);
            if (hm.get(botR.getSrcObjectID()) == null) {
                HashSet<String> destIDSet = new HashSet<String>();
                destIDSet.add(botR.getDestObjectID());
                hm.put(botR.getSrcObjectID(), destIDSet);
                continue;
            }
            ((Set)hm.get(botR.getSrcObjectID())).add(botR.getDestObjectID());
        }
        return hm;
    }

    public static Set getDestBillIdSet(Context ctx, String srcBillId) throws BTPException, BOSException {
        IBTPManager iBTPManager = null;
        iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relateColl = iBTPManager.getDestRelation(srcBillId);
        HashSet<String> idSet = new HashSet<String>();
        if (relateColl == null || relateColl.size() < 1) {
            return idSet;
        }
        int size = relateColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(relateColl.get(i).getDestObjectID());
        }
        return idSet;
    }

    private static Set getSrcBillIdSet(Context ctx, Set destBillIdSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destBillIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        IBOTRelation iBOTRelation = null;
        iBOTRelation = ctx != null ? BOTRelationFactory.getLocalInstance((Context)ctx) : BOTRelationFactory.getRemoteInstance();
        BOTRelationCollection relateColl = iBOTRelation.getCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        int size = relateColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(relateColl.get(i).getSrcObjectID());
        }
        return idSet;
    }

    public static Set getSrcBillIdSet(Context ctx, String destBillId) throws BOSException {
        HashSet<String> destBillIdSet = new HashSet<String>();
        destBillIdSet.add(destBillId);
        return QMHelper.getSrcBillIdSet(ctx, destBillIdSet);
    }

    public static BigDecimal getLocalAmount(BigDecimal bdAmount, BigDecimal bdLocalExRate) {
        if (bdAmount == null) {
            return FMConstants.ZERO;
        }
        if (bdLocalExRate == null) {
            return FMConstants.ZERO;
        }
        return bdAmount.multiply(bdLocalExRate);
    }

    public static List set2List(Set set) {
        if (set == null) {
            return new ArrayList();
        }
        return new ArrayList(set);
    }

    public static Set list2Set(List list) {
        if (list == null || list.size() < 1) {
            return new HashSet();
        }
        return new HashSet(list);
    }

    public static String setTran2String(Set idSet) {
        if (idSet == null || idSet.size() < 1) {
            return "('')";
        }
        String ids = null;
        Iterator iter = idSet.iterator();
        for (int i = 0; iter.hasNext() && i < 999; ++i) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
        }
        ids = ids + ")";
        return ids;
    }

    public static String coll2String(Collection idColl) {
        if (idColl == null || idColl.size() < 1) {
            return null;
        }
        String ids = null;
        Iterator iter = idColl.iterator();
        for (int i = 0; iter.hasNext() && i < 999; ++i) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
        }
        ids = ids + ")";
        return ids;
    }

    public static String coll2String(IObjectCollection coll) {
        if (coll == null || coll.size() < 1) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        Iterator it = coll.iterator();
        for (int i = 0; it.hasNext() && i < 999; ++i) {
            if (i == 0) {
                sql.append("('");
                sql.append(((CoreBaseInfo)it.next()).getId().toString());
                sql.append("'");
                continue;
            }
            sql.append(",'");
            sql.append(((CoreBaseInfo)it.next()).getId().toString());
            sql.append("'");
        }
        sql.append(")");
        return sql.toString();
    }

    public static String Array2String(String[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        String ids = null;
        int len = array.length;
        for (int i = 0; i < len && i < 999; ++i) {
            ids = ids == null ? "('" + array[i] + "'" : ids + ", '" + array[i] + "'";
        }
        ids = ids + ")";
        return ids;
    }

    public static Set Array2Set(String[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(array[i]);
        }
        return idSet;
    }

    public static void objectWrite(Object obj, String key) {
        try {
            logger.debug((Object)("write object " + key));
            FileOutputStream objfile = new FileOutputStream(key);
            ObjectOutputStream p = new ObjectOutputStream(objfile);
            p.writeObject(obj);
            p.flush();
            objfile.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static Object objectRead(String key) {
        Object obj = null;
        try {
            logger.info((Object)("read object " + key));
            FileInputStream objfile = new FileInputStream(key);
            ObjectInputStream p = new ObjectInputStream(objfile);
            obj = p.readObject();
            objfile.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return obj;
    }

    public static String getString(String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)QMHelper.getLocale());
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return new Locale("L2");
        }
    }

    public static IRowSet getSortRowSet(IRowSet rs, List lstSort, String key) throws SQLException, IllegalArgumentException {
        JdbcRowSet tempRs = new JdbcRowSet();
        if (rs.size() == 0) {
            return tempRs;
        }
        QMHelper.existKey(rs, key);
        for (Object compareObj : lstSort) {
            rs.first();
            do {
                Object rsObj;
                if (!(rsObj = rs.getObject(key)).equals(compareObj)) continue;
                rs.previous();
                tempRs.populate((ResultSet)rs, 0, 1, true);
            } while (rs.next());
        }
        rs.first();
        do {
            boolean bExist = false;
            Object rsObj = rs.getObject(key);
            for (Object compareObj : lstSort) {
                if (!rsObj.equals(compareObj)) continue;
                bExist = true;
                break;
            }
            if (bExist) continue;
            rs.previous();
            tempRs.populate((ResultSet)rs, 0, 1, true);
        } while (rs.next());
        return tempRs;
    }

    private static void existKey(IRowSet rs, String key) throws SQLException {
        boolean existkey = false;
        for (int i = 1; i < rs.getMetaData().getColumnCount() + 1; ++i) {
            if (!rs.getMetaData().getColumnName(i).toString().equalsIgnoreCase(key)) continue;
            existkey = true;
            break;
        }
        if (!existkey) {
            throw new IllegalArgumentException("key is not exist!");
        }
    }

    public static Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array == null) {
            return null;
        }
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public static EntityViewInfo getIncludeEntityView(String key, String[] array) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(key, (Object)QMHelper.getSetByArray(array), CompareType.INCLUDE));
        return view;
    }

    public static BigDecimal roundBigDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        NumberFormat df = BOSLocaleUtil.getDecimalFormat();
        return new BigDecimal(df.format(value.doubleValue()));
    }

    public static void roundRowSetBigDecimal(IRowSet rs, String[] cols) throws SQLException {
        while (rs.next()) {
            int n = cols.length;
            for (int i = 0; i < n; ++i) {
                BigDecimal roundedValue = QMHelper.roundBigDecimal(rs.getBigDecimal(cols[i]));
                if (roundedValue == null) continue;
                rs.updateBigDecimal(cols[i], roundedValue);
            }
        }
        rs.beforeFirst();
    }

    public static Locale[] getAllLocale(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo solution = loader.getSolution();
        LanguageCollection lc = solution.getLanguages();
        Locale[] locales = new Locale[lc.size()];
        int n = lc.size();
        for (int i = 0; i < n; ++i) {
            locales[i] = lc.get(i).getLocale();
        }
        return locales;
    }

    public static IObjectCollection botpTransfromSave(Context ctx, CoreBillBaseCollection srcBillColl, BOSObjectType destObjType) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(srcBillColl, destObjType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        CoreBillBaseInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (CoreBillBaseInfo)destBillColl.getObject(i);
            iBTPManager.saveRelations(destBillInfo, botRelateColl);
        }
        return destBillColl;
    }

    public static IObjectCollection botpTransfromSubmit(Context ctx, CoreBillBaseCollection srcBillColl, BOSObjectType destObjType) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(srcBillColl, destObjType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        CoreBillBaseInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (CoreBillBaseInfo)destBillColl.getObject(i);
            iBTPManager.submitRelations(destBillInfo, botRelateColl);
        }
        return destBillColl;
    }

    public static void saveBOTRelation(Context ctx, List srcIdList, String destBillId) throws BOSException {
        if (srcIdList == null || srcIdList.isEmpty() || QMHelper.isEmpty(destBillId)) {
            return;
        }
        String srcBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        int size = srcIdList.size();
        for (int i = 0; i < size; ++i) {
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            srcBillId = (String)srcIdList.get(i);
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static void saveBOTRelation(Context ctx, Map idMap) throws BOSException {
        if (idMap == null || idMap.isEmpty()) {
            return;
        }
        BOTRelationInfo relateInfo = null;
        String srcBillId = null;
        String destBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (Map.Entry entry : idMap.entrySet()) {
            srcBillId = (String)entry.getKey();
            destBillId = (String)entry.getValue();
            relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static boolean hasWFInstance(Context ctx, String billId) throws BOSException {
        boolean hasWorkflow = false;
        if (billId != null) {
            IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(billId);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
            }
            hasWorkflow = instInfo != null;
        }
        return hasWorkflow;
    }

    public static void addDataFilter(FilterInfo filter, ArrayList param) throws BOSException {
        DSParam dp;
        String s;
        if (filter == null || filter.getFilterItems().size() == 0) {
            return;
        }
        if (param == null || param.size() == 0) {
            return;
        }
        FilterInfo datafilter = null;
        if (param != null && param.size() > 0 && (s = (dp = (DSParam)param.get(0)).getColName()) != null && s.equalsIgnoreCase("datafilter")) {
            String f = dp.getAssociateField();
            try {
                datafilter = new FilterInfo(f);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if (datafilter != null && datafilter.getFilterItems().size() > 0) {
            filter.mergeFilter(datafilter, "AND");
        }
    }

    public static void saveMerg(FilterInfo f1, FilterInfo f2, String logic) throws BOSException {
        if (f1 == null) {
            throw new BOSException("sorce filterInfo can not empty");
        }
        if (f1.getFilterItems().size() == 0) {
            f1.getFilterItems().addObjectCollection((IObjectCollection)f2.getFilterItems());
            f1.setMaskString(f2.getMaskString());
            return;
        }
        f1.mergeFilter(f2, logic);
    }

    public static FilterInfo getCUFilter() {
        CtrlUnitInfo curCU = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)curCU.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        filterInfo.setMaskString("#0 or #1 or #2");
        return filterInfo;
    }

    public static EntityViewInfo getCUEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(QMHelper.getCUFilter());
        return evi;
    }

    public static String getClassParam(String clsParam, int index) {
        if (clsParam == null) {
            return null;
        }
        String[] temp = clsParam.split("_");
        if (index >= temp.length) {
            return null;
        }
        return temp[index];
    }

    public static EntityViewInfo getCityEvi(ProvinceInfo province) {
        FilterInfo filter = new FilterInfo();
        if (province != null) {
            filter.getFilterItems().add(new FilterItemInfo("province.id", (Object)province.getId().toString()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("province.id"));
        sic.add(new SelectorItemInfo("province.name"));
        sic.add(new SelectorItemInfo("province.number"));
        return evi;
    }

    public static EntityViewInfo getRegionEvi(ProvinceInfo province, CityInfo city) {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("city.id"));
        sic.add(new SelectorItemInfo("city.name"));
        sic.add(new SelectorItemInfo("city.number"));
        sic.add(new SelectorItemInfo("city.province.id"));
        sic.add(new SelectorItemInfo("city.province.name"));
        sic.add(new SelectorItemInfo("city.province.number"));
        if (city != null) {
            filter.getFilterItems().add(new FilterItemInfo("city.id", (Object)city.getId().toString()));
            return evi;
        }
        if (province != null) {
            filter.getFilterItems().add(new FilterItemInfo("city.province.id", (Object)province.getId().toString()));
            return evi;
        }
        return evi;
    }

    public static byte[] decode(byte[] bs) {
        byte[] c = new byte[bs.length / 2];
        for (int i = 0; i < c.length; ++i) {
            int cc = QMHelper.getInt((char)bs[i * 2]) * 16 + QMHelper.getInt((char)bs[i * 2 + 1]);
            c[i] = (byte)(cc - 128);
        }
        return c;
    }

    private static int getInt(char b) {
        if (b < 'A') {
            return b - 48;
        }
        return b - 55;
    }

    public static byte[] encode(byte[] bs) {
        byte[] sb = new byte[bs.length * 2];
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] + 128;
            sb[i * 2] = (byte)hex[c / 16];
            sb[i * 2 + 1] = (byte)hex[c % 16];
        }
        return sb;
    }

    public static void close(ObjectOutputStream objectOs) {
        if (objectOs != null) {
            try {
                objectOs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(ObjectInputStream objectOs) {
        if (objectOs != null) {
            try {
                objectOs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void updateAccountRef(Context ctx, String srcAccountTableId, String desAcctTableId) {
    }

    public static Set getAllRefAcctIdSet(Context ctx, String cuId, Set acctIdSet) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT b.FOldAcctId FROM T_BD_AcctRefContrast a \n").append(" LEFT JOIN T_BD_AcctRefContrastEntry b ON a.FID = b.FAcctRefContrastID \n").append(" WHERE a.FCompanyID ='").append(cuId).append("'").append(" \t\n AND b.FNewAcctId IN ");
        HashSet<String> oldAcctIdSet = new HashSet<String>();
        oldAcctIdSet.addAll(acctIdSet);
        ISQLExecutor exec = null;
        IRowSet rs = null;
        for (int index = 0; index < 5; ++index) {
            String ids = QMHelper.setTran2String(oldAcctIdSet);
            String sql = sb.toString() + ids;
            exec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
            rs = exec.executeSQL();
            oldAcctIdSet = new HashSet();
            if (rs == null || rs.size() < 1) break;
            try {
                while (rs.next()) {
                    oldAcctIdSet.add(rs.getString("FOldAcctId"));
                    acctIdSet.add(rs.getString("FOldAcctId"));
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return acctIdSet;
    }

    public static boolean hasAsstInnerAcct(Context ctx, String acctViewId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.FID, a.FNumber, a.FName_l2 from T_BD_AccountView a \n").append(" join T_BD_AsstAccount b on a.FCAA = b.FID \n").append(" join T_BD_AsstActGroupDetail c on c.FAsstAccountID = b.FID \n").append(" join T_BD_AsstActType d on c.FAsstActTypeID = d.FID \n").append(" where d.FRealtionDataObject = 'T_FS_InnerAccount' \n").append("  and a.FID = '").append(acctViewId).append("'\n");
        ISQLExecutor exec = QMHelper.getSQLExec(ctx, sql.toString());
        IRowSet rs = exec.executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static boolean hasAsstAccountBank(Context ctx, String acctViewId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.FID, a.FNumber, a.FName_l2 from T_BD_AccountView a \n").append(" join T_BD_AsstAccount b on a.FCAA = b.FID \n").append(" join T_BD_AsstActGroupDetail c on c.FAsstAccountID = b.FID \n").append(" join T_BD_AsstActType d on c.FAsstActTypeID = d.FID \n").append(" where d.FRealtionDataObject = 'T_BD_AccountBanks' \n").append("  and a.FID = '").append(acctViewId).append("'\n");
        ISQLExecutor exec = QMHelper.getSQLExec(ctx, sql.toString());
        IRowSet rs = exec.executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private static Set getAsstInnerAcctAcctViewIdSet(Context ctx, String cuId) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.FID, a.FNumber, a.FName_l2 FROM T_BD_AccountView a \n").append(" JOIN T_BD_AsstAccount b on a.FCAA = b.FID \n").append(" JOIN T_BD_AsstActGroupDetail c on c.FAsstAccountID=b.FID \n").append(" JOIN T_BD_AsstActType d on c.FAsstActTypeID = d.FID \n").append(" WHERE d.FRealtionDataObject = 'T_FS_InnerAccount' \n");
        if (!QMHelper.isEmpty(cuId)) {
            sql.append("\tAND a.FControlUnitID = '").append(cuId).append("'\n");
        }
        ISQLExecutor exec = QMHelper.getSQLExec(ctx, sql.toString());
        IRowSet rs = exec.executeSQL();
        try {
            while (rs.next()) {
                set.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    public static Set getAsstInnerAcctIdSet(Context ctx, String acctViewId) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        if (QMHelper.isEmpty(acctViewId)) {
            return set;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT c.FInnerAccountId FROM T_BD_AccountView a \n").append(" JOIN T_BD_AsstAccount b on a.FCAA = b.FID \n").append(" JOIN T_BD_AssistantHG c on c.FAsstAccountID = b.FID \n").append(" WHERE c.FInnerAccountId IS NOT NULL \n").append("\tAND a.FID = '").append(acctViewId).append("'\n");
        ISQLExecutor exec = QMHelper.getSQLExec(ctx, sql.toString());
        IRowSet rs = exec.executeSQL();
        try {
            while (rs.next()) {
                set.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    private static ISQLExecutor getSQLExec(Context ctx, String sql) {
        if (ctx == null) {
            return SQLExecutorFactory.getRemoteInstance((String)sql);
        }
        return SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
    }

    public static ExchangeRateInfo getExRateInfo(Context ctx, CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurr == null || date == null) {
            return null;
        }
        if (company == null) {
            company = ctx == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (destCurr == null) {
            destCurr = company.getBaseCurrency();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        if (srcCurr.equalsPK((IObjectValue)destCurr)) {
            return null;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangeRate = null;
        iExchangeRate = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo exRateInfo = iExchangeRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return exRateInfo;
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return FMConstants.ZERO;
        }
        return a.multiply(b);
    }

    public static String trimZero(Object value, int type) {
        StringBuffer sb = QMHelper.trimLeftZero(QMHelper.trimRightZero(value, type), type);
        if (sb == null) {
            return null;
        }
        String valueStr = sb.reverse().toString();
        BigDecimal b = new BigDecimal(valueStr);
        if (value == null || QMHelper.isValueZero(b)) {
            if (type == 1) {
                return "0.00";
            }
            if (type == 2) {
                return "0.00000";
            }
        }
        if (valueStr.startsWith(".")) {
            valueStr = STRING_ZERO + valueStr;
        }
        return valueStr;
    }

    private static StringBuffer trimLeftZero(Object value, int type) {
        String tmp;
        int i;
        if (value == null) {
            return null;
        }
        if (QMHelper.isValueZero(value)) {
            if (type == 1) {
                return new StringBuffer("0.00");
            }
            return new StringBuffer("0.00000");
        }
        StringBuffer valueSB = new StringBuffer(value.toString());
        for (i = 0; i < valueSB.length() && (tmp = valueSB.toString().substring(i, i + 1)).equals(STRING_ZERO); ++i) {
        }
        StringBuffer sbReturn = new StringBuffer(valueSB.substring(i)).reverse();
        return sbReturn;
    }

    private static StringBuffer trimRightZero(Object value, int type) {
        String tmp;
        int i;
        if (value == null) {
            return null;
        }
        if (QMHelper.isValueZero(value)) {
            if (type == 1) {
                return new StringBuffer("0.00");
            }
            return new StringBuffer("0.00000");
        }
        StringBuffer valueSB = new StringBuffer(value.toString()).reverse();
        for (i = 0; i < valueSB.length() && (tmp = valueSB.toString().substring(i, i + 1)).equals(STRING_ZERO); ++i) {
        }
        StringBuffer sbReturn = new StringBuffer(valueSB.substring(i)).reverse();
        return sbReturn;
    }

    private static boolean isValueZero(Object value) {
        BigDecimal objValue = new BigDecimal(value.toString());
        return objValue.compareTo(FMConstants.ZERO) == 0;
    }

    public static int setPresionOfExchangeRate(CurrencyInfo srcCurr, CompanyOrgUnitInfo company, Date date, KDFormattedTextField txtexchangeRate) throws Exception {
        ExchangeRateInfo exRateInfo;
        if (srcCurr == null || date == null) {
            return 5;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if ((exRateInfo = QMHelper.getExRateInfo(srcCurr, null, company, date = DateTimeUtils.truncateDate((Date)date))) == null) {
            return 5;
        }
        txtexchangeRate.setValue((Object)exRateInfo.getConvertRate());
        txtexchangeRate.setPrecision(exRateInfo.getPrecision());
        return exRateInfo.getPrecision();
    }

    public static ExchangeRateInfo getExRateInfo(CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurr == null) {
            return null;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (destCurr == null) {
            destCurr = company.getBaseCurrency();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseExchangeTable.*"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
            baseExchangeTable = company.getBaseExchangeTable();
        }
        if (baseExchangeTable == null) {
            return null;
        }
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return exRateInfo;
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Map hm = QMHelper.doTrans(sql, params);
        String sqlValue = (String)hm.get("sql_statment");
        Object[] paramValue = (Object[])hm.get("value");
        DbUtil.execute((Context)ctx, (String)sqlValue, (Object[])paramValue);
    }

    private static Map doTrans(String sql, Object[] param) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        StringBuffer sbSQL = new StringBuffer();
        ArrayList<Object> paramList = new ArrayList<Object>();
        List splitSql = QMHelper.splitSQL(sql);
        int paramCount = param.length;
        for (int i = 0; i < paramCount; ++i) {
            Object singleParam = param[i];
            if (singleParam == null) {
                StringBuffer tmp = new StringBuffer((String)splitSql.get(i));
                tmp.deleteCharAt(tmp.length() - 1).append("null");
                sbSQL.append(tmp).append(" ");
                continue;
            }
            sbSQL.append((String)splitSql.get(i));
            if (singleParam instanceof Date) {
                java.sql.Date dateParam = new java.sql.Date(((Date)singleParam).getTime());
                paramList.add(dateParam);
                continue;
            }
            paramList.add(singleParam);
        }
        hm.put("sql_statment", sbSQL.toString());
        hm.put("value", paramList.toArray());
        return hm;
    }

    private static List splitSQL(String sql) {
        ArrayList<String> lisql = new ArrayList<String>();
        while (sql.indexOf("?") != -1) {
            int positionTmp = sql.indexOf("?");
            String sqlTmp = sql.substring(0, positionTmp + 1);
            lisql.add(sqlTmp);
            sql = sql.substring(sqlTmp.length());
        }
        return lisql;
    }

    public static String cutString(String s, int i) {
        if (s == null) {
            return null;
        }
        if (i < 0) {
            return s;
        }
        if (s.length() > i) {
            return s.substring(0, i);
        }
        return s;
    }

    public static Set getPersonIds(Context ctx, String adminOrgUnitId) throws BOSException {
        HashSet<String> personIds = new HashSet<String>();
        if (QMHelper.isEmpty(adminOrgUnitId)) {
            return personIds;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.id", (Object)adminOrgUnitId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IPositionMember iPositionMember = null;
        iPositionMember = ctx == null ? PositionMemberFactory.getRemoteInstance() : PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection coll = iPositionMember.getPositionMemberCollection(evi);
        if (coll == null || coll.isEmpty()) {
            return personIds;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            personIds.add(coll.get(i).getPerson().getId().toString());
        }
        return personIds;
    }

    public static PersonCollection getPersonColl(Context ctx, String adminOrgUnitId) throws BOSException, EASBizException {
        Set ids = QMHelper.getPersonIds(ctx, adminOrgUnitId);
        if (ids == null || ids.isEmpty()) {
            return new PersonCollection();
        }
        IPerson iPerson = null;
        iPerson = ctx == null ? PersonFactory.getRemoteInstance() : PersonFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return iPerson.getPersonCollection(evi);
    }

    public static UserInfo getAdmin(Context ctx) throws EASBizException, BOSException {
        if (adminUser == null) {
            adminUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        return adminUser;
    }

    private static boolean isAdmin(Context ctx, UserInfo user) throws EASBizException, BOSException {
        if (user == null) {
            return false;
        }
        return user != null && user.getId().equals((Object)QMHelper.getAdmin(ctx).getId());
    }

    public static void updateCreator(Context ctx, ObjectBaseInfo info) throws EASBizException, BOSException {
        if (ctx == null) {
            return;
        }
        if (info == null) {
            return;
        }
        if (QMHelper.isAdmin(ctx, info.getCreator())) {
            info.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        }
    }

    public static IRowSet transJdbcRowSet(IRowSet jdbcRowSet) throws EASBizException, BOSException {
        DynamicRowSet drs = null;
        try {
            int i;
            ResultSetMetaData rsmd = jdbcRowSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            drs = new DynamicRowSet(colCount);
            String[] columnNameArray = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                int columnClz = rsmd.getColumnType(i + 1);
                String columnlbl = rsmd.getColumnLabel(i + 1);
                columnNameArray[i] = columnName;
                ColInfo ciId = new ColInfo(columnName, columnlbl, columnClz, null);
                drs.setColInfo(i + 1, ciId);
            }
            while (jdbcRowSet.next()) {
                drs.moveToInsertRow();
                for (i = 0; i < colCount; ++i) {
                    drs.updateObject(columnNameArray[i], jdbcRowSet.getObject(columnNameArray[i]));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    public static String transToLikeSql(String colName, Set names) {
        Iterator it;
        StringBuffer sql = new StringBuffer();
        if (colName != null && names != null && (it = names.iterator()).hasNext()) {
            sql.append("(");
            sql.append(colName);
            sql.append(" like '%");
            sql.append(it.next().toString());
            sql.append("%'");
            while (it.hasNext()) {
                sql.append(" or ");
                sql.append(colName);
                sql.append(" like '%");
                sql.append(it.next().toString());
                sql.append("%'");
            }
            sql.append(")");
        }
        return sql.toString();
    }

    public static boolean getAccountBankByInnerAcct(Context ctx, String id) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)id));
        evi.setFilter(filter);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        return coll != null && coll.size() > 0;
    }

    public static Date getDate(String date, String pattern) {
        DateFormat formatter = BOSLocaleUtil.getDateFormat();
        try {
            return formatter.parse(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static CompanyOrgUnitCollection getUserOrgRanges(Context ctx) throws EASBizException, BOSException {
        UserInfo user;
        HashSet<String> idSet = new HashSet<String>();
        FullOrgUnitCollection coll = null;
        if (ctx == null) {
            user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            coll = OrgSwitchFacadeFactory.getRemoteInstance().getOrgRanges((IObjectPK)new ObjectUuidPK(user.getId()));
        } else {
            user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            coll = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).getOrgRanges((IObjectPK)new ObjectUuidPK(user.getId()));
        }
        for (int i = 0; i < coll.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)coll.getObject(i);
            if (!orgUnit.isIsCompanyOrgUnit()) continue;
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    public static CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        IPermission permission;
        HashSet<String> idSet = new HashSet<String>();
        UserInfo userInfo = null;
        if (ctx == null) {
            userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            permission = PermissionFactory.getRemoteInstance();
        } else {
            userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            permission = PermissionFactory.getLocalInstance((Context)ctx);
        }
        FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        for (int i = 0; i < mainOrgs.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)mainOrgs.getObject(i);
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isGroup");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("baseCurrency.name");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        sic.add("isSealUp");
        sic.add("isBizUnit");
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    public static void genBillByBotp(Context ctx, CoreBillBaseInfo srcBillInfo, String destBillType) throws BOSException, BTPException, EASBizException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        col.add(srcBillInfo);
        IBTPManager iBTPManager = null;
        iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = iBTPManager.transformMultiBill(col, destBillType);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
        int size = destBillCols.size();
        for (int i = 0; i < size; ++i) {
            iBTPManager.submitRelations((CoreBillBaseInfo)destBillCols.getObject(i), botRelateColl);
        }
    }

    public static Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            return new HashMap();
        }
        HashMap<String, Object> description = new HashMap<String, Object>();
        if (bean instanceof DynaBean) {
            DynaProperty[] descriptors = ((DynaBean)bean).getDynaClass().getDynaProperties();
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                description.put(name, QMHelper.getProperty(bean, name));
            }
        } else {
            PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Object)bean);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if (descriptors[i].getReadMethod() == null || descriptors[i].getWriteMethod() == null) continue;
                description.put(name, QMHelper.getProperty(bean, name));
            }
        }
        return description;
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getNestedProperty((Object)bean, (String)name);
        return value;
    }

    public static String BDC2Str(BigDecimal value) {
        if (value == null) {
            return EMPTY_STRING;
        }
        NumberFormat fmt = BOSLocaleUtil.getDecimalFormat();
        return fmt.format(value);
    }

    public static boolean isInstanceof(String id, Class infoClass) {
        Object info;
        if (null == id || id.length() == 0 || null == infoClass) {
            return false;
        }
        try {
            info = infoClass.newInstance();
        }
        catch (Exception e) {
            return false;
        }
        if (!(info instanceof CoreBaseInfo)) {
            return false;
        }
        BOSUuid uuid = BOSUuid.read((String)id);
        return uuid.getType().equals((Object)((CoreBaseInfo)info).getBOSType());
    }

    public static BigDecimal parseBigDecimal(String value) {
        if (QMHelper.isEmpty(value)) {
            return null;
        }
        value = value.replaceAll(",", EMPTY_STRING);
        return new BigDecimal(value);
    }

    public static Map findChild(Context ctx, Set idSet) throws BOSException {
        HashMap destMap = new HashMap();
        StringBuffer findSql = new StringBuffer();
        findSql.append(" select FSrcObjectID,FDestObjectID from T_BOT_Relation where FSrcObjectID in ");
        findSql.append(QMHelper.setTran2String(idSet));
        findSql.append(" order by FSrcObjectID ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)findSql.toString());
        try {
            String beforeSrcId = EMPTY_STRING;
            ArrayList<String> destIdList = null;
            while (rs.next()) {
                String srcId = rs.getString("FSrcObjectID");
                String destId = rs.getString("FDestObjectID");
                if (!srcId.equals(beforeSrcId)) {
                    destIdList = new ArrayList<String>();
                    destMap.put(srcId, destIdList);
                    destIdList.add(destId);
                } else {
                    destIdList.add(destId);
                }
                beforeSrcId = srcId;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return destMap;
    }

    public static ArrayList getDestIdBySrc(Map idMap, String src) {
        ArrayList destIds = new ArrayList();
        if (idMap == null || idMap.isEmpty()) {
            return destIds;
        }
        String srcBillId = null;
        ArrayList destBillIdList = null;
        for (Map.Entry entry : idMap.entrySet()) {
            srcBillId = (String)entry.getKey();
            destBillIdList = (ArrayList)entry.getValue();
            if (!src.equals(srcBillId)) continue;
            destIds = destBillIdList;
            break;
        }
        return destIds;
    }

    public static PeriodInfo getStartPeriod(Context ctx, String comnumber) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.number", (Object)comnumber));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("startPeriod.periodYear"));
        sic.add(new SelectorItemInfo("startPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("startPeriod.beginDate"));
        sic.add(new SelectorItemInfo("startPeriod.endDate"));
        ISystemStatusCtrol ctrl = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        PeriodInfo prd = null;
        if (col.size() == 1) {
            prd = col.get(0).getStartPeriod();
        }
        return prd;
    }

    public static Object getField(Object obj, String fieldName) throws SecurityException {
        if (obj == null) {
            return EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"42_QMHelper");
        }
        Field f = null;
        try {
            f = obj.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (f == null) {
            try {
                f = obj.getClass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (f == null) {
                for (Class<?> superclass = obj.getClass().getSuperclass(); f == null && superclass != null; superclass = superclass.getSuperclass()) {
                    try {
                        f = superclass.getDeclaredField(fieldName);
                        continue;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
        }
        return f == null ? EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"43_QMHelper") : QMHelper.getSafeValue(obj, f);
    }

    public static Object invokeMethod(String methodName, Class[] parameterTypes, Object obj, Object[] args) throws SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || methodName == null || methodName.length() == 0) {
            return EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"42_QMHelper");
        }
        Method method = null;
        try {
            method = obj.getClass().getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = obj.getClass().getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                for (Class<?> superclass = obj.getClass().getSuperclass(); method == null && superclass != null; superclass = superclass.getSuperclass()) {
                    try {
                        method = superclass.getDeclaredMethod(methodName, parameterTypes);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (method != null) {
                method.setAccessible(true);
            }
        }
        return method == null ? EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"44_QMHelper") : method.invoke(obj, args);
    }

    public static String getListSql(ListUI ui) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, BOSException {
        if (ui == null) {
            return EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"45_QMHelper");
        }
        IMetaDataPK queryPK = ui.getMainQueryPK();
        EntityViewInfo query = ui.getMainQuery();
        Object ret = QMHelper.invokeMethod("getQueryExecutor", new Class[]{IMetaDataPK.class, EntityViewInfo.class}, ui, new Object[]{queryPK, query});
        return ((IQueryExecutor)ret).getSQL();
    }

    public static String getTansSql(String sql, int DBtype) throws SqlTranslateException {
        return TransUtil.Translate((String)sql, (int)DBtype);
    }

    public static Component getCompNameByInfoPropName(CoreUIObject ui, String propertyName) throws SecurityException {
        DataBinder dataBinder = (DataBinder)QMHelper.getField(ui, "dataBinder");
        return dataBinder.getComponetByField(propertyName);
    }

    public static String helps() {
        return "//static Object getField(Object obj, String fieldName) \u83b7\u5f97\u5bf9\u8c61\u7684\u5b57\u6bb5  nFMHelper.getField(CoreUI, \"editData\") \n//static String getListSql(ListUI ui) \u83b7\u53d6ListUI\u7684\u5408\u6210SQLnFMHelper.getListSql(CoreUI) \n//static Component getCompNameByInfoPropName(CoreUIObject ui, String propertyName) \u901a\u8fc7info\u7684\u5c5e\u6027\u83b7\u5f97\u5bf9\u5e94\u7ed1\u5b9a\u7684 ComponentnFMHelper.getCompNameByInfoPropName(CoreUI, \"number\" ) \n//static Object invokeMethod(String methodName, Class[] parameterTypes, Object obj, Object[] args) \u8c03\u7528\u67d0\u5bf9\u8c61\u7684\u65b9\u6cd5, \u5747\u80fd\u8bbf\u95ee private protectednFMHelper.invokeMethod(\"\", new Class[]{ }, CoreUI, new Object[]{ }) \n";
    }

    public static String[] parseEnumString(String str) {
        if (str == null) {
            return new String[0];
        }
        String[] s = str.split("#");
        return s;
    }

    static {
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        adminUser = null;
    }
}

