/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util.backup;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class QMMetadataCommonUtils {
    public static EntityObjectInfo getEntityMetaData(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = null;
        loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        if (loader == null) {
            return entityInfo;
        }
        entityInfo = loader.getEntity(bosType);
        return entityInfo;
    }

    public static IObjectValue createEntity(Context ctx, BOSObjectType objectType) {
        CoreBaseInfo objbase = null;
        try {
            EntityObjectInfo entityInfo = QMMetadataCommonUtils.getEntityMetaData(ctx, objectType);
            if (entityInfo != null) {
                Class<?> cls = Class.forName(entityInfo.getObjectValueClass());
                objbase = (CoreBaseInfo)cls.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objbase;
    }

    public static IObjectCollection createEntityCollection(Context ctx, BOSObjectType bosObjectType) {
        CoreBaseCollection objbaseCollection = null;
        try {
            EntityObjectInfo entityInfo = QMMetadataCommonUtils.getEntityMetaData(ctx, bosObjectType);
            if (entityInfo != null) {
                Class<?> cls = Class.forName(entityInfo.getObjectCollectionClass());
                objbaseCollection = (CoreBaseCollection)cls.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objbaseCollection;
    }

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        CoreBaseInfo baseInfo = (CoreBaseInfo)model;
        IObjectCollection col = (IObjectCollection)baseInfo.get("entry");
        if (col == null || col.size() == 0) {
            return null;
        }
        IObjectValue entryValue = col.getObject(0);
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(entryValue.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        return entityObjectInfo;
    }

    public static ICoreBase getLocalInstance(BOSObjectType bosType, Context ctx) throws BOSException {
        ICoreBase iCoreBase = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(bosType);
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException(e.getMessage());
        }
        catch (SecurityException e) {
            throw new BOSException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new BOSException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new BOSException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new BOSException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new BOSException(e.getMessage());
        }
        return iCoreBase;
    }

    public static ICoreBase getLocalInstance(EntityObjectInfo eo, Context ctx) throws BOSException {
        ICoreBase iCoreBase = null;
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException(e.getMessage());
        }
        catch (SecurityException e) {
            throw new BOSException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new BOSException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new BOSException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new BOSException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new BOSException(e.getMessage());
        }
        return iCoreBase;
    }

    public static CoreBaseInfo getLinkObject(EntityObjectInfo eo, Object value, Context ctx) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("number", value, CompareType.EQUALS));
        entityViewInfo.setFilter(filters);
        CoreBaseCollection cols = QMMetadataCommonUtils.getLocalInstance(eo, ctx).getCollection(entityViewInfo);
        if (cols != null && cols.size() > 0) {
            return cols.get(0);
        }
        return null;
    }

    public static CoreBaseInfo getLinkObject(BOSObjectType bosType, Object value, Context ctx) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("number", value, CompareType.EQUALS));
        entityViewInfo.setFilter(filters);
        CoreBaseCollection cols = QMMetadataCommonUtils.getLocalInstance(bosType, ctx).getCollection(entityViewInfo);
        if (cols != null && cols.size() > 0) {
            return cols.get(0);
        }
        return null;
    }

    public static String getDetailTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        EntityObjectInfo entityObjectInfo = QMMetadataCommonUtils.getEntityObjectInfo(ctx, model);
        if (entityObjectInfo == null) {
            return null;
        }
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }

    public static String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        EntityObjectInfo entityObjectInfo = QMMetadataCommonUtils.getEntityObjectInfo(ctx, model);
        if (entityObjectInfo == null) {
            return null;
        }
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }
}

