/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRuleInfo;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.qc.BalanceCalPatternEnum;
import com.kingdee.eas.qm.qc.DeductCalFomulaEnum;
import com.kingdee.eas.qm.qc.HQHPCalBillCollection;
import com.kingdee.eas.qm.qc.HQHPCalBillFactory;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryCollection;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillSettleItemEntryCollection;
import com.kingdee.eas.qm.qc.HQHPCalBillSettleItemEntryInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillSettleTermEntryCollection;
import com.kingdee.eas.qm.qc.HQHPCalBillSettleTermEntryInfo;
import com.kingdee.eas.qm.qc.IHQHPCalBill;
import com.kingdee.eas.qm.qc.PricingPatternEnum;
import com.kingdee.eas.qm.qc.QCReportCollection;
import com.kingdee.eas.qm.qc.QCReportEntryCollection;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.QuanSettlePatternEnum;
import com.kingdee.eas.qm.qc.app.AbstractHQHPCalBillControllerBean;
import com.kingdee.eas.qm.qc.app.reversesave.hqhp.HQHPCalBillRevAction;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportServerHelper;
import com.kingdee.eas.qm.qc.app.verify.HQHPCalBillAuditVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.HQHPCalBillUnAuditVerifyItem;
import com.kingdee.eas.qm.qc.util.HQHPDeductCalWithFomula;
import com.kingdee.eas.qm.qc.util.HQHPMsg;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.qm.qc.util.QMUnitConvertHelper;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurContractEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurContractSettleTermsNorCollection;
import com.kingdee.eas.scm.sm.pur.PurContractSettleTermsNorInfo;
import com.kingdee.eas.scm.sm.pur.SettlementTypeNorthEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HQHPCalBillControllerBean
extends AbstractHQHPCalBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.HQHPCalBillControllerBean");
    private static String nameCol = QCReportServerHelper.getFieldByLanguage("fname");
    private static BigDecimal ZERO = HQHPUtil.BigDecimal_Zero;
    private static final int DivideMode = 4;
    private int qtyScale;
    private int priceScale;
    private Set purEntryIds = null;
    private Map params;
    private Context ctx;
    private Set allUnSelectWBs;
    private Map verifyResultMap = new HashMap();
    private Map qcReportInfoMaps;
    private IObjectCollection qcReportColls;
    private Map recMaps;
    private Set reportIDs;
    private Set recIDs;
    private List errorMsgs = new ArrayList();
    private String qcItemNotInRange = null;
    private BigDecimal qcValueNotInRange = null;
    private boolean isCal = false;
    private int calSuccessCount = 0;
    CoreBaseCollection calSuccessBills = null;
    private boolean isWeigh;
    private QuanSettlePatternEnum quanSettlePattern = null;
    private BigDecimal netWeighAmount = null;
    private BigDecimal totalDeductVar = null;
    private BigDecimal supplierDryWeight = null;
    private String unitId = null;
    private BigDecimal dryWeightAmount = null;
    private Map netWeighAmounts = null;
    private Map dryWeighAmounts = null;
    private BigDecimal settleUnitPrice = null;
    private Set isAllCancellQCItem;
    private Map deductQCItemAverValue;
    private List submitErrorMsg = new ArrayList();
    private Map submitLogIds = null;
    private Map cancelLogIds = null;
    private List cancelErrorMsgs = new ArrayList();

    @Override
    protected List _getCreateFromList(Context ctx, Map filterParams) throws BOSException, EASBizException {
        String materialID;
        String purContractID;
        this.ctx = ctx;
        StringBuffer sql = this.appendGenColumnsSQL();
        Boolean paramIsWeigh = (Boolean)filterParams.get("Para_IsWeigh");
        sql.append("left outer join T_WM_WeighNoticeBillEntry as wnbe \n");
        sql.append("on wnbe.fsourcebillentryid = recentry.fid \n");
        sql.append("left outer join t_wm_weighbill as wb \n");
        sql.append("on wb.fsourcebillentryid = wnbe.fid \n");
        sql.append("WHERE 1=1 \n");
        if (paramIsWeigh != null && paramIsWeigh.booleanValue()) {
            sql.append("and wb.fid is not null and (wb.FHQHPCalBillID is null or wb.FHQHPCalBillID = '') \n");
            sql.append("and wb.fbillstatus = 30 \n");
        } else {
            sql.append("and wb.fid is null and entry.CFISWEIGH <> 1 \n");
            sql.append("and (REPORT.FSUMBILLNUMBERID IS NULL OR  REPORT.FSUMBILLNUMBERID = '') \n");
        }
        Date weighDateBegin = (Date)filterParams.get("Para_WeighDateBegin");
        Date weighDateEnd = (Date)filterParams.get("Para_WeighDateEnd");
        if (weighDateBegin != null) {
            sql.append("and wb.FLatestWeighTime > to_date('").append(HQHPUtil.formatStartDate(weighDateBegin)).append("') \n");
        }
        if (weighDateEnd != null) {
            sql.append("and wb.FLatestWeighTime < to_date('").append(HQHPUtil.formatEndDate(weighDateEnd)).append("') \n");
        }
        StringBuffer statusFilter = new StringBuffer();
        statusFilter.append("(0,");
        statusFilter.append("1,");
        statusFilter.append("2)");
        sql.append("and PUR.FBASESTATUS NOT IN ").append(statusFilter).append(" \n");
        sql.append("and rec.fbasestatus = ").append(4).append(" \n");
        sql.append("and entry.FQCStandardID is not null \n");
        sql.append("and entry.CFIsHQHPRICE = 1 \n");
        String purOrgIDs = (String)filterParams.get("purOrgID");
        sql.append("AND PUR.FPurOrgUnitID IN ").append(purOrgIDs).append(" \n");
        String purDateBegin = HQHPUtil.formatStartDate((Date)filterParams.get("purDateBegin"));
        String purDateEnd = HQHPUtil.formatEndDate((Date)filterParams.get("purDateEnd"));
        sql.append("AND PUR.FBIZDATE BETWEEN TO_DATE('").append(purDateBegin).append("') AND TO_DATE('").append(purDateEnd).append("') \n");
        Date recBillDateBegin = (Date)filterParams.get("recBillDateBegin");
        Date recBillDateEnd = (Date)filterParams.get("recBillDateEnd");
        if (recBillDateBegin != null && recBillDateEnd != null) {
            String recDateBegin = HQHPUtil.formatStartDate(recBillDateBegin);
            String recDateEnd = HQHPUtil.formatEndDate(recBillDateEnd);
            sql.append("AND REC.FBIZDATE BETWEEN TO_DATE('" + recDateBegin + "') AND TO_DATE('" + recDateEnd + "') \n");
        }
        ArrayList<String> args = new ArrayList<String>();
        String supplierID = (String)filterParams.get("supplierID");
        if (HQHPUtil.isNotNullString(supplierID)) {
            sql.append("AND PUR.FSupplierID = ? \n");
            args.add(supplierID);
        }
        if (HQHPUtil.isNotNullString(purContractID = (String)filterParams.get("purContractID"))) {
            sql.append("AND PUR.FID = ? \n");
            args.add(purContractID);
        }
        if (HQHPUtil.isNotNullString(materialID = (String)filterParams.get("paraMaterialID"))) {
            sql.append("AND MATERIAL2.MTID = ? \n");
            args.add(materialID);
        }
        Integer calPatternFilter = (Integer)filterParams.get("calPattern");
        sql.append("ORDER BY PURORGUNIT,SUPPLIER,MATERIAL,PURCONNUMBER,ID,ENTRYID \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])args.toArray());
        List result = this.createResultWithRS(rs, calPatternFilter);
        return result;
    }

    private StringBuffer appendGenColumnsSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("select DISTINCT PURORG.").append(nameCol).append("  AS PURORGUNIT,SUPPLIER.").append(nameCol).append("  AS SUPPLIER, \n");
        sql.append("MATERIAL2.MNAME AS MATERIAL, MATERIAL2.MTID AS MATERIALID, \n");
        sql.append("PUR.FNUMBER AS PURCONNUMBER,PUR.FBIZDATE AS CONTRACTDATE,PUR.FEFFECTEDDATE AS CONEXPIREDATE,  \n");
        sql.append("CONTYPE.").append(nameCol).append("  AS CONTRACTTYPE,ENTRY.FTAXPRICE AS PRICE,ENTRY.FPROTECTPRICE AS PROTECTIVEPRICE,  \n");
        sql.append("PUR.FID AS ID,ENTRY.FID AS ENTRYID, \n");
        sql.append(" \n");
        sql.append("rec.fid as RECBILLID, rec.fbizdate as RECBILLBIZDATE, rec.fdescription as recBillDesc, rec.fnumber as recBillNumber, \n");
        sql.append("recentry.fid as RECENTRYID,recentry.FTAXPRICE as CONPRICEREC, \n");
        sql.append("request.fid as REQUESTID, \n");
        sql.append(" \n");
        sql.append("report.fid as reportid,QUALITYORG.").append(nameCol).append(" as QUALITYORGUNIT,report.fnumber as NUMBER, \n");
        sql.append("report.FBILLSTATUS AS BILLSTATUS,TQCSTANDARD.").append(nameCol);
        sql.append(" as QCSTANDARD,report.FSAMPLESOLUTION AS SAMPLESOLUTION,  \n");
        sql.append("report.FREPORTDATE AS REPORTDATE,report.FCHECKRESULT AS CHECKRESULT,report.FDELIVERQTY AS DELIVERQTY,  \n");
        sql.append("report.FPASSQTY AS PASSQTY,report.FUNPASSQTY AS UNPASSQTY,MEASUREUNIT.").append(nameCol).append("  AS UNIT, \n");
        sql.append("report.FISCALBALPRICE AS ISCALBALPRICE,report.FISSUBMITBALPRICE AS ISSUBMITBALPRICE,  \n");
        sql.append("report.FISMRB AS ISMRB,report.FSUBMITRESULT AS SUBMITRESULT,report.FDESCRIPTION AS DESCRIPTION, \n");
        sql.append(" \n");
        sql.append("CALBILL.FID AS CALBILLID,CALBILL.FNUMBER AS CALBILLNUMBER,CALBILL.FSETTLEQUANTITY AS CALQUANTITY,  \n");
        sql.append("CALBILL.FSETTLEUNITPRICE AS CALUNITPRICE,CALBILL.FSETTLEMONEY AS CALMONEY \n");
        sql.append(" \n");
        sql.append("from t_sm_purcontract as pur \n");
        sql.append("left outer join t_sm_purcontractentry as entry \n");
        sql.append("on entry.fparentid = pur.fid \n");
        sql.append("inner join T_SM_PURORDERENTRY as orderentry \n");
        sql.append("on orderentry.FSOURCEBILLENTRYID = entry.fid \n");
        sql.append("inner join T_IM_PURRECEIVALENTRY as recentry \n");
        sql.append("on recentry.FpurorderentryID = orderentry.fid \n");
        sql.append("");
        sql.append("left outer join T_IM_PurReceivalBill as rec \n");
        sql.append("on recentry.fparentid = rec.fid \n");
        sql.append("left outer join t_qm_qcrequestentry as requestentry \n");
        sql.append("on requestentry.fsourcebillentryid = recentry.fid \n");
        sql.append("left outer join t_qm_qcrequest as request \n");
        sql.append("on requestentry.fparentid = request.fid \n");
        sql.append("left outer join t_qm_qcreport as report \n");
        sql.append("on report.frequestentryid = requestentry.fid \n");
        sql.append(" \n");
        sql.append("LEFT OUTER JOIN T_ORG_PURCHASE AS PURORG  \n");
        sql.append("ON PUR.FPURORGUNITID = PURORG.FID  \n");
        sql.append("LEFT OUTER JOIN T_BD_SETTLEMENTTYPE AS SETTLETYPE  \n");
        sql.append("ON PUR.FSETTLEMENTTYPEID = SETTLETYPE.FID  \n");
        sql.append("LEFT OUTER JOIN T_BD_SUPPLIER AS SUPPLIER  \n");
        sql.append("ON PUR.FSUPPLIERID = SUPPLIER.FID  \n");
        sql.append("LEFT OUTER JOIN T_SCM_CONTRACETREE AS CONTYPE  \n");
        sql.append("ON PUR.FCONTRACTTYPEID = CONTYPE.FID  \n");
        sql.append("LEFT OUTER JOIN T_ORG_QUALITY AS QUALITYORG  \n");
        sql.append("ON REPORT.FQUALITYORGUNITID = QUALITYORG.FID  \n");
        sql.append("LEFT OUTER JOIN T_QM_QCSTANDARD AS TQCSTANDARD  \n");
        sql.append("ON REPORT.FQCSTANDARDID = TQCSTANDARD.FID \n");
        sql.append("LEFT OUTER JOIN T_BD_MEASUREUNIT AS MEASUREUNIT  \n");
        sql.append("ON REPORT.FUNITID = MEASUREUNIT.FID  \n");
        sql.append("LEFT OUTER JOIN T_QM_HQHPCALBILL AS CALBILL  \n");
        sql.append("ON REPORT.FSUMBILLNUMBERID = CALBILL.FID  \n");
        sql.append(" \n");
        sql.append("LEFT OUTER JOIN   \n");
        sql.append("(SELECT ENTRY1.FID AS PID,MATERIAL1.MNAME,MATERIAL1.MTID  \n");
        sql.append("FROM T_SM_PURCONTRACTENTRY AS ENTRY1  \n");
        sql.append("INNER JOIN (  \n");
        sql.append("    SELECT M.").append(nameCol).append("  AS MNAME, M.FID AS MTID  \n");
        sql.append("    FROM T_BD_MATERIAL AS M  \n");
        sql.append("    INNER JOIN T_BD_MaterialPurchasing AS MP  \n");
        sql.append("    ON M.FID = MP.FMATERIALID  \n");
        sql.append("    ) AS MATERIAL1  \n");
        sql.append("ON ENTRY1.FMATERIALID = MATERIAL1.MTID) AS MATERIAL2  \n");
        sql.append("ON ENTRY.FID = MATERIAL2.PID  \n");
        return sql;
    }

    private List createResultWithRS(IRowSet rs, Integer calPatternFilter) throws BOSException {
        ArrayList<Map> purCons = new ArrayList<Map>();
        LinkedHashMap reportLists = new LinkedHashMap();
        Map purConRowMap = null;
        ArrayList<Map> reportList = null;
        String oldId = "";
        this.purEntryIds = new HashSet();
        try {
            while (rs.next()) {
                String purConId = rs.getString("ID");
                String entryId = rs.getString("ENTRYID");
                String id = purConId + entryId;
                Map reportRowMap = this.getReportRowFromRs(rs);
                if (oldId.equals(id)) {
                    reportList.add(reportRowMap);
                    continue;
                }
                purConRowMap = this.getPurConRowFromRs(rs);
                purCons.add(purConRowMap);
                if (!HQHPUtil.isNullList(reportList)) {
                    reportLists.put(oldId, reportList);
                }
                reportList = new ArrayList<Map>();
                reportList.add(reportRowMap);
                oldId = id;
            }
            if (!HQHPUtil.isNullList(reportList)) {
                reportLists.put(oldId, reportList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.addDynamicInfoToPurContract(purCons, calPatternFilter);
        ArrayList<Cloneable> result = new ArrayList<Cloneable>();
        result.add(purCons);
        result.add(reportLists);
        return result;
    }

    private void addDynamicInfoToPurContract(List purCons, Integer calPatternFilter) throws BOSException {
        if (this.purEntryIds == null || this.purEntryIds.size() == 0) {
            return;
        }
        Map[] dynamicPurInfos = HQHPCalBillFactory.getLocalInstance(this.ctx).getDynamicPurContract(this.purEntryIds);
        if (dynamicPurInfos == null || dynamicPurInfos.length == 0) {
            return;
        }
        Map dynamicPurInfo = dynamicPurInfos[0];
        if (dynamicPurInfo == null) {
            return;
        }
        for (int i = purCons.size() - 1; i >= 0; --i) {
            Map purMap = (Map)purCons.get(i);
            String entryID = (String)purMap.get("entryId");
            List purInfoList = (List)dynamicPurInfo.get(entryID);
            if (purInfoList == null || purInfoList.size() != 4) continue;
            Integer quanSettlePattern = (Integer)purInfoList.get(0);
            Integer calPattern = (Integer)purInfoList.get(1);
            Integer pricingPattern = (Integer)purInfoList.get(2);
            Integer deductCalFomula = (Integer)purInfoList.get(3);
            Integer calPatternEnumValue = this.convertEnumValueCalPattern(calPattern);
            if (calPatternFilter.equals(calPatternEnumValue)) {
                purMap.put("balNumCalPattern", this.convertEnumValueQSP(quanSettlePattern));
                purMap.put("balanceCalPattern", calPatternEnumValue);
                purMap.put("pricingPattern", this.convertEnumValuePricingPattern(pricingPattern));
                purMap.put("deductCalFomula", this.convertEnumDCM(deductCalFomula));
                continue;
            }
            purCons.remove(i);
        }
    }

    private Integer convertEnumDCM(Integer deductCalMethod) {
        if (deductCalMethod == null) {
            return new Integer(10);
        }
        switch (deductCalMethod) {
            case 10: {
                return new Integer(20);
            }
            case 20: {
                return new Integer(30);
            }
            case 30: {
                return new Integer(40);
            }
        }
        return new Integer(10);
    }

    private Integer convertEnumValueQSP(Integer qsp) {
        if (qsp == null) {
            return new Integer(50);
        }
        switch (qsp) {
            case 10: {
                return new Integer(10);
            }
            case 20: {
                return new Integer(20);
            }
            case 30: {
                return new Integer(30);
            }
            case 40: {
                return new Integer(40);
            }
        }
        return new Integer(50);
    }

    private Integer convertEnumValueCalPattern(Integer calPattern) {
        if (calPattern == null) {
            return null;
        }
        switch (calPattern) {
            case 10: {
                return new Integer(10);
            }
            case 20: {
                return new Integer(20);
            }
        }
        return null;
    }

    private Integer convertEnumValuePricingPattern(Integer pricingPattern) {
        if (pricingPattern == null) {
            return null;
        }
        switch (pricingPattern) {
            case 10: {
                return new Integer(20);
            }
            case 20: {
                return new Integer(10);
            }
        }
        return null;
    }

    private Map getPurConRowFromRs(IRowSet rs) throws SQLException {
        this.purEntryIds.add(rs.getString("entryId"));
        HashMap<String, Object> purMap = new HashMap<String, Object>();
        for (int i = 0; i < HQHPUtil.getPurCols().size(); ++i) {
            String object = (String)HQHPUtil.getPurCols().get(i);
            purMap.put(object, rs.getObject(object));
        }
        return purMap;
    }

    private Map getReportRowFromRs(IRowSet rs) throws SQLException {
        HashMap<String, Object> reportMap = new HashMap<String, Object>();
        for (int i = 0; i < HQHPUtil.getQCCols().size(); ++i) {
            String object = (String)HQHPUtil.getQCCols().get(i);
            reportMap.put(object, rs.getObject(object));
        }
        reportMap.put("recEntryID", rs.getObject("recEntryID"));
        reportMap.put("requestID", rs.getObject("requestID"));
        reportMap.put("materialID", rs.getObject("materialID"));
        return reportMap;
    }

    @Override
    protected Map _genCalBills(Context ctx, Map params) throws BOSException, EASBizException {
        this.params = params;
        this.ctx = ctx;
        List entryIDs = (List)params.get("purEntryIDs");
        if (entryIDs.size() != 0) {
            this.allUnSelectWBs = this.mergeAllUnSelectedWBs(params);
            this.qcReportInfoMaps = this.getQCReportRelMaps();
            this.qcReportColls = this.getQCReportColls();
            this.recMaps = this.getRecMaps();
        }
        this.verifyBeforeGenBills();
        PurContractEntryCollection purEntryCollection = this.getPurEntryCollection(ctx);
        Map isWeighMap = this.getDynaIsWeighs(purEntryCollection);
        CoreBaseCollection collections = this.genCalBillColletcion(purEntryCollection, isWeighMap);
        Map result = this.verifyAndCalBill(collections);
        this.writeAddNewLog(collections);
        return result;
    }

    private Set mergeAllUnSelectedWBs(Map params) {
        HashSet all = new HashSet();
        Map unSelectWBs = (Map)params.get("Choose_UnSelectedWBs");
        for (Object key : unSelectWBs.keySet()) {
            Set unSelectedWBSet = (Set)unSelectWBs.get(key);
            Iterator it = unSelectedWBSet.iterator();
            while (it.hasNext()) {
                all.add(it.next());
            }
        }
        return all;
    }

    private void verifyBeforeGenBills() throws BOSException {
        List purIDs = (List)this.params.get("purIDs");
        List entryIDs = (List)this.params.get("purEntryIDs");
        Map purInfos = (Map)this.params.get("Choose_PurInfos");
        Map filterParams = (Map)this.params.get("filterParas");
        Boolean paramIsWeigh = (Boolean)filterParams.get("Para_IsWeigh");
        Map recRowLists = (Map)this.params.get("selectedReports");
        Set passReportIds = this.searchPassReports();
        block0: for (int i = purIDs.size() - 1; i >= 0; --i) {
            int j;
            String purId = (String)purIDs.get(i);
            String entryId = (String)entryIDs.get(i);
            String tmpId = purId + entryId;
            List recRows = (List)recRowLists.get(tmpId);
            if (paramIsWeigh != null && paramIsWeigh.booleanValue()) {
                for (j = recRows.size() - 1; j >= 0; --j) {
                    Map reportRow = (Map)recRows.get(j);
                    if (reportRow.get("billStatus") != null && reportRow.get("billStatus").toString().equals("30")) continue;
                    recRows.remove(j);
                }
            }
            if (HQHPUtil.isNullList(recRows)) {
                HQHPMsg msg;
                List purInfo = (List)purInfos.get(tmpId);
                if (paramIsWeigh != null && paramIsWeigh.booleanValue()) {
                    msg = new HQHPMsg("Verify_CannotGenWithNoReport", new String[]{(String)purInfo.get(4)});
                    this.errorMsgs.add(msg);
                } else {
                    msg = new HQHPMsg("Verify_CannotGenWithNoRecBill", new String[]{(String)purInfo.get(4)});
                    this.errorMsgs.add(msg);
                }
                purIDs.remove(i);
                entryIDs.remove(i);
                recRowLists.remove(tmpId);
                continue;
            }
            for (j = 0; j < recRows.size(); ++j) {
                HQHPMsg msg;
                Map recRow = (Map)recRows.get(j);
                BigDecimal billStatus = null;
                BigDecimal sampleSolution = null;
                if (recRow.get("billStatus") != null) {
                    billStatus = new BigDecimal(recRow.get("billStatus").toString());
                }
                if (recRow.get("sampleSolution") != null) {
                    sampleSolution = new BigDecimal(recRow.get("sampleSolution").toString());
                }
                String reportId = (String)recRow.get("reportID");
                String materialID = (String)recRow.get("materialID");
                String tempKey = materialID + reportId;
                if (paramIsWeigh != null && paramIsWeigh.booleanValue() && !this.qcReportInfoMaps.containsKey(tempKey)) continue;
                if (reportId == null || billStatus != null && billStatus.intValue() != 30) {
                    msg = new HQHPMsg("Verify_CannotGenWithUnAuditBill", new String[]{(String)recRow.get("recBillNumber")});
                    this.errorMsgs.add(msg);
                    purIDs.remove(i);
                    entryIDs.remove(i);
                    recRowLists.remove(tmpId);
                    continue block0;
                }
                if (sampleSolution != null && sampleSolution.intValue() != 20) {
                    msg = new HQHPMsg("Verify_CannotGenWithAllCheck", new String[]{(String)recRow.get("recBillNumber"), (String)recRow.get("number")});
                    this.errorMsgs.add(msg);
                    purIDs.remove(i);
                    entryIDs.remove(i);
                    recRowLists.remove(tmpId);
                    continue block0;
                }
                if (reportId == null || passReportIds.contains(reportId)) continue;
                msg = new HQHPMsg("Verify_CannotGenWithUnPassReport", new String[]{(String)recRow.get("recBillNumber"), (String)recRow.get("number")});
                this.errorMsgs.add(msg);
                purIDs.remove(i);
                entryIDs.remove(i);
                recRowLists.remove(tmpId);
                continue block0;
            }
        }
    }

    private Set searchPassReports() throws BOSException {
        HashSet reportIds = new HashSet();
        Map qcReportLists = (Map)this.params.get("selectedReports");
        for (String purID : qcReportLists.keySet()) {
            List qcReportList = (List)qcReportLists.get(purID);
            if (HQHPUtil.isNullList(qcReportList)) continue;
            for (int i = 0; i < qcReportList.size(); ++i) {
                Map qcReport = (Map)qcReportList.get(i);
                if (qcReport.get("reportID") == null) continue;
                reportIds.add(qcReport.get("reportID"));
            }
        }
        if (reportIds.size() == 0) {
            return reportIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select report.fid,REPORT.FCHECKRESULT,report.FRejectProcessMode,NCPR.PURBIZ \n");
        sql.append("from t_qm_qcreport as report \n");
        sql.append("LEFT OUTER JOIN (  \n");
        sql.append("    SELECT NCPRENTRY.FPARENTID AS NCPRPARENTID,DPMODE.FQCPURBIZ AS PURBIZ \n");
        sql.append("    FROM T_QM_QCREPORTNCPPRENTRY AS NCPRENTRY \n");
        sql.append("    INNER JOIN T_QM_DPPROCESSMODE AS DPMODE \n");
        sql.append("    ON NCPRENTRY.FDPPROCESSMODEID = DPMODE.FID \n");
        sql.append(") AS NCPR \n");
        sql.append("ON REPORT.FID = NCPR.NCPRPARENTID \n");
        sql.append("where report.fid in (").append(HQHPUtil.getInSQLFromSet(reportIds)).append(") \n");
        sql.append("order by report.fid \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        return this.removeUnPassReports(rs, reportIds);
    }

    private Set removeUnPassReports(IRowSet rs, Set reportIds) throws BOSException {
        try {
            while (rs.next()) {
                String reportId = rs.getString("fid");
                int checkResult = rs.getInt("FCHECKRESULT");
                int rejectProcessMode = rs.getInt("FRejectProcessMode");
                int purBiz = rs.getInt("PURBIZ");
                if (checkResult != 20 || purBiz != 3 && (rejectProcessMode != 20 || purBiz != 0)) continue;
                reportIds.remove(reportId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return reportIds;
    }

    private void writeAddNewLog(CoreBaseCollection collections) {
        if (collections == null || collections.size() == 0) {
            return;
        }
        for (int i = 0; i < collections.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)collections.get(i);
            IObjectPK pk = LogUtil.beginLog((Context)this.ctx, (String)"addNew", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"qm_HQHPCalBill_addNew");
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)pk);
        }
    }

    private void addPercentWeightInfo(CoreBaseCollection collections) throws EASBizException, BOSException {
        for (int i = 0; i < collections.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)collections.get(i);
            if (!this.isCal) {
                this.addSettleQuanSInfo(info);
            }
            HQHPUtil.calcPercentWeight(this.ctx, info);
        }
    }

    private void addSettleQuanSInfo(HQHPCalBillInfo info) throws EASBizException, BOSException {
        BigDecimal settleQuanS = ZERO;
        boolean isWeighted = info.isIsWeigh();
        QuanSettlePatternEnum quanSettlePattern = info.getQuanSettlePattern();
        HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            HQHPCalBillQcReportEntryInfo reportEntry = qcReportEntry.get(i);
            if (reportEntry.getSettleQuanS() != null) continue;
            String reportId = reportEntry.getQcPurReport().getId().toString();
            if (!isWeighted) {
                QCReportInfo qcReport = this.getQcReportFromCollection(reportId);
                settleQuanS = qcReport.getDeliverQty();
                settleQuanS = QMUnitConvertHelper.convertQtyByUnit(this.ctx, info.getPurContractEntry().getMaterial().getId().toString(), qcReport.getUnit().getId().toString(), info.getPurContractEntry().getUnit().getId().toString(), settleQuanS);
            } else {
                this.netWeighAmounts = new HashMap();
                this.dryWeighAmounts = new HashMap();
                this.getRelWeighDetails(info);
                BigDecimal netWeight = (BigDecimal)this.netWeighAmounts.get(reportId);
                if (QuanSettlePatternEnum.NETWEIGHT.equals((Object)quanSettlePattern)) {
                    settleQuanS = netWeight;
                } else if (QuanSettlePatternEnum.DRYWEIGHT.equals((Object)quanSettlePattern)) {
                    settleQuanS = (BigDecimal)this.dryWeighAmounts.get(reportId);
                } else if (QuanSettlePatternEnum.SUPPLIERQTY.equals((Object)quanSettlePattern)) {
                    settleQuanS = this.getSupplierQtyByReport(info, reportEntry);
                } else if (QuanSettlePatternEnum.SUPPLIERDRYWEIGHT.equals((Object)quanSettlePattern)) {
                    settleQuanS = this.getSupplierQtyByReport(info, reportEntry);
                }
            }
            settleQuanS = settleQuanS.setScale(this.qtyScale, 4);
            reportEntry.setSettleQuanS(settleQuanS);
        }
    }

    @Override
    protected Map _calBills(Context ctx, IObjectPK[] ids) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.isCal = true;
        CoreBaseCollection collections = this.getHQHPBillCollections(ids);
        List clearBillList = this.clearAdjustInfo(collections);
        this.params = this.getParams(collections);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i].toString());
        }
        String inIds = HQHPUtil.getInSQLFromSet(idSet);
        this.qcReportInfoMaps = this.getQCReportRelMapsWhenAddReport(inIds);
        this.qcReportColls = this.getQCReportColls();
        this.recMaps = this.getRecMaps();
        Map calResult = this.verifyAndCalBill(collections);
        calResult.put("clearAdjustBills", clearBillList);
        IObjectPK[] pks = (IObjectPK[])calResult.get("resultBillIDs");
        this.writeListcalLog(collections, pks);
        return calResult;
    }

    private void writeListcalLog(CoreBaseCollection collections, IObjectPK[] pks) {
        for (int i = 0; i < collections.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)collections.get(i);
            IObjectPK pk = LogUtil.beginLog((Context)this.ctx, (String)"calBill", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"qm_HQHPCalBill_calPrice");
            if (!this.isCalSucessId(info.getId().toString(), pks)) continue;
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)pk);
        }
    }

    private boolean isCalSucessId(String id, IObjectPK[] pks) {
        if (pks == null || pks.length == 0) {
            return false;
        }
        for (int i = 0; i < pks.length; ++i) {
            if (!id.equals(pks[i].toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Map _calBillWhenEdit(Context ctx, HQHPCalBillInfo info) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.isCal = true;
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"calBillWhenEdit", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"qm_HQHPCalBill_calPrice");
        CoreBaseCollection collections = new CoreBaseCollection();
        collections.add((CoreBaseInfo)info);
        List clearBillList = this.clearAdjustInfo(collections);
        this.params = this.getParams(collections);
        HashSet<String> inIdSet = new HashSet<String>();
        inIdSet.add(info.getId().toString());
        String inIds = HQHPUtil.getInSQLFromSet(inIdSet);
        this.qcReportInfoMaps = this.getQCReportRelMapsWhenAddReport(inIds);
        this.qcReportColls = this.getQCReportColls();
        this.recMaps = this.getRecMaps();
        Map calResult = this.verifyAndCalBill(collections);
        calResult.put("clearAdjustBills", clearBillList);
        IObjectPK[] pks = (IObjectPK[])calResult.get("resultBillIDs");
        if (pks != null && pks.length != 0 && pks[0].toString().equals(info.getId().toString())) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
        return calResult;
    }

    private CoreBaseCollection getHQHPBillCollections(IObjectPK[] ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getHQHPBillSelectors());
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i].toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        HQHPCalBillCollection calBillCollection = HQHPCalBillFactory.getLocalInstance(this.ctx).getHQHPCalBillCollection(view);
        CoreBaseCollection result = new CoreBaseCollection();
        result.addObjectCollection((IObjectCollection)calBillCollection);
        return result;
    }

    private SelectorItemCollection getHQHPBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("purContract.id");
        sic.add("purContract.number");
        sic.add("purContractEntry.id");
        sic.add("purContractEntry.taxPrice");
        sic.add("purContractEntry.protectPrice");
        sic.add("purContractEntry.material.id");
        sic.add("purContractEntry.material.isWeighted");
        sic.add("purContractEntry.material.baseUnit.coefficient");
        sic.add("purContractEntry.unit.coefficient");
        sic.add("purContractEntry.unit.id");
        sic.add("qcReportEntry.id");
        sic.add("qcReportEntry.qcPurReport.deliverQty");
        sic.add("qcReportEntry.qcPurReport.unit.id");
        sic.add("qcReportEntry.qcPurReport.id");
        sic.add("qcReportEntry.qcPurReport.requestID");
        sic.add("qcReportEntry.qcPurReport.entrys.id");
        sic.add("qcReportEntry.qcPurReport.entrys.qCItem.id");
        sic.add("qcReportEntry.qcPurReport.entrys.qCItem.dataPrecision");
        sic.add("qcReportEntry.qcPurReport.entrys.checkValue");
        sic.add("qcReportEntry.recBill.id");
        sic.add("qcReportEntry.recBill.number");
        sic.add("qcReportEntry.recBillEntry.id");
        sic.add("settleTermEntry.id");
        sic.add("settleTermEntry.*");
        sic.add("settleTermEntry.qcItem.id");
        sic.add("settleTermEntry.qcItem.number");
        sic.add("settleTermEntry.qcItem.name");
        sic.add("settleTermEntry.qcItem.dataPrecision");
        return sic;
    }

    private List clearAdjustInfo(CoreBaseCollection collections) {
        ArrayList<String> clearBills = new ArrayList<String>();
        for (int i = 0; i < collections.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)collections.get(i);
            if (info.getAdjustDate() == null) continue;
            HQHPUtil.clearAdjustInfo(info);
            clearBills.add(info.getNumber());
        }
        return clearBills;
    }

    private Map getParams(CoreBaseCollection collections) {
        HashMap params = new HashMap();
        HashMap reports = new HashMap();
        for (int i = 0; i < collections.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)collections.get(i);
            String purMapID = info.getPurContract().getId().toString() + info.getPurContractEntry().getId().toString();
            String materialID = info.getPurContractEntry().getMaterial().getId().toString();
            ArrayList reportMaps = new ArrayList();
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(j);
                QCReportInfo qcPurReport = calBillQcReportEntryInfo.getQcPurReport();
                HashMap<String, String> reportMap = new HashMap<String, String>();
                reportMap.put("reportID", qcPurReport.getId().toString());
                reportMap.put("requestID", qcPurReport.getRequestID());
                reportMap.put("materialID", materialID);
                reportMap.put("recBillID", calBillQcReportEntryInfo.getRecBill().getId().toString());
                reportMap.put("recBillNumber", calBillQcReportEntryInfo.getRecBill().getNumber());
                reportMap.put("recEntryID", calBillQcReportEntryInfo.getRecBillEntry().getId().toString());
                reportMaps.add(reportMap);
            }
            reports.put(purMapID, reportMaps);
        }
        params.put("selectedReports", reports);
        return params;
    }

    private PurContractEntryCollection getPurEntryCollection(Context ctx) throws BOSException {
        List purIDs = (List)this.params.get("purIDs");
        List entryIDs = (List)this.params.get("purEntryIDs");
        EntityViewInfo entryView = new EntityViewInfo();
        entryView.setSelector(this.getPurEntrySelectors());
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("id", new HashSet(entryIDs), CompareType.INCLUDE));
        filter2.getFilterItems().add(new FilterItemInfo("parent.id", new HashSet(purIDs), CompareType.INCLUDE));
        entryView.setFilter(filter2);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("parent.purOrgUnit.name"));
        sorter.add(new SorterItemInfo("parent.supplier.name"));
        sorter.add(new SorterItemInfo("material.name"));
        sorter.add(new SorterItemInfo("parent.number"));
        entryView.setSorter(sorter);
        PurContractEntryCollection purContractEntryCollection = PurContractEntryFactory.getLocalInstance((Context)ctx).getPurContractEntryCollection(entryView);
        return purContractEntryCollection;
    }

    private SelectorItemCollection getPurEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.purOrgUnit.name");
        sic.add("parent.supplier.name");
        sic.add("material.id");
        sic.add("material.name");
        sic.add("material.baseUnit.coefficient");
        sic.add("unit.coefficient");
        sic.add("unit.id");
        sic.add("isWeigh");
        sic.add("parent.purOrgUnit.id");
        sic.add("parent.purOrgUnit.number");
        sic.add("material.isWeighted");
        sic.add("taxPrice");
        sic.add("protectPrice");
        sic.add("entries4.*");
        sic.add("entries4.id");
        sic.add("entries4.qcItem.id");
        sic.add("entries4.qcItem.number");
        sic.add("entries4.qcItem.name");
        sic.add("entries4.qcItem.dataPrecision");
        sic.add("entries4.comparator1");
        sic.add("entries4.comparator2");
        sic.add("entries4.lowRange");
        sic.add("entries4.upperRange");
        sic.add("entries4.baseValue");
        sic.add("entries4.basePrice");
        sic.add("entries4.floatValue");
        sic.add("entries4.floatPrice");
        sic.add("entries4.settlementPriceType");
        return sic;
    }

    private Map getReportRelWeighRow(IRowSet rs) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        String[] cols = new String[]{"netWeight", "incidental", "unit", "wbID"};
        for (int i = 0; i < cols.length; ++i) {
            row.put(cols[i], rs.getObject(cols[i]));
        }
        return row;
    }

    private CoreBaseCollection genCalBillColletcion(PurContractEntryCollection purEntries, Map isWeighMap) throws EASBizException, BOSException {
        CoreBaseCollection calBills = new CoreBaseCollection();
        Iterator it = purEntries.iterator();
        Map purInfos = (Map)this.params.get("Choose_PurInfos");
        Map filterParams = (Map)this.params.get("filterParas");
        Boolean paramIsWeigh = (Boolean)filterParams.get("Para_IsWeigh");
        while (it.hasNext()) {
            Map filters;
            Boolean isWeigh;
            HQHPCalBillInfo info = new HQHPCalBillInfo();
            PurContractEntryInfo purContractEntryInfo = (PurContractEntryInfo)it.next();
            PurContractInfo purContractInfo = purContractEntryInfo.getParent();
            String purMapID = purContractInfo.getId().toString() + purContractEntryInfo.getId().toString();
            Map selectedReports = (Map)this.params.get("selectedReports");
            List reportRowMaps = (List)selectedReports.get(purMapID);
            String materialId = purContractEntryInfo.getMaterial().getId().toString();
            if (paramIsWeigh != null && paramIsWeigh.booleanValue()) {
                for (int j = reportRowMaps.size() - 1; j >= 0; --j) {
                    Map reportRowMap = (Map)reportRowMaps.get(j);
                    String reportid = reportRowMap.get("reportID") == null ? "" : reportRowMap.get("reportID").toString();
                    String tempKey = materialId + reportid;
                    if (this.qcReportInfoMaps.containsKey(tempKey)) continue;
                    reportRowMaps.remove(j);
                }
            }
            if (reportRowMaps.size() == 0) {
                HQHPMsg errorMsg = new HQHPMsg("Verify_CannotGenWithNoReport", new String[]{purContractInfo.getNumber()});
                this.errorMsgs.add(errorMsg);
                continue;
            }
            List purInfo = (List)purInfos.get(purMapID);
            info.setPurOrgUnit(purContractInfo.getPurOrgUnit());
            info.setCalBillDate(new Date());
            info.setBillStatus(QMBillBaseStatusEnum.SAVE);
            info.setPurContract(purContractInfo);
            info.setPurContractEntry(purContractEntryInfo);
            if (purInfo != null && purInfo.size() == 5) {
                Integer deductCalFomula;
                Integer pricingPatternValue;
                Integer quanValue = (Integer)purInfo.get(0);
                if (quanValue != null) {
                    info.setQuanSettlePattern(QuanSettlePatternEnum.getEnum(quanValue));
                } else {
                    info.setQuanSettlePattern(QuanSettlePatternEnum.ISNULL);
                }
                Integer calPatternValue = (Integer)purInfo.get(1);
                if (calPatternValue != null) {
                    info.setBalanceCalPattern(BalanceCalPatternEnum.getEnum(calPatternValue));
                }
                if ((pricingPatternValue = (Integer)purInfo.get(2)) != null) {
                    info.setPricingPattern(PricingPatternEnum.getEnum(pricingPatternValue));
                }
                if ((deductCalFomula = (Integer)purInfo.get(3)) != null) {
                    info.setDeductCalFomula(DeductCalFomulaEnum.getEnum(deductCalFomula));
                }
            }
            if ((isWeigh = (Boolean)(filters = (Map)this.params.get("filterParas")).get("Para_IsWeigh")) != null && isWeigh.booleanValue()) {
                info.setRecBizDateBegin((Date)filters.get("Para_WeighDateBegin"));
                info.setRecBizDateEnd((Date)filters.get("Para_WeighDateEnd"));
            } else {
                info.setRecBizDateBegin((Date)filters.get("recBillDateBegin"));
                info.setRecBizDateEnd((Date)filters.get("recBillDateEnd"));
            }
            info.setIsCaled(false);
            info.setIsSubmitted(false);
            info.setIsWeigh(this.getDynaIsWeigh(purContractEntryInfo.getId().toString(), isWeighMap));
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            info.setCreateTime(new Timestamp(new Date().getTime()));
            this.initPriceScale(purContractInfo.getPurOrgUnit().getId().toString());
            info.setUnitPrice(HQHPUtil.getPriceInScale(purContractEntryInfo.getTaxPrice(), this.priceScale));
            info.setProtectivePrice(HQHPUtil.getPriceInScale(purContractEntryInfo.getProtectPrice(), this.priceScale));
            HQHPCalBillSettleTermEntryCollection settleTermEntry = info.getSettleTermEntry();
            PurContractSettleTermsNorCollection entries4 = purContractEntryInfo.getEntries4();
            for (int i = 0; i < entries4.size(); ++i) {
                PurContractSettleTermsNorInfo purContractSettlementTermsInfo = entries4.get(i);
                HQHPCalBillSettleTermEntryInfo hqhpSettleTermEntry = new HQHPCalBillSettleTermEntryInfo();
                hqhpSettleTermEntry.setQcItem(purContractSettlementTermsInfo.getQcItem());
                hqhpSettleTermEntry.setComparator1(purContractSettlementTermsInfo.getComparator1());
                hqhpSettleTermEntry.setComparator2(purContractSettlementTermsInfo.getComparator2());
                hqhpSettleTermEntry.setLowRange(purContractSettlementTermsInfo.getLowRange());
                hqhpSettleTermEntry.setUpperRange(purContractSettlementTermsInfo.getUpperRange());
                hqhpSettleTermEntry.setSettlementPriceType(purContractSettlementTermsInfo.getSettlementPriceType());
                BigDecimal baseValue = purContractSettlementTermsInfo.getBaseValue();
                hqhpSettleTermEntry.setBaseValue(baseValue);
                BigDecimal basePrice = purContractSettlementTermsInfo.getBasePrice();
                hqhpSettleTermEntry.setBasePrice(basePrice);
                BigDecimal floatValue = purContractSettlementTermsInfo.getFloatValue();
                hqhpSettleTermEntry.setFloatValue(floatValue);
                BigDecimal floatPrice = purContractSettlementTermsInfo.getFloatPrice();
                hqhpSettleTermEntry.setFloatPrice(floatPrice);
                settleTermEntry.add(hqhpSettleTermEntry);
            }
            int calPattern = (Integer)filters.get("calPattern");
            if (20 == calPattern) {
                HQHPCalBillQcReportEntryCollection hqhpQcReportEntries = info.getQcReportEntry();
                for (int i = 0; i < reportRowMaps.size(); ++i) {
                    HQHPCalBillQcReportEntryInfo hqhpQcReportEntry = new HQHPCalBillQcReportEntryInfo();
                    Map qcReportRowMap = (Map)reportRowMaps.get(i);
                    QCReportInfo qcReportInfo = new QCReportInfo();
                    qcReportInfo.setId(BOSUuid.read((String)((String)qcReportRowMap.get("reportID"))));
                    hqhpQcReportEntry.setQcPurReport(qcReportInfo);
                    PurReceivalBillInfo recBillInfo = new PurReceivalBillInfo();
                    recBillInfo.setId(BOSUuid.read((String)((String)qcReportRowMap.get("recBillID"))));
                    hqhpQcReportEntry.setRecBill(recBillInfo);
                    PurReceivalEntryInfo recBillEntry = new PurReceivalEntryInfo();
                    recBillEntry.setId(BOSUuid.read((String)((String)qcReportRowMap.get("recEntryID"))));
                    hqhpQcReportEntry.setRecBillEntry(recBillEntry);
                    hqhpQcReportEntry.setConPriceRec(HQHPUtil.getPriceInScale((BigDecimal)qcReportRowMap.get("conPriceRec"), this.priceScale));
                    BigDecimal netWeightAmount = this.getNetWeightFromReport(isWeigh, materialId + (String)qcReportRowMap.get("reportID"));
                    hqhpQcReportEntry.setNetWeightAmount(netWeightAmount);
                    hqhpQcReportEntries.add(hqhpQcReportEntry);
                }
                this.getCodingRuleStrategy().initNumber((ISuportCodingRule)this, this.ctx, (ISuportCodingRuleInfo)info);
                calBills.add((CoreBaseInfo)info);
                continue;
            }
            if (10 != calPattern) continue;
            for (int i = 0; i < reportRowMaps.size(); ++i) {
                HQHPCalBillInfo cloneInfo = (HQHPCalBillInfo)info.clone();
                HQHPCalBillQcReportEntryCollection qcReportEntry = cloneInfo.getQcReportEntry();
                HQHPCalBillQcReportEntryInfo hqhpQcReportEntry = new HQHPCalBillQcReportEntryInfo();
                Map qcReportRowMap = (Map)reportRowMaps.get(i);
                QCReportInfo qcReportInfo = new QCReportInfo();
                qcReportInfo.setId(BOSUuid.read((String)((String)qcReportRowMap.get("reportID"))));
                hqhpQcReportEntry.setQcPurReport(qcReportInfo);
                PurReceivalBillInfo recBillInfo = new PurReceivalBillInfo();
                recBillInfo.setId(BOSUuid.read((String)((String)qcReportRowMap.get("recBillID"))));
                hqhpQcReportEntry.setRecBill(recBillInfo);
                PurReceivalEntryInfo recBillEntry = new PurReceivalEntryInfo();
                recBillEntry.setId(BOSUuid.read((String)((String)qcReportRowMap.get("recEntryID"))));
                hqhpQcReportEntry.setRecBillEntry(recBillEntry);
                hqhpQcReportEntry.setConPriceRec(HQHPUtil.getPriceInScale((BigDecimal)qcReportRowMap.get("conPriceRec"), this.priceScale));
                BigDecimal netWeightAmount = this.getNetWeightFromReport(isWeigh, materialId + (String)qcReportRowMap.get("reportID"));
                hqhpQcReportEntry.setNetWeightAmount(netWeightAmount);
                qcReportEntry.add(hqhpQcReportEntry);
                this.getCodingRuleStrategy().initNumber((ISuportCodingRule)this, this.ctx, (ISuportCodingRuleInfo)cloneInfo);
                calBills.add((CoreBaseInfo)cloneInfo);
            }
        }
        return calBills;
    }

    private BigDecimal getNetWeightFromReport(Boolean isWeigh, String key) {
        BigDecimal netWeightAmout = ZERO;
        if (isWeigh != null && isWeigh.booleanValue()) {
            List relWeighInfoList = (List)this.qcReportInfoMaps.get(key);
            if (relWeighInfoList == null) {
                return netWeightAmout;
            }
            for (int j = 0; j < relWeighInfoList.size(); ++j) {
                Map relWeighInfo = (Map)relWeighInfoList.get(j);
                BigDecimal netWeight = (BigDecimal)relWeighInfo.get("netWeight");
                netWeightAmout = netWeightAmout.add(netWeight);
            }
        }
        return netWeightAmout;
    }

    private Map getDynaIsWeighs(PurContractEntryCollection purEntryCollection) throws BOSException {
        if (purEntryCollection == null || purEntryCollection.size() == 0) {
            return null;
        }
        HashSet<String> purEntryIds = new HashSet<String>();
        for (int i = 0; i < purEntryCollection.size(); ++i) {
            purEntryIds.add(purEntryCollection.get(i).getId().toString());
        }
        if (purEntryIds.size() == 0) {
            return null;
        }
        String sql = "select fid,cfisweigh from t_sm_PurcontractEntry where fid in (" + HQHPUtil.getInSQLFromSet(purEntryIds) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        try {
            while (rs.next()) {
                result.put(rs.getObject("fid"), rs.getObject("cfisweigh"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private boolean getDynaIsWeigh(String purEntryId, Map isWeighMap) {
        if (StringUtils.isEmpty((String)purEntryId)) {
            return false;
        }
        if (isWeighMap == null) {
            return false;
        }
        Object isWeigh = isWeighMap.get(purEntryId);
        if (isWeigh == null) {
            return false;
        }
        return new BigDecimal(isWeigh.toString()).compareTo(new BigDecimal("1")) == 0;
    }

    private Map verifyAndCalBill(CoreBaseCollection collections) throws BOSException, EASBizException {
        Map recRelWeighBill = this.getRecRelWeighBill(collections);
        this.verifyCalBill(recRelWeighBill, collections);
        CoreBaseCollection saveBills = this.calBill(collections);
        this.addPercentWeightInfo(collections);
        IHQHPCalBill iBiz = HQHPCalBillFactory.getLocalInstance(this.ctx);
        IObjectPK[] pks = new IObjectPK[]{};
        if (saveBills.size() > 0) {
            pks = iBiz.saveBatchData(saveBills);
        }
        this.saveRelToWeighBill(this.ctx, saveBills);
        this.updateRelInfo(saveBills);
        HashMap<String, Object> genResult = new HashMap<String, Object>();
        genResult.put("resultError", this.errorMsgs);
        genResult.put("resultBillIDs", pks);
        if (!this.isCal) {
            genResult.put("resultCalCount", new Integer(this.calSuccessCount));
        }
        return genResult;
    }

    private void saveRelToWeighBill(Context ctx, CoreBaseCollection saveBills) throws BOSException {
        ArrayList<String> sqls = new ArrayList<String>();
        for (int i = 0; i < saveBills.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)saveBills.get(i);
            String materialId = info.getPurContractEntry().getMaterial().getId().toString();
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                HashSet<String> wbIds = new HashSet<String>();
                String qcReportId = qcReportEntry.get(j).getQcPurReport().getId().toString();
                String key = materialId + qcReportId;
                List reportRelWeighRows = (List)this.qcReportInfoMaps.get(key);
                if (reportRelWeighRows == null) continue;
                int size = reportRelWeighRows.size();
                for (int k = 0; k < size; ++k) {
                    Map row = (Map)reportRelWeighRows.get(k);
                    Object wbId = row.get("wbID");
                    if (wbId == null) continue;
                    wbIds.add(wbId.toString());
                }
                if (wbIds.size() <= 0) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("update t_wm_weighbill set FIsGenHqHpCalBill = 1, FHQHPCalBillID='").append(info.getId().toString());
                sql.append("' where fid in (").append(HQHPUtil.getInSQLFromSet(wbIds)).append(") ");
                sqls.add(sql.toString());
            }
        }
        HQHPUtil.executeBatch(ctx, sqls);
    }

    private Map getRecRelWeighBill(CoreBaseCollection collections) throws BOSException {
        HashMap recMap = new HashMap();
        HashSet<String> recEntryIds = new HashSet<String>();
        HashSet<String> calBills = new HashSet<String>();
        for (int i = 0; i < collections.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)collections.get(i);
            if (this.isCal && info.getId() != null) {
                calBills.add(info.getId().toString());
            }
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                String recEntryId = qcReportEntry.get(j).getRecBillEntry().getId().toString();
                recEntryIds.add(recEntryId);
            }
        }
        if (recEntryIds.size() == 0) {
            return recMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select recEntry.fid as recId, material.").append(nameCol);
        sql.append(" as mname,rec.fnumber as recNumber, weighBill.fnumber as wmNumber \n");
        sql.append("from T_IM_PURRECEIVALENTRY as recEntry \n");
        sql.append("inner join t_bd_material as material \n");
        sql.append("on material.fid = recEntry.fmaterialid \n");
        sql.append("inner join T_IM_PURRECEIVALBILL as rec \n");
        sql.append("on recEntry.fparentid = rec.fid \n");
        sql.append("left outer join T_QM_QCREQUESTENTRY as reqEntry \n");
        sql.append("on reqEntry.FSOURCEBILLENTRYID = recEntry.fid \n");
        sql.append("left outer join T_QM_QCREQUESTRELWEIGHENTRY as reqRelWeighEntry \n");
        sql.append("on reqEntry.fid = reqRelWeighEntry.FMATERIALENTRYID \n");
        sql.append("left outer join T_WM_WEIGHBILL as weighBill \n");
        sql.append("on reqRelWeighEntry.FRELNOTICEENTRYID = weighBill.FSOURCEBILLENTRYID \n");
        sql.append("where recEntry.fid in (").append(HQHPUtil.getInSQLFromSet(recEntryIds)).append(") \n");
        sql.append("and weighBill.fbillStatus = ").append(30).append(" \n");
        if (!this.isCal) {
            if (this.allUnSelectWBs != null && this.allUnSelectWBs.size() > 0) {
                sql.append("    and weighbill.fid not in (").append(HQHPUtil.getInSQLFromSet(this.allUnSelectWBs)).append(") \n");
            }
        } else if (calBills.size() > 0) {
            sql.append("    and weighbill.FHQHPCalBillID in (").append(HQHPUtil.getInSQLFromSet(calBills)).append(") \n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                ArrayList<String> v = new ArrayList<String>();
                v.add(rs.getString("mname"));
                v.add(rs.getString("recNumber"));
                v.add(rs.getString("wmNumber"));
                recMap.put(rs.getString("recId"), v);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return recMap;
    }

    private void updateRelInfo(CoreBaseCollection bills) throws BOSException {
        ArrayList<String> sqls = new ArrayList<String>();
        for (int i = 0; i < bills.size(); ++i) {
            HQHPCalBillInfo info = (HQHPCalBillInfo)bills.get(i);
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            StringBuffer reportIds = new StringBuffer();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                String qcReportID = qcReportEntry.get(j).getQcPurReport().getId().toString();
                reportIds.append("'" + qcReportID + "'");
                if (j == qcReportEntry.size() - 1) continue;
                reportIds.append(",");
            }
            StringBuffer updateRel = new StringBuffer();
            updateRel.append("update t_qm_qcreport set fsumbillnumberid = '").append(info.getId().toString()).append("'");
            if (this.isCaledBill(info)) {
                updateRel.append(", FIsCalBalPrice = 1");
            }
            updateRel.append(" where fid in (").append(reportIds).append(")");
            sqls.add(updateRel.toString());
        }
        HQHPUtil.executeBatch(this.ctx, sqls);
    }

    private boolean isCaledBill(HQHPCalBillInfo info) {
        return this.calSuccessBills.contains((CoreBaseInfo)info);
    }

    private Map getQCReportRelMapsWhenAddReport(String calBillId) throws BOSException {
        Boolean isWeigh;
        this.reportIDs = new HashSet();
        HashSet requestIDs = new HashSet();
        this.recIDs = new HashSet();
        HashSet materialSet = new HashSet();
        Map qcReportLists = (Map)this.params.get("selectedReports");
        for (String purID : qcReportLists.keySet()) {
            List qcReportList = (List)qcReportLists.get(purID);
            if (HQHPUtil.isNullList(qcReportList)) continue;
            for (int i = 0; i < qcReportList.size(); ++i) {
                Map qcReport = (Map)qcReportList.get(i);
                this.reportIDs.add(qcReport.get("reportID"));
                requestIDs.add(qcReport.get("requestID"));
                this.recIDs.add(qcReport.get("recBillID"));
                materialSet.add(qcReport.get("materialID"));
            }
        }
        String materials = HQHPUtil.getInSQLFromSet(materialSet);
        String reports = HQHPUtil.getInSQLFromSet(this.reportIDs);
        String requests = HQHPUtil.getInSQLFromSet(requestIDs);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT REQ.MATERIAL,REPORT.FID AS REPORTID,REQ.REQUESTID,REQ.NETWEIGHT,REQ.INCIDENTAL,REQ.unit,REQ.wbID,req.calBillid \n");
        sql.append("FROM T_QM_QCREPORT AS REPORT \n");
        sql.append("LEFT OUTER JOIN ( \n");
        sql.append("    SELECT REQWEIGH.MATERIAL,REQWEIGH.REQUESTID, \n");
        sql.append("    WEIGHBILL.FNETWEIGHT AS NETWEIGHT,WEIGHBILL.FINCIDENTAL AS INCIDENTAL,WEIGHBILL.FUnitId as unit, WEIGHBILL.fid as wbID, \n");
        sql.append("    WEIGHBILL.FHQHPCalBillID as calBillid \n");
        sql.append("    FROM T_WM_WEIGHBILL AS WEIGHBILL \n");
        sql.append("    RIGHT OUTER JOIN ( \n");
        sql.append("        SELECT REQ1.FRELNOTICEENTRYID AS REQWEIGHENTRY, REQUESTENTRY1.REQUESTID,REQUESTENTRY1.MATERIAL \n");
        sql.append("        FROM T_QM_QCREQUESTRELWEIGHENTRY AS REQ1 \n");
        sql.append("        RIGHT OUTER JOIN ( \n");
        sql.append("            SELECT REQUEST.FID AS REQUESTID,REQUESTENTRY.FID AS REQUESTENTRYID,REQUESTENTRY.FMATERIALID AS MATERIAL \n");
        sql.append("            FROM T_QM_QCREQUESTENTRY AS REQUESTENTRY \n");
        sql.append("            INNER JOIN T_QM_QCREQUEST AS REQUEST \n");
        sql.append("            ON REQUESTENTRY.FPARENTID = REQUEST.FID \n");
        sql.append("            WHERE REQUEST.FID IN (").append(requests).append(") \n");
        sql.append("            AND REQUESTENTRY.FMATERIALID IN (").append(materials).append(") \n");
        sql.append("        ) AS REQUESTENTRY1 \n");
        sql.append("        ON REQ1.FPARENTID = REQUESTENTRY1.REQUESTID  \n");
        sql.append("           AND REQ1.FMATERIALENTRYID = REQUESTENTRY1.REQUESTENTRYID \n");
        sql.append("    ) AS REQWEIGH \n");
        sql.append("    ON WEIGHBILL.FSOURCEBILLENTRYID = REQWEIGH.REQWEIGHENTRY \n");
        sql.append("    and WEIGHBILL.fbillStatus = ").append(30).append(" \n");
        Map filterParams = (Map)this.params.get("filterParas");
        Date weighDateBegin = (Date)filterParams.get("Para_WeighDateBegin");
        Date weighDateEnd = (Date)filterParams.get("Para_WeighDateEnd");
        if (weighDateBegin != null) {
            sql.append("    and WEIGHBILL.FLatestWeighTime > to_date('").append(HQHPUtil.formatStartDate(weighDateBegin)).append("') \n");
        }
        if (weighDateEnd != null) {
            sql.append("    and WEIGHBILL.FLatestWeighTime < to_date('").append(HQHPUtil.formatEndDate(weighDateEnd)).append("') \n");
        }
        sql.append(") AS REQ \n");
        sql.append("ON REPORT.FREQUESTID = REQ.REQUESTID \n");
        sql.append("WHERE 1=1 \n");
        if (this.isCal) {
            sql.append("and REPORT.FID IN (").append(reports).append(") \n");
        } else {
            sql.append("and REPORT.FID in ( \n");
            sql.append("\tselect distinct report2.fid from t_qm_qcreport as report2 \n");
            sql.append("\tleft outer join t_qm_qcrequestrelweighentry as relweigh2 \n");
            sql.append("\ton relweigh2.FMaterialEntryID = report2.frequestentryid \n");
            sql.append("\tleft outer join t_wm_weighbill as wb2 \n");
            sql.append("\ton wb2.fsourcebillentryid = relweigh2.FRelNoticeEntryID \n");
            sql.append("\twhere (wb2.FHQHPCalBillID is null or wb2.FHQHPCalBillID = '') and  report2.fid in (").append(reports).append(") \n");
            sql.append(") \n");
        }
        if (this.allUnSelectWBs != null && this.allUnSelectWBs.size() > 0) {
            sql.append("    and REQ.wbID not in (").append(HQHPUtil.getInSQLFromSet(this.allUnSelectWBs)).append(") \n");
        } else if (calBillId != null && calBillId.length() > 0) {
            sql.append("    and req.calBillid in (").append(calBillId).append(") \n");
        }
        if (!this.isCal) {
            sql.append("and (req.calBillid is null or req.calBillid = '') \n");
        }
        if ((isWeigh = (Boolean)filterParams.get("Para_IsWeigh")).booleanValue()) {
            sql.append("and req.wbid is not null \n");
        }
        sql.append("ORDER BY REQ.MATERIAL,REPORTID,REQ.REQUESTID \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        Map result = this.getReportRelWeighMap(rs);
        return result;
    }

    private Map getQCReportRelMaps() throws BOSException {
        return this.getQCReportRelMapsWhenAddReport(null);
    }

    private IObjectCollection getQCReportColls() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getReportSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.reportIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        QCReportCollection reportCollection = QCReportFactory.getLocalInstance(this.ctx).getQCReportCollection(view);
        this.removeCancelQCItemFromQCReportColls(reportCollection);
        return reportCollection;
    }

    private void removeCancelQCItemFromQCReportColls(QCReportCollection reportCollection) {
        int size = reportCollection.size();
        for (int i = 0; i < size; ++i) {
            QCReportInfo reportInfo = reportCollection.get(i);
            if (reportInfo == null) continue;
            QCReportEntryCollection entrys = reportInfo.getEntrys();
            for (int j = entrys.size() - 1; j >= 0; --j) {
                QCReportEntryInfo reportEntryInfo = entrys.get(j);
                if (reportEntryInfo == null || !QCResultJudgeEnum.cancel.equals((Object)reportEntryInfo.getCheckResult())) continue;
                entrys.remove(reportEntryInfo);
            }
        }
    }

    private SelectorItemCollection getReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("deliverQty");
        sic.add("unit.id");
        sic.add("entrys.id");
        sic.add("entrys.qCItem.id");
        sic.add("entrys.qCItem.name");
        sic.add("entrys.qCItem.dataPrecision");
        sic.add("entrys.checkValue");
        sic.add("entrys.checkResult");
        return sic;
    }

    private Map getReportRelWeighMap(IRowSet rs) throws BOSException {
        HashMap reportRelWeighMap = new HashMap();
        String oldId = "";
        ArrayList<Map> relWeighList = new ArrayList<Map>();
        try {
            while (rs.next()) {
                String materialID = rs.getString("MATERIAL");
                String reportID = rs.getString("REPORTID");
                String id = materialID + reportID;
                Map reportRelWeighRow = this.getReportRelWeighRow(rs);
                if (oldId.equals(id)) {
                    relWeighList.add(reportRelWeighRow);
                    continue;
                }
                if (!HQHPUtil.isNullList(relWeighList)) {
                    reportRelWeighMap.put(oldId, relWeighList);
                }
                relWeighList = new ArrayList();
                relWeighList.add(reportRelWeighRow);
                oldId = id;
            }
            if (!HQHPUtil.isNullList(relWeighList)) {
                reportRelWeighMap.put(oldId, relWeighList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return reportRelWeighMap;
    }

    private Map getRecMaps() throws BOSException {
        String inSQL = HQHPUtil.getInSQLFromSet(this.recIDs);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT REC.FID AS RECBILLID,RECENTRY.FID AS RECENTRYID,RECENTRY.CFsupplyQTY AS supplierQTY,RECENTRY.FUnitID as unit \n");
        sql.append("FROM T_IM_PURRECEIVALENTRY AS RECENTRY \n");
        sql.append("INNER JOIN T_IM_PURRECEIVALBILL AS REC \n");
        sql.append("ON RECENTRY.FPARENTID = REC.FID \n");
        sql.append("WHERE REC.FID IN (").append(inSQL).append(") \n");
        sql.append("ORDER BY RECBILLID,RECENTRYID \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        Map recMaps = this.getRecRows(rs);
        return recMaps;
    }

    private Map getRecRows(IRowSet rs) throws BOSException {
        HashMap recMaps = new HashMap();
        ArrayList<HashMap<String, Object>> recList = null;
        String oldId = "";
        try {
            while (rs.next()) {
                String id = rs.getString("recBillID");
                HashMap<String, Object> recMap = new HashMap<String, Object>();
                Object recEntryId = rs.getObject("recEntryID");
                recMap.put("recEntryID", recEntryId);
                recMap.put("SUPPLIERQTY", rs.getObject("SUPPLIERQTY"));
                recMap.put("unit", rs.getObject("unit"));
                if (oldId.equals(id)) {
                    recList.add(recMap);
                    continue;
                }
                if (!HQHPUtil.isNullList(recList)) {
                    recMaps.put(oldId, recList);
                }
                recList = new ArrayList<HashMap<String, Object>>();
                recList.add(recMap);
                oldId = id;
            }
            if (!HQHPUtil.isNullList(recList)) {
                recMaps.put(oldId, recList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return recMaps;
    }

    private void verifyCalBill(Map recRelWeighBill, CoreBaseCollection hqhpCalBillCollection) throws EASBizException, BOSException {
        for (int i = 0; i < hqhpCalBillCollection.size(); ++i) {
            HQHPMsg errorMsg;
            HQHPCalBillInfo calBillInfo = (HQHPCalBillInfo)hqhpCalBillCollection.get(i);
            if (calBillInfo.getSettleTermEntry().size() == 0) {
                errorMsg = new HQHPMsg("Error_HasNoSettleItems", new String[]{calBillInfo.getNumber()});
                this.errorMsgs.add(errorMsg);
                this.setBillVerifyFailed(calBillInfo);
                continue;
            }
            if (this.hasNoWeighBill(calBillInfo, recRelWeighBill)) {
                this.setBillVerifyFailed(calBillInfo);
                continue;
            }
            if (QMBillBaseStatusEnum.Audit.equals((Object)calBillInfo.getBillStatus())) {
                errorMsg = new HQHPMsg("Check_OnlyUnAuditBillsCanCal", new String[]{calBillInfo.getNumber()});
                this.errorMsgs.add(errorMsg);
                this.setBillVerifyFailed(calBillInfo);
                continue;
            }
            if (calBillInfo.isIsSubmitted()) {
                errorMsg = new HQHPMsg("Check_SubmittedBillsCannotCal", new String[]{calBillInfo.getNumber()});
                this.errorMsgs.add(errorMsg);
                this.setBillVerifyFailed(calBillInfo);
                continue;
            }
            if (this.qcItemHasRepeatStTerms(calBillInfo)) {
                this.setBillVerifyFailed(calBillInfo);
                continue;
            }
            List hasNoMatchQcItems = this.getHasNoMatchQcItemList(calBillInfo);
            int size = hasNoMatchQcItems.size();
            if (size > 0) {
                this.setBillVerifyFailed(calBillInfo);
                StringBuffer qcItems = new StringBuffer("");
                for (int j = 0; j < size; ++j) {
                    QCItemInfo failedQcItem = (QCItemInfo)hasNoMatchQcItems.get(j);
                    qcItems.append("'" + failedQcItem.getName() + "'");
                    if (j == size - 1) continue;
                    qcItems.append(", ");
                }
                HQHPMsg errorMsg2 = new HQHPMsg("Error_HasNoMatchQcItem", new String[]{calBillInfo.getPurContract().getNumber(), qcItems.toString()});
                this.errorMsgs.add(errorMsg2);
                continue;
            }
            if (!this.everyQtyGreaterThanZero(calBillInfo)) {
                this.setBillVerifyFailed(calBillInfo);
                continue;
            }
            if (!this.floatValueIsZero(calBillInfo)) continue;
            this.setBillVerifyFailed(calBillInfo);
        }
    }

    private void setBillVerifyFailed(HQHPCalBillInfo calBillInfo) {
        this.verifyResultMap.put(calBillInfo, Boolean.TRUE);
    }

    private boolean hasNoWeighBill(HQHPCalBillInfo info, Map recRelWeighBill) {
        if (info.isIsWeigh()) {
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            for (int i = 0; i < qcReportEntry.size(); ++i) {
                String wmNumber;
                List v;
                String recEntryId = qcReportEntry.get(i).getRecBillEntry().getId().toString();
                if (recRelWeighBill == null || HQHPUtil.isNullList(v = (List)recRelWeighBill.get(recEntryId)) || (wmNumber = (String)v.get(2)) != null && !"".equals(wmNumber)) continue;
                String mname = (String)v.get(0);
                String recNumber = (String)v.get(1);
                HQHPMsg errorMsg = new HQHPMsg("Error_WeighHasNoBill", new String[]{recNumber, mname});
                this.errorMsgs.add(errorMsg);
                return true;
            }
        }
        return false;
    }

    private boolean floatValueIsZero(HQHPCalBillInfo calBillInfo) {
        HQHPCalBillSettleTermEntryCollection settleTermEntry = calBillInfo.getSettleTermEntry();
        for (int i = 0; i < settleTermEntry.size(); ++i) {
            HQHPCalBillSettleTermEntryInfo calBillSettleTermEntryInfo = settleTermEntry.get(i);
            BigDecimal floatValue = calBillSettleTermEntryInfo.getFloatValue();
            SettlementTypeNorthEnum settlementPriceType = calBillSettleTermEntryInfo.getSettlementPriceType();
            if (!SettlementTypeNorthEnum.FLOAT.equals((Object)settlementPriceType) || floatValue != null && !HQHPUtil.isZero(floatValue)) continue;
            HQHPMsg errorMsg = new HQHPMsg("Error_FloatValueIsZero", new String[]{calBillInfo.getNumber()});
            this.errorMsgs.add(errorMsg);
            return true;
        }
        return false;
    }

    private boolean qcItemHasRepeatStTerms(HQHPCalBillInfo calBillInfo) {
        HQHPCalBillQcReportEntryCollection calBillQCReportEntry = calBillInfo.getQcReportEntry();
        HQHPCalBillSettleTermEntryCollection calBillSettleTermEntry = calBillInfo.getSettleTermEntry();
        HashMap<BOSUuid, SettlementTypeNorthEnum> tmpQCItemCalTpyeMap = new HashMap<BOSUuid, SettlementTypeNorthEnum>();
        if (calBillQCReportEntry != null && calBillSettleTermEntry != null) {
            for (int j = 0; j < calBillQCReportEntry.size(); ++j) {
                QCReportInfo qcPurReport = this.getQcReportFromCollection(calBillQCReportEntry.get(j).getQcPurReport().getId().toString());
                QCReportEntryCollection entries = qcPurReport.getEntrys();
                if (entries == null) continue;
                for (int k = 0; k < entries.size(); ++k) {
                    QCItemInfo item = entries.get(k).getQCItem();
                    if (item == null) continue;
                    BOSUuid qcItemID = item.getId();
                    for (int m = 0; m < calBillSettleTermEntry.size(); ++m) {
                        HQHPCalBillSettleTermEntryInfo calBillSettleTermEntryInfo = calBillSettleTermEntry.get(m);
                        QCItemInfo qcItemInStTerms = calBillSettleTermEntryInfo.getQcItem();
                        SettlementTypeNorthEnum settlementPriceType = calBillSettleTermEntryInfo.getSettlementPriceType();
                        if (qcItemInStTerms == null || !qcItemID.equals((Object)qcItemInStTerms.getId())) continue;
                        if (!tmpQCItemCalTpyeMap.containsKey(qcItemID)) {
                            tmpQCItemCalTpyeMap.put(qcItemID, settlementPriceType);
                            continue;
                        }
                        if (tmpQCItemCalTpyeMap.get(qcItemID).equals(settlementPriceType)) continue;
                        HQHPMsg errorMsg = new HQHPMsg("Error_SettlePriceTypeRepeat", new String[]{item.getName(), calBillInfo.getPurContract().getNumber()});
                        this.errorMsgs.add(errorMsg);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private List getHasNoMatchQcItemList(HQHPCalBillInfo calBillInfo) {
        HQHPCalBillSettleTermEntryCollection settleTermEntry = calBillInfo.getSettleTermEntry();
        HQHPCalBillQcReportEntryCollection qcReportEntry = calBillInfo.getQcReportEntry();
        ArrayList<QCItemInfo> noMacthQcItems = new ArrayList<QCItemInfo>();
        if (settleTermEntry == null) {
            return noMacthQcItems;
        }
        for (int i = 0; i < settleTermEntry.size(); ++i) {
            HQHPCalBillSettleTermEntryInfo calBillSettleTermEntryInfo = settleTermEntry.get(i);
            QCItemInfo qcItem = calBillSettleTermEntryInfo.getQcItem();
            boolean hasMatch = false;
            if (qcItem == null) continue;
            block1: for (int j = 0; j < qcReportEntry.size(); ++j) {
                HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(j);
                QCReportInfo qcPurReport = this.getQcReportFromCollection(calBillQcReportEntryInfo.getQcPurReport().getId().toString());
                QCReportEntryCollection entrys = qcPurReport.getEntrys();
                for (int k = 0; k < entrys.size(); ++k) {
                    QCReportEntryInfo reportEntryInfo = entrys.get(k);
                    QCItemInfo item = reportEntryInfo.getQCItem();
                    if (!qcItem.getId().equals((Object)item.getId())) continue;
                    hasMatch = true;
                    continue block1;
                }
            }
            if (hasMatch) continue;
            noMacthQcItems.add(qcItem);
        }
        return noMacthQcItems;
    }

    private boolean everyQtyGreaterThanZero(HQHPCalBillInfo calBillInfo) throws EASBizException, BOSException {
        QuanSettlePatternEnum quanSettlePattern = calBillInfo.getQuanSettlePattern();
        if (QuanSettlePatternEnum.SUPPLIERQTY.equals((Object)quanSettlePattern)) {
            Map qcReportLists = (Map)this.params.get("selectedReports");
            String purID = calBillInfo.getPurContract().getId().toString() + calBillInfo.getPurContractEntry().getId().toString();
            List reportList = (List)qcReportLists.get(purID);
            for (int i = 0; i < reportList.size(); ++i) {
                Map reportRow = (Map)reportList.get(i);
                String recId = (String)reportRow.get("recBillID");
                String recNumber = (String)reportRow.get("recBillNumber");
                BigDecimal recBillSupplierQTY = ZERO;
                List recEntryList = (List)this.recMaps.get(recId);
                for (int j = 0; j < recEntryList.size(); ++j) {
                    Map recEntry = (Map)recEntryList.get(j);
                    BigDecimal tmpSupplierQTY = (BigDecimal)recEntry.get("SUPPLIERQTY");
                    String srcUnitId = (String)recEntry.get("unit");
                    tmpSupplierQTY = QMUnitConvertHelper.convertQtyByUnit(this.ctx, calBillInfo.getPurContractEntry().getMaterial().getId().toString(), srcUnitId, calBillInfo.getPurContractEntry().getUnit().getId().toString(), tmpSupplierQTY);
                    if (tmpSupplierQTY == null) continue;
                    recBillSupplierQTY = recBillSupplierQTY.add(tmpSupplierQTY);
                }
                if (!HQHPUtil.isZero(recBillSupplierQTY)) continue;
                HQHPMsg errorMsg = new HQHPMsg("Error_SupplierQTYVerifyFailed", new String[]{calBillInfo.getPurContract().getNumber(), recNumber});
                this.errorMsgs.add(errorMsg);
                return false;
            }
        }
        return true;
    }

    private CoreBaseCollection calBill(CoreBaseCollection hqhpCalBillCollection) throws EASBizException, BOSException {
        this.calSuccessBills = new CoreBaseCollection();
        for (int i = 0; i < hqhpCalBillCollection.size(); ++i) {
            HQHPCalBillInfo calBillInfo = (HQHPCalBillInfo)hqhpCalBillCollection.get(i);
            if (this.verifyFailed(calBillInfo)) continue;
            HQHPCalBillInfo clone = (HQHPCalBillInfo)calBillInfo.clone();
            if (this.calBill(clone)) {
                hqhpCalBillCollection.set(i, (CoreBaseInfo)clone);
                ++this.calSuccessCount;
                this.calSuccessBills.add((CoreBaseInfo)clone);
                continue;
            }
            HQHPMsg errorMsg = new HQHPMsg("Error_QcItemInRightRange", new String[]{this.qcItemNotInRange, this.qcValueNotInRange.toString(), calBillInfo.getPurContract().getNumber()});
            this.errorMsgs.add(errorMsg);
        }
        if (this.isCal) {
            return this.calSuccessBills;
        }
        return hqhpCalBillCollection;
    }

    private boolean verifyFailed(HQHPCalBillInfo calBillInfo) {
        Boolean verifyResult = (Boolean)this.verifyResultMap.get(calBillInfo);
        if (verifyResult == null) {
            return false;
        }
        return verifyResult;
    }

    private boolean calBill(HQHPCalBillInfo info) throws EASBizException, BOSException {
        this.netWeighAmounts = new HashMap();
        this.dryWeighAmounts = new HashMap();
        this.netWeighAmount = ZERO;
        this.dryWeightAmount = null;
        this.totalDeductVar = ZERO;
        this.supplierDryWeight = ZERO;
        this.settleUnitPrice = ZERO;
        this.isAllCancellQCItem = new HashSet();
        this.isWeigh = info.isIsWeigh();
        this.quanSettlePattern = info.getQuanSettlePattern();
        this.unitId = info.getPurContractEntry().getUnit().getId().toString();
        String materialId = info.getPurContractEntry().getMaterial().getId().toString();
        String purOrgUnitId = info.getPurOrgUnit().getId().toString();
        this.initQtyScale(purOrgUnitId, materialId);
        this.initPriceScale(purOrgUnitId);
        BigDecimal dryWeighAmount = ZERO;
        BigDecimal totalDeductWeigh = null;
        if (this.isWeigh) {
            this.getRelWeighDetails(info);
            info.setNetWeightAmount(this.netWeighAmount);
            info.setTotalDeductVar(this.totalDeductVar);
            dryWeighAmount = this.getDryWeighAmount();
            info.setDryWeightAmount(dryWeighAmount);
            totalDeductWeigh = this.netWeighAmount.subtract(dryWeighAmount);
            info.setTotalDeductWeight(totalDeductWeigh);
        }
        BigDecimal supplierAmount = this.getSupplierAmount(info);
        info.setSupplierAmount(supplierAmount);
        if (this.isWeigh) {
            this.supplierDryWeight = supplierAmount.subtract(totalDeductWeigh);
            info.setSupplierDryWeight(this.supplierDryWeight);
        }
        BigDecimal taxPrice = HQHPUtil.getPriceInScale(info.getUnitPrice(), this.priceScale);
        info.setPurMoneyRef(HQHPUtil.multiply(supplierAmount, taxPrice, 2));
        BigDecimal settleQuanS = null;
        BigDecimal deliverQty = this.getDeLiverQty(info);
        if (!this.isWeigh) {
            settleQuanS = deliverQty;
        } else if (QuanSettlePatternEnum.SUPPLIERQTY.equals((Object)this.quanSettlePattern)) {
            settleQuanS = supplierAmount;
        } else if (QuanSettlePatternEnum.SUPPLIERDRYWEIGHT.equals((Object)this.quanSettlePattern)) {
            settleQuanS = this.supplierDryWeight;
        } else if (QuanSettlePatternEnum.DRYWEIGHT.equals((Object)this.quanSettlePattern)) {
            settleQuanS = dryWeighAmount;
        } else if (QuanSettlePatternEnum.NETWEIGHT.equals((Object)this.quanSettlePattern)) {
            settleQuanS = this.netWeighAmount;
        }
        info.setSettleQuantityS(settleQuanS);
        BigDecimal settleQuanI = null;
        settleQuanI = !this.isWeigh ? deliverQty : this.netWeighAmount;
        info.setSettleQuantityI(settleQuanI);
        HQHPCalBillSettleTermEntryCollection settleTermEntry = info.getSettleTermEntry();
        HashMap qcItemBaseValues = new HashMap();
        Set qcItemGroup = this.getQcItemGroup(settleTermEntry, qcItemBaseValues);
        HashMap<String, BigDecimal> qcItemAverValue = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> qcItemStIndex = new HashMap<String, Integer>();
        for (QCItemInfo qcItem : qcItemGroup) {
            BigDecimal averQcValue = this.deductQCItemAverValue != null && this.deductQCItemAverValue.get(qcItem) != null ? (BigDecimal)this.deductQCItemAverValue.get(qcItem) : this.getAverQCValue(qcItem, info, false);
            if (this.isQCItemAllCancel(qcItem)) continue;
            qcItemAverValue.put(qcItem.getId().toString(), averQcValue);
            int settleTermIndex = this.setQcAverValueInStTermEntry(qcItem, averQcValue, settleTermEntry);
            if (settleTermIndex == -1) {
                this.qcItemNotInRange = qcItem.getName();
                this.qcValueNotInRange = averQcValue;
                return false;
            }
            qcItemStIndex.put(qcItem.getId().toString(), new Integer(settleTermIndex));
        }
        this.reSetBaseValue(qcItemBaseValues, qcItemStIndex, settleTermEntry);
        HQHPCalBillSettleItemEntryCollection settleItemEntry = info.getSettleItemEntry();
        settleItemEntry.clear();
        for (QCItemInfo qcItem : qcItemGroup) {
            String qcItemId = qcItem.getId().toString();
            if (this.isQCItemAllCancel(qcItem)) continue;
            HQHPCalBillSettleItemEntryInfo calBillSettleItemEntryInfo = new HQHPCalBillSettleItemEntryInfo();
            BigDecimal averQcValue = (BigDecimal)qcItemAverValue.get(qcItemId);
            calBillSettleItemEntryInfo.setQcAverageValue((BigDecimal)qcItemAverValue.get(qcItemId));
            int index = (Integer)qcItemStIndex.get(qcItemId);
            HQHPCalBillSettleTermEntryInfo calBillSettleTermEntryInfo = settleTermEntry.get(index);
            calBillSettleItemEntryInfo.setQcItem(calBillSettleTermEntryInfo.getQcItem());
            calBillSettleItemEntryInfo.setSettlementPriceType(calBillSettleTermEntryInfo.getSettlementPriceType());
            SettlementTypeNorthEnum settlementPriceType = calBillSettleTermEntryInfo.getSettlementPriceType();
            BigDecimal baseValue = calBillSettleTermEntryInfo.getBaseValue();
            BigDecimal floatValue = calBillSettleTermEntryInfo.getFloatValue();
            BigDecimal floatPrice = HQHPUtil.getPriceInScale(calBillSettleTermEntryInfo.getFloatPrice(), this.priceScale);
            BigDecimal basePrice = HQHPUtil.getPriceInScale(calBillSettleTermEntryInfo.getBasePrice(), this.priceScale);
            if (SettlementTypeNorthEnum.FLOAT.equals((Object)settlementPriceType)) {
                if (averQcValue != null && baseValue != null && floatValue != null && HQHPUtil.notZero(floatValue) && floatPrice != null) {
                    BigDecimal addOrReducePrice = HQHPUtil.multiply(averQcValue.subtract(baseValue).divide(floatValue, 10, 4), floatPrice, this.priceScale);
                    calBillSettleItemEntryInfo.setAddOrReducePrice(addOrReducePrice);
                }
            } else if (SettlementTypeNorthEnum.FIXED.equals((Object)settlementPriceType)) {
                calBillSettleItemEntryInfo.setAddOrReducePrice(basePrice);
            }
            settleItemEntry.add(calBillSettleItemEntryInfo);
        }
        this.addSettleItemSumRow(info, qcItemAverValue, qcItemBaseValues, totalDeductWeigh);
        PricingPatternEnum pricingPattern = info.getPricingPattern();
        BigDecimal settleUnitPriceS = null;
        if (PricingPatternEnum.CONPRICE.equals((Object)pricingPattern)) {
            settleUnitPriceS = info.getUnitPrice();
        } else if (PricingPatternEnum.HQHP.equals((Object)pricingPattern)) {
            BigDecimal protetivePrice = HQHPUtil.getPriceInScale(info.getProtectivePrice(), this.priceScale);
            settleUnitPriceS = protetivePrice == null || HQHPUtil.isZero(protetivePrice) ? this.settleUnitPrice : (this.settleUnitPrice.compareTo(protetivePrice) > 0 ? protetivePrice : this.settleUnitPrice);
        }
        info.setSettleUnitPriceS(settleUnitPriceS);
        BigDecimal settleMoney = null;
        if (settleQuanS != null && settleUnitPriceS != null) {
            settleMoney = HQHPUtil.multiply(settleQuanS, settleUnitPriceS, 2);
        }
        if (settleMoney != null && settleQuanI != null && HQHPUtil.notZero(settleQuanI)) {
            info.setSettleUnitPriceI(settleMoney.divide(settleQuanI, this.priceScale, 4));
        }
        info.setSettleMoney(settleMoney);
        info.setIsCaled(true);
        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        info.setLastUpdateTime(new Timestamp(new Date().getTime()));
        return true;
    }

    protected void initQtyScale(String purOrgUnitId, String materialId) throws BOSException, EASBizException {
        MultiMeasureUnitInfo multiUnitInfo;
        this.qtyScale = 2;
        String paramValue = HQHPUtil.getQtyParamValue(this.ctx, "HQHP001", purOrgUnitId);
        if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
            this.qtyScale = Integer.parseInt(paramValue);
        } else if (this.unitId != null && (multiUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiUnit(materialId, this.unitId)) != null) {
            this.qtyScale = multiUnitInfo.getQtyPrecision();
        }
    }

    protected void initPriceScale(String purOrgUnitId) throws EASBizException, BOSException {
        this.priceScale = 4;
        String paramValue = HQHPUtil.getPriceParamValue(this.ctx, "HQHP002", purOrgUnitId);
        if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
            this.priceScale = Integer.parseInt(paramValue);
        }
    }

    private boolean isQCItemAllCancel(QCItemInfo qcItem) {
        if (qcItem == null || qcItem.getId() == null) {
            return false;
        }
        return this.isAllCancellQCItem.contains(qcItem.getId().toString());
    }

    private void reSetBaseValue(Map qcItemBaseValues, Map qcItemStIndex, HQHPCalBillSettleTermEntryCollection settleTermEntry) {
        for (String qcItemId : qcItemBaseValues.keySet()) {
            Integer index = (Integer)qcItemStIndex.get(qcItemId);
            if (index == null) continue;
            HQHPCalBillSettleTermEntryInfo calBillSettleTermEntryInfo = settleTermEntry.get(index);
            BigDecimal baseValue = calBillSettleTermEntryInfo.getBaseValue();
            qcItemBaseValues.put(qcItemId, baseValue);
        }
    }

    private void addSettleItemSumRow(HQHPCalBillInfo calBillInfo, Map qcItemAverValue, Map qcItemBaseValues, BigDecimal totalDeductWeigh) {
        BigDecimal basePrice;
        HQHPCalBillSettleItemEntryCollection settleItemEntry = calBillInfo.getSettleItemEntry();
        if (settleItemEntry.size() == 0) {
            return;
        }
        PurContractEntryInfo purContractEntry = calBillInfo.getPurContractEntry();
        BigDecimal proPrice = basePrice = HQHPUtil.getPriceInScale(purContractEntry.getTaxPrice(), this.priceScale);
        BigDecimal addOrReducePrice = ZERO;
        BigDecimal sumDeductWeight = totalDeductWeigh;
        boolean hasScale = false;
        for (int i = 0; i < settleItemEntry.size(); ++i) {
            HQHPCalBillSettleItemEntryInfo calBillSettleItemEntryInfo = settleItemEntry.get(i);
            if (SettlementTypeNorthEnum.SCALE.equals((Object)calBillSettleItemEntryInfo.getSettlementPriceType())) {
                String qcItemId = calBillSettleItemEntryInfo.getQcItem().getId().toString();
                BigDecimal qcAverValue = (BigDecimal)qcItemAverValue.get(qcItemId);
                BigDecimal baseValue = (BigDecimal)qcItemBaseValues.get(qcItemId);
                if (proPrice != null && basePrice != null && qcAverValue != null && baseValue != null && HQHPUtil.notZero(baseValue)) {
                    hasScale = true;
                    proPrice = proPrice.subtract(HQHPUtil.multiply(basePrice, new BigDecimal("1").subtract(qcAverValue.divide(baseValue, 10, 4)), this.priceScale));
                }
            }
            if (calBillSettleItemEntryInfo.getAddOrReducePrice() == null) continue;
            addOrReducePrice = addOrReducePrice.add(HQHPUtil.getPriceInScale(calBillSettleItemEntryInfo.getAddOrReducePrice(), this.priceScale));
        }
        this.settleUnitPrice = proPrice.add(addOrReducePrice);
        HQHPCalBillSettleItemEntryInfo sumInfo = new HQHPCalBillSettleItemEntryInfo();
        sumInfo.setConUnitPrice(basePrice);
        BigDecimal protectPrice = HQHPUtil.getPriceInScale(calBillInfo.getProtectivePrice(), this.priceScale);
        sumInfo.setConProPrice(protectPrice);
        if (protectPrice != null && HQHPUtil.notZero(protectPrice) && protectPrice.compareTo(this.settleUnitPrice) < 0) {
            sumInfo.setSettleUnitPrice(protectPrice);
        } else {
            sumInfo.setSettleUnitPrice(this.settleUnitPrice);
        }
        sumInfo.setProportionPrice(hasScale ? proPrice : null);
        sumInfo.setAddOrReducePrice(addOrReducePrice);
        sumInfo.setTotalDeductWeight(sumDeductWeight);
        sumInfo.setTotalNetWeight(this.netWeighAmount);
        settleItemEntry.insertObject(-1, (IObjectValue)sumInfo);
    }

    private BigDecimal getDeLiverQty(HQHPCalBillInfo info) throws EASBizException, BOSException {
        BigDecimal totalDeLiverQty = ZERO;
        HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            QCReportInfo qcPurReport = qcReportEntry.get(i).getQcPurReport();
            QCReportInfo qcReport = this.getQcReportFromCollection(qcPurReport.getId().toString());
            BigDecimal deliverQty = qcReport.getDeliverQty();
            deliverQty = QMUnitConvertHelper.convertQtyByUnit(this.ctx, info.getPurContractEntry().getMaterial().getId().toString(), qcReport.getUnit().getId().toString(), this.unitId, deliverQty);
            if (deliverQty == null) continue;
            totalDeLiverQty = totalDeLiverQty.add(deliverQty);
        }
        return totalDeLiverQty;
    }

    private int setQcAverValueInStTermEntry(QCItemInfo qcItem, BigDecimal averQcValue, HQHPCalBillSettleTermEntryCollection settleTermEntry) {
        for (int i = 0; i < settleTermEntry.size(); ++i) {
            HQHPCalBillSettleTermEntryInfo calBillSettleTermEntryInfo = settleTermEntry.get(i);
            QCItemInfo qcItemInST = calBillSettleTermEntryInfo.getQcItem();
            if (!qcItem.getId().equals((Object)qcItemInST.getId())) continue;
            BigDecimal upperRange = calBillSettleTermEntryInfo.getUpperRange();
            BigDecimal lowRange = calBillSettleTermEntryInfo.getLowRange();
            QCUpperLimitEnum upperComp = calBillSettleTermEntryInfo.getComparator2();
            QCLowerLimitEnum lowerComp = calBillSettleTermEntryInfo.getComparator1();
            if (!HQHPUtil.compareToLowRange(averQcValue, lowerComp, lowRange) || !HQHPUtil.compareToUpperRange(averQcValue, upperComp, upperRange)) continue;
            calBillSettleTermEntryInfo.setQcAverageValue(averQcValue);
            return i;
        }
        return -1;
    }

    private Set getQcItemGroup(HQHPCalBillSettleTermEntryCollection settleTermEntry, Map qcItemBaseValues) {
        HashSet<QCItemInfo> qcItemGroup = new HashSet<QCItemInfo>();
        for (int i = 0; i < settleTermEntry.size(); ++i) {
            HQHPCalBillSettleTermEntryInfo calBillSettleTermEntryInfo = settleTermEntry.get(i);
            QCItemInfo qcItem = calBillSettleTermEntryInfo.getQcItem();
            qcItemGroup.add(qcItem);
            qcItemBaseValues.put(qcItem.getId().toString(), calBillSettleTermEntryInfo.getBaseValue());
        }
        return qcItemGroup;
    }

    private BigDecimal getDryWeighAmount() {
        if (this.dryWeightAmount != null) {
            return this.dryWeightAmount;
        }
        BigDecimal dryWeighAmount = ZERO;
        if (this.dryWeighAmounts.size() == 0) {
            return dryWeighAmount;
        }
        for (Object key : this.dryWeighAmounts.keySet()) {
            dryWeighAmount = dryWeighAmount.add((BigDecimal)this.dryWeighAmounts.get(key));
        }
        return dryWeighAmount;
    }

    private BigDecimal getAverQCValue(QCItemInfo qcItem, HQHPCalBillInfo info, boolean isDeductItem) throws EASBizException, BOSException {
        ArrayList<BigDecimal> settleQuanList = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> qcValueList = new ArrayList<BigDecimal>();
        int cnt = 0;
        HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            String qcReportID = qcReportEntry.get(i).getQcPurReport().getId().toString();
            QCReportInfo reportInfo = this.getQcReportFromCollection(qcReportID);
            if (reportInfo == null) continue;
            ArrayList<BigDecimal> tempQcValueList = new ArrayList<BigDecimal>();
            QCReportEntryCollection entrys = reportInfo.getEntrys();
            for (int j = 0; j < entrys.size(); ++j) {
                QCReportEntryInfo reportEntryInfo = entrys.get(j);
                QCItemInfo item = reportEntryInfo.getQCItem();
                if (!item.getId().equals((Object)qcItem.getId())) continue;
                try {
                    tempQcValueList.add(new BigDecimal(reportEntryInfo.getCheckValue()));
                    ++cnt;
                    continue;
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("HQHP convert to number error: [" + reportEntryInfo.getCheckValue() + "]"));
                }
            }
            BigDecimal qcValue = this.getAverageVal(tempQcValueList);
            BigDecimal settleQuanlitity = ZERO;
            if (info.isIsWeigh()) {
                String reportId = reportInfo.getId().toString();
                BigDecimal netWeight = (BigDecimal)this.netWeighAmounts.get(reportId);
                if (QuanSettlePatternEnum.NETWEIGHT.equals((Object)this.quanSettlePattern)) {
                    settleQuanlitity = netWeight;
                } else if (QuanSettlePatternEnum.DRYWEIGHT.equals((Object)this.quanSettlePattern)) {
                    settleQuanlitity = netWeight;
                } else if (QuanSettlePatternEnum.SUPPLIERQTY.equals((Object)this.quanSettlePattern)) {
                    settleQuanlitity = this.getSupplierQtyByReport(info, qcReportEntry.get(i));
                } else if (QuanSettlePatternEnum.SUPPLIERDRYWEIGHT.equals((Object)this.quanSettlePattern)) {
                    settleQuanlitity = this.getSupplierQtyByReport(info, qcReportEntry.get(i));
                }
            } else {
                BigDecimal deliverQty = reportInfo.getDeliverQty();
                String mid = info.getPurContractEntry().getMaterial().getId().toString();
                settleQuanlitity = deliverQty = QMUnitConvertHelper.convertQtyByUnit(this.ctx, mid, reportInfo.getUnit().getId().toString(), info.getPurContractEntry().getUnit().getId().toString(), deliverQty);
            }
            settleQuanlitity = settleQuanlitity.setScale(this.qtyScale, 4);
            settleQuanList.add(settleQuanlitity);
            qcValueList.add(qcValue);
        }
        if (cnt == 0) {
            this.isAllCancellQCItem.add(qcItem.getId().toString());
            return ZERO;
        }
        int dataPrecision = qcItem.getDataPrecision();
        return this.getAverValue(settleQuanList, qcValueList).setScale(dataPrecision, 4);
    }

    private QCReportInfo getQcReportFromCollection(String qcReportID) {
        for (int i = 0; i < this.qcReportColls.size(); ++i) {
            QCReportInfo coreBaseInfo = ((QCReportCollection)this.qcReportColls).get(i);
            if (!coreBaseInfo.getId().toString().equals(qcReportID)) continue;
            return coreBaseInfo;
        }
        return null;
    }

    private BigDecimal getSupplierAmount(HQHPCalBillInfo info) throws EASBizException, BOSException {
        if (!this.isWeigh) {
            return this.getDeLiverQty(info);
        }
        BigDecimal supplierAmount = ZERO;
        HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
        int size = qcReportEntry.size();
        for (int i = 0; i < size; ++i) {
            HQHPCalBillQcReportEntryInfo reportEntry = qcReportEntry.get(i);
            BigDecimal supplierQTY = this.getSupplierQtyByReport(info, reportEntry);
            if (supplierQTY == null) continue;
            supplierAmount = supplierAmount.add(supplierQTY);
        }
        return supplierAmount;
    }

    private BigDecimal getSupplierQtyByReport(HQHPCalBillInfo info, HQHPCalBillQcReportEntryInfo calBillReportinfo) throws EASBizException, BOSException {
        BigDecimal totalSettleQuanS = ZERO;
        if (calBillReportinfo.getSettleQuanS() != null && totalSettleQuanS.compareTo(calBillReportinfo.getSettleQuanS()) < 0 && (QuanSettlePatternEnum.SUPPLIERQTY.equals((Object)info.getQuanSettlePattern()) || QuanSettlePatternEnum.SUPPLIERDRYWEIGHT.equals((Object)info.getQuanSettlePattern()))) {
            totalSettleQuanS = calBillReportinfo.getSettleQuanS();
            return totalSettleQuanS;
        }
        HashSet<String> wbIds = new HashSet<String>();
        String reportId = calBillReportinfo.getQcPurReport().getId().toString();
        String materialId = info.getPurContractEntry().getMaterial().getId().toString();
        String key = materialId + reportId;
        List reportRelWeighRows = (List)this.qcReportInfoMaps.get(key);
        if (reportRelWeighRows == null) {
            return totalSettleQuanS;
        }
        int size = reportRelWeighRows.size();
        for (int k = 0; k < size; ++k) {
            Map row = (Map)reportRelWeighRows.get(k);
            Object wbId = row.get("wbID");
            if (wbId == null) continue;
            wbIds.add(wbId.toString());
        }
        return totalSettleQuanS;
    }

    private void getRelWeighDetails(HQHPCalBillInfo info) throws EASBizException, BOSException {
        MaterialInfo material = info.getPurContractEntry().getMaterial();
        HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
        this.netWeighAmount = ZERO;
        this.totalDeductVar = ZERO;
        this.isAllCancellQCItem = new HashSet();
        if (qcReportEntry == null) {
            return;
        }
        for (int i = 0; i < qcReportEntry.size(); ++i) {
            HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(i);
            QCReportInfo qcPurReport = calBillQcReportEntryInfo.getQcPurReport();
            String qcReportId = qcPurReport.getId().toString();
            qcPurReport = this.getQcReportFromCollection(qcReportId);
            BigDecimal netWeightPerReport = ZERO;
            String materialId = material.getId().toString();
            String mapID = materialId + qcReportId;
            List relWeighInfoList = (List)this.qcReportInfoMaps.get(mapID);
            if (relWeighInfoList == null) continue;
            String unitId = info.getPurContractEntry().getUnit().getId().toString();
            for (int j = 0; j < relWeighInfoList.size(); ++j) {
                Map relWeighInfo = (Map)relWeighInfoList.get(j);
                BigDecimal netWeight = (BigDecimal)relWeighInfo.get("netWeight");
                BigDecimal deductVar = (BigDecimal)relWeighInfo.get("incidental");
                String weighBillUnitid = (String)relWeighInfo.get("unit");
                netWeight = QMUnitConvertHelper.convertQtyByUnit(this.ctx, materialId, weighBillUnitid, unitId, netWeight);
                deductVar = QMUnitConvertHelper.convertQtyByUnit(this.ctx, materialId, weighBillUnitid, unitId, deductVar);
                if (netWeight != null) {
                    netWeightPerReport = netWeightPerReport.add(netWeight);
                }
                if (deductVar == null) continue;
                this.totalDeductVar = this.totalDeductVar.add(deductVar);
            }
            netWeightPerReport = netWeightPerReport.setScale(this.qtyScale, 4);
            this.netWeighAmount = this.netWeighAmount.add(netWeightPerReport);
            this.netWeighAmounts.put(qcReportId, netWeightPerReport);
        }
        HQHPCalBillSettleTermEntryCollection settleTermEntrys = info.getSettleTermEntry();
        Map deductQCItemBaseValue = this.getDeductQCItemBaseValue(settleTermEntrys);
        this.deductQCItemAverValue = new HashMap();
        for (QCItemInfo qcItem : deductQCItemBaseValue.keySet()) {
            BigDecimal averQcValue = this.getAverQCValue(qcItem, info, true);
            if (this.isQCItemAllCancel(qcItem)) continue;
            this.deductQCItemAverValue.put(qcItem, averQcValue);
        }
        ArrayList deductList = new ArrayList();
        for (QCItemInfo qcItem : this.deductQCItemAverValue.keySet()) {
            BigDecimal eachAverValue = (BigDecimal)this.deductQCItemAverValue.get(qcItem);
            BigDecimal eachBaseValue = (BigDecimal)deductQCItemBaseValue.get(qcItem);
            if (eachAverValue == null || eachBaseValue == null || eachAverValue.compareTo(eachBaseValue) <= 0) continue;
            HashMap<String, BigDecimal> tmp = new HashMap<String, BigDecimal>();
            tmp.put("checkValue", eachAverValue);
            tmp.put("baseValue", eachBaseValue);
            deductList.add(tmp);
        }
        this.dryWeightAmount = this.deductFromNetWeight(this.netWeighAmount, deductList, info);
        for (Object key : this.netWeighAmounts.keySet()) {
            BigDecimal netWeightPerReport = (BigDecimal)this.netWeighAmounts.get(key);
            if (netWeightPerReport == null || this.netWeighAmount.compareTo(ZERO) == 0) continue;
            BigDecimal dryWeightPerReport = netWeightPerReport.divide(this.netWeighAmount, 10, 4).multiply(this.dryWeightAmount).setScale(this.qtyScale, 4);
            this.dryWeighAmounts.put(key, dryWeightPerReport);
        }
    }

    private Map getDeductQCItemBaseValue(HQHPCalBillSettleTermEntryCollection settleTermEntrys) {
        HashMap<QCItemInfo, BigDecimal> m = new HashMap<QCItemInfo, BigDecimal>();
        int size = settleTermEntrys.size();
        for (int i = 0; i < size; ++i) {
            HQHPCalBillSettleTermEntryInfo settleTermEntry = settleTermEntrys.get(i);
            if (!SettlementTypeNorthEnum.STANDARD.equals((Object)settleTermEntry.getSettlementPriceType())) continue;
            QCItemInfo qcItem = settleTermEntry.getQcItem();
            BigDecimal baseValue = settleTermEntry.getBaseValue();
            if (qcItem == null) continue;
            m.put(qcItem, baseValue);
        }
        return m;
    }

    private BigDecimal getDryWeightPerReport(BigDecimal netWeightPerReport, QCReportInfo qcPurReport, HQHPCalBillInfo info) {
        ArrayList deductList = new ArrayList();
        HashSet<String> deductQCItemds = new HashSet<String>();
        QCReportEntryCollection entrys = qcPurReport.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            QCReportEntryInfo reportEntryInfo = entrys.get(i);
            QCItemInfo qcItem = reportEntryInfo.getQCItem();
            HQHPCalBillSettleTermEntryCollection settleTermEntrys = info.getSettleTermEntry();
            for (int j = 0; j < settleTermEntrys.size(); ++j) {
                BigDecimal checkValue;
                HQHPCalBillSettleTermEntryInfo settleTermEntry = settleTermEntrys.get(j);
                QCItemInfo qcItemInSt = settleTermEntry.getQcItem();
                BigDecimal baseValue = settleTermEntry.getBaseValue();
                String qcItemId = qcItem.getId().toString();
                if (!qcItemId.equals(qcItemInSt.getId().toString()) || deductQCItemds.contains(qcItemId) || !HQHPUtil.compareToLowRange(checkValue = this.getArithAvgValueInReport(qcItemId, entrys), settleTermEntry.getComparator1(), settleTermEntry.getLowRange()) || !HQHPUtil.compareToUpperRange(checkValue, settleTermEntry.getComparator2(), settleTermEntry.getUpperRange()) || !SettlementTypeNorthEnum.STANDARD.equals((Object)settleTermEntry.getSettlementPriceType()) || baseValue == null) continue;
                HashMap<String, BigDecimal> tmp = new HashMap<String, BigDecimal>();
                tmp.put("checkValue", checkValue);
                tmp.put("baseValue", baseValue);
                deductList.add(tmp);
                deductQCItemds.add(qcItemId);
            }
        }
        BigDecimal dryWeightPerReport = this.deductFromNetWeight(netWeightPerReport, deductList, info);
        return dryWeightPerReport;
    }

    private BigDecimal getArithAvgValueInReport(String qcItemId, QCReportEntryCollection entrys) {
        ArrayList<BigDecimal> qcValueList = new ArrayList<BigDecimal>();
        for (int i = 0; i < entrys.size(); ++i) {
            QCReportEntryInfo reportEntryInfo = entrys.get(i);
            QCItemInfo qcItem = reportEntryInfo.getQCItem();
            if (!qcItemId.equals(qcItem.getId().toString())) continue;
            try {
                BigDecimal tmp = new BigDecimal(reportEntryInfo.getCheckValue());
                qcValueList.add(tmp);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return this.getAverageVal(qcValueList);
    }

    private BigDecimal deductFromNetWeight(BigDecimal netWeightPerReport, List deductList, HQHPCalBillInfo info) {
        return this.getCalFomula(netWeightPerReport, deductList, info).subtractDeductValue().setScale(this.qtyScale, 4);
    }

    protected HQHPDeductCalWithFomula getCalFomula(BigDecimal netWeightPerReport, List deductList, HQHPCalBillInfo info) {
        return new HQHPDeductCalWithFomula(netWeightPerReport, deductList, info);
    }

    private BigDecimal getAverValue(List settleQuanList, List averValueList) {
        BigDecimal settleQuanSum = this.getSum(settleQuanList);
        if (HQHPUtil.isZero(settleQuanSum)) {
            return this.getAverageVal(averValueList);
        }
        List percentQuanList = this.getPercentQuanList(settleQuanList, settleQuanSum);
        List percentQcValueList = this.getPercentQcValueList(percentQuanList, averValueList);
        return this.getAverValue(percentQcValueList);
    }

    private BigDecimal getAverValue(List percentQcValueList) {
        BigDecimal averValue = ZERO;
        for (int i = 0; i < percentQcValueList.size(); ++i) {
            averValue = averValue.add((BigDecimal)percentQcValueList.get(i));
        }
        return averValue;
    }

    private List getPercentQcValueList(List percentQuanList, List averValueList) {
        ArrayList<BigDecimal> perList = new ArrayList<BigDecimal>();
        for (int i = 0; i < percentQuanList.size(); ++i) {
            perList.add(((BigDecimal)percentQuanList.get(i)).multiply((BigDecimal)averValueList.get(i)));
        }
        return perList;
    }

    private List getPercentQuanList(List settleQuanList, BigDecimal settleQuanSum) {
        ArrayList<BigDecimal> perList = new ArrayList<BigDecimal>();
        for (int i = 0; i < settleQuanList.size(); ++i) {
            perList.add(((BigDecimal)settleQuanList.get(i)).divide(settleQuanSum, 10, 4));
        }
        return perList;
    }

    private BigDecimal getSum(List settleQuanList) {
        BigDecimal sum = ZERO;
        for (int i = 0; i < settleQuanList.size(); ++i) {
            sum = sum.add((BigDecimal)settleQuanList.get(i));
        }
        return sum;
    }

    private BigDecimal getAverageVal(List qcValueList) {
        int size = qcValueList.size();
        if (size == 0) {
            return ZERO;
        }
        BigDecimal averValue = ZERO;
        for (int i = 0; i < size; ++i) {
            BigDecimal value = (BigDecimal)qcValueList.get(i);
            averValue = averValue.add(value);
        }
        if (HQHPUtil.notZero(averValue)) {
            averValue = averValue.divide(new BigDecimal(size), 10, 4);
        }
        return averValue;
    }

    @Override
    protected Map _submitPriceWhenEdit(Context ctx, Map[] params) throws BOSException, EASBizException {
        Map submitParam = params[0];
        String calBillID = (String)submitParam.get("id");
        BigDecimal submitPrice = (BigDecimal)submitParam.get("submitPrice");
        String number = (String)submitParam.get("number");
        String sql = "update t_qm_hqhpcalbill set fissubmitted=1 where fid='" + calBillID + "'";
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(sql);
        Set reports = (Set)submitParam.get("reports");
        if (reports.size() > 0) {
            String updateReportSql = "update t_qm_qcreport set FIsSubmitBalPrice=1 where fid in (" + HQHPUtil.getInSQLFromSet(reports) + ")";
            sqls.add(updateReportSql);
        }
        HQHPUtil.executeBatch(ctx, sqls);
        Set recEntries = (Set)submitParam.get("recEntries");
        HashMap<String, String> calbills = new HashMap<String, String>();
        HashMap<String, BigDecimal> recPrices = new HashMap<String, BigDecimal>();
        for (String recEntryId : recEntries) {
            calbills.put(recEntryId, number);
            recPrices.put(recEntryId, submitPrice);
        }
        params[0] = calbills;
        params[1] = recPrices;
        HashMap result = new HashMap();
        result.put("resultError", new ArrayList());
        return result;
    }

    @Override
    protected Map _submitPrice(Context ctx, Map[] params) throws BOSException, EASBizException {
        this.ctx = ctx;
        List ids = (List)params[0].get("ids");
        HashSet idSet = new HashSet();
        for (int i = 0; i < ids.size(); ++i) {
            idSet.add(ids.get(i));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorsForSubmit());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        HQHPCalBillCollection bills = HQHPCalBillFactory.getLocalInstance(ctx).getHQHPCalBillCollection(view);
        HQHPCalBillCollection billsBak = (HQHPCalBillCollection)((Object)bills.clone());
        Boolean isFromList = (Boolean)params[0].get("isFromList");
        this.verifyAllIsInWarehs(ctx, bills, isFromList);
        ArrayList<String> sqls = new ArrayList<String>();
        HashSet<String> canSubmitBills = new HashSet<String>();
        for (int i = bills.size() - 1; i >= 0; --i) {
            HQHPCalBillQcReportEntryCollection qcReportEntry;
            HQHPCalBillInfo info = bills.get(i);
            String billNumber = info.getNumber();
            if (!this.canSubmit(billNumber, qcReportEntry = info.getQcReportEntry(), info)) {
                bills.remove(info);
                continue;
            }
            canSubmitBills.add(info.getId().toString());
            HQHPCalBillQcReportEntryCollection qcReportEntry2 = info.getQcReportEntry();
            StringBuffer tmpSql = new StringBuffer();
            tmpSql.append("update t_qm_qcreport set FIsSubmitBalPrice = 1 where fid in (");
            for (int j = 0; j < qcReportEntry2.size(); ++j) {
                String reportId = qcReportEntry2.get(j).getQcPurReport().getId().toString();
                tmpSql.append("'" + reportId + "'");
                if (j == qcReportEntry2.size() - 1) continue;
                tmpSql.append(",");
            }
            tmpSql.append(")");
            sqls.add(tmpSql.toString());
        }
        if (canSubmitBills.size() != 0) {
            String sql = "update t_qm_hqhpcalbill set fissubmitted=1 where fid in (" + HQHPUtil.getInSQLFromSet(canSubmitBills) + ")";
            sqls.add(sql);
        }
        HashMap<String, String> calbills = new HashMap<String, String>();
        HashMap<String, BigDecimal> recPrices = new HashMap<String, BigDecimal>();
        String sqlTemp = null;
        for (int i = 0; i < bills.size(); ++i) {
            HQHPCalBillInfo info = bills.get(i);
            String number = info.getNumber();
            BigDecimal submitPrice = this.getSubmitPrice(ctx, info);
            sqlTemp = "update T_WM_WeighBill set FSettleUnitPrice = '" + submitPrice + "',FHQHPCalBillNumber = '" + info.getNumber() + "' where FHQHPCalBillID = '" + info.getId().toString() + "' ";
            sqls.add(sqlTemp);
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(j);
                String recBillEntryId = calBillQcReportEntryInfo.getRecBillEntry().getId().toString();
                calbills.put(recBillEntryId, number);
                recPrices.put(recBillEntryId, submitPrice);
            }
        }
        HQHPUtil.executeBatch(ctx, sqls);
        params[0] = calbills;
        params[1] = recPrices;
        int count = bills.size();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("submitSuccessCount", new Integer(count));
        result.put("Result_SubmitBills", new Integer(count));
        result.put("resultError", this.submitErrorMsg);
        result.put("bills", (Object)bills);
        HashMap numberMap = new HashMap();
        HashMap priceMap = new HashMap();
        this.buildSubmitMap(ctx, bills, numberMap, priceMap);
        result.put("P_WB_numberMap", numberMap);
        result.put("P_WB_priceMap", priceMap);
        this.updateRelWeighBillWhenSubmit(ctx, bills);
        this.writeSubmitPriceLog(billsBak, bills);
        result.put("submitLogIds", this.submitLogIds);
        return result;
    }

    protected BigDecimal getSubmitPrice(Context ctx, HQHPCalBillInfo info) throws EASBizException, BOSException {
        BigDecimal submitPrice = null;
        BigDecimal priceSA = info.getSettleUnitPriceSA();
        BigDecimal priceS = info.getSettleUnitPriceS();
        BigDecimal priceIA = info.getSettleUnitPriceIA();
        BigDecimal priceI = info.getSettleUnitPriceI();
        String purOrgUnitID = info.getPurOrgUnit().getId().toString();
        String paramValue = QMParamUtil.getParamValue((Context)ctx, (String)"HQHP003", (String)purOrgUnitID);
        submitPrice = paramValue != null && paramValue.equals("1") ? (priceIA == null || HQHPUtil.isZero(priceIA) ? priceI : priceIA) : (priceSA == null || HQHPUtil.isZero(priceSA) ? priceS : priceSA);
        return submitPrice;
    }

    protected void buildSubmitMap(Context ctx, HQHPCalBillCollection bills, Map numberMap, Map priceMap) throws EASBizException, BOSException {
        if (bills == null || bills.size() == 0) {
            return;
        }
        for (int i = 0; i < bills.size(); ++i) {
            HQHPCalBillInfo info = bills.get(i);
            String number = info.getNumber();
            BigDecimal submitPrice = this.getSubmitPrice(ctx, info);
            if (info.isIsWeigh()) {
                Set wbIdSet = this.getWBs(ctx, info.getId().toString());
                for (String wbId : wbIdSet) {
                    numberMap.put(wbId, number);
                    priceMap.put(wbId, submitPrice);
                }
                continue;
            }
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(j);
                String recBillEntryId = calBillQcReportEntryInfo.getRecBillEntry().getId().toString();
                numberMap.put(recBillEntryId, number);
                priceMap.put(recBillEntryId, submitPrice);
            }
        }
    }

    private Set getWBs(Context ctx, String hqhpBillId) throws BOSException {
        String findSql = "select fid from t_wm_weighbill where FHQHPCalBillID = '" + hqhpBillId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)findSql);
        HashSet<String> s = new HashSet<String>();
        try {
            while (rs.next()) {
                s.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return s;
    }

    protected void updateRelWeighBillWhenSubmit(Context ctx, HQHPCalBillCollection bills) throws BOSException {
        this.updateRelWeighBillSubmitStatus(ctx, bills, 1);
    }

    private void updateRelWeighBillSubmitStatus(Context ctx, HQHPCalBillCollection bills, int status) throws BOSException {
        if (bills == null || bills.size() == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < bills.size(); ++i) {
            HQHPCalBillInfo calBillInfo = bills.get(i);
            idSet.add(calBillInfo.getId().toString());
        }
        String updateSql = "update t_wm_weighbill set FIsSubmitted = " + status + " where FHQHPCalBillID in (" + HQHPUtil.getInSQLFromSet(idSet) + ")";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void verifyAllRec(HQHPCalBillCollection bills) throws BOSException {
        HQHPCalBillCollection tempCollection = new HQHPCalBillCollection();
        HashSet<String> recEntryIds = new HashSet<String>();
        for (int i = 0; i < bills.size(); ++i) {
            HQHPCalBillInfo calBillInfo = bills.get(i);
            HQHPCalBillQcReportEntryCollection qcReportEntry = calBillInfo.getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                recEntryIds.add(qcReportEntry.get(j).getRecBillEntry().getId().toString());
            }
        }
        Map recQtyDiff = this.getRecQtyDiff(this.ctx, recEntryIds);
        for (int i = tempCollection.size() - 1; i >= 0; --i) {
            HQHPCalBillInfo calBillInfo = bills.get(i);
            if (!this.isNotAllRecBill(recQtyDiff, calBillInfo)) continue;
            bills.remove(calBillInfo);
            HQHPMsg msg = new HQHPMsg("Error_SubmitFailedNoAllRec", new String[]{calBillInfo.getNumber()});
            this.submitErrorMsg.add(msg);
        }
    }

    private void verifyAllIsInWarehs(Context ctx, HQHPCalBillCollection bills, Boolean isFromList) throws BOSException, EASBizException {
        HashMap collectionWeighted = new HashMap();
        HashSet weighBillNumbers = new HashSet();
        HQHPCalBillCollection collectionUnWeighted = new HQHPCalBillCollection();
        HashSet<String> recEntryIds = new HashSet<String>();
        for (int x = 0; x < bills.size(); ++x) {
            HQHPCalBillInfo calBillInfo = bills.get(x);
            HQHPCalBillQcReportEntryCollection qcReportEntry = calBillInfo.getQcReportEntry();
            if (!calBillInfo.isIsWeigh()) {
                if (isFromList == null || !isFromList.booleanValue()) continue;
                for (int y = 0; y < qcReportEntry.size(); ++y) {
                    recEntryIds.add(qcReportEntry.get(y).getRecBillEntry().getId().toString());
                }
                collectionUnWeighted.add(calBillInfo);
                continue;
            }
            for (int z = 0; z < qcReportEntry.size(); ++z) {
                HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(z);
                QCReportInfo qcPurReport = calBillQcReportEntryInfo.getQcPurReport();
                String reportid = qcPurReport.getId().toString();
                String requestentryid = qcPurReport.getRequestEntryID();
                ArrayList<String> p = new ArrayList<String>();
                p.add(reportid);
                p.add(requestentryid);
                p.add(calBillInfo.getId().toString());
                Map relWeighInfo = this._getCurRelWeighInfo(ctx, p);
                List rows = (List)relWeighInfo.get("list");
                for (int i = 0; i < rows.size(); ++i) {
                    Map rowMap = (Map)rows.get(i);
                    weighBillNumbers.add(rowMap.get("number"));
                    collectionWeighted.put(rowMap.get("number"), calBillInfo);
                }
            }
        }
        Map recQtyDiff = this.getRecQtyDiff(ctx, recEntryIds);
        for (int j = collectionUnWeighted.size() - 1; j >= 0; --j) {
            HQHPCalBillInfo calBillInfo = collectionUnWeighted.get(j);
            if (!this.isNotAllRecBill(recQtyDiff, calBillInfo)) continue;
            bills.remove(calBillInfo);
            HQHPMsg msg = new HQHPMsg("Error_SubmitFailedNoAllRec", new String[]{calBillInfo.getNumber()});
            this.submitErrorMsg.add(msg);
        }
    }

    private boolean isNotAllRecBill(Map recQtyDiff, HQHPCalBillInfo calBillInfo) {
        HQHPCalBillQcReportEntryCollection qcReportEntry = calBillInfo.getQcReportEntry();
        for (int j = 0; j < qcReportEntry.size(); ++j) {
            String recEntryId = qcReportEntry.get(j).getRecBillEntry().getId().toString();
            BigDecimal qtyDiff = (BigDecimal)recQtyDiff.get(recEntryId);
            if (qtyDiff == null || qtyDiff.compareTo(HQHPUtil.BigDecimal_Zero) <= 0) continue;
            return true;
        }
        return false;
    }

    private void writeSubmitPriceLog(HQHPCalBillCollection billsBak, HQHPCalBillCollection bills) {
        this.submitLogIds = new HashMap();
        for (int i = 0; i < billsBak.size(); ++i) {
            HQHPCalBillInfo info = billsBak.get(i);
            String id = info.getId().toString();
            IObjectPK pk = LogUtil.beginLog((Context)this.ctx, (String)"submitPrice", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"qm_HQHPCalBill_submitCalPrice");
            if (pk == null) {
                return;
            }
            this.submitLogIds.put(id, pk.toString());
            if (!this.idInBills(id, bills)) continue;
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)pk);
        }
    }

    private boolean idInBills(String id, HQHPCalBillCollection bills) {
        if (bills == null || bills.size() == 0) {
            return false;
        }
        for (int i = 0; i < bills.size(); ++i) {
            HQHPCalBillInfo info = bills.get(i);
            if (!id.equals(info.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private boolean canSubmit(String billNumber, HQHPCalBillQcReportEntryCollection qcReportEntry, HQHPCalBillInfo info) {
        if (!QMBillBaseStatusEnum.Audit.equals((Object)info.getBillStatus())) {
            HQHPMsg msg = new HQHPMsg("Verify_UnAuditBillsCannotSubmit", new String[]{billNumber});
            this.submitErrorMsg.add(msg);
            return false;
        }
        if (!info.isIsCaled()) {
            HQHPMsg msg = new HQHPMsg("Verify_UnCaledBillsCannotSubmit", new String[]{billNumber});
            this.submitErrorMsg.add(msg);
            return false;
        }
        if (info.isIsSubmitted()) {
            HQHPMsg msg = new HQHPMsg("Verify_SubmittedBillsCannotSubmit", new String[]{billNumber});
            this.submitErrorMsg.add(msg);
            return false;
        }
        for (int j = 0; j < qcReportEntry.size(); ++j) {
            HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(j);
            QCReportInfo qcPurReport = calBillQcReportEntryInfo.getQcPurReport();
            if (qcPurReport.isSubmitResult()) continue;
            HQHPMsg msg = new HQHPMsg("Verify_SubmitBillsFailed", new String[]{billNumber, qcPurReport.getNumber()});
            this.submitErrorMsg.add(msg);
            return false;
        }
        return true;
    }

    private SelectorItemCollection getSelectorsForSubmit() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("billStatus");
        sic.add("isCaled");
        sic.add("isWeigh");
        sic.add("isSubmitted");
        sic.add("settleUnitPriceS");
        sic.add("settleUnitPriceSA");
        sic.add("settleUnitPriceI");
        sic.add("settleUnitPriceIA");
        sic.add("purOrgUnit.id");
        sic.add("purOrgUnit.name");
        sic.add("purOrgUnit.number");
        sic.add("qcReportEntry.id");
        sic.add("qcReportEntry.qcPurReport.id");
        sic.add("qcReportEntry.qcPurReport.number");
        sic.add("qcReportEntry.qcPurReport.submitResult");
        sic.add("qcReportEntry.qcPurReport.requestEntryID");
        sic.add("qcReportEntry.recBill.id");
        sic.add("qcReportEntry.recBill.number");
        sic.add("qcReportEntry.recBillEntry.id");
        return sic;
    }

    @Override
    protected Map _getCurRelWeighInfo(Context ctx, List paraList) throws BOSException {
        String calBillId;
        StringBuffer sql = new StringBuffer();
        String reportID = (String)paraList.get(0);
        String requestEntryID = (String)paraList.get(1);
        sql.append("SELECT NOTICEBILL.NOTICEBILLNUMBER,NOTICEBILL.CARNUMBER,NOTICEBILL.MNUMBER AS MATERIALNUMBER, \n");
        sql.append("       NOTICEBILL.MNAME AS MATERIALNAME,WEIGHBILL.FNUMBER AS NUMBER, \n");
        sql.append("       TGROSSUNIT.").append(nameCol).append(" AS GROSSUNIT,WEIGHBILL.FGROSSWEIGHT AS GROSSWEIGHT, \n");
        sql.append("       TTAREUNIT.").append(nameCol).append(" AS TAREUNIT, \n");
        sql.append("       WEIGHBILL.FTAREWEIGHT AS TAREWEIGHT,WEIGHBILL.FINCIDENTAL AS INCIDENTAL, \n");
        sql.append("       WEIGHBILL.FNETWEIGHT AS NETWEIGHT,MUNIT.").append(nameCol).append(" AS UNIT, \n");
        sql.append("       WMBILLTYPE.").append(nameCol).append(" AS BILLTYPE,WEIGHBILL.FWEIGHSTATUS AS WEIGHSTATUS, \n");
        sql.append("       WEIGHBILL.FBILLSTATUS AS BILLSTATUS,WEIGHBILL.FAUDITTIME AS AUDITTIME, \n");
        sql.append("       WEIGHBILL.FISCONTINUOUSCAR AS ISCONTINUOUSCAR,WEIGHBILL.FISMUCHCARRY AS ISMUCHCARRY, \n");
        sql.append("       WAREHOUSE.").append(nameCol).append(" AS DELIVERYWAREHOUSE, \n ");
        sql.append("       UNLOADHOUSE.").append(nameCol).append(" AS UNLOADWAREHOUSE, \n");
        sql.append("       GORG.").append(nameCol).append(" AS GROSSADMINORG,TORG.").append(nameCol).append(" AS TAREADMINORG, \n");
        sql.append("       GPERSON.").append(nameCol).append(" AS GROSSPOUNDOR,TPERSON.").append(nameCol).append(" AS TAREPOUNDOR, \n");
        sql.append("       WEIGHBILL.FGROSSPOUNDTIME AS GROSSPOUNDTIME, \n");
        sql.append("       WEIGHBILL.FTAREPOUNDTIME AS TAREPOUNDTIME,WEIGHBILL.FID AS ID \n");
        sql.append("FROM ( \n");
        sql.append("    SELECT WMNOTICE.FNUMBER AS NOTICEBILLNUMBER,NOTICE.NOTICEENTRYID,NOTICE.CARNUMBER, \n");
        sql.append("           NOTICE.MNUMBER,NOTICE.MNAME,NOTICE.WAREHOUSEID,NOTICE.UNLOADHOUSEID \n");
        sql.append("    FROM ( \n");
        sql.append("        SELECT NOTICEENTRY.FID AS NOTICEENTRYID, NOTICEENTRY.FPARENTID AS NOTICEID, \n");
        sql.append("                NOTICEENTRY.FCARNUMBER AS CARNUMBER, RELNOTICEENTRY.MNUMBER,RELNOTICEENTRY.MNAME, \n");
        sql.append("                NOTICEENTRY.FDeliveryWarehouseID AS WAREHOUSEID,NOTICEENTRY.FUnloadWareHouseID AS UNLOADHOUSEID \n");
        sql.append("        FROM T_WM_WEIGHNOTICEBILLENTRY AS NOTICEENTRY \n");
        sql.append("        INNER JOIN ( \n");
        sql.append("            SELECT WMENTRY.FRELNOTICEENTRYID AS NOTICEENTRYID,ENTRY.MNUMBER,ENTRY.MNAME \n");
        sql.append("            FROM T_QM_QCREQUESTRELWEIGHENTRY AS WMENTRY \n");
        sql.append("            INNER JOIN ( \n");
        sql.append("                SELECT REQUEST3.ENTRYID,REQUEST3.REQUESTID,MATERIAL.FNUMBER AS MNUMBER, \n");
        sql.append("                       MATERIAL.").append(nameCol).append(" AS MNAME \n");
        sql.append("                FROM ( \n");
        sql.append("                    SELECT REQUESTENTRY.FID AS ENTRYID,REQUEST2.REQUESTID,REQUESTENTRY.FMATERIALID AS MATERIALID \n");
        sql.append("                    FROM T_QM_QCREQUESTENTRY AS REQUESTENTRY \n");
        sql.append("                    INNER JOIN ( \n");
        sql.append("                        SELECT REQUEST.FID AS REQUESTID \n");
        sql.append("                        FROM T_QM_QCREQUEST AS REQUEST  \n");
        sql.append("                        INNER JOIN T_QM_QCREPORT AS REPORT \n");
        sql.append("                        ON REQUEST.FID = REPORT.FREQUESTID \n");
        sql.append("                        WHERE REPORT.FID = '").append(reportID).append("' \n");
        sql.append("                    ) AS REQUEST2 \n");
        sql.append("                    ON REQUESTENTRY.FPARENTID = REQUEST2.REQUESTID \n");
        sql.append("                    WHERE REQUESTENTRY.FID = '").append(requestEntryID).append("' \n");
        sql.append("                 ) AS REQUEST3 \n");
        sql.append("                 LEFT OUTER JOIN T_BD_MATERIAL AS MATERIAL \n");
        sql.append("                 ON REQUEST3.MATERIALID = MATERIAL.FID \n");
        sql.append("            ) AS ENTRY \n");
        sql.append("            ON WMENTRY.FMATERIALENTRYID = ENTRY.ENTRYID \n");
        sql.append("            AND WMENTRY.FPARENTID = ENTRY.REQUESTID \n");
        sql.append("        ) AS RELNOTICEENTRY \n");
        sql.append("        ON NOTICEENTRY.FID = RELNOTICEENTRY.NOTICEENTRYID \n");
        sql.append("    ) AS NOTICE \n");
        sql.append("    INNER JOIN T_WM_WEIGHNOTICEBILL AS WMNOTICE \n");
        sql.append("    ON NOTICE.NOTICEID = WMNOTICE.FID \n");
        sql.append(") AS NOTICEBILL \n");
        sql.append("LEFT OUTER JOIN T_WM_WEIGHBILL AS WEIGHBILL \n");
        sql.append("ON NOTICEBILL.NOTICEENTRYID = WEIGHBILL.FSOURCEBILLENTRYID \n");
        sql.append("LEFT OUTER JOIN T_ORG_ADMIN AS GORG \n");
        sql.append("ON WEIGHBILL.FGROSSADMINORGID = GORG.FID \n");
        sql.append("LEFT OUTER JOIN T_ORG_ADMIN AS TORG \n");
        sql.append("ON WEIGHBILL.FTAREADMINORGID = TORG.FID \n");
        sql.append("LEFT OUTER JOIN T_PM_USER AS GPERSON \n");
        sql.append("ON WEIGHBILL.FGROSSPOUNDORID = GPERSON.FID \n");
        sql.append("LEFT OUTER JOIN T_PM_USER AS TPERSON \n");
        sql.append("ON WEIGHBILL.FTAREPOUNDORID = TPERSON.FID \n");
        sql.append("LEFT OUTER JOIN T_WM_WEIGHBILLTYPE AS WMBILLTYPE \n");
        sql.append("ON WEIGHBILL.FBILLTYPEID = WMBILLTYPE.FID \n");
        sql.append("LEFT OUTER JOIN T_WM_SCALE AS GROSSSCALE \n");
        sql.append("ON WEIGHBILL.FGROSSSCALEID = GROSSSCALE.FID \n");
        sql.append("LEFT OUTER JOIN T_BD_MEASUREUNIT AS TGROSSUNIT \n");
        sql.append("ON GROSSSCALE.FUNITID = TGROSSUNIT.FID \n");
        sql.append("LEFT OUTER JOIN T_WM_SCALE AS TARESCALE \n");
        sql.append("ON WEIGHBILL.FTARESCALEID = TARESCALE.FID \n");
        sql.append("LEFT OUTER JOIN T_BD_MEASUREUNIT AS TTAREUNIT \n");
        sql.append("ON TARESCALE.FUNITID = TTAREUNIT.FID \n");
        sql.append("LEFT OUTER JOIN T_BD_MEASUREUNIT AS MUNIT \n");
        sql.append("ON WEIGHBILL.FUNITID = MUNIT.FID \n");
        sql.append("LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE \n");
        sql.append("ON NOTICEBILL.WAREHOUSEID = WAREHOUSE.FID \n");
        sql.append("LEFT OUTER JOIN T_DB_WAREHOUSE AS UNLOADHOUSE \n");
        sql.append("ON NOTICEBILL.UNLOADHOUSEID = UNLOADHOUSE.FID \n");
        sql.append("where WEIGHBILL.fbillStatus = ").append(30);
        if (paraList.size() > 2 && (calBillId = (String)paraList.get(2)) != null) {
            sql.append(" and weighbill.FHQHPCalBillID = '").append(calBillId).append("' \n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return this.createRelWeighMap(rs);
    }

    @Override
    protected Map _getRelWeighInfo(Context ctx, String reportID, String requestEntryID) throws BOSException, EASBizException {
        ArrayList<String> paraList = new ArrayList<String>();
        paraList.add(reportID);
        paraList.add(requestEntryID);
        return this._getCurRelWeighInfo(ctx, paraList);
    }

    private Map createRelWeighMap(IRowSet rs) throws BOSException {
        HashMap result = new HashMap();
        ArrayList<Map> rows = new ArrayList<Map>();
        try {
            while (rs.next()) {
                Map rowMap = this.getReLWeighRowMap(rs);
                rows.add(rowMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("list", rows);
        return result;
    }

    private Map getReLWeighRowMap(IRowSet rs) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        List cols = HQHPUtil.getSQL_WM_COLS();
        for (int i = 0; i < cols.size(); ++i) {
            String object = (String)cols.get(i);
            row.put(object, rs.getObject(object));
        }
        return row;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        return null;
    }

    @Override
    protected void _removeReportsRel(Context ctx, Set ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        String sql = "update t_qm_qcreport set fsumbillnumberid='', FIsCalBalPrice=0, FIsSubmitBalPrice=0 where fid in (" + HQHPUtil.getInSQLFromSet(ids) + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected Map _getReportsToAdd(Context ctx, Map params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \n");
        sql.append("CALBILL.FBillStatus as CalBillStatus, \n");
        this.appendReportCols(sql, params);
        ArrayList args = new ArrayList();
        Set excludeReports = (Set)params.get("Add_Para_ExcludeReports");
        if (excludeReports != null && excludeReports.size() != 0) {
            sql.append("    AND REPORT.FID NOT IN (").append(HQHPUtil.getInSQLFromSet(excludeReports)).append(") \n");
        }
        Date reportDateBegin = (Date)params.get("Add_Para_ReportDateBegin");
        Date reportDateEnd = (Date)params.get("Add_Para_ReportDateEnd");
        if (reportDateBegin != null && reportDateEnd != null) {
            String reportBegin = HQHPUtil.formatStartDate(reportDateBegin);
            String reportEnd = HQHPUtil.formatEndDate(reportDateEnd);
            sql.append(" AND REPORT.FREPORTDATE BETWEEN TO_DATE('" + reportBegin + "') AND TO_DATE('" + reportEnd + "') \n");
        }
        sql.append(" \n");
        sql.append(") AS QCREPORT \n");
        sql.append("ON ENTRY.FID = QCREPORT.PURENTRYID \n");
        sql.append("LEFT OUTER JOIN T_QM_HQHPCALBILL AS CALBILL \n");
        sql.append("ON QCREPORT.QCCALBILLID = CALBILL.FID  \n");
        sql.append("WHERE ENTRY.FID=? \n");
        args.add(params.get("Add_Para_PurEntryID"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])args.toArray());
        Map result = this.getResultRowsForAddReport(rs);
        return result;
    }

    private void appendReportCols(StringBuffer sql, Map filterParams) {
        sql.append("QCREPORT.REPORTID,QCREPORT.ORGNAME AS QUALITYORGUNIT,QCREPORT.FNUMBER AS NUMBER, \n");
        sql.append("QCREPORT.FBILLSTATUS AS BILLSTATUS,QCREPORT.QCSTANDARD,QCREPORT.FSAMPLESOLUTION AS SAMPLESOLUTION, \n");
        sql.append("QCREPORT.FREPORTDATE AS REPORTDATE,QCREPORT.FCHECKRESULT AS CHECKRESULT,QCREPORT.FDELIVERQTY AS DELIVERQTY, \n");
        sql.append("QCREPORT.FPASSQTY AS PASSQTY,QCREPORT.FUNPASSQTY AS UNPASSQTY,QCREPORT.UNIT, \n");
        sql.append("QCREPORT.FISCALBALPRICE AS ISCALBALPRICE,QCREPORT.FISSUBMITBALPRICE AS ISSUBMITBALPRICE, \n");
        sql.append("QCREPORT.FISMRB AS ISMRB,QCREPORT.FSUBMITRESULT AS SUBMITRESULT,QCREPORT.FDESCRIPTION AS DESCRIPTION, \n");
        sql.append("CALBILL.FID AS CALBILLID,CALBILL.FNUMBER AS CALBILLNUMBER,CALBILL.FSETTLEQUANTITY AS CALQUANTITY, \n");
        sql.append("CALBILL.FSETTLEUNITPRICE AS CALUNITPRICE,CALBILL.FSETTLEMONEY AS CALMONEY, \n");
        sql.append("QCREPORT.RECBILLID,QCREPORT.recBillDesc,QCREPORT.RECBILLNUMBER,QCREPORT.RECBILLBIZDATE,QCREPORT.REQUESTID, \n");
        sql.append("MATERIAL2.MTID AS MATERIALID,QCREPORT.RECPRICE AS CONPRICEREC,QCREPORT.RECENTRYID \n");
        sql.append(" \n");
        sql.append("FROM T_SM_PURCONTRACT AS PUR \n");
        sql.append("LEFT OUTER JOIN T_ORG_PURCHASE AS PURORG \n");
        sql.append("ON PUR.FPURORGUNITID = PURORG.FID \n");
        sql.append("LEFT OUTER JOIN T_BD_SETTLEMENTTYPE AS SETTLETYPE \n");
        sql.append("ON PUR.FSETTLEMENTTYPEID = SETTLETYPE.FID \n");
        sql.append("LEFT OUTER JOIN T_BD_SUPPLIER AS SUPPLIER \n");
        sql.append("ON PUR.FSUPPLIERID = SUPPLIER.FID \n");
        sql.append("LEFT OUTER JOIN T_SCM_CONTRACETREE AS CONTYPE \n");
        sql.append("ON PUR.FCONTRACTTYPEID = CONTYPE.FID \n");
        sql.append("LEFT OUTER JOIN T_SM_PURCONTRACTENTRY AS ENTRY \n");
        sql.append("ON PUR.FID = ENTRY.FPARENTID \n");
        sql.append("LEFT OUTER JOIN  \n");
        sql.append(" \n");
        sql.append("(SELECT ENTRY1.FID AS PID,MATERIAL1.MNAME,MATERIAL1.MTID \n");
        sql.append("FROM T_SM_PURCONTRACTENTRY AS ENTRY1 \n");
        sql.append("INNER JOIN ( \n");
        sql.append("    SELECT M.").append(nameCol).append(" AS MNAME, M.FID AS MTID \n");
        sql.append("    FROM T_BD_MATERIAL AS M \n");
        sql.append("    INNER JOIN T_BD_MaterialPurchasing AS MP \n");
        sql.append("    ON M.FID = MP.FMATERIALID AND \n");
        sql.append("    MP.FFineQualityFairPrice = 1 \n");
        sql.append("    ) AS MATERIAL1 \n");
        sql.append("ON ENTRY1.FMATERIALID = MATERIAL1.MTID) AS MATERIAL2 \n");
        sql.append("ON ENTRY.FID = MATERIAL2.PID \n");
        sql.append(" \n");
        sql.append("INNER JOIN ( \n");
        sql.append("    SELECT DISTINCT REQ_ENTRY.PURENTRYID,REPORT.FID AS REPORTID,  \n");
        sql.append("    QUALITYORG.").append(nameCol).append(" AS ORGNAME,REPORT.FNUMBER, \n");
        sql.append("    REPORT.FBILLSTATUS,QCSTANDARD.").append(nameCol).append(" AS QCSTANDARD,REPORT.FSAMPLESOLUTION, \n");
        sql.append("    REPORT.FREPORTDATE,REPORT.FCHECKRESULT,REPORT.FDELIVERQTY, \n");
        sql.append("    REPORT.FPASSQTY,REPORT.FUNPASSQTY,MEASUREUNIT.").append(nameCol).append(" AS UNIT, \n");
        sql.append("    REPORT.FISCALBALPRICE,REPORT.FISSUBMITBALPRICE, \n");
        sql.append("    REPORT.FISMRB,REPORT.FSUBMITRESULT,REPORT.FDESCRIPTION, \n");
        sql.append("    REPORT.FSUMBILLNUMBERID AS QCCALBILLID, \n");
        sql.append("    REQUEST.RECBILLID,REQUEST.recBillDesc,REQUEST.RECBILLNUMBER,REQUEST.RECBILLBIZDATE,REQUEST.REQUESTID, \n");
        sql.append("    REQ_ENTRY.RECPRICE,REQ_ENTRY.RECENTRYID \n");
        sql.append("    FROM T_QM_QCREPORT AS REPORT  \n");
        sql.append("    LEFT OUTER JOIN T_ORG_QUALITY AS QUALITYORG \n");
        sql.append("    ON REPORT.FQUALITYORGUNITID = QUALITYORG.FID \n");
        sql.append("    LEFT OUTER JOIN T_QM_QCSTANDARD AS QCSTANDARD \n");
        sql.append("    ON REPORT.FQCSTANDARDID = QCSTANDARD.FID \n");
        sql.append("    LEFT OUTER JOIN T_BD_MEASUREUNIT AS MEASUREUNIT \n");
        sql.append("    ON REPORT.FUNITID = MEASUREUNIT.FID \n");
        sql.append("    INNER JOIN ( \n");
        sql.append("        SELECT REQUEST1.FID AS REQUESTID,REC.FNUMBER AS RECBILLNUMBER, \n");
        sql.append("        REC.FBIZDATE AS RECBILLBIZDATE,REC.FID AS RECBILLID,rec.fdescription as recBillDesc \n");
        sql.append("        FROM T_QM_QCREQUEST AS REQUEST1 \n");
        sql.append("        INNER JOIN T_IM_PurReceivalBill AS REC \n");
        sql.append("        ON REQUEST1.FSOURCEBILLID = REC.FID \n");
        sql.append("        WHERE REC.FBASESTATUS = ").append(4).append(" \n");
        Date recBillDateBegin = (Date)filterParams.get("recBillDateBegin");
        Date recBillDateEnd = (Date)filterParams.get("recBillDateEnd");
        if (recBillDateBegin != null && recBillDateEnd != null) {
            String recDateBegin = HQHPUtil.formatStartDate(recBillDateBegin);
            String recDateEnd = HQHPUtil.formatEndDate(recBillDateEnd);
            sql.append("        AND REC.FBIZDATE BETWEEN TO_DATE('" + recDateBegin + "') AND TO_DATE('" + recDateEnd + "') \n");
        }
        sql.append("    ) AS REQUEST  \n");
        sql.append("    ON REPORT.FREQUESTID = REQUEST.REQUESTID  \n");
        sql.append("    INNER JOIN (  \n");
        sql.append("        SELECT REQ_ENTRY1.FID,REQ_ENTRY1.FPURCONTRACTID,RECENTRY.FTAXPRICE AS RECPRICE, \n");
        sql.append("                      RECENTRY.PURENTRYID,RECENTRY.FID AS RECENTRYID \n");
        sql.append("        FROM T_QM_QCREQUESTENTRY AS REQ_ENTRY1  \n");
        sql.append("        INNER JOIN ( \n");
        sql.append("              SELECT IMRECENTRY.FID,IMRECENTRY.FTAXPRICE,ORDERENTRY.PURENTRYID \n");
        sql.append("              FROM T_IM_PURRECEIVALENTRY AS IMRECENTRY \n");
        sql.append("              INNER JOIN( \n");
        sql.append("                  SELECT SMORDERENTRY.FID,SMPURENTRY.FID AS PURENTRYID \n");
        sql.append("                  FROM T_SM_PURORDERENTRY AS SMORDERENTRY \n");
        sql.append("                  INNER JOIN T_SM_PURCONTRACTENTRY AS SMPURENTRY \n");
        sql.append("                  ON SMORDERENTRY.FSOURCEBILLENTRYID = SMPURENTRY.FID \n");
        sql.append("              ) AS ORDERENTRY \n");
        sql.append("              ON IMRECENTRY.FpurorderentryID = ORDERENTRY.FID \n");
        sql.append("          ) AS RECENTRY \n");
        sql.append("        ON REQ_ENTRY1.FSOURCEBILLENTRYID = RECENTRY.FID  \n");
        sql.append("    ) AS REQ_ENTRY  \n");
        sql.append("    ON REPORT.FREQUESTENTRYID = REQ_ENTRY.FID  \n");
        sql.append("    LEFT OUTER JOIN ( \n");
        sql.append("        SELECT NCPRENTRY.FPARENTID AS NCPRPARENTID,DPMODE.FQCPURBIZ AS PURBIZ  \n");
        sql.append("        FROM T_QM_QCREPORTNCPPRENTRY AS NCPRENTRY \n");
        sql.append("        INNER JOIN T_QM_DPPROCESSMODE AS DPMODE \n");
        sql.append("        ON NCPRENTRY.FDPPROCESSMODEID = DPMODE.FID \n");
        sql.append("    ) AS NCPR \n");
        sql.append("    ON REPORT.FID = NCPR.NCPRPARENTID \n");
        sql.append("    WHERE REPORT.FBILLSTATUS = ").append(30).append(" \n");
        sql.append("    AND REPORT.FSampleSolution = ").append(20).append(" \n");
        sql.append("    AND (REPORT.FCHECKRESULT <> ").append(20).append(" \n");
        sql.append("               OR (REPORT.FCHECKRESULT = ").append(20).append(" AND  \n");
        sql.append("                       NCPR.PURBIZ <> ").append(3).append(") \n");
        sql.append("    ) \n");
    }

    private Map getResultRowsForAddReport(IRowSet rs) throws BOSException {
        HashMap result = new HashMap();
        ArrayList canAddList = new ArrayList();
        ArrayList canNotAddList = new ArrayList();
        try {
            while (rs.next()) {
                int billStatus = rs.getInt("CalBillStatus");
                if (30 == billStatus) {
                    this.addReportsRowToList(rs, canNotAddList);
                    continue;
                }
                this.addReportsRowToList(rs, canAddList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("ADD_SelectResult_CanAddList", canAddList);
        result.put("ADD_SelectResult_CanNotAddList", canNotAddList);
        return result;
    }

    private void addReportsRowToList(IRowSet rs, List list) throws SQLException {
        Map reportMap = this.getReportRowFromRs(rs);
        list.add(reportMap);
    }

    @Override
    protected void _addReportsToCalBill(Context ctx, Map params) throws BOSException, EASBizException {
        HQHPCalBillInfo info = (HQHPCalBillInfo)params.get("Add_Confirm_Info");
        Set relReportIdSet = (Set)params.get("Add_Confirm_RelReportIdSet");
        Set relCalBillIdSet = (Set)params.get("Add_Confirm_RelCalBillIdSet");
        this.updateOriBills(ctx, info, relReportIdSet, relCalBillIdSet);
        CoreBaseCollection collections = new CoreBaseCollection();
        collections.add((CoreBaseInfo)info);
        this.params = this.getParams(collections);
        this.ctx = ctx;
        this.qcReportInfoMaps = this.getQCReportRelMapsWhenAddReport("'" + info.getId().toString() + "'");
        this.qcReportColls = this.getQCReportColls();
        this.recMaps = this.getRecMaps();
        this.addSettleQuanSInfo(info);
        HQHPUtil.calcPercentWeight(ctx, info);
        this.save(ctx, (CoreBaseInfo)info);
    }

    private void updateOriBills(Context ctx, HQHPCalBillInfo info, Set relReportIdSet, Set relCalBillIdSet) throws BOSException, EASBizException {
        try {
            String updateReportsRelInfoSql = this.getUpdateReportRelSQL(info);
            ArrayList<String> relSqls = new ArrayList<String>();
            relSqls.add(updateReportsRelInfoSql);
            if (relCalBillIdSet.size() != 0) {
                String changeRelSql = "update t_qm_hqhpcalbillqcreportentry set fparentid='" + info.getId().toString() + "' where FQcPurReportID in (" + HQHPUtil.getInSQLFromSet(relReportIdSet) + ")";
                relSqls.add(changeRelSql);
            }
            HQHPUtil.executeBatch(ctx, relSqls);
            if (relCalBillIdSet.size() == 0) {
                return;
            }
            StringBuffer getBillEntryCntSql = new StringBuffer();
            getBillEntryCntSql.append("select fparentid from t_qm_hqhpcalbillqcreportentry where fparentid in (");
            getBillEntryCntSql.append(HQHPUtil.getInSQLFromSet(relCalBillIdSet)).append(")");
            IRowSet calBillRs = DbUtil.executeQuery((Context)ctx, (String)getBillEntryCntSql.toString());
            HashSet<String> updateBills = new HashSet<String>();
            HashSet removeBills = new HashSet();
            while (calBillRs.next()) {
                String calBillID = calBillRs.getString("fparentid");
                if (!relCalBillIdSet.contains(calBillID)) continue;
                updateBills.add(calBillID);
                relCalBillIdSet.remove(calBillID);
            }
            removeBills.addAll(relCalBillIdSet);
            ArrayList<String> sqls = new ArrayList<String>();
            if (updateBills.size() > 0) {
                StringBuffer updateSql = new StringBuffer();
                String[] adjustCols = new String[]{"FSettleUnitPriceSA", "FSettleQuantitySA", "FSettleMoneyA", "FSettleUnitPriceIA", "FAdjustReason", "FUniPriceDiff", "FUniPriceDiffI", "FQuantityDiff", "FMoneyDiff", "FAdjustPerson", "FAdjustDate"};
                updateSql.append("update t_qm_hqhpcalbill set fiscaled=0 ");
                for (int i = 0; i < adjustCols.length; ++i) {
                    updateSql.append(", ").append(adjustCols[i]).append("=null ");
                }
                updateSql.append("where fid in (").append(HQHPUtil.getInSQLFromSet(updateBills)).append(")");
                sqls.add(updateSql.toString());
            }
            if (removeBills.size() > 0) {
                String inBills = HQHPUtil.getInSQLFromSet(removeBills);
                String delBillSql = "delete from t_qm_hqhpcalbill where fid in(" + inBills + ")";
                String delStEntrySql = "delete from T_QM_HQHPCalBillSTermEntry where FParentID in(" + inBills + ")";
                String delSiEntrySql = "delete from T_QM_HQHPCalBillSItemEntry where FParentID in(" + inBills + ")";
                sqls.add(delBillSql);
                sqls.add(delStEntrySql);
                sqls.add(delSiEntrySql);
            }
            if (sqls.size() > 0) {
                HQHPUtil.executeBatch(ctx, sqls);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getUpdateReportRelSQL(HQHPCalBillInfo info) throws BOSException {
        HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
        StringBuffer updateRel = new StringBuffer();
        updateRel.append("update t_qm_qcreport set fsumbillnumberid='").append(info.getId().toString());
        updateRel.append("' where FID in (");
        int size = qcReportEntry.size();
        for (int i = 0; i < size; ++i) {
            String reportID = qcReportEntry.get(i).getQcPurReport().getId().toString();
            updateRel.append("'" + reportID + "'");
            if (i == size - 1) continue;
            updateRel.append(",");
        }
        updateRel.append(")");
        return updateRel.toString();
    }

    public FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        return null;
    }

    @Override
    protected void _saveAdjust(Context ctx, HQHPCalBillInfo info) throws BOSException, EASBizException {
        this._save(ctx, (IObjectValue)info);
    }

    @Override
    protected void _removeBillRelReports(Context ctx, Set ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getRemoveReportsSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        HQHPCalBillCollection calBillCollection = HQHPCalBillFactory.getLocalInstance(ctx).getHQHPCalBillCollection(view);
        HashSet<String> reportIds = new HashSet<String>();
        for (int i = 0; i < calBillCollection.size(); ++i) {
            HQHPCalBillQcReportEntryCollection qcReportEntry = calBillCollection.get(i).getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                reportIds.add(qcReportEntry.get(j).getQcPurReport().getId().toString());
            }
        }
        if (reportIds.size() == 0) {
            return;
        }
        String sql = "update t_qm_qcreport set fsumbillnumberid='', FIsCalBalPrice=0, FIsSubmitBalPrice=0 where fid in (" + HQHPUtil.getInSQLFromSet(reportIds) + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private SelectorItemCollection getRemoveReportsSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("qcReportEntry.id");
        sic.add("qcReportEntry.qcPurReport.id");
        return sic;
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager manager = super.getAuditVerifyManager(ctx, info);
        HQHPCalBillAuditVerifyItem verifyItem = new HQHPCalBillAuditVerifyItem((HQHPCalBillInfo)info);
        manager.addVerifyItem((IVerifyItem)verifyItem);
        return manager;
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager manager = super.getUnAuditVerifyManager(ctx, info);
        HQHPCalBillUnAuditVerifyItem verifyItem = new HQHPCalBillUnAuditVerifyItem((HQHPCalBillInfo)info);
        manager.addVerifyItem((IVerifyItem)verifyItem);
        return manager;
    }

    @Override
    protected void _createFrom(Context ctx) throws BOSException {
    }

    @Override
    protected Map[] _getDynamicPurContract(Context ctx, Set purEntryId) throws BOSException {
        Map[] results = new HashMap[1];
        return results;
    }

    @Override
    protected Map[] _getDynamicRecInfo(Context ctx, Set recEntryID) throws BOSException {
        Map[] results = new HashMap[1];
        return results;
    }

    @Override
    protected void _updateReportCalPrice(Context ctx, Map params) throws BOSException {
        Object action = params.get("Update_Report_Action");
        Object isFromListUI = params.get("Update_Report_IsFromListUI");
        if (isFromListUI == null) {
            Set reportIds = (Set)params.get("Update_Report_IDs");
            if (reportIds == null || reportIds.size() == 0) {
                return;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("update t_qm_qcreport set FBalancePrice = ? where fid in (").append(HQHPUtil.getInSQLFromSet(reportIds)).append(")");
            Object[] v = new BigDecimal[1];
            if ("Update_Report_Action_Audit".equals(action)) {
                v[0] = (BigDecimal)params.get("Update_Report_CalPrice");
                if (v[0] == null) {
                    return;
                }
            } else if ("Update_Report_Action_UnAudit".equals(action)) {
                v[0] = ZERO;
            }
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])v);
        }
        if (isFromListUI != null && ((Boolean)isFromListUI).booleanValue()) {
            Set calBillIds = (Set)params.get("Update_Report_CalBillIds");
            Iterator iterator = calBillIds.iterator();
            ArrayList<String> updateSqls = new ArrayList<String>();
            if ("Update_Report_Action_Audit".equals(action)) {
                while (iterator.hasNext()) {
                    String calBillId = (String)iterator.next();
                    StringBuffer sql = new StringBuffer();
                    sql.append("update t_qm_qcreport set FBalancePrice = ");
                    sql.append("(select (case fsettleunitpriceSa when null then fsettleunitprice when 0 then fsettleunitprice else fsettleunitpriceSa end) as price");
                    sql.append(" from t_qm_hqhpcalbill where fid = '");
                    sql.append(calBillId).append("')");
                    sql.append("where fsumbillnumberid = '").append(calBillId).append("'");
                    updateSqls.add(sql.toString());
                }
            } else if ("Update_Report_Action_UnAudit".equals(action)) {
                while (iterator.hasNext()) {
                    String calBillId = (String)iterator.next();
                    String sql = "update t_qm_qcreport set FBalancePrice = 0 where fsumbillnumberid = '" + calBillId + "'";
                    updateSqls.add(sql);
                }
            }
            if (updateSqls.size() > 0) {
                HQHPUtil.executeBatch(ctx, updateSqls);
            }
        }
    }

    @Override
    protected Map _cancelPrice(Context ctx, Map params) throws BOSException, EASBizException {
        Set ids = (Set)params.get("Cancel_IDS");
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorsForCancel());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        HQHPCalBillCollection calBills = HQHPCalBillFactory.getLocalInstance(ctx).getHQHPCalBillCollection(view);
        HQHPCalBillCollection billsBak = (HQHPCalBillCollection)((Object)calBills.clone());
        this.verifyBillsBeforeCancelPrice(calBills);
        HashSet<String> recEntryIds = new HashSet<String>();
        HashMap<String, String> calBillsForDyna = new HashMap<String, String>();
        HashMap<String, String> calBillNumbersForDyna = new HashMap<String, String>();
        ArrayList<String> sqls = new ArrayList<String>();
        String sqlTemp = null;
        if (calBills.size() > 0) {
            HashSet<String> cancelBillIds = new HashSet<String>();
            HashSet<String> relReportsIds = new HashSet<String>();
            for (int i = 0; i < calBills.size(); ++i) {
                HQHPCalBillInfo calBillInfo = calBills.get(i);
                cancelBillIds.add(calBillInfo.getId().toString());
                HQHPCalBillQcReportEntryCollection qcReportEntry = calBillInfo.getQcReportEntry();
                for (int j = 0; j < qcReportEntry.size(); ++j) {
                    HQHPCalBillQcReportEntryInfo reportEntry = qcReportEntry.get(j);
                    relReportsIds.add(reportEntry.getQcPurReport().getId().toString());
                    String recEntryId = reportEntry.getRecBillEntry().getId().toString();
                    recEntryIds.add(recEntryId);
                    calBillsForDyna.put(recEntryId, calBillInfo.getId().toString());
                    calBillNumbersForDyna.put(recEntryId, calBillInfo.getNumber());
                }
                sqlTemp = "update T_WM_WeighBill set FSettleUnitPrice = null,FHQHPCalBillNumber = null where FHQHPCalBillID = '" + calBillInfo.getId().toString() + "' ";
                sqls.add(sqlTemp);
            }
            String idStr = HQHPUtil.getInSQLFromSet(cancelBillIds);
            String updateSql = "update t_qm_hqhpcalbill set fissubmitted=0 where fid in (" + idStr + ")";
            sqls.add(updateSql);
            if (relReportsIds.size() > 0) {
                String reportIdStr = HQHPUtil.getInSQLFromSet(relReportsIds);
                String updateReportsSql = "update t_qm_qcreport set FIsSubmitBalPrice=0 where fid in (" + reportIdStr + ")";
                sqls.add(updateReportsSql);
            }
        }
        HQHPUtil.executeBatch(ctx, sqls);
        this.updateRelWeighBillWhenCancel(ctx, calBills);
        this.writeCancelPriceLog(ctx, billsBak, calBills);
        HashSet sourceBillEntryId = new HashSet();
        HashMap calBillId = new HashMap();
        HashMap calBillNumber = new HashMap();
        this.buildCancelMap(ctx, calBills, sourceBillEntryId, calBillId, calBillNumber);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Cancel_Bill_Count", new Integer(calBills.size()));
        result.put("resultError", this.cancelErrorMsgs);
        result.put("recEntryIds", recEntryIds);
        result.put("cancelLogIds", this.cancelLogIds);
        result.put("calBillsForDyna", calBillsForDyna);
        result.put("calBillNumbersForDyna", calBillNumbersForDyna);
        result.put("P_WB_sourceBillEntryId", sourceBillEntryId);
        result.put("P_WB_calBillId", calBillId);
        result.put("P_WB_calBillNumber", calBillNumber);
        return result;
    }

    protected void buildCancelMap(Context ctx, HQHPCalBillCollection bills, Set sourceBillEntryId, Map calBillId, Map calBillNumber) throws BOSException {
        if (bills == null || bills.size() == 0) {
            return;
        }
        for (int i = 0; i < bills.size(); ++i) {
            HQHPCalBillInfo info = bills.get(i);
            String id = info.getId().toString();
            String number = info.getNumber();
            if (info.isIsWeigh()) {
                Set wbIdSet = this.getWBs(ctx, info.getId().toString());
                for (String wbId : wbIdSet) {
                    sourceBillEntryId.add(wbId);
                    calBillId.put(wbId, id);
                    calBillNumber.put(wbId, number);
                }
                continue;
            }
            HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
            for (int j = 0; j < qcReportEntry.size(); ++j) {
                HQHPCalBillQcReportEntryInfo calBillQcReportEntryInfo = qcReportEntry.get(j);
                String recBillEntryId = calBillQcReportEntryInfo.getRecBillEntry().getId().toString();
                sourceBillEntryId.add(recBillEntryId);
                calBillId.put(recBillEntryId, id);
                calBillNumber.put(recBillEntryId, number);
            }
        }
    }

    private void updateRelWeighBillWhenCancel(Context ctx, HQHPCalBillCollection calBills) throws BOSException {
        this.updateRelWeighBillSubmitStatus(ctx, calBills, 0);
    }

    private void writeCancelPriceLog(Context ctx, HQHPCalBillCollection billsBak, HQHPCalBillCollection calBills) {
        this.cancelLogIds = new HashMap();
        for (int i = 0; i < billsBak.size(); ++i) {
            HQHPCalBillInfo info = billsBak.get(i);
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"cancelPrice", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"qm_HQHPCalBill_cancelCalPrice");
            if (pk == null) {
                return;
            }
            String id = info.getId().toString();
            this.cancelLogIds.put(id, pk.toString());
            if (!this.idInBills(id, calBills)) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
    }

    private void verifyBillsBeforeCancelPrice(HQHPCalBillCollection calBills) {
        for (int i = calBills.size() - 1; i >= 0; --i) {
            HQHPCalBillInfo calBillInfo = calBills.get(i);
            if (calBillInfo.isIsSubmitted()) continue;
            HQHPMsg msg = new HQHPMsg("Verify_CancelBillsMustBeSubmitted", new String[]{calBillInfo.getNumber()});
            this.cancelErrorMsgs.add(msg);
            calBills.remove(calBillInfo);
        }
    }

    private SelectorItemCollection getSelectorsForCancel() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("*");
        sic.add("qcReportEntry.id");
        sic.add("qcReportEntry.qcPurReport.id");
        sic.add("qcReportEntry.recBillEntry.id");
        return sic;
    }

    @Override
    protected Map _getRecQty(Context ctx, Map param) throws BOSException, EASBizException {
        Set recEntryIds = (Set)param.get("recEntryIds");
        return this.getRecQtyDiff(ctx, recEntryIds);
    }

    private Map getRecQtyDiff(Context ctx, Set recEntryIds) throws BOSException {
        if (recEntryIds == null || recEntryIds.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid, (FQty - FReceiptQty) as qtyDiff \n");
        sql.append("from T_IM_PurReceivalEntry where fid in (").append(HQHPUtil.getInSQLFromSet(recEntryIds)).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> m = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                m.put(rs.getString("fid"), rs.getBigDecimal("qtyDiff"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return m;
    }

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, model, serverActionManager);
        serverActionManager.addServerAction((IServerAction)new HQHPCalBillRevAction());
    }
}

