/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.app.AbstractQCCommonBizFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.PurContractEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class QCCommonBizFacadeControllerBean
extends AbstractQCCommonBizFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCCommonBizFacadeControllerBean");

    @Override
    protected PurContractEntryInfo _getPurContractEntry(Context ctx, QCRequestEntryInfo requestEntryInfo) throws BOSException, EASBizException {
        String requestid = requestEntryInfo.getId().toString();
        requestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(requestid));
        if (!requestEntryInfo.isIsConStandard() || requestEntryInfo.getPurContract() == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select PurContractEntry.FID FROM T_SM_PurContractEntry AS PurContractEntry \n");
        sql.append("inner JOIN T_SM_PurOrderEntry AS PurOrderEntry \n");
        sql.append("ON PurContractEntry.FID = PurOrderEntry.fsourcebillentryid \n");
        sql.append("inner join T_IM_PurReceivalEntry as PurReceivalEntry \n");
        sql.append("on PurOrderEntry.fid = PurReceivalEntry.fsourcebillentryid \n");
        sql.append("inner join t_qm_qcrequestentry as qcrequestentry \n");
        sql.append("on PurReceivalEntry.fid = qcrequestentry.fsourcebillentryid \n");
        sql.append("where qcrequestentry.fid = '" + requestid + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                String fid = rowSet.getString("FID");
                if (fid == null) {
                    return null;
                }
                PurContractEntryInfo info = PurContractEntryFactory.getLocalInstance((Context)ctx).getPurContractEntryInfo((IObjectPK)new ObjectUuidPK(fid));
                return info;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected boolean _canEditPassAndUnPassQtyInQCPurReport(Context ctx, String requestEntryID) throws BOSException, EASBizException {
        if (QMStringUtils.isEmpty((String)requestEntryID)) {
            return true;
        }
        QCRequestEntryInfo requestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(requestEntryID));
        boolean isConStandard = requestEntryInfo.isIsConStandard();
        boolean isHQHPrice = this.isIsHQHPrice(ctx, requestEntryInfo);
        return (!isConStandard || !isHQHPrice) && !requestEntryInfo.isIsWeigh();
    }

    private boolean isIsHQHPrice(Context ctx, QCRequestEntryInfo requestEntryInfo) throws BOSException, EASBizException {
        boolean isHQHPrice = false;
        if (!requestEntryInfo.isIsConStandard() || requestEntryInfo.getPurContract() == null) {
            return false;
        }
        try {
            String requestEntryID = requestEntryInfo.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append("select PurContractEntry.CFIsHQHPrice as CFIsHQHPrice FROM T_SM_PurContractEntry AS PurContractEntry \n");
            sql.append("inner JOIN T_SM_PurOrderEntry AS PurOrderEntry \n");
            sql.append("ON PurContractEntry.FID = PurOrderEntry.fsourcebillentryid \n");
            sql.append("inner join T_IM_PurReceivalEntry as PurReceivalEntry \n");
            sql.append("on PurOrderEntry.fid = PurReceivalEntry.fsourcebillentryid \n");
            sql.append("inner join t_qm_qcrequestentry as qcrequestentry \n");
            sql.append("on PurReceivalEntry.fid = qcrequestentry.fsourcebillentryid \n");
            sql.append("where qcrequestentry.fid = '" + requestEntryID + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                isHQHPrice = rowSet.getBoolean("CFIsHQHPrice");
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        return isHQHPrice;
    }
}

