/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelation;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.qm.basedata.QCBizBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.SampleStatusFactory;
import com.kingdee.eas.qm.basedata.SampleStatusInfo;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRuleInfo;
import com.kingdee.eas.qm.common.ctx.IQMContextHelper;
import com.kingdee.eas.qm.common.ctx.QMContextHelperFactory;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.common.util.QMUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.qc.IQCReinspectReq;
import com.kingdee.eas.qm.qc.QCBillEntryInfo;
import com.kingdee.eas.qm.qc.QCBillException;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCBillSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCBizStateEnum;
import com.kingdee.eas.qm.qc.QCItemBaseInfo;
import com.kingdee.eas.qm.qc.QCReinspectReqEntryCollection;
import com.kingdee.eas.qm.qc.QCReinspectReqEntryInfo;
import com.kingdee.eas.qm.qc.QCReinspectReqFactory;
import com.kingdee.eas.qm.qc.QCReinspectReqInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryInfo;
import com.kingdee.eas.qm.qc.QCSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCSampleException;
import com.kingdee.eas.qm.qc.QCSampleFactory;
import com.kingdee.eas.qm.qc.QCSampleInfo;
import com.kingdee.eas.qm.qc.QCSampleItemEntryCollection;
import com.kingdee.eas.qm.qc.QCSampleItemEntryFactory;
import com.kingdee.eas.qm.qc.QCSampleItemEntryInfo;
import com.kingdee.eas.qm.qc.app.AbstractQCSampleControllerBean;
import com.kingdee.eas.qm.qc.app.reversesave.qcsample.QCReinspectReq4QCSampleAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcsample.QCRequest4QCSampleAction;
import com.kingdee.eas.qm.qc.app.verify.QCSampleAuditSerVerifyItem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCSampleControllerBean
extends AbstractQCSampleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCSampleControllerBean");
    public static final String ToQCBillSucces = "ToQCBillSucces";
    public static final String ToQCRequestSucces = "ToQCRequestSucces";
    public static final BOSObjectType BOSTYPE_QCSample = new QCSampleInfo().getBOSType();
    public static final BOSObjectType BOSTYPE_QCRequest = new QCRequestInfo().getBOSType();
    public static final BOSObjectType BOSTYPE_QCBill = new QCBillInfo().getBOSType();

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkSampleNumber(ctx, model);
        this.getQCRequestEntryUnit(ctx, model);
        QCSampleInfo sampleInfo = (QCSampleInfo)model;
        super._update(ctx, pk, model);
        QCSampleEntryCollection qcSampleEntryCollection = sampleInfo.getEntrys();
        if (qcSampleEntryCollection != null && qcSampleEntryCollection.size() > 0) {
            QCSampleEntryInfo qCSampleEntryInfo = null;
            QCSampleItemEntryCollection itemEntryCollection = null;
            QCSampleItemEntryInfo itemEntryInfo = null;
            int seq = 0;
            for (int i = 0; i < qcSampleEntryCollection.size(); ++i) {
                qCSampleEntryInfo = qcSampleEntryCollection.get(i);
                itemEntryCollection = qCSampleEntryInfo.getItemEntry();
                for (int j = 0; j < itemEntryCollection.size(); ++j) {
                    itemEntryInfo = itemEntryCollection.get(j);
                    seq = j + 1;
                    if (itemEntryInfo.getId() == null) continue;
                    String sql = "UPDATE T_QM_QCSAMPLEITEMENTRY SET FSEQ=" + seq + " where FID='" + itemEntryInfo.getId().toString() + "'";
                    DbUtil.execute((Context)ctx, (String)sql);
                }
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkSampleNumber(ctx, model);
        this.getQCRequestEntryUnit(ctx, model);
        QCSampleInfo sampleInfo = (QCSampleInfo)model;
        if (sampleInfo.getItemEntries().size() > 0) {
            for (int i = 0; i < sampleInfo.getEntrys().size(); ++i) {
                sampleInfo.getEntrys().get(i).getItemEntry().clear();
            }
        }
        return super._addnew(ctx, model);
    }

    private void getQCRequestEntryUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MeasureUnitInfo baseUnit;
        QCSampleInfo sampleInfo = (QCSampleInfo)model;
        if (sampleInfo.getUnit() == null && sampleInfo.getRequestEntryID() != null) {
            QCRequestEntryInfo sourceReqEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(sampleInfo.getRequestEntryID()));
            sampleInfo.setUnit(sourceReqEntryInfo.getEachSampleUnit());
        }
        if (sampleInfo.getBaseUnit() == null && sampleInfo.getMaterial() != null) {
            baseUnit = QMUnitAndExchangeUtils.getBaseUnitForServer((Context)ctx, (String)sampleInfo.getMaterial().getId().toString());
            sampleInfo.setBaseUnit(baseUnit);
        }
        baseUnit = sampleInfo.getBaseUnit();
        BigDecimal sampleCoefficient = null;
        BigDecimal baseCoefficient = null;
        BigDecimal baseSampleQty = null;
        if (baseUnit != null) {
            for (int i = 0; i < sampleInfo.getEntrys().size(); ++i) {
                QCSampleEntryInfo entryInfo = sampleInfo.getEntrys().get(i);
                if (entryInfo.getBaseUnit() == null) {
                    entryInfo.setBaseUnit(baseUnit);
                }
                baseCoefficient = entryInfo.getBaseUnit().getCoefficient();
                if (entryInfo.getUnit() != null) {
                    sampleCoefficient = entryInfo.getUnit().getCoefficient();
                }
                if (baseCoefficient == null || sampleCoefficient == null || entryInfo.getSampleQty() == null || baseCoefficient.compareTo(SysConstant.BIGZERO) <= 0) continue;
                baseSampleQty = entryInfo.getSampleQty().multiply(sampleCoefficient.divide(baseCoefficient, 8, 5));
                entryInfo.setBaseSampleQty(baseSampleQty);
            }
        }
    }

    private void checkSampleNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean hasSameNum;
        QCSampleInfo sampleInfo = (QCSampleInfo)model;
        String qualityID = sampleInfo.getQualityOrgUnit().getId().toString();
        String id = null;
        if (sampleInfo.getId() != null) {
            id = sampleInfo.getId().toString();
        }
        if (hasSameNum = QCSampleFactory.getLocalInstance(ctx).exists("select * where id!='" + id + "' and qualityOrgUnit='" + qualityID + "' and number='" + sampleInfo.getNumber() + "'")) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{sampleInfo.getNumber()});
        }
        QCSampleEntryCollection entrys = sampleInfo.getEntrys();
        StringBuffer numbers = new StringBuffer();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            numbers.append("'").append(entrys.get(i).getNumber()).append("',");
        }
        if (numbers.length() > 0) {
            numbers.deleteCharAt(numbers.length() - 1);
        }
        QCBizBillTypeInfo bizBillInfo = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectStringPK(sampleInfo.getBillType().getId().toString()));
        String bizType = null;
        bizType = QCBizTypeEnum.purCheck == bizBillInfo.getQCBizType() ? String.valueOf(10) : (QCBizTypeEnum.pdtDiscreteCheck == bizBillInfo.getQCBizType() || QCBizTypeEnum.pdtProcessCheck == bizBillInfo.getQCBizType() ? String.valueOf(30) + "," + String.valueOf(20) : "0");
        StringBuffer sql = new StringBuffer("select b.fnumber from t_qm_qcsample a,t_qm_qcsampleentry b,t_qm_qcbizbilltype c ");
        sql.append("where a.fid=b.fparentid and a.fbilltypeid=c.fid ").append(" and a.fqualityorgunitid='").append(qualityID).append("' and c.fqcbiztype in (").append(bizType).append(") and b.fnumber in(").append(numbers.toString()).append(") ");
        if (id != null) {
            sql.append(" and a.fid !='").append(id).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        numbers.setLength(0);
        try {
            while (rs.next()) {
                numbers.append(rs.getString("fnumber")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (numbers.length() > 0) {
            numbers.deleteCharAt(numbers.length() - 1);
            throw new QCSampleException(QCSampleException.SAME_SAMPLE_NUMBER, new String[]{numbers.toString()});
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.hasDestBill(ctx, pk.toString())) {
            throw new QCBillException(QCBillException.CAN_NOT_UNAUDIT_FOR_FLOWBILL);
        }
        super._unAudit(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.hasDestBill(ctx, pk.toString())) {
            throw new QCBillException(QCBillException.CAN_NOT_DELETE_FOR_FLOWBILL);
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCSampleInfo info = (QCSampleInfo)model;
        this.checkSampleQty(ctx, info);
        this.checkAssign(ctx, info);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    private void checkSampleQty(Context ctx, QCSampleInfo info) throws BOSException, EASBizException {
        String requestEntryID = info.getRequestEntryID();
        QCRequestEntryInfo qCRequestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(requestEntryID));
        BigDecimal deliverQty = qCRequestEntryInfo.getDeliverQty();
        deliverQty = deliverQty == null ? new BigDecimal("0") : deliverQty;
        MeasureUnitInfo deliverUnit = qCRequestEntryInfo.getUnit();
        if (deliverUnit != null) {
            MeasureUnitInfo unit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(deliverUnit.getId().toString()));
            deliverUnit.setName(unit.getName());
        }
        MeasureUnitInfo sampleQtyUnit = info.getUnit();
        String materialID = info.getMaterial().getId().toString();
        BigDecimal sampleQty = info.getSampleQty();
        BigDecimal deliverUnitSampleQty = QMUnitAndExchangeUtils.getExchangeQtyForServer((Context)ctx, (MeasureUnitInfo)sampleQtyUnit, (MeasureUnitInfo)deliverUnit, (BigDecimal)sampleQty, (String)materialID);
        if (deliverUnitSampleQty != null && deliverUnitSampleQty.compareTo(deliverQty) > 0) {
            throw new QCSampleException(QCSampleException.SAMPLEQTY_MORE_THAN_DELIVERQTY, new String[]{QMStringUtils.stripTrailingZeros((BigDecimal)sampleQty) + sampleQtyUnit.getName(), QMStringUtils.stripTrailingZeros((BigDecimal)deliverQty) + deliverUnit.getName()});
        }
    }

    private void checkAssign(Context ctx, QCSampleInfo info) throws BOSException, EASBizException {
        QCStandardInfo standardInfo = info.getQcStandard();
        QCSampleEntryInfo entryInfo = null;
        QCSampleItemEntryInfo itemEntryInfo = null;
        String delegQualityID = null;
        String qCItemID = null;
        HashMap<String, String> delegQualityMap = new HashMap<String, String>();
        HashMap<String, String> qCItemMap = new HashMap<String, String>();
        StringBuffer delegQUSQLTemp = new StringBuffer();
        StringBuffer qCItemSQLTemp = new StringBuffer();
        int entrySize = info.getEntrys().size();
        for (int i = 0; i < entrySize; ++i) {
            entryInfo = info.getEntrys().get(i);
            int itemEntrySize = entryInfo.getItemEntry().size();
            for (int j = 0; j < itemEntrySize; ++j) {
                itemEntryInfo = entryInfo.getItemEntry().get(j);
                if (itemEntryInfo.getDelegOrgUnit() == null) continue;
                delegQualityID = itemEntryInfo.getDelegOrgUnit().getId().toString();
                qCItemID = itemEntryInfo.getQCItem().getId().toString();
                if (!delegQualityMap.containsKey(delegQualityID)) {
                    delegQualityMap.put(delegQualityID, itemEntryInfo.getDelegOrgUnit().getName());
                    delegQUSQLTemp.append("'").append(delegQualityID).append("',");
                }
                if (qCItemMap.containsKey(qCItemID + delegQualityID)) continue;
                qCItemMap.put(qCItemID + delegQualityID, itemEntryInfo.getQCItem().getName() + "(" + itemEntryInfo.getDelegOrgUnit().getName() + ")");
                qCItemSQLTemp.append("(fdatabasedid='").append(qCItemID).append("' and fassignorgunitid='").append(delegQualityID).append("') or ");
            }
        }
        StringBuffer sql = new StringBuffer();
        if (delegQUSQLTemp.length() > 0) {
            delegQUSQLTemp.deleteCharAt(delegQUSQLTemp.length() - 1);
            sql.append("SELECT fassignorgunitid FROM T_QM_DATABASEDASSIGN ").append("where fassignorgunitid in (").append(delegQUSQLTemp.toString()).append(") ").append("and fdatabasedid='").append(standardInfo.getId().toString()).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    delegQualityMap.remove(rs.getString("fassignorgunitid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (!delegQualityMap.isEmpty()) {
                delegQUSQLTemp.setLength(0);
                Iterator delegQuality = delegQualityMap.values().iterator();
                while (delegQuality.hasNext()) {
                    delegQUSQLTemp.append(delegQuality.next()).append(",");
                }
                if (delegQUSQLTemp.length() > 0) {
                    delegQUSQLTemp.deleteCharAt(delegQUSQLTemp.length() - 1);
                }
                throw new QCSampleException(QCSampleException.NOT_ASSIGN_QCSTANDARD, new String[]{standardInfo.getName(), delegQUSQLTemp.append("\n").toString()});
            }
        }
        if (qCItemSQLTemp.length() > 0) {
            sql.setLength(0);
            qCItemSQLTemp.delete(qCItemSQLTemp.length() - 3, qCItemSQLTemp.length());
            sql.append("SELECT fdatabasedid||fassignorgunitid as mapid ").append("FROM T_QM_DATABASEDASSIGN where ").append(qCItemSQLTemp.toString());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    qCItemMap.remove(rs.getString("mapid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (!qCItemMap.isEmpty()) {
                qCItemSQLTemp.setLength(0);
                Iterator qCItem = qCItemMap.values().iterator();
                while (qCItem.hasNext()) {
                    qCItemSQLTemp.append("\n").append(qCItem.next());
                }
                throw new QCSampleException(QCSampleException.NOT_ASSIGN_QCITEM, new String[]{qCItemSQLTemp.toString()});
            }
        }
        int entrySize2 = info.getEntrys().size();
        for (int i = 0; i < entrySize2; ++i) {
            entryInfo = info.getEntrys().get(i);
            int itemEntrySize = entryInfo.getItemEntry().size();
            for (int j = 0; j < itemEntrySize; ++j) {
                itemEntryInfo = entryInfo.getItemEntry().get(j);
                if (itemEntryInfo.getDelegOrgUnit() == null) continue;
                this.isAuditAssignedItem(ctx, standardInfo, itemEntryInfo);
            }
        }
    }

    private void isAuditAssignedItem(Context ctx, QCStandardInfo qcStandard, QCSampleItemEntryInfo itementry) throws BOSException, EASBizException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        Locale local = ctx.getLocale();
        sb.appendSql("select  st.fnumber, st.fname_" + local + " from T_QM_QCStandardExtendAttr a, T_QM_QCStandard st" + " where a.FCheckedStatus<>2 and a.fparentid = st.fid and  a.FParentID = ");
        sb.appendParam((Object)qcStandard.getId().toString());
        sb.appendSql(" and a.fQualityOrgUnitid=");
        sb.appendParam((Object)itementry.getDelegOrgUnit().getId().toString());
        ResultSet rs = sb.exeQuery(ctx);
        try {
            if (rs.next()) {
                throw new QCSampleException(QCSampleException.QCSTANDARD_HASNOT_AUDIT, new Object[]{itementry.getDelegOrgUnit().getName(), rs.getString(2), rs.getString(1)});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean hasDestBill(Context ctx, String pk) throws EASBizException, BOSException {
        return QCSampleItemEntryFactory.getLocalInstance(ctx).exists("select * where parent='" + pk + "' and qenDownQty>0");
    }

    private boolean canCreateTo(Context ctx, String pk) throws EASBizException, BOSException {
        return !QCSampleItemEntryFactory.getLocalInstance(ctx).exists("select * where parent='" + pk + "' and (qenDownQty = 0 or qenDownQty is null)");
    }

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, model, serverActionManager);
        BOSObjectType srcType = QMUtils.getSourceBillType((QMCoreBillBaseInfo)model);
        if (new QCReinspectReqInfo().getBOSType().equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCReinspectReq4QCSampleAction());
        } else if (new QCRequestInfo().getBOSType().equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCRequest4QCSampleAction());
        }
    }

    @Override
    protected HashMap _qCSampleTransform(Context ctx, List idList) throws BOSException, EASBizException {
        int qCBillSucces = 0;
        int qCRequestSucces = 0;
        for (int i = 0; i < idList.size(); ++i) {
            HashMap resultMap = this.transformQCBill(ctx, (String)idList.get(i));
            qCBillSucces += ((Integer)resultMap.get(ToQCBillSucces)).intValue();
            qCRequestSucces += ((Integer)resultMap.get(ToQCRequestSucces)).intValue();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ToQCBillSucces, String.valueOf(qCBillSucces));
        map.put(ToQCRequestSucces, String.valueOf(qCRequestSucces));
        return map;
    }

    protected HashMap transformQCBill(Context ctx, String pk) throws BOSException, EASBizException {
        QCSampleInfo info = QCSampleFactory.getLocalInstance(ctx).getQCSampleInfo((IObjectPK)new ObjectUuidPK(pk));
        if (QMBillBaseStatusEnum.Audit != info.getBillStatus()) {
            throw new QCSampleException(QCSampleException.UNAUDIT_CANNOT_CREATETO);
        }
        if (this.canCreateTo(ctx, pk)) {
            throw new QCBillException(QCBillException.CAN_NOT_CREATETO_FOR_FLOWBILL);
        }
        HashMap<String, QCBillInfo> qCBillMap = new HashMap<String, QCBillInfo>();
        HashMap<String, QCRequestInfo> qCReqMap = new HashMap<String, QCRequestInfo>();
        QCBillInfo billInfo = null;
        QCRequestInfo requestInfo = null;
        QCBillSampleEntryInfo billSampleEntryInfo = null;
        QCRequestEntryInfo requestEntryInfo = null;
        QCSampleInfo sampleInfo = (QCSampleInfo)this.getCoreBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getSelectors());
        int entrySize = sampleInfo.getEntrys().size();
        for (int i = 0; i < entrySize; ++i) {
            QCSampleEntryInfo sampleEntryInfo = sampleInfo.getEntrys().get(i);
            String sampleNumber = sampleEntryInfo.getNumber();
            int itemEntrySize = sampleEntryInfo.getItemEntry().size();
            for (int j = 0; j < itemEntrySize; ++j) {
                int QCStrategyNumber;
                QCSampleItemEntryInfo SIEInfo = sampleEntryInfo.getItemEntry().get(j);
                SIEInfo.getQCItem();
                if (SIEInfo.getQenDownQty() != null && SIEInfo.getQenDownQty().compareTo(SysConstant.BIGZERO) > 0) continue;
                if (sampleInfo.getQualityOrgUnit().getId().toString().equals(SIEInfo.getDelegOrgUnit().getId().toString())) {
                    String qCGroupID = SIEInfo.getQCGroup().getId().toString();
                    if (!qCBillMap.containsKey(qCGroupID)) {
                        billInfo = this.createQCBillInfo(ctx, sampleInfo, SIEInfo);
                        billSampleEntryInfo = this.createQCBillSampleEntryInfo(sampleInfo, sampleEntryInfo, billInfo);
                        this.createQCBillEntryInfo(SIEInfo, billInfo, billSampleEntryInfo);
                        qCBillMap.put(qCGroupID, billInfo);
                        continue;
                    }
                    billInfo = (QCBillInfo)qCBillMap.get(qCGroupID);
                    billSampleEntryInfo = null;
                    for (int a = 0; a < billInfo.getSampleEntries().size(); ++a) {
                        QCBillSampleEntryInfo billEntryTemp = billInfo.getSampleEntries().get(a);
                        if (!sampleNumber.equals(billEntryTemp.getNumber())) continue;
                        billSampleEntryInfo = billEntryTemp;
                        break;
                    }
                    if (billSampleEntryInfo == null) {
                        billSampleEntryInfo = this.createQCBillSampleEntryInfo(sampleInfo, sampleEntryInfo, billInfo);
                    }
                    this.createQCBillEntryInfo(SIEInfo, billInfo, billSampleEntryInfo);
                    continue;
                }
                String delegOrgUnitID = SIEInfo.getDelegOrgUnit().getId().toString();
                if (!qCReqMap.containsKey(delegOrgUnitID)) {
                    requestInfo = this.createQCRequestInfo(ctx, sampleInfo, SIEInfo);
                    requestEntryInfo = this.createQCRequestEntryInfo(ctx, sampleInfo, sampleEntryInfo, requestInfo);
                    if (requestEntryInfo.getQcStandard() != null) {
                        QCStrategyNumber = this.getQCStrategy(ctx, requestEntryInfo.getQcStandard().getId().toString(), delegOrgUnitID);
                        requestEntryInfo.setQcStrategy(QCStrategyEnum.getEnum((int)QCStrategyNumber));
                    }
                    this.createQCRequestQcItemEntryInfo(SIEInfo, requestInfo, requestEntryInfo);
                    qCReqMap.put(delegOrgUnitID, requestInfo);
                    continue;
                }
                requestInfo = (QCRequestInfo)qCReqMap.get(delegOrgUnitID);
                requestEntryInfo = null;
                for (int b = 0; b < requestInfo.getEntrys().size(); ++b) {
                    QCRequestEntryInfo reqEntryTemp = requestInfo.getEntrys().get(b);
                    if (!sampleNumber.equals(reqEntryTemp.getSampleNumber())) continue;
                    requestEntryInfo = reqEntryTemp;
                    break;
                }
                if (requestEntryInfo == null) {
                    requestEntryInfo = this.createQCRequestEntryInfo(ctx, sampleInfo, sampleEntryInfo, requestInfo);
                }
                if (requestEntryInfo.getQcStandard() != null) {
                    QCStrategyNumber = this.getQCStrategy(ctx, requestEntryInfo.getQcStandard().getId().toString(), delegOrgUnitID);
                    requestEntryInfo.setQcStrategy(QCStrategyEnum.getEnum((int)QCStrategyNumber));
                }
                this.createQCRequestQcItemEntryInfo(SIEInfo, requestInfo, requestEntryInfo);
            }
        }
        return this.addBills(ctx, qCBillMap, qCReqMap);
    }

    protected HashMap addBills(Context ctx, HashMap qCBillMap, HashMap qCReqMap) throws BOSException, EASBizException {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        String toQCBillBotMappingID = null;
        String toQCRequestBotMappingID = null;
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        for (QCBillInfo billInfo : qCBillMap.values()) {
            if (billInfo.getId() == null) {
                billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            }
            btpManager.saveRelations((CoreBillBaseInfo)billInfo, this.getBOTRelation(ctx, (QMCoreBillBaseInfo)billInfo, toQCBillBotMappingID));
        }
        for (QCRequestInfo reqInfo : qCReqMap.values()) {
            if (reqInfo.getId() == null) {
                reqInfo.setId(BOSUuid.create((BOSObjectType)reqInfo.getBOSType()));
            }
            btpManager.saveRelations((CoreBillBaseInfo)reqInfo, this.getBOTRelation(ctx, (QMCoreBillBaseInfo)reqInfo, toQCRequestBotMappingID));
        }
        resultMap.put(ToQCBillSucces, new Integer(qCBillMap.size()));
        resultMap.put(ToQCRequestSucces, new Integer(qCReqMap.size()));
        return resultMap;
    }

    protected BOTRelationCollection getBOTRelation(Context ctx, QMCoreBillBaseInfo info, String botMappingID) {
        BOTRelationCollection bcolls = new BOTRelationCollection();
        BOTRelationInfo item = new BOTRelationInfo();
        item.setId(BOSUuid.create((BOSObjectType)new BOTRelation().getType()));
        item.setSrcObjectID(info.getSourceBillId());
        item.setSrcEntityID(new QCSampleInfo().getBOSType().toString());
        item.setDestObjectID(info.getId().toString());
        item.setDate((Date)new Timestamp(System.currentTimeMillis()));
        item.setDestEntityID(info.getBOSType().toString());
        item.setType(0);
        item.setBOTMappingID(botMappingID);
        item.setOperatorID(QMContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
        bcolls.add(item);
        return bcolls;
    }

    protected QCRequestInfo createQCRequestInfo(Context ctx, QCSampleInfo sampleInfo, QCSampleItemEntryInfo SIEInfo) throws EASBizException, BOSException {
        QCRequestInfo requestInfo = new QCRequestInfo();
        requestInfo.setBizDate(QMDateUtils.getDayBegin());
        requestInfo.setReqDate(QMDateUtils.transformTimestamp((Date)QMDateUtils.getCurrentTime()));
        requestInfo.setFromBOTP(true);
        requestInfo.setQualityOrgUnit(SIEInfo.getDelegOrgUnit());
        requestInfo.setReqOrgUnit(sampleInfo.getQualityOrgUnit().castToFullOrgUnitInfo());
        requestInfo.setSourceBillId(sampleInfo.getId().toString());
        requestInfo.setSourceBillNumber(sampleInfo.getNumber());
        requestInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        QCSourceBillTypeInfo sourceBillTypeInfo = new QCSourceBillTypeInfo();
        QCBizTypeEnum bizType = sampleInfo.getBillType().getQCBizType();
        requestInfo.setQcBizType(bizType);
        sourceBillTypeInfo.setId(BOSUuid.read((String)QCSourceBillTypeInfo.getQCSampleIDByBizType((QCBizTypeEnum)bizType)));
        if (bizType == QCBizTypeEnum.purCheck) {
            requestInfo.setSupplier(sampleInfo.getSupplier());
        }
        requestInfo.setSourceBillType(sourceBillTypeInfo);
        requestInfo.setBillType(sampleInfo.getBillType());
        IQMContextHelper iQCHelper = QMContextHelperFactory.getLocalInstance((Context)ctx);
        requestInfo.setCreator(iQCHelper.getCurrentUser());
        requestInfo.setBillStatus(QMBillBaseStatusEnum.SAVE);
        return requestInfo;
    }

    protected QCRequestEntryInfo createQCRequestEntryInfo(Context ctx, QCSampleInfo sampleInfo, QCSampleEntryInfo sampleEntryInfo, QCRequestInfo requestInfo) throws EASBizException, BOSException {
        QCRequestEntryInfo requestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(sampleInfo.getRequestEntryID()));
        requestEntryInfo.setId(null);
        requestEntryInfo.setDestBillId(null);
        requestEntryInfo.setRemark(sampleEntryInfo.getRemark());
        requestEntryInfo.setIsGenDestBill(false);
        requestEntryInfo.setNumber(String.valueOf(requestInfo.getEntrys().size() + 1));
        requestEntryInfo.setSampleState(QCBizStateEnum.isNull);
        requestEntryInfo.setReportState(QCBizStateEnum.isNull);
        requestEntryInfo.setQcBillState(QCBizStateEnum.isNull);
        requestEntryInfo.setSourceRequestEntryID(sampleInfo.getRequestEntryID());
        requestEntryInfo.setSourceRequestID(sampleInfo.getRequestID());
        requestEntryInfo.setSeq(requestInfo.getEntrys().size() + 1);
        requestEntryInfo.setSampleNumber(sampleEntryInfo.getNumber());
        requestEntryInfo.setMaterial(sampleInfo.getMaterial());
        requestEntryInfo.setQcStandard(sampleInfo.getQcStandard());
        requestEntryInfo.setQcStrategy(sampleInfo.getQCStrategy());
        requestEntryInfo.setSourceBillID(sampleInfo.getId().toString());
        requestEntryInfo.setSourceBillEntryID(sampleEntryInfo.getId().toString());
        requestEntryInfo.setSourceBillNumber(sampleInfo.getNumber());
        requestEntryInfo.setSampleShares(sampleEntryInfo.getSampleShares());
        requestEntryInfo.setEachSampleQty(sampleEntryInfo.getEachSampleQty());
        requestEntryInfo.setSampleQty(sampleEntryInfo.getSampleQty());
        requestEntryInfo.setEachSampleUnit(sampleEntryInfo.getUnit());
        requestEntryInfo.setParent(requestInfo);
        requestInfo.getEntrys().add(requestEntryInfo);
        return requestEntryInfo;
    }

    protected QCRequestQcItemEntryInfo createQCRequestQcItemEntryInfo(QCSampleItemEntryInfo SIEInfo, QCRequestInfo requestInfo, QCRequestEntryInfo requestEntryInfo) {
        QCRequestQcItemEntryInfo reqItemEntryInfo = new QCRequestQcItemEntryInfo();
        this.setQCItemBaseInfo(reqItemEntryInfo, SIEInfo);
        reqItemEntryInfo.setParent(requestInfo);
        reqItemEntryInfo.setEntry(requestEntryInfo);
        requestEntryInfo.getQcItemEntrys().add(reqItemEntryInfo);
        return reqItemEntryInfo;
    }

    protected QCBillEntryInfo createQCBillEntryInfo(QCSampleItemEntryInfo itemEntryInfo, QCBillInfo billInfo, QCBillSampleEntryInfo billSampleEntryInfo) {
        QCBillEntryInfo billEntryInfo = new QCBillEntryInfo();
        this.setQCItemBaseInfo(billEntryInfo, itemEntryInfo);
        billEntryInfo.setParent(billInfo);
        billEntryInfo.setSampleParent(billSampleEntryInfo);
        billSampleEntryInfo.getItemEntrys().add(billEntryInfo);
        return billEntryInfo;
    }

    protected QCBillSampleEntryInfo createQCBillSampleEntryInfo(QCSampleInfo sampleInfo, QCSampleEntryInfo sampleEntryInfo, QCBillInfo billInfo) {
        QCBillSampleEntryInfo billSampleEntryInfo = new QCBillSampleEntryInfo();
        billSampleEntryInfo.setNumber(sampleEntryInfo.getNumber());
        billSampleEntryInfo.setSampleDes(sampleEntryInfo.getSampleDes());
        billSampleEntryInfo.setSampleQty(sampleEntryInfo.getSampleQty());
        billSampleEntryInfo.setBaseSampleQty(sampleEntryInfo.getBaseSampleQty());
        billSampleEntryInfo.setUnit(sampleEntryInfo.getUnit());
        billSampleEntryInfo.setBaseUnit(sampleEntryInfo.getBaseUnit());
        billSampleEntryInfo.setReqFinishDate(sampleEntryInfo.getReqFinishDate());
        billSampleEntryInfo.setSaveTerm(sampleEntryInfo.getSaveTerm());
        billSampleEntryInfo.setSourceBillEntryID(sampleEntryInfo.getId().toString());
        billSampleEntryInfo.setSampleDate(sampleInfo.getSampleDate());
        billSampleEntryInfo.setRemark(sampleEntryInfo.getRemark());
        billSampleEntryInfo.setIsResResult(true);
        billSampleEntryInfo.setVerifyDate(new Date());
        billSampleEntryInfo.setSampleShares(sampleEntryInfo.getSampleShares());
        billSampleEntryInfo.setEachSampleQty(sampleEntryInfo.getEachSampleQty());
        billSampleEntryInfo.setParent(billInfo);
        billInfo.getSampleEntries().add(billSampleEntryInfo);
        return billSampleEntryInfo;
    }

    protected QCBillInfo createQCBillInfo(Context ctx, QCSampleInfo sampleInfo, QCSampleItemEntryInfo itemEntryInfo) throws EASBizException, BOSException {
        QCBillInfo billInfo = new QCBillInfo();
        billInfo.setBizDate(new Date());
        billInfo.setFromBOTP(true);
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        billInfo.setSrcOrgUnit(sampleInfo.getQualityOrgUnit());
        billInfo.setBillStatus(QMBillBaseStatusEnum.SAVE);
        billInfo.setRequestEntryID(sampleInfo.getRequestEntryID());
        billInfo.setRequestEntryNum(sampleInfo.getRequestEntryNum());
        billInfo.setRequestID(sampleInfo.getRequestID());
        billInfo.setRequestNum(sampleInfo.getRequestNum());
        billInfo.setBillType(sampleInfo.getBillType());
        QCSourceBillTypeInfo sourceBillTypeInfo = new QCSourceBillTypeInfo();
        sourceBillTypeInfo.setId(BOSUuid.read((String)QCSourceBillTypeInfo.getQCSampleIDByBizType((QCBizTypeEnum)sampleInfo.getBillType().getQCBizType())));
        billInfo.setSourceBillType(sourceBillTypeInfo);
        billInfo.setSourceBillId(sampleInfo.getId().toString());
        billInfo.setSourceBillNumber(sampleInfo.getNumber());
        billInfo.setQualityOrgUnit(itemEntryInfo.getDelegOrgUnit());
        billInfo.setQcGroup(itemEntryInfo.getQCGroup());
        billInfo.setMaterial(sampleInfo.getMaterial());
        billInfo.setQcStandard(sampleInfo.getQcStandard());
        billInfo.setSampleSolution(sampleInfo.getSampleSolution());
        QCRequestEntryInfo requestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(sampleInfo.getRequestEntryID()));
        billInfo.setIsConStandard(requestEntryInfo.isIsConStandard());
        billInfo.setQcSequence(sampleInfo.getQcSequence());
        IQMContextHelper iQCHelper = QMContextHelperFactory.getLocalInstance((Context)ctx);
        billInfo.setCreator(iQCHelper.getCurrentUser());
        return billInfo;
    }

    protected void setQCItemBaseInfo(QCItemBaseInfo destInfo, QCSampleItemEntryInfo srcInfo) {
        destInfo.setQCItem(srcInfo.getQCItem());
        destInfo.setCheckStep(srcInfo.getCheckStep());
        destInfo.setIsMustCheck(srcInfo.isIsMustCheck());
        destInfo.setIsKeyItem(srcInfo.isIsKeyItem());
        destInfo.setCheckValue(srcInfo.getCheckValue());
        destInfo.setCheckResult(srcInfo.getCheckResult());
        destInfo.setQCDescription(srcInfo.getQCDescription());
        destInfo.setJudgeType(srcInfo.getJudgeType());
        destInfo.setLowerLimit(srcInfo.getLowerLimit());
        destInfo.setLower(srcInfo.getLower());
        destInfo.setUpperLimit(srcInfo.getUpperLimit());
        destInfo.setUpper(srcInfo.getUpper());
        destInfo.setQCGroup(srcInfo.getQCGroup());
        destInfo.setChecker(srcInfo.getChecker());
        destInfo.setQCInstrument(srcInfo.getQCInstrument());
        destInfo.setSampleNumber(srcInfo.getSampleNumber());
        destInfo.setQcBillNumber(srcInfo.getQcBillNumber());
        destInfo.setItemType(srcInfo.getItemType());
        destInfo.setAnalysisMethod(srcInfo.getAnalysisMethod());
        destInfo.setQCItemAttr(srcInfo.getQCItemAttr());
        destInfo.setQCValueType(srcInfo.getQCValueType());
        destInfo.setDefaultValue(srcInfo.getDefaultValue());
        destInfo.setQCInstrumentGroup(srcInfo.getQCInstrumentGroup());
        destInfo.setQCFrequency(srcInfo.getQCFrequency());
        destInfo.setQCMethod(srcInfo.getQCMethod());
        destInfo.setStandardRequirement(srcInfo.getStandardRequirement());
        destInfo.setQCModifyMode(srcInfo.getQCModifyMode());
        destInfo.setDelegOrgUnit(srcInfo.getDelegOrgUnit());
        destInfo.setIsRuinous(srcInfo.isIsRuinous());
        destInfo.setIsBalanceItem(srcInfo.isIsBalanceItem());
        destInfo.setExpression(srcInfo.getExpression());
        destInfo.setEnums(srcInfo.getEnums());
        destInfo.setRemark(srcInfo.getRemark());
        destInfo.setUnit(srcInfo.getUnit());
        destInfo.setDataPrecision(srcInfo.getDataPrecision());
        destInfo.setSourceBillID(srcInfo.getParent().getId().toString());
        destInfo.setSourceBillEntryID(srcInfo.getId().toString());
        destInfo.setSampleShares(srcInfo.getSampleShares());
        destInfo.setQCValueAcquisitionMode(srcInfo.getQCValueAcquisitionMode());
        destInfo.setSampleProgram(srcInfo.getSampleProgram());
        destInfo.setAcValue(srcInfo.getAcValue());
        destInfo.setReValue(srcInfo.getReValue());
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.*"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sourceBillType.*"));
        sic.add(new SelectorItemInfo("sourceBillNumber"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("qcStandard.*"));
        sic.add(new SelectorItemInfo("qcStandard.billType.CheckHour"));
        sic.add(new SelectorItemInfo("samplePerson.*"));
        sic.add(new SelectorItemInfo("supplier.*"));
        sic.add(new SelectorItemInfo("qcCriterion.*"));
        sic.add(new SelectorItemInfo("sampleGroup.*"));
        sic.add(new SelectorItemInfo("sampleSolution"));
        sic.add(new SelectorItemInfo("qcSequence"));
        sic.add(new SelectorItemInfo("qCStrategy"));
        sic.add(new SelectorItemInfo("sampleQty"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("entrys.number"));
        sic.add(new SelectorItemInfo("entrys.description"));
        sic.add(new SelectorItemInfo("entrys.sampleQty"));
        sic.add(new SelectorItemInfo("entrys.sampleClaim"));
        sic.add(new SelectorItemInfo("entrys.sampleAddress"));
        sic.add(new SelectorItemInfo("entrys.sampleStatus.*"));
        sic.add(new SelectorItemInfo("entrys.observeCycle"));
        sic.add(new SelectorItemInfo("entrys.lastObsDate"));
        sic.add(new SelectorItemInfo("entrys.obsLeadTime"));
        sic.add(new SelectorItemInfo("entrys.saveTerm"));
        sic.add(new SelectorItemInfo("entrys.depPosition"));
        sic.add(new SelectorItemInfo("entrys.sampleDes"));
        sic.add(new SelectorItemInfo("entrys.closeBillNumber"));
        sic.add(new SelectorItemInfo("entrys.reqFinishDate"));
        sic.add(new SelectorItemInfo("entrys.sampleShares"));
        sic.add(new SelectorItemInfo("entrys.eachSampleQty"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCItem.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCItem.name"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCItem.group.id"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCItem.group.name"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCItem.group.number"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCItem.group.longNumber"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.checkStep"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.standardRequirement"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.isMustCheck"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.isKeyItem"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCFrequency.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCMethod.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.judgeType"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.lowerLimit"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.lower"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.upperLimit"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.upper"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.defaultValue"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.delegOrgUnit.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCGroup.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCInstrumentGroup.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCInstrument.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCModifyMode.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.description"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qenDownQty"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.parent.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.id"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.sampleEntryID"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.sampleShares"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.qCValueAcquisitionMode"));
        sic.add(new SelectorItemInfo("sampleDate"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.itemEntry.*"));
        return sic;
    }

    private QCSourceBillTypeInfo getSampleInfoSourceBillType(String sourceBillTypeID) {
        String id = null;
        if (sourceBillTypeID == null || sourceBillTypeID.length() <= 0) {
            id = "2eH0lXkJSGmyruNHY57llubqiQE=";
        } else if (sourceBillTypeID.equals("3ipz+O47Tl2jWeZXuaHqUubqiQE=")) {
            id = "2eH0lXkJSGmyruNHY57llubqiQE=";
        } else if (sourceBillTypeID.equals("Kf2yRiYGTleSq8GLlGZegubqiQE=")) {
            id = "O9U4Te37Qw+Rongn15Y+YObqiQE=";
        }
        BOSUuid oid = BOSUuid.read((String)id);
        QCSourceBillTypeInfo info = new QCSourceBillTypeInfo();
        info.setId(oid);
        return info;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
        for (QCSampleInfo sampleInfo : collection) {
            String reinspectReqTypeID = sampleInfo.getSourceBillType().getId().toString();
            if (!reinspectReqTypeID.equals(QCSourceBillTypeInfo.getQCBillIDByBizType((QCBizTypeEnum)QCBizTypeEnum.purCheck)) && !reinspectReqTypeID.equals(QCSourceBillTypeInfo.getQCBillIDByBizType((QCBizTypeEnum)QCBizTypeEnum.pdtDiscreteCheck))) continue;
            String sourceId = sampleInfo.getSourceBillId();
            QCReinspectReqInfo soucrceInfo = this.getQCReinspectReqInfo(ctx, sourceId);
            sampleInfo.setSourceBillType(this.getSampleInfoSourceBillType(reinspectReqTypeID));
            sampleInfo.setBillType(soucrceInfo.getBillType());
            MeasureUnitInfo srcUnit = soucrceInfo.getUnit();
            sampleInfo.setSampleQty(soucrceInfo.getSampleQty());
            sampleInfo.setUnit(srcUnit);
            if (sampleInfo.getTotalSampleShares() == null) {
                sampleInfo.setTotalSampleShares(soucrceInfo.getSampleShares());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)sampleInfo.getQcStandard().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)sampleInfo.getQualityOrgUnit().getId().toString()));
            view.setFilter(filter);
            QCStandardExtendAttrCollection coll = QCStandardExtendAttrFactory.getLocalInstance((Context)ctx).getQCStandardExtendAttrCollection(view);
            if (coll.size() == 1) {
                QCStandardExtendAttrInfo standardExtendAttrInfo = coll.get(0);
                QCStrategyEnum qcStrategy = standardExtendAttrInfo.getQCStrategy();
                sampleInfo.setQCStrategy(qcStrategy);
            }
            sampleInfo.setSampleDate(new Time(new Date().getTime()));
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)sampleInfo, sampleInfo.getQualityOrgUnit().getId().toString())) {
                String number = codingRuleManager.getNumber((IObjectValue)sampleInfo, sampleInfo.getQualityOrgUnit().getId().toString());
                sampleInfo.setNumber(number);
                sampleInfo.setNumber(number);
            } else {
                this.getCodingRuleStrategy().initNumber((ISuportCodingRule)this, ctx, (ISuportCodingRuleInfo)sampleInfo);
            }
            if (sampleInfo.getBillType() == null) {
                String requestID = sampleInfo.getRequestID();
                ObjectUuidPK reqID = new ObjectUuidPK(BOSUuid.read((String)requestID));
                QCRequestInfo requestInfo = QCRequestFactory.getLocalInstance(ctx).getQCRequestInfo((IObjectPK)reqID);
                sampleInfo.setBillType(requestInfo.getBillType());
            }
            String QCStandardID = sampleInfo.getQcStandard().getId().toString();
            String QualityOrgUnitID = sampleInfo.getQualityOrgUnit().getId().toString();
            int QCStrategyNumber = this.getQCStrategy(ctx, QCStandardID, QualityOrgUnitID);
            QCSampleEntryCollection entryCollection = sampleInfo.getEntrys();
            for (int i = 0; i < entryCollection.size(); ++i) {
                QCBizBillTypeInfo billTypeInfo;
                QCSampleEntryInfo entryInfo = entryCollection.get(i);
                BigDecimal checkHour = null;
                QCStandardInfo standardInfo = sampleInfo.getQcStandard();
                if (standardInfo != null && (billTypeInfo = standardInfo.getBillType()) != null) {
                    checkHour = billTypeInfo.getCheckHour();
                }
                int intCheckHour = 0;
                if (checkHour != null) {
                    intCheckHour = checkHour.intValue();
                }
                Calendar date = Calendar.getInstance();
                date.add(5, intCheckHour);
                entryInfo.setReqFinishDate(date.getTime());
                String sampleNumber = soucrceInfo.getSampleNumber();
                Map dataMap = this.getSomethingFromQCSampleEntry(ctx, sampleNumber);
                String sourceSampleEntryID = (String)dataMap.get("sourceSampleEntryID");
                String sampleEntryID = (String)dataMap.get("sampleEntryID");
                if (sourceSampleEntryID != null) {
                    entryInfo.setSourceSampleID(sourceSampleEntryID);
                } else {
                    entryInfo.setSourceSampleID(sampleEntryID);
                }
                entryInfo.setNumber(sampleInfo.getNumber() + "-001");
                if (30 == QCStrategyNumber) {
                    entryInfo.setSampleClaim((String)dataMap.get("SampleClaim"));
                    entryInfo.setSampleAddress((String)dataMap.get("SampleAddress"));
                    entryInfo.setSampleStatus((SampleStatusInfo)dataMap.get("SampleStatus"));
                    if (dataMap.get("SaveTerm") != null) {
                        entryInfo.setSaveTerm((BigDecimal)dataMap.get("SaveTerm"));
                    }
                    entryInfo.setDepPosition((String)dataMap.get("DepPosition"));
                }
                entryInfo.setSampleDes((String)dataMap.get("SampleDes"));
                String QCReinspectReqID = sampleInfo.getSourceBillId();
                if (QCReinspectReqID == null) continue;
                QCReinspectReqInfo ReinspectReqInfo = this.getQCReinspectReqInfo(ctx, QCReinspectReqID);
                QCReinspectReqEntryCollection ReinspectReqEntryCollection = ReinspectReqInfo.getEntrys();
                sampleInfo.getItemEntries().clear();
                for (int j = 0; j < ReinspectReqEntryCollection.size(); ++j) {
                    QCReinspectReqEntryInfo reinEntryInfo = ReinspectReqEntryCollection.get(j);
                    this.createNewQCSampleItemEntry(sampleInfo, entryInfo, reinEntryInfo);
                }
            }
        }
    }

    private void createNewQCSampleItemEntry(QCSampleInfo sampleInfo, QCSampleEntryInfo sampleEntryInfo, QCReinspectReqEntryInfo reinEntryInfo) {
        QCSampleItemEntryInfo itemEntryInfo = new QCSampleItemEntryInfo();
        itemEntryInfo.setParent(sampleInfo);
        itemEntryInfo.setSampleEntry(sampleEntryInfo);
        itemEntryInfo.setQCItem(reinEntryInfo.getQCItem());
        itemEntryInfo.setCheckStep(reinEntryInfo.getCheckStep());
        itemEntryInfo.setStandardRequirement(reinEntryInfo.getStandardRequirement());
        itemEntryInfo.setIsMustCheck(reinEntryInfo.isIsMustCheck());
        itemEntryInfo.setIsKeyItem(reinEntryInfo.isIsKeyItem());
        itemEntryInfo.setQCFrequency(reinEntryInfo.getQCFrequency());
        itemEntryInfo.setQCMethod(reinEntryInfo.getQCMethod());
        itemEntryInfo.setJudgeType(reinEntryInfo.getJudgeType());
        itemEntryInfo.setLower(reinEntryInfo.getLower());
        itemEntryInfo.setLowerLimit(reinEntryInfo.getLowerLimit());
        itemEntryInfo.setUpper(reinEntryInfo.getUpper());
        itemEntryInfo.setUpperLimit(reinEntryInfo.getUpperLimit());
        itemEntryInfo.setDefaultValue(reinEntryInfo.getDefaultValue());
        itemEntryInfo.setDelegOrgUnit(reinEntryInfo.getDelegOrgUnit());
        itemEntryInfo.setQCGroup(reinEntryInfo.getQCGroup());
        itemEntryInfo.setQCInstrumentGroup(reinEntryInfo.getQCInstrumentGroup());
        itemEntryInfo.setQCInstrument(reinEntryInfo.getQCInstrument());
        itemEntryInfo.setQCModifyMode(reinEntryInfo.getQCModifyMode());
        itemEntryInfo.setExpression(reinEntryInfo.getExpression());
        itemEntryInfo.setEnums(reinEntryInfo.getEnums());
        itemEntryInfo.setQCValueType(reinEntryInfo.getQCValueType());
        itemEntryInfo.setAnalysisMethod(reinEntryInfo.getAnalysisMethod());
        itemEntryInfo.setQCItemAttr(reinEntryInfo.getQCItemAttr());
        itemEntryInfo.setDataPrecision(reinEntryInfo.getDataPrecision());
        itemEntryInfo.setIsBalanceItem(reinEntryInfo.isIsBalanceItem());
        itemEntryInfo.setRemark(reinEntryInfo.getRemark());
        itemEntryInfo.setUnit(reinEntryInfo.getUnit());
        itemEntryInfo.setIsRuinous(reinEntryInfo.isIsRuinous());
        itemEntryInfo.setItemType(reinEntryInfo.getItemType());
        itemEntryInfo.setQCValueAcquisitionMode(reinEntryInfo.getQCValueAcquisitionMode());
        itemEntryInfo.setSampleShares(reinEntryInfo.getSampleShares());
        itemEntryInfo.setSampleProgram(reinEntryInfo.getSampleProgram());
        itemEntryInfo.setAcValue(reinEntryInfo.getAcValue());
        itemEntryInfo.setReValue(reinEntryInfo.getReValue());
        sampleInfo.getItemEntries().add(itemEntryInfo);
    }

    private int getQCStrategy(Context ctx, String QCStandardID, String QualityOrgUnitID) throws BOSException {
        String sql = "select FQCStrategy from T_QM_QCStandardExtendAttr where FParentID='" + QCStandardID + "'" + " and FQualityOrgUnitID='" + QualityOrgUnitID + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        int QCStrategyNumber = 0;
        try {
            while (set.next()) {
                QCStrategyNumber = set.getInt("FQCStrategy");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return QCStrategyNumber;
    }

    private QCReinspectReqInfo getQCReinspectReqInfo(Context ctx, String id) throws BOSException, EASBizException {
        IQCReinspectReq QCReinspectReq2 = QCReinspectReqFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        QCReinspectReqInfo info = QCReinspectReq2.getQCReinspectReqInfo((IObjectPK)pk);
        return info;
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM002", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    private Map getSomethingFromQCSampleEntry(Context ctx, String number) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String sql = "select FID,FSourceSampleID,FSampleDes,FSampleClaim,FSampleAddress,FSampleStatusID,FSaveTerm,FDepPosition from T_QM_QCSampleEntry where FNumber='" + number + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (set.next()) {
                String sampleEntryID = set.getString("FID");
                String sourceSampleEntryID = set.getString("FSourceSampleID");
                String SampleClaim = set.getString("FSampleClaim");
                String SampleAddress = set.getString("FSampleAddress");
                String SampleStatusID = set.getString("FSampleStatusID");
                String SaveTerm = set.getString("FSaveTerm");
                String DepPosition = set.getString("FDepPosition");
                String SampleDes = set.getString("FSampleDes");
                dataMap.put("sampleEntryID", sampleEntryID);
                dataMap.put("sourceSampleEntryID", sourceSampleEntryID);
                dataMap.put("SampleClaim", SampleClaim);
                dataMap.put("SampleAddress", SampleAddress);
                dataMap.put("DepPosition", DepPosition);
                dataMap.put("SampleDes", SampleDes);
                if (!StringUtil.isEmptyString((String)SampleStatusID)) {
                    SampleStatusInfo sampleInfo = SampleStatusFactory.getLocalInstance((Context)ctx).getSampleStatusInfo((IObjectPK)new ObjectStringPK(SampleStatusID));
                    dataMap.put("SampleStatus", sampleInfo);
                }
                if (SaveTerm != null) {
                    dataMap.put("SaveTerm", new BigDecimal(SaveTerm));
                    continue;
                }
                dataMap.put("SaveTerm", null);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return dataMap;
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager unAuditVerifyManager = super.getUnAuditVerifyManager(ctx, info);
        final Context tempContext = ctx;
        final QCSampleInfo sampleInfo = (QCSampleInfo)info;
        unAuditVerifyManager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                if (QCSampleControllerBean.this.hasDestBill(tempContext, sampleInfo.getId().toString())) {
                    throw new QCBillException(QCBillException.CAN_NOT_UNAUDIT_FOR_FLOWBILL);
                }
                return true;
            }
        });
        return unAuditVerifyManager;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        String auditPermName = "";
        QCSampleInfo model = (QCSampleInfo)info;
        QCBizTypeEnum qcBizType = model.getBillType().getQCBizType();
        if (null == qcBizType) {
            qcBizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(model.getBillType().getId())).getQCBizType();
        }
        if (qcBizType.equals((Object)QCBizTypeEnum.purCheck)) {
            auditPermName = "qm_QCPurSample_04audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.pdtProcessCheck)) {
            auditPermName = "qm_QCMMSample_04audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.pdtDiscreteCheck)) {
            auditPermName = "qm_QCMMSample_04audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.otherCheck)) {
            auditPermName = "";
        }
        return auditPermName;
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager verifyManager = super.getAuditVerifyManager(ctx, info);
        QCSampleAuditSerVerifyItem verifyItem = new QCSampleAuditSerVerifyItem(ctx, info);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }
}

