/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.IBatchFile;
import com.kingdee.eas.mm.lot.MMBatchIFileInfo;
import com.kingdee.eas.qm.basedata.IQCCertificateMaterialFacade;
import com.kingdee.eas.qm.basedata.IQCStandardItemEntry;
import com.kingdee.eas.qm.basedata.QCCertificateMaterialFacadeFactory;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.IQCReport;
import com.kingdee.eas.qm.qc.QCReportCollection;
import com.kingdee.eas.qm.qc.QCReportEntryCollection;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.QCertificateEntryCollection;
import com.kingdee.eas.qm.qc.QCertificateEntryInfo;
import com.kingdee.eas.qm.qc.QCertificateException;
import com.kingdee.eas.qm.qc.QCertificateInfo;
import com.kingdee.eas.qm.qc.ReportSourceTypeEnum;
import com.kingdee.eas.qm.qc.app.AbstractQCertificateControllerBean;
import com.kingdee.eas.qm.qc.app.reversesave.qcertificate.QCertificateSaveRelationAction;
import com.kingdee.eas.qm.qc.app.verify.QCertificateCreateFromVerifyItem;
import com.kingdee.eas.scm.sm.pur.IPurContractQCItemsNorth;
import com.kingdee.eas.scm.sm.pur.PurContractQCItemsNorthCollection;
import com.kingdee.eas.scm.sm.pur.PurContractQCItemsNorthFactory;
import com.kingdee.eas.scm.sm.pur.PurContractQCItemsNorthInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCertificateControllerBean
extends AbstractQCertificateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCertificateControllerBean");

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, model, serverActionManager);
        serverActionManager.addServerAction((IServerAction)new QCertificateSaveRelationAction());
    }

    @Override
    protected Map _getBtpCreateFromList(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Map map;
        QCertificateInfo info = (QCertificateInfo)model;
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        ArrayList<String> orderMaterials = new ArrayList<String>();
        this.getCreateFromVerifyManager(ctx, info).verify();
        IRowSet rs = null;
        Map relMap = null;
        if (null == info) {
            throw new BOSException("qcertificate value for create from is error!");
        }
        ReportSourceTypeEnum rptSrcType = info.getReportSrcType();
        MaterialInfo material = info.getMaterial();
        StorageOrgUnitInfo storageOrgUnit = info.getStorageOrgUnit();
        String lotNo = info.getPdtLotNo();
        Date bomDate = info.getBomDate();
        String materialID = material.getId().toString();
        String storageOrgUnitID = null;
        if (null != storageOrgUnit) {
            storageOrgUnitID = storageOrgUnit.getId().toString();
        }
        if (rptSrcType.getValue() == 10) {
            map = this.getSubMaterials(ctx, storageOrgUnitID, materialID, bomDate, true);
            IRowSet materials = (IRowSet)map.get("rtnMaterials");
            relMap = (Map)map.get("materialRelation");
            if (QMStringUtils.isEmpty((String)lotNo)) {
                rs = this.getBtpQCReports(ctx, materials, orderMaterials, info);
            } else {
                List list = this.getSubPdtBatchByMaterial(ctx, materialID, storageOrgUnitID, lotNo, relMap);
                rs = this.getBtpQCReports(ctx, list, orderMaterials, info);
            }
        } else if (rptSrcType.getValue() == 20) {
            map = this.getSubMaterials(ctx, storageOrgUnitID, materialID, bomDate, false);
            relMap = (Map)map.get("materialRelation");
            List list = this.getSubPdtBatchByMaterial(ctx, materialID, storageOrgUnitID, lotNo, relMap);
            rs = this.getBtpQCReports(ctx, list, orderMaterials, info);
        } else if (rptSrcType.getValue() == 30) {
            HashMap<String, String> orderMap = new HashMap<String, String>();
            orderMap.put("materialID", materialID);
            orderMaterials.add(materialID);
            HashMap<String, String> arrMap = new HashMap<String, String>();
            arrMap.put("materialID", materialID);
            arrMap.put("pdtLotNo", lotNo);
            Map[] arr = new Map[]{arrMap};
            rs = this.getBtpQCReports(ctx, arr, info);
        }
        List rtnList = this.orderRsRpts(rs, orderMaterials);
        rtnMap.put("relation", relMap);
        rtnMap.put("rtnResultSet", rtnList);
        return rtnMap;
    }

    private Map getSubMaterials(Context ctx, String storageOrgUnitID, String materialID, Date bomDate, boolean isOnlyForQCC) throws BOSException, EASBizException {
        IQCCertificateMaterialFacade ibiz = QCCertificateMaterialFacadeFactory.getLocalInstance((Context)ctx);
        Map map = ibiz.getAllCerSubMaterials(storageOrgUnitID, materialID, bomDate, isOnlyForQCC);
        return map;
    }

    private List getSubPdtBatchByMaterial(Context ctx, String materialID, String storageOrgUnitID, String pdtLotNo, Map relMap) throws BOSException, EASBizException {
        IBatchFile iBatchFile = BatchFileFactory.getLocalInstance((Context)ctx);
        List batchs = iBatchFile.getAllBatch(storageOrgUnitID, materialID, pdtLotNo, relMap);
        return batchs;
    }

    @Override
    protected IObjectPK _createCertificateInfo(Context ctx, List rptIdList, IObjectValue model) throws BOSException, EASBizException {
        QCertificateInfo info = (QCertificateInfo)model;
        IObjectPK pk = null;
        if (null != (info = this.getCreateBillInfo(ctx, rptIdList, info)).getId()) {
            pk = new ObjectUuidPK(info.getId());
            this._update(ctx, pk, (IObjectValue)info);
        } else {
            pk = this._save(ctx, (IObjectValue)info);
        }
        return pk;
    }

    private String getFieldByLanague(String field) {
        String name = null;
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L1 ";
        } else if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L3 ";
        } else if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L2 ";
        }
        return name;
    }

    private IRowSet getBtpQCReports(Context ctx, Map[] materialAndLot, QCertificateInfo info) throws BOSException {
        if (null == materialAndLot || materialAndLot.length <= 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        ReportSourceTypeEnum rptSrcType = info.getReportSrcType();
        String qcSrcBillTypeID = "sIOH0y8rQvuIBYATQMWEsebqiQE=','FLJ+4hsARhavfhBsrOo52+bqiQE=','9cJS6I4xTRKZaJv44sbGcebqiQE=','uGOiLznJSv6EdtXtUfNj5+bqiQE=','7KrHpnhhT+OdF/EZkG+E6ObqiQE=";
        sql.append(" select  \t\n");
        sql.append(" \t\t\t(case when e.FSourceBillTypeID = '").append("FLJ+4hsARhavfhBsrOo52+bqiQE=").append("' then c.FPurLotNo \t\t\n");
        sql.append(" \t\t\t\t  else c.FPdtLotNo \t\t\n");
        sql.append(" \t\t\t end) as pdtLotNo, \t\t\n");
        sql.append(" \t\t\ta.FCheckLot as checkLot, \t\t\n");
        sql.append(" \t\t\tb.FID as materialID, \t\t\t\n");
        sql.append(" \t\t\tb.FNumber as materialNum, \t\t\n");
        sql.append(" \t\t\tb.").append(this.getFieldByLanague("FName")).append(" as materialName, \t\n");
        sql.append(" \t\t\tb.FModel as materialMode, \t\t\n");
        sql.append(" \t\t\ta.FID as reportID, \t\t\t\t\n");
        sql.append(" \t\t\ta.FNumber as reportNum, \t\t\n");
        sql.append(" \t\t\ta.FReportDate as reportDate, \t\n");
        sql.append(" \t\t\tf.FQCBizType as bizType \t\n");
        sql.append(" from\t\tT_QM_QCReport as a \n");
        sql.append(" inner join T_BD_Material as b on a.FJudgeMaterialID = b.FID \n");
        sql.append(" inner join T_QM_QCRequestEntry as c on a.FRequestEntryID = c.FID \n");
        sql.append(" inner join T_QM_QCBizBillType as d on a.FBillTypeID = d.FID \n");
        sql.append(" inner join T_QM_QCRequest as e on a.FRequestID = e.FID \n");
        sql.append(" inner join T_QM_QCBizBillType as f on a.FBillTypeID = f.FID \n");
        sql.append(" where \t\t1 = 1 \n");
        sql.append(" and\t\ta.FBillStatus = ").append(30).append(" \n");
        sql.append(" and\t\t(d.FQCBizType = ").append(20).append(" \n");
        sql.append(" or d.FQCBizType = ").append(30).append(" \n");
        if (ReportSourceTypeEnum.material.equals((Object)rptSrcType)) {
            sql.append(" \t\t\t or\td.FQCBizType = ").append(10).append(" \n");
        }
        sql.append(")");
        sql.append(" and \t\ta.FQualityOrgUnitID = '").append(info.getQualityOrgUnit().getId().toString()).append("' \n");
        sql.append(" and ( \n");
        sql.append(" \t(c.FIsConStandard=0 \n");
        sql.append(" \t\tand\texists( \n");
        sql.append(" \t\t\tselect aa.FID from T_QM_QCReportEntry as aa \n");
        sql.append(" \t\t\tinner join T_QM_QCReport as bb on aa.FParentID = bb.FID \n");
        sql.append(" \t\t\tinner join T_QM_QCStandardItemEntries as cc on bb.FQCStandardID = cc.FParentID \n");
        sql.append(" \t\t\twhere cc.FIsVisibleForQCC = 1  \n");
        sql.append("\t\t\tand aa.FQCItemID = cc.FQCItemID \n");
        sql.append(" \t\t\tand aa.FParentID = a.FID \n");
        sql.append(" \t\t\tand aa.FCheckResult <> 30\n");
        sql.append(" \t\t\t)) \n");
        sql.append(" \tor (c.FIsConStandard=1\n");
        sql.append("\t\tand exists( \n");
        sql.append("\t\t\tselect aa.FID from T_QM_QCReportEntry as aa \n");
        sql.append(" \t\t\tinner join T_QM_QCReport as bb on aa.FParentID = bb.FID\n");
        sql.append(" \t\t\tinner join T_QM_QCRequestEntry as cc on bb.FRequestEntryID = cc.FID\n");
        sql.append(" \t\t\tinner join T_SM_PurContract as dd on cc.FPurContractID=dd.FID\n");
        sql.append(" \t\t\tinner join T_SM_PurContractEntry as ee on ee.FParentID=dd.FID\n");
        sql.append(" \t\t\tinner join T_SM_PurContractQCItemsNorth as ff on ff.FParentID=ee.FID\n");
        sql.append(" \t\t\twhere ff.FIsVisibleForQCC = 1\n");
        sql.append("\t\t\tand aa.FQCItemID = ff.FQCItemID\n");
        sql.append("\t\t\tand aa.FParentID = a.FID \n");
        sql.append("\t\t\tand aa.FCheckResult <> 30 \n");
        sql.append("\t\t\t) \n");
        sql.append("\t\t)\t \n");
        sql.append(" \t)\n");
        sql.append(" and\t\te.FSourceBillTypeID in ('").append(qcSrcBillTypeID).append("') \n");
        sql.append(" and\t\t( \n");
        for (int i = 0; i < materialAndLot.length; ++i) {
            if (null == materialAndLot[i]) continue;
            if (i > 0) {
                sql.append("\t\t\tor ");
            }
            String materialID = (String)materialAndLot[i].get("materialID");
            String lotNo = (String)materialAndLot[i].get("pdtLotNo");
            sql.append(" (b.FID = '").append(materialID).append("' ");
            if (!QMStringUtils.isEmpty((String)lotNo)) {
                sql.append("  and (c.FPdtLotNo = '").append(lotNo).append("'");
                sql.append("  \t\tor c.FPurLotNo = '").append(lotNo).append("')");
            }
            sql.append(") \n");
        }
        sql.append(" \t\t\t) \n");
        sql.append(" order by \tpdtLotNo,materialID \n");
        logger.info((Object)("getBtpQCReports sql: \n" + sql.toString()));
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getBtpQCReports(Context ctx, List batchsList, List orderMaterials, QCertificateInfo info) throws BOSException {
        if (null == batchsList || batchsList.size() <= 0) {
            return null;
        }
        Map[] arr = new Map[batchsList.size()];
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < batchsList.size(); ++i) {
            MMBatchIFileInfo batchFile = (MMBatchIFileInfo)batchsList.get(i);
            String materialID = batchFile.getMaterial().getId().toString();
            String pdtLotNo = batchFile.getLotNo();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("materialID", materialID);
            map.put("pdtLotNo", pdtLotNo);
            if (temp.indexOf(materialID + pdtLotNo) >= 0) continue;
            temp.add(materialID + pdtLotNo);
            orderMaterials.add(materialID);
            arr[i] = map;
        }
        return this.getBtpQCReports(ctx, arr, info);
    }

    private IRowSet getBtpQCReports(Context ctx, IRowSet materials, List orderMaterials, QCertificateInfo info) throws BOSException {
        if (null == materials || materials.size() <= 0) {
            return null;
        }
        Map[] arr = new Map[materials.size()];
        int index = 0;
        try {
            while (materials.next()) {
                String materialID = materials.getString("FMaterialID");
                if (orderMaterials.indexOf(materialID) >= 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("materialID", materialID);
                orderMaterials.add(materialID);
                arr[index] = map;
                ++index;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return this.getBtpQCReports(ctx, arr, info);
    }

    private List orderRsRpts(IRowSet rs, List orderMaterial) throws BOSException {
        if (null == orderMaterial || null == rs) {
            return null;
        }
        Collection rsCol = null;
        try {
            rsCol = rs.toCollection();
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
        ArrayList<List> rtnList = new ArrayList<List>();
        for (String currID : orderMaterial) {
            for (List rst : rsCol) {
                if (!currID.equals((String)rst.get(2))) continue;
                rtnList.add(rst);
            }
        }
        return rtnList;
    }

    private List getVisbleQCCItems(Context ctx, QCRequestEntryInfo reqEntry) throws BOSException {
        ArrayList<String> itemIdList;
        block4: {
            String oql;
            block3: {
                itemIdList = null;
                oql = "";
                boolean isConStd = reqEntry.isIsConStandard();
                if (!isConStd) break block3;
                oql = oql + "select FID from T_SM_PurContractEntry where FParentID='" + reqEntry.getPurContract().getId().toString() + "'";
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent3", (Object)oql, CompareType.INNER));
                filter.getFilterItems().add(new FilterItemInfo("isVisibleForQCC", (Object)new Boolean(true)));
                view.setFilter(filter);
                IPurContractQCItemsNorth ibiz = PurContractQCItemsNorthFactory.getLocalInstance((Context)ctx);
                PurContractQCItemsNorthCollection itemCol = ibiz.getPurContractQCItemsNorthCollection(view);
                if (null == itemCol) break block4;
                itemIdList = new ArrayList();
                for (PurContractQCItemsNorthInfo info : itemCol) {
                    itemIdList.add(info.getQcItem().getId().toString());
                }
                break block4;
            }
            QCStandardInfo standardInfo = reqEntry.getQcStandard();
            String standardId = standardInfo.getId().toString();
            IQCStandardItemEntry ibiz = QCStandardItemEntryFactory.getLocalInstance((Context)ctx);
            oql = "select qCItem.id where parent = '" + standardId + "' and isVisibleForQCC = 1";
            QCStandardItemEntryCollection itemEntrys = null;
            itemEntrys = ibiz.getQCStandardItemEntryCollection(oql);
            if (null != itemEntrys) {
                itemIdList = new ArrayList<String>();
                for (QCStandardItemEntryInfo entry : itemEntrys) {
                    itemIdList.add(entry.getQCItem().getId().toString());
                }
            }
        }
        return itemIdList;
    }

    private QCertificateInfo getCreateBillInfo(Context ctx, List rptIdList, QCertificateInfo info) throws EASBizException, BOSException {
        info.getEntrys().clear();
        HashSet set = new HashSet(rptIdList);
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        env.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"*", "qCStandard.itemEntries.*", "billType.*", "entrys.*", "entrys.qCModifyMode.dataPrecision", "entrys.qCItem.isVisibleForQCC", "entrys.qCItem.qCValueType"});
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"qCStandard.qCCriterion"});
        env.setSelector(sic);
        IQCReport iReport = QCReportFactory.getLocalInstance(ctx);
        QCReportCollection rptCol = iReport.getQCReportCollection(env);
        QCReportCollection orderedRptCol = this.orderReportCollectionByIDs(rptCol, rptIdList);
        if (null != orderedRptCol && orderedRptCol.size() > 0) {
            Iterator iter = orderedRptCol.iterator();
            while (iter.hasNext()) {
                List visibleItemIds;
                QCReportInfo rptInfo = (QCReportInfo)iter.next();
                QCReportEntryCollection rptEntryCol = rptInfo.getEntrys();
                String reqEntryID = rptInfo.getRequestEntryID();
                QCRequestEntryInfo reqEntry = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(reqEntryID));
                String pdtLotNo = "";
                info.setFromBOTP(true);
                if (rptInfo.getJudgeMaterial().getId().equals((Object)info.getMaterial().getId())) {
                    info.setQcStandard(rptInfo.getQCStandard());
                    info.setQcCriterion(rptInfo.getQCStandard().getQCCriterion());
                    info.setPdtDate(reqEntry.getPdtDate());
                }
                if (null == (visibleItemIds = this.getVisbleQCCItems(ctx, reqEntry)) || visibleItemIds.size() <= 0 || null == rptEntryCol || rptEntryCol.size() <= 0) continue;
                Iterator rptEntryIter = rptEntryCol.iterator();
                while (rptEntryIter.hasNext()) {
                    QCReportEntryInfo rptEntry = (QCReportEntryInfo)rptEntryIter.next();
                    if (!visibleItemIds.contains(rptEntry.getQCItem().getId().toString()) || QCResultJudgeEnum.cancel.equals((Object)rptEntry.getCheckResult())) continue;
                    QCertificateEntryInfo entry = new QCertificateEntryInfo();
                    entry.setSourceBillID(rptInfo.getId().toString());
                    entry.setReportNumber(rptInfo.getNumber());
                    if (rptInfo.getBillType().getQCBizType().getValue() == 10) {
                        entry.setReportTypeID("4o71JVzlT/avO5iRUJkDRObqiQE=");
                        pdtLotNo = reqEntry.getPurLotNo();
                    } else if (rptInfo.getBillType().getQCBizType().getValue() == 20 || rptInfo.getBillType().getQCBizType().getValue() == 30) {
                        entry.setReportTypeID("GnHD33UuQOmGDfR7lyYQGebqiQE=");
                        pdtLotNo = reqEntry.getPdtLotNo();
                    }
                    entry.setCheckValue(rptEntry.getCheckValue());
                    entry.setLower(rptEntry.getLower());
                    entry.setUpper(rptEntry.getUpper());
                    entry.setDefaultValue(rptEntry.getDefaultValue());
                    entry.setSourceBillEntryID(rptEntry.getId().toString());
                    entry.setQCItem(rptEntry.getQCItem());
                    entry.setQCMethod(rptEntry.getQCMethod());
                    entry.setQCDescription(rptEntry.getQCDescription());
                    entry.setLowerLimit(rptEntry.getLowerLimit());
                    entry.setUpperLimit(rptEntry.getUpperLimit());
                    entry.setCheckResult(rptEntry.getCheckResult());
                    entry.setIsMustCheck(rptEntry.isIsMustCheck());
                    entry.setIsKeyItem(rptEntry.isIsKeyItem());
                    entry.setStandardRequirement(rptEntry.getStandardRequirement());
                    entry.setQCFrequency(rptEntry.getQCFrequency());
                    entry.setJudgeMaterial(rptInfo.getJudgeMaterial());
                    entry.setMaterial(rptInfo.getMaterial());
                    entry.setPdtLotNo(pdtLotNo);
                    entry.setEnums(rptEntry.getEnums());
                    entry.setExpression(rptEntry.getExpression());
                    entry.setUnit(rptEntry.getUnit());
                    entry.setDataPrecision(rptEntry.getDataPrecision());
                    entry.setJudgeType(rptEntry.getJudgeType());
                    entry.setQCModifyMode(rptEntry.getQCModifyMode());
                    info.getEntrys().add(entry);
                }
            }
        }
        return info;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCertificateInfo info = (QCertificateInfo)model;
        this.getSubmitVerifyManager(ctx, info).verify();
        return super._submit(ctx, model);
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM011", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected IVerifyManager getCreateFromVerifyManager(Context ctx, QCertificateInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new QCertificateCreateFromVerifyItem(ctx, info));
        return verifymanager;
    }

    protected IVerifyManager getSubmitVerifyManager(Context ctx, final QCertificateInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                if (!info.isFromBOTP()) {
                    throw new QCertificateException(QCertificateException.HANDMADEISNOTALLOWED);
                }
                QCertificateEntryCollection entrys = info.getEntrys();
                if (null == entrys || entrys.size() <= 0) {
                    throw new QCertificateException(QCertificateException.ENTRYCANNOTNULL);
                }
                ArrayList<QCItemInfo> qcItems = new ArrayList<QCItemInfo>();
                String reItemNames = "";
                String reItemIds = "";
                for (int i = 0; i < entrys.size(); ++i) {
                    QCertificateEntryInfo entryInfo = entrys.get(i);
                    if (qcItems.contains(entryInfo.getQCItem()) && reItemIds.indexOf(entryInfo.getQCItem().getId().toString()) < 0) {
                        reItemNames = reItemNames + entryInfo.getQCItem().getName();
                        reItemIds = reItemIds + entryInfo.getQCItem().getId().toString();
                    }
                    qcItems.add(entryInfo.getQCItem());
                }
                if (!QMStringUtils.isEmpty((String)reItemNames)) {
                    reItemNames = reItemNames.substring(1);
                    throw new QCertificateException(QCertificateException.QCITEMCANNOTREPEAT, new Object[]{reItemNames});
                }
                return true;
            }
        });
        return verifymanager;
    }

    @Override
    protected IRowSet _chooseLot(Context ctx, String materialID, ReportSourceTypeEnum rptSrcType) throws BOSException, EASBizException {
        if (QMStringUtils.isEmpty((String)materialID) || null == rptSrcType) {
            throw new BOSException("the params of chooseLot error!");
        }
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        String fieldMatName = this.getFieldByLanague("FName");
        if (rptSrcType.getValue() == 30) {
            sql.append(" select distinct b.FNumber as materialNumber, \n");
            sql.append(" \t\tb.").append(fieldMatName).append(" as materialName, \n");
            sql.append(" \t\tb.FModel as materialMode, \n");
            sql.append(" \t\t(case when c.FSourceBillTypeID = '").append("FLJ+4hsARhavfhBsrOo52+bqiQE=").append("' then a.FPurLotNo \t\t\n");
            sql.append(" \t\t\t  else a.FPdtLotNo \t\t\n");
            sql.append(" \t\t end) as lotNo, \n");
            sql.append(" \t\tb.FID as materialID, \n");
            sql.append(" \t\t1 as id \n");
            sql.append(" from \tT_QM_QCRequestEntry as a \n");
            sql.append(" inner join T_BD_Material as b on a.FMaterialID = b.FID \n");
            sql.append(" inner join T_QM_QCRequest as c on a.FParentID = c.FID \n");
            sql.append(" where \ta.FMaterialID = ? \n");
            sql.append(" and \t((a.FPurLotNo is not null and c.FSourceBillTypeID = '").append("FLJ+4hsARhavfhBsrOo52+bqiQE=").append("') \n");
            sql.append(" \t \tor (a.FPdtLotNo is not null and (c.FSourceBillTypeID = '").append("sIOH0y8rQvuIBYATQMWEsebqiQE=").append("'");
            sql.append(" or c.FSourceBillTypeID = '").append("9cJS6I4xTRKZaJv44sbGcebqiQE=").append("'");
            sql.append(" or c.FSourceBillTypeID = '").append("uGOiLznJSv6EdtXtUfNj5+bqiQE=").append("'");
            sql.append(" or c.FSourceBillTypeID = '").append("7KrHpnhhT+OdF/EZkG+E6ObqiQE=").append("'");
            sql.append(")) \n");
            sql.append(") \n");
            sql.append(" and \tc.FSourceBillTypeID <> ?");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{materialID, "UzuilRaMQXKxCKhSpl2dyubqiQE="});
        } else {
            sql.append(" select \tdistinct b.FNumber as materialNumber, \n");
            sql.append(" \t\t\tb.").append(fieldMatName).append(" as materialName, \n");
            sql.append(" \t\t\tb.FModel as materialMode, \n");
            sql.append(" \t\t\ta.FLotNo as lotNo, \n");
            sql.append(" \t\t\tb.FID as materialID, \n");
            sql.append(" \t\t\ta.FID as id \n");
            sql.append(" from \t\tT_MM_BatchFile as a \n");
            sql.append(" inner join\tT_BD_Material as b on a.FMaterialID = b.FID \n");
            sql.append(" where \t\ta.FMaterialID = ? \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{materialID});
        }
        return rs;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) {
        return "qm_QCertificate_06audit";
    }

    protected QCReportCollection orderReportCollectionByIDs(QCReportCollection coll, List seqId) {
        if (null == coll || coll.size() <= 0 || null == seqId || seqId.size() <= 0) {
            return null;
        }
        QCReportCollection orderedColl = new QCReportCollection();
        for (int i = 0; i < seqId.size(); ++i) {
            BOSUuid id = BOSUuid.read((String)((String)seqId.get(i)));
            if (null == coll.get(id)) continue;
            orderedColl.add(coll.get(id));
            coll.removeObject(id);
        }
        if (null != coll && coll.size() > 0) {
            orderedColl.addCollection(coll);
        }
        return orderedColl;
    }
}

