/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.IBatchFile;
import com.kingdee.eas.mm.lot.MMBatchIFileInfo;
import com.kingdee.eas.qm.basedata.IQCCertificateMaterialFacade;
import com.kingdee.eas.qm.basedata.QCCertificateMaterialFacadeFactory;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.QCertificateInfo;
import com.kingdee.eas.qm.qc.ReportSourceTypeEnum;
import com.kingdee.eas.qm.qc.app.AbstractQCertificateCreateFacadeControllerBean;
import com.kingdee.eas.qm.qc.app.verify.QCertificateCreateFromVerifyItem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCertificateCreateFacadeControllerBean
extends AbstractQCertificateCreateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCertificateCreateFacadeControllerBean");

    @Override
    protected Map _getBtpCreateFromList(Context ctx, IObjectValue model, Map filterMap) throws BOSException, EASBizException {
        Map map;
        QCertificateInfo info = (QCertificateInfo)model;
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        ArrayList<String> orderMaterials = new ArrayList<String>();
        this.getCreateFromVerifyManager(ctx, info).verify();
        IRowSet rs = null;
        Map relMap = null;
        if (null == info) {
            throw new BOSException("qcertificate value for create from is error!");
        }
        ReportSourceTypeEnum rptSrcType = info.getReportSrcType();
        MaterialInfo material = info.getMaterial();
        StorageOrgUnitInfo storageOrgUnit = info.getStorageOrgUnit();
        String lotNo = info.getPdtLotNo();
        Date bomDate = info.getBomDate();
        String materialID = material.getId().toString();
        String storageOrgUnitID = null;
        if (null != storageOrgUnit) {
            storageOrgUnitID = storageOrgUnit.getId().toString();
        }
        if (rptSrcType.getValue() == 10) {
            map = this.getSubMaterials(ctx, storageOrgUnitID, materialID, bomDate, true);
            IRowSet materials = (IRowSet)map.get("rtnMaterials");
            relMap = (Map)map.get("materialRelation");
            if (QMStringUtils.isEmpty((String)lotNo)) {
                rs = this.getBtpQCReports(ctx, materials, orderMaterials, info, filterMap);
            } else {
                List list = this.getSubPdtBatchByMaterial(ctx, materialID, storageOrgUnitID, lotNo, relMap);
                rs = this.getBtpQCReports(ctx, list, orderMaterials, info, filterMap);
            }
        } else if (rptSrcType.getValue() == 20) {
            map = this.getSubMaterials(ctx, storageOrgUnitID, materialID, bomDate, false);
            relMap = (Map)map.get("materialRelation");
            List list = this.getSubPdtBatchByMaterial(ctx, materialID, storageOrgUnitID, lotNo, relMap);
            rs = this.getBtpQCReports(ctx, list, orderMaterials, info, filterMap);
        } else if (rptSrcType.getValue() == 30) {
            HashMap<String, String> orderMap = new HashMap<String, String>();
            orderMap.put("materialID", materialID);
            orderMaterials.add(materialID);
            HashMap<String, String> arrMap = new HashMap<String, String>();
            arrMap.put("materialID", materialID);
            arrMap.put("pdtLotNo", lotNo);
            Map[] arr = new Map[]{arrMap};
            rs = this.getBtpQCReports(ctx, arr, info, filterMap);
        }
        List rtnList = this.orderRsRpts(rs, orderMaterials);
        rtnMap.put("relation", relMap);
        rtnMap.put("rtnResultSet", rtnList);
        return rtnMap;
    }

    private IVerifyManager getCreateFromVerifyManager(Context ctx, QCertificateInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new QCertificateCreateFromVerifyItem(ctx, info));
        return verifymanager;
    }

    private Map getSubMaterials(Context ctx, String storageOrgUnitID, String materialID, Date bomDate, boolean isOnlyForQCC) throws BOSException, EASBizException {
        IQCCertificateMaterialFacade ibiz = QCCertificateMaterialFacadeFactory.getLocalInstance((Context)ctx);
        Map map = ibiz.getAllCerSubMaterials(storageOrgUnitID, materialID, bomDate, isOnlyForQCC);
        return map;
    }

    private IRowSet getBtpQCReports(Context ctx, IRowSet materials, List orderMaterials, QCertificateInfo info, Map filterMap) throws BOSException {
        if (null == materials || materials.size() <= 0) {
            return null;
        }
        Map[] arr = new Map[materials.size()];
        int index = 0;
        try {
            while (materials.next()) {
                String materialID = materials.getString("FMaterialID");
                if (orderMaterials.indexOf(materialID) >= 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("materialID", materialID);
                orderMaterials.add(materialID);
                arr[index] = map;
                ++index;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return this.getBtpQCReports(ctx, arr, info, filterMap);
    }

    private IRowSet getBtpQCReports(Context ctx, Map[] materialAndLot, QCertificateInfo info, Map filterMap) throws BOSException {
        if (null == materialAndLot || materialAndLot.length <= 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        ReportSourceTypeEnum rptSrcType = info.getReportSrcType();
        String qcSrcBillTypeID = "sIOH0y8rQvuIBYATQMWEsebqiQE=','FLJ+4hsARhavfhBsrOo52+bqiQE=','9cJS6I4xTRKZaJv44sbGcebqiQE=','uGOiLznJSv6EdtXtUfNj5+bqiQE=','7KrHpnhhT+OdF/EZkG+E6ObqiQE=','UzuilRaMQXKxCKhSpl2dyubqiQE=";
        sql.append(" select  \t\n");
        sql.append(" \t\t\t(case when e.FSourceBillTypeID = '").append("FLJ+4hsARhavfhBsrOo52+bqiQE=").append("' then c.FPurLotNo \t\t\n");
        sql.append(" \t\t\t\t  else c.FPdtLotNo \t\t\n");
        sql.append(" \t\t\t end) as pdtLotNo, \t\t\n");
        sql.append(" \t\t\ta.FCheckLot as checkLot, \t\t\n");
        sql.append(" \t\t\tb.FID as materialID, \t\t\t\n");
        sql.append(" \t\t\tb.FNumber as materialNum, \t\t\n");
        sql.append(" \t\t\tb.").append(this.getFieldByLanague("FName")).append(" as materialName, \t\n");
        sql.append(" \t\t\tb.FModel as materialMode, \t\t\n");
        sql.append(" \t\t\ta.FID as reportID, \t\t\t\t\n");
        sql.append(" \t\t\ta.FNumber as reportNum, \t\t\n");
        sql.append(" \t\t\ta.FReportDate as reportDate, \t\n");
        sql.append(" \t\t\tf.FQCBizType as bizType \t\n");
        sql.append(" from\t\tT_QM_QCReport as a \n");
        sql.append(" inner join T_BD_Material as b on a.FJudgeMaterialID = b.FID \n");
        sql.append(" inner join T_QM_QCRequestEntry as c on a.FRequestEntryID = c.FID \n");
        sql.append(" inner join T_QM_QCBizBillType as d on a.FBillTypeID = d.FID \n");
        sql.append(" inner join T_QM_QCRequest as e on a.FRequestID = e.FID \n");
        sql.append(" inner join T_QM_QCBizBillType as f on a.FBillTypeID = f.FID \n");
        sql.append(" left outer join T_QM_QCGroupPerson as p on a.FCheckerID = p.FID \n");
        sql.append(" where \t\t1 = 1 \n");
        sql.append(" and\t\ta.FBillStatus = ").append(30).append(" \n");
        sql.append(" and\t\t(d.FQCBizType = ").append(20).append(" \n");
        sql.append(" or d.FQCBizType = ").append(30).append(" \n");
        if (ReportSourceTypeEnum.material.equals((Object)rptSrcType)) {
            sql.append(" \t\t\t or\td.FQCBizType = ").append(10).append(" \n");
        }
        sql.append(")");
        sql.append(" and \t\ta.FQualityOrgUnitID = '").append(info.getQualityOrgUnit().getId().toString()).append("' \n");
        sql.append(" and ( \n");
        sql.append(" \t(c.FIsConStandard=0 \n");
        sql.append(" \t\tand\texists( \n");
        sql.append(" \t\t\tselect aa.FID from T_QM_QCReportEntry as aa \n");
        sql.append(" \t\t\tinner join T_QM_QCReport as bb on aa.FParentID = bb.FID \n");
        sql.append(" \t\t\tinner join T_QM_QCStandardItemEntries as cc on bb.FQCStandardID = cc.FParentID \n");
        sql.append(" \t\t\twhere cc.FIsVisibleForQCC = 1  \n");
        sql.append("\t\t\tand aa.FQCItemID = cc.FQCItemID \n");
        sql.append(" \t\t\tand aa.FParentID = a.FID \n");
        sql.append(" \t\t\tand aa.FCheckResult <> 30\n");
        sql.append(" \t\t\t)) \n");
        sql.append(" \tor (c.FIsConStandard=1\n");
        sql.append("\t\tand exists( \n");
        sql.append("\t\t\tselect aa.FID from T_QM_QCReportEntry as aa \n");
        sql.append(" \t\t\tinner join T_QM_QCReport as bb on aa.FParentID = bb.FID\n");
        sql.append(" \t\t\tinner join T_QM_QCRequestEntry as cc on bb.FRequestEntryID = cc.FID\n");
        sql.append(" \t\t\tinner join T_SM_PurContract as dd on cc.FPurContractID=dd.FID\n");
        sql.append(" \t\t\tinner join T_SM_PurContractEntry as ee on ee.FParentID=dd.FID\n");
        sql.append(" \t\t\tinner join T_SM_PurContractQCItemsNorth as ff on ff.FParentID=ee.FID\n");
        sql.append(" \t\t\twhere ff.FIsVisibleForQCC = 1\n");
        sql.append("\t\t\tand aa.FQCItemID = ff.FQCItemID\n");
        sql.append("\t\t\tand aa.FParentID = a.FID \n");
        sql.append("\t\t\tand aa.FCheckResult <> 30 \n");
        sql.append("\t\t\t) \n");
        sql.append("\t\t)\t \n");
        sql.append(" \t)\n");
        sql.append(" and\t\te.FSourceBillTypeID in ('").append(qcSrcBillTypeID).append("') \n");
        sql.append(" and\t\t( \n");
        StringBuffer materialIDsStr = new StringBuffer("'null'");
        for (int i = 0; i < materialAndLot.length; ++i) {
            if (null == materialAndLot[i]) continue;
            if (i > 0) {
                sql.append("\t\t\tor ");
            }
            String materialID = (String)materialAndLot[i].get("materialID");
            String lotNo = (String)materialAndLot[i].get("pdtLotNo");
            sql.append(" (b.FID = '").append(materialID).append("' ");
            if (!QMStringUtils.isEmpty((String)lotNo)) {
                sql.append("  and (c.FPdtLotNo = '").append(lotNo).append("'");
                sql.append("  \t\tor c.FPurLotNo = '").append(lotNo).append("')");
            }
            sql.append(") \n");
            materialIDsStr.append(",'").append(materialID).append("'");
        }
        if (filterMap.get("reportNumber") != null) {
            String reportNumber = (String)filterMap.get("reportNumber");
            sql.append(" and a.FNumber like '%").append(reportNumber).append("%' \n");
        }
        if (filterMap.get("checkerID") != null) {
            String checkerID = (String)filterMap.get("checkerID");
            sql.append(" and p.FID='").append(checkerID).append("' \n");
        }
        if (filterMap.get("description") != null) {
            String description = (String)filterMap.get("description");
            sql.append(" and a.FDescription like '%").append(description).append("%' \n");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (filterMap.get("reportDateFrom") != null) {
            Date reportDateFrom = (Date)filterMap.get("reportDateFrom");
            sql.append(" and a.FReportDate >= TO_DATE('").append(df.format(reportDateFrom)).append(" 00:00:00') \n");
        }
        if (filterMap.get("reportDateTo") != null) {
            Date reportDateTo = (Date)filterMap.get("reportDateTo");
            sql.append(" and a.FReportDate <= TO_DATE('").append(df.format(reportDateTo)).append(" 23:59:59') \n");
        }
        if (filterMap.get("isFirstCreate") != null && ((Boolean)filterMap.get("isFirstCreate")).booleanValue()) {
            sql.append(" and not exists ( \n").append("  select cerE.FSourceBillID from T_QM_QCertificateEntry as cerE \n").append("  where cerE.FSourceBillID=a.FID ").append(" ) \n");
        }
        sql.append(" \t\t\t) \n");
        sql.append(" order by \tpdtLotNo,materialID \n");
        logger.info((Object)("getBtpQCReports sql: \n" + sql.toString()));
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private List getSubPdtBatchByMaterial(Context ctx, String materialID, String storageOrgUnitID, String pdtLotNo, Map relMap) throws BOSException, EASBizException {
        IBatchFile iBatchFile = BatchFileFactory.getLocalInstance((Context)ctx);
        List batchs = iBatchFile.getAllBatch(storageOrgUnitID, materialID, pdtLotNo, relMap);
        return batchs;
    }

    private IRowSet getBtpQCReports(Context ctx, List batchsList, List orderMaterials, QCertificateInfo info, Map filterMap) throws BOSException {
        if (null == batchsList || batchsList.size() <= 0) {
            return null;
        }
        Map[] arr = new Map[batchsList.size()];
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < batchsList.size(); ++i) {
            MMBatchIFileInfo batchFile = (MMBatchIFileInfo)batchsList.get(i);
            String materialID = batchFile.getMaterial().getId().toString();
            String pdtLotNo = batchFile.getLotNo();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("materialID", materialID);
            map.put("pdtLotNo", pdtLotNo);
            if (temp.indexOf(materialID + pdtLotNo) >= 0) continue;
            temp.add(materialID + pdtLotNo);
            orderMaterials.add(materialID);
            arr[i] = map;
        }
        return this.getBtpQCReports(ctx, arr, info, filterMap);
    }

    private List orderRsRpts(IRowSet rs, List orderMaterial) throws SQLDataException {
        if (null == orderMaterial || null == rs) {
            return null;
        }
        Collection rsCol = null;
        try {
            rsCol = rs.toCollection();
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
        ArrayList<List> rtnList = new ArrayList<List>();
        for (String currID : orderMaterial) {
            for (List rst : rsCol) {
                if (!currID.equals((String)rst.get(2))) continue;
                rtnList.add(rst);
            }
        }
        return rtnList;
    }

    private Object getFieldByLanague(String field) {
        String name = null;
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L1 ";
        } else if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L3 ";
        } else if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L2 ";
        }
        return name;
    }
}

