/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelation;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitCollection;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.qm.basedata.ItemTypeEnum;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCGroupCollection;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.SampleHierarchyEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.common.QMBillBaseInfo;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.ServerAction;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.qm.common.ctx.QMContextHelperFactory;
import com.kingdee.eas.qm.common.util.QCBatchExecuteResult;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.common.util.QMVerifyHelper;
import com.kingdee.eas.qm.qc.CheckResultEnum;
import com.kingdee.eas.qm.qc.QCBillCollection;
import com.kingdee.eas.qm.qc.QCBillEntryInfo;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCBillSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCBizStateEnum;
import com.kingdee.eas.qm.qc.QCItemBaseCollection;
import com.kingdee.eas.qm.qc.QCItemBaseInfo;
import com.kingdee.eas.qm.qc.QCReportCollection;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestCollection;
import com.kingdee.eas.qm.qc.QCRequestEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestException;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.QCSampleBaseCollection;
import com.kingdee.eas.qm.qc.QCSampleBaseInfo;
import com.kingdee.eas.qm.qc.QCSampleCollection;
import com.kingdee.eas.qm.qc.QCSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCSampleInfo;
import com.kingdee.eas.qm.qc.QCSampleItemEntryInfo;
import com.kingdee.eas.qm.qc.QcUtils;
import com.kingdee.eas.qm.qc.ReportEntrySrcTypeEnum;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class QCRequestBatchCreateToBillServerAction
extends ServerAction
implements IServerAction {
    CoreBillBaseCollection qcSampleSrcBillCollection = new CoreBillBaseCollection();
    CoreBillBaseCollection qcBillSrcBillCollection = new CoreBillBaseCollection();
    CoreBillBaseCollection qcReportSrcBillCollection = new CoreBillBaseCollection();
    CoreBillBaseCollection qcRequestSrcBillCollection = new CoreBillBaseCollection();
    QCBatchExecuteResult batchResults = new QCBatchExecuteResult();
    QCRequestEntryCollection requestEntryColl = new QCRequestEntryCollection();
    private static final String QCRequestRes = "com.kingdee.eas.qm.qc.QCRequestResource";
    List listOK = new ArrayList();
    List listError = new ArrayList();

    public void handler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        int i;
        super.handler(ctx, event);
        Object[] args = event.getParams();
        List idArray = (List)args[0];
        List entriesIds = (List)args[1];
        this.doIt(ctx, idArray, entriesIds);
        BatchExecuteResult result = new BatchExecuteResult(this.listOK.size() + this.listError.size());
        for (i = 0; i < this.listOK.size(); ++i) {
            result.setReturnValue(i, this.listOK.get(i));
        }
        for (i = 0; i < this.listError.size(); ++i) {
            result.setException(this.listOK.size() + i, (Throwable)this.listError.get(i));
        }
        result.setBatchResult((Object)this.batchResults);
        event.setResult((Object)result);
    }

    protected void doIt(Context ctx, List idArray, List entriesIds) throws BOSException, EASBizException {
        QCRequestCollection coll = this.getSourceBillColl(ctx, idArray);
        this.fillSourceColl(ctx, entriesIds, coll);
        this.createQCSample(ctx, this.qcSampleSrcBillCollection);
        this.createQCBill(ctx, this.qcBillSrcBillCollection);
        this.createQCReport(ctx, this.qcReportSrcBillCollection);
    }

    private void createQCReport(Context ctx, CoreBillBaseCollection qcReportSrcBillCollection) throws BOSException, EASBizException {
        if (qcReportSrcBillCollection.size() == 0) {
            return;
        }
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        String destBillBosType = new QCReportInfo().getBOSType().toString();
        BTPTransformResult btpResult = btpManager.transform(qcReportSrcBillCollection, destBillBosType);
        QCReportCollection qcReportColl = (QCReportCollection)btpResult.getBills();
        String isDefaultPasskey = "";
        try {
            isDefaultPasskey = QcUtils.getProperties("checkResultKey");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < qcReportColl.size(); ++i) {
            QCReportInfo qcReport = qcReportColl.get(i);
            this.batchResults.addKeyListE("Report", qcReport.getId().toString());
            QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)qcReport, (String)"requestEntryID");
            String requestEntryID = qcReport.getRequestEntryID();
            QCRequestEntryInfo requestEntry = this.requestEntryColl.get(BOSUuid.read((String)requestEntryID));
            qcReport.setUnit(requestEntry.getUnit());
            qcReport.setBaseUnit(requestEntry.getBaseUnit());
            qcReport.setBillType(requestEntry.getQcStandard().getBillType());
            qcReport.setDeliverQty(requestEntry.getDeliverQty());
            qcReport.setDeliverBaseQty(requestEntry.getBaseDeliverQty());
            qcReport.setSampleUnit(requestEntry.getEachSampleUnit() == null ? requestEntry.getUnit() : requestEntry.getEachSampleUnit());
            qcReport.setSampleBaseUnit(requestEntry.getBaseUnit());
            QCSourceBillTypeInfo sbtype = this.getSourceBillType(ctx, requestEntry.getQcStandard().getBillType().getQCBizType());
            qcReport.setSourceBillType(sbtype);
            qcReport.setValidDate(requestEntry.getExpDate());
            qcReport.setRejectProcessMode(requestEntry.getQcStandard().getBillType().getRejectPMode());
            if (isDefaultPasskey.equals("1")) {
                qcReport.setPassQty(qcReport.getDeliverQty());
                qcReport.setPassBaseQty(qcReport.getDeliverBaseQty());
                qcReport.setCheckResult(CheckResultEnum.pass);
            }
            QCItemBaseCollection itemColl = this.getQCItemEntryInfo(ctx, requestEntry.getQcItemEntrys(), null);
            for (int j = 0; j < itemColl.size(); ++j) {
                QCItemBaseInfo item = itemColl.get(j);
                if (item.getItemType() == ItemTypeEnum.append) continue;
                QCReportEntryInfo itemEntry = new QCReportEntryInfo();
                this.tranceItem(item, itemEntry);
                itemEntry.setSourceBillNumber(qcReport.getSourceBillNumber());
                itemEntry.setSourceBillID(qcReport.getSourceBillId());
                itemEntry.setReportEntrySrcType(ReportEntrySrcTypeEnum.QCRequest);
                if (isDefaultPasskey.equals("1")) {
                    if (itemEntry.getDefaultValue() != null) {
                        itemEntry.setCheckValue(itemEntry.getDefaultValue());
                    }
                    if (itemEntry.isIsMustCheck() && itemEntry.getDefaultValue() != null) {
                        itemEntry.setCheckResult(QCResultJudgeEnum.pass);
                    } else if (!itemEntry.isIsMustCheck()) {
                        itemEntry.setCheckResult(QCResultJudgeEnum.cancel);
                    }
                }
                qcReport.getEntrys().add(itemEntry);
            }
        }
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        if (destBillCols != null && destBillCols.size() == 0) {
            return;
        }
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            QCRequestBatchCreateToBillServerAction.botpSave(ctx, botRelationCols, (QMCoreBillBaseInfo)destBillInfo);
        }
    }

    private void createQCBill(Context ctx, CoreBillBaseCollection qcBillSrcBillCollection) throws BOSException, EASBizException {
        int i;
        if (qcBillSrcBillCollection.size() == 0) {
            return;
        }
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        String destBillBosType = new QCBillInfo().getBOSType().toString();
        BTPTransformResult btpResult = btpManager.transform(qcBillSrcBillCollection, destBillBosType);
        QCBillCollection tempqcBillColl = (QCBillCollection)btpResult.getBills();
        QCBillCollection destBillCols = new QCBillCollection();
        QCRequestCollection qcRequestColl = new QCRequestCollection();
        for (int i2 = 0; i2 < tempqcBillColl.size(); ++i2) {
            QCBillInfo tempqcBill = tempqcBillColl.get(i2);
            this.batchResults.addKeyListE("bill", tempqcBill.getId().toString());
            QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)tempqcBill, (String)"requestEntryID");
            String requestEntryID = tempqcBill.getRequestEntryID();
            QCRequestEntryInfo requestEntry = this.requestEntryColl.get(BOSUuid.read((String)requestEntryID));
            QCRequestInfo requestInfo = (QCRequestInfo)qcBillSrcBillCollection.get((Object)requestEntry.getParent().getId());
            String number = tempqcBill.getNumber();
            if (QMStringUtils.isEmpty((String)tempqcBill.getNumber())) {
                String orgId;
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                CodingRuleInfo codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)tempqcBill, orgId = tempqcBill.getQualityOrgUnit().getId().toString());
                number = codingRuleInfo != null ? codingRuleManager.getNumber((IObjectValue)tempqcBill, orgId) : new ServerCodingRuleStrategy().getNewNumberWhenBotpBill(ctx, (QMCoreBillBaseInfo)tempqcBill);
                tempqcBill.setNumber(number);
            }
            tempqcBill.setQcSequence(1);
            QCSampleBaseCollection sampleColl = this.getSampeEntryInfo(ctx, requestEntry, requestEntry.getQcStandard());
            QCRequestBatchCreateToBillServerAction.initSampleNumber(number, sampleColl);
            QualityOrgUnitInfo mainOU = tempqcBill.getQualityOrgUnit();
            QCGroupCollection groupColl = new QCGroupCollection();
            QualityOrgUnitCollection delOucoll = new QualityOrgUnitCollection();
            for (int idx = 0; idx < requestEntry.getQcItemEntrys().size(); ++idx) {
                QCRequestQcItemEntryInfo item = requestEntry.getQcItemEntrys().get(idx);
                QualityOrgUnitInfo ou = item.getDelegOrgUnit();
                QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)item, (String)"delegOrgUnit");
                QCGroupInfo group = item.getQCGroup();
                if (QMEqualsUtils.equals((Object)ou, (Object)mainOU)) {
                    groupColl.add(group);
                    continue;
                }
                delOucoll.add(ou);
            }
            QCBillCollection qcBillColl = new QCBillCollection();
            for (int gi = 0; gi < groupColl.size(); ++gi) {
                QCGroupInfo group = groupColl.get(gi);
                QCBillInfo newqcBill = (QCBillInfo)tempqcBill.clone();
                newqcBill.setId(BOSUuid.create((BOSObjectType)newqcBill.getBOSType()));
                if (gi != 0) {
                    newqcBill.setNumber(null);
                }
                newqcBill.setQcGroup(group);
                qcBillColl.add(newqcBill);
                destBillCols.add(newqcBill);
            }
            for (int qci = 0; qci < qcBillColl.size(); ++qci) {
                QCBillInfo qcBill = qcBillColl.get(qci);
                this.buillQCDetail(ctx, requestEntry, sampleColl, qcBill);
            }
            QCRequestCollection qcReqColl = new QCRequestCollection();
            for (int qui = 0; qui < delOucoll.size(); ++qui) {
                QualityOrgUnitInfo delOu = delOucoll.get(qui);
                QCRequestInfo info = new QCRequestInfo();
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                QCSourceBillTypeInfo sbtype = this.getSourceBillType(ctx, requestEntry.getQcStandard().getBillType().getQCBizType());
                info.setSourceBillType(sbtype);
                info.setReqDate(requestInfo.getReqDate());
                info.setBillStatus(tempqcBill.getBillStatus());
                info.setEffectedStatus(tempqcBill.getEffectedStatus());
                info.setSourceBillId(requestInfo.getId().toString());
                info.setSourceBillNumber(requestInfo.getNumber());
                info.setReqOrgUnit(requestInfo.getQualityOrgUnit().castToFullOrgUnitInfo());
                info.setDescription(requestInfo.getDescription());
                info.setSupplier(requestInfo.getSupplier());
                info.setBillType(requestInfo.getBillType());
                QCSourceBillTypeInfo ssbtype = this.getSourceBillType(ctx, requestEntry.getQcStandard().getBillType().getQCBizType());
                info.setSourceBillType(ssbtype);
                info.setQcBizType(requestEntry.getQcStandard().getBillType().getQCBizType());
                qcRequestColl.add(info);
                qcReqColl.add(info);
                info.setQualityOrgUnit(delOu);
            }
            for (int reqi = 0; reqi < qcReqColl.size(); ++reqi) {
                QCRequestInfo info = qcReqColl.get(reqi);
                this.buildQCReqDetail(tempqcBill, requestEntry, sampleColl, info);
            }
        }
        String srcType = new QCRequestInfo().getBOSType().toString();
        int count = destBillCols.size();
        for (i = 0; i < count; ++i) {
            QCBillInfo destBillInfo = destBillCols.get(i);
            BOTRelationCollection bcolls = new BOTRelationCollection();
            BOTRelationInfo item = new BOTRelationInfo();
            item.setId(BOSUuid.create((BOSObjectType)new BOTRelation().getType()));
            item.setSrcObjectID(destBillInfo.getSourceBillId());
            item.setSrcEntityID(srcType);
            item.setDestObjectID(destBillInfo.getId().toString());
            item.setDestEntityID(destBillInfo.getBOSType().toString());
            item.setType(0);
            item.setOperatorID(QMContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
            bcolls.add(item);
            QCRequestBatchCreateToBillServerAction.botpSave(ctx, bcolls, (QMCoreBillBaseInfo)destBillInfo);
        }
        for (i = 0; i < qcRequestColl.size(); ++i) {
            QCRequestInfo rbill = qcRequestColl.get(i);
            BOTRelationCollection bcolls = new BOTRelationCollection();
            BOTRelationInfo item = new BOTRelationInfo();
            item.setId(BOSUuid.create((BOSObjectType)new BOTRelation().getType()));
            item.setSrcObjectID(rbill.getSourceBillId());
            item.setSrcEntityID(rbill.getBOSType().toString());
            item.setDestObjectID(rbill.getId().toString());
            item.setDestEntityID(rbill.getBOSType().toString());
            item.setType(0);
            item.setOperatorID(QMContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
            bcolls.add(item);
            QCRequestBatchCreateToBillServerAction.botpSave(ctx, bcolls, (QMCoreBillBaseInfo)rbill);
        }
    }

    private void buildQCReqDetail(QCBillInfo tempqcBill, QCRequestEntryInfo srcRequestEntry, QCSampleBaseCollection sampleColl, QCRequestInfo info) {
        QualityOrgUnitInfo reqMainOU = info.getQualityOrgUnit();
        for (int s = 0; s < sampleColl.size(); ++s) {
            QCSampleBaseInfo sample = sampleColl.get(s);
            QCRequestEntryInfo qcRequestEntryInfo = new QCRequestEntryInfo();
            qcRequestEntryInfo.setIsGenDestBill(false);
            qcRequestEntryInfo.setSampleState(QCBizStateEnum.isNull);
            qcRequestEntryInfo.setQcBillState(QCBizStateEnum.isNull);
            qcRequestEntryInfo.setReportState(QCBizStateEnum.isNull);
            qcRequestEntryInfo.setIsReturnResult(false);
            qcRequestEntryInfo.setSampleNumber(sample.getNumber());
            qcRequestEntryInfo.setDeliverQty(srcRequestEntry.getDeliverQty());
            this.tranceRequestEntry(srcRequestEntry, qcRequestEntryInfo);
            QCStandardExtendAttrCollection stdExtCol = srcRequestEntry.getQcStandard().getExtendAttr();
            for (int i = 0; i < stdExtCol.size(); ++i) {
                QCStandardExtendAttrInfo stdExtInfo = stdExtCol.get(i);
                if (!stdExtInfo.getQualityOrgUnit().getId().equals((Object)info.getQualityOrgUnit().getId())) continue;
                qcRequestEntryInfo.setQcStrategy(stdExtInfo.getQCStrategy());
                break;
            }
            qcRequestEntryInfo.setSourceBillID(srcRequestEntry.getParent().getId().toString());
            qcRequestEntryInfo.setSourceBillEntryID(srcRequestEntry.getId().toString());
            qcRequestEntryInfo.setSourceBillNumber(tempqcBill.getSourceBillNumber());
            qcRequestEntryInfo.setNumber(String.valueOf(info.getEntrys().size() + 1));
            qcRequestEntryInfo.setSourceRequestID(srcRequestEntry.getParent().getId().toString());
            qcRequestEntryInfo.setSourceRequestEntryID(srcRequestEntry.getId().toString());
            qcRequestEntryInfo.setEachSampleQty(srcRequestEntry.getEachSampleQty());
            qcRequestEntryInfo.setEachSampleUnit(srcRequestEntry.getEachSampleUnit());
            qcRequestEntryInfo.setSampleShares(srcRequestEntry.getSampleShares());
            qcRequestEntryInfo.setSampleQty(srcRequestEntry.getSampleQty());
            qcRequestEntryInfo.setSampleBaseQty(srcRequestEntry.getSampleBaseQty());
            info.getEntrys().add(qcRequestEntryInfo);
            QCItemBaseCollection itemColl = sample.getBaseItemEntries();
            for (int j = 0; j < itemColl.size(); ++j) {
                QCItemBaseInfo item = itemColl.get(j);
                if (!QMEqualsUtils.equals((Object)reqMainOU, (Object)item.getDelegOrgUnit())) continue;
                QCRequestQcItemEntryInfo qcrequestItem = new QCRequestQcItemEntryInfo();
                this.tranceItem(item, qcrequestItem);
                qcrequestItem.setEntry(qcRequestEntryInfo);
                qcRequestEntryInfo.getQcItemEntrys().add(qcrequestItem);
            }
        }
    }

    private void buillQCDetail(Context ctx, QCRequestEntryInfo requestEntry, QCSampleBaseCollection sampleColl, QCBillInfo qcBill) {
        QCGroupInfo mainQCgroup = qcBill.getQcGroup();
        qcBill.setQcSequence(1);
        qcBill.setQcStandard(requestEntry.getQcStandard());
        qcBill.setBillType(requestEntry.getQcStandard().getBillType());
        QCSourceBillTypeInfo sbtype = this.getSourceBillType(ctx, requestEntry.getQcStandard().getBillType().getQCBizType());
        qcBill.setSourceBillType(sbtype);
        for (int s = 0; s < sampleColl.size(); ++s) {
            QCSampleBaseInfo sample = sampleColl.get(s);
            QCBillSampleEntryInfo sampleEntryInfo = new QCBillSampleEntryInfo();
            this.tranceSample(sample, sampleEntryInfo);
            sampleEntryInfo.setId(BOSUuid.create((BOSObjectType)sampleEntryInfo.getBOSType()));
            sampleEntryInfo.setSourceBillEntryID(requestEntry.getId().toString());
            sampleEntryInfo.setNumber(sample.getNumber());
            qcBill.getSampleEntries().add(sampleEntryInfo);
            QCItemBaseCollection itemColl = sample.getBaseItemEntries();
            for (int j = 0; j < itemColl.size(); ++j) {
                QCItemBaseInfo item = itemColl.get(j);
                if (!QMEqualsUtils.equals((Object)mainQCgroup, (Object)item.getQCGroup())) continue;
                QCBillEntryInfo itemEntry = new QCBillEntryInfo();
                this.tranceItem(item, itemEntry);
                itemEntry.setSampleParent(sampleEntryInfo);
                itemEntry.setSourceBillEntryID(requestEntry.getId().toString());
                itemEntry.setSourceBillID(qcBill.getSourceBillId().toString());
                qcBill.getEntrys().add(itemEntry);
            }
        }
    }

    public static void initSampleNumber(String number, QCSampleBaseCollection info) {
        for (int i = 0; i < info.size(); ++i) {
            QCSampleBaseInfo entry = info.get(i);
            if (!QMStringUtils.isEmpty((String)entry.getNumber())) continue;
            String c = QMStringUtils.leftPadString((char)'0', (String)String.valueOf(i + 1), (int)3);
            entry.setNumber(number + "-" + c);
        }
    }

    private void createQCSample(Context ctx, CoreBillBaseCollection qcSampleSrcBillCollection) throws BOSException, EASBizException {
        if (qcSampleSrcBillCollection.size() == 0) {
            return;
        }
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        String destBillBosType = new QCSampleInfo().getBOSType().toString();
        BTPTransformResult btpResult = btpManager.transform(qcSampleSrcBillCollection, destBillBosType);
        QCSampleCollection qcSampleColl = (QCSampleCollection)btpResult.getBills();
        for (int i = 0; i < qcSampleColl.size(); ++i) {
            QCSampleInfo qcSample = qcSampleColl.get(i);
            this.batchResults.addKeyListE("sample", qcSample.getId().toString());
            QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)qcSample, (String)"requestEntryID");
            String requestID = qcSample.getRequestID();
            String requestEntryID = qcSample.getRequestEntryID();
            if (qcSample.getNumber() == null || qcSample.getNumber().trim().length() == 0) {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String orgId = qcSample.getQualityOrgUnit().getId().toString();
                CodingRuleInfo codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)qcSample, orgId);
                String number = null;
                number = codingRuleInfo != null ? codingRuleManager.getNumber((IObjectValue)qcSample, orgId) : new ServerCodingRuleStrategy().getNewNumberWhenBotpBill(ctx, (QMCoreBillBaseInfo)qcSample);
                qcSample.setNumber(number);
            }
            QCRequestEntryInfo requestEntry = this.requestEntryColl.get(BOSUuid.read((String)requestEntryID));
            QCRequestInfo reqInfo = (QCRequestInfo)qcSampleSrcBillCollection.get((Object)BOSUuid.read((String)requestID));
            qcSample.setQcSequence(1);
            qcSample.setUnit(requestEntry.getEachSampleUnit());
            qcSample.setBaseUnit(requestEntry.getBaseUnit());
            qcSample.setQcStandard(requestEntry.getQcStandard());
            qcSample.setBillType(requestEntry.getQcStandard().getBillType());
            QCSourceBillTypeInfo sbtype = this.getSourceBillType(ctx, requestEntry.getQcStandard().getBillType().getQCBizType());
            qcSample.setSourceBillType(sbtype);
            qcSample.setQCStrategy(requestEntry.getQcStrategy());
            QCSampleBaseCollection sampleEntryColl = this.getSampeEntryInfo(ctx, requestEntry, requestEntry.getQcStandard());
            QCRequestBatchCreateToBillServerAction.initSampleNumber(qcSample.getNumber(), sampleEntryColl);
            BigDecimal totalSampleShares = SysConstant.BIGZERO;
            BigDecimal sampleQty = SysConstant.BIGZERO;
            boolean isSrcReq = reqInfo.getSourceBillType().isQCRequest() || reqInfo.getSourceBillType().isQCSample();
            QCStandardInfo qcStandard = requestEntry.getQcStandard();
            for (int s = 0; s < sampleEntryColl.size(); ++s) {
                int j;
                QCSampleBaseInfo sampleEntry = sampleEntryColl.get(s);
                if (!isSrcReq && qcStandard.getSampleSolution() != SampleSolutionEnum.allCheck && !qcStandard.isIsSerialNumSimple()) {
                    QCItemBaseCollection itemEntrys = sampleEntry.getBaseItemEntries();
                    BigDecimal maxSampleShares = SysConstant.BIGZERO;
                    for (j = 0; j < itemEntrys.size(); ++j) {
                        QCItemBaseInfo itemInfo = itemEntrys.get(j);
                        if (itemInfo.getSampleShares() == null || maxSampleShares.compareTo(itemInfo.getSampleShares()) >= 0) continue;
                        maxSampleShares = itemInfo.getSampleShares();
                    }
                    sampleEntry.setSampleShares(maxSampleShares);
                }
                QCSampleEntryInfo entryInfo = new QCSampleEntryInfo();
                this.tranceSample(sampleEntry, entryInfo);
                entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                if (sampleEntry.getSampleShares() != null && sampleEntry.getSampleShares().compareTo(new BigDecimal(0)) != 0) {
                    totalSampleShares = totalSampleShares.add(sampleEntry.getSampleShares());
                    if (sampleEntry.getEachSampleQty() != null) {
                        entryInfo.setSampleQty(sampleEntry.getSampleShares().multiply(sampleEntry.getEachSampleQty()));
                        sampleQty = sampleQty.add(sampleEntry.getSampleShares().multiply(sampleEntry.getEachSampleQty()));
                    }
                }
                qcSample.getEntrys().add(entryInfo);
                QCItemBaseCollection itemColl = sampleEntry.getBaseItemEntries();
                for (j = 0; j < itemColl.size(); ++j) {
                    QCItemBaseInfo item = itemColl.get(j);
                    QCSampleItemEntryInfo itemEntry = new QCSampleItemEntryInfo();
                    itemEntry.setSampleEntry(entryInfo);
                    itemEntry.setParent(qcSample);
                    itemEntry.setQenDownQty(QMConstant.ZERO);
                    this.tranceItem(item, itemEntry);
                    qcSample.getItemEntries().add(itemEntry);
                }
            }
            qcSample.setSampleQty(sampleQty);
            qcSample.setTotalSampleShares(totalSampleShares);
        }
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        if (destBillCols != null && destBillCols.size() == 0) {
            return;
        }
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            QCRequestBatchCreateToBillServerAction.botpSave(ctx, botRelationCols, (QMCoreBillBaseInfo)((QMBillBaseInfo)destBillInfo));
        }
    }

    private QCSourceBillTypeInfo getSourceBillType(Context ctx, QCBizTypeEnum bizType) {
        String id = null;
        id = bizType == QCBizTypeEnum.purCheck ? "pqjXnRaWRgS4CbaMCLUFvObqiQE=" : (bizType == QCBizTypeEnum.pdtProcessCheck ? "PRkicFUqRKuW6RjTR/I9aebqiQE=" : (bizType == QCBizTypeEnum.pdtDiscreteCheck ? "PRkicFUqRKuW6RjTR/I9aebqiQE=" : (bizType == QCBizTypeEnum.invCheck ? "k94CQOyPSFG8+J5GqX2A7ebqiQE=" : "xj2csMpzQPaNtQIfzIYt3ubqiQE=")));
        BOSUuid oid = BOSUuid.read((String)id);
        QCSourceBillTypeInfo info = new QCSourceBillTypeInfo();
        info.setId(oid);
        return info;
    }

    public static void botpSave(Context ctx, BOTRelationCollection botRelationCols, QMCoreBillBaseInfo destBillInfo) throws BOSException, EASBizException {
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (destBillInfo.getBillStatus() == QMBillBaseStatusEnum.Submit) {
            btpManager.submitRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
        } else {
            btpManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
        }
    }

    private QCRequestCollection getSourceBillColl(Context ctx, List idArray) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idArray), CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.getSelector().add("*");
        ev.getSelector().add("qcItemEntrys.*");
        ev.getSelector().add("entrys.*");
        ev.getSelector().add("entrys.qcStandard.*");
        ev.getSelector().add("entrys.qcStandard.extendAttr.qCStrategy");
        ev.getSelector().add("entrys.qcStandard.extendAttr.qualityOrgUnit.id");
        ev.getSelector().add("entrys.qcStandard.billType.*");
        ev.getSelector().add("entrys.qcItemEntrys.*");
        ev.getSelector().add("entrys.qcItemEntrys.qCItem.id");
        ev.getSelector().add("entrys.qcItemEntrys.delegOrgUnit.id");
        ev.getSelector().add("entrys.qcItemEntrys.delegOrgUnit.name");
        ev.getSelector().add("entrys.qcItemEntrys.delegOrgUnit.number");
        ev.getSelector().add("entrys.relWeighEntrys.*");
        QCRequestCollection coll = QCRequestFactory.getLocalInstance(ctx).getQCRequestCollection(ev);
        return coll;
    }

    private void fillSourceColl(Context ctx, List entriesIds, QCRequestCollection coll) throws EASBizException, BOSException {
        for (int i = 0; i < coll.size(); ++i) {
            QCRequestInfo bill = coll.get(i);
            if (bill.getAuditor() == null) {
                this.listError.add(new QCRequestException(QCRequestException.UNAUDITCANNOTCREATETO, new Object[]{bill.getNumber()}));
                continue;
            }
            if (bill.getDescription() == null) {
                bill.setDescription("");
            }
            for (int j = 0; j < bill.getEntrys().size(); ++j) {
                QCRequestInfo tbill;
                QCRequestInfo oldbill;
                QCRequestEntryInfo entry = bill.getEntrys().get(j);
                if (entry.getRemark() == null) {
                    entry.setRemark("");
                }
                this.requestEntryColl.add(entry);
                if (entry.isIsGenDestBill() && entriesIds.contains(entry.getId().toString())) {
                    this.listError.add(new QCRequestException(QCRequestException.CANNOTREPEATCREATETO, new Object[]{bill.getNumber(), entry.getNumber()}));
                    continue;
                }
                if (entry.isIsGenDestBill() || !entriesIds.contains(entry.getId().toString())) continue;
                this.listOK.add(QMResourceUtils.getMessage((String)QCRequestRes, (String)"RequestEntryCreateSuccess", (String[])new String[]{bill.getNumber(), entry.getNumber()}));
                QCStrategyEnum qcStrategy = entry.getQcStrategy();
                if (qcStrategy == QCStrategyEnum.threeStepCheck) {
                    if (this.qcSampleSrcBillCollection.containsKey((Object)bill.getId())) {
                        oldbill = (QCRequestInfo)this.qcSampleSrcBillCollection.get((Object)bill.getId());
                        oldbill.getEntrys().add(entry);
                        continue;
                    }
                    tbill = (QCRequestInfo)bill.clone();
                    tbill.getEntrys().clear();
                    tbill.getEntrys().add(entry);
                    this.qcSampleSrcBillCollection.add((CoreBillBaseInfo)tbill);
                    continue;
                }
                if (qcStrategy == QCStrategyEnum.twoStepCheck) {
                    if (this.qcBillSrcBillCollection.containsKey((Object)bill.getId())) {
                        oldbill = (QCRequestInfo)this.qcBillSrcBillCollection.get((Object)bill.getId());
                        oldbill.getEntrys().add(entry);
                        continue;
                    }
                    tbill = (QCRequestInfo)bill.clone();
                    tbill.getEntrys().clear();
                    tbill.getEntrys().add(entry);
                    this.qcBillSrcBillCollection.add((CoreBillBaseInfo)tbill);
                    continue;
                }
                if (qcStrategy == QCStrategyEnum.oneStepCheck) {
                    if (this.qcReportSrcBillCollection.containsKey((Object)bill.getId())) {
                        oldbill = (QCRequestInfo)this.qcReportSrcBillCollection.get((Object)bill.getId());
                        oldbill.getEntrys().add(entry);
                        continue;
                    }
                    tbill = (QCRequestInfo)bill.clone();
                    tbill.getEntrys().clear();
                    tbill.getEntrys().add(entry);
                    this.qcReportSrcBillCollection.add((CoreBillBaseInfo)tbill);
                    continue;
                }
                throw new QCRequestException(QCRequestException.QCSTRATEGYERROR, new Object[]{qcStrategy});
            }
        }
    }

    public QCSampleBaseCollection getSampeEntryInfo(Context ctx, QCRequestEntryInfo entryInfo, QCStandardInfo qcStandard) throws EASBizException, BOSException {
        QCSampleBaseCollection coll;
        block17: {
            block15: {
                block16: {
                    coll = new QCSampleBaseCollection();
                    if (qcStandard.getSampleSolution() != SampleSolutionEnum.allCheck) break block15;
                    if (!qcStandard.isIsSerialNumSimple()) break block16;
                    int deliverQty = entryInfo.getDeliverQty().intValue();
                    int eachSampleQty = entryInfo.getEachSampleQty().intValue();
                    String[][] dataArrays = new String[1][3];
                    dataArrays[0][0] = entryInfo.getMaterial().getId().toString();
                    dataArrays[0][1] = entryInfo.getUnit().getId().toString();
                    dataArrays[0][2] = entryInfo.getEachSampleUnit().getId().toString();
                    BigDecimal deliverQtyBig = new BigDecimal(deliverQty);
                    BigDecimal eachSampleQtyBig = new BigDecimal(eachSampleQty);
                    BigDecimal[] rate = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getConvRatesByMaterial(dataArrays);
                    int count = deliverQtyBig.divide(eachSampleQtyBig.multiply(rate[0])).intValue();
                    if (count > 500) {
                        throw new QCRequestException(QCRequestException.DELIVERQTYMAX, new Object[]{new Integer(count)});
                    }
                    for (int i = 0; i < count; ++i) {
                        QCSampleBaseInfo info = this.createSampeInfo(entryInfo);
                        coll.add(info);
                        info.setSampleShares(QMConstant.ONE);
                        info.setSampleQty(info.getSampleShares().multiply(info.getEachSampleQty()));
                        QCItemBaseCollection itemEntry = this.getQCItemEntryInfo(ctx, entryInfo.getQcItemEntrys(), null);
                        info.getBaseItemEntries().addCollection(itemEntry);
                    }
                    if (entryInfo.getDeliverQty().compareTo(new BigDecimal(deliverQty)) <= 0) break block17;
                    QCSampleBaseInfo info = this.createSampeInfo(entryInfo);
                    coll.add(info);
                    info.setSampleShares(QMConstant.ZERO);
                    info.setSampleQty(info.getSampleShares().multiply(info.getEachSampleQty()));
                    QCItemBaseCollection itemEntry = this.getQCItemEntryInfo(ctx, entryInfo.getQcItemEntrys(), null);
                    info.getBaseItemEntries().addCollection(itemEntry);
                    break block17;
                }
                QCSampleBaseInfo info = this.createSampeInfo(entryInfo);
                coll.add(info);
                if (entryInfo.getMaterial() != null && entryInfo.getUnit() != null && entryInfo.getBaseUnit() != null) {
                    BigDecimal baseDeliverQty = QMUnitAndExchangeUtils.getExchangeQtyForServer((Context)ctx, (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getDeliverQty(), (String)entryInfo.getMaterial().getId().toString());
                    info.setSampleShares(baseDeliverQty.setScale(0, 1));
                } else {
                    info.setSampleShares(entryInfo.getDeliverQty().setScale(0, 1));
                }
                info.setSampleQty(info.getSampleShares().multiply(info.getEachSampleQty()));
                QCItemBaseCollection itemEntry = this.getQCItemEntryInfo(ctx, entryInfo.getQcItemEntrys(), null);
                info.getBaseItemEntries().addCollection(itemEntry);
                break block17;
            }
            if (qcStandard.getSampleHierarchy() == SampleHierarchyEnum.step) {
                ArrayList<String> steps = new ArrayList<String>();
                for (int i = 0; i < entryInfo.getQcItemEntrys().size(); ++i) {
                    QCRequestQcItemEntryInfo entry = entryInfo.getQcItemEntrys().get(i);
                    if (steps.contains(entry.getCheckStep())) continue;
                    steps.add(entry.getCheckStep());
                }
                int stepCount = steps.size();
                for (int i = 0; i < stepCount; ++i) {
                    QCSampleBaseInfo info = this.createSampeInfo(entryInfo);
                    if (entryInfo.getSampleShares() != null) {
                        info.setSampleShares(entryInfo.getSampleShares());
                    }
                    coll.add(info);
                    QCItemBaseCollection itemEntry = this.getQCItemEntryInfo(ctx, entryInfo.getQcItemEntrys(), (String)steps.get(i));
                    info.getBaseItemEntries().addCollection(itemEntry);
                }
            } else if (qcStandard.getSampleHierarchy() == SampleHierarchyEnum.solution) {
                QCSampleBaseInfo info = this.createSampeInfo(entryInfo);
                if (entryInfo.getSampleShares() != null) {
                    info.setSampleShares(entryInfo.getSampleShares());
                }
                QCItemBaseCollection itemEntry = this.getQCItemEntryInfo(ctx, entryInfo.getQcItemEntrys(), null);
                info.getBaseItemEntries().addCollection(itemEntry);
                coll.add(info);
            } else if (qcStandard.getSampleHierarchy() == SampleHierarchyEnum.item) {
                Iterator iter = entryInfo.getQcItemEntrys().iterator();
                while (iter.hasNext()) {
                    QCRequestQcItemEntryInfo itemEntryInfo = (QCRequestQcItemEntryInfo)iter.next();
                    QCSampleBaseInfo info = this.createSampeInfo(entryInfo);
                    if (entryInfo.getSampleShares() != null) {
                        info.setSampleShares(entryInfo.getSampleShares());
                    }
                    info.getBaseItemEntries().add(itemEntryInfo);
                    coll.add(info);
                }
            }
        }
        return coll;
    }

    private QCSampleBaseInfo createSampeInfo(QCRequestEntryInfo entryInfo) {
        QCSampleBaseInfo info = new QCSampleBaseInfo();
        info.setBaseUnit(entryInfo.getBaseUnit());
        info.setReqFinishDate(entryInfo.getReqFinishDate());
        info.setEachSampleQty(entryInfo.getEachSampleQty());
        info.setUnit(entryInfo.getEachSampleUnit());
        info.setSampleQty(QMConstant.ZERO);
        info.setSampleShares(entryInfo.getSampleShares());
        info.setSampleDate(QMDateUtils.getDayBegin());
        info.setVerifyDate(new Date());
        info.setIsResResult(true);
        return info;
    }

    public QCItemBaseCollection getQCItemEntryInfo(Context ctx, QCRequestQcItemEntryCollection itemEntries, String step) {
        QCItemBaseCollection coll = new QCItemBaseCollection();
        if (!QMStringUtils.isEmpty((String)step)) {
            for (int i = 0; i < itemEntries.size(); ++i) {
                QCRequestQcItemEntryInfo iteminfo = itemEntries.get(i);
                if (!step.equals(iteminfo.getCheckStep())) continue;
                QCItemBaseInfo item = this.createQCitemBaseInfo(iteminfo);
                coll.add(item);
            }
        } else {
            for (int i = 0; i < itemEntries.size(); ++i) {
                QCRequestQcItemEntryInfo iteminfo = itemEntries.get(i);
                QCItemBaseInfo item = this.createQCitemBaseInfo(iteminfo);
                coll.add(item);
            }
        }
        return coll;
    }

    private QCItemBaseInfo createQCitemBaseInfo(QCRequestQcItemEntryInfo iteminfo) {
        QCItemBaseInfo item = new QCItemBaseInfo();
        item.setQCItem(iteminfo.getQCItem());
        item.setDelegOrgUnit(iteminfo.getDelegOrgUnit());
        item.setQCGroup(iteminfo.getQCGroup());
        item.setUnit(iteminfo.getUnit());
        item.setQCInstrumentGroup(iteminfo.getQCInstrumentGroup());
        item.setQCInstrument(iteminfo.getQCInstrument());
        item.setDefaultValue(iteminfo.getDefaultValue());
        item.setExpression(iteminfo.getExpression());
        item.setEnums(iteminfo.getEnums());
        item.setQCModifyMode(iteminfo.getQCModifyMode());
        item.setStandardRequirement(iteminfo.getStandardRequirement());
        item.setQCFrequency(iteminfo.getQCFrequency());
        item.setQCMethod(iteminfo.getQCMethod());
        item.setItemType(iteminfo.getItemType());
        item.setIsMustCheck(iteminfo.isIsMustCheck());
        item.setIsKeyItem(iteminfo.isIsKeyItem());
        item.setIsRuinous(iteminfo.isIsRuinous());
        item.setIsBalanceItem(iteminfo.isIsBalanceItem());
        item.setCheckStep(iteminfo.getCheckStep());
        item.setRemark(iteminfo.getRemark());
        item.setJudgeType(iteminfo.getJudgeType());
        item.setUpper(iteminfo.getUpper());
        item.setUpperLimit(iteminfo.getUpperLimit());
        item.setLower(iteminfo.getLower());
        item.setLowerLimit(iteminfo.getLowerLimit());
        item.setQCValueType(iteminfo.getQCValueType());
        item.setAnalysisMethod(iteminfo.getAnalysisMethod());
        item.setQCItemAttr(iteminfo.getQCItemAttr());
        item.setCheckValue(iteminfo.getCheckValue());
        item.setCheckResult(iteminfo.getCheckResult());
        item.setQCDescription(iteminfo.getQCDescription());
        item.setJudgeType(iteminfo.getJudgeType());
        item.setChecker(iteminfo.getChecker());
        item.setSampleNumber(iteminfo.getSampleNumber());
        item.setQcBillNumber(iteminfo.getQcBillNumber());
        item.setVerifyFinishedDate(iteminfo.getVerifyFinishedDate());
        item.setQCItemAttr(iteminfo.getQCItemAttr());
        item.setDataPrecision(iteminfo.getDataPrecision());
        item.setQCValueAcquisitionMode(iteminfo.getQCValueAcquisitionMode());
        item.setSampleShares(iteminfo.getSampleShares());
        item.setAcValue(iteminfo.getAcValue());
        item.setReValue(iteminfo.getReValue());
        item.setSampleProgram(iteminfo.getSampleProgram());
        return item;
    }

    private void tranceSample(QCSampleBaseInfo srcSample, QCSampleBaseInfo destEntryInfo) {
        destEntryInfo.setSeq(srcSample.getSeq());
        destEntryInfo.setSampleQty(srcSample.getSampleQty());
        destEntryInfo.setSampleShares(srcSample.getSampleShares());
        destEntryInfo.setEachSampleQty(srcSample.getEachSampleQty());
        destEntryInfo.setUnit(srcSample.getUnit());
        destEntryInfo.setBaseUnit(srcSample.getBaseUnit());
        destEntryInfo.setReqFinishDate(srcSample.getReqFinishDate());
        destEntryInfo.setNumber(srcSample.getNumber());
        destEntryInfo.setVerifyDate(srcSample.getVerifyDate());
        destEntryInfo.setSampleDate(srcSample.getSampleDate());
        destEntryInfo.setIsResResult(srcSample.isIsResResult());
    }

    private void tranceItem(QCItemBaseInfo srcItem, QCItemBaseInfo destItemEntry) {
        destItemEntry.setQCItem(srcItem.getQCItem());
        destItemEntry.setDelegOrgUnit(srcItem.getDelegOrgUnit());
        destItemEntry.setQCGroup(srcItem.getQCGroup());
        destItemEntry.setUnit(srcItem.getUnit());
        destItemEntry.setQCInstrumentGroup(srcItem.getQCInstrumentGroup());
        destItemEntry.setQCInstrument(srcItem.getQCInstrument());
        destItemEntry.setDefaultValue(srcItem.getDefaultValue());
        destItemEntry.setExpression(srcItem.getExpression());
        destItemEntry.setEnums(srcItem.getEnums());
        destItemEntry.setQCModifyMode(srcItem.getQCModifyMode());
        destItemEntry.setStandardRequirement(srcItem.getStandardRequirement());
        destItemEntry.setQCFrequency(srcItem.getQCFrequency());
        destItemEntry.setQCMethod(srcItem.getQCMethod());
        destItemEntry.setIsRuinous(srcItem.isIsRuinous());
        destItemEntry.setIsBalanceItem(srcItem.isIsBalanceItem());
        destItemEntry.setItemType(srcItem.getItemType());
        destItemEntry.setIsMustCheck(srcItem.isIsMustCheck());
        destItemEntry.setIsKeyItem(srcItem.isIsKeyItem());
        destItemEntry.setCheckStep(srcItem.getCheckStep());
        destItemEntry.setRemark(srcItem.getRemark());
        destItemEntry.setJudgeType(srcItem.getJudgeType());
        destItemEntry.setUpper(srcItem.getUpper());
        destItemEntry.setUpperLimit(srcItem.getUpperLimit());
        destItemEntry.setLower(srcItem.getLower());
        destItemEntry.setLowerLimit(srcItem.getLowerLimit());
        destItemEntry.setQCValueType(srcItem.getQCValueType());
        destItemEntry.setAnalysisMethod(srcItem.getAnalysisMethod());
        destItemEntry.setQCItemAttr(srcItem.getQCItemAttr());
        destItemEntry.setRemark(srcItem.getRemark());
        destItemEntry.setDataPrecision(srcItem.getDataPrecision());
        destItemEntry.setQCValueAcquisitionMode(srcItem.getQCValueAcquisitionMode());
        destItemEntry.setSampleShares(srcItem.getSampleShares());
        destItemEntry.setAcValue(srcItem.getAcValue());
        destItemEntry.setReValue(srcItem.getReValue());
        destItemEntry.setSampleProgram(srcItem.getSampleProgram());
    }

    private void tranceRequestEntry(QCRequestEntryInfo entry, QCRequestEntryInfo newentry) {
        newentry.setMaterial(entry.getMaterial());
        newentry.setUnit(entry.getUnit());
        newentry.setBaseUnit(entry.getBaseUnit());
        newentry.setCheckHour(entry.getCheckHour());
        newentry.setReqFinishDate(entry.getReqFinishDate());
        newentry.setQcStandard(entry.getQcStandard());
        newentry.setIsConStandard(entry.isIsConStandard());
        newentry.setQcStandardType(entry.getQcStandardType());
        newentry.setQcType(entry.getQcType());
        newentry.setShelfLife(entry.getShelfLife());
        newentry.setExpDate(entry.getExpDate());
        newentry.setWareHouse(entry.getWareHouse());
        newentry.setOperation(entry.getOperation());
        newentry.setWpSeq(entry.getWpSeq());
        newentry.setPdtLine(entry.getPdtLine());
        newentry.setPdtLineWP(entry.getPdtLineWP());
        newentry.setIsConStandard(entry.isIsConStandard());
        newentry.setPurLotNo(entry.getPurLotNo());
        newentry.setPdtLotNo(entry.getPdtLotNo());
        newentry.setPdtDate(entry.getPdtDate());
        newentry.setPurDate(entry.getPurDate());
        newentry.setConNumber(entry.getConNumber());
        newentry.setOrderNumber(entry.getOrderNumber());
        newentry.setMmOrder(entry.getMmOrder());
        newentry.setPdtOrder(entry.getPdtOrder());
        newentry.setPurContract(entry.getPurContract());
        newentry.setFinishedDate(entry.getFinishedDate());
        newentry.setOppPdtLotNo(entry.getOppPdtLotNo());
        newentry.setIsKeyPart(entry.isIsKeyPart());
        newentry.setRecDeprt(entry.getRecDeprt());
        newentry.setSpecialQCReq(entry.getSpecialQCReq());
        newentry.setQcPerson(entry.getQcPerson());
        newentry.setQcBizObject(entry.getQcBizObject());
        newentry.setFirstCheck(entry.isFirstCheck());
        newentry.setClassGroup(entry.getClassGroup());
        newentry.setClassTeam(entry.getClassTeam());
        newentry.setFinishedLotNo(entry.getFinishedLotNo());
        newentry.setKeyWP(entry.isKeyWP());
        newentry.setTechnicsRoute(entry.getTechnicsRoute());
        newentry.setPdtLineWP(entry.getPdtLineWP());
        newentry.setFormula(entry.getFormula());
        newentry.setRemark(entry.getRemark());
    }

    private void genQCRptRelWeighEntrys(QCReportInfo rptInfo, QCRequestEntryInfo reqEntryInfo) {
    }
}

