/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCBillSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCBizStateEnum;
import com.kingdee.eas.qm.qc.app.verify.QCChildrenExistVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.QCSequenceVerifyItem;
import com.kingdee.eas.util.app.DbUtil;

public class QCBillToQCRequestAction
extends ReverseServerAction {
    public void beforeAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeAddnewHandler(ctx, event);
        if (event.getSrcObject() instanceof QCBillInfo) {
            QCBillInfo info = (QCBillInfo)event.getSrcObject();
            this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.start.getValue()));
            this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FIsGenDestBill", new Integer(1));
            QCBillToQCRequestAction.initSampleNumber(info);
        }
    }

    public static void initSampleNumber(QCBillInfo info) {
        for (int i = 0; i < info.getSampleEntries().size(); ++i) {
            QCBillSampleEntryInfo entry = info.getSampleEntries().get(i);
            if (entry.getNumber() != null && entry.getNumber().trim().length() != 0) continue;
            String c = QMStringUtils.leftPadString((char)'0', (String)String.valueOf(i + 1), (int)3);
            entry.setNumber(info.getNumber() + "-" + c);
        }
    }

    public void afterAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        IVerifyManager verifyManager;
        QCBillInfo info;
        super.beforeAuditHandler(ctx, event);
        if (event.getSrcObject() instanceof QCBillInfo && this.getQCSequenceVerifyItem(ctx, info = (QCBillInfo)event.getSrcObject(), new Integer(1)).verify() && !(verifyManager = this.getBeforeAuditVerifyManager(ctx, info)).verify()) {
            this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.end.getValue()));
        }
    }

    public void afterDeleteHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCBillInfo info;
        IVerifyManager verifyManager;
        super.beforeDeleteHandler(ctx, event);
        if (event.getSrcObject() instanceof QCBillInfo && !(verifyManager = this.getQCBillExistVerifyManager(ctx, info = (QCBillInfo)event.getSrcObject())).verify()) {
            this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.isNull.getValue()));
            verifyManager = this.getQCBillExistAndQCReqExistVerifyManager(ctx, info);
            if (!verifyManager.verify()) {
                this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FIsGenDestBill", new Integer(0));
            }
        }
    }

    public void beforeUnAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeUnAuditHandler(ctx, event);
        QCBillInfo info = (QCBillInfo)event.getSrcObject();
        IVerifyManager verifyManager = this.getBeforeUnAuditVerifyManager(ctx, info);
        if (verifyManager.verify()) {
            this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.start.getValue()));
        }
    }

    protected void updateQCRequestEntryFieldValue(Context ctx, String requestEntryID, String fieldName, Object fieldValue) throws BOSException {
        DbUtil.execute((Context)ctx, (String)(" update T_QM_QCRequestEntry set " + fieldName + " = " + fieldValue + " where fid='" + requestEntryID + "' "));
    }

    protected IVerifyManager getBeforeAuditVerifyManager(Context ctx, QCBillInfo info) {
        VerifyManager beforeAuditVerifyManager = new VerifyManager();
        beforeAuditVerifyManager.addVerifyItem((IVerifyItem)new QCChildrenExistVerifyItem(ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.qm.qc.app.F7QCBillQuery"), new String[]{"requestEntryID", "billStatus"}, new Object[]{info.getRequestEntryID(), new Integer(30)}, new CompareType[]{CompareType.EQUALS, CompareType.NOTEQUALS}));
        return beforeAuditVerifyManager;
    }

    protected IVerifyManager getBeforeUnAuditVerifyManager(Context ctx, QCBillInfo info) {
        VerifyManager beforeUnAuditManager = new VerifyManager();
        beforeUnAuditManager.addVerifyItem((IVerifyItem)new QCSequenceVerifyItem(ctx, info, new Integer(1)));
        return beforeUnAuditManager;
    }

    protected IVerifyManager getQCSequenceVerifyItem(Context ctx, QCBillInfo info, Integer qcSequence) {
        VerifyManager manager = new VerifyManager();
        manager.addVerifyItem((IVerifyItem)new QCSequenceVerifyItem(ctx, info, qcSequence));
        return manager;
    }

    protected IVerifyManager getQCBillExistVerifyManager(Context ctx, QCBillInfo info) {
        VerifyManager beforeDeleteVerifyManager = new VerifyManager();
        beforeDeleteVerifyManager.addVerifyItem((IVerifyItem)new QCChildrenExistVerifyItem(ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.qm.qc.app.F7QCBillQuery"), new String[]{"requestEntryID"}, new String[]{info.getRequestEntryID()}, new CompareType[]{CompareType.EQUALS}));
        return beforeDeleteVerifyManager;
    }

    private IVerifyManager getQCBillExistAndQCReqExistVerifyManager(Context ctx, QCBillInfo info) {
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new QCChildrenExistVerifyItem(ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.qm.qc.app.QCRequestQuery"), new String[]{"entrys.sourceBillEntryID"}, new String[]{info.getRequestEntryID()}, new CompareType[]{CompareType.EQUALS}));
        return verifyManager;
    }
}

