/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.QCBillEntryInfo;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCBillSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCBizStateEnum;
import com.kingdee.eas.qm.qc.app.verify.QCChildrenExistVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.QCSequenceVerifyItem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QCBillToQCSampleAction
extends ReverseServerAction {
    public void beforeAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeAddnewHandler(ctx, event);
        if (event.getSrcObject() instanceof QCBillInfo) {
            QCBillInfo info = (QCBillInfo)event.getSrcObject();
            this.reverseQCSampleItemGenDownQty(ctx, info, 1);
            if (this.getQCSequenceVerifyManager(ctx, info).verify()) {
                this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.start.getValue()));
            }
        }
    }

    public void afterAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        IVerifyManager verifyManager;
        QCChildrenExistVerifyItem verifyItem;
        QCBillInfo info;
        super.beforeAuditHandler(ctx, event);
        if (event.getSrcObject() instanceof QCBillInfo && this.getQCSequenceVerifyManager(ctx, info = (QCBillInfo)event.getSrcObject()).verify() && !(verifyItem = new QCChildrenExistVerifyItem(ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.qm.qc.app.F7QCBillQuery"), new String[]{"sourceBillId", "billStatus"}, new Object[]{info.getSourceBillId(), new Integer(30)}, new CompareType[]{CompareType.EQUALS, CompareType.NOTEQUALS})).verify() && (verifyManager = this.getBeforeAuditVerifyManager(ctx, info)).verify()) {
            this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.end.getValue()));
        }
    }

    public void afterDeleteHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeDeleteHandler(ctx, event);
        if (event.getSrcObject() instanceof QCBillInfo) {
            QCBillInfo info = (QCBillInfo)event.getSrcObject();
            this.reverseQCSampleItemGenDownQty(ctx, info, 2);
            if (this.getQCSequenceVerifyManager(ctx, info).verify()) {
                if (!this.getQCSampleGenQCBillExistVerifyManager(ctx, info).verify()) {
                    this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.isNull.getValue()));
                } else {
                    this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.start.getValue()));
                }
            }
        }
    }

    protected void reverseQCSampleItemGenDownQty(Context ctx, QCBillInfo info, int strategy) throws BOSException {
        if (info.getSampleEntries() != null && info.getSampleEntries().size() > 0) {
            ArrayList<String> sqlList = new ArrayList<String>();
            Iterator iter = info.getSampleEntries().iterator();
            String sql = null;
            while (iter != null && iter.hasNext()) {
                Iterator it;
                QCBillSampleEntryInfo sampleEntryInfo = (QCBillSampleEntryInfo)iter.next();
                if (sampleEntryInfo == null) continue;
                Iterator iterator = it = sampleEntryInfo.getItemEntrys() == null ? null : sampleEntryInfo.getItemEntrys().iterator();
                while (it != null && it.hasNext()) {
                    QCBillEntryInfo entryInfo = (QCBillEntryInfo)it.next();
                    if (entryInfo == null) continue;
                    switch (strategy) {
                        case 1: {
                            if (sampleEntryInfo.getSampleQty() == null) break;
                            sql = " Update T_QM_QCSampleItemEntry set FQenDownQty =" + sampleEntryInfo.getSampleQty().stripTrailingZeros().toPlainString() + " where fid = '" + entryInfo.getSourceBillEntryID() + "' ";
                            break;
                        }
                        case 2: {
                            sql = " Update T_QM_QCSampleItemEntry set FQenDownQty =0 where fid = '" + entryInfo.getSourceBillEntryID() + "'";
                        }
                    }
                    sqlList.add(sql);
                }
            }
            this.executeBatch(ctx, sqlList);
        }
    }

    protected void updateQCRequestEntryFieldValue(Context ctx, String requestEntryID, String fieldName, Object fieldValue) throws BOSException {
        DbUtil.execute((Context)ctx, (String)(" update T_QM_QCRequestEntry set " + fieldName + " = " + fieldValue + " where fid='" + requestEntryID + "' "));
    }

    protected void executeBatch(Context ctx, List sqlList) throws BOSException {
        Statement stmt = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            for (int i = 0; i < sqlList.size(); ++i) {
                if (sqlList.get(i) == null) continue;
                stmt.addBatch((String)sqlList.get(i));
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)cn);
    }

    public void beforeUnAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeUnAuditHandler(ctx, event);
        QCBillInfo info = (QCBillInfo)event.getSrcObject();
        IVerifyManager verifyManager = this.getQCSequenceVerifyManager(ctx, info);
        if (verifyManager.verify()) {
            this.updateQCRequestEntryFieldValue(ctx, info.getRequestEntryID(), "FQcBillState", new Integer(QCBizStateEnum.start.getValue()));
        }
    }

    protected IVerifyManager getQCSequenceVerifyManager(Context ctx, QCBillInfo info) throws EASBizException, BOSException {
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new QCSequenceVerifyItem(ctx, info, new Integer(1)));
        return verifyManager;
    }

    protected IVerifyManager getQCSampleGenQCBillExistVerifyManager(Context ctx, QCBillInfo info) {
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new QCChildrenExistVerifyItem(ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.qm.qc.app.F7QCBillQuery"), new String[]{"sourceBillId"}, new String[]{info.getSourceBillId()}, new CompareType[]{CompareType.EQUALS}));
        return verifyManager;
    }

    protected IVerifyManager getBeforeAuditVerifyManager(final Context ctx, final QCBillInfo info) {
        VerifyManager manager = new VerifyManager();
        manager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                boolean allEquals = true;
                String sql = "";
                if (info.getSampleEntries() != null && info.getSampleEntries().size() > 0) {
                    Iterator iter = info.getSampleEntries().iterator();
                    try {
                        while (iter.hasNext() && allEquals) {
                            IRowSet rs;
                            QCBillSampleEntryInfo sampleEntryInfo = (QCBillSampleEntryInfo)iter.next();
                            if (sampleEntryInfo.getSampleQty() == null || !(rs = DbUtil.executeQuery((Context)ctx, (String)(sql = " Select   a.fid  From T_QM_QCSampleItemEntry a, T_QM_QCBillEntry b Where      b.fsampleParentid = '" + sampleEntryInfo.getId().toString() + "' and b.fsourcebillid = a.fid and" + "      a.FQenDownQty<>" + sampleEntryInfo.getSampleQty().stripTrailingZeros().toPlainString()))).next()) continue;
                            allEquals = false;
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                return allEquals;
            }
        });
        return manager;
    }
}

