/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcreject;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.qc.IQCReportNCPPREntry;
import com.kingdee.eas.qm.qc.IQCRequest;
import com.kingdee.eas.qm.qc.QCRejectProcessInfo;
import com.kingdee.eas.qm.qc.QCRejectProcessRstEntryCollection;
import com.kingdee.eas.qm.qc.QCRejectProcessRstEntryInfo;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCReportNCPPREntryFactory;
import com.kingdee.eas.qm.qc.QCReportNCPPREntryInfo;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCResultReWriteTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Iterator;

public class QCRejectToQCReportAction
extends ReverseServerAction {
    public void handler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.handler(ctx, event);
        if ("BEFORE_SUBMITRESULT".equals(event.getEventName())) {
            this.beforeSubmitResultHandler(ctx, event);
            return;
        }
        if ("AFTER_SUBMITRESULT".equals(event.getEventName())) {
            this.afterSubmitResultHandler(ctx, event);
            return;
        }
        if ("BEFORE_REDORESULT".equals(event.getEventName())) {
            this.beforeRedoResultHandler(ctx, event);
            return;
        }
        if ("AFTER_REDORESULT".equals(event.getEventName())) {
            this.afterRedoResultHandler(ctx, event);
            return;
        }
    }

    public void afterAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.afterAuditHandler(ctx, event);
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        if (null == info || QMStringUtils.isEmpty((String)info.getSourceBillId())) {
            return;
        }
        this.writeBackRPRstToRpt(ctx, info, true);
    }

    public void afterUnAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.afterUnAuditHandler(ctx, event);
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        if (null == info || QMStringUtils.isEmpty((String)info.getSourceBillId())) {
            return;
        }
        this.writeBackRPRstToRpt(ctx, info, false);
    }

    public void afterAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeAddnewHandler(ctx, event);
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        this.saveWriteBack(ctx, info);
    }

    public void beforeDeleteHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeDeleteHandler(ctx, event);
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        this.deleteWriteBack(ctx, info);
    }

    public void beforeSubmitResultHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        this.submitResultWriteBack(ctx, info);
    }

    public void afterSubmitResultHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ");
        sql.append(this.getTableName(ctx));
        sql.append(" set FSubmitResult = 1 ");
        sql.append(" where FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getId().toString()});
    }

    public void beforeRedoResultHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        this.redoResultWriteBack(ctx, info);
    }

    public void afterRedoResultHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ");
        sql.append(this.getTableName(ctx));
        sql.append(" set FSubmitResult = 0 ");
        sql.append(" where FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getId().toString()});
    }

    private void saveWriteBack(Context ctx, QCRejectProcessInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_QM_QCReport ");
        sql.append(" set\tFIsMRB = ?");
        sql.append(" where\tfid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(1), info.getSourceBillId()});
    }

    private void deleteWriteBack(Context ctx, QCRejectProcessInfo info) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_QM_QCReport ");
        sql.append(" set\tFIsMRB = ?");
        sql.append(" where\tFID = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(0), info.getSourceBillId()});
    }

    private void resultWriteBack(Context ctx, QCRejectProcessInfo info, boolean flag) throws BOSException, EASBizException {
        this.writeBackRPRstToRpt(ctx, info, flag);
        String reqEntryID = info.getRequestEntryID();
        if (QMStringUtils.isEmpty((String)reqEntryID)) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        IQCRequest ibiz = QCRequestFactory.getLocalInstance(ctx);
        QCRequestInfo reqInfo = ibiz.getQCRequestInfo((IObjectPK)new ObjectUuidPK(info.getRequestID()));
        if (flag) {
            ibiz.submitResult(reqInfo, reqEntryID, info.getSourceBillId(), QCResultReWriteTypeEnum.unpass);
        } else {
            ibiz.cancleResult(reqInfo, reqEntryID, info.getSourceBillId(), QCResultReWriteTypeEnum.unpass);
        }
    }

    private void submitResultWriteBack(Context ctx, QCRejectProcessInfo info) throws BOSException, EASBizException {
        String reqEntryID = info.getRequestEntryID();
        if (info.getBillType().getRejectPMode().getValue() != 20) {
            return;
        }
        if (QMStringUtils.isEmpty((String)reqEntryID)) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        IQCRequest ibiz = QCRequestFactory.getLocalInstance(ctx);
        QCRequestInfo reqInfo = ibiz.getQCRequestInfo((IObjectPK)new ObjectUuidPK(info.getRequestID()));
        ibiz.submitResult(reqInfo, reqEntryID, info.getSourceBillId(), QCResultReWriteTypeEnum.unpass);
    }

    private void redoResultWriteBack(Context ctx, QCRejectProcessInfo info) throws BOSException, EASBizException {
        String reqEntryID = info.getRequestEntryID();
        if (info.getBillType().getRejectPMode().getValue() == 20) {
            if (QMStringUtils.isEmpty((String)reqEntryID)) {
                return;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entrys.*"));
            IQCRequest ibiz = QCRequestFactory.getLocalInstance(ctx);
            QCRequestInfo reqInfo = ibiz.getQCRequestInfo((IObjectPK)new ObjectUuidPK(info.getRequestID()));
            ibiz.cancleResult(reqInfo, reqEntryID, info.getSourceBillId(), QCResultReWriteTypeEnum.unpass);
        }
    }

    private void writeBackRPRstToRpt(Context ctx, String rejectProcessID, String rptBillID, boolean flag) throws BOSException {
        if (flag) {
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into T_QM_QCReportNCPPREntry \n");
            sql.append(" (FID,FMaterialID,FDPProcessModeID,FProcessOpinion,FQty,FBaseQty,FUnitID,FBaseUnitID,FValidDate,FRemark,FParentID, FSourceBillType) \n");
            sql.append(" select newbosid('C0F61517'),FMaterialID,FDPProcessModeID,FProcessOpinion,FQty,FBaseQty,FUnitID,FBaseUnitID,FValidDate,FRemark");
            sql.append(",'").append(rptBillID).append("'");
            sql.append(",'").append("+ZWvRMizR4uFjK1cs5RNp+bqiQE=").append("' \n");
            sql.append(" from\tT_QM_QCRejectRstEntry \n");
            sql.append(" where\tFParentID = ? \n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rejectProcessID});
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from T_QM_QCReportNCPPREntry \n");
            sql.append(" where \tFParentID = ? \n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rptBillID});
        }
    }

    private void writeBackRPRstToRpt(Context ctx, QCRejectProcessInfo info, boolean flag) throws BOSException, EASBizException {
        if (null == info || QMStringUtils.isEmpty((String)info.getSourceBillId())) {
            return;
        }
        String rptBillID = info.getSourceBillId();
        QCReportInfo rptInfo = new QCReportInfo();
        rptInfo.setId(BOSUuid.read((String)rptBillID));
        if (flag) {
            String sql = "select FSeq from T_QM_QCReportNCPPREntry where FParentID = ? order by FSeq desc";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rptBillID});
            int lastSeq = 0;
            try {
                if (null != rs && rs.next()) {
                    lastSeq = rs.getInt("FSeq");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            CoreBaseCollection ncppCol = new CoreBaseCollection();
            QCReportNCPPREntryInfo rptNCPPEntry = null;
            QCRejectProcessRstEntryCollection rstEntryCol = info.getRstEntry();
            if (null != rstEntryCol) {
                Iterator iter = rstEntryCol.iterator();
                while (iter.hasNext()) {
                    QCRejectProcessRstEntryInfo rstEntry = (QCRejectProcessRstEntryInfo)iter.next();
                    rptNCPPEntry = new QCReportNCPPREntryInfo();
                    rptNCPPEntry.setMaterial(rstEntry.getMaterial());
                    rptNCPPEntry.setDPProcessMode(rstEntry.getDPProcessMode());
                    rptNCPPEntry.setProcessOpinion(rstEntry.getProcessOpinion());
                    rptNCPPEntry.setQty(rstEntry.getQty());
                    rptNCPPEntry.setBaseQty(rstEntry.getBaseQty());
                    rptNCPPEntry.setUnit(rstEntry.getUnit());
                    rptNCPPEntry.setBaseUnit(rstEntry.getBaseUnit());
                    rptNCPPEntry.setValidDate(rstEntry.getValidDate());
                    rptNCPPEntry.setRemark(rstEntry.getRemark());
                    rptNCPPEntry.setParent(rptInfo);
                    QCSourceBillTypeInfo rejectBillTypeInfo = new QCSourceBillTypeInfo();
                    rejectBillTypeInfo.setId(BOSUuid.read((String)"+ZWvRMizR4uFjK1cs5RNp+bqiQE="));
                    rptNCPPEntry.setSourceBillType(rejectBillTypeInfo);
                    rptNCPPEntry.setSourceBillID(info.getId().toString());
                    rptNCPPEntry.setSourceBillNumber(info.getNumber());
                    rptNCPPEntry.setSourceBillEntryID(rstEntry.getId().toString());
                    rptNCPPEntry.setSeq(++lastSeq);
                    ncppCol.add((CoreBaseInfo)rptNCPPEntry);
                }
                IQCReportNCPPREntry ibiz = QCReportNCPPREntryFactory.getLocalInstance(ctx);
                ibiz.addnew(ncppCol);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from T_QM_QCReportNCPPREntry \n");
            sql.append(" where \tFParentID = ? \n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rptBillID});
        }
    }

    public String getTableName(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)"2010B1A2"));
        return entity.getTable().getName();
    }
}

