/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.basedata.QCPurBizEnum;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCReturnResultCollection;
import com.kingdee.eas.qm.qc.QCReturnResultInfo;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCRequestReverseSaveAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCRequestReverseSaveUtils;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCheckFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCheckInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;

public class PurReceivalBill4QCRequestAction
extends QCRequestReverseSaveAction {
    @Override
    public String getSrcBillEntryTbl() {
        return "T_IM_PurReceivalEntry";
    }

    @Override
    public String[] getBaseQty() {
        return new String[]{"FBaseQty", "-FReverseBaseQty"};
    }

    @Override
    public String[] getBaseQty(boolean isWeigh) {
        if (isWeigh) {
            return new String[]{"CFSupplyBaseQty", "-FReverseBaseQty"};
        }
        return this.getBaseQty();
    }

    @Override
    public String[] getQty() {
        return new String[]{"fqty", "-FReverseQty"};
    }

    @Override
    public String[] getQty(boolean isWeigh) {
        if (isWeigh) {
            return new String[]{"CFSupplyQty", "-FReverseQty"};
        }
        return this.getQty();
    }

    @Override
    public String getBaseDeliverQty() {
        return "FCheckBaseQty";
    }

    @Override
    public String getDeliverQty() {
        return "FCheckQty";
    }

    @Override
    public String getBaseUnDeliverQty() {
        return "FUnCheckBaseQty";
    }

    @Override
    public String getUnDeliverQty() {
        return "FUnCheckQty";
    }

    @Override
    public BigDecimal[] getQtyAry(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo, QCReturnResultCollection rsList) throws BOSException, EASBizException {
        return QCRequestReverseSaveUtils.getPurManuQty(ctx, materialInfo, measureUnitInfo, rsList);
    }

    @Override
    public String[] getFieldAry() {
        String[] fieldAry = new String[]{"FQualifiedQty", "FQualifiedBaseQty", "FUnqualifiedQty", "FUnqualifiedBaseQty", "FConcessiveRecQty", "FConcessiveRecBaseQty"};
        return fieldAry;
    }

    @Override
    public void processSubmitResult(Context ctx, QCRequestEntryInfo qcRequestEntry, String sourceBillEntryID, MaterialInfo material, MeasureUnitInfo unit, QCReturnResultCollection rsList, String flag) throws BOSException, EASBizException {
        super.processSubmitResult(ctx, qcRequestEntry, sourceBillEntryID, material, unit, rsList, flag);
        if (rsList.size() == 0) {
            return;
        }
        if (flag.equals("+")) {
            PurReceivalEntryInfo entryInfo = new PurReceivalEntryInfo();
            entryInfo.setId(BOSUuid.read((String)sourceBillEntryID));
            for (int i = 0; i < rsList.size(); ++i) {
                QCReturnResultInfo rs = rsList.get(i);
                PurReceivalEntryCheckInfo checkInfo = new PurReceivalEntryCheckInfo();
                checkInfo.setParent2(entryInfo);
                checkInfo.setSourceBillId(rs.getSourceBillID());
                checkInfo.setSourceBillEntryId(rs.getSourceBillEntryID());
                checkInfo.setSourceBillId(rs.getSourceBillID());
                if (rs.getJudgeMaterial() != null) {
                    checkInfo.setMaterial(rs.getJudgeMaterial());
                } else {
                    checkInfo.setMaterial(rs.getMaterial());
                }
                checkInfo.setMaterialName(material.getName());
                checkInfo.setUnit(rs.getUnit());
                checkInfo.setBaseUnit(rs.getBaseUnit());
                checkInfo.setCheckBatchNo(rs.getCheckBatch());
                checkInfo.setRemark(rs.getRemark());
                QCPurBizEnum biz = rs.getDPProcessMode().getQCPurBiz();
                if (biz == QCPurBizEnum.BIZ_Qualified) {
                    checkInfo.setQualifiedQty(rs.getQty());
                    checkInfo.setQualifiedBaseQty(rs.getBaseQty());
                    checkInfo.setAssociateQty(rs.getQty());
                } else if (biz == QCPurBizEnum.BIZ_Unqualified) {
                    checkInfo.setUnQualifiedQty(rs.getQty());
                    checkInfo.setUnQualifiedBaseQty(rs.getBaseQty());
                    checkInfo.setAssociateQty(QMConstant.ZERO);
                } else if (biz == QCPurBizEnum.BIZ_Back) {
                    checkInfo.setConcessRecQty(rs.getQty());
                    checkInfo.setConcessRecBaseQty(rs.getBaseQty());
                    checkInfo.setAssociateQty(rs.getQty());
                }
                PurReceivalEntryCheckFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)checkInfo);
            }
        } else {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < rsList.size(); ++i) {
                set.add(rsList.get(i).getSourceBillEntryID());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillEntryId", set, CompareType.INCLUDE));
            PurReceivalEntryCheckFactory.getLocalInstance((Context)ctx).delete(filter);
        }
    }

    @Override
    public void canCancelResultHandler(Context ctx, String srcbillId, String srcbillEntryId, QCReturnResultCollection rsList) throws EASBizException, BOSException {
        InvServerUtils.canCancelResultHandler((Context)ctx, (String)srcbillId, (String)srcbillId, (QCReturnResultCollection)rsList);
    }

    @Override
    public String getCheckQtyTitle(Context ctx) {
        String str = ResourceBase.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"8_PurReceivalBill4QCRequestAction", (Locale)ctx.getLocale());
        return str;
    }

    @Override
    public String getAddNewPermItemName() {
        return "qm_QCPurRequest_02addnew";
    }

    @Override
    public void canSubmitResultHandler(Context ctx, String srcbillId, String srcbillEntryId, QCReturnResultCollection rsList) throws EASBizException, BOSException {
    }
}

