/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.util.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportServerHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCReportCheckLotHelper {
    private static Logger logger = Logger.getLogger((String)QCReportCheckLotHelper.class.getName());
    public static final String CheckLot_Split_Char = "_";
    public static final char CheckLotPadChar = '0';
    public static final int CheckLotPad_EntrySeqSize = 3;
    public static final int CheckLotPad_SeqSize = 2;

    public static void addBatchInfo(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        Iterator it = colls.iterator();
        HashMap batchMap = new HashMap();
        while (it.hasNext()) {
            QCReportInfo reportInfo = (QCReportInfo)it.next();
            QCReportCheckLotHelper.addBatchInfo(ctx, reportInfo, batchMap);
        }
    }

    public static void addBatchInfo(Context ctx, QCReportInfo reportInfo, Map batchMap) throws BOSException, EASBizException {
        String reuqestNum = reportInfo.getRequestNum();
        String requestEntryNum = reportInfo.getRequestEntryNum();
        String maxBatch = QCReportCheckLotHelper.getMaxCheckBatch(ctx, reportInfo, batchMap, reuqestNum, requestEntryNum);
        reportInfo.setCheckLot(reuqestNum + CheckLot_Split_Char + QMStringUtils.leftPadString((char)'0', (String)requestEntryNum, (int)3) + CheckLot_Split_Char + maxBatch);
    }

    public static String getMaxCheckBatch(Context ctx, QCReportInfo reportInfo, Map batchMap, String requestNumber, String requestEntryNumber) throws BOSException, EASBizException {
        String maxBatch = "01";
        String key = QCReportServerHelper.buildReuqestKey(ctx, requestNumber, requestEntryNumber);
        String orgID = reportInfo.getQualityOrgUnit().getId().toString();
        String tempBatch = (String)batchMap.get(key);
        if (tempBatch != null) {
            maxBatch = QCReportCheckLotHelper.addAtCurrentBatch(tempBatch);
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT T.FCHECKLOT AS LOT \n");
            sql.append("FROM T_QM_QCREPORT T \n");
            sql.append("WHERE T.FREQUESTNUM = '" + requestNumber + "' \n");
            sql.append("AND T.FREQUESTENTRYNUM = '" + requestEntryNumber + "' \n");
            sql.append("AND T.FQUALITYORGUNITID = '" + orgID + "' \n");
            sql.append("ORDER BY T.FCHECKLOT DESC \n");
            sql.append(" \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                String[] strs;
                String curLot;
                if (rs.next() && !StringUtil.isEmptyString((String)(curLot = rs.getString("LOT"))) && (strs = curLot.split(CheckLot_Split_Char)).length > 0) {
                    String dbStr = strs[strs.length - 1];
                    maxBatch = QCReportCheckLotHelper.addAtCurrentBatch(dbStr);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        batchMap.put(key, maxBatch);
        return maxBatch;
    }

    public static String addAtCurrentBatch(String str) {
        int temp = 0;
        try {
            temp = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
        if (++temp > 99) {
            return str;
        }
        str = String.valueOf(temp);
        str = QMStringUtils.leftPadString((char)'0', (String)str, (int)3);
        return str;
    }
}

