/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.util.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.qc.CheckResultEnum;
import com.kingdee.eas.qm.qc.QCReportAllItemEntryInfo;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.util.QMUnitConvertHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCReportCheckResultServerHelper {
    private static Logger logger = Logger.getLogger((String)QCReportCheckResultServerHelper.class.getName());
    public static final String SOURCETYPE = "sourceType";
    public static final String BILLNUMBER = "billNumber";
    public static final String SAMPLENUMBER = "sampleNumber";
    public static final String SOURCESAMPLENUMBER = "sourceSampleNumber";
    public static final String SAMPLEQTY = "sampleQty";
    public static final String SAMPLEUNITID = "sampleUnitId";
    public static final String REINSPECTFORM = "reinspectform";
    public static final String ISRESRESULT = "isResResult";
    public static final String QCITEMID = "qcItemId";
    public static final String ISKEYITEM = "isKeyItem";
    public static final String CHECKRESULT = "checkResult";
    public static final String ISRUINOUS = "isRuinous";

    public static void computeCheckResult(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (QCReportInfo reportInfo : colls) {
            QCReportCheckResultServerHelper.computeCheckResult(ctx, reportInfo);
        }
    }

    public static void computeCheckResult(Context ctx, QCReportInfo reportInfo) throws BOSException, EASBizException {
        CheckResultEnum checkResult;
        logger.debug((Object)"compute!!!");
        String judgeType = null;
        if (reportInfo.getSampleSolution() == SampleSolutionEnum.allCheck) {
            reportInfo.setCheckResult(CheckResultEnum.pass);
            return;
        }
        judgeType = QMParamUtil.getParamValue((Context)ctx, (String)"QM007", (String)reportInfo.getQualityOrgUnit().getId().toString());
        if (StringUtils.isEmpty((String)judgeType)) {
            return;
        }
        String sampleNumberList = QCReportCheckResultServerHelper.getSourceSampleNumberList(ctx, reportInfo);
        Map rsMap = QCReportCheckResultServerHelper.getResultData(ctx, reportInfo.getRequestEntryID(), sampleNumberList);
        boolean pass = true;
        BigDecimal qty = SysConstant.BIGZERO;
        BigDecimal ruinousQty = SysConstant.BIGZERO;
        BigDecimal unPassQty = SysConstant.BIGZERO;
        BigDecimal passQty = SysConstant.BIGZERO;
        HashMap<String, BigDecimal> sampleQty = new HashMap<String, BigDecimal>();
        String materialID = "";
        String sampleUnitID = "";
        String sampleBaseUnitID = "";
        if (reportInfo.getJudgeMaterial() != null) {
            materialID = reportInfo.getJudgeMaterial().getId().toString();
        }
        if (reportInfo.getSampleUnit() != null) {
            sampleUnitID = reportInfo.getSampleUnit().getId().toString();
        }
        if (reportInfo.getSampleBaseUnit() != null) {
            sampleBaseUnitID = reportInfo.getSampleBaseUnit().getId().toString();
        }
        Iterator rsIt = rsMap.keySet().iterator();
        while (rsIt.hasNext()) {
            Map sapmleMap = (Map)rsMap.get(rsIt.next());
            String billType = (String)sapmleMap.get(SOURCETYPE);
            String sourceSampNumber = (String)sapmleMap.get(SOURCESAMPLENUMBER);
            BigDecimal iQty = (BigDecimal)sapmleMap.get(SAMPLEQTY);
            String reinspect = (String)sapmleMap.get(REINSPECTFORM);
            boolean isResult = ((String)sapmleMap.get(ISRESRESULT)).equals("1");
            String tmpSampleUnitId = (String)sapmleMap.get(SAMPLEUNITID);
            iQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, tmpSampleUnitId, sampleUnitID, iQty);
            if (iQty == null) {
                iQty = SysConstant.BIGZERO;
            }
            boolean isRui = false;
            int isPass = -1;
            qty = qty.add(iQty);
            if (sampleQty.get(sourceSampNumber) == null) {
                sampleQty.put(sourceSampNumber, iQty);
            } else {
                BigDecimal sQty = (BigDecimal)sampleQty.get(sourceSampNumber);
                sampleQty.put(sourceSampNumber, sQty.add(iQty));
            }
            Iterator sapmleIt = sapmleMap.keySet().iterator();
            while (sapmleIt.hasNext()) {
                Object value = sapmleMap.get(sapmleIt.next());
                if (!(value instanceof Map)) continue;
                Map itemMap = (Map)value;
                if (!isRui) {
                    isRui = itemMap.get(ISRUINOUS).equals("1");
                }
                boolean isUnPass = itemMap.get(CHECKRESULT).equals(String.valueOf(20));
                if (judgeType.equals("1")) {
                    if (isResult) {
                        if (isUnPass) {
                            isPass = 0;
                        } else if (isPass != 0) {
                            isPass = 1;
                        }
                    } else {
                        isPass = -1;
                    }
                } else if (judgeType.equals("2") && itemMap.get(ISKEYITEM).equals("1")) {
                    if (isResult) {
                        if (isUnPass) {
                            isPass = 0;
                        } else if (isPass != 0) {
                            isPass = 1;
                        }
                    } else {
                        isPass = -1;
                    }
                }
                if (!isResult || !pass) continue;
                pass = !isUnPass;
            }
            if (isRui) {
                ruinousQty = ruinousQty.add(iQty);
            }
            if (isPass != 0) continue;
            unPassQty = unPassQty.add(iQty);
        }
        passQty = qty.subtract(unPassQty);
        CheckResultEnum checkResultEnum = checkResult = pass ? CheckResultEnum.pass : CheckResultEnum.unpass;
        if (judgeType.equals("0")) {
            unPassQty = SysConstant.BIGZERO;
            passQty = SysConstant.BIGZERO;
        }
        reportInfo.setCheckResult(checkResult);
        reportInfo.setLossQty(ruinousQty);
        BigDecimal ruinousBaseQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, sampleUnitID, sampleBaseUnitID, ruinousQty);
        reportInfo.setLossBaseQty(ruinousBaseQty);
        HashMap<String, String> ampleNumberMap = new HashMap<String, String>();
        boolean isAllItemPass = true;
        Iterator rpeIt = reportInfo.getEntrys().iterator();
        while (rpeIt.hasNext()) {
            QCReportEntryInfo rpe = (QCReportEntryInfo)rpeIt.next();
            String sampleNumber = rpe.getSampleNumber();
            if (ampleNumberMap.get(sampleNumber) == null) {
                String sourceSampleNumber = QCReportCheckResultServerHelper.getSourceSampleNumberList(ctx, sampleNumber);
                ampleNumberMap.put(sampleNumber, sourceSampleNumber);
                sampleNumber = sourceSampleNumber;
            } else {
                sampleNumber = (String)ampleNumberMap.get(sampleNumber);
            }
            BigDecimal sQty = (BigDecimal)sampleQty.get(sampleNumber);
            rpe.setSampleNumber(sampleNumber);
            QCResultJudgeEnum result = rpe.getCheckResult();
            if (result != null && QCResultJudgeEnum.pass.equals((Object)result)) continue;
            isAllItemPass = false;
        }
        if (isAllItemPass) {
            reportInfo.setPassSampleShares(reportInfo.getTotalSampleQty());
        }
    }

    public static String getSourceSampleNumberList(Context ctx, String sampleNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT sourceSpe.fnumber \n");
        sql.append("FROM t_Qm_Qcsampleentry spe \n");
        sql.append("INNER JOIN t_Qm_Qcsampleentry sourceSpe ON sourceSpe.fid = spe.fsourcesampleid \n");
        sql.append("WHERE spe.fnumber = '" + sampleNumber + "' \n");
        String sourceSampleNumber = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                sourceSampleNumber = rs.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLDataException(e);
        }
        if (StringUtils.isEmpty(sourceSampleNumber)) {
            return sampleNumber;
        }
        return sourceSampleNumber;
    }

    public static String getSourceSampleNumberList(Context ctx, QCReportInfo reportInfo) throws BOSException {
        String sampleNumberList = "''";
        Iterator sIt = reportInfo.getAllItemEntry().iterator();
        while (sIt.hasNext()) {
            QCReportAllItemEntryInfo reInfo = (QCReportAllItemEntryInfo)sIt.next();
            if (sampleNumberList.indexOf(reInfo.getSampleNumber()) != -1) continue;
            sampleNumberList = sampleNumberList + ",'" + reInfo.getSampleNumber() + "'";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT spe1.fnumber FROM t_Qm_Qcsampleentry spe1 \n");
        sql.append("WHERE spe1.fid IN \n");
        sql.append("(SELECT DISTINCT ISNULL(spe2.Fsourcesampleid,spe2.fid) FROM t_Qm_Qcsampleentry spe2 \n");
        sql.append("WHERE spe2.fnumber IN (" + sampleNumberList + ")) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sampleNumberList = "''";
        try {
            while (rs.next()) {
                if (sampleNumberList.indexOf(rs.getString(1)) != -1) continue;
                sampleNumberList = sampleNumberList + ",'" + rs.getString(1) + "'";
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
            throw new SQLDataException(e1);
        }
        return sampleNumberList;
    }

    public static Map getResultData(Context ctx, String requestEntryID, String sampleNumberList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 'bill' AS sourceType, \n");
        sql.append("bill.fnumber AS billNumber, \n");
        sql.append("billse.fnumber AS sampleNumber, \n");
        sql.append("ISNULL((SELECT sourceSpe.fnumber \n");
        sql.append("FROM t_Qm_Qcsampleentry spe \n");
        sql.append("INNER JOIN t_Qm_Qcsampleentry sourceSpe ON sourceSpe.fid = spe.fsourcesampleid \n");
        sql.append("WHERE spe.fnumber = billse.fnumber) \n");
        sql.append(",billse.fnumber) AS sourceSampleNumber, \n");
        sql.append("billse.fsampleqty AS sampleQty, \n");
        sql.append("billse.funitid AS sampleUnitId, \n");
        sql.append("billse.freinspectform AS reinspectform, \n");
        sql.append("billse.fisresresult AS isResResult, \n");
        sql.append("bille.fqcitemid AS qcItemId, \n");
        sql.append("bille.fiskeyitem AS isKeyItem, \n");
        sql.append("bille.fcheckresult AS checkResult, \n");
        sql.append("bille.fisRuinous AS isRuinous \n");
        sql.append("FROM t_qm_qcbill bill \n");
        sql.append("INNER JOIN t_qm_qcbillsampleentry billse ON bill.fid = billse.fparentid \n");
        sql.append("INNER JOIN t_qm_qcbillentry bille ON billse.fid = bille.fsampleparentid \n");
        sql.append("WHERE bill.frequestentryid = '" + requestEntryID + "' \n");
        sql.append("AND billse.fnumber IN (" + sampleNumberList + ") \n");
        sql.append("AND bill.fbillstatus IN (30) \n");
        sql.append("UNION ALL \n");
        sql.append("SELECT 'report' AS sourceType, \n");
        sql.append("rp.fnumber AS billNumber, \n");
        sql.append("spe.fnumber AS sampleNumber, \n");
        sql.append("spe.fnumber AS sourceSampleNumber, \n");
        sql.append("spe.fsampleqty AS sampleQty, \n");
        sql.append("spe.funitid AS sampleUnitId, \n");
        sql.append("0 AS reinspectform, \n");
        sql.append("1 AS isResResult, \n");
        sql.append("rpe.fqcitemid AS qcItemId, \n");
        sql.append("rpe.fiskeyitem AS isKeyItem, \n");
        sql.append("rpe.fcheckresult AS checkResult, \n");
        sql.append("rpe.fisruinous AS isRuinous \n");
        sql.append("FROM t_qm_qcsample sp \n");
        sql.append("INNER JOIN t_qm_qcsampleentry spe ON sp.fid = spe.fparentid \n");
        sql.append("INNER JOIN t_qm_qcrequestentry rqe ON rqe.fsamplenumber = spe.fnumber \n");
        sql.append("INNER JOIN t_qm_qcreport rp ON rp.frequestentryid = rqe.fid \n");
        sql.append("INNER JOIN t_qm_qcreportEntry rpe ON rpe.fparentid = rp.fid \n");
        sql.append("WHERE sp.frequestentryid = '" + requestEntryID + "' \n");
        sql.append("AND rp.fbillstatus IN (30) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Map<String, BigDecimal>> rsMap = new HashMap<String, Map<String, BigDecimal>>();
        try {
            while (rs.next()) {
                Map<String, BigDecimal> sapmleMap;
                if (rsMap.get(rs.getString(SAMPLENUMBER)) == null) {
                    sapmleMap = new HashMap<String, String>();
                    sapmleMap.put(BILLNUMBER, (BigDecimal)((Object)rs.getString(BILLNUMBER)));
                    sapmleMap.put(SAMPLENUMBER, (BigDecimal)((Object)rs.getString(SAMPLENUMBER)));
                    sapmleMap.put(SAMPLEQTY, rs.getBigDecimal(SAMPLEQTY));
                    sapmleMap.put(SAMPLEUNITID, (BigDecimal)((Object)rs.getString(SAMPLEUNITID)));
                    sapmleMap.put(REINSPECTFORM, (BigDecimal)((Object)rs.getString(REINSPECTFORM)));
                    sapmleMap.put(ISRESRESULT, (BigDecimal)((Object)rs.getString(ISRESRESULT)));
                    rsMap.put(rs.getString(SAMPLENUMBER), sapmleMap);
                }
                sapmleMap = (Map)rsMap.get(rs.getString(SAMPLENUMBER));
                HashMap<String, String> itemMap = new HashMap<String, String>();
                itemMap.put(QCITEMID, rs.getString(QCITEMID));
                itemMap.put(ISKEYITEM, rs.getString(ISKEYITEM));
                itemMap.put(CHECKRESULT, rs.getString(CHECKRESULT));
                itemMap.put(ISRUINOUS, rs.getString(ISRUINOUS));
                sapmleMap.put(rs.getString(QCITEMID), (BigDecimal)((Object)itemMap));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLDataException(e);
        }
        return rsMap;
    }
}

