/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.util.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.basedata.EvaluateModeEnum;
import com.kingdee.eas.qm.basedata.ItemTypeEnum;
import com.kingdee.eas.qm.basedata.JudgeTypeEnum;
import com.kingdee.eas.qm.basedata.MergeModeEnum;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCBizBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCFrequencyInfo;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.qm.basedata.QCGroupPersonInfo;
import com.kingdee.eas.qm.basedata.QCInstrumentGroupInfo;
import com.kingdee.eas.qm.basedata.QCInstrumentInfo;
import com.kingdee.eas.qm.basedata.QCItemAttributeEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCMethodInfo;
import com.kingdee.eas.qm.basedata.QCModifyModeFactory;
import com.kingdee.eas.qm.basedata.QCModifyModeInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.RejectProcessModeEnum;
import com.kingdee.eas.qm.basedata.SampleHierarchyEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.basedata.util.QCModifyModeHelper;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.qc.CheckResultEnum;
import com.kingdee.eas.qm.qc.IQCReport;
import com.kingdee.eas.qm.qc.QCBillEntry;
import com.kingdee.eas.qm.qc.QCBillEntryFactory;
import com.kingdee.eas.qm.qc.QCBillEntryInfo;
import com.kingdee.eas.qm.qc.QCItemBaseInfo;
import com.kingdee.eas.qm.qc.QCItemSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCItemSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCReportAllItemEntryInfo;
import com.kingdee.eas.qm.qc.QCReportCollection;
import com.kingdee.eas.qm.qc.QCReportEntry;
import com.kingdee.eas.qm.qc.QCReportEntryCollection;
import com.kingdee.eas.qm.qc.QCReportEntryFactory;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.ReportEntrySrcTypeEnum;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportCheckLotHelper;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportCheckResultServerHelper;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportServerHelper;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportTempTableHelper;
import com.kingdee.eas.qm.qc.util.QMUnitConvertHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCReportCreateHelper {
    private static Logger logger = Logger.getLogger((String)QCReportCreateHelper.class.getName());

    public static String getQCBillToQCReportBotMappingID(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    public static List checkCanCreateReportByRequestEntry(Context ctx, String orgID, String requestBillID, String requestBillEntryID) throws BOSException, EASBizException {
        String checkSql = QCReportCreateHelper.buildCheckCanCreateReportSqlByRequestEntry(ctx, orgID, requestBillID, requestBillEntryID);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        ArrayList<String> errorMsgList = null;
        try {
            while (rs.next()) {
                if (errorMsgList == null) {
                    errorMsgList = new ArrayList<String>();
                }
                String fnumber = rs.getString("FNUMBER");
                String fbilltype = rs.getString("BILLTYPE");
                String qualityOrgUnitName = rs.getString("QUALITYORGUNITNAME");
                errorMsgList.add(fnumber + "#" + fbilltype + "#" + qualityOrgUnitName);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return errorMsgList;
    }

    public static List checkCanCreateReportBySample(Context ctx, String orgID, String sampleNumber, String requestBillID, String requestBillEntryID) throws BOSException, EASBizException {
        String checkSql = QCReportCreateHelper.buildCheckCanCreateReportSqlBySample(ctx, orgID, sampleNumber, requestBillID, requestBillEntryID);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        ArrayList<String> errorMsgList = null;
        try {
            while (rs.next()) {
                if (errorMsgList == null) {
                    errorMsgList = new ArrayList<String>();
                }
                String fnumber = rs.getString("FNUMBER");
                String fbilltype = rs.getString("BILLTYPE");
                String qualityOrgUnitName = rs.getString("QUALITYORGUNITNAME");
                errorMsgList.add(fnumber + "#" + fbilltype + "#" + qualityOrgUnitName);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return errorMsgList;
    }

    public static String buildCheckCanCreateReportSqlByRequestEntry(Context ctx, String orgID, String requestBillID, String requestBillEntryID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T1.FID,\n");
        sql.append("        T1.FNUMBER,\n");
        sql.append("        'QCBILL' AS BILLTYPE,\n");
        sql.append("        T2." + QCReportServerHelper.getFieldByLanguage("FNAME") + " AS QUALITYORGUNITNAME \n");
        sql.append(" FROM T_QM_QCBILL T1,T_ORG_Quality T2,T_QM_QCBillSampleEntry T3 \n");
        sql.append(" WHERE T1.FQUALITYORGUNITID = '" + orgID + "' \n");
        sql.append("   AND T1.FREQUESTID = '" + requestBillID + "' \n");
        sql.append("   AND T1.FREQUESTENTRYID = '" + requestBillEntryID + "' \n");
        sql.append("   AND T1.FQUALITYORGUNITID = T2.FID \n");
        sql.append("   AND T1.FID = T3.FPARENTID \n");
        sql.append("   AND (T1.FBILLSTATUS IN (0,10,20) ");
        sql.append(" \t    OR (T1.FBILLSTATUS IN (30) ");
        sql.append("            AND T3.FReinspectForm<>0 AND T3.FisReinspect=0)) \n");
        sql.append("   AND (SELECT count(1) FROM T_QM_QCBillSampleEntry T4 WHERE T4.Fparentid = T3.Fparentid  \n");
        sql.append("\t     AND T4.FCloseBillNum is null AND ISNULL(T3.FisReinspect,0) = 0) <> 0  \n");
        sql.append("UNION  ALL \n");
        sql.append("SELECT REQUEST.FID, REQUEST.FNUMBER,'QCREQUEST' AS BILLTYPE  \n,T2." + QCReportServerHelper.getFieldByLanguage("fname") + " AS QUALITYORGUNITNAME  \n");
        sql.append("FROM T_QM_QCREQUEST REQUEST  \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY REQUESTENTRY   \n");
        sql.append("ON REQUEST.FID =REQUESTENTRY.FPARENTID  \n");
        sql.append("INNER JOIN T_ORG_Quality T2   \n");
        sql.append("ON REQUEST.FQUALITYORGUNITID =T2.FID  \n");
        sql.append("WHERE REQUEST.FREQORGUNITID = '" + orgID + "'  \n");
        sql.append("AND ( \n");
        sql.append("REQUEST.FBILLSTATUS IN (0,10,20) \n");
        sql.append("OR REQUESTENTRY.FREPORTSTATE IS NULL ");
        sql.append("OR REQUESTENTRY.FREPORTSTATE != 20)  \n");
        sql.append("AND REQUESTENTRY.FSOURCEREQUESTID ='" + requestBillID + "' \n");
        sql.append("AND REQUESTENTRY.FSOURCEREQUESTENTRYID ='" + requestBillEntryID + "' \n");
        sql.append(" \n");
        sql.append("UNION  ALL \n");
        sql.append(" SELECT        REIINSPECTREQ.FID,       REIINSPECTREQ.FNUMBER,       'QCREIINSPECTREQ' AS BILLTYPE,       T2." + QCReportServerHelper.getFieldByLanguage("FNAME") + " AS QUALITYORGUNITNAME" + "    FROM" + "       T_QM_QCReinspectReq REIINSPECTREQ," + "       T_ORG_Quality T2" + "    WHERE" + "       REIINSPECTREQ.FQUALITYORGUNITID='" + orgID + "'  AND" + "       REIINSPECTREQ.FisExistDownstre = 0 AND" + "       REIINSPECTREQ.FQCRequsetID = '" + requestBillID + "' AND" + "       REIINSPECTREQ.FQCReqEntryID = '" + requestBillEntryID + "' AND" + "       REIINSPECTREQ.FQUALITYORGUNITID = T2.FID ");
        sql.append("UNION  ALL \n");
        sql.append("SELECT       SAMPLE.FID,       SAMPLE.FNUMBER,       'QCSAMPLE' AS BILLTYPE,       T2." + QCReportServerHelper.getFieldByLanguage("FNAME") + " AS QUALITYORGUNITNAME" + "   FROM" + "       T_QM_QCSample SAMPLE," + "       T_QM_QCSampleItemEntry SAMPLEITEMENTRY," + "       T_ORG_Quality T2" + "   WHERE" + "       SAMPLE.FQUALITYORGUNITID='" + orgID + "'  AND" + "       SAMPLE.FRequestID='" + requestBillID + "' AND" + "       SAMPLE.FRequestEntryID = '" + requestBillEntryID + "' AND" + "       SAMPLE.FID = SAMPLEITEMENTRY.FPARENTID AND" + "       SAMPLEITEMENTRY.FQenDownQty = 0 AND" + "       SAMPLE.FQUALITYORGUNITID = T2.FID");
        logger.debug((Object)sql.toString());
        return sql.toString();
    }

    public static String buildCheckCanCreateReportSqlBySample(Context ctx, String orgID, String sampleNumber, String requestBillID, String requestBillEntryID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.FID, T1.FNUMBER, 'QCBILL' AS BILLTYPE  \n");
        sql.append(",T3." + QCReportServerHelper.getFieldByLanguage("fname") + " AS QUALITYORGUNITNAME  \n");
        sql.append("FROM T_QM_QCBILL T1  \n");
        sql.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY T2 \n");
        sql.append("ON T1.FID = T2.FPARENTID   \n");
        sql.append("INNER JOIN T_ORG_Quality T3 \n");
        sql.append("ON T1.FQUALITYORGUNITID = T3.FID   \n");
        sql.append(" where \n ");
        sql.append("T1.FQUALITYORGUNITID = '" + orgID + "'  \n");
        sql.append("AND T1.FBILLSTATUS IN (0,10,20)  \n");
        sql.append("AND T2.FNUMBER ='" + sampleNumber + "'  \n");
        sql.append("AND T1.FREQUESTID ='" + requestBillID + "'  \n");
        sql.append("AND T1.FREQUESTENTRYID ='" + requestBillEntryID + "'  \n");
        sql.append("AND (SELECT count(1)  \n");
        sql.append("FROM T_QM_QCBillSampleEntry T4 \n");
        sql.append("WHERE T4.Fparentid = T2.Fparentid \n");
        sql.append("AND T4.FCloseBillNum is null \n");
        sql.append("AND ISNULL(T2.FisReinspect, 0) = 0) <> 0 \n");
        sql.append(" \n");
        sql.append("UNION  ALL \n");
        sql.append("SELECT REQUEST.FID, REQUEST.FNUMBER,  \n");
        sql.append("'QCREQUEST' AS BILLTYPE  \n");
        sql.append(",T2." + QCReportServerHelper.getFieldByLanguage("fname") + " AS QUALITYORGUNITNAME  \n");
        sql.append("FROM T_QM_QCREQUEST REQUEST  \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY REQUESTENTRY   \n");
        sql.append("ON REQUEST.FID =REQUESTENTRY.FPARENTID  \n");
        sql.append("INNER JOIN T_ORG_Quality T2   \n");
        sql.append("ON REQUEST.FQUALITYORGUNITID =T2.FID  \n");
        sql.append("WHERE REQUEST.FREQORGUNITID = '" + orgID + "'  \n");
        sql.append("AND ( \n");
        sql.append("REQUEST.FBILLSTATUS IN (0,10,20) \n");
        sql.append("OR REQUESTENTRY.FREPORTSTATE IS NULL ");
        sql.append("OR REQUESTENTRY.FREPORTSTATE != 20)  \n");
        sql.append("AND REQUESTENTRY.FSAMPLENUMBER ='" + sampleNumber + "'  \n");
        sql.append("AND REQUESTENTRY.FSOURCEREQUESTID  ='" + requestBillID + "'  \n");
        sql.append("AND REQUESTENTRY.FSOURCEREQUESTENTRYID ='" + requestBillEntryID + "'  \n");
        sql.append(" \n");
        logger.debug((Object)sql);
        return sql.toString();
    }

    public static String buildCanCreateReportBillsSql(Context ctx, QCBizTypeEnum[] qcBizTypes, String orgID, Map params) throws BOSException, EASBizException {
        Date endDate;
        Date beginDate;
        StringBuffer qcBizTypeStr = new StringBuffer();
        for (int i = 0; i < qcBizTypes.length; ++i) {
            qcBizTypeStr.append("," + qcBizTypes[i].getValue());
        }
        String qcBizTypeList = qcBizTypeStr.substring(1);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT \n");
        sql.append("T1.FID AS REQUESTID,T1.FNUMBER AS REQUESTNUMBER, \n");
        sql.append("T2.FID AS REQUESTENTRYID, \n");
        sql.append("T2.FNUMBER AS REQUESTENTRYNUMBER, \n");
        sql.append("T2.FMATERIALID AS MATERIALID, \n");
        sql.append("MATERIAL.FNUMBER AS MATERIALNUMBER, \n");
        sql.append("MATERIAL.FNAME_L2 AS MATERIALNAME, \n");
        sql.append("TO_NUMBER(ISNULL(T2.FDELIVERQTY,0)) AS SENDQTY, \n");
        sql.append("T2.FUNITID AS UNITID,UNIT.FNAME_L2 AS UNITNAME,");
        sql.append("TO_CHAR(T2.FREQFINISHDATE,'YYYY-MM-DD') AS REQFINISHDATE, \n");
        sql.append("'" + ReportEntrySrcTypeEnum.QCBill.toString() + "' AS SOURCEBILLTYPE, \n");
        sql.append("QCBILL.FID AS SOURCEBILLID, \n");
        sql.append("QCBILL.FNUMBER AS SOURCEBILLNUMBER, \n");
        sql.append("QCBILLENTRY.FID AS SOURCEBILLENTRYID, \n");
        sql.append("QCBILLENTRY.FSEQ AS FSEQ, \n");
        sql.append("ISNULL((SELECT sourceSpe.fnumber \n");
        sql.append("FROM t_Qm_Qcsampleentry spe \n");
        sql.append("INNER JOIN t_Qm_Qcsampleentry sourceSpe ON sourceSpe.fid = spe.fsourcesampleid \n");
        sql.append("WHERE spe.fnumber = QCBILLENTRY.fnumber) \n");
        sql.append(",QCBILLENTRY.fnumber) \n");
        sql.append("AS SAMPLENUMBER , \n");
        sql.append("TO_NUMBER(ISNULL(QCBILLENTRY.FSAMPLEQTY,0)) AS SAMPLEQTY, \n");
        sql.append("TO_CHAR(QCBILLENTRY.FVERIFYDATE,'YYYY-MM-DD') AS CHECKDATE, \n");
        sql.append("T1.FREQORGUNITID AS REQORGID, \n");
        sql.append("SRCORG.FNAME_L2 AS REQORGNAME ");
        sql.append("FROM T_QM_QCREQUEST T1 \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY T2 \n");
        sql.append("ON T1.FID = T2.FPARENTID \n");
        sql.append("INNER JOIN T_BD_MATERIAL MATERIAL \n");
        sql.append("ON T2.FMATERIALID = MATERIAL.FID \n");
        sql.append("INNER JOIN T_BD_MEASUREUNIT UNIT \n");
        sql.append("ON T2.FUNITID = UNIT.FID \n");
        sql.append("INNER JOIN T_ORG_BASEUNIT SRCORG  \n");
        sql.append("ON T1.FREQORGUNITID = SRCORG.FID \n");
        sql.append("INNER JOIN T_QM_QCBILL QCBILL \n");
        sql.append("ON QCBILL.FREQUESTID = T1.FID  \n");
        sql.append("AND QCBILL.FREQUESTENTRYID = T2.FID  \n");
        sql.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY QCBILLENTRY \n");
        sql.append("ON QCBILL.FID = QCBILLENTRY.FPARENTID \n");
        sql.append("INNER JOIN T_QM_QCBIZBILLTYPE BIZTYPE \n");
        sql.append("ON QCBILL.FBILLTYPEID =BIZTYPE.FID \n");
        sql.append("WHERE BIZTYPE.FQCBIZTYPE IN (" + qcBizTypeList + ") \n");
        sql.append("AND QCBILL.FQualityOrgUnitID = '" + orgID + "' \n");
        sql.append("AND QCBILL.FBILLSTATUS IN(30) \n");
        sql.append("AND ISNULL(QCBILLENTRY.FIsResResult,0) = 1 \n");
        sql.append("AND ISNULL(QCBILLENTRY.FIsReinspect,0) = 0 \n");
        sql.append("AND ISNULL(QCBILLENTRY.FIsQCReport,0) = 0 \n");
        if (params.get("RequestBillID") != null) {
            String billID = (String)params.get("RequestBillID");
            sql.append("AND T1.FID = '" + billID + "' \n");
        }
        if (params.get("MaterialID") != null) {
            String materialID = (String)params.get("MaterialID");
            sql.append("AND T2.FMATERIALID = '" + materialID + "' \n");
        }
        if (params.get("ReqDate") != null) {
            Map dateMap = (Map)params.get("ReqDate");
            beginDate = (Date)dateMap.get("Begin");
            endDate = (Date)dateMap.get("End");
            if ((beginDate = QMDateUtils.getDayBegin((Date)beginDate)).compareTo(endDate = QMDateUtils.getDayBegin((Date)endDate)) == 0) {
                sql.append("AND T2.FReqFinishDate = TO_DATE('" + QMDateUtils.formatDate2((Date)beginDate) + "') \n");
            } else {
                sql.append("AND T2.FReqFinishDate between TO_DATE('" + QMDateUtils.formatDate2((Date)beginDate) + " 00:00:00') and TO_DATE('" + QMDateUtils.formatDate2((Date)endDate) + " 23:59:59') \n");
            }
        }
        if (params.get("samplePlan") != null) {
            int samplePlan = (Integer)params.get("samplePlan");
            sql.append(" and QCBILL.FSampleSolution= " + samplePlan + " \n");
        }
        sql.append("UNION ALL \n");
        sql.append("SELECT DISTINCT \n");
        sql.append("T1.FID AS REQUESTID,T1.FNUMBER AS REQUESTNUMBER, \n");
        sql.append("T2.FID AS REQUESTENTRYID, \n");
        sql.append("T2.FNUMBER AS REQUESTENTRYNUMBER, \n");
        sql.append("T2.FMATERIALID AS MATERIALID, \n");
        sql.append("MATERIAL.FNUMBER AS MATERIALNUMBER, \n");
        sql.append("MATERIAL.FNAME_L2 AS MATERIALNAME, \n");
        sql.append("ISNULL(T2.FDELIVERQTY,0) AS SENDQTY, \n");
        sql.append("T2.FUNITID AS UNITID,UNIT.FNAME_L2 AS UNITNAME, \n");
        sql.append("TO_CHAR(T2.FREQFINISHDATE,'YYYY-MM-DD') AS REQFINISHDATE, \n");
        sql.append("'" + ReportEntrySrcTypeEnum.QCReport.toString() + "' AS SOURCEBILLTYPE, \n");
        sql.append("QCREPORT.FID AS SOURCEBILLID, \n");
        sql.append("QCREPORT.FNUMBER AS SOURCEBILLNUMBER, \n");
        sql.append("QCREPORTENTRY.FID AS SOURCEBILLENTRYID, \n");
        sql.append("QCREPORTENTRY.FSEQ AS FSEQ, \n");
        sql.append("REQUESTENTRY.FSAMPLENUMBER AS SAMPLENUMBER, \n");
        sql.append("ISNULL(REQUESTENTRY.FDELIVERQTY,0) AS SAMPLEQTY, \n");
        sql.append("TO_CHAR(QCREPORT.FREPORTDATE,'YYYY-MM-DD') AS CHECKDATE, \n");
        sql.append("T1.FREQORGUNITID AS REQORGID, \n");
        sql.append("SRCORG.FNAME_L2 AS REQORGNAME  \n");
        sql.append("FROM T_QM_QCREQUEST T1 \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY T2 \n");
        sql.append("ON T1.FID = T2.FPARENTID \n");
        sql.append("INNER JOIN T_BD_MATERIAL MATERIAL \n");
        sql.append("ON T2.FMATERIALID = MATERIAL.FID \n");
        sql.append("INNER JOIN T_BD_MEASUREUNIT UNIT \n");
        sql.append("ON T2.FUNITID = UNIT.FID \n");
        sql.append("INNER JOIN T_ORG_BASEUNIT SRCORG  \n");
        sql.append("ON T1.FREQORGUNITID = SRCORG.FID \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY REQUESTENTRY \n");
        sql.append("ON REQUESTENTRY.FSOURCEREQUESTID = T1.FID \n");
        sql.append("AND REQUESTENTRY.FSOURCEREQUESTENTRYID = T2.FID \n");
        sql.append("INNER JOIN T_QM_QCREPORT QCREPORT \n");
        sql.append("ON QCREPORT.FREQUESTID = REQUESTENTRY.FPARENTID \n");
        sql.append("AND QCREPORT.FREQUESTENTRYID = REQUESTENTRY.FID \n");
        sql.append("INNER JOIN T_QM_QCREPORTENTRY QCREPORTENTRY \n");
        sql.append("ON QCREPORT.FID = QCREPORTENTRY.FPARENTID \n");
        sql.append("INNER JOIN T_QM_QCBIZBILLTYPE BIZTYPE \n");
        sql.append("ON QCREPORT.FBILLTYPEID = BIZTYPE.FID \n");
        sql.append("WHERE  \n");
        sql.append("QCREPORT.FBILLSTATUS IN (30) \n");
        sql.append("AND ISNULL(QCREPORT.FISCOMBINEREPORT,0) = 0 \n");
        sql.append("AND BIZTYPE.FQCBIZTYPE IN (" + qcBizTypeList + ") \n");
        sql.append("AND QCREPORT.FQUALITYORGUNITID!= '" + orgID + "' \n");
        if (params.get("RequestBillID") != null) {
            String billID = (String)params.get("RequestBillID");
            sql.append("AND T1.FID = '" + billID + "' \n");
        }
        if (params.get("MaterialID") != null) {
            String materialID = (String)params.get("MaterialID");
            sql.append("AND T2.FMATERIALID = '" + materialID + "' \n");
        }
        if (params.get("ReqDate") != null) {
            Map dateMap = (Map)params.get("ReqDate");
            beginDate = (Date)dateMap.get("Begin");
            endDate = (Date)dateMap.get("End");
            if ((beginDate = QMDateUtils.getDayBegin((Date)beginDate)).compareTo(endDate = QMDateUtils.getDayBegin((Date)endDate)) == 0) {
                sql.append("AND T2.FReqFinishDate = TO_DATE('" + QMDateUtils.formatDate2((Date)beginDate) + "') \n");
            } else {
                sql.append("AND T2.FReqFinishDate between TO_DATE('" + QMDateUtils.formatDate2((Date)beginDate) + "') and TO_DATE('" + QMDateUtils.formatDate2((Date)endDate) + "') \n");
            }
        }
        if (params.get("samplePlan") != null) {
            int samplePlan = (Integer)params.get("samplePlan");
            sql.append(" and QCREPORT.FSampleSolution= " + samplePlan + " \n");
        }
        sql.append(" \n");
        sql.append("ORDER BY  \n");
        sql.append("REQUESTNUMBER,REQUESTENTRYNUMBER,SOURCEBILLTYPE DESC,SOURCEBILLNUMBER,FSEQ,SAMPLENUMBER \n");
        sql.append(" \n");
        logger.debug((Object)sql.toString());
        return sql.toString();
    }

    public static String createTempTableForCreateReport(Context ctx) throws BOSException, EASBizException {
        String tableName = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("CreateReportTable");
        String createSql = QCReportCreateHelper.buildCreateTempTableSql(ctx, tableName);
        DbUtil.execute((Context)ctx, (String)createSql);
        return tableName;
    }

    public static String buildCreateTempTableSql(Context ctx, String tableName) throws BOSException, EASBizException {
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table " + tableName + "  \n");
        createSql.append("( \n");
        createSql.append("FID VARCHAR(44) NOT NULL , \n");
        createSql.append("FSourceBillID VARCHAR(44) , \n");
        createSql.append("FSourceBillNumber NVARCHAR(80) , \n");
        createSql.append("FRequestID VARCHAR(44) , \n");
        createSql.append("FRequestEntryID VARCHAR(44) , \n");
        createSql.append("FRequestNum NVARCHAR(80), \n");
        createSql.append("FRequestEntryNum NVARCHAR(80), \n");
        createSql.append("FMaterialID VARCHAR(44) , \n");
        createSql.append("FQCStandardID VARCHAR(44) , \n");
        createSql.append("FIsConStandard INT, \n");
        createSql.append("FAdjustMaterialID VARCHAR(44) , \n");
        createSql.append("FAdjustQCStandardID VARCHAR(44) , \n");
        createSql.append("FSampleSolution INT, \n");
        createSql.append("FBizBillType NVARCHAR(44), \n");
        createSql.append("FSampleUnitID NVARCHAR(44), \n");
        createSql.append("FSampleBaseUnitID NVARCHAR(44), \n");
        createSql.append("FCheckBatchUnitID NVARCHAR(44), \n");
        createSql.append("FCheckBatchBaseUnitID NVARCHAR(44), \n");
        createSql.append("FSendQty NUMERIC(28,10), \n");
        createSql.append("FSourceBillEntryID VARCHAR(44) , \n");
        createSql.append("FSourceBillType VARCHAR(44) , \n");
        createSql.append("FSampleNumber NVARCHAR(80) , \n");
        createSql.append("FSampleSerial NVARCHAR(80) , \n");
        createSql.append("FQCItemID VARCHAR(44), \n");
        createSql.append("FIsCheck INT, \n");
        createSql.append("FIsKeyItem INT , \n");
        createSql.append("FCheckValue NVARCHAR(255), \n");
        createSql.append("FCheckValueUnitID VARCHAR(44), \n");
        createSql.append("FRemark NVARCHAR(255), \n");
        createSql.append("FRemark1 NVARCHAR(255), \n");
        createSql.append("FCheckResult INT, \n");
        createSql.append("FCheckDescription NVARCHAR(255), \n");
        createSql.append("FJudgeType INT , \n");
        createSql.append("FLowerLimit INT, \n");
        createSql.append("FLower  NUMERIC(28,10), \n");
        createSql.append("FUpperLimit INT, \n");
        createSql.append("FUpper NUMERIC(28,10), \n");
        createSql.append("FDefaultValue NVARCHAR(255), \n");
        createSql.append("FQCDGOrgUnitID VARCHAR(44), \n");
        createSql.append("FQCGroupID VARCHAR(44), \n");
        createSql.append("FQCGroupPersonID VARCHAR(44), \n");
        createSql.append("FQCInstrumentGroupID VARCHAR(44), \n");
        createSql.append("FQCInstrumentID VARCHAR(44), \n");
        createSql.append("FEnums NVARCHAR(255), \n");
        createSql.append("FExpression NVARCHAR(2000), \n");
        createSql.append("FAnalysisMethod INT, \n");
        createSql.append("FQCValueType INT, \n");
        createSql.append("FCheckStep NVARCHAR(100), \n");
        createSql.append("FQCStandardRequirement NVARCHAR(255), \n");
        createSql.append("FQCFrequencyID VARCHAR(44), \n");
        createSql.append("FQCMethodID VARCHAR(44), \n");
        createSql.append("FQCItemAttr INT, \n");
        createSql.append("FIsRuinous INT, \n");
        createSql.append("FSampleQty NUMERIC(28,10), \n");
        createSql.append("FModifyMode VARCHAR(44), \n");
        createSql.append("FDataPrecision INT, \n");
        createSql.append("FISBalItem INT, \n");
        createSql.append("FExpDateEnd DATETIME, \n");
        createSql.append("FTotalSampleQty NUMERIC(28,10), \n");
        createSql.append("FSampleHierarchy INT, \n");
        createSql.append("FQCStrategy INT, \n");
        createSql.append("FQCValueAcquisitionMode INT, \n");
        createSql.append("FSampleShares NUMERIC(21,8), \n");
        createSql.append("FPassShares NUMERIC(21,8), \n");
        createSql.append("FUnPassShares NUMERIC(21,8), \n");
        createSql.append("FMergeItemQty INT, \n");
        createSql.append("FSysCheckValue NVARCHAR(255), \n");
        createSql.append("FSourceItemEntryID VARCHAR(44), \n");
        createSql.append("FSampleProgramID VARCHAR(44), \n");
        createSql.append("FAcValue NUMERIC(21,8), \n");
        createSql.append("FReValue NUMERIC(21,8), \n");
        createSql.append("FDefectQty NUMERIC(21,8), \n");
        createSql.append("FEachSampleUnitID VARCHAR(44), \n");
        createSql.append("FEachSampleQty NUMERIC(21,8), \n");
        createSql.append("FBillItemEntrySeq INT ");
        createSql.append(" \n");
        createSql.append(") \n");
        logger.debug((Object)createSql.toString());
        return createSql.toString();
    }

    public static List createReportWithCreateList(Context ctx, QualityOrgUnitInfo mainOrgInfo, List createList, ServerCodingRuleStrategy codeingRuleStrategy, ISuportCodingRule codeingBean) throws BOSException, EASBizException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        if (createList == null || createList.size() == 0) {
            return idList;
        }
        String tableName = "";
        try {
            tableName = QCReportCreateHelper.createTempTableForCreateReport(ctx);
            StringBuffer billids = new StringBuffer();
            StringBuffer billEntryids = new StringBuffer();
            StringBuffer reportids = new StringBuffer();
            StringBuffer reportEntryids = new StringBuffer();
            billids.append("''");
            billEntryids.append("''");
            reportids.append("''");
            reportEntryids.append("''");
            for (int i = 0; i < createList.size(); ++i) {
                String key = (String)createList.get(i);
                String[] keys = key.split("<#>");
                String sourceBillType = keys[4];
                if (ReportEntrySrcTypeEnum.QCBill.toString().equals(sourceBillType)) {
                    billids.append(",'" + keys[5] + "'");
                    billEntryids.append(",'" + keys[6] + "'");
                    continue;
                }
                reportids.append(",'" + keys[5] + "'");
                reportEntryids.append(",'" + keys[6] + "'");
            }
            QCReportCreateHelper.insertCreateReportDataToTempTable(ctx, tableName, billids.toString(), billEntryids.toString(), reportids.toString(), reportEntryids.toString());
            String sql = QCReportCreateHelper.buildSelectHeadSqlFromCreateReportTempTable(ctx, tableName);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            QCReportCollection reportCols = new QCReportCollection();
            while (rs.next()) {
                QCReportInfo headInfo = new QCReportInfo();
                QCReportCreateHelper.addHeadBaseInfoByRowSet(ctx, mainOrgInfo, rs, headInfo, billids.toString());
                QCReportCreateHelper.addReportEntryInfoFromCreateReportTempTable(ctx, tableName, headInfo);
                if (headInfo.getEntrys() == null || headInfo.getEntrys().size() == 0) {
                    throw new QMException(QMException.CANNOTCREATEQCREPORT);
                }
                QCReportCreateHelper.fixReportData(ctx, headInfo, tableName);
                reportCols.add(headInfo);
            }
            QCReportCheckResultServerHelper.computeCheckResult(ctx, (IObjectCollection)reportCols);
            ctx.put((Object)"ISCreateFrom", (Object)Boolean.TRUE);
            IQCReport ibiz = QCReportFactory.getLocalInstance(ctx);
            QCReportCheckLotHelper.addBatchInfo(ctx, (IObjectCollection)reportCols);
            for (int i = 0; i < reportCols.size(); ++i) {
                QCReportInfo reportInfo = reportCols.get(i);
                QCReportServerHelper.initNumberByCodeingRule(ctx, codeingRuleStrategy, codeingBean, reportInfo);
                QCReportCreateHelper.modifyQCItem(ctx, reportInfo);
                IObjectPK pk = ibiz.save((CoreBaseInfo)reportInfo);
                idList.add(pk);
            }
        }
        catch (EASBizException e1) {
            throw e1;
        }
        catch (BOSException e2) {
            throw e2;
        }
        catch (SQLException e3) {
            throw new SQLDataException(e3);
        }
        finally {
            QCReportTempTableHelper.releaseTempTable(ctx, tableName);
            ctx.remove((Object)"ISCreateFrom");
        }
        return idList;
    }

    public static void modifyQCItem(Context ctx, QCReportInfo reportInfo) throws BOSException, EASBizException {
        Iterator it = reportInfo.getEntrys().iterator();
        while (it.hasNext()) {
            QCReportEntryInfo entryInfo = (QCReportEntryInfo)it.next();
            QCModifyModeInfo modifyInfo = entryInfo.getQCModifyMode();
            String checkValue = entryInfo.getCheckValue();
            QCValueTypeEnum valueType = entryInfo.getQCValueType();
            boolean canModify = valueType == QCValueTypeEnum.number || valueType == QCValueTypeEnum.formula;
            if (!canModify || modifyInfo == null || StringUtil.isEmptyString((String)checkValue)) continue;
            try {
                modifyInfo = QCModifyModeFactory.getLocalInstance((Context)ctx).getQCModifyModeInfo((IObjectPK)new ObjectUuidPK(modifyInfo.getId()));
                BigDecimal modifyTo = new BigDecimal(checkValue);
                int dataPrecision = 8;
                BigDecimal afterModifyVar = QCModifyModeHelper.modify((BigDecimal)modifyTo, (QCModifyModeInfo)modifyInfo, (int)dataPrecision);
                entryInfo.setCheckValue(afterModifyVar.toString());
                entryInfo.setSysCheckValue(afterModifyVar.toString());
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)nfe);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static void fixReportData(Context ctx, QCReportInfo reportInfo, String tableName) throws BOSException, EASBizException {
        Iterator it = reportInfo.getEntrys().iterator();
        StringBuffer ids = new StringBuffer();
        ids.append("''");
        while (it.hasNext()) {
            QCReportEntryInfo entryInfo = (QCReportEntryInfo)it.next();
            ids.append(",'" + entryInfo.getSourceBillEntryID() + "'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT FRemark,FSourceBillEntryID FROM " + tableName + " \n");
        sql.append("WHERE FSourceBillEntryID IN \n");
        sql.append("(" + ids.toString() + ") \n");
        sql.append(" \n");
        logger.debug((Object)sql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer remark = new StringBuffer();
        try {
            while (rs.next()) {
                String tempRemark = rs.getString("FRemark");
                if (StringUtil.isEmptyString((String)tempRemark)) continue;
                remark.append(tempRemark + ";");
            }
            String description = remark.toString();
            if (description.length() > 0) {
                description = description.substring(0, description.length() - 1);
            }
            reportInfo.setDescription(description);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void insertCreateReportDataToTempTable(Context ctx, String tableName, String billids, String billentryids, String reportids, String reportentryids) throws BOSException, EASBizException {
        String sql1 = QCReportCreateHelper.buildInsertCreateReportDataToTempTable(ctx, tableName, billids, billentryids);
        String sql2 = QCReportCreateHelper.buildAppendOtherReportDataToTempTable(ctx, tableName, reportids, reportentryids);
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            st.addBatch(sql1);
            st.addBatch(sql2);
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        StringBuffer sql3 = new StringBuffer();
        sql3.append("SELECT DISTINCT QCBILLSE.FID,QCOLDSE.FSAMPLEQTY,QCOLDSE.FNUMBER  \n");
        sql3.append("FROM T_QM_QCBILL QCBILL \n");
        sql3.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY QCBILLSE \n");
        sql3.append("ON QCBILL.FID = QCBILLSE.FPARENTID \n");
        sql3.append("INNER JOIN T_QM_QCSAMPLE QCSAMPLE \n");
        sql3.append("ON QCSAMPLE.FID = QCBILL.FSOURCEBILLID \n");
        sql3.append("INNER JOIN T_QM_QCREINSPECTREQ QCREIBILL \n");
        sql3.append("ON QCSAMPLE.FSOURCEBILLID = QCREIBILL.FID \n");
        sql3.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY QCOLDSE \n");
        sql3.append("ON QCREIBILL.FSOURCEBILLENTRYID = QCOLDSE.FID \n");
        sql3.append("WHERE QCBILLSE.FID IN \n");
        sql3.append("(SELECT FSourceBillEntryID FROM " + tableName + ") \n");
        sql3.append("AND QCOLDSE.FREINSPECTFORM IN (20,30) \n");
        sql3.append("AND QCBILLSE.FCloseBillNum is null \n");
        sql3.append(" \n");
        sql3.append("UNION \n");
        sql3.append("SELECT DISTINCT QCBILLSE.FID,QCOLDSE.FSAMPLEQTY,QCOLDSE.FNUMBER  \n");
        sql3.append("FROM T_QM_QCBILL QCBILL \n");
        sql3.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY QCBILLSE \n");
        sql3.append("ON QCBILL.FID = QCBILLSE.FPARENTID \n");
        sql3.append("INNER JOIN T_QM_QCREINSPECTREQ QCREIBILL \n");
        sql3.append("ON QCBILL.FSOURCEBILLID = QCREIBILL.FID \n");
        sql3.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY QCOLDSE \n");
        sql3.append("ON QCREIBILL.FSOURCEBILLENTRYID = QCOLDSE.FID \n");
        sql3.append("WHERE QCBILLSE.FID IN \n");
        sql3.append("(SELECT FSourceBillEntryID FROM " + tableName + ") \n");
        sql3.append("AND QCOLDSE.FREINSPECTFORM IN (20,30) \n");
        sql3.append("AND QCBILLSE.FCloseBillNum is null \n");
        sql3.append(" \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql3.toString());
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            while (rs.next()) {
                BigDecimal sampleQty = rs.getBigDecimal("FSAMPLEQTY");
                String qcbillentryID = rs.getString("FID");
                String sampleNumber = rs.getString("FNUMBER");
                StringBuffer batchSql = new StringBuffer();
                batchSql.append("UPDATE " + tableName + " \n");
                batchSql.append("SET FSampleQty=FSampleQty+" + sampleQty + " \n");
                batchSql.append("WHERE FSourceBillEntryID='" + qcbillentryID + "' \n");
                batchSql.append("AND NOT EXISTS(");
                batchSql.append("SELECT FSourceBillEntryID FROM " + tableName + " \n");
                batchSql.append("WHERE FSourceBillEntryID != '" + qcbillentryID + "' \n");
                batchSql.append("AND FSAMPLENUMBER='" + sampleNumber + "' \n");
                batchSql.append(") \n");
                batchSql.append(" \n");
                st.addBatch(batchSql.toString());
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    public static String buildAppendOtherReportDataToTempTable(Context ctx, String tableName, String reportbillids, String reportbillentryids) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tableName + "  \n");
        sql.append("( \n");
        sql.append("FID,FSourceBillID,FSourceBillNumber,FRequestID, \n");
        sql.append("FRequestEntryID,FRequestNum,FRequestEntryNum, \n");
        sql.append("FMaterialID,FQCStandardID,FISCONSTANDARD, \n");
        sql.append("FAdjustMaterialID,FAdjustQCStandardID, \n");
        sql.append("FSampleSolution,FBizBillType,FSourceBillEntryID, \n");
        sql.append("FSampleNumber,FSampleSerial,FQCItemID, \n");
        sql.append("FSourceBillType,FIsCheck,FIsKeyItem, \n");
        sql.append("FCheckValue,FCheckValueUnitID, \n");
        sql.append("FRemark,FRemark1,FCheckResult, \n");
        sql.append("FCheckDescription,FJudgeType,FLowerLimit, \n");
        sql.append("FLower,FUpperLimit,FUpper, \n");
        sql.append("FQCGroupID,FQCGroupPersonID,FQCInstrumentID, \n");
        sql.append("FCheckStep,FQCStandardRequirement, \n");
        sql.append("FQCFrequencyID, \n");
        sql.append("FQCMethodID,FQCItemAttr,FSampleUnitID, \n");
        sql.append("FIsRuinous,FSampleQty, \n");
        sql.append("FModifyMode,FDataPrecision,FExpDateEnd, \n");
        sql.append("FSampleBaseUnitID, \n");
        sql.append("FCheckBatchUnitID,FCheckBatchBaseUnitID, \n");
        sql.append("FSendQty,  \n");
        sql.append("FQCDGOrgUnitID, \n");
        sql.append("FQCInstrumentGroupID, \n");
        sql.append("FEnums, \n");
        sql.append("FExpression, \n");
        sql.append("FAnalysisMethod, \n");
        sql.append("FQCValueType, \n");
        sql.append("FISBalItem, \n");
        sql.append("FDefaultValue, \n");
        sql.append("FTotalSampleQty, \n");
        sql.append("FQCStrategy, \n");
        sql.append("FSampleHierarchy, \n");
        sql.append("FQCValueAcquisitionMode, \n");
        sql.append("FSampleShares, \n");
        sql.append("FPassShares, \n");
        sql.append("FUnPassShares, \n");
        sql.append("FSysCheckValue, \n");
        sql.append("FSourceItemEntryID, \n");
        sql.append("FSampleProgramID, \n");
        sql.append("FAcValue, \n");
        sql.append("FReValue, \n");
        sql.append("FDefectQty, \n");
        sql.append("FEachSampleUnitID, \n");
        sql.append("FEachSampleQty ");
        sql.append(" \n");
        sql.append(") \n");
        sql.append("SELECT newbosid('QCREPORT') AS FID, \n");
        sql.append("REPORT.FID AS FSOURCEBILLID, \n");
        sql.append("REPORT.FNUMBER AS FSOURCEBILLNUMBER, \n");
        sql.append("COREREQUEST.FID AS REQUESTID,  \n");
        sql.append("COREREQUESTENTRY.FID AS REQUESTENTRYID,    \n");
        sql.append("COREREQUEST.FNUMBER AS REQUESTNUM,   \n");
        sql.append("COREREQUESTENTRY.FNUMBER AS REQUESTENTRYNUM,    \n");
        sql.append("COREREQUESTENTRY.FMATERIALID AS FMaterialID,   \n");
        sql.append("COREREQUESTENTRY.FQCSTANDARDID AS FQCStandardID,    \n");
        sql.append("COREREQUESTENTRY.FISCONSTANDARD AS FISCONSTANDARD,   \n");
        sql.append("COREREQUESTENTRY.FMATERIALID AS FAdjustMaterialID,    \n");
        sql.append("COREREQUESTENTRY.FQCSTANDARDID AS FAdjustQCStandardID, \n");
        sql.append("STANDARD.FSAMPLESOLUTION AS FSampleSolution, \n");
        sql.append("STANDARD.FBILLTYPEID AS FBizBillType,  \n");
        sql.append("REPORTENTRY.FID AS FSourceBillEntryID,   \n");
        sql.append("REQUESTENTRY.FSAMPLENUMBER AS FSampleNumber,  \n");
        sql.append("'' AS FSampleSerial,  \n");
        sql.append("REPORTENTRY.FQCITEMID     AS FQCITEMID, \n");
        sql.append("'9029ADA2' AS FSourceBillType, \n");
        sql.append("REPORTENTRY.FISMUSTCHECK  AS FIsCheck, \n");
        sql.append("REPORTENTRY.FISKEYITEM    AS FIsKeyItem, \n");
        sql.append("REPORTENTRY.FCHECKVALUE   AS FCheckValue, \n");
        sql.append("REPORTENTRY.FUnitID   AS FCheckValueUnitID, \n");
        sql.append("REPORT.FDescription AS FREMARK, \n");
        sql.append("REPORTENTRY.FREMARK AS FREMARK1, \n");
        sql.append("REPORTENTRY.FCHECKRESULT  AS FCheckResult, \n");
        sql.append("REPORTENTRY.FQCDESCRIPTION AS FCheckDescription, \n");
        sql.append("REPORTENTRY.FJUDGETYPE    AS FJUDGETYPE, \n");
        sql.append("REPORTENTRY.FLOWERLIMIT   AS FLOWERLIMIT, \n");
        sql.append("REPORTENTRY.FLOWER AS FLOWER, \n");
        sql.append("REPORTENTRY.FUPPERLIMIT   AS FUPPERLIMIT, \n");
        sql.append("REPORTENTRY.FUPPER AS FUPPER, \n");
        sql.append("REPORTENTRY.FQCGROUPID    AS FQCGROUPID, \n");
        sql.append("REPORTENTRY.FCHECKERID    AS FQCGROUPPERSONID, \n");
        sql.append("REPORTENTRY.FQCINSTRUMENTID AS FQCINSTRUMENTID, \n");
        sql.append("REPORTENTRY.FCHECKSTEP    AS FCheckStemp, \n");
        sql.append("REPORTENTRY.FSTANDARDREQUIREMENT AS FSTANDARDREQUIREMENT, \n");
        sql.append("REPORTENTRY.FQCFREQUENCYID AS FQCFREQUENCYID, \n");
        sql.append("REPORTENTRY.FQCMETHODID   AS FQCMETHODID, \n");
        sql.append("REPORTENTRY.FQCITEMATTR   AS FQCITEMATTRID, \n");
        sql.append("REPORT.FSampeUnitID AS FSampleUnitID, \n");
        sql.append("REPORTENTRY.FISRUINOUS AS FISRUINOUS, \n");
        sql.append("REQUESTENTRY.FDELIVERQTY AS FSAMPLEQTY, \n");
        sql.append("REPORTENTRY.FQCModifyModeID AS FQCModifyModeID , \n");
        sql.append("REPORTENTRY.FDataPrecision AS FDataPrecision , \n");
        sql.append("COREREQUESTENTRY.FEXPDATE AS FExpDateEnd,  \n");
        sql.append("REPORT.FSampeBaseUnitID AS FSampleBaseUnitID, \n");
        sql.append("COREREQUESTENTRY.FUNITID AS FCheckBatchUnitID,  \n");
        sql.append("COREREQUESTENTRY.FBaseUnitID AS FCheckBatchBaseUnitID,  \n");
        sql.append("COREREQUESTENTRY.FDELIVERQTY AS FSendQty,  \n");
        sql.append("REPORTENTRY.FDelegOrgUnitID, \n");
        sql.append("REPORTENTRY.FQCInstrumentGroupID, \n");
        sql.append("REPORTENTRY.FEnums, \n");
        sql.append("REPORTENTRY.FExpression, \n");
        sql.append("REPORTENTRY.FAnalysisMethod, \n");
        sql.append("REPORTENTRY.FQCValueType, \n");
        sql.append("REPORTENTRY.FISBalanceItem, \n");
        sql.append("REPORTENTRY.FDefaultValue, \n");
        sql.append("QCSAMPLE.FTotalSampleShares, \n");
        sql.append("COREREQUESTENTRY.FQcStrategy, \n");
        sql.append("STANDARD.FSampleHierarchy AS FSampleHierarchy, \n");
        sql.append("REPORTENTRY.FQCValueAcquisitionMode, \n");
        sql.append("REPORTENTRY.FSampleShares, \n");
        sql.append("REPORTENTRY.FPassShares, \n");
        sql.append("REPORTENTRY.FUnPassShares, \n");
        sql.append("REPORTENTRY.FSysCheckValue, \n");
        sql.append("REPORTENTRY.FID, \n");
        sql.append("REPORTENTRY.FSampleProgramID, \n");
        sql.append("REPORTENTRY.FAcValue, \n");
        sql.append("REPORTENTRY.FReValue, \n");
        sql.append("REPORTENTRY.FDefectQty, \n");
        sql.append("REPORTENTRY.FEachSampleUnitID, \n");
        sql.append("REPORTENTRY.FEachSampleQty ");
        sql.append(" \n");
        sql.append(" \n");
        sql.append("FROM T_QM_QCREQUEST REQUEST \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY REQUESTENTRY \n");
        sql.append("ON REQUEST.FID =REQUESTENTRY.FPARENTID \n");
        sql.append("INNER JOIN T_QM_QCREPORT REPORT \n");
        sql.append("ON REQUEST.FID = REPORT.FREQUESTID \n");
        sql.append("AND REPORT.FREQUESTENTRYID = REQUESTENTRY.FID \n");
        sql.append("INNER JOIN T_QM_QCREPORTENTRY REPORTENTRY  \n");
        sql.append("ON REPORT.FID =REPORTENTRY.FPARENTID \n");
        sql.append("INNER JOIN  T_QM_QCREQUEST COREREQUEST \n");
        sql.append("ON  COREREQUEST.FID = REQUESTENTRY.FSOURCEREQUESTID  \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY COREREQUESTENTRY \n");
        sql.append("ON COREREQUESTENTRY.FPARENTID = COREREQUEST.FID \n");
        sql.append("AND COREREQUESTENTRY.FID = REQUESTENTRY.FSOURCEREQUESTENTRYID \n");
        sql.append("INNER JOIN T_QM_QCSTANDARD STANDARD  \n");
        sql.append("ON COREREQUESTENTRY.FQCSTANDARDID = STANDARD.FID \n");
        sql.append("LEFT JOIN T_QM_QCSample QCSAMPLE \n");
        sql.append("ON QCSAMPLE.FREQUESTENTRYID = REQUESTENTRY.fid");
        sql.append(" \n");
        sql.append(" \n");
        sql.append(" \n");
        sql.append("WHERE REPORT.FID IN (" + reportbillids + ") \n");
        sql.append("AND REPORTENTRY.FID IN (" + reportbillentryids + ") \n");
        logger.debug((Object)sql.toString());
        return sql.toString();
    }

    public static String buildInsertCreateReportDataToTempTable(Context ctx, String tableName, String billids, String billentryids) throws BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO " + tableName + "  \n");
        insertSql.append("( \n");
        insertSql.append("FID,FSourceBillID,FSourceBillNumber,FRequestID, \n");
        insertSql.append("FRequestEntryID,FRequestNum,FRequestEntryNum, \n");
        insertSql.append("FMaterialID,FQCStandardID,FISCONSTANDARD, \n");
        insertSql.append("FAdjustMaterialID,FAdjustQCStandardID, \n");
        insertSql.append("FSampleSolution,FBizBillType,FSourceBillEntryID, \n");
        insertSql.append("FSampleNumber,FSampleSerial,FQCItemID, \n");
        insertSql.append("FSourceBillType,FIsCheck,FIsKeyItem, \n");
        insertSql.append("FCheckValue,FCheckValueUnitID, \n");
        insertSql.append("FRemark,FRemark1,FCheckResult, \n");
        insertSql.append("FCheckDescription,FJudgeType,FLowerLimit, \n");
        insertSql.append("FLower,FUpperLimit,FUpper, \n");
        insertSql.append("FQCGroupID,FQCGroupPersonID,FQCInstrumentID, \n");
        insertSql.append("FCheckStep,FQCStandardRequirement, \n");
        insertSql.append("FQCFrequencyID, \n");
        insertSql.append("FQCMethodID,FQCItemAttr,FSampleUnitID, \n");
        insertSql.append("FIsRuinous,FSampleQty, \n");
        insertSql.append("FModifyMode,FDataPrecision,FExpDateEnd, \n");
        insertSql.append("FSampleBaseUnitID, \n");
        insertSql.append("FCheckBatchUnitID,FCheckBatchBaseUnitID, \n");
        insertSql.append("FSendQty,  \n");
        insertSql.append("FQCDGOrgUnitID, \n");
        insertSql.append("FQCInstrumentGroupID, \n");
        insertSql.append("FEnums, \n");
        insertSql.append("FExpression, \n");
        insertSql.append("FAnalysisMethod, \n");
        insertSql.append("FQCValueType, \n");
        insertSql.append("FISBalItem, \n");
        insertSql.append("FDefaultValue, \n");
        insertSql.append("FTotalSampleQty, \n");
        insertSql.append("FQCStrategy, \n");
        insertSql.append("FSampleHierarchy, \n");
        insertSql.append("FQCValueAcquisitionMode, \n");
        insertSql.append("FSampleShares, \n");
        insertSql.append("FPassShares, \n");
        insertSql.append("FUnPassShares, \n");
        insertSql.append("FSysCheckValue, \n");
        insertSql.append("FSourceItemEntryID, \n");
        insertSql.append("FSampleProgramID, \n");
        insertSql.append("FAcValue, \n");
        insertSql.append("FReValue, \n");
        insertSql.append("FDefectQty, \n");
        insertSql.append("FEachSampleUnitID, \n");
        insertSql.append("FEachSampleQty, \n");
        insertSql.append("FBillItemEntrySeq ");
        insertSql.append(" \n");
        insertSql.append(") \n");
        insertSql.append("SELECT newbosid('QCREPORT') AS FID, \n");
        insertSql.append("QCBILL.FID AS FSOURCEBILLID, \n");
        insertSql.append("QCBILL.FNUMBER AS FSOURCEBILLNUMBER, \n");
        insertSql.append("ISNULL(QCBILL.FREQUESTID,'NULL') AS FREQUESTID, \n");
        insertSql.append("ISNULL(QCBILL.FREQUESTENTRYID,'NULL') AS FREQUESTENTRYID, \n");
        insertSql.append("ISNULL(QCBILL.FREQUESTNUM,'NULL') AS FQUESTNUM, \n");
        insertSql.append("ISNULL(QCBILL.FREQUESTENTRYNUM,'NULL') AS FQUESTNUMBER, \n");
        insertSql.append("REQUESTENTRY.FMATERIALID AS FMATERIALID,  \n");
        insertSql.append("REQUESTENTRY.FQCSTANDARDID AS FQCSTANDARDID,  \n");
        insertSql.append("REQUESTENTRY.FISCONSTANDARD AS FISCONSTANDARD,  \n");
        insertSql.append("REQUESTENTRY.FMATERIALID AS FADJUSTMATERIAL,  \n");
        insertSql.append("REQUESTENTRY.FQCSTANDARDID AS FADJUSTQCSTANDARD,  \n");
        insertSql.append("QCSTANDARD.FSAMPLESOLUTION AS FSAMPLESOLUTION, \n");
        insertSql.append("QCSTANDARD.FBILLTYPEID AS FBILLTYPEID,    \n");
        insertSql.append("QCBILLENTRY.FID AS FSOURCEBILLENTRYID, \n");
        insertSql.append("QCBILLENTRY.FNUMBER AS FSAMPLENUMBER, \n");
        insertSql.append("QCBILLENTRY.FSERIALNUM AS FSAMPLESERIALNUMBER, \n");
        insertSql.append("QCBILLITEMENTRY.FQCITEMID AS FQCITEMID, \n");
        insertSql.append("'1AC2BFF5' AS FSourceBillType, \n");
        insertSql.append("QCBILLITEMENTRY.FIsMustCheck AS FIsCheck, \n");
        insertSql.append("QCBILLITEMENTRY.FIsKeyItem AS FIsKeyItem, \n");
        insertSql.append("QCBILLITEMENTRY.FCheckValue AS FCheckValue, \n");
        insertSql.append("QCBILLITEMENTRY.FUnitID AS FCheckValueUnitID, \n");
        insertSql.append("QCBILL.FDescription AS FRemark, \n");
        insertSql.append("QCBILLITEMENTRY.FRemark AS FRemark1, \n");
        insertSql.append("QCBILLITEMENTRY.FCheckResult AS FCheckResult, \n");
        insertSql.append("QCBILLITEMENTRY.FQCDescription AS FQCDescription, \n");
        insertSql.append("QCBILLITEMENTRY.FJudgeType AS FJudgeType, \n");
        insertSql.append("QCBILLITEMENTRY.FLowerLimit AS FLowerLimit, \n");
        insertSql.append("QCBILLITEMENTRY.FLower AS FLower, \n");
        insertSql.append("QCBILLITEMENTRY.FUpperLimit AS FUpperLimit, \n");
        insertSql.append("QCBILLITEMENTRY.FUpper AS FUpper, \n");
        insertSql.append("QCBILLITEMENTRY.FQCGroupID AS FQCGroupID, \n");
        insertSql.append("QCBILLITEMENTRY.FCheckerID AS FQCGroupPersonID, \n");
        insertSql.append("QCBILLITEMENTRY.FQCInstrumentID AS FQCInstrumentID, \n");
        insertSql.append("QCBILLITEMENTRY.FCheckStep AS FCheckStep, \n");
        insertSql.append("QCBILLITEMENTRY.FStandardRequirement AS FStandardRequirement, \n");
        insertSql.append("QCBILLITEMENTRY.FQCFrequencyID AS FQCFrequencyID, \n");
        insertSql.append("QCBILLITEMENTRY.FQCMethodID AS FQCMethodID, \n");
        insertSql.append("QCBILLITEMENTRY.FQCItemAttr AS FQCItemAttr, \n");
        insertSql.append("QCBILLENTRY.FUNITID AS FSampleUnitID, \n");
        insertSql.append("QCBILLITEMENTRY.FISRUINOUS AS FISRUINOUS, \n");
        insertSql.append("QCBILLENTRY.FSAMPLEQTY AS FSampleQty, \n");
        insertSql.append("QCBILLITEMENTRY.FQCModifyModeID AS FModifyMode, \n");
        insertSql.append("QCBILLITEMENTRY.FDataPrecision AS FDataPrecision, \n");
        insertSql.append("REQUESTENTRY.FExpDate AS FExpDate, \n");
        insertSql.append("QCBILLENTRY.FBaseUnitID AS FSampleBaseUnitID, \n");
        insertSql.append("REQUESTENTRY.FUNITID AS FCheckBatchUnitID, \n");
        insertSql.append("REQUESTENTRY.FBaseUnitID AS FCheckBatchBaseUnitID, \n");
        insertSql.append("REQUESTENTRY.FDeliverQty AS FSendQty, \n");
        insertSql.append("QCBILLITEMENTRY.FDelegOrgUnitID, \n");
        insertSql.append("QCBILLITEMENTRY.FQCInstrumentGroupID, \n");
        insertSql.append("QCBILLITEMENTRY.FEnums, \n");
        insertSql.append("QCBILLITEMENTRY.FExpression, \n");
        insertSql.append("QCBILLITEMENTRY.FAnalysisMethod, \n");
        insertSql.append("QCBILLITEMENTRY.FQCValueType, \n");
        insertSql.append("QCBILLITEMENTRY.FISBalanceItem, \n");
        insertSql.append("QCBILLITEMENTRY.FDefaultValue, \n");
        insertSql.append("QCSAMPLE.FTotalSampleShares, \n");
        insertSql.append("REQUESTENTRY.FQcStrategy, \n");
        insertSql.append("QCSTANDARD.FSampleHierarchy AS FSampleHierarchy, \n");
        insertSql.append("QCBILLITEMENTRY.FQCValueAcquisitionMode, \n");
        insertSql.append("QCBILLITEMENTRY.FSampleShares, \n");
        insertSql.append("QCBILLITEMENTRY.FPassShares, \n");
        insertSql.append("QCBILLITEMENTRY.FUnPassShares, \n");
        insertSql.append("QCBILLITEMENTRY.FCheckValue, \n");
        insertSql.append("QCBILLITEMENTRY.FID, \n");
        insertSql.append("QCBILLITEMENTRY.FSampleProgramID, \n");
        insertSql.append("QCBILLITEMENTRY.FAcValue, \n");
        insertSql.append("QCBILLITEMENTRY.FReValue, \n");
        insertSql.append("QCBILLITEMENTRY.FDefectQty, \n");
        insertSql.append("QCBILLENTRY.FUnitID, \n");
        insertSql.append("QCBILLENTRY.FEachSampleQty, \n");
        insertSql.append("QCSTANDARDentry.FSeq ");
        insertSql.append("FROM T_QM_QCBILL QCBILL \n");
        insertSql.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY QCBILLENTRY  \n");
        insertSql.append("ON QCBILL.FID = QCBILLENTRY.FPARENTID \n");
        insertSql.append("INNER JOIN T_QM_QCBILLENTRY QCBILLITEMENTRY  \n");
        insertSql.append("ON QCBILLENTRY.FID = QCBILLITEMENTRY.FSAMPLEPARENTID  \n");
        insertSql.append("AND QCBILL.FID = QCBILLITEMENTRY.FPARENTID \n");
        insertSql.append("INNER JOIN T_QM_QCRequestEntry REQUESTENTRY \n");
        insertSql.append("ON REQUESTENTRY.FID =QCBILL.FRequestEntryID  \n");
        insertSql.append("AND REQUESTENTRY.FPARENTID =QCBILL.FRequestID  \n");
        insertSql.append("INNER JOIN T_QM_QCSTANDARD QCSTANDARD  \n");
        insertSql.append("ON REQUESTENTRY.FQCSTANDARDID = QCSTANDARD.FID \n");
        insertSql.append("LEFT JOIN T_QM_QCSTANDARDitementries QCSTANDARDentry  \n");
        insertSql.append("on QCSTANDARD.fid = QCSTANDARDentry.fparentid and QCSTANDARDentry.fqcitemid = QCBILLITEMENTRY.fqcitemid \n");
        insertSql.append("LEFT JOIN T_QM_QCSample QCSAMPLE \n");
        insertSql.append("ON QCBILL.FSOURCEBILLID = QCSAMPLE.FID");
        insertSql.append(" \n");
        insertSql.append("WHERE QCBILL.FID IN(" + billids + ") \n");
        insertSql.append("AND QCBILLENTRY.FID IN(" + billentryids + ") \n");
        insertSql.append(" order by  QCSTANDARDentry.FSeq   ");
        insertSql.append(" \n");
        logger.debug((Object)insertSql.toString());
        return insertSql.toString();
    }

    public static String buildSelectHeadSqlFromCreateReportTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT \n");
        sql.append("T.FREQUESTID,T.FREQUESTNUM, \n");
        sql.append("T.FREQUESTENTRYID,T.FREQUESTENTRYNUM, \n");
        sql.append("T.FMATERIALID,T.FQCSTANDARDID, \n");
        sql.append("T.FISCONSTANDARD,T.FADJUSTMATERIALID, \n");
        sql.append("T.FADJUSTQCSTANDARDID,T.FSAMPLESOLUTION, \n");
        sql.append("T.FBIZBILLTYPE,BIZBILLTYPE.FREJECTPMODE, \n");
        sql.append("T.FCHECKBATCHUNITID,T.FCHECKBATCHBASEUNITID, \n");
        sql.append("T.FSENDQTY,T.FExpDateEnd,T.FSampleHierarchy,T.FQCStrategy \n");
        sql.append(" \n");
        sql.append("FROM " + tableName + " T \n");
        sql.append("LEFT JOIN T_QM_QCBIZBILLTYPE BIZBILLTYPE \n");
        sql.append("ON T.FBIZBILLTYPE =BIZBILLTYPE.FID  \n");
        sql.append(" \n");
        sql.append("ORDER BY \n");
        sql.append("T.FREQUESTID, \n");
        sql.append("T.FREQUESTNUM, \n");
        sql.append("T.FREQUESTENTRYID, \n");
        sql.append("T.FREQUESTENTRYNUM \n");
        logger.debug((Object)sql.toString());
        return sql.toString();
    }

    public static void addReportEntryInfoFromCreateReportTempTable(Context ctx, String tableName, QCReportInfo headInfo) throws BOSException, EASBizException {
        String requestKey = headInfo.getRequestID() + "<#>" + headInfo.getRequestNum() + "<#>" + headInfo.getRequestEntryID() + "<#>" + headInfo.getRequestEntryNum();
        String sql = QCReportCreateHelper.buildSelectEntrySqlFromCreateReportTempTable(ctx, tableName, requestKey);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> itemList = new ArrayList<String>();
        try {
            while (rs.next()) {
                QCResultJudgeEnum qCResultJudge = QCResultJudgeEnum.getEnum(rs.getInt("FCheckResult"));
                if (qCResultJudge != null && QCResultJudgeEnum.cancel.equals((Object)qCResultJudge)) continue;
                String qcItemID = rs.getString("FQCITEMID");
                if (itemList.contains(qcItemID)) {
                    QCReportCreateHelper.mergeEntryBaseInfoByRowSet(headInfo, qcItemID, rs, ctx);
                } else {
                    itemList.add(qcItemID);
                    QCReportEntryInfo entryInfo = new QCReportEntryInfo();
                    entryInfo.setParent(headInfo);
                    QCReportCreateHelper.addEntryBaseInfoByRowSet(ctx, rs, entryInfo);
                    headInfo.getEntrys().add(entryInfo);
                }
                QCReportAllItemEntryInfo allItemEntryInfo = new QCReportAllItemEntryInfo();
                allItemEntryInfo.setParent(headInfo);
                QCReportCreateHelper.addEntryBaseInfoByRowSet(ctx, rs, allItemEntryInfo);
                headInfo.getAllItemEntry().add(allItemEntryInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void mergeEntryBaseInfoByRowSet(QCReportInfo headInfo, String qcItemID, IRowSet rs, Context ctx) throws SQLException, EASBizException, BOSException {
        QCReportEntryCollection entries = headInfo.getEntrys();
        for (int i = 0; i < entries.size(); ++i) {
            QCReportEntryInfo entryInfo = entries.get(i);
            String itemid = entryInfo.getQCItem().getId().toString();
            if (!qcItemID.equals(itemid)) continue;
            String qcBillEntryId = rs.getString("FSourceItemEntryID");
            QCReportCreateHelper.setQCReportSampleItem(ctx, entryInfo, qcBillEntryId);
            int preMergeItemQty = entryInfo.getMergeItemQty();
            int mergeItemQty = preMergeItemQty + 1;
            entryInfo.setMergeItemQty(mergeItemQty);
            BigDecimal preSampleShares = entryInfo.getSampleShares();
            BigDecimal newSampleShares = rs.getBigDecimal("FSampleShares");
            BigDecimal sampleShares = preSampleShares == null ? newSampleShares : preSampleShares.add(newSampleShares == null ? new BigDecimal("0") : newSampleShares);
            entryInfo.setSampleShares(sampleShares);
            BigDecimal prePassShares = entryInfo.getPassShares();
            BigDecimal newPassShares = rs.getBigDecimal("FPassShares");
            BigDecimal passShares = prePassShares == null ? newPassShares : prePassShares.add(newPassShares == null ? new BigDecimal("0") : newPassShares);
            entryInfo.setPassShares(passShares);
            BigDecimal preUnPassShares = entryInfo.getUnPassShares();
            BigDecimal newUnPassShares = rs.getBigDecimal("FUnPassShares");
            BigDecimal unPassShares = preUnPassShares == null ? newUnPassShares : preUnPassShares.add(newUnPassShares == null ? new BigDecimal("0") : newUnPassShares);
            entryInfo.setUnPassShares(unPassShares);
            MergeModeEnum mergeMode = MergeModeEnum.ARITHMETICMEAN;
            String requestEntryId = headInfo.getRequestEntryID();
            String sql = "select FMergeMode from T_QM_QCRequestQcItemEntry where FEntryID = '" + requestEntryId + "' and FQCItemID = '" + qcItemID + "' ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                int mergeModeValue = rowSet.getInt("FMergeMode");
                mergeMode = MergeModeEnum.getEnum((int)mergeModeValue);
            }
            QCValueTypeEnum valueType = QCValueTypeEnum.getEnum((int)rs.getInt("FQCValueType"));
            if (valueType.equals((Object)QCValueTypeEnum.enumvalue) || valueType.equals((Object)QCValueTypeEnum.text)) {
                entryInfo.setCheckValue(null);
                entryInfo.setSysCheckValue(null);
                entryInfo.setCheckResult(QCResultJudgeEnum.isNull);
            } else if (entryInfo.getCheckValue() != null || rs.getBigDecimal("FCheckValue") != null) {
                BigDecimal nowSysQty;
                BigDecimal preQty = new BigDecimal(entryInfo.getCheckValue() == null ? "0" : entryInfo.getCheckValue());
                BigDecimal nowQty = rs.getBigDecimal("FCheckValue") == null ? new BigDecimal("0") : rs.getBigDecimal("FCheckValue");
                BigDecimal preSysQty = new BigDecimal(entryInfo.getSysCheckValue() == null ? "0" : entryInfo.getSysCheckValue());
                BigDecimal bigDecimal = nowSysQty = rs.getBigDecimal("FSysCheckValue") == null ? new BigDecimal("0") : rs.getBigDecimal("FSysCheckValue");
                if (mergeMode.equals((Object)MergeModeEnum.ARITHMETICMEAN)) {
                    BigDecimal nowMergeItemQty = new BigDecimal(entryInfo.getMergeItemQty());
                    BigDecimal preSumQty = preQty.multiply(new BigDecimal(preMergeItemQty));
                    BigDecimal nowSumQty = preSumQty.add(nowQty);
                    BigDecimal nowCheckValue = nowSumQty.divide(nowMergeItemQty, 8, 4);
                    entryInfo.setCheckValue(nowCheckValue.toString());
                    BigDecimal preSysSumQty = preSysQty.multiply(new BigDecimal(preMergeItemQty));
                    BigDecimal nowSysSumQty = preSysSumQty.add(nowSysQty);
                    BigDecimal nowSysCheckValue = nowSysSumQty.divide(nowMergeItemQty, 8, 4);
                    entryInfo.setSysCheckValue(nowSysCheckValue.toString());
                } else if (mergeMode.equals((Object)MergeModeEnum.MAXIMUM)) {
                    if (nowQty.compareTo(preQty) == 1) {
                        entryInfo.setCheckValue(nowQty.toString());
                    }
                    if (nowSysQty.compareTo(preSysQty) == 1) {
                        entryInfo.setSysCheckValue(nowSysQty.toString());
                    }
                } else if (mergeMode.equals((Object)MergeModeEnum.MINIMUM)) {
                    if (nowQty.compareTo(preQty) == -1) {
                        entryInfo.setCheckValue(nowQty.toString());
                    }
                    if (nowSysQty.compareTo(preSysQty) == -1) {
                        entryInfo.setSysCheckValue(nowSysQty.toString());
                    }
                }
            }
            entryInfo.setSampleProgram(null);
            entryInfo.setAcValue(rs.getBigDecimal("FAcValue"));
            entryInfo.setReValue(rs.getBigDecimal("FReValue"));
            BigDecimal sumDefectQty = (entryInfo.getDefectQty() == null ? new BigDecimal("0") : entryInfo.getDefectQty()).add(rs.getBigDecimal("FDefectQty") == null ? new BigDecimal("0") : rs.getBigDecimal("FDefectQty"));
            entryInfo.setDefectQty(sumDefectQty);
            BigDecimal eachSampleQty = entryInfo.getEachSampleQty();
            if (eachSampleQty != null && sampleShares != null) {
                entryInfo.setSampleQty(eachSampleQty.multiply(sampleShares));
            } else {
                entryInfo.setSampleQty(new BigDecimal("0"));
            }
            entryInfo.setDelegOrgUnit(null);
            entryInfo.setQCGroup(null);
            entryInfo.setChecker(null);
            entryInfo.setQCInstrumentGroup(null);
            entryInfo.setQCInstrument(null);
            entryInfo.setCheckStep(null);
            entryInfo.setStandardRequirement(null);
            entryInfo.setQCMethod(null);
            entryInfo.setSampleNumber(null);
            entryInfo.setSeqNo(null);
            entryInfo.setString("reportEntrySrcType", null);
            entryInfo.setSourceBillNumber(null);
            entryInfo.setQCDescription(null);
            entryInfo.setRemark(null);
            if (entryInfo.getSampleProgram() != null) {
                QCReportCreateHelper.doStmToCheckResult(headInfo, entryInfo);
                continue;
            }
            entryInfo = QCReportCreateHelper.getCheckResult(headInfo, entryInfo);
        }
    }

    private static QCReportEntryInfo getCheckResult(QCReportInfo headInfo, QCReportEntryInfo entryinfo) {
        block54: {
            if (entryinfo.getSampleProgram() != null) {
                return entryinfo;
            }
            QCValueTypeEnum valueType = entryinfo.getQCValueType();
            if (valueType != QCValueTypeEnum.number && valueType != QCValueTypeEnum.formula) {
                return entryinfo;
            }
            String checkValue = entryinfo.getCheckValue();
            if (checkValue == null) {
                return entryinfo;
            }
            QCAnalysisMethodEnum asmEnum = entryinfo.getAnalysisMethod();
            if (asmEnum == QCAnalysisMethodEnum.qualitativeAnalysis) {
                String defaultValue = entryinfo.getDefaultValue();
                try {
                    BigDecimal temp2;
                    BigDecimal temp1 = new BigDecimal(checkValue.toString());
                    BigDecimal bigDecimal = temp2 = defaultValue == null ? SysConstant.BIGZERO : new BigDecimal(defaultValue.toString());
                    if (temp1.compareTo(temp2) == 0) {
                        entryinfo.setCheckResult(QCResultJudgeEnum.pass);
                        break block54;
                    }
                    entryinfo.setCheckResult(QCResultJudgeEnum.unPass);
                }
                catch (NumberFormatException e) {
                    entryinfo.setCheckResult(QCResultJudgeEnum.unPass);
                }
            } else if (asmEnum == QCAnalysisMethodEnum.quantitativeAnalysis) {
                JudgeTypeEnum judgeType = entryinfo.getJudgeType();
                if (judgeType == null || judgeType == JudgeTypeEnum.NULL) {
                    return entryinfo;
                }
                BigDecimal tempCheckValue = new BigDecimal(checkValue.toString());
                BigDecimal lowerValue = entryinfo.getLower();
                QCLowerLimitEnum lowerLimit = entryinfo.getLowerLimit();
                if (lowerLimit == QCLowerLimitEnum.isNull) {
                    lowerLimit = null;
                }
                BigDecimal upperValue = entryinfo.getUpper();
                QCUpperLimitEnum upperLimit = entryinfo.getUpperLimit();
                if (upperLimit == QCUpperLimitEnum.isNull) {
                    upperLimit = null;
                }
                if (upperValue != null && upperLimit != null && lowerValue != null && lowerLimit != null) {
                    BigDecimal temp1 = new BigDecimal(lowerValue.toString());
                    BigDecimal temp2 = new BigDecimal(upperValue.toString());
                    boolean ispass = true;
                    if (lowerLimit == QCLowerLimitEnum.equal) {
                        ispass = tempCheckValue.compareTo(temp1) == 0;
                    } else if (lowerLimit == QCLowerLimitEnum.graterAndEqual) {
                        ispass = tempCheckValue.compareTo(temp1) != -1;
                    } else if (lowerLimit == QCLowerLimitEnum.greater) {
                        ispass = tempCheckValue.compareTo(temp1) == 1;
                    }
                    if (upperLimit == QCUpperLimitEnum.equal) {
                        if (ispass && tempCheckValue.compareTo(temp2) == 0) {
                            ispass = true;
                        } else if (ispass) {
                            ispass = false;
                        }
                    } else if (upperLimit == QCUpperLimitEnum.lessAndEqual) {
                        if (ispass && tempCheckValue.compareTo(temp2) != 1) {
                            ispass = true;
                        } else if (ispass) {
                            ispass = false;
                        }
                    }
                    if (upperLimit == QCUpperLimitEnum.less) {
                        if (ispass && tempCheckValue.compareTo(temp2) == -1) {
                            ispass = true;
                        } else if (ispass) {
                            ispass = false;
                        }
                    }
                    entryinfo.setCheckResult(QCReportCreateHelper.getResultJudgeEnumByJudgeEnum(judgeType, ispass));
                } else if (upperValue != null && upperLimit != null) {
                    BigDecimal temp2 = new BigDecimal(upperValue.toString());
                    boolean ispass = true;
                    if (upperLimit == QCUpperLimitEnum.equal) {
                        if (ispass && tempCheckValue.compareTo(temp2) == 0) {
                            ispass = true;
                        } else if (ispass) {
                            ispass = false;
                        }
                    } else if (upperLimit == QCUpperLimitEnum.lessAndEqual) {
                        if (ispass && tempCheckValue.compareTo(temp2) != 1) {
                            ispass = true;
                        } else if (ispass) {
                            ispass = false;
                        }
                    }
                    if (upperLimit == QCUpperLimitEnum.less) {
                        if (ispass && tempCheckValue.compareTo(temp2) == -1) {
                            ispass = true;
                        } else if (ispass) {
                            ispass = false;
                        }
                    }
                    entryinfo.setCheckResult(QCReportCreateHelper.getResultJudgeEnumByJudgeEnum(judgeType, ispass));
                } else if (lowerValue != null && lowerLimit != null) {
                    BigDecimal temp2 = new BigDecimal(lowerValue.toString());
                    boolean ispass = true;
                    if (lowerLimit == QCLowerLimitEnum.equal) {
                        ispass = tempCheckValue.compareTo(temp2) == 0;
                    } else if (lowerLimit == QCLowerLimitEnum.graterAndEqual) {
                        ispass = tempCheckValue.compareTo(temp2) != -1;
                    } else if (lowerLimit == QCLowerLimitEnum.greater) {
                        ispass = tempCheckValue.compareTo(temp2) == 1;
                    }
                    entryinfo.setCheckResult(QCReportCreateHelper.getResultJudgeEnumByJudgeEnum(judgeType, ispass));
                } else {
                    entryinfo.setCheckResult(QCReportCreateHelper.getResultJudgeEnumByJudgeEnum(judgeType, false));
                }
            }
        }
        return entryinfo;
    }

    private static QCReportEntryInfo doStmToCheckResult(QCReportInfo headInfo, QCReportEntryInfo entryinfo) {
        if (entryinfo.getSampleProgram() != null) {
            QCSamplingProgramInfo samProInfo = entryinfo.getSampleProgram();
            EvaluateModeEnum eMode = samProInfo.getEvaluationMode();
            BigDecimal acValue = entryinfo.getAcValue();
            BigDecimal reValue = entryinfo.getReValue();
            BigDecimal unPassQty = entryinfo.getUnPassShares();
            BigDecimal defectQty = entryinfo.getDefectQty();
            if (eMode != null && (EvaluateModeEnum.countdeterminebymanual.equals((Object)eMode) || EvaluateModeEnum.countdeterminebysys.equals((Object)eMode))) {
                if (unPassQty != null && acValue != null && reValue != null) {
                    BigDecimal unPassQtyB = unPassQty instanceof Integer ? new BigDecimal((Integer)((Object)unPassQty)) : (unPassQty instanceof BigDecimal ? unPassQty : new BigDecimal("0"));
                    if (unPassQtyB.compareTo(acValue) != 1) {
                        entryinfo.setCheckResult(QCResultJudgeEnum.pass);
                    } else if (unPassQtyB.compareTo(reValue) != -1) {
                        entryinfo.setCheckResult(QCResultJudgeEnum.unPass);
                    } else {
                        entryinfo.setCheckResult(QCResultJudgeEnum.isNull);
                    }
                }
            } else if (eMode != null && (EvaluateModeEnum.pointdeterminebymanual.equals((Object)eMode) || EvaluateModeEnum.pointdeterminebysys.equals((Object)eMode)) && defectQty != null && acValue != null && reValue != null) {
                BigDecimal defectQtyB = defectQty instanceof Integer ? new BigDecimal((Integer)((Object)defectQty)) : (defectQty instanceof BigDecimal ? defectQty : new BigDecimal("0"));
                if (defectQtyB.compareTo(acValue) != 1) {
                    entryinfo.setCheckResult(QCResultJudgeEnum.pass);
                } else if (defectQtyB.compareTo(reValue) != -1) {
                    entryinfo.setCheckResult(QCResultJudgeEnum.unPass);
                } else {
                    entryinfo.setCheckResult(QCResultJudgeEnum.isNull);
                }
            }
        }
        return entryinfo;
    }

    public static QCResultJudgeEnum getResultJudgeEnumByJudgeEnum(JudgeTypeEnum type, boolean isPass) {
        if (type == JudgeTypeEnum.Qualified) {
            return isPass ? QCResultJudgeEnum.pass : QCResultJudgeEnum.unPass;
        }
        if (type == JudgeTypeEnum.UNQualified) {
            return isPass ? QCResultJudgeEnum.unPass : QCResultJudgeEnum.pass;
        }
        if (type == JudgeTypeEnum.NULL) {
            return QCResultJudgeEnum.noDeterminant;
        }
        return null;
    }

    protected String getJudgeTypeParamsValue(QCReportInfo headInfo) throws Exception {
        String orgID = null;
        if (headInfo.getQualityOrgUnit() != null) {
            orgID = headInfo.getQualityOrgUnit().getId().toString();
        }
        String judgeType = QMParamUtil.getParamValue(null, (String)"QM007", orgID);
        return judgeType;
    }

    public void computeCheckResult(QCReportInfo headInfo) throws Exception {
        String judgeType = this.getJudgeTypeParamsValue(headInfo);
        if (headInfo.getSampleSolution() == SampleSolutionEnum.allCheck) {
            headInfo.setCheckResult(CheckResultEnum.pass);
            return;
        }
        boolean isPass = true;
        if ("0".equals(judgeType) || "2".equals(judgeType) || "1".equals(judgeType)) {
            QCReportEntryCollection entries = headInfo.getEntrys();
            for (int i = 0; i < entries.size(); ++i) {
                QCReportEntryInfo entryInfo = entries.get(i);
                if (entryInfo.getCheckResult() != null && entryInfo.getCheckResult() != QCResultJudgeEnum.unPass && entryInfo.getCheckResult() != QCResultJudgeEnum.noDeterminant) continue;
                isPass = false;
                break;
            }
        } else {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"33_QCReportCheckResultClientHelper"));
        }
        headInfo.setCheckResult(isPass ? CheckResultEnum.pass : CheckResultEnum.unpass);
    }

    public static String buildSelectEntrySqlFromCreateReportTempTable(Context ctx, String tableName, String requestKey) throws BOSException, EASBizException {
        String[] keys = requestKey.split("<#>");
        String requestID = keys[0];
        String requestNum = keys[1];
        String requestEntryID = keys[2];
        String requestEntryNum = keys[3];
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  \n");
        sql.append("T.FSOURCEBILLID,T.FSOURCEBILLNUMBER, \n");
        sql.append("T.FSOURCEBILLENTRYID,T.FSourceBillType, \n");
        sql.append("T.FSAMPLENUMBER,T.FSAMPLESERIAL, \n");
        sql.append("T.FQCITEMID,T.FIsCheck, \n");
        sql.append("T.FIsKeyItem,T.FCheckValue,FCheckValueUnitID, \n");
        sql.append("T.FRemark1, \n");
        sql.append("T.FCheckResult,T.FCheckDescription, \n");
        sql.append("T.FJudgeType, T.FLowerLimit, \n");
        sql.append("T.FLower,T.FUpperLimit, \n");
        sql.append("T.FUpper,T.FQCGroupID, \n");
        sql.append("T.FQCGroupPersonID,T.FQCInstrumentID, \n");
        sql.append("T.FCheckStep,T.FQCStandardRequirement, \n");
        sql.append("T.FQCFrequencyID,T.FQCMethodID, \n");
        sql.append("T.FQCItemAttr,T.FSampleUnitID, \n");
        sql.append("T.FISRUINOUS,T.FSampleQty, \n");
        sql.append("T.FSampleBaseUnitID, \n");
        sql.append("T.FModifyMode, \n");
        sql.append("T.FDataPrecision, \n");
        sql.append("T.FQCDGOrgUnitID, \n");
        sql.append("T.FQCInstrumentGroupID, \n");
        sql.append("T.FEnums, \n");
        sql.append("T.FExpression, \n");
        sql.append("T.FAnalysisMethod, \n");
        sql.append("T.FQCValueType, \n");
        sql.append("T.FISBalItem, \n");
        sql.append("T.FDefaultValue, \n");
        sql.append("T.FQCValueAcquisitionMode, \n");
        sql.append("T.FSampleShares, \n");
        sql.append("T.FPassShares, \n");
        sql.append("T.FUnPassShares, \n");
        sql.append("T.FSysCheckValue, \n");
        sql.append("FSourceItemEntryID, \n");
        sql.append("FSampleProgramID,FAcValue,FReValue,FDefectQty, \n");
        sql.append("FEachSampleUnitID,FEachSampleQty \n");
        sql.append(" \n");
        sql.append("FROM " + tableName + " T \n");
        sql.append(" \n");
        sql.append("WHERE T.FREQUESTID = '" + requestID + "' \n");
        sql.append("AND T.FREQUESTNUM = '" + requestNum + "' \n");
        sql.append("AND T.FREQUESTENTRYID = '" + requestEntryID + "' \n");
        sql.append("AND T.FREQUESTENTRYNUM = '" + requestEntryNum + "' \n");
        sql.append(" \n");
        sql.append(" ORDER BY  \n");
        sql.append("T.FBillItemEntrySeq \n");
        sql.append(" \n");
        logger.debug((Object)sql.toString());
        return sql.toString();
    }

    public static void addHeadBaseInfoByRowSet(Context ctx, QualityOrgUnitInfo mainOrgInfo, IRowSet rs, QCReportInfo headInfo, String billids) throws BOSException, EASBizException {
        try {
            MeasureUnitInfo unit;
            String qcstandardID;
            headInfo.setId(BOSUuid.create((BOSObjectType)headInfo.getBOSType()));
            headInfo.setReportDate(new Date());
            headInfo.setBizDate(new Date());
            headInfo.setQualityOrgUnit(mainOrgInfo);
            headInfo.setFromBOTP(true);
            headInfo.setIsUsedReport(false);
            String reuqestNum = rs.getString("FREQUESTNUM");
            String requestEntryNum = rs.getString("FREQUESTENTRYNUM");
            String requestID = rs.getString("FREQUESTID");
            String requestEntryID = rs.getString("FREQUESTENTRYID");
            headInfo.setRequestID(requestID);
            headInfo.setRequestEntryID(requestEntryID);
            headInfo.setRequestNum(reuqestNum);
            headInfo.setRequestEntryNum(requestEntryNum);
            String materialID = "";
            materialID = rs.getString("FMATERIALID");
            if (!StringUtil.isEmptyString((String)materialID)) {
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)materialID));
                headInfo.setMaterial(material);
                headInfo.setJudgeMaterial(material);
            }
            if (!StringUtil.isEmptyString((String)(qcstandardID = rs.getString("FQCSTANDARDID")))) {
                QCStandardInfo qcstandard = new QCStandardInfo();
                qcstandard.setId(BOSUuid.read((String)qcstandardID));
                headInfo.setQCStandard(qcstandard);
                headInfo.setJudgeStandard(qcstandard);
            }
            headInfo.setSampleSolution(SampleSolutionEnum.getEnum((int)rs.getInt("FSAMPLESOLUTION")));
            String bizBillType = rs.getString("FBIZBILLTYPE");
            if (!StringUtil.isEmptyString((String)bizBillType)) {
                QCBizBillTypeInfo bizBillTypeInfo = new QCBizBillTypeInfo();
                bizBillTypeInfo.setId(BOSUuid.read((String)bizBillType));
                headInfo.setBillType(bizBillTypeInfo);
            }
            bizBillType = rs.getString("FBIZBILLTYPE");
            QCBizTypeEnum bizType = null;
            if (!StringUtil.isEmptyString((String)bizBillType)) {
                QCBizBillTypeInfo tempInfo = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectStringPK(bizBillType));
                bizType = tempInfo.getQCBizType();
            }
            QCSourceBillTypeInfo sourceBillType = new QCSourceBillTypeInfo();
            sourceBillType.setId(BOSUuid.read((String)QCSourceBillTypeInfo.getQCBillIDByBizType(bizType)));
            headInfo.setSourceBillType(sourceBillType);
            headInfo.setRejectProcessMode(RejectProcessModeEnum.getEnum((int)rs.getInt("FREJECTPMODE")));
            String baseUnitID = "";
            String unitID = "";
            baseUnitID = rs.getString("FCheckBatchBaseUnitID");
            if (!StringUtil.isEmptyString((String)baseUnitID)) {
                unit = new MeasureUnitInfo();
                unit.setId(BOSUuid.read((String)baseUnitID));
                headInfo.setBaseUnit(unit);
            }
            if (!StringUtil.isEmptyString((String)(unitID = rs.getString("FCheckBatchUnitID")))) {
                unit = new MeasureUnitInfo();
                unit.setId(BOSUuid.read((String)unitID));
                headInfo.setUnit(unit);
            }
            headInfo.setDeliverQty(rs.getBigDecimal("FSendQty"));
            BigDecimal baseQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, unitID, baseUnitID, rs.getBigDecimal("FSendQty"));
            headInfo.setDeliverBaseQty(baseQty);
            headInfo.setValidDate(rs.getDate("FExpDateEnd"));
            headInfo.setQCStrategy(QCStrategyEnum.getEnum((int)rs.getInt("FQCStrategy")));
            headInfo.setSampleHierarchy(SampleHierarchyEnum.getEnum((int)rs.getInt("FSampleHierarchy")));
            StringBuffer sql = new StringBuffer();
            sql.append("select QCSAMPLE.FID,QCSAMPLE.FTotalSampleShares,QCSAMPLE.FSampleQty,");
            sql.append("QCSAMPLE.FUnitID,QCSAMPLE.FBaseUnitID from \n");
            sql.append(" T_QM_QCSample QCSAMPLE where FRequestEntryID ='" + requestEntryID + "' \n");
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            BigDecimal allTotalSampleShares = new BigDecimal("0");
            BigDecimal allSampleQty = new BigDecimal("0");
            String sampleUnitID = "";
            String baseSampleUnitID = "";
            while (rs2.next()) {
                BigDecimal totalSampleShares = rs2.getBigDecimal("FTotalSampleShares");
                BigDecimal sampleQty = rs2.getBigDecimal("FSampleQty");
                sampleUnitID = rs2.getString("FUnitID");
                baseSampleUnitID = rs2.getString("FBaseUnitID");
                allTotalSampleShares = allTotalSampleShares.add(totalSampleShares == null ? new BigDecimal("0") : totalSampleShares);
                allSampleQty = allSampleQty.add(sampleQty == null ? new BigDecimal("0") : sampleQty);
            }
            headInfo.setTotalSampleQty(allTotalSampleShares);
            headInfo.setSampleQty(allSampleQty);
            if (!StringUtil.isEmptyString((String)sampleUnitID)) {
                MeasureUnitInfo sampleUnitInfo = new MeasureUnitInfo();
                sampleUnitInfo.setId(BOSUuid.read((String)sampleUnitID));
                headInfo.setSampleUnit(sampleUnitInfo);
            }
            if (!StringUtil.isEmptyString((String)baseSampleUnitID)) {
                MeasureUnitInfo sampleBaseUnitInfo = new MeasureUnitInfo();
                sampleBaseUnitInfo.setId(BOSUuid.read((String)baseSampleUnitID));
                headInfo.setSampleBaseUnit(sampleBaseUnitInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void addEntryBaseInfoByRowSet(Context ctx, IRowSet rs, QCItemBaseInfo entryInfo) throws BOSException, EASBizException {
        try {
            QCReportCreateHelper.addEntryBaseInfoCommonDataByRowSet(rs, entryInfo);
            if (entryInfo instanceof QCReportEntryInfo) {
                QCReportEntryInfo qCReportEntryInfo = (QCReportEntryInfo)entryInfo;
                qCReportEntryInfo.setSourceBillNumber(rs.getString("FSourceBillNumber"));
                qCReportEntryInfo.setReportEntrySrcType(ReportEntrySrcTypeEnum.getEnum(rs.getString("FSourceBillType")));
                if (qCReportEntryInfo.getParent().getSampleUnit() == null) {
                    String unitID = "";
                    String baseUnitID = "";
                    unitID = rs.getString("FSampleUnitID");
                    if (!StringUtil.isEmptyString((String)unitID)) {
                        MeasureUnitInfo sampleUnitInfo = new MeasureUnitInfo();
                        sampleUnitInfo.setId(BOSUuid.read((String)unitID));
                        qCReportEntryInfo.getParent().setSampleUnit(sampleUnitInfo);
                    }
                    if (!StringUtil.isEmptyString((String)(baseUnitID = rs.getString("FSampleBaseUnitID")))) {
                        MeasureUnitInfo sampleBaseUnitInfo = new MeasureUnitInfo();
                        sampleBaseUnitInfo.setId(BOSUuid.read((String)baseUnitID));
                        qCReportEntryInfo.getParent().setSampleBaseUnit(sampleBaseUnitInfo);
                    }
                }
                if (!StringUtil.isEmptyString((String)rs.getString("FEachSampleUnitID"))) {
                    MeasureUnitInfo eachSampleUnitInfo = new MeasureUnitInfo();
                    eachSampleUnitInfo.setId(BOSUuid.read((String)rs.getString("FEachSampleUnitID")));
                    qCReportEntryInfo.setEachSampleUnit(eachSampleUnitInfo);
                }
                BigDecimal eachSampleQty = rs.getBigDecimal("FEachSampleQty");
                qCReportEntryInfo.setEachSampleQty(eachSampleQty);
                BigDecimal sampleShares = qCReportEntryInfo.getSampleShares();
                if (eachSampleQty != null && sampleShares != null) {
                    qCReportEntryInfo.setSampleQty(eachSampleQty.multiply(sampleShares));
                } else {
                    qCReportEntryInfo.setSampleQty(new BigDecimal("0"));
                }
                qCReportEntryInfo.setMergeItemQty(1);
                qCReportEntryInfo.setSysCheckValue(rs.getString("FSysCheckValue"));
                qCReportEntryInfo.setDefectQty(rs.getBigDecimal("FDefectQty"));
                String qcSourceItemID = rs.getString("FSourceItemEntryID");
                QCReportCreateHelper.setQCReportSampleItem(ctx, qCReportEntryInfo, qcSourceItemID);
            } else if (entryInfo instanceof QCReportAllItemEntryInfo) {
                QCReportAllItemEntryInfo qCReportAllItemEntryInfo = (QCReportAllItemEntryInfo)entryInfo;
                qCReportAllItemEntryInfo.setSourceBillNumber(rs.getString("FSourceBillNumber"));
                qCReportAllItemEntryInfo.setReportEntrySrcType(ReportEntrySrcTypeEnum.getEnum(rs.getString("FSourceBillType")));
                if (qCReportAllItemEntryInfo.getParent().getSampleUnit() == null) {
                    String unitID = "";
                    String baseUnitID = "";
                    unitID = rs.getString("FSampleUnitID");
                    if (!StringUtil.isEmptyString((String)unitID)) {
                        MeasureUnitInfo sampleUnitInfo = new MeasureUnitInfo();
                        sampleUnitInfo.setId(BOSUuid.read((String)unitID));
                        qCReportAllItemEntryInfo.getParent().setSampleUnit(sampleUnitInfo);
                    }
                    if (!StringUtil.isEmptyString((String)(baseUnitID = rs.getString("FSampleBaseUnitID")))) {
                        MeasureUnitInfo sampleBaseUnitInfo = new MeasureUnitInfo();
                        sampleBaseUnitInfo.setId(BOSUuid.read((String)baseUnitID));
                        qCReportAllItemEntryInfo.getParent().setSampleBaseUnit(sampleBaseUnitInfo);
                    }
                }
                qCReportAllItemEntryInfo.setSampleQty(rs.getBigDecimal("FSAMPLEQTY"));
                qCReportAllItemEntryInfo.setMergeItemQty(1);
                qCReportAllItemEntryInfo.setSysCheckValue(rs.getString("FSysCheckValue"));
                qCReportAllItemEntryInfo.setDefectQty(rs.getBigDecimal("FDefectQty"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void setQCReportSampleItem(Context ctx, QCReportEntryInfo qCReportEntryInfo, String sourceItemEntryID) throws BOSException, EASBizException {
        block5: {
            QCReportEntryInfo reportEntriyInfo;
            QCItemSampleEntryCollection itemSEInfos;
            BOSUuid sourceItemEntryBOSID;
            block4: {
                if (sourceItemEntryID == null) {
                    return;
                }
                sourceItemEntryBOSID = BOSUuid.read((String)sourceItemEntryID);
                if (!sourceItemEntryBOSID.getType().equals((Object)new QCBillEntry().getType())) break block4;
                QCBillEntryInfo billEntriyInfo = QCBillEntryFactory.getLocalInstance(ctx).getQCBillEntryInfo((IObjectPK)new ObjectUuidPK(sourceItemEntryID));
                QCItemSampleEntryCollection itemSEInfos2 = billEntriyInfo.getSampleEntry();
                if (itemSEInfos2 == null || itemSEInfos2.size() <= 0) break block5;
                int size = itemSEInfos2.size();
                for (int i = 0; i < size; ++i) {
                    QCItemSampleEntryInfo sISampleEntryInfo = itemSEInfos2.get(i);
                    QCItemSampleEntryInfo qCItemSampleEntryInfo = QCReportCreateHelper.createQCItemSampleEntryInfo(qCReportEntryInfo, sISampleEntryInfo);
                    qCReportEntryInfo.getSampleEntry().add(qCItemSampleEntryInfo);
                }
                break block5;
            }
            if (sourceItemEntryBOSID.getType().equals((Object)new QCReportEntry().getType()) && (itemSEInfos = (reportEntriyInfo = QCReportEntryFactory.getLocalInstance(ctx).getQCReportEntryInfo((IObjectPK)new ObjectUuidPK(sourceItemEntryID))).getSampleEntry()) != null && itemSEInfos.size() > 0) {
                int size = itemSEInfos.size();
                for (int i = 0; i < size; ++i) {
                    QCItemSampleEntryInfo sISampleEntryInfo = itemSEInfos.get(i);
                    QCItemSampleEntryInfo qCItemSampleEntryInfo = QCReportCreateHelper.createQCItemSampleEntryInfo(qCReportEntryInfo, sISampleEntryInfo);
                    qCReportEntryInfo.getSampleEntry().add(qCItemSampleEntryInfo);
                }
            }
        }
    }

    private static QCItemSampleEntryInfo createQCItemSampleEntryInfo(QCReportEntryInfo qCReportEntryInfo, QCItemSampleEntryInfo sISampleEntryInfo) {
        QCItemSampleEntryInfo qCItemSampleEntryInfo = new QCItemSampleEntryInfo();
        qCItemSampleEntryInfo.setId(BOSUuid.create((BOSObjectType)qCItemSampleEntryInfo.getBOSType()));
        qCItemSampleEntryInfo.setRelBillEntry(null);
        qCItemSampleEntryInfo.setRelReportEntry(qCReportEntryInfo);
        qCItemSampleEntryInfo.setEachSampleResult(sISampleEntryInfo.getEachSampleResult());
        qCItemSampleEntryInfo.setEachSampleValue(sISampleEntryInfo.getEachSampleValue());
        qCItemSampleEntryInfo.setDefectQty(sISampleEntryInfo.getDefectQty());
        qCItemSampleEntryInfo.setUnit(sISampleEntryInfo.getUnit());
        qCItemSampleEntryInfo.setSampleNumber(sISampleEntryInfo.getSampleNumber());
        qCItemSampleEntryInfo.setRemark(sISampleEntryInfo.getRemark());
        return qCItemSampleEntryInfo;
    }

    private static void addEntryBaseInfoCommonDataByRowSet(IRowSet rs, QCItemBaseInfo entryInfo) throws SQLException {
        String qcMethodID;
        String qcInstrumentID;
        String qcInstrumentGroupID;
        String qcGroupPersonID;
        QCGroupInfo groupInfo;
        String qcGroupID;
        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        entryInfo.setSourceBillID(rs.getString("FSourceBillID"));
        entryInfo.setSourceBillEntryID(rs.getString("FSourceBillEntryID"));
        entryInfo.setSampleNumber(rs.getString("FSAMPLENUMBER"));
        entryInfo.setSeqNo(rs.getString("FSAMPLESERIAL"));
        String qcItemID = rs.getString("FQCITEMID");
        if (!StringUtil.isEmptyString((String)qcItemID)) {
            QCItemInfo qcitem = new QCItemInfo();
            qcitem.setId(BOSUuid.read((String)qcItemID));
            entryInfo.setQCItem(qcitem);
        }
        entryInfo.setIsMustCheck(rs.getBoolean("FIsCheck"));
        entryInfo.setIsKeyItem(rs.getBoolean("FIsKeyItem"));
        entryInfo.setCheckValue(rs.getString("FCheckValue"));
        entryInfo.setIsBalanceItem(rs.getBoolean("FISBalItem"));
        String unitID = rs.getString("FCheckValueUnitID");
        if (!StringUtil.isEmptyString((String)unitID)) {
            MeasureUnitInfo item = new MeasureUnitInfo();
            item.setId(BOSUuid.read((String)unitID));
            entryInfo.setUnit(item);
        }
        String remark1 = rs.getString("FRemark1");
        entryInfo.setRemark(remark1);
        entryInfo.setCheckResult(QCResultJudgeEnum.getEnum(rs.getInt("FCheckResult")));
        entryInfo.setQCDescription(rs.getString("FCheckDescription"));
        entryInfo.setJudgeType(JudgeTypeEnum.getEnum((int)rs.getInt("FJudgeType")));
        entryInfo.setLowerLimit(QCLowerLimitEnum.getEnum((int)rs.getInt("FLowerLimit")));
        entryInfo.setLower(rs.getBigDecimal("FLower"));
        entryInfo.setUpperLimit(QCUpperLimitEnum.getEnum((int)rs.getInt("FUpperLimit")));
        entryInfo.setUpper(rs.getBigDecimal("FUpper"));
        entryInfo.setDefaultValue(rs.getString("FDefaultValue"));
        String orgID = rs.getString("FQCDGOrgUnitID");
        if (!StringUtil.isEmptyString((String)orgID)) {
            QualityOrgUnitInfo unitInfo = new QualityOrgUnitInfo();
            unitInfo.setId(BOSUuid.read((String)orgID));
            entryInfo.setDelegOrgUnit(unitInfo);
        }
        if (!StringUtil.isEmptyString((String)(qcGroupID = rs.getString("FQCGroupID")))) {
            groupInfo = new QCGroupInfo();
            groupInfo.setId(BOSUuid.read((String)qcGroupID));
            entryInfo.setQCGroup(groupInfo);
        }
        if (!StringUtil.isEmptyString((String)(qcGroupPersonID = rs.getString("FQCGroupPersonID")))) {
            QCGroupPersonInfo groupPersonInfo = new QCGroupPersonInfo();
            groupPersonInfo.setId(BOSUuid.read((String)qcGroupPersonID));
            entryInfo.setChecker(groupPersonInfo);
        }
        if (!StringUtil.isEmptyString((String)(qcInstrumentGroupID = rs.getString("FQCInstrumentGroupID")))) {
            groupInfo = new QCInstrumentGroupInfo();
            groupInfo.setId(BOSUuid.read((String)qcInstrumentGroupID));
            entryInfo.setQCInstrumentGroup((QCInstrumentGroupInfo)groupInfo);
        }
        if (!StringUtil.isEmptyString((String)(qcInstrumentID = rs.getString("FQCInstrumentID")))) {
            QCInstrumentInfo instrumentInfo = new QCInstrumentInfo();
            instrumentInfo.setId(BOSUuid.read((String)qcInstrumentID));
            entryInfo.setQCInstrument(instrumentInfo);
        }
        entryInfo.setCheckStep(rs.getString("FCheckStep"));
        entryInfo.setStandardRequirement(rs.getString("FQCStandardRequirement"));
        entryInfo.setEnums(rs.getString("FEnums"));
        entryInfo.setExpression(rs.getString("FExpression"));
        entryInfo.setAnalysisMethod(QCAnalysisMethodEnum.getEnum((int)rs.getInt("FAnalysisMethod")));
        entryInfo.setQCValueType(QCValueTypeEnum.getEnum((int)rs.getInt("FQCValueType")));
        String qcFrequencyID = rs.getString("FQCFrequencyID");
        if (!StringUtil.isEmptyString((String)qcFrequencyID)) {
            QCFrequencyInfo frequencyInfo = new QCFrequencyInfo();
            frequencyInfo.setId(BOSUuid.read((String)qcFrequencyID));
            entryInfo.setQCFrequency(frequencyInfo);
        }
        if (!StringUtil.isEmptyString((String)(qcMethodID = rs.getString("FQCMethodID")))) {
            QCMethodInfo methodInfo = new QCMethodInfo();
            methodInfo.setId(BOSUuid.read((String)qcMethodID));
            entryInfo.setQCMethod(methodInfo);
        }
        entryInfo.setQCItemAttr(QCItemAttributeEnum.getEnum((int)rs.getInt("FQCItemAttr")));
        String modifyID = rs.getString("FModifyMode");
        if (!StringUtil.isEmptyString((String)modifyID)) {
            QCModifyModeInfo info = new QCModifyModeInfo();
            info.setId(BOSUuid.read((String)modifyID));
            entryInfo.setQCModifyMode(info);
        }
        entryInfo.setDataPrecision(rs.getInt("FDataPrecision"));
        entryInfo.setItemType(ItemTypeEnum.standard);
        entryInfo.setIsRuinous(rs.getBoolean("FISRUINOUS"));
        entryInfo.setQCValueAcquisitionMode(QCValueAcquisitionModeEnum.getEnum((int)rs.getInt("FQCValueAcquisitionMode")));
        entryInfo.setSampleShares(rs.getBigDecimal("FSampleShares"));
        entryInfo.setPassShares(rs.getBigDecimal("FPassShares"));
        entryInfo.setUnPassShares(rs.getBigDecimal("FUnPassShares"));
        String sampleProgramID = rs.getString("FSampleProgramID");
        if (!StringUtil.isEmptyString((String)sampleProgramID)) {
            QCSamplingProgramInfo sampleProgramInfo = new QCSamplingProgramInfo();
            sampleProgramInfo.setId(BOSUuid.read((String)sampleProgramID));
            entryInfo.setSampleProgram(sampleProgramInfo);
        }
        entryInfo.setAcValue(rs.getBigDecimal("FAcValue"));
        entryInfo.setReValue(rs.getBigDecimal("FReValue"));
    }

    public static Map processInfoToErrorMap(Context ctx, String orgID, boolean isCreateByEntry, List idList) throws BOSException, EASBizException {
        HashMap<String, List> errorMap = new HashMap<String, List>();
        for (int i = 0; i < idList.size(); ++i) {
            String key = (String)idList.get(i);
            String[] keys = key.split("<#>");
            String requestBillNumber = keys[0];
            String requestBillEntryNumber = keys[1];
            String requestBillID = keys[2];
            String requestBillEntryID = keys[3];
            String sampleNumber = keys[7];
            String requestKey = QCReportServerHelper.buildReuqestKey(ctx, requestBillNumber, requestBillEntryNumber);
            String checkKey = isCreateByEntry ? requestKey : sampleNumber;
            List errorMsgList = null;
            if (!errorMap.containsKey(checkKey) && (errorMsgList = isCreateByEntry ? QCReportCreateHelper.checkCanCreateReportByRequestEntry(ctx, orgID, requestBillID, requestBillEntryID) : QCReportCreateHelper.checkCanCreateReportBySample(ctx, orgID, sampleNumber, requestBillID, requestBillEntryID)) == null || errorMap.containsKey(checkKey)) continue;
            errorMap.put(checkKey, errorMsgList);
        }
        return errorMap;
    }

    public static void processInfoToCreateList(Context ctx, boolean isCreateByEntry, List createList, List idList, Map errorMap) throws BOSException, EASBizException {
        for (int i = 0; i < idList.size(); ++i) {
            String key = (String)idList.get(i);
            if (QCReportCreateHelper.isKeyLikeErrorKey(ctx, isCreateByEntry, key, errorMap)) continue;
            createList.add(key);
        }
    }

    public static boolean isKeyLikeErrorKey(Context ctx, boolean isCreateByEntry, String key, Map errorMap) throws BOSException, EASBizException {
        String[] keys = key.split("<#>");
        String requestBillNumber = keys[0];
        String requestBillEntryNumber = keys[1];
        String requestKey = QCReportServerHelper.buildReuqestKey(ctx, requestBillNumber, requestBillEntryNumber);
        String sampleNumber = keys[7];
        String checkKey = isCreateByEntry ? requestKey : sampleNumber;
        return errorMap.containsKey(checkKey);
    }

    public static Map processSuccessListToSuccessMap(Context ctx, List successList) throws BOSException, EASBizException {
        if (successList.size() == 0) {
            return new HashMap();
        }
        StringBuffer ids = new StringBuffer();
        ids.append("(''");
        for (int i = 0; i < successList.size(); ++i) {
            if (successList.get(i) == null || successList.get(i).toString().equals("")) continue;
            ids.append(",'" + successList.get(i).toString() + "'");
        }
        ids.append(")");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.FID,a.FNUMBER,a.FRequestNum,a.FRequestEntryNum,b." + QCReportServerHelper.getFieldByLanguage("fname") + " as qualityOrgUnitName" + "   FROM T_QM_QCREPORT a,T_ORG_Quality b WHERE a.FQualityOrgUnitID = b.fid and a.FID IN ");
        sql.append(ids);
        logger.debug((Object)sql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<ObjectStringPK, String> successMap = new HashMap<ObjectStringPK, String>();
        try {
            while (rs.next()) {
                String fid = rs.getString("FID");
                String fnumber = rs.getString("FNUMBER");
                String FRequestNum = rs.getString("FRequestNum");
                String FRequestEntryNum = rs.getString("FRequestEntryNum");
                String qualityOrgUnitName = rs.getString("qualityOrgUnitName");
                successMap.put(new ObjectStringPK(fid), fnumber + "<#>" + FRequestNum + "<&>" + FRequestEntryNum + "<#>" + qualityOrgUnitName);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return successMap;
    }

    private static void fixRptRelWeighEntrys(Context ctx, QCReportInfo rptInfo) throws BOSException {
        String reqEntryId = rptInfo.getRequestEntryID();
        if (QMStringUtils.isEmpty((String)reqEntryId)) {
            return;
        }
    }
}

