/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.qc.QCRejectProcessEntryCollection;
import com.kingdee.eas.qm.qc.QCRejectProcessEntryInfo;
import com.kingdee.eas.qm.qc.QCRejectProcessException;
import com.kingdee.eas.qm.qc.QCRejectProcessInfo;
import com.kingdee.eas.qm.qc.QCRejectProcessRstEntryCollection;
import com.kingdee.eas.qm.qc.QCRejectProcessRstEntryInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QCRejectSubmitVerifyItem
extends AbstractVerifyItem {
    private Context ctx;
    private QCRejectProcessInfo rejectInfo;

    public QCRejectSubmitVerifyItem(Context ctx, QCRejectProcessInfo rejectInfo) {
        this.ctx = ctx;
        this.rejectInfo = rejectInfo;
    }

    public boolean verify() throws EASBizException, BOSException {
        if (null == this.rejectInfo) {
            return false;
        }
        QCRejectProcessEntryCollection rptEntrys = this.rejectInfo.getEntrys();
        if (null == rptEntrys || rptEntrys.size() <= 0) {
            throw new QCRejectProcessException(QCRejectProcessException.RPTENTRYCANNOTNULL);
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        StringBuffer reReasonItemNames = new StringBuffer();
        StringBuffer reReasonItemIDs = new StringBuffer();
        StringBuffer reMasterItemNames = new StringBuffer();
        StringBuffer noMasterItemNames = new StringBuffer();
        for (int i = 0; i < rptEntrys.size(); ++i) {
            QCRejectProcessEntryInfo rptEntry = rptEntrys.get(i);
            String itemID = rptEntry.getQCItem().getId().toString();
            String itemName = rptEntry.getQCItem().getName();
            boolean repeatReason = false;
            if (!map.containsKey(itemID)) {
                Object[] arrValue = null;
                ArrayList<QCRejectProcessEntryInfo> reasonList = new ArrayList<QCRejectProcessEntryInfo>();
                reasonList.add(rptEntry);
                arrValue = rptEntry.isMasterDPReason() ? new Object[]{reasonList, new Integer(1), itemName} : new Object[]{reasonList, new Integer(0), itemName};
                map.put(itemID, arrValue);
            } else {
                Object[] tempValue = (Object[])map.get(itemID);
                ArrayList listValue = (ArrayList)tempValue[0];
                int masterReason = (Integer)tempValue[1];
                if (rptEntry.isMasterDPReason()) {
                    ++masterReason;
                }
                ArrayList tempList = (ArrayList)listValue.clone();
                for (QCRejectProcessEntryInfo temp : listValue) {
                    if (temp.getDpReason().getId().equals((Object)rptEntry.getDpReason().getId())) {
                        repeatReason = true;
                        continue;
                    }
                    tempList.add(rptEntry);
                }
                map.remove(itemID);
                map.put(itemID, new Object[]{tempList, new Integer(masterReason), itemName});
            }
            if (!repeatReason || reReasonItemIDs.indexOf(itemID) > 0) continue;
            reReasonItemNames.append("\uff0c").append(rptEntry.getQCItem().getName());
            reReasonItemIDs.append("\uff0c").append(itemID);
        }
        if (null != reReasonItemNames && reReasonItemNames.length() > 0) {
            throw new QCRejectProcessException(QCRejectProcessException.REASONCANNOTREPEAT, new Object[]{reReasonItemNames.substring(reReasonItemNames.indexOf("\uff0c") + 1)});
        }
        for (Map.Entry entry : map.entrySet()) {
            Object[] arrValue = (Object[])entry.getValue();
            int masterCount = (Integer)arrValue[1];
            if (masterCount < 1) {
                noMasterItemNames.append("\uff0c").append((String)arrValue[2]);
                continue;
            }
            if (masterCount <= 1) continue;
            reMasterItemNames.append("\uff0c").append((String)arrValue[2]);
        }
        if (null != noMasterItemNames && noMasterItemNames.length() > 0) {
            throw new QCRejectProcessException(QCRejectProcessException.MASTERREASONCANNOTNULL, new Object[]{noMasterItemNames.substring(noMasterItemNames.indexOf("\uff0c") + 1)});
        }
        if (null != reMasterItemNames && reMasterItemNames.length() > 0) {
            throw new QCRejectProcessException(QCRejectProcessException.MUSTONEMASTERREASON, new Object[]{reMasterItemNames.substring(reMasterItemNames.indexOf("\uff0c") + 1)});
        }
        QCRejectProcessRstEntryCollection rstEntrys = this.rejectInfo.getRstEntry();
        if (null == rstEntrys || rstEntrys.size() <= 0) {
            throw new QCRejectProcessException(QCRejectProcessException.RSTENTRYCANNOTNULL);
        }
        Iterator iter = rstEntrys.iterator();
        BigDecimal sumRstQty = NumericUtils.toBigDecimal((Object)new String("0.00"));
        StringBuffer qtyError = new StringBuffer();
        int index = 0;
        while (iter.hasNext()) {
            QCRejectProcessRstEntryInfo rstInfo = (QCRejectProcessRstEntryInfo)iter.next();
            MeasureUnitInfo baseUnit = rstInfo.getBaseUnit();
            BigDecimal baseQty = rstInfo.getBaseQty();
            String rstMaterialID = rstInfo.getMaterial().getId().toString();
            if (null == baseUnit) {
                baseUnit = QMUnitAndExchangeUtils.getBaseUnitForServer((Context)this.ctx, (String)rstMaterialID);
            }
            if ((baseQty = QMUnitAndExchangeUtils.getExchangeQtyForServer((Context)this.ctx, (MeasureUnitInfo)rstInfo.getUnit(), (MeasureUnitInfo)baseUnit, (BigDecimal)rstInfo.getQty(), (String)rstMaterialID)).compareTo(NumericUtils.toBigDecimal((Object)new String("0.00"))) <= 0) {
                qtyError.append(",").append(String.valueOf(index + 1));
            }
            sumRstQty = sumRstQty.add(baseQty);
            ++index;
        }
        if (null != qtyError && qtyError.length() > 0) {
            String errorMsg = qtyError.substring(qtyError.indexOf(",") + 1);
            throw new QCRejectProcessException(QCRejectProcessException.RSTQTYMUSTMORETHANZERO, new String[]{errorMsg});
        }
        if (sumRstQty.compareTo(this.rejectInfo.getBaseUnQualitySamQty()) != 0) {
            throw new QCRejectProcessException(QCRejectProcessException.SUMRSTQTYMUSTEQUALUNQTY);
        }
        return true;
    }
}

