/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCStandardFactory;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardProductLineEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardProductLineEntryFactory;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.basedata.SampleHierarchyEnum;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.qc.QCRequestEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestException;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QCRequestSaveServerVerify
extends AbstractVerifyItem {
    private QCRequestInfo info;
    private Context ctx;

    public QCRequestSaveServerVerify(Context ctx, QCRequestInfo info) {
        this.info = info;
        this.ctx = ctx;
    }

    public boolean verify() throws EASBizException, BOSException {
        this.verifyQCStandardAboutWeigh();
        this.verifyMaterialEntry();
        this.verifyItemEntry();
        return true;
    }

    protected void verifyQCStandardAboutWeigh() throws BOSException, EASBizException, QCRequestException {
        if ((this.info.getId() == null || QMStringUtils.isEmpty((String)this.info.getId().toString())) && this.info.isFromBOTP()) {
            return;
        }
    }

    protected void verifyMaterialEntry() throws BOSException, EASBizException {
        Object[] params;
        QCRequestEntryCollection entrys = this.info.getEntrys();
        if (null == entrys || entrys.size() <= 0) {
            return;
        }
        Iterator iter = entrys.iterator();
        String wrongUnitRowIndexs = "";
        StringBuffer wrongPdtLineRowIndexs = new StringBuffer();
        int entryIndex = 0;
        while (iter.hasNext()) {
            QCRequestEntryInfo entryInfo = (QCRequestEntryInfo)iter.next();
            String oql = "select isSerialNumSimple where id = '" + entryInfo.getQcStandard().getId().toString() + "'";
            QCStandardInfo qcStd = QCStandardFactory.getLocalInstance((Context)this.ctx).getQCStandardInfo(oql);
            if (qcStd.isIsSerialNumSimple()) {
                wrongUnitRowIndexs = this.isCanConversedUnit(entryInfo, wrongUnitRowIndexs, ++entryIndex);
            }
            if (!QCBizTypeEnum.pdtProcessCheck.equals((Object)this.info.getQcBizType())) continue;
            this.isDefinePdtLineWP(this.ctx, entryInfo, wrongPdtLineRowIndexs, entryIndex);
        }
        if (!QMStringUtils.isEmpty((String)wrongUnitRowIndexs)) {
            params = new Object[]{wrongUnitRowIndexs.substring(1)};
            throw new QCRequestException(QCRequestException.EACHUNITANDMATERIALISNOTSUITED, params);
        }
        if (wrongPdtLineRowIndexs != null && wrongPdtLineRowIndexs.length() > 0) {
            params = new Object[]{wrongPdtLineRowIndexs.substring(1)};
            throw new QCRequestException(QCRequestException.QCSTDEXPDTLINEORWP, params);
        }
    }

    protected void verifyItemEntry() throws BOSException, EASBizException {
        QCRequestEntryCollection entrys = this.info.getEntrys();
        if (null == entrys || entrys.size() <= 0) {
            return;
        }
        Iterator iter = entrys.iterator();
        int matEntryIndex = 0;
        while (iter.hasNext()) {
            Object[] params;
            QCRequestEntryInfo entryInfo = (QCRequestEntryInfo)iter.next();
            QCRequestQcItemEntryCollection itemCol = entryInfo.getQcItemEntrys();
            QCStandardInfo qcStd = entryInfo.getQcStandard();
            ++matEntryIndex;
            if (qcStd != null && (null == itemCol || itemCol.size() <= 0)) {
                Object[] params2 = new Object[]{String.valueOf(matEntryIndex)};
                throw new QCRequestException(QCRequestException.ITEMENTRYCANNOTBENULL, params2);
            }
            StringBuffer iterativeItemNames = new StringBuffer();
            StringBuffer qtyNullItemEntryIndex = new StringBuffer();
            StringBuffer grpNullItemEntryIndex = new StringBuffer();
            StringBuffer stepNullItemEntryIndex = new StringBuffer();
            ArrayList itemList = new ArrayList();
            Iterator itemIter = itemCol.iterator();
            int itemEntryIndex = 0;
            while (itemIter.hasNext()) {
                QCRequestQcItemEntryInfo itemEntry = (QCRequestQcItemEntryInfo)itemIter.next();
                this.isIterativeItem(itemEntry, itemList, iterativeItemNames);
                this.verifySampleArithmetic(itemEntry, qtyNullItemEntryIndex, ++itemEntryIndex);
                this.verifyItemEntryLimit(itemEntry, matEntryIndex, itemEntryIndex);
                if (QCStrategyEnum.twoStepCheck.equals((Object)entryInfo.getQcStrategy())) {
                    this.verifyQCGroup(itemEntry, grpNullItemEntryIndex, itemEntryIndex);
                }
                if (!SampleHierarchyEnum.step.equals((Object)qcStd.getSampleHierarchy())) continue;
                this.verifyCheckStep(itemEntry, stepNullItemEntryIndex, itemEntryIndex);
            }
            if (null != iterativeItemNames && iterativeItemNames.length() > 0) {
                params = new Object[]{String.valueOf(entryInfo.getSeq()), iterativeItemNames.substring(1)};
                throw new QCRequestException(QCRequestException.ITEMENTRYHASITERATIVEITEM, params);
            }
            if (null != qtyNullItemEntryIndex && qtyNullItemEntryIndex.length() > 0) {
                params = new Object[]{String.valueOf(matEntryIndex), qtyNullItemEntryIndex.substring(1)};
                throw new QCRequestException(QCRequestException.ACORREORSHARESCANNOTBENULL, params);
            }
            if (null != grpNullItemEntryIndex && grpNullItemEntryIndex.length() > 0) {
                params = new Object[]{String.valueOf(matEntryIndex), grpNullItemEntryIndex.substring(1)};
                throw new QCRequestException(QCRequestException.QCGRPCANNNOTNULL, params);
            }
            if (null == stepNullItemEntryIndex || stepNullItemEntryIndex.length() <= 0) continue;
            params = new Object[]{String.valueOf(matEntryIndex), stepNullItemEntryIndex.substring(1)};
            throw new QCRequestException(QCRequestException.CHECKSTEPCANNNOTNULL, params);
        }
    }

    protected void isIterativeItem(QCRequestQcItemEntryInfo itemEntry, List itemList, StringBuffer iterativeItemNames) {
        QCItemInfo qcItem = itemEntry.getQCItem();
        String itemId = qcItem.getId().toString();
        if (itemList.contains(itemId)) {
            iterativeItemNames.append("," + qcItem.getName());
        } else {
            itemList.add(itemId);
        }
    }

    protected void verifyItemEntryLimit(QCRequestQcItemEntryInfo itemEntry, int matEntryIdx, int entrySeq) throws EASBizException {
        QCItemInfo qcItem = itemEntry.getQCItem();
        Object[] params = new Object[]{new Integer(matEntryIdx), new Integer(entrySeq)};
        if (qcItem.getQCValueType() != null && (qcItem.getQCValueType().getValue() == 10 || qcItem.getQCValueType().getValue() == 40) && itemEntry.getLower() != null && itemEntry.getUpper() != null) {
            if (itemEntry.getLower().compareTo(itemEntry.getUpper()) > 0) {
                throw new QCRequestException(QCRequestException.LOWERLIMITMUSTLOWERUPPER, params);
            }
            if (itemEntry.getLower().compareTo(itemEntry.getUpper()) == 0 && (itemEntry.getLowerLimit().equals((Object)QCLowerLimitEnum.greater) || itemEntry.getUpperLimit().equals((Object)QCUpperLimitEnum.less))) {
                throw new QCRequestException(QCRequestException.LOWERLIMITEQUALSUPPER, params);
            }
        }
        if (itemEntry.getLower() != null && (itemEntry.getLowerLimit() == null || QCLowerLimitEnum.isNull.equals((Object)itemEntry.getLowerLimit())) || itemEntry.getLower() == null && itemEntry.getLowerLimit() != null && !QCLowerLimitEnum.isNull.equals((Object)itemEntry.getLowerLimit()) || itemEntry.getUpper() != null && (itemEntry.getUpperLimit() == null || QCUpperLimitEnum.isNull.equals((Object)itemEntry.getUpperLimit())) || itemEntry.getUpper() == null && itemEntry.getUpperLimit() != null && !QCUpperLimitEnum.isNull.equals((Object)itemEntry.getUpperLimit())) {
            throw new QCRequestException(QCRequestException.LOWERANDLIMITMUSTVALUESYN, params);
        }
    }

    protected String isCanConversedUnit(QCRequestEntryInfo entryInfo, String wrongUnitRowIndexs, int entryIndex) throws EASBizException, BOSException {
        MeasureUnitInfo unit = entryInfo.getEachSampleUnit();
        MaterialInfo material = entryInfo.getMaterial();
        if (null != unit && material != null && !QMUnitAndExchangeUtils.isSameMultiUnitGroup((Context)this.ctx, (MaterialInfo)material, (MeasureUnitInfo)unit)) {
            wrongUnitRowIndexs = wrongUnitRowIndexs + "," + entryIndex;
        }
        return wrongUnitRowIndexs;
    }

    protected void isDefinePdtLineWP(Context ctx, QCRequestEntryInfo entryInfo, StringBuffer wrongStdRowIndexs, int entryIndex) throws BOSException {
        ProductLineInfo pdtLine = entryInfo.getPdtLine();
        ProductLineWPEntryInfo lineWP = entryInfo.getPdtLineWP();
        QCStandardInfo qcStd = entryInfo.getQcStandard();
        if (pdtLine == null || qcStd == null) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append(" select id ");
        oql.append(" where parent='" + qcStd.getId().toString() + "'");
        oql.append(" and material.id='" + entryInfo.getMaterial().getId().toString() + "'");
        oql.append(" and qualityOrgUnit.id='" + this.info.getQualityOrgUnit().getId().toString() + "'");
        oql.append(" and ((productLine.id is null)");
        oql.append(" or (productLine.id = '" + pdtLine.getId().toString() + "'");
        oql.append(" and (ProductLineWP.id is null");
        if (lineWP != null) {
            oql.append(" or ProductLineWP.id = '" + lineWP.getId().toString() + "'");
        }
        oql.append(" )))");
        QCStandardProductLineEntryCollection pdtCol = QCStandardProductLineEntryFactory.getLocalInstance((Context)ctx).getQCStandardProductLineEntryCollection(oql.toString());
        if (pdtCol == null || pdtCol.size() == 0) {
            wrongStdRowIndexs.append("," + entryIndex);
        }
    }

    protected void verifySampleArithmetic(QCRequestQcItemEntryInfo itemEntry, StringBuffer itemEntryIndex, int index) {
        if (null != itemEntry.getSampleProgram() && (null == itemEntry.getAcValue() || null == itemEntry.getReValue() || NumericUtils.equalsZero((BigDecimal)itemEntry.getSampleShares()))) {
            itemEntryIndex.append("," + index);
        }
    }

    protected void verifyQCGroup(QCRequestQcItemEntryInfo itemEntry, StringBuffer itemEntryIndex, int index) {
        if (QMEqualsUtils.equals((Object)this.info.getQualityOrgUnit(), (Object)itemEntry.getDelegOrgUnit()) && itemEntry.getQCGroup() == null) {
            itemEntryIndex.append("," + index);
        }
    }

    protected void verifyCheckStep(QCRequestQcItemEntryInfo itemEntry, StringBuffer stepNullIndex, int index) {
        if (QMStringUtils.isEmpty((String)itemEntry.getCheckStep())) {
            stepNullIndex.append("," + index);
        }
    }
}

