/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.qc.QCSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCSampleException;
import com.kingdee.eas.qm.qc.QCSampleInfo;

public class QCSampleAuditSerVerifyItem
extends AbstractVerifyItem {
    private Context ctx;
    private QMCoreBillBaseInfo info;

    public QCSampleAuditSerVerifyItem(Context ctx, QMCoreBillBaseInfo info) {
        this.ctx = ctx;
        this.info = info;
    }

    public boolean verify() throws EASBizException, BOSException {
        QCSampleInfo sampleInfo = (QCSampleInfo)this.info;
        String orgUnitID = sampleInfo.getQualityOrgUnit().getId().toString();
        boolean isSampleQtyAutoSumParamSelected = false;
        try {
            isSampleQtyAutoSumParamSelected = QMParamUtil.paramIsSelected((Context)this.ctx, (String)"QM015", (String)orgUnitID);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        MeasureUnitInfo headerUnit = sampleInfo.getUnit();
        if (!QMEqualsUtils.equals((Object)headerUnit, null) && isSampleQtyAutoSumParamSelected && !QMUnitAndExchangeUtils.isSameMultiUnitGroup((Context)this.ctx, (MaterialInfo)sampleInfo.getMaterial(), (MeasureUnitInfo)headerUnit)) {
            throw new QCSampleException(QCSampleException.HEADER_UNIT_NOT_SAMEMULTI_UNITGROUP);
        }
        QCSampleEntryCollection entryCols = sampleInfo.getEntrys();
        if (entryCols != null && entryCols.size() > 0) {
            for (int i = 0; i < entryCols.size(); ++i) {
                QCSampleEntryInfo entryInfo = entryCols.get(i);
                MeasureUnitInfo entryEachSampleUnit = entryInfo.getUnit();
                if (QMEqualsUtils.equals((Object)entryEachSampleUnit, null) || !isSampleQtyAutoSumParamSelected || QMUnitAndExchangeUtils.isSameMultiUnitGroup((Context)this.ctx, (MaterialInfo)sampleInfo.getMaterial(), (MeasureUnitInfo)entryEachSampleUnit)) continue;
                throw new QCSampleException(QCSampleException.ENTRY_UNIT_NOT_SAMEMULTI_UNITGROUP);
            }
        }
        return true;
    }
}

