/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.verify.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.qc.HQualityHPriceCalException;
import com.kingdee.eas.qm.qc.QCReportException;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportServerHelper;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCReportServerBaseVerifyItem;
import com.kingdee.eas.scm.sm.pur.PurContractEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurContractEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class QCPurReportCalculateBalPriceVerifyItem
extends QCReportServerBaseVerifyItem {
    public QCPurReportCalculateBalPriceVerifyItem(Context ctx, QCReportInfo reportInfo) {
        super(ctx, reportInfo);
    }

    public boolean verify() throws EASBizException, BOSException {
        if (this.reportInfo.isIsSubmitBalPrice()) {
            throw new QCReportException(QCReportException.NOT_CALBAL_SUBMITED);
        }
        this.checkCanCalBalPrice();
        return true;
    }

    private void checkCanCalBalPrice() throws EASBizException, BOSException {
        String requestEntryID = this.reportInfo.getRequestEntryID();
        QCRequestEntryInfo requestEntryInfo = QCRequestEntryFactory.getLocalInstance(this.ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(requestEntryID));
        String sourceEntryID = requestEntryInfo.getSourceBillEntryID();
        PurContractEntryInfo entryInfo = this.getPurContractEntryInfo(sourceEntryID);
        if (entryInfo == null) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"Can't Find PurContractEntryInfo at the calulate verify!"});
        }
        try {
            String purcontEntryID = entryInfo.getId().toString();
            String reportID = this.reportInfo.getId().toString();
            StringBuffer sql = new StringBuffer();
            String f_name = QCReportServerHelper.getFieldByLanguage("ITEM.FNAME");
            sql.append("SELECT ITEMTEMP.ITEMID AS ITEMID, \n");
            sql.append("ITEM.FNUMBER AS ITEMNUMBER, \n");
            sql.append(" " + f_name + " AS ITEMNAME, \n");
            sql.append("SUM(BILLTYPE)AS BILLTYPE, COUNT(*) AS COUNT \n");
            sql.append("FROM ( \n");
            sql.append("SELECT DISTINCT CTS.FQCITEMID AS ITEMID,1 AS BILLTYPE \n");
            sql.append("FROM T_SM_PURCONTRACTQCITEMSNORTH CTS \n");
            sql.append("WHERE CTS.FPARENTID = '" + purcontEntryID + "' \n");
            sql.append("AND CTS.FISSETTLEMENTITEM = 1 \n");
            sql.append("UNION ALL \n");
            sql.append("SELECT DISTINCT REPORTENTRY.FQCITEMID AS ITEMID, \n");
            sql.append("3 AS BILLTYPE \n");
            sql.append("FROM T_QM_QCREPORTENTRY REPORTENTRY  \n");
            sql.append("WHERE REPORTENTRY.FPARENTID = '" + reportID + "' \n");
            sql.append("AND REPORTENTRY.FISBALANCEITEM = 1 \n");
            sql.append(" ) ITEMTEMP \n");
            sql.append(" LEFT JOIN T_QM_QCITEM ITEM  \n");
            sql.append("ON ITEMTEMP.ITEMID = ITEM.FID \n");
            sql.append("GROUP BY ITEMTEMP.ITEMID,ITEM.FNUMBER," + f_name + " \n");
            sql.append("HAVING  COUNT(*) =1 \n");
            sql.append(" \n");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                int billType = rs.getInt("BILLTYPE");
                String qcItemNumber = rs.getString("ITEMNUMBER");
                String qcItemName = rs.getString("ITEMNAME");
                if (billType < 3) {
                    throw new HQualityHPriceCalException(HQualityHPriceCalException.ITEM_NOT_FULL_BG, new Object[]{qcItemNumber + " " + qcItemName});
                }
                throw new HQualityHPriceCalException(HQualityHPriceCalException.ITEM_NOT_FULL_HT, new Object[]{qcItemNumber + " " + qcItemName});
            }
            sql = new StringBuffer();
            sql.append("SELECT ITEMID,ITEMNUMBER,ITEMNAME,COUNT(TYPE) \n");
            sql.append("FROM ( \n");
            sql.append("SELECT DISTINCT CTS.FQCITEM AS ITEMID, \n");
            sql.append("ITEM.FNUMBER AS ITEMNUMBER, \n");
            sql.append("ITEM.FNAME_L2 AS ITEMNAME, \n");
            sql.append("CTS.FSETTLEMENTPRICETYPE AS TYPE \n");
            sql.append("FROM T_SM_PURCONTRACTSETTLETERMSNOR CTS \n");
            sql.append("LEFT JOIN T_QM_QCITEM ITEM  \n");
            sql.append("ON CTS.FQCITEM = ITEM.FID \n");
            sql.append("WHERE CTS.FPARENTID = '" + purcontEntryID + "' \n");
            sql.append(")TEMP \n");
            sql.append("GROUP BY TEMP.ITEMID,TEMP.ITEMNUMBER,TEMP.ITEMNAME \n");
            sql.append("HAVING COUNT(TYPE) > 1 \n");
            sql.append(" \n");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                String qcItemNumber = rs.getString("ITEMNUMBER");
                String qcItemName = rs.getString("ITEMNAME");
                throw new HQualityHPriceCalException(HQualityHPriceCalException.CALTYPEERROR, new String[]{qcItemNumber + " " + qcItemName});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private PurContractEntryInfo getPurContractEntryInfo(String reciveBillEntryID) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String sql = "select oe.fsourcebillentryid purcontractentryid  from t_sm_purorderentry oe, t_im_purreceivalentry re where re.fpurorderentryid =oe.fid and re.fid='" + reciveBillEntryID + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        ev.setFilter(filter);
        PurContractEntryCollection coll = PurContractEntryFactory.getLocalInstance((Context)this.ctx).getPurContractEntryCollection(ev);
        if (coll.size() == 0) {
            return null;
        }
        if (coll.size() == 1) {
            return coll.get(0);
        }
        throw new QMException(QMException.BLANK, (Object[])new String[]{"Find more PurContractEntryInfo at the calulate verify!"});
    }
}

