/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.verify.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.sfc.CompletionReport;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.mm.sfc.DisTaskDispatchEntryInfo;
import com.kingdee.eas.mm.sfc.SourceBillTypeEnum;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.RejectProcessModeEnum;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.qc.QCReportException;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCReportServerBaseVerifyItem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class QCReportSubmitResultServerVerifyItem
extends QCReportServerBaseVerifyItem {
    public QCReportSubmitResultServerVerifyItem(Context ctx, QCReportInfo reportInfo) {
        super(ctx, reportInfo);
    }

    public boolean verify() throws EASBizException, BOSException {
        String sourceBillId;
        if (this.reportInfo == null) {
            throw new BOSException("Error ReportInfo!");
        }
        if (this.reportInfo.getId() == null || this.reportInfo.getBillStatus() != QMBillBaseStatusEnum.Audit) {
            throw new QCReportException(QCReportException.SUBMITRESULT_NOAUDIT);
        }
        if (this.reportInfo.isSubmitResult()) {
            throw new QCReportException(QCReportException.SUBMITRESULT_SUBMITED);
        }
        String requestID = this.reportInfo.getRequestID();
        QCRequestInfo requestInfo = null;
        if (!StringUtil.isEmptyString((String)requestID)) {
            boolean isCanSubmitResult;
            requestInfo = QCRequestFactory.getLocalInstance(this.ctx).getQCRequestInfo((IObjectPK)new ObjectStringPK(requestID));
            boolean bl = requestInfo.getSourceBillType() == null ? false : (isCanSubmitResult = "UzuilRaMQXKxCKhSpl2dyubqiQE=".equals(requestInfo.getSourceBillType().getId().toString()) ? true : requestInfo.getSourceBillType().isFromOtherSubSystem());
            if (!isCanSubmitResult) {
                throw new QCReportException(QCReportException.SUBMITRESULT_CANSUBMITRESULT);
            }
        }
        if (this.reportInfo.getBillType().getQCBizType() == QCBizTypeEnum.pdtDiscreteCheck && (sourceBillId = requestInfo.getSourceBillId()) != null && BOSUuid.read((String)sourceBillId).getType().equals((Object)new CompletionReport().getType())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("sourceBillType1"));
            sic.add(new SelectorItemInfo("dispWorkProcess.id"));
            sic.add(new SelectorItemInfo("dispWorkProcess.name"));
            sic.add(new SelectorItemInfo("dispWorkProcess.number"));
            sic.add(new SelectorItemInfo("dispWorkProcess.isCheckPoint"));
            sic.add(new SelectorItemInfo("process.id"));
            sic.add(new SelectorItemInfo("process.name"));
            sic.add(new SelectorItemInfo("process.number"));
            sic.add(new SelectorItemInfo("process.isCheckPoint"));
            CompletionReportInfo completionReportInfo = CompletionReportFactory.getLocalInstance((Context)this.ctx).getCompletionReportInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            boolean isCheckPoint = false;
            if (SourceBillTypeEnum.DISPATCHWORKBILL.equals((Object)completionReportInfo.getSourceBillType1())) {
                DisTaskDispatchEntryInfo ddeInfo = completionReportInfo.getDispWorkProcess();
                if (ddeInfo != null) {
                    isCheckPoint = ddeInfo.isIsCheckPoint();
                }
            } else {
                ManufactureOrderTechnicsInfo motInfo = completionReportInfo.getProcess();
                if (motInfo != null) {
                    isCheckPoint = motInfo.isIsCheckPoint();
                }
            }
            if (!isCheckPoint) {
                throw new QCReportException(QCReportException.SUBMITRESULT_NOTCHECKOUT);
            }
        }
        if (this.reportInfo.getBillType().isIsEnableMRB() && this.reportInfo.getRejectProcessMode() == RejectProcessModeEnum.inspectionReport && this.reportInfo.getUnPassQty().signum() == 1 && this.reportInfo.getNCPPREntries().size() == 0) {
            throw new QCReportException(QCReportException.SUBMITRESULT_ISMRBREWRITE);
        }
        return true;
    }

    public static boolean verifyIsRtnRst(Context ctx, String requestEntryID) throws BOSException, SQLDataException {
        boolean rtnFlag = false;
        StringBuffer sql = new StringBuffer(0);
        sql.append(" select entry.CFIsHQHPRICE as isHQHPrice, \n");
        sql.append(" requestentry.FIsReturnResult isReturnResult \n");
        sql.append(" from t_sm_purcontractentry as entry \n");
        sql.append(" right outer join T_SM_PURORDERENTRY as orderentry \n");
        sql.append(" on orderentry.FSOURCEBILLENTRYID = entry.fid \n");
        sql.append(" right join T_IM_PURRECEIVALENTRY as recentry \n");
        sql.append(" on recentry.FpurorderentryID = orderentry.fid \n");
        sql.append(" right outer join T_IM_PurReceivalBill as rec \n");
        sql.append(" on recentry.fparentid = rec.fid \n");
        sql.append(" right outer join t_qm_qcrequestentry as requestentry \n");
        sql.append(" on requestentry.fsourcebillentryid = recentry.fid \n");
        sql.append(" where requestentry.FID = ?\n");
        Object[] params = new Object[]{requestEntryID};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rs.next()) {
                boolean isHQHPrice = rs.getBoolean("isHQHPrice");
                boolean isReturnResult = rs.getBoolean("isReturnResult");
                rtnFlag = !isReturnResult || isReturnResult && isHQHPrice;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rtnFlag;
    }
}

