/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;

public class QMUnitConvertHelper {
    public static BigDecimal convertQtyByUnit(Context ctx, String materialID, String srcUnitID, String destUnitID, BigDecimal qty) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID)) {
            return qty;
        }
        if (StringUtils.isEmpty((String)srcUnitID) || StringUtils.isEmpty((String)destUnitID) || qty == null) {
            return null;
        }
        BigDecimal targetQty = null;
        if (srcUnitID.equals(destUnitID)) {
            return qty;
        }
        IMultiMeasureUnit multiUnit = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo srcMultiUnitInfo = multiUnit.getMultiUnit(materialID, srcUnitID);
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(materialID, destUnitID);
        if (srcMultiUnitInfo != null && desMultiUnitInfo != null) {
            BigDecimal baseExchangeRate1 = srcMultiUnitInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = desMultiUnitInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, desMultiUnitInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public static HashMap getMultiMeasureUnit(Context ctx, String materialID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID)) {
            return null;
        }
        IMultiMeasureUnit iMultiUnit = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitCollection multiUnits = iMultiUnit.getDataByMaterial(materialID);
        if (multiUnits != null) {
            HashMap<String, MultiMeasureUnitInfo> map = new HashMap<String, MultiMeasureUnitInfo>();
            for (int i = 0; i < multiUnits.size(); ++i) {
                MultiMeasureUnitInfo multiUnit = multiUnits.get(i);
                if (multiUnit == null) continue;
                map.put(multiUnit.getMeasureUnit().getId().toString(), multiUnit);
            }
            return map;
        }
        return null;
    }

    public static BigDecimal convertQtyFromMap(HashMap unitMap, String srcUnitID, String destUnitID, BigDecimal qty, boolean isUsePrecision) {
        if (unitMap == null) {
            return qty;
        }
        if (StringUtils.isEmpty((String)srcUnitID) || StringUtils.isEmpty((String)destUnitID) || qty == null) {
            return null;
        }
        BigDecimal targetQty = null;
        if (srcUnitID.equals(destUnitID)) {
            return qty;
        }
        MultiMeasureUnitInfo srcMultiUnitInfo = (MultiMeasureUnitInfo)unitMap.get(srcUnitID);
        MultiMeasureUnitInfo desMultiUnitInfo = (MultiMeasureUnitInfo)unitMap.get(destUnitID);
        if (srcMultiUnitInfo != null && desMultiUnitInfo != null) {
            BigDecimal baseExchangeRate1 = srcMultiUnitInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = desMultiUnitInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            int precision = 8;
            if (isUsePrecision) {
                precision = desMultiUnitInfo.getQtyPrecision();
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, precision, 4);
        }
        return targetQty;
    }
}

