/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.openapi.policy;

import com.kingdee.eas.scm.framework.openapi.policy.RequestPolicy;

public class ClientPolicy
extends RequestPolicy {
    private static Integer DEFAULT_HTTP_PORT = 80;
    private static Integer DEFAULT_HTTPS_PORT = 443;
    private static final ClientPolicy CBU_POLICY = new ClientPolicy("localhost");
    private String serverHost;
    private int httpPort = DEFAULT_HTTP_PORT;
    private boolean isProxy = false;
    private String proxyHost;
    private int proxyPort;
    private int httpsPort = DEFAULT_HTTPS_PORT;
    private int defaultVersion = 1;
    private String enterpriseId;

    public static ClientPolicy getDefaultPolicy() {
        return CBU_POLICY.clone();
    }

    @Override
    public ClientPolicy clone() {
        ClientPolicy newObj = (ClientPolicy)super.clone();
        newObj.httpPort = this.httpPort;
        newObj.httpsPort = this.httpsPort;
        newObj.defaultVersion = this.defaultVersion;
        return newObj;
    }

    @Override
    protected ClientPolicy newPolicy() {
        return new ClientPolicy(this.serverHost);
    }

    public ClientPolicy(String serverHost) {
        if (serverHost == null || serverHost.length() < 1) {
            throw new IllegalArgumentException("serverHost can not be empty");
        }
        this.serverHost = serverHost;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public ClientPolicy setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public ClientPolicy setHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public ClientPolicy setProxy(boolean isProxy) {
        this.isProxy = isProxy;
        return this;
    }

    public ClientPolicy setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public ClientPolicy setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public int getDefaultVersion() {
        return this.defaultVersion;
    }

    public ClientPolicy setDefaultVersion(int defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    public ClientPolicy setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
        return this;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }
}

