/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.scm.sm.pur.b2b.MaterialPermissionInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.AbstractMaterialPermissionControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MaterialPermissionControllerBean
extends AbstractMaterialPermissionControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected void _save(Context ctx, Map updateMap) throws BOSException {
        String insertSQL = "insert into T_B2B_MaterialPermission(FID, FMaterialId, FIsAllowed, FIsAllowedDirect) values(?, ?, ?, ?)";
        String updateSQL = "update T_B2B_MaterialPermission set FIsAllowed = ?, FIsAllowedDirect = ? where FMaterialId = ?";
        if (updateMap == null || updateMap.size() == 0) {
            return;
        }
        boolean hasInsert = false;
        boolean hasUpdate = false;
        Connection conn = null;
        PreparedStatement insertPS = null;
        PreparedStatement updatePS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            insertPS = conn.prepareStatement("insert into T_B2B_MaterialPermission(FID, FMaterialId, FIsAllowed, FIsAllowedDirect) values(?, ?, ?, ?)");
            updatePS = conn.prepareStatement("update T_B2B_MaterialPermission set FIsAllowed = ?, FIsAllowedDirect = ? where FMaterialId = ?");
            Iterator it = updateMap.values().iterator();
            MaterialPermissionInfo info = null;
            while (it.hasNext()) {
                info = (MaterialPermissionInfo)it.next();
                if (info.getId() == null) {
                    info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                    insertPS.setString(1, info.getId().toString());
                    insertPS.setString(2, info.getMaterialId());
                    insertPS.setBoolean(3, info.isIsAllowed());
                    insertPS.setBoolean(4, info.isIsAllowedDirect());
                    insertPS.addBatch();
                    hasInsert = true;
                    continue;
                }
                updatePS.setBoolean(1, info.isIsAllowed());
                updatePS.setBoolean(2, info.isIsAllowedDirect());
                updatePS.setString(3, info.getMaterialId());
                updatePS.addBatch();
                hasUpdate = true;
            }
            if (hasInsert) {
                insertPS.executeBatch();
            }
            if (hasUpdate) {
                updatePS.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertPS);
                SQLUtils.cleanup(updatePS, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertPS);
        SQLUtils.cleanup((Statement)updatePS, (Connection)conn);
    }

    @Override
    protected List _checkPermission(Context ctx, List materialList) throws BOSException {
        ArrayList result = new ArrayList(materialList);
        if (materialList == null || materialList.size() == 0) {
            return result;
        }
        StringBuffer idFilter = new StringBuffer();
        for (int i = 0; i < materialList.size(); ++i) {
            if (i > 0) {
                idFilter.append(",");
            }
            idFilter.append("'").append(materialList.get(i)).append("'");
        }
        String selectSQL = "select FMaterialId, FIsAllowed from T_B2B_MaterialPermission where FMaterialId in (" + idFilter.toString() + ") and FIsAllowed = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        try {
            while (rs.next()) {
                result.remove(rs.getString("FMaterialId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return result;
    }
}

