/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderExpenseEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.ISupplier4AliFacade;
import com.kingdee.eas.scm.sm.pur.b2b.Supplier4AliFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.AbstractPurB2BFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurCloudServiceHelper;
import com.kingdee.eas.scm.sm.pur.b2b.app.SupplierHandlerUtil;
import com.kingdee.eas.scm.sm.pur.b2b.model.BuyOfferInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.ObjectCollection;
import com.kingdee.eas.scm.sm.pur.b2b.model.OrderEntryModel;
import com.kingdee.eas.scm.sm.pur.b2b.model.OrderModelInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationItem;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierMapTypeEnum;
import com.kingdee.eas.scm.sm.pur.b2b.util.JSONUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class PurB2BFacadeControllerBean
extends AbstractPurB2BFacadeControllerBean {
    private static final long serialVersionUID = -8881711785467748113L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.b2b.app.PurB2BFacadeControllerBean");
    private static final BigDecimal BIGDECIMAL_100 = new BigDecimal("100.00");

    @Override
    protected BuyOfferInfo _getBuyOfferByPrId(Context ctx, String netBuyOfferId, String companyId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)netBuyOfferId)) {
            throw new BOSException("buyOfferId is null!");
        }
        if (StringUtils.isEmpty((String)companyId)) {
            throw new BOSException("company is null!");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("buyOfferId", netBuyOfferId);
        String result = PurCloudServiceHelper.send(ctx, companyId, "buyoffer.getBuyOfferInfoById", params);
        try {
            return JSONUtil.json2BuyOffInfo(result, true);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected QuotationInfo _getQuotationInfoById(Context ctx, String quotationId, String companyId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)quotationId)) {
            throw new BOSException("quotationId is null!");
        }
        if (StringUtils.isEmpty((String)companyId)) {
            throw new BOSException("company is null!");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("quotationId", quotationId);
        String result = PurCloudServiceHelper.send(ctx, companyId, "quotation.getQuotationInfoById", params);
        try {
            return JSONUtil.json2QuotationInfo(new JSONObject(result), true);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected QuotationInfo[] _getListedByQuotationId(Context ctx, String buyofferId, String companyId, List purIdList) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)buyofferId)) {
            throw new BOSException("id is null!");
        }
        if (StringUtils.isEmpty((String)companyId)) {
            throw new BOSException("company is null!");
        }
        long t1 = System.currentTimeMillis();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("buyofferId", buyofferId);
        String result = PurCloudServiceHelper.send(ctx, companyId, "quotation.getQuotationListByBuyOffId", params);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("quotation.getQuotationListByBuyOffId " + (t2 - t1) + "ms"));
        ObjectCollection<QuotationInfo> list = null;
        try {
            list = JSONUtil.json2QuotationList(result);
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        long t3 = System.currentTimeMillis();
        logger.debug((Object)("JSONUtil.json2QuotationList " + (t3 - t2) + "ms"));
        if (list == null) {
            return null;
        }
        List<QuotationInfo> ret = list.getItemsList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("companyOrgUnitId", companyId);
        paramMap.put("purchaseOrgUnitIdList", purIdList);
        ISupplier4AliFacade supplier4AliService = Supplier4AliFacadeFactory.getLocalInstance(ctx);
        for (QuotationInfo info : ret) {
            paramMap.put("supplierMemberId", info.getSupplierMemberId());
            long t4 = System.currentTimeMillis();
            SupplierMapTypeEnum mapType = supplier4AliService.checkSupplierData(paramMap);
            long t5 = System.currentTimeMillis();
            logger.debug((Object)("supplier4AliService.checkSupplierData " + (t5 - t4) + "ms"));
            info.setSupplierMapType(mapType);
        }
        return ret.toArray(new QuotationInfo[0]);
    }

    @Override
    protected OrderModelInfo _getWebOrderModelById(Context ctx, String compnayId, String orderId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orderId)) {
            throw new BOSException("id is null!");
        }
        if (StringUtils.isEmpty((String)compnayId)) {
            throw new BOSException("company is null!");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", orderId);
        params.put("needOrderEntries", true);
        params.put("needInvoiceInfo", false);
        params.put("needOrderMemoList", false);
        params.put("needLogisticsOrderList", false);
        params.put("tradeType", true);
        String result = PurCloudServiceHelper.send(ctx, compnayId, "order.getOrderModelInfoById", params);
        try {
            return JSONUtil.json2OrderModelInfo(result, true);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected BOSUuid _addPurOrderByQuotation(Context ctx, QuotationInfo quotationInfo, String botpName) throws BOSException, EASBizException {
        QuotationItem item;
        if (quotationInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("1000001", "\u4e0b\u5355\u5931\u8d25\uff0c\u62a5\u4ef7\u5355\u4fe1\u606f\u4e3a\u7a7a"));
        }
        HashMap<String, QuotationItem> prItemId2PriceMap = new HashMap<String, QuotationItem>();
        ObjectCollection<QuotationItem> items = quotationInfo.getSupplyNoteItems();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            item = items.getItem(i);
            prItemId2PriceMap.put(item.getPrItemId(), item);
        }
        String buyOfferId = quotationInfo.getBuyOfferId();
        PurRequestEntryCollection purReqEntries = PurRequestEntryFactory.getLocalInstance((Context)ctx).getPurRequestEntryCollection(this.getEntityViewByBuyOffer(buyOfferId));
        if (purReqEntries == null || purReqEntries.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1000002", "\u4e0b\u5355\u5931\u8d25\uff0c\u672a\u53d6\u5230\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f"));
        }
        ArrayList<String> purReqIdList = new ArrayList<String>();
        ArrayList<String> purReqentryList = new ArrayList<String>();
        PurRequestEntryInfo purReqEntry = null;
        for (int i = 0; i < purReqEntries.size(); ++i) {
            purReqEntry = purReqEntries.get(i);
            if (!purReqIdList.contains(purReqEntry.getParent().getId().toString())) {
                purReqIdList.add(purReqEntry.getParent().getId().toString());
            }
            purReqentryList.add(purReqEntry.getId().toString());
        }
        if (botpName == null) {
            throw new EASBizException(new NumericExceptionSubItem("1000007", "\u4e0b\u5355\u5931\u8d25\uff0c\u6ca1\u6709\u914d\u7f6e\u7533\u8bf7\u5355\u5230\u8ba2\u5355\u7684BOTP\u8f6c\u6362\u89c4\u5219\u53c2\u6570"));
        }
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("1000003", "\u4e0b\u5355\u5931\u8d25\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u8f6c\u6362\u89c4\u5219\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new EASBizException(new NumericExceptionSubItem("1000004", "\u4e0b\u5355\u5931\u8d25\uff0c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u672a\u542f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        SelectorItemCollection botpSelectors = SCMSelectorFactory.getPurRequestSelector((boolean)true);
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(purReqIdList.toArray(new String[0]), new String[]{"entries"}, purReqentryList, botpSelectors, "3171BFAD", (IObjectPK)new ObjectUuidPK(botMappingInfo.getId()), "25428F2E");
        IObjectCollection bills = transformResult.getBills();
        if (bills.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("1000000", "\u4e0b\u5355\u5931\u8d25\uff0cbotp\u8f6c\u6362\u540e\u8ba2\u5355\u6570\u636e\u4f4d\u7a7a"));
        }
        String easSupplierId = SupplierHandlerUtil.getSupplierIDByMemberID(ctx, quotationInfo.getSupplierMemberId());
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setId(BOSUuid.read((String)easSupplierId));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"726f145b-0107-1000-e000-0227c0a81235676394A1", CompareType.EQUALS));
        view.setFilter(filter);
        ExpenseTypeInfo expenseTypeInfo = new ExpenseTypeInfo();
        ExpenseTypeCollection expenseTypecol = ExpenseTypeFactory.getLocalInstance((Context)ctx).getExpenseTypeCollection(view);
        if (expenseTypecol != null && expenseTypecol.size() > 0) {
            expenseTypeInfo = expenseTypecol.get(0);
        } else {
            expenseTypeInfo.setId(BOSUuid.read((String)"726f145b-0107-1000-e000-0227c0a81235676394A1"));
        }
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
        String taxRate = null;
        int size2 = bills.size();
        for (int i = 0; i < size2; ++i) {
            PurOrderEntryInfo entry;
            PurOrderInfo order = (PurOrderInfo)bills.getObject(i);
            PurOrderEntryCollection entrys = order.getEntries();
            boolean isInTax = false;
            int len = entrys.size();
            for (int j = 0; j < len; ++j) {
                entry = entrys.get(j);
                String prItemId = entry.getSourceBillEntryId();
                BigDecimal price = new BigDecimal(0);
                item = (QuotationItem)prItemId2PriceMap.get(prItemId);
                if (item != null && item.getPrice() != null) {
                    price = new BigDecimal(item.getPrice()).divide(BIGDECIMAL_100, 2, RoundingMode.HALF_UP);
                }
                BigDecimal qty = new BigDecimal(item.getAmount()).setScale(2, RoundingMode.HALF_UP);
                taxRate = item.getTaxRate();
                if (item.isIncludeTax()) {
                    isInTax = true;
                    entry.setTaxPrice(price);
                    entry.setTaxRate(new BigDecimal(taxRate));
                } else {
                    entry.setPrice(price);
                }
                entry.setQty(qty);
                entry.put("netBuyOfferId", (Object)quotationInfo.getBuyOfferId());
                entry.put("netQuotationItemId", (Object)String.valueOf(item.getId()));
                entry.put("netQuotationId", (Object)String.valueOf(quotationInfo.getId()));
            }
            BigDecimal freight = new BigDecimal(0);
            if (quotationInfo != null && entrys.size() > 0) {
                freight = new BigDecimal(quotationInfo.getFreight()).divide(BIGDECIMAL_100, 2, RoundingMode.HALF_UP);
                entry = entrys.get(0);
                PurOrderExpenseEntryInfo expenseInfo = new PurOrderExpenseEntryInfo();
                expenseInfo.setExpenseAmount(freight);
                expenseInfo.setCurrency(order.getCurrency());
                expenseInfo.setExchangeRate(order.getExchangeRate());
                expenseInfo.setTaxRate(entry.getTaxRate());
                expenseInfo.setTax(entry.getTaxRate().multiply(freight).setScale(2));
                expenseInfo.setUnitExpense(freight.divide(entry.getQty(), 2, RoundingMode.HALF_UP));
                expenseInfo.setPurOrderEntry(entry);
                expenseInfo.setExpenseItem(expenseTypeInfo);
                entry.getEntries().add(expenseInfo);
            }
            order.setIsInTax(isInTax);
            order.setSupplier(supplierInfo);
            order.setBoolean("isNetOrder", true);
            iPurOrder.handleAfterTransform("SAVE", (IObjectValue)order);
            iPurOrder.save((CoreBaseInfo)order);
            iPurOrder.saveRelations((CoreBillBaseInfo)order, transformResult.getBOTRelationCollection());
        }
        return ((PurOrderInfo)bills.getObject(0)).getId();
    }

    @Override
    protected boolean _isExpire(Context ctx, BuyOfferInfo buyInfo) throws BOSException {
        Date expire = buyInfo.getGmtQuotationExpire();
        return expire.getTime() <= System.currentTimeMillis();
    }

    private EntityViewInfo getEntityViewByBuyOffer(String buyOfferId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("netBuyOfferItemId", (Object)buyOfferId, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.id");
        sic.add("parent.companyOrgUnit");
        sic.add("parent.baseStatus");
        sic.add("id");
        sic.add("purchaseOrgUnit");
        sic.add(new SelectorItemInfo("netBuyOfferItemId"));
        viewInfo.setSelector(sic);
        return viewInfo;
    }

    @Override
    protected QuotationInfo[] _getQuotationListByBuyIdsFromEAS(Context ctx, List buyOfferIds) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected BOSUuid _addPurOrderByWebOrder(Context ctx, OrderModelInfo webOrderInfo, String quotationId, String companyId) throws BOSException, EASBizException {
        QuotationItem quoItem;
        QuotationInfo quotationInfo = this._getQuotationInfoById(ctx, quotationId, companyId);
        if (quotationInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("1000001", "\u4e0b\u5355\u5931\u8d25\uff0c\u62a5\u4ef7\u5355\u4fe1\u606f\u4e3a\u7a7a"));
        }
        HashMap<String, QuotationItem> prItemQuoMap = new HashMap<String, QuotationItem>();
        HashMap<String, OrderEntryModel> prItemWebOrder = new HashMap<String, OrderEntryModel>();
        ObjectCollection<QuotationItem> quoItems = quotationInfo.getSupplyNoteItems();
        ObjectCollection<OrderEntryModel> webOrderItems = webOrderInfo.getOrderEntries();
        int size = quoItems.size();
        for (int i = 0; i < size; ++i) {
            quoItem = quoItems.getItem(i);
            prItemQuoMap.put(quoItem.getPrItemId(), quoItem);
        }
        for (int i = 0; i < webOrderItems.size(); ++i) {
            OrderEntryModel webOrderItem = webOrderItems.getItem(i);
            prItemWebOrder.put(webOrderItem.getPrItemId(), webOrderItem);
        }
        String buyOfferId = quotationInfo.getBuyOfferId();
        PurRequestEntryCollection purReqEntries = PurRequestEntryFactory.getLocalInstance((Context)ctx).getPurRequestEntryCollection(this.getEntityViewByBuyOffer(buyOfferId));
        if (purReqEntries == null || purReqEntries.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1000002", "\u4e0b\u5355\u5931\u8d25\uff0c\u672a\u53d6\u5230\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f"));
        }
        ArrayList<String> purReqIdList = new ArrayList<String>();
        ArrayList<String> purReqentryList = new ArrayList<String>();
        PurRequestEntryInfo purReqEntry = null;
        for (int i = 0; i < purReqEntries.size(); ++i) {
            purReqEntry = purReqEntries.get(i);
            if (!purReqIdList.contains(purReqEntry.getParent().getId().toString())) {
                purReqIdList.add(purReqEntry.getParent().getId().toString());
            }
            purReqentryList.add(purReqEntry.getId().toString());
        }
        String botpName = "PUR001";
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("1000003", "\u4e0b\u5355\u5931\u8d25\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u8f6c\u6362\u89c4\u5219\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new EASBizException(new NumericExceptionSubItem("1000004", "\u4e0b\u5355\u5931\u8d25\uff0c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u672a\u542f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        SelectorItemCollection botpSelectors = SCMSelectorFactory.getPurRequestSelector((boolean)true);
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(purReqIdList.toArray(new String[0]), new String[]{"entries"}, purReqentryList, botpSelectors, "3171BFAD", (IObjectPK)new ObjectUuidPK(botMappingInfo.getId()), "25428F2E");
        IObjectCollection bills = transformResult.getBills();
        if (bills.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("1000000", "\u4e0b\u5355\u5931\u8d25\uff0cbotp\u8f6c\u6362\u540e\u8ba2\u5355\u6570\u636e\u4f4d\u7a7a"));
        }
        String easSupplierId = SupplierHandlerUtil.getSupplierIDByMemberID(ctx, quotationInfo.getSupplierMemberId());
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setId(BOSUuid.read((String)easSupplierId));
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
        String taxRate = null;
        int size2 = bills.size();
        for (int i = 0; i < size2; ++i) {
            PurOrderInfo order = (PurOrderInfo)bills.getObject(i);
            PurOrderEntryCollection entrys = order.getEntries();
            boolean isInTax = false;
            int len = entrys.size();
            for (int j = 0; j < len; ++j) {
                PurOrderEntryInfo entry = entrys.get(j);
                String prItemId = entry.getSourceBillEntryId();
                quoItem = (QuotationItem)prItemQuoMap.get(prItemId);
                OrderEntryModel webOrderItem = (OrderEntryModel)prItemWebOrder.get(prItemId);
                BigDecimal price = new BigDecimal(webOrderItem.getPrice()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
                BigDecimal qty = new BigDecimal(webOrderItem.getQuantity()).setScale(2, RoundingMode.HALF_UP);
                entry.put("netBuyOfferId", (Object)quotationInfo.getBuyOfferId());
                entry.put("netQuotationItemId", (Object)String.valueOf(quoItem.getId()));
                entry.put("netOrderEntryId", (Object)webOrderItem.getId());
                entry.setQty(qty);
                taxRate = quoItem.getTaxRate();
                if (quoItem.isIncludeTax()) {
                    isInTax = true;
                    entry.setTaxPrice(price);
                    entry.setTaxRate(new BigDecimal(taxRate));
                    continue;
                }
                entry.setPrice(price);
            }
            order.setIsInTax(isInTax);
            order.setSupplier(supplierInfo);
            order.put("netOrderId", (Object)webOrderInfo.getId());
            order.setBoolean("isNetOrder", true);
            iPurOrder.handleAfterTransform("SAVE", (IObjectValue)order);
            iPurOrder.save((CoreBaseInfo)order);
            iPurOrder.saveRelations((CoreBillBaseInfo)order, transformResult.getBOTRelationCollection());
        }
        return ((PurOrderInfo)bills.getObject(0)).getId();
    }

    @Override
    protected void _addPaymentBillByOrder(Context ctx, String webOrderId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("netOrderId", (Object)webOrderId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(SCMSelectorFactory.getPurOrderSelector((boolean)true));
        PurOrderCollection orderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(viewInfo);
        if (orderCollection.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1000001", "\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u7f51\u7edc\u8ba2\u5355\u53f7\u4e3a\u3010" + webOrderId + "\u3011\u7684EAS\u8ba2\u5355"));
        }
        PurOrderInfo orderInfo = orderCollection.get(0);
        String botpName = "PO_AP001";
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("1000003", "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u8f6c\u6362\u89c4\u5219\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new EASBizException(new NumericExceptionSubItem("1000004", "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff0c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u672a\u542f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)orderInfo.getCompanyOrgUnit());
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add((CoreBillBaseInfo)orderInfo);
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botMappingInfo);
        IObjectCollection bills = transformResult.getBills();
        OtherBillInfo otherBillInfo = (OtherBillInfo)bills.getObject(0);
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance((Context)ctx);
        iOtherBill.handleAfterTransform("SAVE", (IObjectValue)otherBillInfo);
        iOtherBill.save((CoreBaseInfo)otherBillInfo);
        SCMServerUtils.traceUpAndDown((Context)ctx, (String)orderInfo.getId().toString(), (String)otherBillInfo.getId().toString(), (String)orderInfo.getBOSType().toString(), (String)otherBillInfo.getBOSType().toString());
        ObjectUuidPK iOtherBillPk = new ObjectUuidPK(otherBillInfo.getId());
        iOtherBill.submit((CoreBaseInfo)otherBillInfo);
        iOtherBill.audit((IObjectPK)iOtherBillPk);
        botpName = "AP004";
        botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("1000003", "\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u8f6c\u6362\u89c4\u5219\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new EASBizException(new NumericExceptionSubItem("1000004", "\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25\uff0c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u672a\u542f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add((CoreBillBaseInfo)otherBillInfo);
        transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botMappingInfo);
        bills = transformResult.getBills();
        PaymentBillInfo paymentBillInfo = (PaymentBillInfo)bills.getObject(0);
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        iPaymentBill.handleAfterTransform("SAVE", (IObjectValue)paymentBillInfo);
        iPaymentBill.save((CoreBaseInfo)paymentBillInfo);
        SCMServerUtils.traceUpAndDown((Context)ctx, (String)otherBillInfo.getId().toString(), (String)paymentBillInfo.getId().toString(), (String)otherBillInfo.getBOSType().toString(), (String)paymentBillInfo.getBOSType().toString());
    }

    @Override
    protected void _confirmJDOrder(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        String id = InvServerUtils.getInStringFromArray((String[])ids);
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct t2.fJdOrderId from t_sm_purorder t1 inner join t_sm_purorderentry t2 on t1.fid = t2.fparentid ");
        sql.append(" where t1.fid in ").append(id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        String jdOrderID = null;
        JSONArray jsonArray = new JSONArray();
        try {
            while (rs.next()) {
                jdOrderID = rs.getString("fJdOrderId");
                if (StringUtils.isEmpty((String)jdOrderID)) continue;
                jsonArray.put((Object)jdOrderID);
            }
            if (jsonArray.length() == 0) {
                return;
            }
            params.put("jdOrderIds", jsonArray.toString());
            PurCloudServiceHelper.send(ctx, "00000000-0000-0000-0000-000000000000CCE7AED4", "jd.order.confirm", params);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    @Override
    protected String _getPurpOrderInfo(Context ctx, String jdOrderId) throws BOSException, EASBizException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderid", jdOrderId);
        UserInfo tempObj = (UserInfo)ctx.get((Object)"UserInfo");
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
        user.setNumber("user");
        user.setName("user");
        user.setType(UserType.PERSON);
        ctx.put((Object)"UserInfo", (Object)user);
        String retValue = PurCloudServiceHelper.send(ctx, "00000000-0000-0000-0000-000000000000CCE7AED4", "purp.getPURPOrderInfoByID", params);
        ctx.put((Object)"UserInfo", (Object)tempObj);
        return retValue;
    }

    @Override
    protected void _writeBackERPBillNumber(Context ctx, String purpBillID, String billNumber) throws BOSException, EASBizException {
        if (ctx.get((Object)"UserInfo") == null) {
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            user.setNumber("user");
            user.setName("user");
            ctx.put((Object)"UserInfo", (Object)user);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("purpBillID", purpBillID);
        params.put("billNumber", billNumber);
        PurCloudServiceHelper.send(ctx, "00000000-0000-0000-0000-000000000000CCE7AED4", "purp.writeBackERPBillNumber", params);
    }

    @Override
    protected void _confirmJdOrder(Context ctx, String jdOrderId) throws BOSException, EASBizException {
    }

    @Override
    protected QuotationInfo[] _getQuotationsByBuyOfferId(Context ctx, String buyOfferId, String companyId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected BOSUuid _addPurOrderByQuotation(Context ctx, QuotationInfo quotationInfo, String botpNumber, List entryidList) throws BOSException, EASBizException {
        QuotationItem item;
        if (quotationInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("1000001", "\u4e0b\u5355\u5931\u8d25\uff0c\u62a5\u4ef7\u5355\u4fe1\u606f\u4e3a\u7a7a"));
        }
        HashMap<String, QuotationItem> prItemId2PriceMap = new HashMap<String, QuotationItem>();
        ObjectCollection<QuotationItem> items = quotationInfo.getSupplyNoteItems();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            item = items.getItem(i);
            prItemId2PriceMap.put(item.getPrItemId(), item);
        }
        PurRequestEntryCollection purReqEntries = PurRequestEntryFactory.getLocalInstance((Context)ctx).getPurRequestEntryCollection(this.getEntityViewByEntryid(entryidList));
        if (purReqEntries == null || purReqEntries.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1000002", "\u4e0b\u5355\u5931\u8d25\uff0c\u672a\u53d6\u5230\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f"));
        }
        ArrayList<String> purReqIdList = new ArrayList<String>();
        ArrayList<String> purReqentryList = new ArrayList<String>();
        PurRequestEntryInfo purReqEntry = null;
        for (int i = 0; i < purReqEntries.size(); ++i) {
            purReqEntry = purReqEntries.get(i);
            if (!purReqIdList.contains(purReqEntry.getParent().getId().toString())) {
                purReqIdList.add(purReqEntry.getParent().getId().toString());
            }
            purReqentryList.add(purReqEntry.getId().toString());
        }
        if (botpNumber == null) {
            throw new EASBizException(new NumericExceptionSubItem("1000007", "\u4e0b\u5355\u5931\u8d25\uff0c\u6ca1\u6709\u914d\u7f6e\u7533\u8bf7\u5355\u5230\u8ba2\u5355\u7684BOTP\u8f6c\u6362\u89c4\u5219\u53c2\u6570"));
        }
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpNumber + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("1000003", "\u4e0b\u5355\u5931\u8d25\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u8f6c\u6362\u89c4\u5219\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new EASBizException(new NumericExceptionSubItem("1000004", "\u4e0b\u5355\u5931\u8d25\uff0c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u672a\u542f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        SelectorItemCollection botpSelectors = SCMSelectorFactory.getPurRequestSelector((boolean)true);
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(purReqIdList.toArray(new String[0]), new String[]{"entries"}, purReqentryList, botpSelectors, "3171BFAD", (IObjectPK)new ObjectUuidPK(botMappingInfo.getId()), "25428F2E");
        IObjectCollection bills = transformResult.getBills();
        if (bills.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("1000000", "\u4e0b\u5355\u5931\u8d25\uff0cbotp\u8f6c\u6362\u540e\u8ba2\u5355\u6570\u636e\u4f4d\u7a7a"));
        }
        String easSupplierId = SupplierHandlerUtil.getSupplierIDByMemberID(ctx, quotationInfo.getSupplierMemberId());
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setId(BOSUuid.read((String)easSupplierId));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"726f145b-0107-1000-e000-0227c0a81235676394A1", CompareType.EQUALS));
        view.setFilter(filter);
        ExpenseTypeInfo expenseTypeInfo = new ExpenseTypeInfo();
        ExpenseTypeCollection expenseTypecol = ExpenseTypeFactory.getLocalInstance((Context)ctx).getExpenseTypeCollection(view);
        if (expenseTypecol != null && expenseTypecol.size() > 0) {
            expenseTypeInfo = expenseTypecol.get(0);
        } else {
            expenseTypeInfo.setId(BOSUuid.read((String)"726f145b-0107-1000-e000-0227c0a81235676394A1"));
        }
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
        String taxRate = null;
        int size2 = bills.size();
        for (int i = 0; i < size2; ++i) {
            PurOrderEntryInfo entry;
            PurOrderInfo order = (PurOrderInfo)bills.getObject(i);
            PurOrderEntryCollection entrys = order.getEntries();
            boolean isInTax = false;
            int len = entrys.size();
            for (int j = 0; j < len; ++j) {
                entry = entrys.get(j);
                String prItemId = entry.getSourceBillEntryId();
                BigDecimal price = BigDecimal.ZERO;
                item = (QuotationItem)prItemId2PriceMap.get(prItemId);
                if (item != null && item.getPrice() != null) {
                    price = new BigDecimal(item.getPrice()).divide(BIGDECIMAL_100, 2, RoundingMode.HALF_UP);
                }
                BigDecimal qty = new BigDecimal(item.getAmount()).setScale(6, RoundingMode.HALF_UP);
                taxRate = item.getTaxRate();
                if (item.isIncludeTax()) {
                    isInTax = true;
                    entry.setTaxPrice(price);
                    entry.setTaxRate(new BigDecimal(taxRate));
                } else {
                    entry.setPrice(price);
                }
                entry.setQty(qty);
                entry.put("netBuyOfferId", (Object)quotationInfo.getBuyOfferId());
                entry.put("netQuotationItemId", (Object)String.valueOf(item.getId()));
                entry.put("netQuotationId", (Object)String.valueOf(quotationInfo.getId()));
            }
            BigDecimal freight = BigDecimal.ZERO;
            if (quotationInfo != null && entrys.size() > 0 && BigDecimal.ZERO.compareTo(freight = new BigDecimal(quotationInfo.getFreight()).divide(BIGDECIMAL_100, 2, RoundingMode.HALF_UP)) < 0) {
                entry = entrys.get(0);
                PurOrderExpenseEntryInfo expenseInfo = new PurOrderExpenseEntryInfo();
                expenseInfo.setExpenseAmount(freight);
                expenseInfo.setCurrency(order.getCurrency());
                expenseInfo.setExchangeRate(order.getExchangeRate());
                expenseInfo.setTaxRate(entry.getTaxRate());
                expenseInfo.setTax(entry.getTaxRate().multiply(freight).setScale(2));
                expenseInfo.setUnitExpense(freight.divide(entry.getQty(), 2, RoundingMode.HALF_UP));
                expenseInfo.setPurOrderEntry(entry);
                expenseInfo.setExpenseItem(expenseTypeInfo);
                entry.getEntries().add(expenseInfo);
            }
            order.setIsInTax(isInTax);
            order.setSupplier(supplierInfo);
            order.setBoolean("isNetOrder", true);
            iPurOrder.handleAfterTransform("SAVE", (IObjectValue)order);
            iPurOrder.save((CoreBaseInfo)order);
            iPurOrder.saveRelations((CoreBillBaseInfo)order, transformResult.getBOTRelationCollection());
        }
        return ((PurOrderInfo)bills.getObject(0)).getId();
    }

    private EntityViewInfo getEntityViewByEntryid(List entryids) {
        HashSet entryidSet = new HashSet();
        int size = entryids.size();
        for (int i = 0; i < size; ++i) {
            entryidSet.add(entryids.get(i));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", entryidSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.id");
        sic.add("parent.companyOrgUnit");
        sic.add("parent.baseStatus");
        sic.add("id");
        sic.add("purchaseOrgUnit");
        sic.add(new SelectorItemInfo("netBuyOfferItemId"));
        viewInfo.setSelector(sic);
        return viewInfo;
    }
}

