/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierMapTypeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SupplierHandlerUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.b2b.app.SupplierHandlerUtil");

    public static List<String> getMappingSupplierListByID(Context ctx, List<String> idList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder ids = new StringBuilder();
        if (idList != null) {
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append("'").append(idList.get(i)).append("'");
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FSupplierID FROM T_BD_SupplierMappingAli WHERE FSupplierMemberId IS NOT NULL ").append("\n");
        if (ids.length() > 0) {
            sql.append(" AND FSupplierID IN (").append((CharSequence)ids).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs != null && rs.next()) {
                list.add(rs.getString("FSupplierID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    public static Map<String, String> getMappingSupplierMap(Context ctx, List<String> idList) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder ids = new StringBuilder();
        if (idList != null) {
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append("'").append(idList.get(i)).append("'");
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FSupplierID,FSupplierMemberId FROM T_BD_SupplierMappingAli WHERE FSupplierMemberId IS NOT NULL ").append("\n");
        if (ids.length() > 0) {
            sql.append(" AND FSupplierID IN (").append((CharSequence)ids).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs != null && rs.next()) {
                result.put(rs.getString("FSupplierID"), rs.getString("FSupplierMemberId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static String getMappingSupplierMemberID(Context ctx, String supplerId) throws BOSException, EASBizException {
        String result = null;
        if (supplerId == null || supplerId.length() == 0) {
            return result;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FSupplierMemberId FROM T_BD_SupplierMappingAli WHERE FSupplierID = '").append(supplerId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                result = rs.getString("FSupplierMemberId");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static String getSupplierIDByMemberID(Context ctx, String supplerMemberId) throws BOSException, EASBizException {
        String result = null;
        if (supplerMemberId == null || supplerMemberId.length() == 0) {
            return result;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FSupplierID FROM T_BD_SupplierMappingAli WHERE FSupplierMemberId =  '").append(supplerMemberId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                result = rs.getString("FSupplierId");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static Map<String, String> getMappingSupplierByMemberID(Context ctx, List<String> memberIdList) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder ids = new StringBuilder();
        if (memberIdList != null) {
            int size = memberIdList.size();
            for (int i = 0; i < size; ++i) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append("'").append(memberIdList.get(i)).append("'");
                map.put(memberIdList.get(i), "");
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FSupplierID,FSupplierMemberId FROM T_BD_SupplierMappingAli WHERE 1=1 ").append("\n");
        if (ids.length() > 0) {
            sql.append(" AND FSupplierMemberId IN (").append((CharSequence)ids).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs != null && rs.next()) {
                map.put(rs.getString("FSupplierMemberId"), rs.getString("FSupplierID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("SupplierHandlerUtil.getMappingSupplierByMemberID " + (t2 - t1) + "ms"));
        return map;
    }

    public static boolean hasMapped(Context ctx, String supplierMemberId) throws BOSException {
        if (supplierMemberId == null || "".equals(supplierMemberId)) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FSupplierID FROM T_BD_SupplierMappingAli ").append("\n");
        sql.append(" WHERE FSupplierMemberId = '").append(supplierMemberId).append("'").append("\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String supplierid = "";
        try {
            if (rs != null && rs.next() && (supplierid = rs.getString("FSupplierID")) != null && supplierid.trim().length() > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static SupplierMapTypeEnum hasMapping(Context ctx, String supplierMemberId) throws BOSException {
        if (StringUtils.isEmpty((String)supplierMemberId)) {
            return SupplierMapTypeEnum.SUPPLIER_NOTMAPPING;
        }
        long t1 = System.currentTimeMillis();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FSupplierID FROM T_BD_SupplierMappingAli ").append("\n");
        sql.append(" WHERE FSupplierMemberId = '").append(supplierMemberId).append("'").append("\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String supplierid = "";
        try {
            if (rs != null && rs.next() && (supplierid = rs.getString("FSupplierID")) != null && supplierid.trim().length() > 0) {
                return SupplierMapTypeEnum.SUPPLIER_MAPPING;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("SupplierHandlerUtil.hasMapping " + (t2 - t1) + "ms"));
        return SupplierMapTypeEnum.SUPPLIER_NOTMAPPING;
    }

    public static boolean dealWithMapping(Context ctx, String supplierMemberId, String supplierId) throws BOSException {
        if (StringUtils.isEmpty((String)supplierMemberId) || StringUtils.isEmpty((String)supplierId) || !SupplierHandlerUtil.isExistSupplierId(ctx, supplierId)) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO T_BD_SupplierMappingAli(FID,FSUPPLIERID,FSUPPLIERMEMBERID) VALUES(newbosid('12345678'),'" + supplierId + "', '" + supplierMemberId + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return true;
    }

    private static boolean isExistSupplierId(Context ctx, String supplierId) throws BOSException {
        String sql = "select count(1) as ct from t_bd_supplier where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{supplierId});
        try {
            if (rs.next()) {
                return rs.getInt("ct") > 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static SupplierMapTypeEnum hasSupplierCompanyInfo(Context ctx, IObjectPK supplierPK, IObjectPK companyPK) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("usingStatus"));
        SupplierCompanyInfoInfo supCompanyInfo = iSupplier.getCompanyInfo(supplierPK, companyPK, selector);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("SupplierHandlerUtil.hasSupplierCompanyInfo " + (t2 - t1) + "ms"));
        if (supCompanyInfo == null) {
            return SupplierMapTypeEnum.SUPPLIER_NOCOMPANYDATA;
        }
        if (UsingStatusEnum.FREEZED.equals((Object)supCompanyInfo.getUsingStatus())) {
            return SupplierMapTypeEnum.SUPPLIER_COMPANYDATANOAUDIT;
        }
        return SupplierMapTypeEnum.SUPPLIER_COMPANYDATACOMPLETE;
    }

    public static SupplierMapTypeEnum hasSupplierPurchaseInfo(Context ctx, IObjectPK supplierPK, IObjectPK purchaseOrgPK) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        ISupplierPurchaseInfo iSupPurchase = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("usingStatus"));
        SupplierPurchaseInfoInfo supPurchaseInfo = iSupPurchase.getPurChaseInfo(supplierPK, purchaseOrgPK, selector);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("SupplierHandlerUtil.hasSupplierCompanyInfo " + (t2 - t1) + "ms"));
        if (supPurchaseInfo == null) {
            return SupplierMapTypeEnum.SUPPLIER_NOPURCHASEDATA;
        }
        if (UsingStatusEnum.FREEZED.equals((Object)supPurchaseInfo.getUsingStatus())) {
            return SupplierMapTypeEnum.SUPPLIER_PURCHASEDATANOAUDIT;
        }
        return SupplierMapTypeEnum.SUPPLIER_PURCHASEDATACOMPLETE;
    }

    public static CSSPGroupStandardInfo getGroupStandardInfo(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("isBasic", (Object)1);
        filter.appendFilterItem("type", (Object)2);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        view.setFilter(filter);
        CSSPGroupStandardCollection col = CSSPGroupStandardFactory.getLocalInstance((Context)ctx).getCSSPGroupStandardCollection(view);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    public static CSSPGroupInfo getCSSPGroupInfo(Context ctx, CSSPGroupStandardInfo stdInfo) throws BOSException, EASBizException {
        CSSPGroupInfo groupInfo = null;
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("CU.id", (Object)cu.getId().toString());
        filter.appendFilterItem("groupStandard.id", (Object)stdInfo.getId().toString());
        filter.appendFilterItem("number", (Object)"NetSupplier");
        view.setFilter(filter);
        CSSPGroupCollection col = CSSPGroupFactory.getLocalInstance((Context)ctx).getCSSPGroupCollection(view);
        if (col != null && col.size() > 0) {
            groupInfo = col.get(0);
        } else {
            groupInfo = new CSSPGroupInfo();
            groupInfo.setCU(cu);
            groupInfo.setName("NetSupplier");
            groupInfo.setNumber("NetSupplier");
            groupInfo.setIsLeaf(true);
            groupInfo.setLevel(1);
            groupInfo.setLongNumber("NetSupplier");
            groupInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            groupInfo.setGroupStandard(stdInfo);
            groupInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            groupInfo.setCreateTime(TimeStampUtility.getTime());
            CSSPGroupFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)groupInfo);
        }
        return groupInfo;
    }

    public static SupplierGroupDetailInfo getSupplierGroupDetailInfo(CSSPGroupStandardInfo stdInfo, CSSPGroupInfo groupInfo) {
        SupplierGroupDetailInfo detailInfo = new SupplierGroupDetailInfo();
        detailInfo.setSupplierGroupStandard(stdInfo);
        detailInfo.setSupplierGroupFullName(groupInfo.getName());
        detailInfo.setSupplierGroup(groupInfo);
        return detailInfo;
    }

    public static KAClassficationInfo getDefaultAccountClass(Context ctx, String type, String comID, String accountTableId) throws BOSException {
        String typeID = "";
        if (comID == null) {
            comID = "";
        }
        if (accountTableId == null) {
            accountTableId = "";
        }
        if (type.equals("customer")) {
            typeID = "7ac99937-00fb-2000-e000-0002c0a81345B999CA39";
        } else if (type.equals("supplier")) {
            typeID = "7ac99937-00fb-3000-e000-0002c0a81345B999CA39";
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typelink.objectType.id", (Object)typeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("currencyCompany.id", (Object)comID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableId.id", (Object)accountTableId, CompareType.EQUALS));
        StringBuffer sql = new StringBuffer(100);
        sql.append("select min(k.fnumber) from t_bd_kaclassfication k inner join t_bd_kaclassficationtype kt on k.ftypelink=kt.fid where ");
        sql.append(" kt.fobjecttypeid='").append(typeID).append("'");
        sql.append(" and k.fcurrencycompany='").append(comID).append("'");
        sql.append(" and k.faccounttableid='").append(accountTableId).append("'");
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)sql.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        evi.setFilter(filterInfo);
        KAClassficationInfo kaClassficationInfo = null;
        KAClassficationCollection collection = KAClassficationFactory.getLocalInstance((Context)ctx).getKAClassficationCollection(evi);
        if (collection.size() > 0) {
            kaClassficationInfo = collection.get(0);
        }
        return kaClassficationInfo;
    }
}

