/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.info;

import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerCancelBuyofferMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerCloseOrderMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerModifyBuyofferMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerOrderMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerPaySuccessMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerPublishBuyofferMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerTradeSuccessMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.MsgTypeEnum;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.SupplierCancelQuotationMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.SupplierCooperateionMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.SupplierQuotationMsg;
import com.kingdee.messageCenter.Message;
import java.util.HashMap;
import java.util.Map;

public abstract class MessageInfo {
    public static final String MSG_GMTBORN = "gmtBorn";
    public static final String MSG_USERINFO = "userInfo";
    public static final String MSG_TYPE = "type";
    public static final String MSG_DATA = "data";
    private String id;
    private long gmtBorn;
    private String companyId;
    private MsgTypeEnum type;
    private Map<String, String> data = new HashMap<String, String>();

    public long getGmtBorn() {
        return this.gmtBorn;
    }

    public void setGmtBorn(long gmtBorn) {
        this.gmtBorn = gmtBorn;
    }

    public MsgTypeEnum getType() {
        return this.type;
    }

    public void setType(MsgTypeEnum type) {
        this.type = type;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public static MessageInfo parse(String jsonStr) throws JSONException {
        JSONObject json = new JSONObject(jsonStr);
        return MessageInfo.parse(json);
    }

    public static MessageInfo parse(JSONObject json) throws JSONException {
        MsgTypeEnum msgType = MsgTypeEnum.getMsgTypeEnum(json.getString(MSG_TYPE));
        MessageInfo info = MessageInfo.getMsgInfoByType(msgType);
        if (null == info) {
            return null;
        }
        info.setCompanyId(json.getString("companyId"));
        info.setGmtBorn(json.getLong(MSG_GMTBORN));
        info.initData(json.getJSONObject(MSG_DATA));
        return info;
    }

    public static MessageInfo getMsgInfoByType(MsgTypeEnum msgType) {
        if (MsgTypeEnum.BUYER_PUBLISH_BUYOFFER.equals((Object)msgType)) {
            return new BuyerPublishBuyofferMsg();
        }
        if (MsgTypeEnum.BUYER_MODIFY_BUYOFFER.equals((Object)msgType)) {
            return new BuyerModifyBuyofferMsg();
        }
        if (MsgTypeEnum.BUYER_CANCEL_BUYOFFER.equals((Object)msgType)) {
            return new BuyerCancelBuyofferMsg();
        }
        if (MsgTypeEnum.SUPPLIER_CANCEL_QUOTATION.equals((Object)msgType)) {
            return new SupplierCancelQuotationMsg();
        }
        if (MsgTypeEnum.SUPPLIER_QUOTATION.equals((Object)msgType)) {
            return new SupplierQuotationMsg();
        }
        if (MsgTypeEnum.CREATE_COOPERATEION.equals((Object)msgType)) {
            return new SupplierCooperateionMsg();
        }
        if (MsgTypeEnum.BUYER_ORDERED.equals((Object)msgType)) {
            return new BuyerOrderMsg();
        }
        if (MsgTypeEnum.BUYER_PAYED_SUCCEED.equals((Object)msgType)) {
            return new BuyerPaySuccessMsg();
        }
        if (MsgTypeEnum.BUYER_TRADE_SUCCED.equals((Object)msgType)) {
            return new BuyerTradeSuccessMsg();
        }
        if (MsgTypeEnum.BUYER_CLOSE_ORDER.equals((Object)msgType)) {
            return new BuyerCloseOrderMsg();
        }
        return null;
    }

    public abstract void initData(JSONObject var1) throws JSONException;

    public void copyMessage(Message m) {
        this.setId(m.getId());
        this.setGmtBorn(m.getLastUpdatetime().getTime());
        this.setCompanyId(m.getField("companyId"));
        this.data = m.getBody();
    }

    public String toJsonString() {
        JSONObject json = new JSONObject((Object)this);
        return json.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

